/* vi:set ts=8 sts=0 sw=8:
 * $Id: debug.h,v 1.1 2000/07/15 20:02:46 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __DEBUG_H__
#define __DEBUG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <stdio.h>
#include <config.h>

#ifdef ENABLE_DEBUG

extern int dbg_flags;

#define DBG_ADVOPTS	0x00000001
#define DBG_FILE	0x00000002
#define DBG_MAIN	0x00000004
#define DBG_MISC	0x00000008
#define DBG_WIN		0x00000010
#define DBG_PREFS	0x00000020
#define DBG_SEARCH	0x00000040

#define DBG_PRINTF(options, s)	\
	if (dbg_flags & (options))	\
		printf s;

#define APPDBG_ALWAYS(s)	printf s;
#define APPDBG_ADVOPTS(s)	DBG_PRINTF(DBG_ADVOPTS,  s);
#define APPDBG_FILE(s)		DBG_PRINTF(DBG_FILE,     s);
#define APPDBG_MAIN(s)		DBG_PRINTF(DBG_MAIN,    s);
#define APPDBG_MISC(s)		DBG_PRINTF(DBG_MISC, s);
#define APPDBG_WIN(s)		DBG_PRINTF(DBG_WIN,  s);
#define APPDBG_PREFS(s)		DBG_PRINTF(DBG_PREFS,  s);
#define APPDBG_SEARCH(s)	DBG_PRINTF(DBG_SEARCH,  s);

#else	/* NO DEBUG */

#define DBG_PRINTF(options, s)

#define APPDBG_ALWAYS(s)
#define APPDBG_ADVOPTS(s)
#define APPDBG_FILE(s)
#define APPDBG_MAIN(s)
#define APPDBG_MISC(s)
#define APPDBG_WIN(s)
#define APPDBG_PREFS(s)
#define APPDBG_SEARCH(s)

#endif	/* ENABLE_DEBUG */


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __DEBUG_H__ */
