/* EPGScanner.c generated by valac 0.16.0, the Vala compiler
 * generated from EPGScanner.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <cstuff.h>


#define DVB_TYPE_EPG_SCANNER (dvb_epg_scanner_get_type ())
#define DVB_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScanner))
#define DVB_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))
#define DVB_IS_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EPG_SCANNER))
#define DVB_IS_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EPG_SCANNER))
#define DVB_EPG_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))

typedef struct _DVBEPGScanner DVBEPGScanner;
typedef struct _DVBEPGScannerClass DVBEPGScannerClass;
typedef struct _DVBEPGScannerPrivate DVBEPGScannerPrivate;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define __g_queue_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_queue_free__g_object_unref0_ (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_FACTORY (dvb_factory_get_type ())
#define DVB_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_FACTORY, DVBFactory))
#define DVB_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_FACTORY, DVBFactoryClass))
#define DVB_IS_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_FACTORY))
#define DVB_IS_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_FACTORY))
#define DVB_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_FACTORY, DVBFactoryClass))

typedef struct _DVBFactory DVBFactory;
typedef struct _DVBFactoryClass DVBFactoryClass;

#define DVB_TYPE_SETTINGS (dvb_settings_get_type ())
#define DVB_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SETTINGS, DVBSettings))
#define DVB_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SETTINGS, DVBSettingsClass))
#define DVB_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SETTINGS))
#define DVB_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SETTINGS))
#define DVB_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SETTINGS, DVBSettingsClass))

typedef struct _DVBSettings DVBSettings;
typedef struct _DVBSettingsClass DVBSettingsClass;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_SCHEDULE (dvb_schedule_get_type ())
#define DVB_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCHEDULE, DVBSchedule))
#define DVB_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCHEDULE, DVBScheduleClass))
#define DVB_IS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCHEDULE))
#define DVB_IS_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCHEDULE))
#define DVB_SCHEDULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCHEDULE, DVBScheduleClass))

typedef struct _DVBSchedule DVBSchedule;
typedef struct _DVBScheduleClass DVBScheduleClass;
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;
#define _dvb_event_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_unref (var), NULL)))

struct _DVBEPGScanner {
	GObject parent_instance;
	DVBEPGScannerPrivate * priv;
};

struct _DVBEPGScannerClass {
	GObjectClass parent_class;
};

struct _DVBEPGScannerPrivate {
	DVBDeviceGroup* DeviceGroup;
	GstElement* pipeline;
	GStaticRecMutex __lock_pipeline;
	GQueue* channels;
	GSource* scan_source;
	GSource* queue_source;
	gint stop_counter;
	GMainContext* context;
	GMainLoop* loop;
	GThread* worker_thread;
	guint bus_watch_id;
	GeeHashMap* channel_events;
	GStaticRecMutex __lock_channel_events;
};

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	gchar* name;
	gchar* description;
	gchar* extended_description;
	GSList* audio_components;
	GSList* video_components;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};


static gpointer dvb_epg_scanner_parent_class = NULL;
static DVBLoggingLogger* dvb_epg_scanner_log;
static DVBLoggingLogger* dvb_epg_scanner_log = NULL;
static gint dvb_epg_scanner_CHECK_EIT_INTERVAL;
static gint dvb_epg_scanner_CHECK_EIT_INTERVAL = 0;

GType dvb_epg_scanner_get_type (void) G_GNUC_CONST;
GType dvb_device_group_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
#define DVB_EPG_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_EPG_SCANNER, DVBEPGScannerPrivate))
enum  {
	DVB_EPG_SCANNER_DUMMY_PROPERTY
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
static void _g_object_unref0_ (gpointer var);
static void _g_queue_free__g_object_unref0_ (GQueue* self);
#define DVB_EPG_SCANNER_WAIT_FOR_EIT_DURATION 10
#define DVB_EPG_SCANNER_PIPELINE_TEMPLATE "dvbsrc name=dvbsrc adapter=%u frontend=%u pids=0:16:17:18 stats-report" \
"ing-interval=0 ! mpegtsparse ! fakesink silent=true"
DVBEPGScanner* dvb_epg_scanner_new (DVBDeviceGroup* device);
DVBEPGScanner* dvb_epg_scanner_construct (GType object_type, DVBDeviceGroup* device);
DVBFactory* dvb_factory_new (void);
DVBFactory* dvb_factory_construct (GType object_type);
GType dvb_factory_get_type (void) G_GNUC_CONST;
GType dvb_settings_get_type (void) G_GNUC_CONST;
DVBSettings* dvb_factory_get_settings (DVBFactory* self);
gint dvb_settings_get_epg_scan_interval (DVBSettings* self);
void dvb_epg_scanner_stop (DVBEPGScanner* self);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
static void dvb_epg_scanner_remove_timeouts (DVBEPGScanner* self);
static void dvb_epg_scanner_reset (DVBEPGScanner* self);
static void* dvb_epg_scanner_worker (DVBEPGScanner* self);
static gboolean dvb_epg_scanner_setup_pipeline (DVBEPGScanner* self);
GType dvb_device_get_type (void) G_GNUC_CONST;
DVBDevice* dvb_device_group_get_next_free_device (DVBDeviceGroup* self);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
static gboolean dvb_epg_scanner_bus_watch_func (DVBEPGScanner* self, GstBus* bus, GstMessage* message);
static gboolean _dvb_epg_scanner_bus_watch_func_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
static void dvb_epg_scanner_reset_pipeline (DVBEPGScanner* self);
gboolean dvb_epg_scanner_start (DVBEPGScanner* self);
static gpointer _dvb_epg_scanner_worker_gthread_func (gpointer self);
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
static gboolean dvb_epg_scanner_scan_new_frequency (DVBEPGScanner* self);
static gboolean _dvb_epg_scanner_scan_new_frequency_gsource_func (gpointer self);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
const gchar* dvb_channel_get_Name (DVBChannel* self);
GType dvb_schedule_get_type (void) G_GNUC_CONST;
DVBSchedule* dvb_channel_get_Schedule (DVBChannel* self);
void dvb_schedule_add_all (DVBSchedule* self, GeeCollection* new_events);
static gboolean _dvb_epg_scanner_start_gsource_func (gpointer self);
void dvb_schedule_remove_expired_events (DVBSchedule* self);
void dvb_channel_setup_dvb_source (DVBChannel* self, GstElement* source);
void dvb_logging_logger_warning (DVBLoggingLogger* self, const gchar* format, ...);
void dvb_epg_scanner_on_eit_structure (DVBEPGScanner* self, const GstStructure* structure);
static guint dvb_epg_scanner_get_uint_val (const GstStructure* structure, const gchar* name);
guint dvb_event_hash (DVBEvent* event);
static guint _dvb_event_hash_ghash_func (gconstpointer key);
gboolean dvb_event_equal (DVBEvent* event1, DVBEvent* event2);
static gboolean _dvb_event_equal_gequal_func (gconstpointer a, gconstpointer b);
DVBEvent* dvb_event_new (void);
DVBEvent* dvb_event_construct (GType object_type);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void) G_GNUC_CONST;
gboolean dvb_event_has_expired (DVBEvent* self);
static GObject * dvb_epg_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_epg_scanner_finalize (GObject* obj);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_queue_free__g_object_unref0_ (GQueue* self) {
	g_queue_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_queue_free (self);
}


/**
         * @device: The device where EPG should be collected from
         */
DVBEPGScanner* dvb_epg_scanner_construct (GType object_type, DVBDeviceGroup* device) {
	DVBEPGScanner * self = NULL;
	DVBDeviceGroup* _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (device != NULL, NULL);
	self = (DVBEPGScanner*) g_object_new (object_type, NULL);
	_tmp0_ = device;
	self->priv->DeviceGroup = _tmp0_;
	_tmp1_ = dvb_epg_scanner_CHECK_EIT_INTERVAL;
	if (_tmp1_ == (-1)) {
		DVBFactory* _tmp2_;
		DVBFactory* _tmp3_;
		DVBSettings* _tmp4_ = NULL;
		DVBSettings* _tmp5_;
		DVBSettings* settings;
		DVBSettings* _tmp6_;
		gint _tmp7_ = 0;
		_tmp2_ = dvb_factory_new ();
		_tmp3_ = _tmp2_;
		_tmp4_ = dvb_factory_get_settings (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		settings = _tmp5_;
		_tmp6_ = settings;
		_tmp7_ = dvb_settings_get_epg_scan_interval (_tmp6_);
		dvb_epg_scanner_CHECK_EIT_INTERVAL = _tmp7_;
		_g_object_unref0 (settings);
	}
	return self;
}


DVBEPGScanner* dvb_epg_scanner_new (DVBDeviceGroup* device) {
	return dvb_epg_scanner_construct (DVB_TYPE_EPG_SCANNER, device);
}


/**
         * Stop collecting EPG data
         */
void dvb_epg_scanner_stop (DVBEPGScanner* self) {
	DVBLoggingLogger* _tmp0_;
	DVBDeviceGroup* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = dvb_epg_scanner_log;
	_tmp1_ = self->priv->DeviceGroup;
	_tmp2_ = dvb_device_group_get_Id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->stop_counter;
	dvb_logging_logger_debug (_tmp0_, "EPGScanner.vala:75: Stopping EPG scan for group %u (%d)", _tmp3_, _tmp4_);
	_tmp5_ = self->priv->stop_counter;
	if (_tmp5_ == 0) {
		dvb_epg_scanner_remove_timeouts (self);
		dvb_epg_scanner_reset (self);
	}
	_tmp6_ = self->priv->stop_counter;
	self->priv->stop_counter = _tmp6_ + 1;
}


static void dvb_epg_scanner_remove_timeouts (DVBEPGScanner* self) {
	GSource* _tmp0_;
	GSource* _tmp2_;
	GMainLoop* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scan_source;
	if (_tmp0_ != NULL) {
		GSource* _tmp1_;
		_tmp1_ = self->priv->scan_source;
		g_source_destroy (_tmp1_);
		_g_source_unref0 (self->priv->scan_source);
		self->priv->scan_source = NULL;
	}
	_tmp2_ = self->priv->queue_source;
	if (_tmp2_ != NULL) {
		GSource* _tmp3_;
		_tmp3_ = self->priv->queue_source;
		g_source_destroy (_tmp3_);
		_g_source_unref0 (self->priv->queue_source);
		self->priv->queue_source = NULL;
	}
	_tmp4_ = self->priv->loop;
	if (_tmp4_ != NULL) {
		GMainLoop* _tmp5_;
		GThread* _tmp6_;
		_tmp5_ = self->priv->loop;
		g_main_loop_quit (_tmp5_);
		_g_main_loop_unref0 (self->priv->loop);
		self->priv->loop = NULL;
		_tmp6_ = self->priv->worker_thread;
		g_thread_join (_tmp6_);
		_g_thread_unref0 (self->priv->worker_thread);
		self->priv->worker_thread = NULL;
	}
}


static void* dvb_epg_scanner_worker (DVBEPGScanner* self) {
	void* result = NULL;
	GMainLoop* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->loop;
	g_main_loop_run (_tmp0_);
	result = NULL;
	return result;
}


static gboolean _dvb_epg_scanner_bus_watch_func_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = dvb_epg_scanner_bus_watch_func (self, bus, message);
	return result;
}


static gboolean dvb_epg_scanner_setup_pipeline (DVBEPGScanner* self) {
	gboolean result = FALSE;
	DVBDeviceGroup* _tmp0_;
	DVBDevice* _tmp1_ = NULL;
	DVBDevice* device;
	DVBDevice* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->DeviceGroup;
	_tmp1_ = dvb_device_group_get_next_free_device (_tmp0_);
	device = _tmp1_;
	_tmp2_ = device;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (device);
		return result;
	}
	{
		GstElement* _tmp3_;
		_tmp3_ = self->priv->pipeline;
		g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
		{
			GstElement* _tmp20_;
			GstBus* _tmp21_ = NULL;
			GstBus* bus;
			GstBus* _tmp22_;
			GMainContext* _tmp23_;
			guint _tmp24_ = 0U;
			{
				DVBDevice* _tmp4_;
				guint _tmp5_;
				guint _tmp6_;
				DVBDevice* _tmp7_;
				guint _tmp8_;
				guint _tmp9_;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				GstElement* _tmp12_ = NULL;
				GstElement* _tmp13_;
				GstElement* _tmp14_;
				_tmp4_ = device;
				_tmp5_ = dvb_device_get_Adapter (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = device;
				_tmp8_ = dvb_device_get_Frontend (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strdup_printf (DVB_EPG_SCANNER_PIPELINE_TEMPLATE, _tmp6_, _tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = gst_parse_launch (_tmp11_, &_inner_error_);
				_tmp13_ = _tmp12_;
				_g_free0 (_tmp11_);
				_tmp14_ = _tmp13_;
				if (_inner_error_ != NULL) {
					goto __catch61_g_error;
				}
				_gst_object_unref0 (self->priv->pipeline);
				self->priv->pipeline = _tmp14_;
			}
			goto __finally61;
			__catch61_g_error:
			{
				GError* e = NULL;
				DVBLoggingLogger* _tmp15_;
				GError* _tmp16_;
				const gchar* _tmp17_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp15_ = dvb_epg_scanner_log;
				_tmp16_ = e;
				_tmp17_ = _tmp16_->message;
				dvb_logging_logger_error (_tmp15_, "EPGScanner.vala:118: Could not create pipeline: %s", _tmp17_);
				result = FALSE;
				_g_error_free0 (e);
				{
					GstElement* _tmp18_;
					_tmp18_ = self->priv->pipeline;
					g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
				}
				_g_object_unref0 (device);
				return result;
			}
			__finally61:
			if (_inner_error_ != NULL) {
				{
					GstElement* _tmp19_;
					_tmp19_ = self->priv->pipeline;
					g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
				}
				_g_object_unref0 (device);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_tmp20_ = self->priv->pipeline;
			_tmp21_ = gst_element_get_bus (_tmp20_);
			bus = _tmp21_;
			_tmp22_ = bus;
			_tmp23_ = self->priv->context;
			_tmp24_ = gst_bus_add_watch_context (_tmp22_, _dvb_epg_scanner_bus_watch_func_gst_bus_func, self, _tmp23_);
			self->priv->bus_watch_id = _tmp24_;
			_gst_object_unref0 (bus);
		}
		__finally60:
		{
			GstElement* _tmp25_;
			_tmp25_ = self->priv->pipeline;
			g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (device);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_g_object_unref0 (device);
	return result;
}


static gpointer _g_source_ref0 (gpointer self) {
	return self ? g_source_ref (self) : NULL;
}


static void dvb_epg_scanner_reset_pipeline (DVBEPGScanner* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GstElement* _tmp0_;
		_tmp0_ = self->priv->pipeline;
		g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
		{
			GstElement* _tmp1_;
			_tmp1_ = self->priv->pipeline;
			if (_tmp1_ != NULL) {
				GMainContext* _tmp2_;
				guint _tmp3_;
				GSource* _tmp4_ = NULL;
				GSource* _tmp5_;
				GSource* bus_watch_source;
				GSource* _tmp6_;
				GstElement* _tmp8_;
				GstElement* _tmp9_;
				_tmp2_ = self->priv->context;
				_tmp3_ = self->priv->bus_watch_id;
				_tmp4_ = g_main_context_find_source_by_id (_tmp2_, _tmp3_);
				_tmp5_ = _g_source_ref0 (_tmp4_);
				bus_watch_source = _tmp5_;
				_tmp6_ = bus_watch_source;
				if (_tmp6_ != NULL) {
					GSource* _tmp7_;
					_tmp7_ = bus_watch_source;
					g_source_destroy (_tmp7_);
					self->priv->bus_watch_id = (guint) 0;
				}
				_tmp8_ = self->priv->pipeline;
				gst_element_set_state (_tmp8_, GST_STATE_NULL);
				_tmp9_ = self->priv->pipeline;
				gst_element_get_state (_tmp9_, NULL, NULL, (GstClockTime) (-1));
				_gst_object_unref0 (self->priv->pipeline);
				self->priv->pipeline = NULL;
				_g_source_unref0 (bus_watch_source);
			}
		}
		__finally62:
		{
			GstElement* _tmp10_;
			_tmp10_ = self->priv->pipeline;
			g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void dvb_epg_scanner_reset (DVBEPGScanner* self) {
	DVBChannel* c = NULL;
	GQueue* _tmp3_;
	GeeHashMap* _tmp4_;
	g_return_if_fail (self != NULL);
	dvb_epg_scanner_reset_pipeline (self);
	while (TRUE) {
		GQueue* _tmp0_;
		gpointer _tmp1_ = NULL;
		DVBChannel* _tmp2_;
		_tmp0_ = self->priv->channels;
		_tmp1_ = g_queue_pop_head (_tmp0_);
		_g_object_unref0 (c);
		c = (DVBChannel*) _tmp1_;
		_tmp2_ = c;
		if (!(_tmp2_ != NULL)) {
			break;
		}
	}
	_tmp3_ = self->priv->channels;
	g_queue_clear (_tmp3_);
	_tmp4_ = self->priv->channel_events;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp4_);
	_g_object_unref0 (c);
}


/**
         * Start collection EPG data for all channels
         */
static gpointer _dvb_epg_scanner_worker_gthread_func (gpointer self) {
	gpointer result;
	result = dvb_epg_scanner_worker (self);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _dvb_epg_scanner_scan_new_frequency_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_epg_scanner_scan_new_frequency (self);
	return result;
}


gboolean dvb_epg_scanner_start (DVBEPGScanner* self) {
	gboolean result = FALSE;
	DVBLoggingLogger* _tmp0_;
	DVBDeviceGroup* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gint _tmp4_;
	GMainContext* _tmp5_;
	GMainLoop* _tmp6_;
	gint _tmp12_;
	gint _tmp13_;
	gboolean _tmp25_ = FALSE;
	GSource* _tmp26_;
	GSource* _tmp27_;
	GSource* _tmp28_;
	GMainContext* _tmp29_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = dvb_epg_scanner_log;
	_tmp1_ = self->priv->DeviceGroup;
	_tmp2_ = dvb_device_group_get_Id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->stop_counter;
	dvb_logging_logger_debug (_tmp0_, "EPGScanner.vala:161: Starting EPG scan for group %u (%d)", _tmp3_, _tmp4_);
	_tmp5_ = self->priv->context;
	_tmp6_ = g_main_loop_new (_tmp5_, FALSE);
	_g_main_loop_unref0 (self->priv->loop);
	self->priv->loop = _tmp6_;
	{
		GThread* _tmp7_;
		GThread* _tmp8_;
		_tmp7_ = g_thread_try_new ("EPG-Worker-Thread", _dvb_epg_scanner_worker_gthread_func, self, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			goto __catch63_g_error;
		}
		_g_thread_unref0 (self->priv->worker_thread);
		self->priv->worker_thread = _tmp8_;
	}
	goto __finally63;
	__catch63_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = dvb_epg_scanner_log;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		dvb_logging_logger_error (_tmp9_, "EPGScanner.vala:167: Could not create thread: %s", _tmp11_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally63:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp12_ = self->priv->stop_counter;
	self->priv->stop_counter = _tmp12_ - 1;
	_tmp13_ = self->priv->stop_counter;
	if (_tmp13_ > 0) {
		result = FALSE;
		return result;
	}
	self->priv->stop_counter = 0;
	{
		DVBDeviceGroup* _tmp14_;
		DVBChannelList* _tmp15_;
		DVBChannelList* _tmp16_;
		GeeIterator* _tmp17_ = NULL;
		GeeIterator* _c_it;
		_tmp14_ = self->priv->DeviceGroup;
		_tmp15_ = dvb_device_group_get_Channels (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
		_c_it = _tmp17_;
		while (TRUE) {
			GeeIterator* _tmp18_;
			gboolean _tmp19_ = FALSE;
			GeeIterator* _tmp20_;
			gpointer _tmp21_ = NULL;
			DVBChannel* c;
			GQueue* _tmp22_;
			DVBChannel* _tmp23_;
			DVBChannel* _tmp24_;
			_tmp18_ = _c_it;
			_tmp19_ = gee_iterator_next (_tmp18_);
			if (!_tmp19_) {
				break;
			}
			_tmp20_ = _c_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			c = (DVBChannel*) _tmp21_;
			_tmp22_ = self->priv->channels;
			_tmp23_ = c;
			_tmp24_ = _g_object_ref0 (_tmp23_);
			g_queue_push_tail (_tmp22_, _tmp24_);
			_g_object_unref0 (c);
		}
		_g_object_unref0 (_c_it);
	}
	_tmp25_ = dvb_epg_scanner_setup_pipeline (self);
	if (!_tmp25_) {
		result = FALSE;
		return result;
	}
	_tmp26_ = g_timeout_source_new_seconds ((guint) DVB_EPG_SCANNER_WAIT_FOR_EIT_DURATION);
	_g_source_unref0 (self->priv->scan_source);
	self->priv->scan_source = _tmp26_;
	_tmp27_ = self->priv->scan_source;
	g_source_set_callback (_tmp27_, _dvb_epg_scanner_scan_new_frequency_gsource_func, g_object_ref (self), g_object_unref);
	_tmp28_ = self->priv->scan_source;
	_tmp29_ = self->priv->context;
	g_source_attach (_tmp28_, _tmp29_);
	result = FALSE;
	return result;
}


/**
         * Scan the next frequency for EPG data
         */
static gboolean _dvb_epg_scanner_start_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_epg_scanner_start (self);
	return result;
}


static gboolean dvb_epg_scanner_scan_new_frequency (DVBEPGScanner* self) {
	gboolean result = FALSE;
	GQueue* _tmp35_;
	gboolean _tmp36_ = FALSE;
	GQueue* _tmp46_;
	gpointer _tmp47_ = NULL;
	DVBChannel* channel;
	DVBChannel* _tmp48_;
	DVBSchedule* _tmp49_;
	DVBSchedule* _tmp50_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->channel_events;
		g_static_rec_mutex_lock (&self->priv->__lock_channel_events);
		{
			GeeHashMap* _tmp33_;
			{
				GeeHashMap* _tmp1_;
				GeeSet* _tmp2_;
				GeeSet* _tmp3_;
				GeeSet* _tmp4_;
				GeeIterator* _tmp5_ = NULL;
				GeeIterator* _tmp6_;
				GeeIterator* _sid_it;
				_tmp1_ = self->priv->channel_events;
				_tmp2_ = gee_abstract_map_get_keys ((GeeMap*) _tmp1_);
				_tmp3_ = _tmp2_;
				_tmp4_ = _tmp3_;
				_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
				_tmp6_ = _tmp5_;
				_g_object_unref0 (_tmp4_);
				_sid_it = _tmp6_;
				while (TRUE) {
					GeeIterator* _tmp7_;
					gboolean _tmp8_ = FALSE;
					GeeIterator* _tmp9_;
					gpointer _tmp10_ = NULL;
					guint sid;
					DVBDeviceGroup* _tmp11_;
					DVBChannelList* _tmp12_;
					DVBChannelList* _tmp13_;
					guint _tmp14_;
					DVBChannel* _tmp15_ = NULL;
					DVBChannel* channel;
					DVBChannel* _tmp16_;
					GeeHashMap* _tmp18_;
					guint _tmp19_;
					gpointer _tmp20_ = NULL;
					GeeHashSet* list;
					DVBLoggingLogger* _tmp21_;
					GeeHashSet* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					DVBChannel* _tmp25_;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					guint _tmp28_;
					DVBChannel* _tmp29_;
					DVBSchedule* _tmp30_;
					DVBSchedule* _tmp31_;
					GeeHashSet* _tmp32_;
					_tmp7_ = _sid_it;
					_tmp8_ = gee_iterator_next (_tmp7_);
					if (!_tmp8_) {
						break;
					}
					_tmp9_ = _sid_it;
					_tmp10_ = gee_iterator_get (_tmp9_);
					sid = GPOINTER_TO_UINT (_tmp10_);
					_tmp11_ = self->priv->DeviceGroup;
					_tmp12_ = dvb_device_group_get_Channels (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = sid;
					_tmp15_ = dvb_channel_list_get_channel (_tmp13_, _tmp14_);
					channel = _tmp15_;
					_tmp16_ = channel;
					if (_tmp16_ == NULL) {
						guint _tmp17_;
						_tmp17_ = sid;
						g_warning ("EPGScanner.vala:196: Could not find channel %u for this device", _tmp17_);
						_g_object_unref0 (channel);
						continue;
					}
					_tmp18_ = self->priv->channel_events;
					_tmp19_ = sid;
					_tmp20_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp18_, GUINT_TO_POINTER (_tmp19_));
					list = (GeeHashSet*) _tmp20_;
					_tmp21_ = dvb_epg_scanner_log;
					_tmp22_ = list;
					_tmp23_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = channel;
					_tmp26_ = dvb_channel_get_Name (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = sid;
					dvb_logging_logger_debug (_tmp21_, "EPGScanner.vala:201: Adding %d events of channel %s (%u)", _tmp24_, _tmp27_, _tmp28_);
					_tmp29_ = channel;
					_tmp30_ = dvb_channel_get_Schedule (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = list;
					dvb_schedule_add_all (_tmp31_, (GeeCollection*) _tmp32_);
					_g_object_unref0 (list);
					_g_object_unref0 (channel);
				}
				_g_object_unref0 (_sid_it);
			}
			_tmp33_ = self->priv->channel_events;
			gee_abstract_map_clear ((GeeAbstractMap*) _tmp33_);
		}
		__finally64:
		{
			GeeHashMap* _tmp34_;
			_tmp34_ = self->priv->channel_events;
			g_static_rec_mutex_unlock (&self->priv->__lock_channel_events);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp35_ = self->priv->channels;
	_tmp36_ = g_queue_is_empty (_tmp35_);
	if (_tmp36_) {
		DVBLoggingLogger* _tmp37_;
		DVBDeviceGroup* _tmp38_;
		guint _tmp39_;
		guint _tmp40_;
		gint _tmp41_;
		GSource* _tmp42_;
		GSource* _tmp43_;
		GSource* _tmp44_;
		GMainContext* _tmp45_;
		_tmp37_ = dvb_epg_scanner_log;
		_tmp38_ = self->priv->DeviceGroup;
		_tmp39_ = dvb_device_group_get_Id (_tmp38_);
		_tmp40_ = _tmp39_;
		dvb_logging_logger_debug (_tmp37_, "EPGScanner.vala:209: Finished EPG scan for group %u", _tmp40_);
		dvb_epg_scanner_reset (self);
		_tmp41_ = dvb_epg_scanner_CHECK_EIT_INTERVAL;
		_tmp42_ = g_timeout_source_new_seconds ((guint) _tmp41_);
		_g_source_unref0 (self->priv->queue_source);
		self->priv->queue_source = _tmp42_;
		_tmp43_ = self->priv->queue_source;
		g_source_set_callback (_tmp43_, _dvb_epg_scanner_start_gsource_func, g_object_ref (self), g_object_unref);
		_tmp44_ = self->priv->queue_source;
		_tmp45_ = self->priv->context;
		g_source_attach (_tmp44_, _tmp45_);
		result = FALSE;
		return result;
	}
	_tmp46_ = self->priv->channels;
	_tmp47_ = g_queue_pop_head (_tmp46_);
	channel = (DVBChannel*) _tmp47_;
	_tmp48_ = channel;
	_tmp49_ = dvb_channel_get_Schedule (_tmp48_);
	_tmp50_ = _tmp49_;
	dvb_schedule_remove_expired_events (_tmp50_);
	{
		GstElement* _tmp51_;
		_tmp51_ = self->priv->pipeline;
		g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
		{
			GstElement* _tmp52_;
			GstElement* _tmp53_;
			GstElement* _tmp54_ = NULL;
			GstElement* dvbsrc;
			DVBChannel* _tmp55_;
			GstElement* _tmp56_;
			GstElement* _tmp57_;
			_tmp52_ = self->priv->pipeline;
			gst_element_set_state (_tmp52_, GST_STATE_READY);
			_tmp53_ = self->priv->pipeline;
			_tmp54_ = gst_bin_get_by_name (GST_BIN (_tmp53_), "dvbsrc");
			dvbsrc = _tmp54_;
			_tmp55_ = channel;
			_tmp56_ = dvbsrc;
			dvb_channel_setup_dvb_source (_tmp55_, _tmp56_);
			_tmp57_ = self->priv->pipeline;
			gst_element_set_state (_tmp57_, GST_STATE_PLAYING);
			_gst_object_unref0 (dvbsrc);
		}
		__finally65:
		{
			GstElement* _tmp58_;
			_tmp58_ = self->priv->pipeline;
			g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_g_object_unref0 (channel);
	return result;
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


static gboolean dvb_epg_scanner_bus_watch_func (DVBEPGScanner* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	GstMessage* _tmp0_;
	GstMessageType _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = message;
	_tmp1_ = _tmp0_->type;
	switch (_tmp1_) {
		case GST_MESSAGE_ELEMENT:
		{
			GstMessage* _tmp2_;
			const GstStructure* _tmp3_ = NULL;
			GstStructure* _tmp4_;
			GstStructure* structure;
			const GstStructure* _tmp5_;
			const gchar* _tmp6_ = NULL;
			_tmp2_ = message;
			_tmp3_ = gst_message_get_structure (_tmp2_);
			_tmp4_ = _gst_structure_copy0 (_tmp3_);
			structure = _tmp4_;
			_tmp5_ = structure;
			_tmp6_ = gst_structure_get_name (_tmp5_);
			if (g_strcmp0 (_tmp6_, "dvb-read-failure") == 0) {
				DVBLoggingLogger* _tmp7_;
				_tmp7_ = dvb_epg_scanner_log;
				dvb_logging_logger_warning (_tmp7_, "EPGScanner.vala:241: Could not read from DVB device");
			} else {
				const GstStructure* _tmp8_;
				const gchar* _tmp9_ = NULL;
				_tmp8_ = structure;
				_tmp9_ = gst_structure_get_name (_tmp8_);
				if (g_strcmp0 (_tmp9_, "eit") == 0) {
					const GstStructure* _tmp10_;
					_tmp10_ = structure;
					dvb_epg_scanner_on_eit_structure (self, _tmp10_);
				}
			}
			_gst_structure_free0 (structure);
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			GError* gerror = NULL;
			gchar* debug = NULL;
			GstMessage* _tmp11_;
			GError* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			DVBLoggingLogger* _tmp14_;
			GError* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gboolean _tmp18_ = FALSE;
			_tmp11_ = message;
			gst_message_parse_error (_tmp11_, &_tmp12_, &_tmp13_);
			_g_error_free0 (gerror);
			gerror = _tmp12_;
			_g_free0 (debug);
			debug = _tmp13_;
			_tmp14_ = dvb_epg_scanner_log;
			_tmp15_ = gerror;
			_tmp16_ = _tmp15_->message;
			_tmp17_ = debug;
			dvb_logging_logger_error (_tmp14_, "EPGScanner.vala:251: %s %s", _tmp16_, _tmp17_);
			dvb_epg_scanner_reset_pipeline (self);
			_tmp18_ = dvb_epg_scanner_setup_pipeline (self);
			if (_tmp18_) {
				result = TRUE;
				_g_free0 (debug);
				_g_error_free0 (gerror);
				return result;
			} else {
				dvb_epg_scanner_reset (self);
				result = FALSE;
				_g_free0 (debug);
				_g_error_free0 (gerror);
				return result;
			}
			_g_free0 (debug);
			_g_error_free0 (gerror);
		}
		default:
		{
			break;
		}
	}
	result = TRUE;
	return result;
}


static guint _dvb_event_hash_ghash_func (gconstpointer key) {
	guint result;
	result = dvb_event_hash (key);
	return result;
}


static gboolean _dvb_event_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = dvb_event_equal (a, b);
	return result;
}


void dvb_epg_scanner_on_eit_structure (DVBEPGScanner* self, const GstStructure* structure) {
	const GstStructure* _tmp0_;
	GValue* _tmp1_ = NULL;
	GValue events;
	GType _tmp2_ = 0UL;
	gboolean _tmp3_ = FALSE;
	guint _tmp4_ = 0U;
	guint size;
	GValue val = {0};
	const GstStructure* event = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	_tmp0_ = structure;
	_tmp1_ = gst_structure_get_value (_tmp0_, "events");
	events = *_tmp1_;
	_tmp2_ = gst_value_list_get_type ();
	_tmp3_ = G_VALUE_HOLDS (&events, _tmp2_);
	if (!_tmp3_) {
		return;
	}
	_tmp4_ = gst_value_list_get_size (&events);
	size = _tmp4_;
	{
		GeeHashMap* _tmp5_;
		_tmp5_ = self->priv->channel_events;
		g_static_rec_mutex_lock (&self->priv->__lock_channel_events);
		{
			const GstStructure* _tmp6_;
			guint _tmp7_ = 0U;
			guint sid;
			GeeHashMap* _tmp8_;
			guint _tmp9_;
			gboolean _tmp10_ = FALSE;
			GeeHashMap* _tmp15_;
			guint _tmp16_;
			gpointer _tmp17_ = NULL;
			GeeHashSet* list;
			_tmp6_ = structure;
			_tmp7_ = dvb_epg_scanner_get_uint_val (_tmp6_, "service-id");
			sid = _tmp7_;
			_tmp8_ = self->priv->channel_events;
			_tmp9_ = sid;
			_tmp10_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp8_, GUINT_TO_POINTER (_tmp9_));
			if (!_tmp10_) {
				GeeHashMap* _tmp11_;
				guint _tmp12_;
				GeeHashSet* _tmp13_;
				GeeHashSet* _tmp14_;
				_tmp11_ = self->priv->channel_events;
				_tmp12_ = sid;
				_tmp13_ = gee_hash_set_new (DVB_TYPE_EVENT, (GBoxedCopyFunc) dvb_event_ref, dvb_event_unref, _dvb_event_hash_ghash_func, _dvb_event_equal_gequal_func);
				_tmp14_ = _tmp13_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, GUINT_TO_POINTER (_tmp12_), _tmp14_);
				_g_object_unref0 (_tmp14_);
			}
			_tmp15_ = self->priv->channel_events;
			_tmp16_ = sid;
			_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, GUINT_TO_POINTER (_tmp16_));
			list = (GeeHashSet*) _tmp17_;
			{
				guint i;
				i = (guint) 0;
				{
					gboolean _tmp18_;
					_tmp18_ = TRUE;
					while (TRUE) {
						gboolean _tmp19_;
						guint _tmp21_;
						guint _tmp22_;
						guint _tmp23_;
						GValue* _tmp24_ = NULL;
						const GstStructure* _tmp25_ = NULL;
						DVBEvent* _tmp26_;
						DVBEvent* event_class;
						DVBEvent* _tmp27_;
						const GstStructure* _tmp28_;
						guint _tmp29_ = 0U;
						DVBEvent* _tmp30_;
						const GstStructure* _tmp31_;
						guint _tmp32_ = 0U;
						DVBEvent* _tmp33_;
						const GstStructure* _tmp34_;
						guint _tmp35_ = 0U;
						DVBEvent* _tmp36_;
						const GstStructure* _tmp37_;
						guint _tmp38_ = 0U;
						DVBEvent* _tmp39_;
						const GstStructure* _tmp40_;
						guint _tmp41_ = 0U;
						DVBEvent* _tmp42_;
						const GstStructure* _tmp43_;
						guint _tmp44_ = 0U;
						DVBEvent* _tmp45_;
						const GstStructure* _tmp46_;
						guint _tmp47_ = 0U;
						DVBEvent* _tmp48_;
						const GstStructure* _tmp49_;
						guint _tmp50_ = 0U;
						DVBEvent* _tmp51_;
						gboolean _tmp52_ = FALSE;
						DVBEvent* _tmp53_;
						const GstStructure* _tmp54_;
						guint _tmp55_ = 0U;
						const GstStructure* _tmp56_;
						const gchar* _tmp57_ = NULL;
						gchar* _tmp58_;
						gchar* name;
						gboolean _tmp59_ = FALSE;
						const gchar* _tmp60_;
						gboolean _tmp63_;
						const GstStructure* _tmp67_;
						const gchar* _tmp68_ = NULL;
						gchar* _tmp69_;
						gchar* desc;
						gboolean _tmp70_ = FALSE;
						const gchar* _tmp71_;
						gboolean _tmp74_;
						const GstStructure* _tmp78_;
						const gchar* _tmp79_ = NULL;
						gchar* _tmp80_;
						gchar* ext_desc;
						gboolean _tmp81_ = FALSE;
						const gchar* _tmp82_;
						gboolean _tmp85_;
						gboolean free_ca = FALSE;
						const GstStructure* _tmp89_;
						gboolean _tmp90_ = FALSE;
						DVBEvent* _tmp91_;
						gboolean _tmp92_;
						GeeHashSet* _tmp93_;
						DVBEvent* _tmp94_;
						_tmp19_ = _tmp18_;
						if (!_tmp19_) {
							guint _tmp20_;
							_tmp20_ = i;
							i = _tmp20_ + 1;
						}
						_tmp18_ = FALSE;
						_tmp21_ = i;
						_tmp22_ = size;
						if (!(_tmp21_ < _tmp22_)) {
							break;
						}
						_tmp23_ = i;
						_tmp24_ = gst_value_list_get_value (&events, _tmp23_);
						val = *_tmp24_;
						_tmp25_ = gst_value_get_structure (&val);
						event = _tmp25_;
						_tmp26_ = dvb_event_new ();
						event_class = _tmp26_;
						_tmp27_ = event_class;
						_tmp28_ = event;
						_tmp29_ = dvb_epg_scanner_get_uint_val (_tmp28_, "event-id");
						_tmp27_->id = _tmp29_;
						_tmp30_ = event_class;
						_tmp31_ = event;
						_tmp32_ = dvb_epg_scanner_get_uint_val (_tmp31_, "year");
						_tmp30_->year = _tmp32_;
						_tmp33_ = event_class;
						_tmp34_ = event;
						_tmp35_ = dvb_epg_scanner_get_uint_val (_tmp34_, "month");
						_tmp33_->month = _tmp35_;
						_tmp36_ = event_class;
						_tmp37_ = event;
						_tmp38_ = dvb_epg_scanner_get_uint_val (_tmp37_, "day");
						_tmp36_->day = _tmp38_;
						_tmp39_ = event_class;
						_tmp40_ = event;
						_tmp41_ = dvb_epg_scanner_get_uint_val (_tmp40_, "hour");
						_tmp39_->hour = _tmp41_;
						_tmp42_ = event_class;
						_tmp43_ = event;
						_tmp44_ = dvb_epg_scanner_get_uint_val (_tmp43_, "minute");
						_tmp42_->minute = _tmp44_;
						_tmp45_ = event_class;
						_tmp46_ = event;
						_tmp47_ = dvb_epg_scanner_get_uint_val (_tmp46_, "second");
						_tmp45_->second = _tmp47_;
						_tmp48_ = event_class;
						_tmp49_ = event;
						_tmp50_ = dvb_epg_scanner_get_uint_val (_tmp49_, "duration");
						_tmp48_->duration = _tmp50_;
						_tmp51_ = event_class;
						_tmp52_ = dvb_event_has_expired (_tmp51_);
						if (_tmp52_) {
							_dvb_event_unref0 (event_class);
							continue;
						}
						_tmp53_ = event_class;
						_tmp54_ = event;
						_tmp55_ = dvb_epg_scanner_get_uint_val (_tmp54_, "running-status");
						_tmp53_->running_status = _tmp55_;
						_tmp56_ = event;
						_tmp57_ = gst_structure_get_string (_tmp56_, "name");
						_tmp58_ = g_strdup (_tmp57_);
						name = _tmp58_;
						_tmp60_ = name;
						if (_tmp60_ != NULL) {
							const gchar* _tmp61_;
							gboolean _tmp62_ = FALSE;
							_tmp61_ = name;
							_tmp62_ = g_utf8_validate (_tmp61_, (gssize) (-1), NULL);
							_tmp59_ = _tmp62_;
						} else {
							_tmp59_ = FALSE;
						}
						_tmp63_ = _tmp59_;
						if (_tmp63_) {
							DVBEvent* _tmp64_;
							const gchar* _tmp65_;
							gchar* _tmp66_;
							_tmp64_ = event_class;
							_tmp65_ = name;
							_tmp66_ = g_strdup (_tmp65_);
							_g_free0 (_tmp64_->name);
							_tmp64_->name = _tmp66_;
						}
						_tmp67_ = event;
						_tmp68_ = gst_structure_get_string (_tmp67_, "description");
						_tmp69_ = g_strdup (_tmp68_);
						desc = _tmp69_;
						_tmp71_ = desc;
						if (_tmp71_ != NULL) {
							const gchar* _tmp72_;
							gboolean _tmp73_ = FALSE;
							_tmp72_ = desc;
							_tmp73_ = g_utf8_validate (_tmp72_, (gssize) (-1), NULL);
							_tmp70_ = _tmp73_;
						} else {
							_tmp70_ = FALSE;
						}
						_tmp74_ = _tmp70_;
						if (_tmp74_) {
							DVBEvent* _tmp75_;
							const gchar* _tmp76_;
							gchar* _tmp77_;
							_tmp75_ = event_class;
							_tmp76_ = desc;
							_tmp77_ = g_strdup (_tmp76_);
							_g_free0 (_tmp75_->description);
							_tmp75_->description = _tmp77_;
						}
						_tmp78_ = event;
						_tmp79_ = gst_structure_get_string (_tmp78_, "extended-text");
						_tmp80_ = g_strdup (_tmp79_);
						ext_desc = _tmp80_;
						_tmp82_ = ext_desc;
						if (_tmp82_ != NULL) {
							const gchar* _tmp83_;
							gboolean _tmp84_ = FALSE;
							_tmp83_ = ext_desc;
							_tmp84_ = g_utf8_validate (_tmp83_, (gssize) (-1), NULL);
							_tmp81_ = _tmp84_;
						} else {
							_tmp81_ = FALSE;
						}
						_tmp85_ = _tmp81_;
						if (_tmp85_) {
							DVBEvent* _tmp86_;
							const gchar* _tmp87_;
							gchar* _tmp88_;
							_tmp86_ = event_class;
							_tmp87_ = ext_desc;
							_tmp88_ = g_strdup (_tmp87_);
							_g_free0 (_tmp86_->extended_description);
							_tmp86_->extended_description = _tmp88_;
						}
						_tmp89_ = event;
						gst_structure_get_boolean (_tmp89_, "free-ca-mode", &_tmp90_);
						free_ca = _tmp90_;
						_tmp91_ = event_class;
						_tmp92_ = free_ca;
						_tmp91_->free_ca_mode = _tmp92_;
						_tmp93_ = list;
						_tmp94_ = event_class;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp93_, _tmp94_);
						_g_free0 (ext_desc);
						_g_free0 (desc);
						_g_free0 (name);
						_dvb_event_unref0 (event_class);
					}
				}
			}
			_g_object_unref0 (list);
		}
		__finally66:
		{
			GeeHashMap* _tmp95_;
			_tmp95_ = self->priv->channel_events;
			g_static_rec_mutex_unlock (&self->priv->__lock_channel_events);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static guint dvb_epg_scanner_get_uint_val (const GstStructure* structure, const gchar* name) {
	guint result = 0U;
	guint val = 0U;
	const GstStructure* _tmp0_;
	const gchar* _tmp1_;
	guint _tmp2_ = 0U;
	g_return_val_if_fail (structure != NULL, 0U);
	g_return_val_if_fail (name != NULL, 0U);
	_tmp0_ = structure;
	_tmp1_ = name;
	gst_structure_get_uint (_tmp0_, _tmp1_, &_tmp2_);
	val = _tmp2_;
	result = val;
	return result;
}


static GObject * dvb_epg_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBEPGScanner * self;
	GQueue* _tmp0_;
	GMainContext* _tmp1_;
	GeeHashMap* _tmp2_;
	parent_class = G_OBJECT_CLASS (dvb_epg_scanner_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_EPG_SCANNER (obj);
	_tmp0_ = g_queue_new ();
	__g_queue_free__g_object_unref0_0 (self->priv->channels);
	self->priv->channels = _tmp0_;
	self->priv->stop_counter = 0;
	_tmp1_ = g_main_context_new ();
	_g_main_context_unref0 (self->priv->context);
	self->priv->context = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->channel_events);
	self->priv->channel_events = _tmp2_;
	return obj;
}


static void dvb_epg_scanner_class_init (DVBEPGScannerClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_epg_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBEPGScannerPrivate));
	G_OBJECT_CLASS (klass)->constructor = dvb_epg_scanner_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_epg_scanner_finalize;
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_epg_scanner_log = _tmp1_;
	dvb_epg_scanner_CHECK_EIT_INTERVAL = -1;
}


static void dvb_epg_scanner_instance_init (DVBEPGScanner * self) {
	self->priv = DVB_EPG_SCANNER_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_pipeline);
	g_static_rec_mutex_init (&self->priv->__lock_channel_events);
}


static void dvb_epg_scanner_finalize (GObject* obj) {
	DVBEPGScanner * self;
	self = DVB_EPG_SCANNER (obj);
	g_static_rec_mutex_free (&self->priv->__lock_pipeline);
	_gst_object_unref0 (self->priv->pipeline);
	__g_queue_free__g_object_unref0_0 (self->priv->channels);
	_g_source_unref0 (self->priv->scan_source);
	_g_source_unref0 (self->priv->queue_source);
	_g_main_context_unref0 (self->priv->context);
	_g_main_loop_unref0 (self->priv->loop);
	_g_thread_unref0 (self->priv->worker_thread);
	g_static_rec_mutex_free (&self->priv->__lock_channel_events);
	_g_object_unref0 (self->priv->channel_events);
	G_OBJECT_CLASS (dvb_epg_scanner_parent_class)->finalize (obj);
}


GType dvb_epg_scanner_get_type (void) {
	static volatile gsize dvb_epg_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_epg_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBEPGScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_epg_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEPGScanner), 0, (GInstanceInitFunc) dvb_epg_scanner_instance_init, NULL };
		GType dvb_epg_scanner_type_id;
		dvb_epg_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBEPGScanner", &g_define_type_info, 0);
		g_once_init_leave (&dvb_epg_scanner_type_id__volatile, dvb_epg_scanner_type_id);
	}
	return dvb_epg_scanner_type_id__volatile;
}



