/******************************************************************************\
 gnofin/dialog-about.c   $Revision: 1.8.2.2 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "common.h"
#include <libgnomeui/gnome-about.h>
#include "dialogs.h"

void
dialog_about (GtkWindow *parent)
{
  GtkWidget *dialog;
  const gchar *authors[] = { "Darin Fisher, Lead programmer.",
  			     "Luc Saillard, Numerous code contributions.",
  			     "Ryan Boren, CBB importing.",
  			     "Martin Fisher, Initial code for QIF importing.",
			     "Olivier Kaloudoff and Michel Piguel, French localization.",
                             "Jiri Vasina, Czech localization.",
                             "Daniel Lobato, Brazilian Portuguese localization.",
			     "Torsten Landschoff, Debian packager.",
			     NULL };

  trace ("");
  
  dialog = gnome_about_new (APPNAME,
  			    VERSION,
			    "(C) 1999-2000 Darin Fisher",
			    authors,
			    _("A personal finance application for GNOME.\n"
			      "http://gnofin.sourceforge.net/"),
			    NULL);

  gnome_dialog_set_parent (GNOME_DIALOG (dialog), parent);
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);

  gtk_widget_show (dialog);
}
