/******************************************************************************\
 gnofin/config-saver.c   $Revision: 1.2 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "common.h"
#include <libgnome/gnome-config.h>
#include "config-saver.h"

typedef struct {
  const gchar    *category;
  ConfigSaveFunc  func;
  gpointer        data;
} ConfigSaver;

static GSList *config_savers = NULL;

static gint
lookup_saver (const ConfigSaver *saver, const gchar *cat)
{
  return strcmp (saver->category, cat);
}

gboolean
config_saver_register (const gchar *cat, ConfigSaveFunc func, gpointer data)
{
  ConfigSaver *saver;
  GSList *node;

  trace ("");
  g_return_val_if_fail (cat, FALSE);
  g_return_val_if_fail (func, FALSE);

  node = g_slist_find_custom (config_savers, (gpointer) cat, (GCompareFunc) lookup_saver);
  if (node)
    return FALSE;

  saver = g_new (ConfigSaver, 1);
  saver->category = cat;
  saver->func = func;
  saver->data = data;
  config_savers = g_slist_prepend (config_savers, saver);

  return TRUE;
}

void
config_saver_unregister (const gchar *cat)
{
  GSList *node;

  trace ("");
  g_return_if_fail (cat);

  node = g_slist_find_custom (config_savers, (gpointer) cat, (GCompareFunc) lookup_saver);
  if (node)
    config_savers = g_slist_remove_link (config_savers, node);
}

void
config_save_all (void)
{
  ConfigSaver *saver;
  GSList *node;

  trace ("");
  
  for (node=config_savers; node; node=node->next)
  {
    saver = LIST_DEREF (ConfigSaver, node);
    saver->func (saver->data);
  }
  gnome_config_sync ();
}
