# Common settings for Ada Debian packaging.
#
#  Copyright (C) 2012-2021 Nicolas Boulenguez <nicolas@debian.org>
#
#  This program is free software: you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation, either version 3 of the
#  License, or (at your option) any later version.
#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#  General Public License for more details.
#  You should have received a copy of the GNU General Public License
#  along with this program. If not, see <http://www.gnu.org/licenses/>.

# Typical use:
#
# DEB_BUILD_MAINT_OPTIONS := hardening=+all
# DEB_LDFLAGS_MAINT_APPEND := -Wl,--no-undefined -Wl,--no-copy-dt-needed-entries -Wl,--no-allow-shlib-undefined
# DEB_ADAFLAGS_MAINT_APPEND := -gnatwa -Wall
# DPKG_EXPORT_BUILDFLAGS := 1
# include /usr/share/dpkg/buildflags.mk
# include /usr/share/dpkg/buildopts.mk
# include $(wildcard /usr/share/ada/debian_packaging.mk)
# # The wilcard is useful when Build-Depends-Indep does not contain gnat.

# We need both buildflags.mk and buildopts.mk.  Direct inclusion here
# may cause subtle problems with lazy evaluation in buildflags.mk if
# debian/rules also includes it later.
# Could become a simple include once they are protected against double
# inclusion (#872381).
ifneq (,$(filter-out $(MAKEFILE_LIST),/usr/share/dpkg/buildflags.mk \
                                      /usr/share/dpkg/buildopts.mk))
  $(error Please include /usr/share/dpkg/default.mk or the more specific \
          build{flags,opts}.mk before debian_packaging.mk))
endif

# Ada is not in dpkg-dev flag list. We add a sensible default here.

# Format checking is meaningless for Ada sources.
ADAFLAGS := $(filter-out -Wformat -Werror=format-security, $(CFLAGS))

ifdef DEB_ADAFLAGS_SET
  ADAFLAGS := $(DEB_ADAFLAGS_SET)
endif
ADAFLAGS := $(DEB_ADAFLAGS_PREPEND) \
            $(filter-out $(DEB_ADAFLAGS_STRIP),$(ADAFLAGS)) \
            $(DEB_ADAFLAGS_APPEND)

ifdef DEB_ADAFLAGS_MAINT_SET
  ADAFLAGS := $(DEB_ADAFLAGS_MAINT_SET)
endif
ADAFLAGS := $(DEB_ADAFLAGS_MAINT_PREPEND) \
            $(filter-out $(DEB_ADAFLAGS_MAINT_STRIP),$(ADAFLAGS)) \
            $(DEB_ADAFLAGS_MAINT_APPEND)

ifdef DPKG_EXPORT_BUILDFLAGS
  export ADAFLAGS
endif

######################################################################
# Options for gprbuild/gnatmake.

# Let Make delegate parallelism to gnatmake/gprbuild.
.NOTPARALLEL:

# Only set a -j option if explicitly requested by DEB_BUILD_OPTIONS
# (like Debhelper).
# Some GNAT projects, especially when driven by a Makefile, offer a
# parallelism configuration that interacts in obscure ways with -j.
# If so, set DEB_GPRBUILDFLAGS_NO_J before including this Makefile and
# use DEB_BUILD_OPTION_PARALLEL directly.

ifdef DEB_BUILD_OPTION_PARALLEL
  GNATMAKEFLAGS += -j$(DEB_BUILD_OPTION_PARALLEL)
  ifndef DEB_GPRBUILDFLAGS_NO_J
    GPRBUILDFLAGS += -j$(DEB_BUILD_OPTION_PARALLEL)
  endif
endif

GNATMAKEFLAGS += -R
GPRBUILDFLAGS += -R
# Avoid lintian warning about setting an explicit library runpath.
# http://wiki.debian.org/RpathIssue

ifeq (,$(filter terse,$(DEB_BUILD_OPTIONS)))
  GNATMAKEFLAGS += -v
  GPRBUILDFLAGS += -v
endif
# Make exact command lines available for automatic log checkers.

GNATMAKEFLAGS += -eS
# Tell gnatmake to echo commands to stdout instead of stderr, avoiding
# buildds thinking it is inactive and killing it.
# -eS is the default on gprbuild.

# Gprbuild generates -gnate[cm] switches with a counter, but
# parallelism makes the enumeration order unreproducible.
GPRBUILDFLAGS += -cargs:ada -gno-record-gcc-switches -gargs

# You may be interested in
# -s  recompile if compilation switches have changed
#     (bad default because of interactions between -amxs and standard library)
# -we handle warnings as errors
# -vP2 verbose when parsing projects.
