-----------------------------------------------------------------
--         Copyright (C) 2007, AdaCore                         --
-----------------------------------------------------------------
with Ada.Command_Line; use Ada.Command_Line;
with GNAT.IO;          use GNAT.IO;
with GNAT.Mmap;        use GNAT.Mmap;
with GNAT.OS_Lib;      use GNAT.OS_Lib;

procedure Test_Mmap is
   Filename : constant String := Argument (1);
   Mode : constant String := Argument (2);
   Mmap : constant String := Argument (3);
   File : Mapped_File;
   Str  : Str_Access;
   Offs : Long_Integer := 0;
   Page : Integer;
   Out_File : File_Descriptor;
   First : Integer;
begin
   File := Open_Read (Filename, Use_Mmap_If_Available => Mmap = "mmap");
   Out_File := Create_File ("mmap.out", Binary);
   if Mode = "full" then
      Read (File);
      Str := Data (File);
      Page := Write (Out_File, Str.all'Address, Last (File));

   else
      Page := Get_Page_Size;
      while Offs < Length (File) loop
         Read (File, Offs, Length => Long_Integer (Page) * 4);
         Str := Data (File);
         First := Integer (Offs - Offset (File) + 1);
         First := Write
           (Out_File, Str (First)'Address, Last (File) - First + 1);

         --  for S in Integer (Offs - Offset (File) + 1) .. Last (File) loop
         --     Put (Str (S));
         --  end loop;

         Offs := Offs + Long_Integer (Last (File));
      end loop;
   end if;

   Close (Out_File);
   Close (File);

end Test_Mmap;
