with Src_Info;
with Projects.Registry;
with Language_Handlers;
with VFS;

package Test_Utils is

   procedure Load_Project
     (Name : String;
      Handler      : access Language_Handlers.Language_Handler_Record'Class;
      Registry     : in out Projects.Registry.Project_Registry'Class;
      Project      : out Projects.Project_Type);
   --  Load a project file

   procedure Load_LI_File
     (Source_Info_List : in out Src_Info.LI_File_List;
      Handler          : Language_Handlers.Language_Handler;
      Registry         : in out Projects.Registry.Project_Registry'Class;
      Source_Filename  : VFS.Virtual_File;
      LI               : out Src_Info.LI_File_Ptr);
   --  Find, Load and Parse the LI file for the corresponding source
   --  file

   function Create_Lang_Handler
     (Registry : access Projects.Registry.Project_Registry'Class)
      return Language_Handlers.Language_Handler;
   --  Create a language handler

end Test_Utils;
