#include <sys/stat.h>
#include <sys/param.h>
#ifdef _WIN32
#include <windows.h>
#include <process.h>
#include "mingw32.h"
#endif

extern int __gnat_stat (char *, struct stat *);

int __gnat_copy_attribs (from, to, mode) {}

const int __gnat_vmsp = 0;

int __gnat_max_path_len = MAXPATHLEN;

/* char used as prefix/suffix for environment variables */
#if defined (_WIN32)
char __gnat_environment_char = '%';
#else
char __gnat_environment_char = '$';
#endif

int get_gcc_version () { return 2; }

void
__gnat_kill (int pid, int sig)
{ 
#if defined(_WIN32)
  HANDLE process_handle;
  
  if (sig == 9)
    { 
      process_handle = OpenProcess (PROCESS_TERMINATE, FALSE, pid);
      if (process_handle != NULL)
        TerminateProcess (process_handle, 0);
    }
#else
  kill (pid, sig);
#endif
}

int
__gnat_is_symbolic_link (char *name)
{
#if defined (_WIN32) || defined (VMS)
  return 0;
#else
  int ret;
  struct stat statbuf;

  ret = lstat (name, &statbuf);
  return (!ret && S_ISLNK (statbuf.st_mode));
#endif
}

int
__gnat_is_readable_file (char *name)
{ 
  int ret;
  int mode;
  struct stat statbuf;

  ret = __gnat_stat (name, &statbuf);
  mode = statbuf.st_mode & S_IRUSR;
  return (!ret && mode);
}

void
__gnat_set_readonly (char *name)
{
  struct stat statbuf;

  if (__gnat_stat (name, &statbuf) == 0)
  {
    statbuf.st_mode = statbuf.st_mode & 07577;
    chmod (name, statbuf.st_mode);
  }
}
