with Ada.Text_IO; use Ada.Text_IO;
with Ada.Strings.Unbounded; use Ada.Strings.Unbounded;

with GNU.DB.SQLite; use GNU.DB.SQLite;

procedure Demo
is
   Version : constant String := "$Id: demo.adb,v 1.4 2004/03/07 19:56:12 merdmann Exp $";

   function List
     (argc        : integer;
      argv        : Row_Array;
      columnNames : Row_Array)
      return integer is
   begin
      for I in argv'Range loop
         Put_Line(To_String(columnNames(I) & ": " & argv(I)));
      end loop;

      return 0;
   end List;


   db      : GNU.DB.Sqlite.Object;
   table   : Table_Controlled;
   errmsg  : Ustring;

begin
   Put_Line("Opening the file example.db");

   Open(db, "demo.db", READ_WRITE, errmsg);

   Put_Line("Create a table called DEMO with fields bla, ble and blo");

   Exec(db,
        "CREATE TABLE demo(bla INT, ble INT, blo INT);",
        errmsg);

   New_Line;
   Put_Line("Insert 10 rows with (100, 200, 300)");

   for I in 1..10 loop
      Exec(db,
           "INSERT INTO demo VALUES(100, 200, 300);",
           errmsg);
   end loop;

   New_Line;
   Put_Line("Select everything in table DEMO");

   New_Line;
   Put_Line("1: Using get_table");

   get_table(db,
        "SELECT * FROM demo;",
         table,
         errmsg);

   Put_Line("table has " & integer'Image(table.table'Last) & " rows");

   for I in table.Table'Range loop
      for J in table.Table(I)'Range loop
         Put(To_String(table.table(I)(J)));
         Put(" ");
      end loop;

      New_Line;
   end loop;

   New_Line;
   Put_Line("2: Using exec_with_callback");

   exec_with_callback(db,
      "SELECT * FROM demo;",
      List'Unrestricted_Access,
      errmsg);

   New_Line;
   Put_Line("Drop table DEMO");

   Exec(db,
        "DROP TABLE demo;",
        errmsg);

   Close(db);

exception
   -- too lazy to catch specific exceptions
   when others =>
      if errmsg /= Null_Unbounded_String then
         Put_Line(To_String(errmsg));
      end if;
end Demo;
