------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-gen_ocinumber.adb,v 1.5 2004/04/20 09:19:22 vagul Exp $

with OCI.Thread;

package body OCI.Thick.Gen_OCINumber is

   ---------------------
   -- Binary_Function --
   ---------------------

   function Binary_Function (Left, Right : OCINumber) return OCINumber is
      Result : aliased OCINumber;
      Rc : SWord := OCINumberOper (Thread.Error, Left, Right, Result'Access);
   begin
      Check_Error (Rc);

      return Result;
   end Binary_Function;

   --------------------
   -- Unary_Function --
   --------------------

   function Unary_Function (Item : OCINumber) return OCINumber is
      Result : aliased OCINumber;
      Rc     : SWord := OCINumberOper (Thread.Error, Item, Result'Access);
   begin
      Check_Error (Rc);

      return Result;
   end Unary_Function;

end OCI.Thick.Gen_OCINumber;
