-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/contents_handler.ads,v $
--  Description     : contents handler package                               --
--  Author          : Michael Erdmann                                        --
--  Created         : 8.8.2001                                               --
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/09/30 20:14:27 $
--  Status          : $State: Exp $
--                                                                           --
--  Copyright (C) 2000 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--  This package implements the so called contents handler. The contents     --
--  handler package maintains the table of contents for the application.     --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--                                                                           --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Strings.Unbounded;              use Ada.Strings.Unbounded;
with Project_File;                       use Project_File;

with GSQL_Types;                         use GSQL_Types;

package Contents_Handler is

   type Object is abstract tagged private;
   type Handle is access all Object'Class;

   -- set the key of a contents element
   procedure Key(
      This  : in out Object'Class;
      Value : in String );

   procedure Key(
      This  : in out Object'Class;
      Value : in Unbounded_String );

   function Key(
      This : in Object'Class ) return String;

   function Key(
      This : in Object'Class ) return Unbounded_String;

   function Self(
      This : in Object'Class ) return Handle;

   procedure Initialize(
      This : in out Object );

   procedure Finalize(
      This : in out Object );

   -- ********************************************************************* --
   -- **    A B S T R A C T   I N T E R F A C E   TO BE IMPLEMENTED      ** --
   -- ********************************************************************* --

   -- instance has been selected for processing
   procedure Selected(
      Item : in out Object  ) is abstract;

   -- return the contents of the instances which is written into the
   -- given text buffer.
   procedure Value(
      Item : in Object;
      Text : out Text_Buffer;
      Last : out Positive ) is abstract;

   -- save to persitent storage, this is called upon finalization of
   -- the object.
   procedure Save(
      Item  : in out Object;
      Value : in Text_Buffer;
      Name  : in String := "" ) is abstract;

   -- load the object data from a persitant storage. This is called
   -- upon initialization of the object, which means the procedure
   -- has to implement the situation, that the instance does not exist
   -- yet as well.
   procedure Load(
      Item  : in out Object;
      Value : out Text_Buffer;
      Last  : out Natural ) is abstract;

   -- Edit a selected object
   procedure Open_Editor(
      Item  : in out Object ) is abstract;

   -- the editor is closed
   procedure Close_Editor(
      Item  : in out Object ) is abstract;

   -- the execute button has been pressed, execute the contents of
   -- the instances.
   procedure Execute(
      Item  : in out Object ) is abstract;


private
   type Object is abstract tagged record
         Key  : Unbounded_String := Null_Unbounded_String;
         Self : Handle := null;
      end record;


end Contents_Handler;
