.TH PSCONTOUR l "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
pscontour \- Contour xyz-data by direct triangulation
.SH SYNOPSIS
\fBpscontour\fP \fIxyzfile\fP \fB\-C\fP\fIcptfile\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] 
[ \fB\-A\fP[\fB-\fP][\fIlabelinfo\fP] ] [ \fB\-B\fP[\fBp\fP|\fBs\fP]\fIparameters\fP ] [ \fB\-D\fP[\fIdumpfile\fP] ] [ \fB\-E\fP\fIview_az\fP/\fIview_el\fP ] 
[ \fB\-G\fP[\fBd\fP|\fBf\fP|\fBn\fP|\fBl\fP|\fBL\fP|\fBx\fP|\fBX\fP]\fIparams\fP ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-I\fP ] [ \fB\-K\fP ] 
[ \fB\-L\fP\fIpen\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-N\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-S\fP ] [ \fB\-T\fP\fIindexfile\fP ] [ \fB\-U\fP[/\fIdx\fP/\fIdy\fP/][\fIlabel\fP] ] 
[ \fB\-V\fP ] [ \fB\-W\fP[\fB+\fP]\fIpen\fP ] [ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIx-shift\fP[\fBu\fP]] ] 
[ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIy-shift\fP[\fBu\fP]] ] [ \fB\-c\fP\fIcopies\fP ] [ \fB\-:\fP[\fBi\fP|\fBo\fP] ] [ \fB\-b\fP[\fBi\fP|\fBo\fP][\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ]
.SH DESCRIPTION
\fBpscontour\fP reads an ASCII [or binary] xyz-file and produces a raw contour plot by triangulation.  By default, the
optimal Delaunay triangulation is performed (using either Shewchuk's [1996]\"'
or Watson's [1982] method as selected during \fBGMT\fP installation), but the user\"'
may optionally provide a second file with
network information, such as a triangular mesh used for finite element modeling.  In addition to contours, the area between contours may be painted according to
the color palette file.
.TP
\fIxyzfile\fP
Raw ASCII (or binary, see \fB\-b\fP) xyz data to be contoured.
.TP
.B \-C
name of the color palette file.  Must have discrete colors if you want to paint the
surface (\fB\-I\fP).  Only contours that have annotation flags set will be annotated.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the \fBMEASURE_UNIT\fP setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert)
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant)
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic)
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic)
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP][\fBr\fP|\fBz\fP] (Polar coordinates (theta,r))
.br
\fB\-Jx\fP\fIx-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP][\fI/y-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP]] (Linear, log, and power scaling)
.br
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-A
Give - to disable all annotations.
The optional \fIlabelinfo\fP controls the specifics of the label formatting and consists of a concatenated string
made up of any of the following control arguments:
.br
.RS
.TP
\fB+a\fP\fIangle\fP
For annotations at a fixed angle, \fB+an\fP for line-normal, or \fB+ap\fP for line-parallel [Default].
.TP
\fB+c\fP\fIdx\fP[/\fIdy\fP]
Sets the clearance between label and optional text box.  Append \fBc|i|m|p\fP to specify
the unit or % to indicate a percentage of the label font size [15%].
.TP
\fB+f\fP\fIfont\fP
Sets the desired font [Default \fBANNOT_FONT_PRIMARY\fP].
.TP
\fB+g\fP[\fIcolor\fP]
Selects opaque text boxes [Default is transparent]; optionally specify the color [Default is \fBPAGE_COLOR\fP].
.TP
\fB+j\fP\fIjust\fP
Sets label justification [Default is CM].
.TP
\fB+k\fP\fIcolor\fP
Sets color of text labels [Default is \fBCOLOR_BACKGROUND\fP].
.TP
\fB+l\fP\fIlabel\fP
Sets the constant label text.
.TP
\fB+L\fP\fIflag\fP
Sets the label text according to the specified flag:
.RS
.TP
\fB+Lh\fP
Take the label from the current multisegment header (first scan for an embedded
\fB\-L\fP\fIlabel\fP option, if not use the first word following the segment flag).
.TP
\fB+Ld\fP
Take the Cartesian plot distances along the line as the label; append \fBc|i|m|p\fP
as the unit [Default is \fBMEASURE_UNIT\fP].
.TP
\fB+LD\fP
Calculate actual map distances; append \fBd|e|k|m|n\fP as the unit [Default is \fBd\fP(egrees),
unless label placement was based on map distances along the lines in which case we use the same unit specified for that algorithm].
Requires a map projection to be used.
.TP
\fB+Lf\fP
Use text after the 2nd column in the fixed label location file as the label.  Requires the fixed label
location setting.
.TP
\fB+Lx\fP
As \fB+Lh\fP but use the headers in the \fIxfile.d\fP instead.  Requires the crossing file option.
.RE
.TP
\fB+o\fP
Selects rounded rectangular text box [Default is rectangular].  Not applicable for curved text (\fB+v\fP) and
only makes sense for opaque text boxes.
.TP
\fB+p\fP[\fIpen\fP]
Draws the outline of text boxsets [Default is no outline]; optionally specify pen for outline [Default is width = 0.25p, color = black, texture = solid].
\fIpen\fP is a comma delimetered list of \fIwidth\fP, \fIcolor\fP and \fItexture\fP, each of which is optional.
\fIwidth\fP can be indicated as a measure (points, centimeters, inches) or as \fBfaint\fP, \fBthin\fP[\fBner\fP|\fBnest\fP],
\fBthick\fP[\fBer\fP|\fBest\fP], \fBfat\fP[\fBter\fP|\fBtest\fP], or \fBobese\fP.
\fIcolor\fP specifies a grey shade (0\-255) or color (r/g/b, each in range 0\-255; h-s-v, ranges
0\-360, 0\-1, 0\-1; or c/m/y/k, each in range 0\-100%; or valid color name).
\fItexture\fP is a combination of dashes `-' and dots `.'.
.TP
\fB+r\fP\fImin_rad\fP
Will not place labels where the line's radius of curvature is less than \fImin_rad\fP [Default is 0].\"'
.TP
\fB+s\fP\fIsize\fP
Sets the desired font size in points [Default is 9].
.TP
\fB+u\fP\fIunit\fP
Appends \fIunit\fP to all line labels. If \fIunit\fP starts with a leading hypen (-) then there will be no space
between label value and the unit.
[Default is no unit].
.TP
\fB+v\fP
Specifies curved labels following the path [Default is straight labels].
.TP
\fB+w\fP
Specifies how many (\fIx, y\fP) points will be used to estimate label angles [Default is 10].
.TP
\fB+=\fP\fIprefix\fP
Prepends \fIprefix\fP to all line labels.
If \fIprefix\fP starts with a leading hypen (-) then there will be no space
between label value and the prefix. [Default is no prefix].
.RE
.TP
.B \-B
Sets map boundary annotation and tickmark intervals; see the
\fBpsbasemap\fP man page for all the details.
.TP
.B \-D
Dump the (x,y,z) coordinates of each contour to separate files, one for each contour segment. The
files will be named \fIdumpfile_cont_segment[_i]\fP.xyz, where \fIcont\fP is the contour value and
\fIsegment\fP is a running segment number for each contour interval (for closed contours we append _i.)
However, when \fB\-M\fP is used in conjunction with \fB\-D\fP a single multisegment file is created instead.
.TP
.B \-E
Sets the view point by specifying azimuth and elevation in degrees. [Default is 180/90].
.TP
.B \-G
Controls the placement of labels along the contours.
Choose among five controlling algorithms:
.RS
.TP
\fB\-G\fP\fBd\fP\fIdist\fP[c|i|m|p] or \fB\-G\fP\fBD\fP\fIdist\fP[d|e|k|m|n]
For lower case \fBd\fP, give distances between labels on the plot in your preferred measurement unit
\fBc\fP (cm), \fBi\fP (inch), \fBm\fP (meter), or \fBp\fP (points), while for upper case \fBD\fP, specify
distances in map units and append the unit; choose among \fBe\fP (m), \fBk\fP (km), \fBm\fP (mile), \fBn\fP
(nautical mile), or \fBd\fP (spherical degree).  [Default is 10\fBc\fP or 4\fBi\fP].  
.TP
\fB\-G\fP\fBf\fP\fIffile.d\fP
Reads the ascii file \fIffile.d\fP and places labels at locations in the file
that matches locations along the contours.
Inexact mathces and points outside the region are skipped.
.TP
\fB\-G\fP\fBl|L\fP\fIline1\fP[,\fIline2\fP,...]
Give \fIstart\fP and \fIstop\fP coordinates for one or
more comma-separated straight line segments.  Labels will be placed where these lines intersect the
contours.  The format of each \fIline\fP specification is \fIstart/stop\fP, where \fIstart\fP and \fIstop\fP
are either a specified point \fIlon/lat\fP or a 2-character \fBXY\fP key that uses the justification
format employed in \fBpstext\fP to indicate a point on the map, given as [LCR][BMT].
\fB\-G\fP\fBL\fP will interpret the point pairs as defining great circles [Default is straight line].
.TP
\fB\-G\fP\fBn\fP\fIn_label\fP
Specifies the number of equidistant labels for contours line [1].
Upper case \fB\-G\fP\fBN\fP starts labeling exactly at the start of the line [Default centers them along the line].
\fB\-G\fP\fBN\fP-1 places one justified label at start, while \fB\-G\fP\fBN\fP+1 places one justified
label at the end of contours.
Optionally, append /\fImin_dist\fP[c|i|m|p] to enforce that a minimum distance separation
between successive labels is enforced.
.TP
\fB\-G\fP\fBx|X\fP\fIxfile.d\fP
Reads the multi-segment file \fIxfile.d\fP and places labels at the intersections
between the contours and the lines in\fIxfile.d\fP.  \fB\-G\fP\fBX\fP will resample the lines first along
great-circle arcs.
.RE
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-I
Color the triangles using the color palette table.
.TP
.B \-Jz
Sets the vertical scaling (for 3-D maps).  Same syntax as \fB\-Jx\fP.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Draw the underlying triangular mesh using the specified pen attributes [Default is no mesh].
\fIpen\fP is a comma delimetered list of \fIwidth\fP, \fIcolor\fP and \fItexture\fP, each of which is optional.
\fIwidth\fP can be indicated as a measure (points, centimeters, inches) or as \fBfaint\fP, \fBthin\fP[\fBner\fP|\fBnest\fP],
\fBthick\fP[\fBer\fP|\fBest\fP], \fBfat\fP[\fBter\fP|\fBtest\fP], or \fBobese\fP.
\fIcolor\fP specifies a grey shade (0\-255) or color (r/g/b, each in range 0\-255; h-s-v, ranges
0\-360, 0\-1, 0\-1; or c/m/y/k, each in range 0\-100%; or valid color name).
\fItexture\fP is a combination of dashes `-' and dots `.'.
.TP
.B \-M
When used in conjunction with \fB\-D\fP a single multisegment file is created, and
each contour section is preceded by a header record whose first column is \fIflag\fP
followed by the contour level.
.TP
.B \-N
Do NOT clip contours or image at the boundaries [Default will clip to fit inside region \fB\-R\fP].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
.B \-S
Skip all input \fIxyz\fP points that fall outside the region [Default uses all the data in the triangulation].
.TP
.B \-T
Give name of file with network information.  Each record must contain triplets of
node numbers for a triangle [Default computes these using Delaunay triangulation (see \fBtriangulate\fP)].
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot.  Optionally,
append a label, or \fBc\fP (which will plot the command string.).  The \fBGMT\fP parameters
\fBUNIX_TIME\fP and \fBUNIX_TIME_POS\fP can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Select contouring and set contour pen attributes.  If the \fB+\fP flag is set then
the contour lines are colored according to the cpt file (see \fB\-C\fP).
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP), and
opetionally append units (\fBc\fP, \fBi\fP, \fBm\fP, \fBp\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
Give \fBc\fP to center plot using current page size.
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is 3 input columns].
Use 4-byte integer triplets for node ids (\fB\-T\fP).
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.  Optionally, append
\fIncol\fP, the number of desired columns in your binary output file.
[Default is 3 output columns].
.SH EXAMPLES
To make a raw contour plot from the file topo.xyz and drawing the contours (pen = 2)
given in the color palette file topo.cpt on a Lambert map
at 0.5 inch/degree along the standard parallels 18 and 24, use 
.br
.sp
\fBpscontour\fP topo.xyz \fB\-R\fP320/330/20/30 \fB\-Jl\fP18/24/0.5\fBi\fP \fB\-C\fPtopo.cpt \fB\-W\fP0.5\fBp\fP > topo.ps
.br
.sp
To create a color \fIPostScript\fP plot of the numerical temperature solution obtained on a triangular mesh
whose node coordinates and temperatures are stored in temp.xyz and mesh arrangement is given by the file mesh.ijk, using
the colors in temp.cpt, run
.br
.sp
\fBpscontour\fP temp.xyz \fB\-R\fP0/150/0/100 \fB\-Jx\fP0.1 \fB\-C\fPtemp.cpt \fB\-G \-W\fP0.25\fBp\fP > temp.ps
.SH BUGS
Sometimes there will appear to be thin lines of the wrong color in the image.
This is a round-off problem which may be remedied by using a higher value of
\fBDOTS_PR_INCH\fP in the \.gmtdefaults4 file.
.SH "SEE ALSO"
.IR GMT (l),
.IR grdcontour (l),
.IR grdimage (l),
.IR nearneighbor (l),
.IR psbasemap (l),
.IR psscale (l),
.IR surface (l),
.IR triangulate (l)
.SH REFERENCES
Watson, D. F., 1982, Acord: Automatic contouring of raw data, \fIComp. & Geosci., 8\fP, 97\-101.
.br
Shewchuk, J. R., 1996, Triangle: Engineering a 2D Quality Mesh Generator
and Delaunay Triangulator, First Workshop on Applied Computational Geometry
(Philadelphia, PA), 124-133, ACM, May 1996.
.br
www.cs.cmu.edu/~quake/triangle.html
