#include "MElement.h"
#include "GaussLegendreSimplex.h"
//#include "Global.h"

/* constants for 4-point rule */
#define  a4  0.5854101966249685  
#define  b4  0.138196601125015  

/* constants for 5-point rule */
#define  a5  0.500000000000000  
#define  b5  0.166666666666667  

/* constants for 16-point rule */
#define  a16  0.0503737941001228  
#define  b16  0.0665420686332923  
#define  c16  0.7716429020672371  
#define  d16  0.0761190326442543  
#define  e16  0.1197005277978019  
#define  f16  0.0718316452676693  
#define  g16  0.4042339134672644  

/* constants for 17-p9oint rule */
#define  a17  0.1884185567365411  
#define  b17  0.0670385837260428  
#define  c17  0.0452855923632739  
#define  p17  0.7316369079576180  
#define  q17  0.0894543640141273  
#define  e17  0.1325810999384657  
#define  f17  0.0245400397290300  
#define  g17  0.4214394310662522  


/* constants for 29-point rule */
#define  a29  0.0904012904601475  
#define  b29  0.0191198342789912  
#define  c29  0.0436149384066657  
#define  d29  0.0258116759619916  
#define  p29  0.8277192480479295  
#define  q29  0.0574269173173568  
#define  e29  0.0513518841255634  
#define  f29  0.4860510285706072  
#define  g29  0.2312985436519147  
#define  h29  0.2967538129690260  
#define  i29  0.6081079894015281  
#define  j29  0.0475690988147229  

IntPt GQTet1[1] = { 
  {{.25,.25,.25},1.0} 
};

IntPt GQTet2[4] = {
  { {a4,b4,b4},.25 },
  { {b4,a4,b4},.25 },
  { {b4,b4,a4},.25 },
  { {b4,b4,b4},.25 }
};

IntPt GQTet3[5] = {
  {{0.25,0.25,0.25},-0.8},
  {{a5,b5,b5},0.45},
  {{b5,a5,b5},0.45},
  {{b5,b5,a5},0.45},
  {{b5,b5,b5},0.45}
};

IntPt GQTet4[16] = {
  {{c16,d16,d16},a16},
  {{d16,c16,d16},a16},
  {{d16,d16,c16},a16},
  {{d16,d16,d16},a16},
  {{e16,f16,g16},b16},
  {{f16,e16,g16},b16},
  {{e16,g16,g16},b16},
  {{f16,g16,g16},b16},
  {{g16,g16,e16},b16},
  {{g16,g16,f16},b16},
  {{g16,e16,f16},b16},
  {{g16,f16,e16},b16},
  {{e16,g16,f16},b16},
  {{f16,g16,e16},b16},
  {{g16,e16,g16},b16},
  {{g16,f16,g16},b16}
};

IntPt GQTet5[17] = {
  {{0.25,0.25,0.25},a17},
  {{p17,q17,q17},b17},
  {{q17,p17,q17},b17},
  {{q17,q17,p17},b17},
  {{q17,q17,q17},b17},
  {{e17,f17,g17},c17},
  {{f17,e17,g17},c17},
  {{e17,g17,g17},c17},
  {{f17,g17,g17},c17},
  {{g17,g17,e17},c17},
  {{g17,g17,f17},c17},
  {{g17,e17,f17},c17},
  {{g17,f17,e17},c17},
  {{e17,g17,f17},c17},
  {{f17,g17,e17},c17},
  {{g17,e17,g17},c17},
  {{g17,f17,g17},c17}
};

IntPt GQTet6[29] = {
  {{0.25,0.25,0.25},a29},
  
  {{p29,q29,q29},b29},
  {{q29,p29,q29},b29},
  {{q29,q29,p29},b29},
  {{q29,q29,q29},b29},
  
  {{e29,f29,g29},c29},
  {{f29,e29,g29},c29},
  {{e29,g29,g29},c29},
  {{f29,g29,g29},c29},
  {{g29,g29,e29},c29},
  {{g29,g29,f29},c29},
  {{g29,e29,f29},c29},
  {{g29,f29,e29},c29},
  {{e29,g29,f29},c29},
  {{f29,g29,e29},c29},
  {{g29,e29,g29},c29},
  {{g29,f29,g29},c29},
  
  {{h29,i29,j29},d29},
  {{i29,h29,j29},d29},
  {{h29,j29,j29},d29},
  {{i29,j29,j29},d29},
  {{j29,j29,h29},d29},
  {{j29,j29,i29},d29},
  {{j29,h29,i29},d29},
  {{j29,i29,h29},d29},
  {{h29,j29,i29},d29},
  {{i29,j29,h29},d29},
  {{j29,h29,j29},d29},
  {{j29,i29,j29},d29}
  
};


IntPt * GQTet[7] = {GQTet1,GQTet1,GQTet2,GQTet3,GQTet4,GQTet5,GQTet6};
IntPt * GQTetDegen[17] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
int GQTetnPt[7] = {1,1,4,5,16,17,29};

// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 1 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP1Solin[1] = {
  {{0.25 , 0.25 , 0.25}, 1}
};

// 0 negative weights, 0 points outside of the tetrahedron,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 2 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP2Solin[4] = {
  {{0.138196601125 , 0.138196601125 , 0.138196601125}, 0.25},
  {{0.585410196625 , 0.138196601125 , 0.138196601125}, 0.25},
  {{0.138196601125 , 0.585410196625 , 0.138196601125}, 0.25},
  {{0.138196601125 , 0.138196601125 , 0.585410196625}, 0.25}
};

// 0 negative weights, 0 points outside of the tetrahedron,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 3 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP3Solin[5] = {
  {{0.25 , 0.25 , 0.25}, -0.8},
  {{0.166666666667 , 0.166666666667 , 0.166666666667}, 0.45},
  {{0.166666666667 , 0.166666666667 , 0.5}, 0.45},
  {{0.166666666667 , 0.5 , 0.166666666667}, 0.45},
  {{0.5 , 0.166666666667 , 0.166666666667}, 0.45}
};

// 1 negative weights, 0 points outside of the tetrahedron,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 4 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP4Solin[11] = {
  {{0.25 , 0.25 , 0.25}, -0.0789333333333},
  {{0.0714285714286 , 0.0714285714286 , 0.0714285714286}, 0.0457333333333},
  {{0.0714285714286 , 0.0714285714286 , 0.785714285714}, 0.0457333333333},
  {{0.0714285714286 , 0.785714285714 , 0.0714285714286}, 0.0457333333333},
  {{0.785714285714 , 0.0714285714286 , 0.0714285714286}, 0.0457333333333},
  {{0.399403576167 , 0.399403576167 , 0.100596423833}, 0.149333333333},
  {{0.399403576167 , 0.100596423833 , 0.399403576167}, 0.149333333333},
  {{0.100596423833 , 0.399403576167 , 0.399403576167}, 0.149333333333},
  {{0.399403576167 , 0.100596423833 , 0.100596423833}, 0.149333333333},
  {{0.100596423833 , 0.399403576167 , 0.100596423833}, 0.149333333333},
  {{0.100596423833 , 0.100596423833 , 0.399403576167}, 0.149333333333}
};

// 1 negative weights, 0 points outside of the tetrahedron,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 5 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP5Solin[14] = {
  {{0.0927352503109 , 0.0927352503109 , 0.0927352503109}, 0.0734930431164},
  {{0.721794249067 , 0.0927352503109 , 0.0927352503109}, 0.0734930431164},
  {{0.0927352503109 , 0.721794249067 , 0.0927352503109}, 0.0734930431164},
  {{0.0927352503109 , 0.0927352503109 , 0.721794249067}, 0.0734930431164},
  {{0.310885919263 , 0.310885919263 , 0.310885919263}, 0.112687925718},
  {{0.0673422422101 , 0.310885919263 , 0.310885919263}, 0.112687925718},
  {{0.310885919263 , 0.0673422422101 , 0.310885919263}, 0.112687925718},
  {{0.310885919263 , 0.310885919263 , 0.0673422422101}, 0.112687925718},
  {{0.454496295874 , 0.454496295874 , 0.0455037041256}, 0.0425460207771},
  {{0.454496295874 , 0.0455037041256 , 0.454496295874}, 0.0425460207771},
  {{0.0455037041256 , 0.454496295874 , 0.454496295874}, 0.0425460207771},
  {{0.454496295874 , 0.0455037041256 , 0.0455037041256}, 0.0425460207771},
  {{0.0455037041256 , 0.454496295874 , 0.0455037041256}, 0.0425460207771},
  {{0.0455037041256 , 0.0455037041256 , 0.454496295874}, 0.0425460207771}
};

// 0 negative weights, 0 points outside of the tetrahedron,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 6 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP6Solin[24] = {
  {{0.214602871259 , 0.214602871259 , 0.214602871259}, 0.0399227502582},
  {{0.356191386223 , 0.214602871259 , 0.214602871259}, 0.0399227502582},
  {{0.214602871259 , 0.356191386223 , 0.214602871259}, 0.0399227502582},
  {{0.214602871259 , 0.214602871259 , 0.356191386223}, 0.0399227502582},
  {{0.0406739585346 , 0.0406739585346 , 0.0406739585346}, 0.0100772110553},
  {{0.877978124396 , 0.0406739585346 , 0.0406739585346}, 0.0100772110553},
  {{0.0406739585346 , 0.877978124396 , 0.0406739585346}, 0.0100772110553},
  {{0.0406739585346 , 0.0406739585346 , 0.877978124396}, 0.0100772110553},
  {{0.322337890142 , 0.322337890142 , 0.322337890142}, 0.0553571815437},
  {{0.0329863295732 , 0.322337890142 , 0.322337890142}, 0.0553571815437},
  {{0.322337890142 , 0.0329863295732 , 0.322337890142}, 0.0553571815437},
  {{0.322337890142 , 0.322337890142 , 0.0329863295732}, 0.0553571815437},
  {{0.063661001875 , 0.063661001875 , 0.269672331458}, 0.0482142857143},
  {{0.063661001875 , 0.269672331458 , 0.063661001875}, 0.0482142857143},
  {{0.063661001875 , 0.063661001875 , 0.603005664792}, 0.0482142857143},
  {{0.063661001875 , 0.603005664792 , 0.063661001875}, 0.0482142857143},
  {{0.063661001875 , 0.269672331458 , 0.603005664792}, 0.0482142857143},
  {{0.063661001875 , 0.603005664792 , 0.269672331458}, 0.0482142857143},
  {{0.269672331458 , 0.063661001875 , 0.063661001875}, 0.0482142857143},
  {{0.269672331458 , 0.063661001875 , 0.603005664792}, 0.0482142857143},
  {{0.269672331458 , 0.603005664792 , 0.063661001875}, 0.0482142857143},
  {{0.603005664792 , 0.063661001875 , 0.269672331458}, 0.0482142857143},
  {{0.603005664792 , 0.063661001875 , 0.063661001875}, 0.0482142857143},
  {{0.603005664792 , 0.269672331458 , 0.063661001875}, 0.0482142857143}
};

// 0 negative weights, 0 points outside of the tetrahedron,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 7 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP7Solin[31] = {
  {{0.5 , 0.5 , 0}, 0.00582010582011},
  {{0.5 , 0 , 0.5}, 0.00582010582011},
  {{0 , 0.5 , 0.5}, 0.00582010582011},
  {{0 , 0 , 0.5}, 0.00582010582011},
  {{0 , 0.5 , 0}, 0.00582010582011},
  {{0.5 , 0 , 0}, 0.00582010582011},
  {{0.25 , 0.25 , 0.25}, 0.109585340797},
  {{0.0782131923303 , 0.0782131923303 , 0.0782131923303}, 0.0635996491465},
  {{0.0782131923303 , 0.0782131923303 , 0.765360423009}, 0.0635996491465},
  {{0.0782131923303 , 0.765360423009 , 0.0782131923303}, 0.0635996491465},
  {{0.765360423009 , 0.0782131923303 , 0.0782131923303}, 0.0635996491465},
  {{0.121843216664 , 0.121843216664 , 0.121843216664}, -0.375106440686},
  {{0.121843216664 , 0.121843216664 , 0.634470350008}, -0.375106440686},
  {{0.121843216664 , 0.634470350008 , 0.121843216664}, -0.375106440686},
  {{0.634470350008 , 0.121843216664 , 0.121843216664}, -0.375106440686},
  {{0.332539164446 , 0.332539164446 , 0.332539164446}, 0.0293485515784},
  {{0.332539164446 , 0.332539164446 , 0.00238250666074}, 0.0293485515784},
  {{0.332539164446 , 0.00238250666074 , 0.332539164446}, 0.0293485515784},
  {{0.00238250666074 , 0.332539164446 , 0.332539164446}, 0.0293485515784},
  {{0.1 , 0.1 , 0.2}, 0.165343915344},
  {{0.1 , 0.2 , 0.1}, 0.165343915344},
  {{0.1 , 0.1 , 0.6}, 0.165343915344},
  {{0.1 , 0.6 , 0.1}, 0.165343915344},
  {{0.1 , 0.2 , 0.6}, 0.165343915344},
  {{0.1 , 0.6 , 0.2}, 0.165343915344},
  {{0.2 , 0.1 , 0.1}, 0.165343915344},
  {{0.2 , 0.1 , 0.6}, 0.165343915344},
  {{0.2 , 0.6 , 0.1}, 0.165343915344},
  {{0.6 , 0.1 , 0.2}, 0.165343915344},
  {{0.6 , 0.1 , 0.1}, 0.165343915344},
  {{0.6 , 0.2 , 0.1}, 0.165343915344}
};

// 4 negative weights, 0 points outside of the tetrahedron 


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 8 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP8Solin[43] = {
  {{0.25 , 0.25 , 0.25}, -0.123001131952},
  {{0.206829931611 , 0.206829931611 , 0.206829931611}, 0.0855018349372},
  {{0.206829931611 , 0.206829931611 , 0.379510205168}, 0.0855018349372},
  {{0.206829931611 , 0.379510205168 , 0.206829931611}, 0.0855018349372},
  {{0.379510205168 , 0.206829931611 , 0.206829931611}, 0.0855018349372},
  {{0.0821035883105 , 0.0821035883105 , 0.0821035883105}, 0.0118021998788},
  {{0.0821035883105 , 0.0821035883105 , 0.753689235068}, 0.0118021998788},
  {{0.0821035883105 , 0.753689235068 , 0.0821035883105}, 0.0118021998788},
  {{0.753689235068 , 0.0821035883105 , 0.0821035883105}, 0.0118021998788},
  {{0.0057819505052 , 0.0057819505052 , 0.0057819505052}, 0.00101900465456},
  {{0.0057819505052 , 0.0057819505052 , 0.982654148484}, 0.00101900465456},
  {{0.0057819505052 , 0.982654148484 , 0.0057819505052}, 0.00101900465456},
  {{0.982654148484 , 0.0057819505052 , 0.0057819505052}, 0.00101900465456},
  {{0.0505327400189 , 0.0505327400189 , 0.449467259981}, 0.0274781029468},
  {{0.0505327400189 , 0.449467259981 , 0.0505327400189}, 0.0274781029468},
  {{0.449467259981 , 0.0505327400189 , 0.0505327400189}, 0.0274781029468},
  {{0.0505327400189 , 0.449467259981 , 0.449467259981}, 0.0274781029468},
  {{0.449467259981 , 0.0505327400189 , 0.449467259981}, 0.0274781029468},
  {{0.449467259981 , 0.449467259981 , 0.0505327400189}, 0.0274781029468},
  {{0.229066536117 , 0.229066536117 , 0.0356395827885}, 0.0342269148521},
  {{0.229066536117 , 0.0356395827885 , 0.229066536117}, 0.0342269148521},
  {{0.229066536117 , 0.229066536117 , 0.506227344978}, 0.0342269148521},
  {{0.229066536117 , 0.506227344978 , 0.229066536117}, 0.0342269148521},
  {{0.229066536117 , 0.0356395827885 , 0.506227344978}, 0.0342269148521},
  {{0.229066536117 , 0.506227344978 , 0.0356395827885}, 0.0342269148521},
  {{0.0356395827885 , 0.229066536117 , 0.229066536117}, 0.0342269148521},
  {{0.0356395827885 , 0.229066536117 , 0.506227344978}, 0.0342269148521},
  {{0.0356395827885 , 0.506227344978 , 0.229066536117}, 0.0342269148521},
  {{0.506227344978 , 0.229066536117 , 0.0356395827885}, 0.0342269148521},
  {{0.506227344978 , 0.229066536117 , 0.229066536117}, 0.0342269148521},
  {{0.506227344978 , 0.0356395827885 , 0.229066536117}, 0.0342269148521},
  {{0.0366077495532 , 0.0366077495532 , 0.190486041935}, 0.012843114847},
  {{0.0366077495532 , 0.190486041935 , 0.0366077495532}, 0.012843114847},
  {{0.0366077495532 , 0.0366077495532 , 0.736298458959}, 0.012843114847},
  {{0.0366077495532 , 0.736298458959 , 0.0366077495532}, 0.012843114847},
  {{0.0366077495532 , 0.190486041935 , 0.736298458959}, 0.012843114847},
  {{0.0366077495532 , 0.736298458959 , 0.190486041935}, 0.012843114847},
  {{0.190486041935 , 0.0366077495532 , 0.0366077495532}, 0.012843114847},
  {{0.190486041935 , 0.0366077495532 , 0.736298458959}, 0.012843114847},
  {{0.190486041935 , 0.736298458959 , 0.0366077495532}, 0.012843114847},
  {{0.736298458959 , 0.0366077495532 , 0.190486041935}, 0.012843114847},
  {{0.736298458959 , 0.0366077495532 , 0.0366077495532}, 0.012843114847},
  {{0.736298458959 , 0.190486041935 , 0.0366077495532}, 0.012843114847}
};

// 1 negative weights, 0 points outside of the tetrahedron 


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 9 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP9Solin[53] = {
  {{0.25 , 0.25 , 0.25}, -0.826794229957},
  {{0.0483510385497 , 0.0483510385497 , 0.0483510385497}, 0.0111920194145},
  {{0.0483510385497 , 0.0483510385497 , 0.854946884351}, 0.0111920194145},
  {{0.0483510385497 , 0.854946884351 , 0.0483510385497}, 0.0111920194145},
  {{0.854946884351 , 0.0483510385497 , 0.0483510385497}, 0.0111920194145},
  {{0.324579280118 , 0.324579280118 , 0.324579280118}, 0.025856543817},
  {{0.324579280118 , 0.324579280118 , 0.0262621596464}, 0.025856543817},
  {{0.324579280118 , 0.0262621596464 , 0.324579280118}, 0.025856543817},
  {{0.0262621596464 , 0.324579280118 , 0.324579280118}, 0.025856543817},
  {{0.114616540224 , 0.114616540224 , 0.114616540224}, -0.541108598887},
  {{0.114616540224 , 0.114616540224 , 0.656150379328}, -0.541108598887},
  {{0.114616540224 , 0.656150379328 , 0.114616540224}, -0.541108598887},
  {{0.656150379328 , 0.114616540224 , 0.114616540224}, -0.541108598887},
  {{0.225489951912 , 0.225489951912 , 0.225489951912}, 0.268035457215},
  {{0.225489951912 , 0.225489951912 , 0.323530144265}, 0.268035457215},
  {{0.225489951912 , 0.323530144265 , 0.225489951912}, 0.268035457215},
  {{0.323530144265 , 0.225489951912 , 0.225489951912}, 0.268035457215},
  {{0.131627809247 , 0.131627809247 , 0.0836647016172}, 0.208202435307},
  {{0.131627809247 , 0.0836647016172 , 0.131627809247}, 0.208202435307},
  {{0.131627809247 , 0.131627809247 , 0.653079679889}, 0.208202435307},
  {{0.131627809247 , 0.653079679889 , 0.131627809247}, 0.208202435307},
  {{0.131627809247 , 0.0836647016172 , 0.653079679889}, 0.208202435307},
  {{0.131627809247 , 0.653079679889 , 0.0836647016172}, 0.208202435307},
  {{0.0836647016172 , 0.131627809247 , 0.131627809247}, 0.208202435307},
  {{0.0836647016172 , 0.131627809247 , 0.653079679889}, 0.208202435307},
  {{0.0836647016172 , 0.653079679889 , 0.131627809247}, 0.208202435307},
  {{0.653079679889 , 0.131627809247 , 0.0836647016172}, 0.208202435307},
  {{0.653079679889 , 0.131627809247 , 0.131627809247}, 0.208202435307},
  {{0.653079679889 , 0.0836647016172 , 0.131627809247}, 0.208202435307},
  {{0.433951461411 , 0.433951461411 , 0.107769859549}, 0.020115503416},
  {{0.433951461411 , 0.107769859549 , 0.433951461411}, 0.020115503416},
  {{0.433951461411 , 0.433951461411 , 0.0243272176278}, 0.020115503416},
  {{0.433951461411 , 0.0243272176278 , 0.433951461411}, 0.020115503416},
  {{0.433951461411 , 0.107769859549 , 0.0243272176278}, 0.020115503416},
  {{0.433951461411 , 0.0243272176278 , 0.107769859549}, 0.020115503416},
  {{0.107769859549 , 0.433951461411 , 0.433951461411}, 0.020115503416},
  {{0.107769859549 , 0.433951461411 , 0.0243272176278}, 0.020115503416},
  {{0.107769859549 , 0.0243272176278 , 0.433951461411}, 0.020115503416},
  {{0.0243272176278 , 0.433951461411 , 0.107769859549}, 0.020115503416},
  {{0.0243272176278 , 0.433951461411 , 0.433951461411}, 0.020115503416},
  {{0.0243272176278 , 0.107769859549 , 0.433951461411}, 0.020115503416},
  {{-0.00137627731814 , -0.00137627731814 , 0.276553472637}, 0.00258977325334},
  {{-0.00137627731814 , 0.276553472637 , -0.00137627731814}, 0.00258977325334},
  {{-0.00137627731814 , -0.00137627731814 , 0.726199081999}, 0.00258977325334},
  {{-0.00137627731814 , 0.726199081999 , -0.00137627731814}, 0.00258977325334},
  {{-0.00137627731814 , 0.276553472637 , 0.726199081999}, 0.00258977325334},
  {{-0.00137627731814 , 0.726199081999 , 0.276553472637}, 0.00258977325334},
  {{0.276553472637 , -0.00137627731814 , -0.00137627731814}, 0.00258977325334},
  {{0.276553472637 , -0.00137627731814 , 0.726199081999}, 0.00258977325334},
  {{0.276553472637 , 0.726199081999 , -0.00137627731814}, 0.00258977325334},
  {{0.726199081999 , -0.00137627731814 , 0.276553472637}, 0.00258977325334},
  {{0.726199081999 , -0.00137627731814 , -0.00137627731814}, 0.00258977325334},
  {{0.726199081999 , 0.276553472637 , -0.00137627731814}, 0.00258977325334}
};

// 5 negative weights, 12 points outside of the tetrahedron 


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 11 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP11Solin[126] = {
  {{0.0714285714286 , 0.0714285714286 , 0.785714285714}, 0.27217694439},
  {{0.0714285714286 , 0.214285714286 , 0.642857142857}, 0.27217694439},
  {{0.0714285714286 , 0.357142857143 , 0.5}, 0.27217694439},
  {{0.0714285714286 , 0.5 , 0.357142857143}, 0.27217694439},
  {{0.0714285714286 , 0.642857142857 , 0.214285714286}, 0.27217694439},
  {{0.0714285714286 , 0.785714285714 , 0.0714285714286}, 0.27217694439},
  {{0.214285714286 , 0.0714285714286 , 0.642857142857}, 0.27217694439},
  {{0.214285714286 , 0.214285714286 , 0.5}, 0.27217694439},
  {{0.214285714286 , 0.357142857143 , 0.357142857143}, 0.27217694439},
  {{0.214285714286 , 0.5 , 0.214285714286}, 0.27217694439},
  {{0.214285714286 , 0.642857142857 , 0.0714285714286}, 0.27217694439},
  {{0.357142857143 , 0.0714285714286 , 0.5}, 0.27217694439},
  {{0.357142857143 , 0.214285714286 , 0.357142857143}, 0.27217694439},
  {{0.357142857143 , 0.357142857143 , 0.214285714286}, 0.27217694439},
  {{0.357142857143 , 0.5 , 0.0714285714286}, 0.27217694439},
  {{0.5 , 0.0714285714286 , 0.357142857143}, 0.27217694439},
  {{0.5 , 0.214285714286 , 0.214285714286}, 0.27217694439},
  {{0.5 , 0.357142857143 , 0.0714285714286}, 0.27217694439},
  {{0.642857142857 , 0.0714285714286 , 0.214285714286}, 0.27217694439},
  {{0.642857142857 , 0.214285714286 , 0.0714285714286}, 0.27217694439},
  {{0.785714285714 , 0.0714285714286 , 0.0714285714286}, 0.27217694439},
  {{0.0714285714286 , 0.0714285714286 , 0.642857142857}, 0.27217694439},
  {{0.0714285714286 , 0.214285714286 , 0.5}, 0.27217694439},
  {{0.0714285714286 , 0.357142857143 , 0.357142857143}, 0.27217694439},
  {{0.0714285714286 , 0.5 , 0.214285714286}, 0.27217694439},
  {{0.0714285714286 , 0.642857142857 , 0.0714285714286}, 0.27217694439},
  {{0.214285714286 , 0.0714285714286 , 0.5}, 0.27217694439},
  {{0.214285714286 , 0.214285714286 , 0.357142857143}, 0.27217694439},
  {{0.214285714286 , 0.357142857143 , 0.214285714286}, 0.27217694439},
  {{0.214285714286 , 0.5 , 0.0714285714286}, 0.27217694439},
  {{0.357142857143 , 0.0714285714286 , 0.357142857143}, 0.27217694439},
  {{0.357142857143 , 0.214285714286 , 0.214285714286}, 0.27217694439},
  {{0.357142857143 , 0.357142857143 , 0.0714285714286}, 0.27217694439},
  {{0.5 , 0.0714285714286 , 0.214285714286}, 0.27217694439},
  {{0.5 , 0.214285714286 , 0.0714285714286}, 0.27217694439},
  {{0.642857142857 , 0.0714285714286 , 0.0714285714286}, 0.27217694439},
  {{0.0714285714286 , 0.0714285714286 , 0.5}, 0.27217694439},
  {{0.0714285714286 , 0.214285714286 , 0.357142857143}, 0.27217694439},
  {{0.0714285714286 , 0.357142857143 , 0.214285714286}, 0.27217694439},
  {{0.0714285714286 , 0.5 , 0.0714285714286}, 0.27217694439},
  {{0.214285714286 , 0.0714285714286 , 0.357142857143}, 0.27217694439},
  {{0.214285714286 , 0.214285714286 , 0.214285714286}, 0.27217694439},
  {{0.214285714286 , 0.357142857143 , 0.0714285714286}, 0.27217694439},
  {{0.357142857143 , 0.0714285714286 , 0.214285714286}, 0.27217694439},
  {{0.357142857143 , 0.214285714286 , 0.0714285714286}, 0.27217694439},
  {{0.5 , 0.0714285714286 , 0.0714285714286}, 0.27217694439},
  {{0.0714285714286 , 0.0714285714286 , 0.357142857143}, 0.27217694439},
  {{0.0714285714286 , 0.214285714286 , 0.214285714286}, 0.27217694439},
  {{0.0714285714286 , 0.357142857143 , 0.0714285714286}, 0.27217694439},
  {{0.214285714286 , 0.0714285714286 , 0.214285714286}, 0.27217694439},
  {{0.214285714286 , 0.214285714286 , 0.0714285714286}, 0.27217694439},
  {{0.357142857143 , 0.0714285714286 , 0.0714285714286}, 0.27217694439},
  {{0.0714285714286 , 0.0714285714286 , 0.214285714286}, 0.27217694439},
  {{0.0714285714286 , 0.214285714286 , 0.0714285714286}, 0.27217694439},
  {{0.214285714286 , 0.0714285714286 , 0.0714285714286}, 0.27217694439},
  {{0.0714285714286 , 0.0714285714286 , 0.0714285714286}, 0.27217694439},
  {{0.0833333333333 , 0.0833333333333 , 0.75}, -0.699140859141},
  {{0.0833333333333 , 0.25 , 0.583333333333}, -0.699140859141},
  {{0.0833333333333 , 0.416666666667 , 0.416666666667}, -0.699140859141},
  {{0.0833333333333 , 0.583333333333 , 0.25}, -0.699140859141},
  {{0.0833333333333 , 0.75 , 0.0833333333333}, -0.699140859141},
  {{0.25 , 0.0833333333333 , 0.583333333333}, -0.699140859141},
  {{0.25 , 0.25 , 0.416666666667}, -0.699140859141},
  {{0.25 , 0.416666666667 , 0.25}, -0.699140859141},
  {{0.25 , 0.583333333333 , 0.0833333333333}, -0.699140859141},
  {{0.416666666667 , 0.0833333333333 , 0.416666666667}, -0.699140859141},
  {{0.416666666667 , 0.25 , 0.25}, -0.699140859141},
  {{0.416666666667 , 0.416666666667 , 0.0833333333333}, -0.699140859141},
  {{0.583333333333 , 0.0833333333333 , 0.25}, -0.699140859141},
  {{0.583333333333 , 0.25 , 0.0833333333333}, -0.699140859141},
  {{0.75 , 0.0833333333333 , 0.0833333333333}, -0.699140859141},
  {{0.0833333333333 , 0.0833333333333 , 0.583333333333}, -0.699140859141},
  {{0.0833333333333 , 0.25 , 0.416666666667}, -0.699140859141},
  {{0.0833333333333 , 0.416666666667 , 0.25}, -0.699140859141},
  {{0.0833333333333 , 0.583333333333 , 0.0833333333333}, -0.699140859141},
  {{0.25 , 0.0833333333333 , 0.416666666667}, -0.699140859141},
  {{0.25 , 0.25 , 0.25}, -0.699140859141},
  {{0.25 , 0.416666666667 , 0.0833333333333}, -0.699140859141},
  {{0.416666666667 , 0.0833333333333 , 0.25}, -0.699140859141},
  {{0.416666666667 , 0.25 , 0.0833333333333}, -0.699140859141},
  {{0.583333333333 , 0.0833333333333 , 0.0833333333333}, -0.699140859141},
  {{0.0833333333333 , 0.0833333333333 , 0.416666666667}, -0.699140859141},
  {{0.0833333333333 , 0.25 , 0.25}, -0.699140859141},
  {{0.0833333333333 , 0.416666666667 , 0.0833333333333}, -0.699140859141},
  {{0.25 , 0.0833333333333 , 0.25}, -0.699140859141},
  {{0.25 , 0.25 , 0.0833333333333}, -0.699140859141},
  {{0.416666666667 , 0.0833333333333 , 0.0833333333333}, -0.699140859141},
  {{0.0833333333333 , 0.0833333333333 , 0.25}, -0.699140859141},
  {{0.0833333333333 , 0.25 , 0.0833333333333}, -0.699140859141},
  {{0.25 , 0.0833333333333 , 0.0833333333333}, -0.699140859141},
  {{0.0833333333333 , 0.0833333333333 , 0.0833333333333}, -0.699140859141},
  {{0.1 , 0.1 , 0.7}, 0.611623739879},
  {{0.1 , 0.3 , 0.5}, 0.611623739879},
  {{0.1 , 0.5 , 0.3}, 0.611623739879},
  {{0.1 , 0.7 , 0.1}, 0.611623739879},
  {{0.3 , 0.1 , 0.5}, 0.611623739879},
  {{0.3 , 0.3 , 0.3}, 0.611623739879},
  {{0.3 , 0.5 , 0.1}, 0.611623739879},
  {{0.5 , 0.1 , 0.3}, 0.611623739879},
  {{0.5 , 0.3 , 0.1}, 0.611623739879},
  {{0.7 , 0.1 , 0.1}, 0.611623739879},
  {{0.1 , 0.1 , 0.5}, 0.611623739879},
  {{0.1 , 0.3 , 0.3}, 0.611623739879},
  {{0.1 , 0.5 , 0.1}, 0.611623739879},
  {{0.3 , 0.1 , 0.3}, 0.611623739879},
  {{0.3 , 0.3 , 0.1}, 0.611623739879},
  {{0.5 , 0.1 , 0.1}, 0.611623739879},
  {{0.1 , 0.1 , 0.3}, 0.611623739879},
  {{0.1 , 0.3 , 0.1}, 0.611623739879},
  {{0.3 , 0.1 , 0.1}, 0.611623739879},
  {{0.1 , 0.1 , 0.1}, 0.611623739879},
  {{0.125 , 0.125 , 0.625}, -0.210152316819},
  {{0.125 , 0.375 , 0.375}, -0.210152316819},
  {{0.125 , 0.625 , 0.125}, -0.210152316819},
  {{0.375 , 0.125 , 0.375}, -0.210152316819},
  {{0.375 , 0.375 , 0.125}, -0.210152316819},
  {{0.625 , 0.125 , 0.125}, -0.210152316819},
  {{0.125 , 0.125 , 0.375}, -0.210152316819},
  {{0.125 , 0.375 , 0.125}, -0.210152316819},
  {{0.375 , 0.125 , 0.125}, -0.210152316819},
  {{0.125 , 0.125 , 0.125}, -0.210152316819},
  {{0.166666666667 , 0.166666666667 , 0.5}, 0.0244084821429},
  {{0.166666666667 , 0.5 , 0.166666666667}, 0.0244084821429},
  {{0.5 , 0.166666666667 , 0.166666666667}, 0.0244084821429},
  {{0.166666666667 , 0.166666666667 , 0.166666666667}, 0.0244084821429},
  {{0.25 , 0.25 , 0.25}, -0.000564373897707}
};

// 46 negative weights, 0 points outside of the tetrahedron 


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 13 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP13Solin[210] = {
  {{0.0625 , 0.0625 , 0.8125}, 0.315305454099},
  {{0.0625 , 0.1875 , 0.6875}, 0.315305454099},
  {{0.0625 , 0.3125 , 0.5625}, 0.315305454099},
  {{0.0625 , 0.4375 , 0.4375}, 0.315305454099},
  {{0.0625 , 0.5625 , 0.3125}, 0.315305454099},
  {{0.0625 , 0.6875 , 0.1875}, 0.315305454099},
  {{0.0625 , 0.8125 , 0.0625}, 0.315305454099},
  {{0.1875 , 0.0625 , 0.6875}, 0.315305454099},
  {{0.1875 , 0.1875 , 0.5625}, 0.315305454099},
  {{0.1875 , 0.3125 , 0.4375}, 0.315305454099},
  {{0.1875 , 0.4375 , 0.3125}, 0.315305454099},
  {{0.1875 , 0.5625 , 0.1875}, 0.315305454099},
  {{0.1875 , 0.6875 , 0.0625}, 0.315305454099},
  {{0.3125 , 0.0625 , 0.5625}, 0.315305454099},
  {{0.3125 , 0.1875 , 0.4375}, 0.315305454099},
  {{0.3125 , 0.3125 , 0.3125}, 0.315305454099},
  {{0.3125 , 0.4375 , 0.1875}, 0.315305454099},
  {{0.3125 , 0.5625 , 0.0625}, 0.315305454099},
  {{0.4375 , 0.0625 , 0.4375}, 0.315305454099},
  {{0.4375 , 0.1875 , 0.3125}, 0.315305454099},
  {{0.4375 , 0.3125 , 0.1875}, 0.315305454099},
  {{0.4375 , 0.4375 , 0.0625}, 0.315305454099},
  {{0.5625 , 0.0625 , 0.3125}, 0.315305454099},
  {{0.5625 , 0.1875 , 0.1875}, 0.315305454099},
  {{0.5625 , 0.3125 , 0.0625}, 0.315305454099},
  {{0.6875 , 0.0625 , 0.1875}, 0.315305454099},
  {{0.6875 , 0.1875 , 0.0625}, 0.315305454099},
  {{0.8125 , 0.0625 , 0.0625}, 0.315305454099},
  {{0.0625 , 0.0625 , 0.6875}, 0.315305454099},
  {{0.0625 , 0.1875 , 0.5625}, 0.315305454099},
  {{0.0625 , 0.3125 , 0.4375}, 0.315305454099},
  {{0.0625 , 0.4375 , 0.3125}, 0.315305454099},
  {{0.0625 , 0.5625 , 0.1875}, 0.315305454099},
  {{0.0625 , 0.6875 , 0.0625}, 0.315305454099},
  {{0.1875 , 0.0625 , 0.5625}, 0.315305454099},
  {{0.1875 , 0.1875 , 0.4375}, 0.315305454099},
  {{0.1875 , 0.3125 , 0.3125}, 0.315305454099},
  {{0.1875 , 0.4375 , 0.1875}, 0.315305454099},
  {{0.1875 , 0.5625 , 0.0625}, 0.315305454099},
  {{0.3125 , 0.0625 , 0.4375}, 0.315305454099},
  {{0.3125 , 0.1875 , 0.3125}, 0.315305454099},
  {{0.3125 , 0.3125 , 0.1875}, 0.315305454099},
  {{0.3125 , 0.4375 , 0.0625}, 0.315305454099},
  {{0.4375 , 0.0625 , 0.3125}, 0.315305454099},
  {{0.4375 , 0.1875 , 0.1875}, 0.315305454099},
  {{0.4375 , 0.3125 , 0.0625}, 0.315305454099},
  {{0.5625 , 0.0625 , 0.1875}, 0.315305454099},
  {{0.5625 , 0.1875 , 0.0625}, 0.315305454099},
  {{0.6875 , 0.0625 , 0.0625}, 0.315305454099},
  {{0.0625 , 0.0625 , 0.5625}, 0.315305454099},
  {{0.0625 , 0.1875 , 0.4375}, 0.315305454099},
  {{0.0625 , 0.3125 , 0.3125}, 0.315305454099},
  {{0.0625 , 0.4375 , 0.1875}, 0.315305454099},
  {{0.0625 , 0.5625 , 0.0625}, 0.315305454099},
  {{0.1875 , 0.0625 , 0.4375}, 0.315305454099},
  {{0.1875 , 0.1875 , 0.3125}, 0.315305454099},
  {{0.1875 , 0.3125 , 0.1875}, 0.315305454099},
  {{0.1875 , 0.4375 , 0.0625}, 0.315305454099},
  {{0.3125 , 0.0625 , 0.3125}, 0.315305454099},
  {{0.3125 , 0.1875 , 0.1875}, 0.315305454099},
  {{0.3125 , 0.3125 , 0.0625}, 0.315305454099},
  {{0.4375 , 0.0625 , 0.1875}, 0.315305454099},
  {{0.4375 , 0.1875 , 0.0625}, 0.315305454099},
  {{0.5625 , 0.0625 , 0.0625}, 0.315305454099},
  {{0.0625 , 0.0625 , 0.4375}, 0.315305454099},
  {{0.0625 , 0.1875 , 0.3125}, 0.315305454099},
  {{0.0625 , 0.3125 , 0.1875}, 0.315305454099},
  {{0.0625 , 0.4375 , 0.0625}, 0.315305454099},
  {{0.1875 , 0.0625 , 0.3125}, 0.315305454099},
  {{0.1875 , 0.1875 , 0.1875}, 0.315305454099},
  {{0.1875 , 0.3125 , 0.0625}, 0.315305454099},
  {{0.3125 , 0.0625 , 0.1875}, 0.315305454099},
  {{0.3125 , 0.1875 , 0.0625}, 0.315305454099},
  {{0.4375 , 0.0625 , 0.0625}, 0.315305454099},
  {{0.0625 , 0.0625 , 0.3125}, 0.315305454099},
  {{0.0625 , 0.1875 , 0.1875}, 0.315305454099},
  {{0.0625 , 0.3125 , 0.0625}, 0.315305454099},
  {{0.1875 , 0.0625 , 0.1875}, 0.315305454099},
  {{0.1875 , 0.1875 , 0.0625}, 0.315305454099},
  {{0.3125 , 0.0625 , 0.0625}, 0.315305454099},
  {{0.0625 , 0.0625 , 0.1875}, 0.315305454099},
  {{0.0625 , 0.1875 , 0.0625}, 0.315305454099},
  {{0.1875 , 0.0625 , 0.0625}, 0.315305454099},
  {{0.0625 , 0.0625 , 0.0625}, 0.315305454099},
  {{0.0714285714286 , 0.0714285714286 , 0.785714285714}, -0.889111351676},
  {{0.0714285714286 , 0.214285714286 , 0.642857142857}, -0.889111351676},
  {{0.0714285714286 , 0.357142857143 , 0.5}, -0.889111351676},
  {{0.0714285714286 , 0.5 , 0.357142857143}, -0.889111351676},
  {{0.0714285714286 , 0.642857142857 , 0.214285714286}, -0.889111351676},
  {{0.0714285714286 , 0.785714285714 , 0.0714285714286}, -0.889111351676},
  {{0.214285714286 , 0.0714285714286 , 0.642857142857}, -0.889111351676},
  {{0.214285714286 , 0.214285714286 , 0.5}, -0.889111351676},
  {{0.214285714286 , 0.357142857143 , 0.357142857143}, -0.889111351676},
  {{0.214285714286 , 0.5 , 0.214285714286}, -0.889111351676},
  {{0.214285714286 , 0.642857142857 , 0.0714285714286}, -0.889111351676},
  {{0.357142857143 , 0.0714285714286 , 0.5}, -0.889111351676},
  {{0.357142857143 , 0.214285714286 , 0.357142857143}, -0.889111351676},
  {{0.357142857143 , 0.357142857143 , 0.214285714286}, -0.889111351676},
  {{0.357142857143 , 0.5 , 0.0714285714286}, -0.889111351676},
  {{0.5 , 0.0714285714286 , 0.357142857143}, -0.889111351676},
  {{0.5 , 0.214285714286 , 0.214285714286}, -0.889111351676},
  {{0.5 , 0.357142857143 , 0.0714285714286}, -0.889111351676},
  {{0.642857142857 , 0.0714285714286 , 0.214285714286}, -0.889111351676},
  {{0.642857142857 , 0.214285714286 , 0.0714285714286}, -0.889111351676},
  {{0.785714285714 , 0.0714285714286 , 0.0714285714286}, -0.889111351676},
  {{0.0714285714286 , 0.0714285714286 , 0.642857142857}, -0.889111351676},
  {{0.0714285714286 , 0.214285714286 , 0.5}, -0.889111351676},
  {{0.0714285714286 , 0.357142857143 , 0.357142857143}, -0.889111351676},
  {{0.0714285714286 , 0.5 , 0.214285714286}, -0.889111351676},
  {{0.0714285714286 , 0.642857142857 , 0.0714285714286}, -0.889111351676},
  {{0.214285714286 , 0.0714285714286 , 0.5}, -0.889111351676},
  {{0.214285714286 , 0.214285714286 , 0.357142857143}, -0.889111351676},
  {{0.214285714286 , 0.357142857143 , 0.214285714286}, -0.889111351676},
  {{0.214285714286 , 0.5 , 0.0714285714286}, -0.889111351676},
  {{0.357142857143 , 0.0714285714286 , 0.357142857143}, -0.889111351676},
  {{0.357142857143 , 0.214285714286 , 0.214285714286}, -0.889111351676},
  {{0.357142857143 , 0.357142857143 , 0.0714285714286}, -0.889111351676},
  {{0.5 , 0.0714285714286 , 0.214285714286}, -0.889111351676},
  {{0.5 , 0.214285714286 , 0.0714285714286}, -0.889111351676},
  {{0.642857142857 , 0.0714285714286 , 0.0714285714286}, -0.889111351676},
  {{0.0714285714286 , 0.0714285714286 , 0.5}, -0.889111351676},
  {{0.0714285714286 , 0.214285714286 , 0.357142857143}, -0.889111351676},
  {{0.0714285714286 , 0.357142857143 , 0.214285714286}, -0.889111351676},
  {{0.0714285714286 , 0.5 , 0.0714285714286}, -0.889111351676},
  {{0.214285714286 , 0.0714285714286 , 0.357142857143}, -0.889111351676},
  {{0.214285714286 , 0.214285714286 , 0.214285714286}, -0.889111351676},
  {{0.214285714286 , 0.357142857143 , 0.0714285714286}, -0.889111351676},
  {{0.357142857143 , 0.0714285714286 , 0.214285714286}, -0.889111351676},
  {{0.357142857143 , 0.214285714286 , 0.0714285714286}, -0.889111351676},
  {{0.5 , 0.0714285714286 , 0.0714285714286}, -0.889111351676},
  {{0.0714285714286 , 0.0714285714286 , 0.357142857143}, -0.889111351676},
  {{0.0714285714286 , 0.214285714286 , 0.214285714286}, -0.889111351676},
  {{0.0714285714286 , 0.357142857143 , 0.0714285714286}, -0.889111351676},
  {{0.214285714286 , 0.0714285714286 , 0.214285714286}, -0.889111351676},
  {{0.214285714286 , 0.214285714286 , 0.0714285714286}, -0.889111351676},
  {{0.357142857143 , 0.0714285714286 , 0.0714285714286}, -0.889111351676},
  {{0.0714285714286 , 0.0714285714286 , 0.214285714286}, -0.889111351676},
  {{0.0714285714286 , 0.214285714286 , 0.0714285714286}, -0.889111351676},
  {{0.214285714286 , 0.0714285714286 , 0.0714285714286}, -0.889111351676},
  {{0.0714285714286 , 0.0714285714286 , 0.0714285714286}, -0.889111351676},
  {{0.0833333333333 , 0.0833333333333 , 0.75}, 0.898895390324},
  {{0.0833333333333 , 0.25 , 0.583333333333}, 0.898895390324},
  {{0.0833333333333 , 0.416666666667 , 0.416666666667}, 0.898895390324},
  {{0.0833333333333 , 0.583333333333 , 0.25}, 0.898895390324},
  {{0.0833333333333 , 0.75 , 0.0833333333333}, 0.898895390324},
  {{0.25 , 0.0833333333333 , 0.583333333333}, 0.898895390324},
  {{0.25 , 0.25 , 0.416666666667}, 0.898895390324},
  {{0.25 , 0.416666666667 , 0.25}, 0.898895390324},
  {{0.25 , 0.583333333333 , 0.0833333333333}, 0.898895390324},
  {{0.416666666667 , 0.0833333333333 , 0.416666666667}, 0.898895390324},
  {{0.416666666667 , 0.25 , 0.25}, 0.898895390324},
  {{0.416666666667 , 0.416666666667 , 0.0833333333333}, 0.898895390324},
  {{0.583333333333 , 0.0833333333333 , 0.25}, 0.898895390324},
  {{0.583333333333 , 0.25 , 0.0833333333333}, 0.898895390324},
  {{0.75 , 0.0833333333333 , 0.0833333333333}, 0.898895390324},
  {{0.0833333333333 , 0.0833333333333 , 0.583333333333}, 0.898895390324},
  {{0.0833333333333 , 0.25 , 0.416666666667}, 0.898895390324},
  {{0.0833333333333 , 0.416666666667 , 0.25}, 0.898895390324},
  {{0.0833333333333 , 0.583333333333 , 0.0833333333333}, 0.898895390324},
  {{0.25 , 0.0833333333333 , 0.416666666667}, 0.898895390324},
  {{0.25 , 0.25 , 0.25}, 0.898895390324},
  {{0.25 , 0.416666666667 , 0.0833333333333}, 0.898895390324},
  {{0.416666666667 , 0.0833333333333 , 0.25}, 0.898895390324},
  {{0.416666666667 , 0.25 , 0.0833333333333}, 0.898895390324},
  {{0.583333333333 , 0.0833333333333 , 0.0833333333333}, 0.898895390324},
  {{0.0833333333333 , 0.0833333333333 , 0.416666666667}, 0.898895390324},
  {{0.0833333333333 , 0.25 , 0.25}, 0.898895390324},
  {{0.0833333333333 , 0.416666666667 , 0.0833333333333}, 0.898895390324},
  {{0.25 , 0.0833333333333 , 0.25}, 0.898895390324},
  {{0.25 , 0.25 , 0.0833333333333}, 0.898895390324},
  {{0.416666666667 , 0.0833333333333 , 0.0833333333333}, 0.898895390324},
  {{0.0833333333333 , 0.0833333333333 , 0.25}, 0.898895390324},
  {{0.0833333333333 , 0.25 , 0.0833333333333}, 0.898895390324},
  {{0.25 , 0.0833333333333 , 0.0833333333333}, 0.898895390324},
  {{0.0833333333333 , 0.0833333333333 , 0.0833333333333}, 0.898895390324},
  {{0.1 , 0.1 , 0.7}, -0.392066499922},
  {{0.1 , 0.3 , 0.5}, -0.392066499922},
  {{0.1 , 0.5 , 0.3}, -0.392066499922},
  {{0.1 , 0.7 , 0.1}, -0.392066499922},
  {{0.3 , 0.1 , 0.5}, -0.392066499922},
  {{0.3 , 0.3 , 0.3}, -0.392066499922},
  {{0.3 , 0.5 , 0.1}, -0.392066499922},
  {{0.5 , 0.1 , 0.3}, -0.392066499922},
  {{0.5 , 0.3 , 0.1}, -0.392066499922},
  {{0.7 , 0.1 , 0.1}, -0.392066499922},
  {{0.1 , 0.1 , 0.5}, -0.392066499922},
  {{0.1 , 0.3 , 0.3}, -0.392066499922},
  {{0.1 , 0.5 , 0.1}, -0.392066499922},
  {{0.3 , 0.1 , 0.3}, -0.392066499922},
  {{0.3 , 0.3 , 0.1}, -0.392066499922},
  {{0.5 , 0.1 , 0.1}, -0.392066499922},
  {{0.1 , 0.1 , 0.3}, -0.392066499922},
  {{0.1 , 0.3 , 0.1}, -0.392066499922},
  {{0.3 , 0.1 , 0.1}, -0.392066499922},
  {{0.1 , 0.1 , 0.1}, -0.392066499922},
  {{0.125 , 0.125 , 0.625}, 0.070050772273},
  {{0.125 , 0.375 , 0.375}, 0.070050772273},
  {{0.125 , 0.625 , 0.125}, 0.070050772273},
  {{0.375 , 0.125 , 0.375}, 0.070050772273},
  {{0.375 , 0.375 , 0.125}, 0.070050772273},
  {{0.625 , 0.125 , 0.125}, 0.070050772273},
  {{0.125 , 0.125 , 0.375}, 0.070050772273},
  {{0.125 , 0.375 , 0.125}, 0.070050772273},
  {{0.375 , 0.125 , 0.125}, 0.070050772273},
  {{0.125 , 0.125 , 0.125}, 0.070050772273},
  {{0.166666666667 , 0.166666666667 , 0.5}, -0.00399411525974},
  {{0.166666666667 , 0.5 , 0.166666666667}, -0.00399411525974},
  {{0.5 , 0.166666666667 , 0.166666666667}, -0.00399411525974},
  {{0.166666666667 , 0.166666666667 , 0.166666666667}, -0.00399411525974},
  {{0.25 , 0.25 , 0.25}, 3.76249265137e-05}
};

// 80 negative weights, 0 points outside of the tetrahedron 


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 15 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP15Solin[330] = {
  {{0.0555555555556 , 0.0555555555556 , 0.833333333333}, 0.385902744622},
  {{0.0555555555556 , 0.166666666667 , 0.722222222222}, 0.385902744622},
  {{0.0555555555556 , 0.277777777778 , 0.611111111111}, 0.385902744622},
  {{0.0555555555556 , 0.388888888889 , 0.5}, 0.385902744622},
  {{0.0555555555556 , 0.5 , 0.388888888889}, 0.385902744622},
  {{0.0555555555556 , 0.611111111111 , 0.277777777778}, 0.385902744622},
  {{0.0555555555556 , 0.722222222222 , 0.166666666667}, 0.385902744622},
  {{0.0555555555556 , 0.833333333333 , 0.0555555555556}, 0.385902744622},
  {{0.166666666667 , 0.0555555555556 , 0.722222222222}, 0.385902744622},
  {{0.166666666667 , 0.166666666667 , 0.611111111111}, 0.385902744622},
  {{0.166666666667 , 0.277777777778 , 0.5}, 0.385902744622},
  {{0.166666666667 , 0.388888888889 , 0.388888888889}, 0.385902744622},
  {{0.166666666667 , 0.5 , 0.277777777778}, 0.385902744622},
  {{0.166666666667 , 0.611111111111 , 0.166666666667}, 0.385902744622},
  {{0.166666666667 , 0.722222222222 , 0.0555555555556}, 0.385902744622},
  {{0.277777777778 , 0.0555555555556 , 0.611111111111}, 0.385902744622},
  {{0.277777777778 , 0.166666666667 , 0.5}, 0.385902744622},
  {{0.277777777778 , 0.277777777778 , 0.388888888889}, 0.385902744622},
  {{0.277777777778 , 0.388888888889 , 0.277777777778}, 0.385902744622},
  {{0.277777777778 , 0.5 , 0.166666666667}, 0.385902744622},
  {{0.277777777778 , 0.611111111111 , 0.0555555555556}, 0.385902744622},
  {{0.388888888889 , 0.0555555555556 , 0.5}, 0.385902744622},
  {{0.388888888889 , 0.166666666667 , 0.388888888889}, 0.385902744622},
  {{0.388888888889 , 0.277777777778 , 0.277777777778}, 0.385902744622},
  {{0.388888888889 , 0.388888888889 , 0.166666666667}, 0.385902744622},
  {{0.388888888889 , 0.5 , 0.0555555555556}, 0.385902744622},
  {{0.5 , 0.0555555555556 , 0.388888888889}, 0.385902744622},
  {{0.5 , 0.166666666667 , 0.277777777778}, 0.385902744622},
  {{0.5 , 0.277777777778 , 0.166666666667}, 0.385902744622},
  {{0.5 , 0.388888888889 , 0.0555555555556}, 0.385902744622},
  {{0.611111111111 , 0.0555555555556 , 0.277777777778}, 0.385902744622},
  {{0.611111111111 , 0.166666666667 , 0.166666666667}, 0.385902744622},
  {{0.611111111111 , 0.277777777778 , 0.0555555555556}, 0.385902744622},
  {{0.722222222222 , 0.0555555555556 , 0.166666666667}, 0.385902744622},
  {{0.722222222222 , 0.166666666667 , 0.0555555555556}, 0.385902744622},
  {{0.833333333333 , 0.0555555555556 , 0.0555555555556}, 0.385902744622},
  {{0.0555555555556 , 0.0555555555556 , 0.722222222222}, 0.385902744622},
  {{0.0555555555556 , 0.166666666667 , 0.611111111111}, 0.385902744622},
  {{0.0555555555556 , 0.277777777778 , 0.5}, 0.385902744622},
  {{0.0555555555556 , 0.388888888889 , 0.388888888889}, 0.385902744622},
  {{0.0555555555556 , 0.5 , 0.277777777778}, 0.385902744622},
  {{0.0555555555556 , 0.611111111111 , 0.166666666667}, 0.385902744622},
  {{0.0555555555556 , 0.722222222222 , 0.0555555555556}, 0.385902744622},
  {{0.166666666667 , 0.0555555555556 , 0.611111111111}, 0.385902744622},
  {{0.166666666667 , 0.166666666667 , 0.5}, 0.385902744622},
  {{0.166666666667 , 0.277777777778 , 0.388888888889}, 0.385902744622},
  {{0.166666666667 , 0.388888888889 , 0.277777777778}, 0.385902744622},
  {{0.166666666667 , 0.5 , 0.166666666667}, 0.385902744622},
  {{0.166666666667 , 0.611111111111 , 0.0555555555556}, 0.385902744622},
  {{0.277777777778 , 0.0555555555556 , 0.5}, 0.385902744622},
  {{0.277777777778 , 0.166666666667 , 0.388888888889}, 0.385902744622},
  {{0.277777777778 , 0.277777777778 , 0.277777777778}, 0.385902744622},
  {{0.277777777778 , 0.388888888889 , 0.166666666667}, 0.385902744622},
  {{0.277777777778 , 0.5 , 0.0555555555556}, 0.385902744622},
  {{0.388888888889 , 0.0555555555556 , 0.388888888889}, 0.385902744622},
  {{0.388888888889 , 0.166666666667 , 0.277777777778}, 0.385902744622},
  {{0.388888888889 , 0.277777777778 , 0.166666666667}, 0.385902744622},
  {{0.388888888889 , 0.388888888889 , 0.0555555555556}, 0.385902744622},
  {{0.5 , 0.0555555555556 , 0.277777777778}, 0.385902744622},
  {{0.5 , 0.166666666667 , 0.166666666667}, 0.385902744622},
  {{0.5 , 0.277777777778 , 0.0555555555556}, 0.385902744622},
  {{0.611111111111 , 0.0555555555556 , 0.166666666667}, 0.385902744622},
  {{0.611111111111 , 0.166666666667 , 0.0555555555556}, 0.385902744622},
  {{0.722222222222 , 0.0555555555556 , 0.0555555555556}, 0.385902744622},
  {{0.0555555555556 , 0.0555555555556 , 0.611111111111}, 0.385902744622},
  {{0.0555555555556 , 0.166666666667 , 0.5}, 0.385902744622},
  {{0.0555555555556 , 0.277777777778 , 0.388888888889}, 0.385902744622},
  {{0.0555555555556 , 0.388888888889 , 0.277777777778}, 0.385902744622},
  {{0.0555555555556 , 0.5 , 0.166666666667}, 0.385902744622},
  {{0.0555555555556 , 0.611111111111 , 0.0555555555556}, 0.385902744622},
  {{0.166666666667 , 0.0555555555556 , 0.5}, 0.385902744622},
  {{0.166666666667 , 0.166666666667 , 0.388888888889}, 0.385902744622},
  {{0.166666666667 , 0.277777777778 , 0.277777777778}, 0.385902744622},
  {{0.166666666667 , 0.388888888889 , 0.166666666667}, 0.385902744622},
  {{0.166666666667 , 0.5 , 0.0555555555556}, 0.385902744622},
  {{0.277777777778 , 0.0555555555556 , 0.388888888889}, 0.385902744622},
  {{0.277777777778 , 0.166666666667 , 0.277777777778}, 0.385902744622},
  {{0.277777777778 , 0.277777777778 , 0.166666666667}, 0.385902744622},
  {{0.277777777778 , 0.388888888889 , 0.0555555555556}, 0.385902744622},
  {{0.388888888889 , 0.0555555555556 , 0.277777777778}, 0.385902744622},
  {{0.388888888889 , 0.166666666667 , 0.166666666667}, 0.385902744622},
  {{0.388888888889 , 0.277777777778 , 0.0555555555556}, 0.385902744622},
  {{0.5 , 0.0555555555556 , 0.166666666667}, 0.385902744622},
  {{0.5 , 0.166666666667 , 0.0555555555556}, 0.385902744622},
  {{0.611111111111 , 0.0555555555556 , 0.0555555555556}, 0.385902744622},
  {{0.0555555555556 , 0.0555555555556 , 0.5}, 0.385902744622},
  {{0.0555555555556 , 0.166666666667 , 0.388888888889}, 0.385902744622},
  {{0.0555555555556 , 0.277777777778 , 0.277777777778}, 0.385902744622},
  {{0.0555555555556 , 0.388888888889 , 0.166666666667}, 0.385902744622},
  {{0.0555555555556 , 0.5 , 0.0555555555556}, 0.385902744622},
  {{0.166666666667 , 0.0555555555556 , 0.388888888889}, 0.385902744622},
  {{0.166666666667 , 0.166666666667 , 0.277777777778}, 0.385902744622},
  {{0.166666666667 , 0.277777777778 , 0.166666666667}, 0.385902744622},
  {{0.166666666667 , 0.388888888889 , 0.0555555555556}, 0.385902744622},
  {{0.277777777778 , 0.0555555555556 , 0.277777777778}, 0.385902744622},
  {{0.277777777778 , 0.166666666667 , 0.166666666667}, 0.385902744622},
  {{0.277777777778 , 0.277777777778 , 0.0555555555556}, 0.385902744622},
  {{0.388888888889 , 0.0555555555556 , 0.166666666667}, 0.385902744622},
  {{0.388888888889 , 0.166666666667 , 0.0555555555556}, 0.385902744622},
  {{0.5 , 0.0555555555556 , 0.0555555555556}, 0.385902744622},
  {{0.0555555555556 , 0.0555555555556 , 0.388888888889}, 0.385902744622},
  {{0.0555555555556 , 0.166666666667 , 0.277777777778}, 0.385902744622},
  {{0.0555555555556 , 0.277777777778 , 0.166666666667}, 0.385902744622},
  {{0.0555555555556 , 0.388888888889 , 0.0555555555556}, 0.385902744622},
  {{0.166666666667 , 0.0555555555556 , 0.277777777778}, 0.385902744622},
  {{0.166666666667 , 0.166666666667 , 0.166666666667}, 0.385902744622},
  {{0.166666666667 , 0.277777777778 , 0.0555555555556}, 0.385902744622},
  {{0.277777777778 , 0.0555555555556 , 0.166666666667}, 0.385902744622},
  {{0.277777777778 , 0.166666666667 , 0.0555555555556}, 0.385902744622},
  {{0.388888888889 , 0.0555555555556 , 0.0555555555556}, 0.385902744622},
  {{0.0555555555556 , 0.0555555555556 , 0.277777777778}, 0.385902744622},
  {{0.0555555555556 , 0.166666666667 , 0.166666666667}, 0.385902744622},
  {{0.0555555555556 , 0.277777777778 , 0.0555555555556}, 0.385902744622},
  {{0.166666666667 , 0.0555555555556 , 0.166666666667}, 0.385902744622},
  {{0.166666666667 , 0.166666666667 , 0.0555555555556}, 0.385902744622},
  {{0.277777777778 , 0.0555555555556 , 0.0555555555556}, 0.385902744622},
  {{0.0555555555556 , 0.0555555555556 , 0.166666666667}, 0.385902744622},
  {{0.0555555555556 , 0.166666666667 , 0.0555555555556}, 0.385902744622},
  {{0.166666666667 , 0.0555555555556 , 0.0555555555556}, 0.385902744622},
  {{0.0555555555556 , 0.0555555555556 , 0.0555555555556}, 0.385902744622},
  {{0.0625 , 0.0625 , 0.8125}, -1.18703229778},
  {{0.0625 , 0.1875 , 0.6875}, -1.18703229778},
  {{0.0625 , 0.3125 , 0.5625}, -1.18703229778},
  {{0.0625 , 0.4375 , 0.4375}, -1.18703229778},
  {{0.0625 , 0.5625 , 0.3125}, -1.18703229778},
  {{0.0625 , 0.6875 , 0.1875}, -1.18703229778},
  {{0.0625 , 0.8125 , 0.0625}, -1.18703229778},
  {{0.1875 , 0.0625 , 0.6875}, -1.18703229778},
  {{0.1875 , 0.1875 , 0.5625}, -1.18703229778},
  {{0.1875 , 0.3125 , 0.4375}, -1.18703229778},
  {{0.1875 , 0.4375 , 0.3125}, -1.18703229778},
  {{0.1875 , 0.5625 , 0.1875}, -1.18703229778},
  {{0.1875 , 0.6875 , 0.0625}, -1.18703229778},
  {{0.3125 , 0.0625 , 0.5625}, -1.18703229778},
  {{0.3125 , 0.1875 , 0.4375}, -1.18703229778},
  {{0.3125 , 0.3125 , 0.3125}, -1.18703229778},
  {{0.3125 , 0.4375 , 0.1875}, -1.18703229778},
  {{0.3125 , 0.5625 , 0.0625}, -1.18703229778},
  {{0.4375 , 0.0625 , 0.4375}, -1.18703229778},
  {{0.4375 , 0.1875 , 0.3125}, -1.18703229778},
  {{0.4375 , 0.3125 , 0.1875}, -1.18703229778},
  {{0.4375 , 0.4375 , 0.0625}, -1.18703229778},
  {{0.5625 , 0.0625 , 0.3125}, -1.18703229778},
  {{0.5625 , 0.1875 , 0.1875}, -1.18703229778},
  {{0.5625 , 0.3125 , 0.0625}, -1.18703229778},
  {{0.6875 , 0.0625 , 0.1875}, -1.18703229778},
  {{0.6875 , 0.1875 , 0.0625}, -1.18703229778},
  {{0.8125 , 0.0625 , 0.0625}, -1.18703229778},
  {{0.0625 , 0.0625 , 0.6875}, -1.18703229778},
  {{0.0625 , 0.1875 , 0.5625}, -1.18703229778},
  {{0.0625 , 0.3125 , 0.4375}, -1.18703229778},
  {{0.0625 , 0.4375 , 0.3125}, -1.18703229778},
  {{0.0625 , 0.5625 , 0.1875}, -1.18703229778},
  {{0.0625 , 0.6875 , 0.0625}, -1.18703229778},
  {{0.1875 , 0.0625 , 0.5625}, -1.18703229778},
  {{0.1875 , 0.1875 , 0.4375}, -1.18703229778},
  {{0.1875 , 0.3125 , 0.3125}, -1.18703229778},
  {{0.1875 , 0.4375 , 0.1875}, -1.18703229778},
  {{0.1875 , 0.5625 , 0.0625}, -1.18703229778},
  {{0.3125 , 0.0625 , 0.4375}, -1.18703229778},
  {{0.3125 , 0.1875 , 0.3125}, -1.18703229778},
  {{0.3125 , 0.3125 , 0.1875}, -1.18703229778},
  {{0.3125 , 0.4375 , 0.0625}, -1.18703229778},
  {{0.4375 , 0.0625 , 0.3125}, -1.18703229778},
  {{0.4375 , 0.1875 , 0.1875}, -1.18703229778},
  {{0.4375 , 0.3125 , 0.0625}, -1.18703229778},
  {{0.5625 , 0.0625 , 0.1875}, -1.18703229778},
  {{0.5625 , 0.1875 , 0.0625}, -1.18703229778},
  {{0.6875 , 0.0625 , 0.0625}, -1.18703229778},
  {{0.0625 , 0.0625 , 0.5625}, -1.18703229778},
  {{0.0625 , 0.1875 , 0.4375}, -1.18703229778},
  {{0.0625 , 0.3125 , 0.3125}, -1.18703229778},
  {{0.0625 , 0.4375 , 0.1875}, -1.18703229778},
  {{0.0625 , 0.5625 , 0.0625}, -1.18703229778},
  {{0.1875 , 0.0625 , 0.4375}, -1.18703229778},
  {{0.1875 , 0.1875 , 0.3125}, -1.18703229778},
  {{0.1875 , 0.3125 , 0.1875}, -1.18703229778},
  {{0.1875 , 0.4375 , 0.0625}, -1.18703229778},
  {{0.3125 , 0.0625 , 0.3125}, -1.18703229778},
  {{0.3125 , 0.1875 , 0.1875}, -1.18703229778},
  {{0.3125 , 0.3125 , 0.0625}, -1.18703229778},
  {{0.4375 , 0.0625 , 0.1875}, -1.18703229778},
  {{0.4375 , 0.1875 , 0.0625}, -1.18703229778},
  {{0.5625 , 0.0625 , 0.0625}, -1.18703229778},
  {{0.0625 , 0.0625 , 0.4375}, -1.18703229778},
  {{0.0625 , 0.1875 , 0.3125}, -1.18703229778},
  {{0.0625 , 0.3125 , 0.1875}, -1.18703229778},
  {{0.0625 , 0.4375 , 0.0625}, -1.18703229778},
  {{0.1875 , 0.0625 , 0.3125}, -1.18703229778},
  {{0.1875 , 0.1875 , 0.1875}, -1.18703229778},
  {{0.1875 , 0.3125 , 0.0625}, -1.18703229778},
  {{0.3125 , 0.0625 , 0.1875}, -1.18703229778},
  {{0.3125 , 0.1875 , 0.0625}, -1.18703229778},
  {{0.4375 , 0.0625 , 0.0625}, -1.18703229778},
  {{0.0625 , 0.0625 , 0.3125}, -1.18703229778},
  {{0.0625 , 0.1875 , 0.1875}, -1.18703229778},
  {{0.0625 , 0.3125 , 0.0625}, -1.18703229778},
  {{0.1875 , 0.0625 , 0.1875}, -1.18703229778},
  {{0.1875 , 0.1875 , 0.0625}, -1.18703229778},
  {{0.3125 , 0.0625 , 0.0625}, -1.18703229778},
  {{0.0625 , 0.0625 , 0.1875}, -1.18703229778},
  {{0.0625 , 0.1875 , 0.0625}, -1.18703229778},
  {{0.1875 , 0.0625 , 0.0625}, -1.18703229778},
  {{0.0625 , 0.0625 , 0.0625}, -1.18703229778},
  {{0.0714285714286 , 0.0714285714286 , 0.785714285714}, 1.36145175725},
  {{0.0714285714286 , 0.214285714286 , 0.642857142857}, 1.36145175725},
  {{0.0714285714286 , 0.357142857143 , 0.5}, 1.36145175725},
  {{0.0714285714286 , 0.5 , 0.357142857143}, 1.36145175725},
  {{0.0714285714286 , 0.642857142857 , 0.214285714286}, 1.36145175725},
  {{0.0714285714286 , 0.785714285714 , 0.0714285714286}, 1.36145175725},
  {{0.214285714286 , 0.0714285714286 , 0.642857142857}, 1.36145175725},
  {{0.214285714286 , 0.214285714286 , 0.5}, 1.36145175725},
  {{0.214285714286 , 0.357142857143 , 0.357142857143}, 1.36145175725},
  {{0.214285714286 , 0.5 , 0.214285714286}, 1.36145175725},
  {{0.214285714286 , 0.642857142857 , 0.0714285714286}, 1.36145175725},
  {{0.357142857143 , 0.0714285714286 , 0.5}, 1.36145175725},
  {{0.357142857143 , 0.214285714286 , 0.357142857143}, 1.36145175725},
  {{0.357142857143 , 0.357142857143 , 0.214285714286}, 1.36145175725},
  {{0.357142857143 , 0.5 , 0.0714285714286}, 1.36145175725},
  {{0.5 , 0.0714285714286 , 0.357142857143}, 1.36145175725},
  {{0.5 , 0.214285714286 , 0.214285714286}, 1.36145175725},
  {{0.5 , 0.357142857143 , 0.0714285714286}, 1.36145175725},
  {{0.642857142857 , 0.0714285714286 , 0.214285714286}, 1.36145175725},
  {{0.642857142857 , 0.214285714286 , 0.0714285714286}, 1.36145175725},
  {{0.785714285714 , 0.0714285714286 , 0.0714285714286}, 1.36145175725},
  {{0.0714285714286 , 0.0714285714286 , 0.642857142857}, 1.36145175725},
  {{0.0714285714286 , 0.214285714286 , 0.5}, 1.36145175725},
  {{0.0714285714286 , 0.357142857143 , 0.357142857143}, 1.36145175725},
  {{0.0714285714286 , 0.5 , 0.214285714286}, 1.36145175725},
  {{0.0714285714286 , 0.642857142857 , 0.0714285714286}, 1.36145175725},
  {{0.214285714286 , 0.0714285714286 , 0.5}, 1.36145175725},
  {{0.214285714286 , 0.214285714286 , 0.357142857143}, 1.36145175725},
  {{0.214285714286 , 0.357142857143 , 0.214285714286}, 1.36145175725},
  {{0.214285714286 , 0.5 , 0.0714285714286}, 1.36145175725},
  {{0.357142857143 , 0.0714285714286 , 0.357142857143}, 1.36145175725},
  {{0.357142857143 , 0.214285714286 , 0.214285714286}, 1.36145175725},
  {{0.357142857143 , 0.357142857143 , 0.0714285714286}, 1.36145175725},
  {{0.5 , 0.0714285714286 , 0.214285714286}, 1.36145175725},
  {{0.5 , 0.214285714286 , 0.0714285714286}, 1.36145175725},
  {{0.642857142857 , 0.0714285714286 , 0.0714285714286}, 1.36145175725},
  {{0.0714285714286 , 0.0714285714286 , 0.5}, 1.36145175725},
  {{0.0714285714286 , 0.214285714286 , 0.357142857143}, 1.36145175725},
  {{0.0714285714286 , 0.357142857143 , 0.214285714286}, 1.36145175725},
  {{0.0714285714286 , 0.5 , 0.0714285714286}, 1.36145175725},
  {{0.214285714286 , 0.0714285714286 , 0.357142857143}, 1.36145175725},
  {{0.214285714286 , 0.214285714286 , 0.214285714286}, 1.36145175725},
  {{0.214285714286 , 0.357142857143 , 0.0714285714286}, 1.36145175725},
  {{0.357142857143 , 0.0714285714286 , 0.214285714286}, 1.36145175725},
  {{0.357142857143 , 0.214285714286 , 0.0714285714286}, 1.36145175725},
  {{0.5 , 0.0714285714286 , 0.0714285714286}, 1.36145175725},
  {{0.0714285714286 , 0.0714285714286 , 0.357142857143}, 1.36145175725},
  {{0.0714285714286 , 0.214285714286 , 0.214285714286}, 1.36145175725},
  {{0.0714285714286 , 0.357142857143 , 0.0714285714286}, 1.36145175725},
  {{0.214285714286 , 0.0714285714286 , 0.214285714286}, 1.36145175725},
  {{0.214285714286 , 0.214285714286 , 0.0714285714286}, 1.36145175725},
  {{0.357142857143 , 0.0714285714286 , 0.0714285714286}, 1.36145175725},
  {{0.0714285714286 , 0.0714285714286 , 0.214285714286}, 1.36145175725},
  {{0.0714285714286 , 0.214285714286 , 0.0714285714286}, 1.36145175725},
  {{0.214285714286 , 0.0714285714286 , 0.0714285714286}, 1.36145175725},
  {{0.0714285714286 , 0.0714285714286 , 0.0714285714286}, 1.36145175725},
  {{0.0833333333333 , 0.0833333333333 , 0.75}, -0.719116312259},
  {{0.0833333333333 , 0.25 , 0.583333333333}, -0.719116312259},
  {{0.0833333333333 , 0.416666666667 , 0.416666666667}, -0.719116312259},
  {{0.0833333333333 , 0.583333333333 , 0.25}, -0.719116312259},
  {{0.0833333333333 , 0.75 , 0.0833333333333}, -0.719116312259},
  {{0.25 , 0.0833333333333 , 0.583333333333}, -0.719116312259},
  {{0.25 , 0.25 , 0.416666666667}, -0.719116312259},
  {{0.25 , 0.416666666667 , 0.25}, -0.719116312259},
  {{0.25 , 0.583333333333 , 0.0833333333333}, -0.719116312259},
  {{0.416666666667 , 0.0833333333333 , 0.416666666667}, -0.719116312259},
  {{0.416666666667 , 0.25 , 0.25}, -0.719116312259},
  {{0.416666666667 , 0.416666666667 , 0.0833333333333}, -0.719116312259},
  {{0.583333333333 , 0.0833333333333 , 0.25}, -0.719116312259},
  {{0.583333333333 , 0.25 , 0.0833333333333}, -0.719116312259},
  {{0.75 , 0.0833333333333 , 0.0833333333333}, -0.719116312259},
  {{0.0833333333333 , 0.0833333333333 , 0.583333333333}, -0.719116312259},
  {{0.0833333333333 , 0.25 , 0.416666666667}, -0.719116312259},
  {{0.0833333333333 , 0.416666666667 , 0.25}, -0.719116312259},
  {{0.0833333333333 , 0.583333333333 , 0.0833333333333}, -0.719116312259},
  {{0.25 , 0.0833333333333 , 0.416666666667}, -0.719116312259},
  {{0.25 , 0.25 , 0.25}, -0.719116312259},
  {{0.25 , 0.416666666667 , 0.0833333333333}, -0.719116312259},
  {{0.416666666667 , 0.0833333333333 , 0.25}, -0.719116312259},
  {{0.416666666667 , 0.25 , 0.0833333333333}, -0.719116312259},
  {{0.583333333333 , 0.0833333333333 , 0.0833333333333}, -0.719116312259},
  {{0.0833333333333 , 0.0833333333333 , 0.416666666667}, -0.719116312259},
  {{0.0833333333333 , 0.25 , 0.25}, -0.719116312259},
  {{0.0833333333333 , 0.416666666667 , 0.0833333333333}, -0.719116312259},
  {{0.25 , 0.0833333333333 , 0.25}, -0.719116312259},
  {{0.25 , 0.25 , 0.0833333333333}, -0.719116312259},
  {{0.416666666667 , 0.0833333333333 , 0.0833333333333}, -0.719116312259},
  {{0.0833333333333 , 0.0833333333333 , 0.25}, -0.719116312259},
  {{0.0833333333333 , 0.25 , 0.0833333333333}, -0.719116312259},
  {{0.25 , 0.0833333333333 , 0.0833333333333}, -0.719116312259},
  {{0.0833333333333 , 0.0833333333333 , 0.0833333333333}, -0.719116312259},
  {{0.1 , 0.1 , 0.7}, 0.175029687465},
  {{0.1 , 0.3 , 0.5}, 0.175029687465},
  {{0.1 , 0.5 , 0.3}, 0.175029687465},
  {{0.1 , 0.7 , 0.1}, 0.175029687465},
  {{0.3 , 0.1 , 0.5}, 0.175029687465},
  {{0.3 , 0.3 , 0.3}, 0.175029687465},
  {{0.3 , 0.5 , 0.1}, 0.175029687465},
  {{0.5 , 0.1 , 0.3}, 0.175029687465},
  {{0.5 , 0.3 , 0.1}, 0.175029687465},
  {{0.7 , 0.1 , 0.1}, 0.175029687465},
  {{0.1 , 0.1 , 0.5}, 0.175029687465},
  {{0.1 , 0.3 , 0.3}, 0.175029687465},
  {{0.1 , 0.5 , 0.1}, 0.175029687465},
  {{0.3 , 0.1 , 0.3}, 0.175029687465},
  {{0.3 , 0.3 , 0.1}, 0.175029687465},
  {{0.5 , 0.1 , 0.1}, 0.175029687465},
  {{0.1 , 0.1 , 0.3}, 0.175029687465},
  {{0.1 , 0.3 , 0.1}, 0.175029687465},
  {{0.3 , 0.1 , 0.1}, 0.175029687465},
  {{0.1 , 0.1 , 0.1}, 0.175029687465},
  {{0.125 , 0.125 , 0.625}, -0.017243267021},
  {{0.125 , 0.375 , 0.375}, -0.017243267021},
  {{0.125 , 0.625 , 0.125}, -0.017243267021},
  {{0.375 , 0.125 , 0.375}, -0.017243267021},
  {{0.375 , 0.375 , 0.125}, -0.017243267021},
  {{0.625 , 0.125 , 0.125}, -0.017243267021},
  {{0.125 , 0.125 , 0.375}, -0.017243267021},
  {{0.125 , 0.375 , 0.125}, -0.017243267021},
  {{0.375 , 0.125 , 0.125}, -0.017243267021},
  {{0.125 , 0.125 , 0.125}, -0.017243267021},
  {{0.166666666667 , 0.166666666667 , 0.5}, 0.000499264407467},
  {{0.166666666667 , 0.5 , 0.166666666667}, 0.000499264407467},
  {{0.5 , 0.166666666667 , 0.166666666667}, 0.000499264407467},
  {{0.166666666667 , 0.166666666667 , 0.166666666667}, 0.000499264407467},
  {{0.25 , 0.25 , 0.25}, -1.954541637e-06}
};

// 130 negative weights, 0 points outside of the tetrahedron 


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 17 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP17Solin[495] = {
  {{0.05 , 0.05 , 0.85}, 0.493238114797},
  {{0.05 , 0.15 , 0.75}, 0.493238114797},
  {{0.05 , 0.25 , 0.65}, 0.493238114797},
  {{0.05 , 0.35 , 0.55}, 0.493238114797},
  {{0.05 , 0.45 , 0.45}, 0.493238114797},
  {{0.05 , 0.55 , 0.35}, 0.493238114797},
  {{0.05 , 0.65 , 0.25}, 0.493238114797},
  {{0.05 , 0.75 , 0.15}, 0.493238114797},
  {{0.05 , 0.85 , 0.05}, 0.493238114797},
  {{0.15 , 0.05 , 0.75}, 0.493238114797},
  {{0.15 , 0.15 , 0.65}, 0.493238114797},
  {{0.15 , 0.25 , 0.55}, 0.493238114797},
  {{0.15 , 0.35 , 0.45}, 0.493238114797},
  {{0.15 , 0.45 , 0.35}, 0.493238114797},
  {{0.15 , 0.55 , 0.25}, 0.493238114797},
  {{0.15 , 0.65 , 0.15}, 0.493238114797},
  {{0.15 , 0.75 , 0.05}, 0.493238114797},
  {{0.25 , 0.05 , 0.65}, 0.493238114797},
  {{0.25 , 0.15 , 0.55}, 0.493238114797},
  {{0.25 , 0.25 , 0.45}, 0.493238114797},
  {{0.25 , 0.35 , 0.35}, 0.493238114797},
  {{0.25 , 0.45 , 0.25}, 0.493238114797},
  {{0.25 , 0.55 , 0.15}, 0.493238114797},
  {{0.25 , 0.65 , 0.05}, 0.493238114797},
  {{0.35 , 0.05 , 0.55}, 0.493238114797},
  {{0.35 , 0.15 , 0.45}, 0.493238114797},
  {{0.35 , 0.25 , 0.35}, 0.493238114797},
  {{0.35 , 0.35 , 0.25}, 0.493238114797},
  {{0.35 , 0.45 , 0.15}, 0.493238114797},
  {{0.35 , 0.55 , 0.05}, 0.493238114797},
  {{0.45 , 0.05 , 0.45}, 0.493238114797},
  {{0.45 , 0.15 , 0.35}, 0.493238114797},
  {{0.45 , 0.25 , 0.25}, 0.493238114797},
  {{0.45 , 0.35 , 0.15}, 0.493238114797},
  {{0.45 , 0.45 , 0.05}, 0.493238114797},
  {{0.55 , 0.05 , 0.35}, 0.493238114797},
  {{0.55 , 0.15 , 0.25}, 0.493238114797},
  {{0.55 , 0.25 , 0.15}, 0.493238114797},
  {{0.55 , 0.35 , 0.05}, 0.493238114797},
  {{0.65 , 0.05 , 0.25}, 0.493238114797},
  {{0.65 , 0.15 , 0.15}, 0.493238114797},
  {{0.65 , 0.25 , 0.05}, 0.493238114797},
  {{0.75 , 0.05 , 0.15}, 0.493238114797},
  {{0.75 , 0.15 , 0.05}, 0.493238114797},
  {{0.85 , 0.05 , 0.05}, 0.493238114797},
  {{0.05 , 0.05 , 0.75}, 0.493238114797},
  {{0.05 , 0.15 , 0.65}, 0.493238114797},
  {{0.05 , 0.25 , 0.55}, 0.493238114797},
  {{0.05 , 0.35 , 0.45}, 0.493238114797},
  {{0.05 , 0.45 , 0.35}, 0.493238114797},
  {{0.05 , 0.55 , 0.25}, 0.493238114797},
  {{0.05 , 0.65 , 0.15}, 0.493238114797},
  {{0.05 , 0.75 , 0.05}, 0.493238114797},
  {{0.15 , 0.05 , 0.65}, 0.493238114797},
  {{0.15 , 0.15 , 0.55}, 0.493238114797},
  {{0.15 , 0.25 , 0.45}, 0.493238114797},
  {{0.15 , 0.35 , 0.35}, 0.493238114797},
  {{0.15 , 0.45 , 0.25}, 0.493238114797},
  {{0.15 , 0.55 , 0.15}, 0.493238114797},
  {{0.15 , 0.65 , 0.05}, 0.493238114797},
  {{0.25 , 0.05 , 0.55}, 0.493238114797},
  {{0.25 , 0.15 , 0.45}, 0.493238114797},
  {{0.25 , 0.25 , 0.35}, 0.493238114797},
  {{0.25 , 0.35 , 0.25}, 0.493238114797},
  {{0.25 , 0.45 , 0.15}, 0.493238114797},
  {{0.25 , 0.55 , 0.05}, 0.493238114797},
  {{0.35 , 0.05 , 0.45}, 0.493238114797},
  {{0.35 , 0.15 , 0.35}, 0.493238114797},
  {{0.35 , 0.25 , 0.25}, 0.493238114797},
  {{0.35 , 0.35 , 0.15}, 0.493238114797},
  {{0.35 , 0.45 , 0.05}, 0.493238114797},
  {{0.45 , 0.05 , 0.35}, 0.493238114797},
  {{0.45 , 0.15 , 0.25}, 0.493238114797},
  {{0.45 , 0.25 , 0.15}, 0.493238114797},
  {{0.45 , 0.35 , 0.05}, 0.493238114797},
  {{0.55 , 0.05 , 0.25}, 0.493238114797},
  {{0.55 , 0.15 , 0.15}, 0.493238114797},
  {{0.55 , 0.25 , 0.05}, 0.493238114797},
  {{0.65 , 0.05 , 0.15}, 0.493238114797},
  {{0.65 , 0.15 , 0.05}, 0.493238114797},
  {{0.75 , 0.05 , 0.05}, 0.493238114797},
  {{0.05 , 0.05 , 0.65}, 0.493238114797},
  {{0.05 , 0.15 , 0.55}, 0.493238114797},
  {{0.05 , 0.25 , 0.45}, 0.493238114797},
  {{0.05 , 0.35 , 0.35}, 0.493238114797},
  {{0.05 , 0.45 , 0.25}, 0.493238114797},
  {{0.05 , 0.55 , 0.15}, 0.493238114797},
  {{0.05 , 0.65 , 0.05}, 0.493238114797},
  {{0.15 , 0.05 , 0.55}, 0.493238114797},
  {{0.15 , 0.15 , 0.45}, 0.493238114797},
  {{0.15 , 0.25 , 0.35}, 0.493238114797},
  {{0.15 , 0.35 , 0.25}, 0.493238114797},
  {{0.15 , 0.45 , 0.15}, 0.493238114797},
  {{0.15 , 0.55 , 0.05}, 0.493238114797},
  {{0.25 , 0.05 , 0.45}, 0.493238114797},
  {{0.25 , 0.15 , 0.35}, 0.493238114797},
  {{0.25 , 0.25 , 0.25}, 0.493238114797},
  {{0.25 , 0.35 , 0.15}, 0.493238114797},
  {{0.25 , 0.45 , 0.05}, 0.493238114797},
  {{0.35 , 0.05 , 0.35}, 0.493238114797},
  {{0.35 , 0.15 , 0.25}, 0.493238114797},
  {{0.35 , 0.25 , 0.15}, 0.493238114797},
  {{0.35 , 0.35 , 0.05}, 0.493238114797},
  {{0.45 , 0.05 , 0.25}, 0.493238114797},
  {{0.45 , 0.15 , 0.15}, 0.493238114797},
  {{0.45 , 0.25 , 0.05}, 0.493238114797},
  {{0.55 , 0.05 , 0.15}, 0.493238114797},
  {{0.55 , 0.15 , 0.05}, 0.493238114797},
  {{0.65 , 0.05 , 0.05}, 0.493238114797},
  {{0.05 , 0.05 , 0.55}, 0.493238114797},
  {{0.05 , 0.15 , 0.45}, 0.493238114797},
  {{0.05 , 0.25 , 0.35}, 0.493238114797},
  {{0.05 , 0.35 , 0.25}, 0.493238114797},
  {{0.05 , 0.45 , 0.15}, 0.493238114797},
  {{0.05 , 0.55 , 0.05}, 0.493238114797},
  {{0.15 , 0.05 , 0.45}, 0.493238114797},
  {{0.15 , 0.15 , 0.35}, 0.493238114797},
  {{0.15 , 0.25 , 0.25}, 0.493238114797},
  {{0.15 , 0.35 , 0.15}, 0.493238114797},
  {{0.15 , 0.45 , 0.05}, 0.493238114797},
  {{0.25 , 0.05 , 0.35}, 0.493238114797},
  {{0.25 , 0.15 , 0.25}, 0.493238114797},
  {{0.25 , 0.25 , 0.15}, 0.493238114797},
  {{0.25 , 0.35 , 0.05}, 0.493238114797},
  {{0.35 , 0.05 , 0.25}, 0.493238114797},
  {{0.35 , 0.15 , 0.15}, 0.493238114797},
  {{0.35 , 0.25 , 0.05}, 0.493238114797},
  {{0.45 , 0.05 , 0.15}, 0.493238114797},
  {{0.45 , 0.15 , 0.05}, 0.493238114797},
  {{0.55 , 0.05 , 0.05}, 0.493238114797},
  {{0.05 , 0.05 , 0.45}, 0.493238114797},
  {{0.05 , 0.15 , 0.35}, 0.493238114797},
  {{0.05 , 0.25 , 0.25}, 0.493238114797},
  {{0.05 , 0.35 , 0.15}, 0.493238114797},
  {{0.05 , 0.45 , 0.05}, 0.493238114797},
  {{0.15 , 0.05 , 0.35}, 0.493238114797},
  {{0.15 , 0.15 , 0.25}, 0.493238114797},
  {{0.15 , 0.25 , 0.15}, 0.493238114797},
  {{0.15 , 0.35 , 0.05}, 0.493238114797},
  {{0.25 , 0.05 , 0.25}, 0.493238114797},
  {{0.25 , 0.15 , 0.15}, 0.493238114797},
  {{0.25 , 0.25 , 0.05}, 0.493238114797},
  {{0.35 , 0.05 , 0.15}, 0.493238114797},
  {{0.35 , 0.15 , 0.05}, 0.493238114797},
  {{0.45 , 0.05 , 0.05}, 0.493238114797},
  {{0.05 , 0.05 , 0.35}, 0.493238114797},
  {{0.05 , 0.15 , 0.25}, 0.493238114797},
  {{0.05 , 0.25 , 0.15}, 0.493238114797},
  {{0.05 , 0.35 , 0.05}, 0.493238114797},
  {{0.15 , 0.05 , 0.25}, 0.493238114797},
  {{0.15 , 0.15 , 0.15}, 0.493238114797},
  {{0.15 , 0.25 , 0.05}, 0.493238114797},
  {{0.25 , 0.05 , 0.15}, 0.493238114797},
  {{0.25 , 0.15 , 0.05}, 0.493238114797},
  {{0.35 , 0.05 , 0.05}, 0.493238114797},
  {{0.05 , 0.05 , 0.25}, 0.493238114797},
  {{0.05 , 0.15 , 0.15}, 0.493238114797},
  {{0.05 , 0.25 , 0.05}, 0.493238114797},
  {{0.15 , 0.05 , 0.15}, 0.493238114797},
  {{0.15 , 0.15 , 0.05}, 0.493238114797},
  {{0.25 , 0.05 , 0.05}, 0.493238114797},
  {{0.05 , 0.05 , 0.15}, 0.493238114797},
  {{0.05 , 0.15 , 0.05}, 0.493238114797},
  {{0.15 , 0.05 , 0.05}, 0.493238114797},
  {{0.05 , 0.05 , 0.05}, 0.493238114797},
  {{0.0555555555556 , 0.0555555555556 , 0.833333333333}, -1.64516433234},
  {{0.0555555555556 , 0.166666666667 , 0.722222222222}, -1.64516433234},
  {{0.0555555555556 , 0.277777777778 , 0.611111111111}, -1.64516433234},
  {{0.0555555555556 , 0.388888888889 , 0.5}, -1.64516433234},
  {{0.0555555555556 , 0.5 , 0.388888888889}, -1.64516433234},
  {{0.0555555555556 , 0.611111111111 , 0.277777777778}, -1.64516433234},
  {{0.0555555555556 , 0.722222222222 , 0.166666666667}, -1.64516433234},
  {{0.0555555555556 , 0.833333333333 , 0.0555555555556}, -1.64516433234},
  {{0.166666666667 , 0.0555555555556 , 0.722222222222}, -1.64516433234},
  {{0.166666666667 , 0.166666666667 , 0.611111111111}, -1.64516433234},
  {{0.166666666667 , 0.277777777778 , 0.5}, -1.64516433234},
  {{0.166666666667 , 0.388888888889 , 0.388888888889}, -1.64516433234},
  {{0.166666666667 , 0.5 , 0.277777777778}, -1.64516433234},
  {{0.166666666667 , 0.611111111111 , 0.166666666667}, -1.64516433234},
  {{0.166666666667 , 0.722222222222 , 0.0555555555556}, -1.64516433234},
  {{0.277777777778 , 0.0555555555556 , 0.611111111111}, -1.64516433234},
  {{0.277777777778 , 0.166666666667 , 0.5}, -1.64516433234},
  {{0.277777777778 , 0.277777777778 , 0.388888888889}, -1.64516433234},
  {{0.277777777778 , 0.388888888889 , 0.277777777778}, -1.64516433234},
  {{0.277777777778 , 0.5 , 0.166666666667}, -1.64516433234},
  {{0.277777777778 , 0.611111111111 , 0.0555555555556}, -1.64516433234},
  {{0.388888888889 , 0.0555555555556 , 0.5}, -1.64516433234},
  {{0.388888888889 , 0.166666666667 , 0.388888888889}, -1.64516433234},
  {{0.388888888889 , 0.277777777778 , 0.277777777778}, -1.64516433234},
  {{0.388888888889 , 0.388888888889 , 0.166666666667}, -1.64516433234},
  {{0.388888888889 , 0.5 , 0.0555555555556}, -1.64516433234},
  {{0.5 , 0.0555555555556 , 0.388888888889}, -1.64516433234},
  {{0.5 , 0.166666666667 , 0.277777777778}, -1.64516433234},
  {{0.5 , 0.277777777778 , 0.166666666667}, -1.64516433234},
  {{0.5 , 0.388888888889 , 0.0555555555556}, -1.64516433234},
  {{0.611111111111 , 0.0555555555556 , 0.277777777778}, -1.64516433234},
  {{0.611111111111 , 0.166666666667 , 0.166666666667}, -1.64516433234},
  {{0.611111111111 , 0.277777777778 , 0.0555555555556}, -1.64516433234},
  {{0.722222222222 , 0.0555555555556 , 0.166666666667}, -1.64516433234},
  {{0.722222222222 , 0.166666666667 , 0.0555555555556}, -1.64516433234},
  {{0.833333333333 , 0.0555555555556 , 0.0555555555556}, -1.64516433234},
  {{0.0555555555556 , 0.0555555555556 , 0.722222222222}, -1.64516433234},
  {{0.0555555555556 , 0.166666666667 , 0.611111111111}, -1.64516433234},
  {{0.0555555555556 , 0.277777777778 , 0.5}, -1.64516433234},
  {{0.0555555555556 , 0.388888888889 , 0.388888888889}, -1.64516433234},
  {{0.0555555555556 , 0.5 , 0.277777777778}, -1.64516433234},
  {{0.0555555555556 , 0.611111111111 , 0.166666666667}, -1.64516433234},
  {{0.0555555555556 , 0.722222222222 , 0.0555555555556}, -1.64516433234},
  {{0.166666666667 , 0.0555555555556 , 0.611111111111}, -1.64516433234},
  {{0.166666666667 , 0.166666666667 , 0.5}, -1.64516433234},
  {{0.166666666667 , 0.277777777778 , 0.388888888889}, -1.64516433234},
  {{0.166666666667 , 0.388888888889 , 0.277777777778}, -1.64516433234},
  {{0.166666666667 , 0.5 , 0.166666666667}, -1.64516433234},
  {{0.166666666667 , 0.611111111111 , 0.0555555555556}, -1.64516433234},
  {{0.277777777778 , 0.0555555555556 , 0.5}, -1.64516433234},
  {{0.277777777778 , 0.166666666667 , 0.388888888889}, -1.64516433234},
  {{0.277777777778 , 0.277777777778 , 0.277777777778}, -1.64516433234},
  {{0.277777777778 , 0.388888888889 , 0.166666666667}, -1.64516433234},
  {{0.277777777778 , 0.5 , 0.0555555555556}, -1.64516433234},
  {{0.388888888889 , 0.0555555555556 , 0.388888888889}, -1.64516433234},
  {{0.388888888889 , 0.166666666667 , 0.277777777778}, -1.64516433234},
  {{0.388888888889 , 0.277777777778 , 0.166666666667}, -1.64516433234},
  {{0.388888888889 , 0.388888888889 , 0.0555555555556}, -1.64516433234},
  {{0.5 , 0.0555555555556 , 0.277777777778}, -1.64516433234},
  {{0.5 , 0.166666666667 , 0.166666666667}, -1.64516433234},
  {{0.5 , 0.277777777778 , 0.0555555555556}, -1.64516433234},
  {{0.611111111111 , 0.0555555555556 , 0.166666666667}, -1.64516433234},
  {{0.611111111111 , 0.166666666667 , 0.0555555555556}, -1.64516433234},
  {{0.722222222222 , 0.0555555555556 , 0.0555555555556}, -1.64516433234},
  {{0.0555555555556 , 0.0555555555556 , 0.611111111111}, -1.64516433234},
  {{0.0555555555556 , 0.166666666667 , 0.5}, -1.64516433234},
  {{0.0555555555556 , 0.277777777778 , 0.388888888889}, -1.64516433234},
  {{0.0555555555556 , 0.388888888889 , 0.277777777778}, -1.64516433234},
  {{0.0555555555556 , 0.5 , 0.166666666667}, -1.64516433234},
  {{0.0555555555556 , 0.611111111111 , 0.0555555555556}, -1.64516433234},
  {{0.166666666667 , 0.0555555555556 , 0.5}, -1.64516433234},
  {{0.166666666667 , 0.166666666667 , 0.388888888889}, -1.64516433234},
  {{0.166666666667 , 0.277777777778 , 0.277777777778}, -1.64516433234},
  {{0.166666666667 , 0.388888888889 , 0.166666666667}, -1.64516433234},
  {{0.166666666667 , 0.5 , 0.0555555555556}, -1.64516433234},
  {{0.277777777778 , 0.0555555555556 , 0.388888888889}, -1.64516433234},
  {{0.277777777778 , 0.166666666667 , 0.277777777778}, -1.64516433234},
  {{0.277777777778 , 0.277777777778 , 0.166666666667}, -1.64516433234},
  {{0.277777777778 , 0.388888888889 , 0.0555555555556}, -1.64516433234},
  {{0.388888888889 , 0.0555555555556 , 0.277777777778}, -1.64516433234},
  {{0.388888888889 , 0.166666666667 , 0.166666666667}, -1.64516433234},
  {{0.388888888889 , 0.277777777778 , 0.0555555555556}, -1.64516433234},
  {{0.5 , 0.0555555555556 , 0.166666666667}, -1.64516433234},
  {{0.5 , 0.166666666667 , 0.0555555555556}, -1.64516433234},
  {{0.611111111111 , 0.0555555555556 , 0.0555555555556}, -1.64516433234},
  {{0.0555555555556 , 0.0555555555556 , 0.5}, -1.64516433234},
  {{0.0555555555556 , 0.166666666667 , 0.388888888889}, -1.64516433234},
  {{0.0555555555556 , 0.277777777778 , 0.277777777778}, -1.64516433234},
  {{0.0555555555556 , 0.388888888889 , 0.166666666667}, -1.64516433234},
  {{0.0555555555556 , 0.5 , 0.0555555555556}, -1.64516433234},
  {{0.166666666667 , 0.0555555555556 , 0.388888888889}, -1.64516433234},
  {{0.166666666667 , 0.166666666667 , 0.277777777778}, -1.64516433234},
  {{0.166666666667 , 0.277777777778 , 0.166666666667}, -1.64516433234},
  {{0.166666666667 , 0.388888888889 , 0.0555555555556}, -1.64516433234},
  {{0.277777777778 , 0.0555555555556 , 0.277777777778}, -1.64516433234},
  {{0.277777777778 , 0.166666666667 , 0.166666666667}, -1.64516433234},
  {{0.277777777778 , 0.277777777778 , 0.0555555555556}, -1.64516433234},
  {{0.388888888889 , 0.0555555555556 , 0.166666666667}, -1.64516433234},
  {{0.388888888889 , 0.166666666667 , 0.0555555555556}, -1.64516433234},
  {{0.5 , 0.0555555555556 , 0.0555555555556}, -1.64516433234},
  {{0.0555555555556 , 0.0555555555556 , 0.388888888889}, -1.64516433234},
  {{0.0555555555556 , 0.166666666667 , 0.277777777778}, -1.64516433234},
  {{0.0555555555556 , 0.277777777778 , 0.166666666667}, -1.64516433234},
  {{0.0555555555556 , 0.388888888889 , 0.0555555555556}, -1.64516433234},
  {{0.166666666667 , 0.0555555555556 , 0.277777777778}, -1.64516433234},
  {{0.166666666667 , 0.166666666667 , 0.166666666667}, -1.64516433234},
  {{0.166666666667 , 0.277777777778 , 0.0555555555556}, -1.64516433234},
  {{0.277777777778 , 0.0555555555556 , 0.166666666667}, -1.64516433234},
  {{0.277777777778 , 0.166666666667 , 0.0555555555556}, -1.64516433234},
  {{0.388888888889 , 0.0555555555556 , 0.0555555555556}, -1.64516433234},
  {{0.0555555555556 , 0.0555555555556 , 0.277777777778}, -1.64516433234},
  {{0.0555555555556 , 0.166666666667 , 0.166666666667}, -1.64516433234},
  {{0.0555555555556 , 0.277777777778 , 0.0555555555556}, -1.64516433234},
  {{0.166666666667 , 0.0555555555556 , 0.166666666667}, -1.64516433234},
  {{0.166666666667 , 0.166666666667 , 0.0555555555556}, -1.64516433234},
  {{0.277777777778 , 0.0555555555556 , 0.0555555555556}, -1.64516433234},
  {{0.0555555555556 , 0.0555555555556 , 0.166666666667}, -1.64516433234},
  {{0.0555555555556 , 0.166666666667 , 0.0555555555556}, -1.64516433234},
  {{0.166666666667 , 0.0555555555556 , 0.0555555555556}, -1.64516433234},
  {{0.0555555555556 , 0.0555555555556 , 0.0555555555556}, -1.64516433234},
  {{0.0625 , 0.0625 , 0.8125}, 2.11027964051},
  {{0.0625 , 0.1875 , 0.6875}, 2.11027964051},
  {{0.0625 , 0.3125 , 0.5625}, 2.11027964051},
  {{0.0625 , 0.4375 , 0.4375}, 2.11027964051},
  {{0.0625 , 0.5625 , 0.3125}, 2.11027964051},
  {{0.0625 , 0.6875 , 0.1875}, 2.11027964051},
  {{0.0625 , 0.8125 , 0.0625}, 2.11027964051},
  {{0.1875 , 0.0625 , 0.6875}, 2.11027964051},
  {{0.1875 , 0.1875 , 0.5625}, 2.11027964051},
  {{0.1875 , 0.3125 , 0.4375}, 2.11027964051},
  {{0.1875 , 0.4375 , 0.3125}, 2.11027964051},
  {{0.1875 , 0.5625 , 0.1875}, 2.11027964051},
  {{0.1875 , 0.6875 , 0.0625}, 2.11027964051},
  {{0.3125 , 0.0625 , 0.5625}, 2.11027964051},
  {{0.3125 , 0.1875 , 0.4375}, 2.11027964051},
  {{0.3125 , 0.3125 , 0.3125}, 2.11027964051},
  {{0.3125 , 0.4375 , 0.1875}, 2.11027964051},
  {{0.3125 , 0.5625 , 0.0625}, 2.11027964051},
  {{0.4375 , 0.0625 , 0.4375}, 2.11027964051},
  {{0.4375 , 0.1875 , 0.3125}, 2.11027964051},
  {{0.4375 , 0.3125 , 0.1875}, 2.11027964051},
  {{0.4375 , 0.4375 , 0.0625}, 2.11027964051},
  {{0.5625 , 0.0625 , 0.3125}, 2.11027964051},
  {{0.5625 , 0.1875 , 0.1875}, 2.11027964051},
  {{0.5625 , 0.3125 , 0.0625}, 2.11027964051},
  {{0.6875 , 0.0625 , 0.1875}, 2.11027964051},
  {{0.6875 , 0.1875 , 0.0625}, 2.11027964051},
  {{0.8125 , 0.0625 , 0.0625}, 2.11027964051},
  {{0.0625 , 0.0625 , 0.6875}, 2.11027964051},
  {{0.0625 , 0.1875 , 0.5625}, 2.11027964051},
  {{0.0625 , 0.3125 , 0.4375}, 2.11027964051},
  {{0.0625 , 0.4375 , 0.3125}, 2.11027964051},
  {{0.0625 , 0.5625 , 0.1875}, 2.11027964051},
  {{0.0625 , 0.6875 , 0.0625}, 2.11027964051},
  {{0.1875 , 0.0625 , 0.5625}, 2.11027964051},
  {{0.1875 , 0.1875 , 0.4375}, 2.11027964051},
  {{0.1875 , 0.3125 , 0.3125}, 2.11027964051},
  {{0.1875 , 0.4375 , 0.1875}, 2.11027964051},
  {{0.1875 , 0.5625 , 0.0625}, 2.11027964051},
  {{0.3125 , 0.0625 , 0.4375}, 2.11027964051},
  {{0.3125 , 0.1875 , 0.3125}, 2.11027964051},
  {{0.3125 , 0.3125 , 0.1875}, 2.11027964051},
  {{0.3125 , 0.4375 , 0.0625}, 2.11027964051},
  {{0.4375 , 0.0625 , 0.3125}, 2.11027964051},
  {{0.4375 , 0.1875 , 0.1875}, 2.11027964051},
  {{0.4375 , 0.3125 , 0.0625}, 2.11027964051},
  {{0.5625 , 0.0625 , 0.1875}, 2.11027964051},
  {{0.5625 , 0.1875 , 0.0625}, 2.11027964051},
  {{0.6875 , 0.0625 , 0.0625}, 2.11027964051},
  {{0.0625 , 0.0625 , 0.5625}, 2.11027964051},
  {{0.0625 , 0.1875 , 0.4375}, 2.11027964051},
  {{0.0625 , 0.3125 , 0.3125}, 2.11027964051},
  {{0.0625 , 0.4375 , 0.1875}, 2.11027964051},
  {{0.0625 , 0.5625 , 0.0625}, 2.11027964051},
  {{0.1875 , 0.0625 , 0.4375}, 2.11027964051},
  {{0.1875 , 0.1875 , 0.3125}, 2.11027964051},
  {{0.1875 , 0.3125 , 0.1875}, 2.11027964051},
  {{0.1875 , 0.4375 , 0.0625}, 2.11027964051},
  {{0.3125 , 0.0625 , 0.3125}, 2.11027964051},
  {{0.3125 , 0.1875 , 0.1875}, 2.11027964051},
  {{0.3125 , 0.3125 , 0.0625}, 2.11027964051},
  {{0.4375 , 0.0625 , 0.1875}, 2.11027964051},
  {{0.4375 , 0.1875 , 0.0625}, 2.11027964051},
  {{0.5625 , 0.0625 , 0.0625}, 2.11027964051},
  {{0.0625 , 0.0625 , 0.4375}, 2.11027964051},
  {{0.0625 , 0.1875 , 0.3125}, 2.11027964051},
  {{0.0625 , 0.3125 , 0.1875}, 2.11027964051},
  {{0.0625 , 0.4375 , 0.0625}, 2.11027964051},
  {{0.1875 , 0.0625 , 0.3125}, 2.11027964051},
  {{0.1875 , 0.1875 , 0.1875}, 2.11027964051},
  {{0.1875 , 0.3125 , 0.0625}, 2.11027964051},
  {{0.3125 , 0.0625 , 0.1875}, 2.11027964051},
  {{0.3125 , 0.1875 , 0.0625}, 2.11027964051},
  {{0.4375 , 0.0625 , 0.0625}, 2.11027964051},
  {{0.0625 , 0.0625 , 0.3125}, 2.11027964051},
  {{0.0625 , 0.1875 , 0.1875}, 2.11027964051},
  {{0.0625 , 0.3125 , 0.0625}, 2.11027964051},
  {{0.1875 , 0.0625 , 0.1875}, 2.11027964051},
  {{0.1875 , 0.1875 , 0.0625}, 2.11027964051},
  {{0.3125 , 0.0625 , 0.0625}, 2.11027964051},
  {{0.0625 , 0.0625 , 0.1875}, 2.11027964051},
  {{0.0625 , 0.1875 , 0.0625}, 2.11027964051},
  {{0.1875 , 0.0625 , 0.0625}, 2.11027964051},
  {{0.0625 , 0.0625 , 0.0625}, 2.11027964051},
  {{0.0714285714286 , 0.0714285714286 , 0.785714285714}, -1.30806149226},
  {{0.0714285714286 , 0.214285714286 , 0.642857142857}, -1.30806149226},
  {{0.0714285714286 , 0.357142857143 , 0.5}, -1.30806149226},
  {{0.0714285714286 , 0.5 , 0.357142857143}, -1.30806149226},
  {{0.0714285714286 , 0.642857142857 , 0.214285714286}, -1.30806149226},
  {{0.0714285714286 , 0.785714285714 , 0.0714285714286}, -1.30806149226},
  {{0.214285714286 , 0.0714285714286 , 0.642857142857}, -1.30806149226},
  {{0.214285714286 , 0.214285714286 , 0.5}, -1.30806149226},
  {{0.214285714286 , 0.357142857143 , 0.357142857143}, -1.30806149226},
  {{0.214285714286 , 0.5 , 0.214285714286}, -1.30806149226},
  {{0.214285714286 , 0.642857142857 , 0.0714285714286}, -1.30806149226},
  {{0.357142857143 , 0.0714285714286 , 0.5}, -1.30806149226},
  {{0.357142857143 , 0.214285714286 , 0.357142857143}, -1.30806149226},
  {{0.357142857143 , 0.357142857143 , 0.214285714286}, -1.30806149226},
  {{0.357142857143 , 0.5 , 0.0714285714286}, -1.30806149226},
  {{0.5 , 0.0714285714286 , 0.357142857143}, -1.30806149226},
  {{0.5 , 0.214285714286 , 0.214285714286}, -1.30806149226},
  {{0.5 , 0.357142857143 , 0.0714285714286}, -1.30806149226},
  {{0.642857142857 , 0.0714285714286 , 0.214285714286}, -1.30806149226},
  {{0.642857142857 , 0.214285714286 , 0.0714285714286}, -1.30806149226},
  {{0.785714285714 , 0.0714285714286 , 0.0714285714286}, -1.30806149226},
  {{0.0714285714286 , 0.0714285714286 , 0.642857142857}, -1.30806149226},
  {{0.0714285714286 , 0.214285714286 , 0.5}, -1.30806149226},
  {{0.0714285714286 , 0.357142857143 , 0.357142857143}, -1.30806149226},
  {{0.0714285714286 , 0.5 , 0.214285714286}, -1.30806149226},
  {{0.0714285714286 , 0.642857142857 , 0.0714285714286}, -1.30806149226},
  {{0.214285714286 , 0.0714285714286 , 0.5}, -1.30806149226},
  {{0.214285714286 , 0.214285714286 , 0.357142857143}, -1.30806149226},
  {{0.214285714286 , 0.357142857143 , 0.214285714286}, -1.30806149226},
  {{0.214285714286 , 0.5 , 0.0714285714286}, -1.30806149226},
  {{0.357142857143 , 0.0714285714286 , 0.357142857143}, -1.30806149226},
  {{0.357142857143 , 0.214285714286 , 0.214285714286}, -1.30806149226},
  {{0.357142857143 , 0.357142857143 , 0.0714285714286}, -1.30806149226},
  {{0.5 , 0.0714285714286 , 0.214285714286}, -1.30806149226},
  {{0.5 , 0.214285714286 , 0.0714285714286}, -1.30806149226},
  {{0.642857142857 , 0.0714285714286 , 0.0714285714286}, -1.30806149226},
  {{0.0714285714286 , 0.0714285714286 , 0.5}, -1.30806149226},
  {{0.0714285714286 , 0.214285714286 , 0.357142857143}, -1.30806149226},
  {{0.0714285714286 , 0.357142857143 , 0.214285714286}, -1.30806149226},
  {{0.0714285714286 , 0.5 , 0.0714285714286}, -1.30806149226},
  {{0.214285714286 , 0.0714285714286 , 0.357142857143}, -1.30806149226},
  {{0.214285714286 , 0.214285714286 , 0.214285714286}, -1.30806149226},
  {{0.214285714286 , 0.357142857143 , 0.0714285714286}, -1.30806149226},
  {{0.357142857143 , 0.0714285714286 , 0.214285714286}, -1.30806149226},
  {{0.357142857143 , 0.214285714286 , 0.0714285714286}, -1.30806149226},
  {{0.5 , 0.0714285714286 , 0.0714285714286}, -1.30806149226},
  {{0.0714285714286 , 0.0714285714286 , 0.357142857143}, -1.30806149226},
  {{0.0714285714286 , 0.214285714286 , 0.214285714286}, -1.30806149226},
  {{0.0714285714286 , 0.357142857143 , 0.0714285714286}, -1.30806149226},
  {{0.214285714286 , 0.0714285714286 , 0.214285714286}, -1.30806149226},
  {{0.214285714286 , 0.214285714286 , 0.0714285714286}, -1.30806149226},
  {{0.357142857143 , 0.0714285714286 , 0.0714285714286}, -1.30806149226},
  {{0.0714285714286 , 0.0714285714286 , 0.214285714286}, -1.30806149226},
  {{0.0714285714286 , 0.214285714286 , 0.0714285714286}, -1.30806149226},
  {{0.214285714286 , 0.0714285714286 , 0.0714285714286}, -1.30806149226},
  {{0.0714285714286 , 0.0714285714286 , 0.0714285714286}, -1.30806149226},
  {{0.0833333333333 , 0.0833333333333 , 0.75}, 0.404502925646},
  {{0.0833333333333 , 0.25 , 0.583333333333}, 0.404502925646},
  {{0.0833333333333 , 0.416666666667 , 0.416666666667}, 0.404502925646},
  {{0.0833333333333 , 0.583333333333 , 0.25}, 0.404502925646},
  {{0.0833333333333 , 0.75 , 0.0833333333333}, 0.404502925646},
  {{0.25 , 0.0833333333333 , 0.583333333333}, 0.404502925646},
  {{0.25 , 0.25 , 0.416666666667}, 0.404502925646},
  {{0.25 , 0.416666666667 , 0.25}, 0.404502925646},
  {{0.25 , 0.583333333333 , 0.0833333333333}, 0.404502925646},
  {{0.416666666667 , 0.0833333333333 , 0.416666666667}, 0.404502925646},
  {{0.416666666667 , 0.25 , 0.25}, 0.404502925646},
  {{0.416666666667 , 0.416666666667 , 0.0833333333333}, 0.404502925646},
  {{0.583333333333 , 0.0833333333333 , 0.25}, 0.404502925646},
  {{0.583333333333 , 0.25 , 0.0833333333333}, 0.404502925646},
  {{0.75 , 0.0833333333333 , 0.0833333333333}, 0.404502925646},
  {{0.0833333333333 , 0.0833333333333 , 0.583333333333}, 0.404502925646},
  {{0.0833333333333 , 0.25 , 0.416666666667}, 0.404502925646},
  {{0.0833333333333 , 0.416666666667 , 0.25}, 0.404502925646},
  {{0.0833333333333 , 0.583333333333 , 0.0833333333333}, 0.404502925646},
  {{0.25 , 0.0833333333333 , 0.416666666667}, 0.404502925646},
  {{0.25 , 0.25 , 0.25}, 0.404502925646},
  {{0.25 , 0.416666666667 , 0.0833333333333}, 0.404502925646},
  {{0.416666666667 , 0.0833333333333 , 0.25}, 0.404502925646},
  {{0.416666666667 , 0.25 , 0.0833333333333}, 0.404502925646},
  {{0.583333333333 , 0.0833333333333 , 0.0833333333333}, 0.404502925646},
  {{0.0833333333333 , 0.0833333333333 , 0.416666666667}, 0.404502925646},
  {{0.0833333333333 , 0.25 , 0.25}, 0.404502925646},
  {{0.0833333333333 , 0.416666666667 , 0.0833333333333}, 0.404502925646},
  {{0.25 , 0.0833333333333 , 0.25}, 0.404502925646},
  {{0.25 , 0.25 , 0.0833333333333}, 0.404502925646},
  {{0.416666666667 , 0.0833333333333 , 0.0833333333333}, 0.404502925646},
  {{0.0833333333333 , 0.0833333333333 , 0.25}, 0.404502925646},
  {{0.0833333333333 , 0.25 , 0.0833333333333}, 0.404502925646},
  {{0.25 , 0.0833333333333 , 0.0833333333333}, 0.404502925646},
  {{0.0833333333333 , 0.0833333333333 , 0.0833333333333}, 0.404502925646},
  {{0.1 , 0.1 , 0.7}, -0.0583432291551},
  {{0.1 , 0.3 , 0.5}, -0.0583432291551},
  {{0.1 , 0.5 , 0.3}, -0.0583432291551},
  {{0.1 , 0.7 , 0.1}, -0.0583432291551},
  {{0.3 , 0.1 , 0.5}, -0.0583432291551},
  {{0.3 , 0.3 , 0.3}, -0.0583432291551},
  {{0.3 , 0.5 , 0.1}, -0.0583432291551},
  {{0.5 , 0.1 , 0.3}, -0.0583432291551},
  {{0.5 , 0.3 , 0.1}, -0.0583432291551},
  {{0.7 , 0.1 , 0.1}, -0.0583432291551},
  {{0.1 , 0.1 , 0.5}, -0.0583432291551},
  {{0.1 , 0.3 , 0.3}, -0.0583432291551},
  {{0.1 , 0.5 , 0.1}, -0.0583432291551},
  {{0.3 , 0.1 , 0.3}, -0.0583432291551},
  {{0.3 , 0.3 , 0.1}, -0.0583432291551},
  {{0.5 , 0.1 , 0.1}, -0.0583432291551},
  {{0.1 , 0.1 , 0.3}, -0.0583432291551},
  {{0.1 , 0.3 , 0.1}, -0.0583432291551},
  {{0.3 , 0.1 , 0.1}, -0.0583432291551},
  {{0.1 , 0.1 , 0.1}, -0.0583432291551},
  {{0.125 , 0.125 , 0.625}, 0.00328443181353},
  {{0.125 , 0.375 , 0.375}, 0.00328443181353},
  {{0.125 , 0.625 , 0.125}, 0.00328443181353},
  {{0.375 , 0.125 , 0.375}, 0.00328443181353},
  {{0.375 , 0.375 , 0.125}, 0.00328443181353},
  {{0.625 , 0.125 , 0.125}, 0.00328443181353},
  {{0.125 , 0.125 , 0.375}, 0.00328443181353},
  {{0.125 , 0.375 , 0.125}, 0.00328443181353},
  {{0.375 , 0.125 , 0.125}, 0.00328443181353},
  {{0.125 , 0.125 , 0.125}, 0.00328443181353},
  {{0.166666666667 , 0.166666666667 , 0.5}, -4.93777985408e-05},
  {{0.166666666667 , 0.5 , 0.166666666667}, -4.93777985408e-05},
  {{0.5 , 0.166666666667 , 0.166666666667}, -4.93777985408e-05},
  {{0.166666666667 , 0.166666666667 , 0.166666666667}, -4.93777985408e-05},
  {{0.25 , 0.25 , 0.25}, 8.143923525e-08}
};

// 200 negative weights, 0 points outside of the tetrahedron 


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 19 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP19Solin[715] = {
  {{0.0454545454545 , 0.0454545454545 , 0.863636363636}, 0.652943603366},
  {{0.0454545454545 , 0.136363636364 , 0.772727272727}, 0.652943603366},
  {{0.0454545454545 , 0.227272727273 , 0.681818181818}, 0.652943603366},
  {{0.0454545454545 , 0.318181818182 , 0.590909090909}, 0.652943603366},
  {{0.0454545454545 , 0.409090909091 , 0.5}, 0.652943603366},
  {{0.0454545454545 , 0.5 , 0.409090909091}, 0.652943603366},
  {{0.0454545454545 , 0.590909090909 , 0.318181818182}, 0.652943603366},
  {{0.0454545454545 , 0.681818181818 , 0.227272727273}, 0.652943603366},
  {{0.0454545454545 , 0.772727272727 , 0.136363636364}, 0.652943603366},
  {{0.0454545454545 , 0.863636363636 , 0.0454545454545}, 0.652943603366},
  {{0.136363636364 , 0.0454545454545 , 0.772727272727}, 0.652943603366},
  {{0.136363636364 , 0.136363636364 , 0.681818181818}, 0.652943603366},
  {{0.136363636364 , 0.227272727273 , 0.590909090909}, 0.652943603366},
  {{0.136363636364 , 0.318181818182 , 0.5}, 0.652943603366},
  {{0.136363636364 , 0.409090909091 , 0.409090909091}, 0.652943603366},
  {{0.136363636364 , 0.5 , 0.318181818182}, 0.652943603366},
  {{0.136363636364 , 0.590909090909 , 0.227272727273}, 0.652943603366},
  {{0.136363636364 , 0.681818181818 , 0.136363636364}, 0.652943603366},
  {{0.136363636364 , 0.772727272727 , 0.0454545454545}, 0.652943603366},
  {{0.227272727273 , 0.0454545454545 , 0.681818181818}, 0.652943603366},
  {{0.227272727273 , 0.136363636364 , 0.590909090909}, 0.652943603366},
  {{0.227272727273 , 0.227272727273 , 0.5}, 0.652943603366},
  {{0.227272727273 , 0.318181818182 , 0.409090909091}, 0.652943603366},
  {{0.227272727273 , 0.409090909091 , 0.318181818182}, 0.652943603366},
  {{0.227272727273 , 0.5 , 0.227272727273}, 0.652943603366},
  {{0.227272727273 , 0.590909090909 , 0.136363636364}, 0.652943603366},
  {{0.227272727273 , 0.681818181818 , 0.0454545454545}, 0.652943603366},
  {{0.318181818182 , 0.0454545454545 , 0.590909090909}, 0.652943603366},
  {{0.318181818182 , 0.136363636364 , 0.5}, 0.652943603366},
  {{0.318181818182 , 0.227272727273 , 0.409090909091}, 0.652943603366},
  {{0.318181818182 , 0.318181818182 , 0.318181818182}, 0.652943603366},
  {{0.318181818182 , 0.409090909091 , 0.227272727273}, 0.652943603366},
  {{0.318181818182 , 0.5 , 0.136363636364}, 0.652943603366},
  {{0.318181818182 , 0.590909090909 , 0.0454545454545}, 0.652943603366},
  {{0.409090909091 , 0.0454545454545 , 0.5}, 0.652943603366},
  {{0.409090909091 , 0.136363636364 , 0.409090909091}, 0.652943603366},
  {{0.409090909091 , 0.227272727273 , 0.318181818182}, 0.652943603366},
  {{0.409090909091 , 0.318181818182 , 0.227272727273}, 0.652943603366},
  {{0.409090909091 , 0.409090909091 , 0.136363636364}, 0.652943603366},
  {{0.409090909091 , 0.5 , 0.0454545454545}, 0.652943603366},
  {{0.5 , 0.0454545454545 , 0.409090909091}, 0.652943603366},
  {{0.5 , 0.136363636364 , 0.318181818182}, 0.652943603366},
  {{0.5 , 0.227272727273 , 0.227272727273}, 0.652943603366},
  {{0.5 , 0.318181818182 , 0.136363636364}, 0.652943603366},
  {{0.5 , 0.409090909091 , 0.0454545454545}, 0.652943603366},
  {{0.590909090909 , 0.0454545454545 , 0.318181818182}, 0.652943603366},
  {{0.590909090909 , 0.136363636364 , 0.227272727273}, 0.652943603366},
  {{0.590909090909 , 0.227272727273 , 0.136363636364}, 0.652943603366},
  {{0.590909090909 , 0.318181818182 , 0.0454545454545}, 0.652943603366},
  {{0.681818181818 , 0.0454545454545 , 0.227272727273}, 0.652943603366},
  {{0.681818181818 , 0.136363636364 , 0.136363636364}, 0.652943603366},
  {{0.681818181818 , 0.227272727273 , 0.0454545454545}, 0.652943603366},
  {{0.772727272727 , 0.0454545454545 , 0.136363636364}, 0.652943603366},
  {{0.772727272727 , 0.136363636364 , 0.0454545454545}, 0.652943603366},
  {{0.863636363636 , 0.0454545454545 , 0.0454545454545}, 0.652943603366},
  {{0.0454545454545 , 0.0454545454545 , 0.772727272727}, 0.652943603366},
  {{0.0454545454545 , 0.136363636364 , 0.681818181818}, 0.652943603366},
  {{0.0454545454545 , 0.227272727273 , 0.590909090909}, 0.652943603366},
  {{0.0454545454545 , 0.318181818182 , 0.5}, 0.652943603366},
  {{0.0454545454545 , 0.409090909091 , 0.409090909091}, 0.652943603366},
  {{0.0454545454545 , 0.5 , 0.318181818182}, 0.652943603366},
  {{0.0454545454545 , 0.590909090909 , 0.227272727273}, 0.652943603366},
  {{0.0454545454545 , 0.681818181818 , 0.136363636364}, 0.652943603366},
  {{0.0454545454545 , 0.772727272727 , 0.0454545454545}, 0.652943603366},
  {{0.136363636364 , 0.0454545454545 , 0.681818181818}, 0.652943603366},
  {{0.136363636364 , 0.136363636364 , 0.590909090909}, 0.652943603366},
  {{0.136363636364 , 0.227272727273 , 0.5}, 0.652943603366},
  {{0.136363636364 , 0.318181818182 , 0.409090909091}, 0.652943603366},
  {{0.136363636364 , 0.409090909091 , 0.318181818182}, 0.652943603366},
  {{0.136363636364 , 0.5 , 0.227272727273}, 0.652943603366},
  {{0.136363636364 , 0.590909090909 , 0.136363636364}, 0.652943603366},
  {{0.136363636364 , 0.681818181818 , 0.0454545454545}, 0.652943603366},
  {{0.227272727273 , 0.0454545454545 , 0.590909090909}, 0.652943603366},
  {{0.227272727273 , 0.136363636364 , 0.5}, 0.652943603366},
  {{0.227272727273 , 0.227272727273 , 0.409090909091}, 0.652943603366},
  {{0.227272727273 , 0.318181818182 , 0.318181818182}, 0.652943603366},
  {{0.227272727273 , 0.409090909091 , 0.227272727273}, 0.652943603366},
  {{0.227272727273 , 0.5 , 0.136363636364}, 0.652943603366},
  {{0.227272727273 , 0.590909090909 , 0.0454545454545}, 0.652943603366},
  {{0.318181818182 , 0.0454545454545 , 0.5}, 0.652943603366},
  {{0.318181818182 , 0.136363636364 , 0.409090909091}, 0.652943603366},
  {{0.318181818182 , 0.227272727273 , 0.318181818182}, 0.652943603366},
  {{0.318181818182 , 0.318181818182 , 0.227272727273}, 0.652943603366},
  {{0.318181818182 , 0.409090909091 , 0.136363636364}, 0.652943603366},
  {{0.318181818182 , 0.5 , 0.0454545454545}, 0.652943603366},
  {{0.409090909091 , 0.0454545454545 , 0.409090909091}, 0.652943603366},
  {{0.409090909091 , 0.136363636364 , 0.318181818182}, 0.652943603366},
  {{0.409090909091 , 0.227272727273 , 0.227272727273}, 0.652943603366},
  {{0.409090909091 , 0.318181818182 , 0.136363636364}, 0.652943603366},
  {{0.409090909091 , 0.409090909091 , 0.0454545454545}, 0.652943603366},
  {{0.5 , 0.0454545454545 , 0.318181818182}, 0.652943603366},
  {{0.5 , 0.136363636364 , 0.227272727273}, 0.652943603366},
  {{0.5 , 0.227272727273 , 0.136363636364}, 0.652943603366},
  {{0.5 , 0.318181818182 , 0.0454545454545}, 0.652943603366},
  {{0.590909090909 , 0.0454545454545 , 0.227272727273}, 0.652943603366},
  {{0.590909090909 , 0.136363636364 , 0.136363636364}, 0.652943603366},
  {{0.590909090909 , 0.227272727273 , 0.0454545454545}, 0.652943603366},
  {{0.681818181818 , 0.0454545454545 , 0.136363636364}, 0.652943603366},
  {{0.681818181818 , 0.136363636364 , 0.0454545454545}, 0.652943603366},
  {{0.772727272727 , 0.0454545454545 , 0.0454545454545}, 0.652943603366},
  {{0.0454545454545 , 0.0454545454545 , 0.681818181818}, 0.652943603366},
  {{0.0454545454545 , 0.136363636364 , 0.590909090909}, 0.652943603366},
  {{0.0454545454545 , 0.227272727273 , 0.5}, 0.652943603366},
  {{0.0454545454545 , 0.318181818182 , 0.409090909091}, 0.652943603366},
  {{0.0454545454545 , 0.409090909091 , 0.318181818182}, 0.652943603366},
  {{0.0454545454545 , 0.5 , 0.227272727273}, 0.652943603366},
  {{0.0454545454545 , 0.590909090909 , 0.136363636364}, 0.652943603366},
  {{0.0454545454545 , 0.681818181818 , 0.0454545454545}, 0.652943603366},
  {{0.136363636364 , 0.0454545454545 , 0.590909090909}, 0.652943603366},
  {{0.136363636364 , 0.136363636364 , 0.5}, 0.652943603366},
  {{0.136363636364 , 0.227272727273 , 0.409090909091}, 0.652943603366},
  {{0.136363636364 , 0.318181818182 , 0.318181818182}, 0.652943603366},
  {{0.136363636364 , 0.409090909091 , 0.227272727273}, 0.652943603366},
  {{0.136363636364 , 0.5 , 0.136363636364}, 0.652943603366},
  {{0.136363636364 , 0.590909090909 , 0.0454545454545}, 0.652943603366},
  {{0.227272727273 , 0.0454545454545 , 0.5}, 0.652943603366},
  {{0.227272727273 , 0.136363636364 , 0.409090909091}, 0.652943603366},
  {{0.227272727273 , 0.227272727273 , 0.318181818182}, 0.652943603366},
  {{0.227272727273 , 0.318181818182 , 0.227272727273}, 0.652943603366},
  {{0.227272727273 , 0.409090909091 , 0.136363636364}, 0.652943603366},
  {{0.227272727273 , 0.5 , 0.0454545454545}, 0.652943603366},
  {{0.318181818182 , 0.0454545454545 , 0.409090909091}, 0.652943603366},
  {{0.318181818182 , 0.136363636364 , 0.318181818182}, 0.652943603366},
  {{0.318181818182 , 0.227272727273 , 0.227272727273}, 0.652943603366},
  {{0.318181818182 , 0.318181818182 , 0.136363636364}, 0.652943603366},
  {{0.318181818182 , 0.409090909091 , 0.0454545454545}, 0.652943603366},
  {{0.409090909091 , 0.0454545454545 , 0.318181818182}, 0.652943603366},
  {{0.409090909091 , 0.136363636364 , 0.227272727273}, 0.652943603366},
  {{0.409090909091 , 0.227272727273 , 0.136363636364}, 0.652943603366},
  {{0.409090909091 , 0.318181818182 , 0.0454545454545}, 0.652943603366},
  {{0.5 , 0.0454545454545 , 0.227272727273}, 0.652943603366},
  {{0.5 , 0.136363636364 , 0.136363636364}, 0.652943603366},
  {{0.5 , 0.227272727273 , 0.0454545454545}, 0.652943603366},
  {{0.590909090909 , 0.0454545454545 , 0.136363636364}, 0.652943603366},
  {{0.590909090909 , 0.136363636364 , 0.0454545454545}, 0.652943603366},
  {{0.681818181818 , 0.0454545454545 , 0.0454545454545}, 0.652943603366},
  {{0.0454545454545 , 0.0454545454545 , 0.590909090909}, 0.652943603366},
  {{0.0454545454545 , 0.136363636364 , 0.5}, 0.652943603366},
  {{0.0454545454545 , 0.227272727273 , 0.409090909091}, 0.652943603366},
  {{0.0454545454545 , 0.318181818182 , 0.318181818182}, 0.652943603366},
  {{0.0454545454545 , 0.409090909091 , 0.227272727273}, 0.652943603366},
  {{0.0454545454545 , 0.5 , 0.136363636364}, 0.652943603366},
  {{0.0454545454545 , 0.590909090909 , 0.0454545454545}, 0.652943603366},
  {{0.136363636364 , 0.0454545454545 , 0.5}, 0.652943603366},
  {{0.136363636364 , 0.136363636364 , 0.409090909091}, 0.652943603366},
  {{0.136363636364 , 0.227272727273 , 0.318181818182}, 0.652943603366},
  {{0.136363636364 , 0.318181818182 , 0.227272727273}, 0.652943603366},
  {{0.136363636364 , 0.409090909091 , 0.136363636364}, 0.652943603366},
  {{0.136363636364 , 0.5 , 0.0454545454545}, 0.652943603366},
  {{0.227272727273 , 0.0454545454545 , 0.409090909091}, 0.652943603366},
  {{0.227272727273 , 0.136363636364 , 0.318181818182}, 0.652943603366},
  {{0.227272727273 , 0.227272727273 , 0.227272727273}, 0.652943603366},
  {{0.227272727273 , 0.318181818182 , 0.136363636364}, 0.652943603366},
  {{0.227272727273 , 0.409090909091 , 0.0454545454545}, 0.652943603366},
  {{0.318181818182 , 0.0454545454545 , 0.318181818182}, 0.652943603366},
  {{0.318181818182 , 0.136363636364 , 0.227272727273}, 0.652943603366},
  {{0.318181818182 , 0.227272727273 , 0.136363636364}, 0.652943603366},
  {{0.318181818182 , 0.318181818182 , 0.0454545454545}, 0.652943603366},
  {{0.409090909091 , 0.0454545454545 , 0.227272727273}, 0.652943603366},
  {{0.409090909091 , 0.136363636364 , 0.136363636364}, 0.652943603366},
  {{0.409090909091 , 0.227272727273 , 0.0454545454545}, 0.652943603366},
  {{0.5 , 0.0454545454545 , 0.136363636364}, 0.652943603366},
  {{0.5 , 0.136363636364 , 0.0454545454545}, 0.652943603366},
  {{0.590909090909 , 0.0454545454545 , 0.0454545454545}, 0.652943603366},
  {{0.0454545454545 , 0.0454545454545 , 0.5}, 0.652943603366},
  {{0.0454545454545 , 0.136363636364 , 0.409090909091}, 0.652943603366},
  {{0.0454545454545 , 0.227272727273 , 0.318181818182}, 0.652943603366},
  {{0.0454545454545 , 0.318181818182 , 0.227272727273}, 0.652943603366},
  {{0.0454545454545 , 0.409090909091 , 0.136363636364}, 0.652943603366},
  {{0.0454545454545 , 0.5 , 0.0454545454545}, 0.652943603366},
  {{0.136363636364 , 0.0454545454545 , 0.409090909091}, 0.652943603366},
  {{0.136363636364 , 0.136363636364 , 0.318181818182}, 0.652943603366},
  {{0.136363636364 , 0.227272727273 , 0.227272727273}, 0.652943603366},
  {{0.136363636364 , 0.318181818182 , 0.136363636364}, 0.652943603366},
  {{0.136363636364 , 0.409090909091 , 0.0454545454545}, 0.652943603366},
  {{0.227272727273 , 0.0454545454545 , 0.318181818182}, 0.652943603366},
  {{0.227272727273 , 0.136363636364 , 0.227272727273}, 0.652943603366},
  {{0.227272727273 , 0.227272727273 , 0.136363636364}, 0.652943603366},
  {{0.227272727273 , 0.318181818182 , 0.0454545454545}, 0.652943603366},
  {{0.318181818182 , 0.0454545454545 , 0.227272727273}, 0.652943603366},
  {{0.318181818182 , 0.136363636364 , 0.136363636364}, 0.652943603366},
  {{0.318181818182 , 0.227272727273 , 0.0454545454545}, 0.652943603366},
  {{0.409090909091 , 0.0454545454545 , 0.136363636364}, 0.652943603366},
  {{0.409090909091 , 0.136363636364 , 0.0454545454545}, 0.652943603366},
  {{0.5 , 0.0454545454545 , 0.0454545454545}, 0.652943603366},
  {{0.0454545454545 , 0.0454545454545 , 0.409090909091}, 0.652943603366},
  {{0.0454545454545 , 0.136363636364 , 0.318181818182}, 0.652943603366},
  {{0.0454545454545 , 0.227272727273 , 0.227272727273}, 0.652943603366},
  {{0.0454545454545 , 0.318181818182 , 0.136363636364}, 0.652943603366},
  {{0.0454545454545 , 0.409090909091 , 0.0454545454545}, 0.652943603366},
  {{0.136363636364 , 0.0454545454545 , 0.318181818182}, 0.652943603366},
  {{0.136363636364 , 0.136363636364 , 0.227272727273}, 0.652943603366},
  {{0.136363636364 , 0.227272727273 , 0.136363636364}, 0.652943603366},
  {{0.136363636364 , 0.318181818182 , 0.0454545454545}, 0.652943603366},
  {{0.227272727273 , 0.0454545454545 , 0.227272727273}, 0.652943603366},
  {{0.227272727273 , 0.136363636364 , 0.136363636364}, 0.652943603366},
  {{0.227272727273 , 0.227272727273 , 0.0454545454545}, 0.652943603366},
  {{0.318181818182 , 0.0454545454545 , 0.136363636364}, 0.652943603366},
  {{0.318181818182 , 0.136363636364 , 0.0454545454545}, 0.652943603366},
  {{0.409090909091 , 0.0454545454545 , 0.0454545454545}, 0.652943603366},
  {{0.0454545454545 , 0.0454545454545 , 0.318181818182}, 0.652943603366},
  {{0.0454545454545 , 0.136363636364 , 0.227272727273}, 0.652943603366},
  {{0.0454545454545 , 0.227272727273 , 0.136363636364}, 0.652943603366},
  {{0.0454545454545 , 0.318181818182 , 0.0454545454545}, 0.652943603366},
  {{0.136363636364 , 0.0454545454545 , 0.227272727273}, 0.652943603366},
  {{0.136363636364 , 0.136363636364 , 0.136363636364}, 0.652943603366},
  {{0.136363636364 , 0.227272727273 , 0.0454545454545}, 0.652943603366},
  {{0.227272727273 , 0.0454545454545 , 0.136363636364}, 0.652943603366},
  {{0.227272727273 , 0.136363636364 , 0.0454545454545}, 0.652943603366},
  {{0.318181818182 , 0.0454545454545 , 0.0454545454545}, 0.652943603366},
  {{0.0454545454545 , 0.0454545454545 , 0.227272727273}, 0.652943603366},
  {{0.0454545454545 , 0.136363636364 , 0.136363636364}, 0.652943603366},
  {{0.0454545454545 , 0.227272727273 , 0.0454545454545}, 0.652943603366},
  {{0.136363636364 , 0.0454545454545 , 0.136363636364}, 0.652943603366},
  {{0.136363636364 , 0.136363636364 , 0.0454545454545}, 0.652943603366},
  {{0.227272727273 , 0.0454545454545 , 0.0454545454545}, 0.652943603366},
  {{0.0454545454545 , 0.0454545454545 , 0.136363636364}, 0.652943603366},
  {{0.0454545454545 , 0.136363636364 , 0.0454545454545}, 0.652943603366},
  {{0.136363636364 , 0.0454545454545 , 0.0454545454545}, 0.652943603366},
  {{0.0454545454545 , 0.0454545454545 , 0.0454545454545}, 0.652943603366},
  {{0.05 , 0.05 , 0.85}, -2.34875292761},
  {{0.05 , 0.15 , 0.75}, -2.34875292761},
  {{0.05 , 0.25 , 0.65}, -2.34875292761},
  {{0.05 , 0.35 , 0.55}, -2.34875292761},
  {{0.05 , 0.45 , 0.45}, -2.34875292761},
  {{0.05 , 0.55 , 0.35}, -2.34875292761},
  {{0.05 , 0.65 , 0.25}, -2.34875292761},
  {{0.05 , 0.75 , 0.15}, -2.34875292761},
  {{0.05 , 0.85 , 0.05}, -2.34875292761},
  {{0.15 , 0.05 , 0.75}, -2.34875292761},
  {{0.15 , 0.15 , 0.65}, -2.34875292761},
  {{0.15 , 0.25 , 0.55}, -2.34875292761},
  {{0.15 , 0.35 , 0.45}, -2.34875292761},
  {{0.15 , 0.45 , 0.35}, -2.34875292761},
  {{0.15 , 0.55 , 0.25}, -2.34875292761},
  {{0.15 , 0.65 , 0.15}, -2.34875292761},
  {{0.15 , 0.75 , 0.05}, -2.34875292761},
  {{0.25 , 0.05 , 0.65}, -2.34875292761},
  {{0.25 , 0.15 , 0.55}, -2.34875292761},
  {{0.25 , 0.25 , 0.45}, -2.34875292761},
  {{0.25 , 0.35 , 0.35}, -2.34875292761},
  {{0.25 , 0.45 , 0.25}, -2.34875292761},
  {{0.25 , 0.55 , 0.15}, -2.34875292761},
  {{0.25 , 0.65 , 0.05}, -2.34875292761},
  {{0.35 , 0.05 , 0.55}, -2.34875292761},
  {{0.35 , 0.15 , 0.45}, -2.34875292761},
  {{0.35 , 0.25 , 0.35}, -2.34875292761},
  {{0.35 , 0.35 , 0.25}, -2.34875292761},
  {{0.35 , 0.45 , 0.15}, -2.34875292761},
  {{0.35 , 0.55 , 0.05}, -2.34875292761},
  {{0.45 , 0.05 , 0.45}, -2.34875292761},
  {{0.45 , 0.15 , 0.35}, -2.34875292761},
  {{0.45 , 0.25 , 0.25}, -2.34875292761},
  {{0.45 , 0.35 , 0.15}, -2.34875292761},
  {{0.45 , 0.45 , 0.05}, -2.34875292761},
  {{0.55 , 0.05 , 0.35}, -2.34875292761},
  {{0.55 , 0.15 , 0.25}, -2.34875292761},
  {{0.55 , 0.25 , 0.15}, -2.34875292761},
  {{0.55 , 0.35 , 0.05}, -2.34875292761},
  {{0.65 , 0.05 , 0.25}, -2.34875292761},
  {{0.65 , 0.15 , 0.15}, -2.34875292761},
  {{0.65 , 0.25 , 0.05}, -2.34875292761},
  {{0.75 , 0.05 , 0.15}, -2.34875292761},
  {{0.75 , 0.15 , 0.05}, -2.34875292761},
  {{0.85 , 0.05 , 0.05}, -2.34875292761},
  {{0.05 , 0.05 , 0.75}, -2.34875292761},
  {{0.05 , 0.15 , 0.65}, -2.34875292761},
  {{0.05 , 0.25 , 0.55}, -2.34875292761},
  {{0.05 , 0.35 , 0.45}, -2.34875292761},
  {{0.05 , 0.45 , 0.35}, -2.34875292761},
  {{0.05 , 0.55 , 0.25}, -2.34875292761},
  {{0.05 , 0.65 , 0.15}, -2.34875292761},
  {{0.05 , 0.75 , 0.05}, -2.34875292761},
  {{0.15 , 0.05 , 0.65}, -2.34875292761},
  {{0.15 , 0.15 , 0.55}, -2.34875292761},
  {{0.15 , 0.25 , 0.45}, -2.34875292761},
  {{0.15 , 0.35 , 0.35}, -2.34875292761},
  {{0.15 , 0.45 , 0.25}, -2.34875292761},
  {{0.15 , 0.55 , 0.15}, -2.34875292761},
  {{0.15 , 0.65 , 0.05}, -2.34875292761},
  {{0.25 , 0.05 , 0.55}, -2.34875292761},
  {{0.25 , 0.15 , 0.45}, -2.34875292761},
  {{0.25 , 0.25 , 0.35}, -2.34875292761},
  {{0.25 , 0.35 , 0.25}, -2.34875292761},
  {{0.25 , 0.45 , 0.15}, -2.34875292761},
  {{0.25 , 0.55 , 0.05}, -2.34875292761},
  {{0.35 , 0.05 , 0.45}, -2.34875292761},
  {{0.35 , 0.15 , 0.35}, -2.34875292761},
  {{0.35 , 0.25 , 0.25}, -2.34875292761},
  {{0.35 , 0.35 , 0.15}, -2.34875292761},
  {{0.35 , 0.45 , 0.05}, -2.34875292761},
  {{0.45 , 0.05 , 0.35}, -2.34875292761},
  {{0.45 , 0.15 , 0.25}, -2.34875292761},
  {{0.45 , 0.25 , 0.15}, -2.34875292761},
  {{0.45 , 0.35 , 0.05}, -2.34875292761},
  {{0.55 , 0.05 , 0.25}, -2.34875292761},
  {{0.55 , 0.15 , 0.15}, -2.34875292761},
  {{0.55 , 0.25 , 0.05}, -2.34875292761},
  {{0.65 , 0.05 , 0.15}, -2.34875292761},
  {{0.65 , 0.15 , 0.05}, -2.34875292761},
  {{0.75 , 0.05 , 0.05}, -2.34875292761},
  {{0.05 , 0.05 , 0.65}, -2.34875292761},
  {{0.05 , 0.15 , 0.55}, -2.34875292761},
  {{0.05 , 0.25 , 0.45}, -2.34875292761},
  {{0.05 , 0.35 , 0.35}, -2.34875292761},
  {{0.05 , 0.45 , 0.25}, -2.34875292761},
  {{0.05 , 0.55 , 0.15}, -2.34875292761},
  {{0.05 , 0.65 , 0.05}, -2.34875292761},
  {{0.15 , 0.05 , 0.55}, -2.34875292761},
  {{0.15 , 0.15 , 0.45}, -2.34875292761},
  {{0.15 , 0.25 , 0.35}, -2.34875292761},
  {{0.15 , 0.35 , 0.25}, -2.34875292761},
  {{0.15 , 0.45 , 0.15}, -2.34875292761},
  {{0.15 , 0.55 , 0.05}, -2.34875292761},
  {{0.25 , 0.05 , 0.45}, -2.34875292761},
  {{0.25 , 0.15 , 0.35}, -2.34875292761},
  {{0.25 , 0.25 , 0.25}, -2.34875292761},
  {{0.25 , 0.35 , 0.15}, -2.34875292761},
  {{0.25 , 0.45 , 0.05}, -2.34875292761},
  {{0.35 , 0.05 , 0.35}, -2.34875292761},
  {{0.35 , 0.15 , 0.25}, -2.34875292761},
  {{0.35 , 0.25 , 0.15}, -2.34875292761},
  {{0.35 , 0.35 , 0.05}, -2.34875292761},
  {{0.45 , 0.05 , 0.25}, -2.34875292761},
  {{0.45 , 0.15 , 0.15}, -2.34875292761},
  {{0.45 , 0.25 , 0.05}, -2.34875292761},
  {{0.55 , 0.05 , 0.15}, -2.34875292761},
  {{0.55 , 0.15 , 0.05}, -2.34875292761},
  {{0.65 , 0.05 , 0.05}, -2.34875292761},
  {{0.05 , 0.05 , 0.55}, -2.34875292761},
  {{0.05 , 0.15 , 0.45}, -2.34875292761},
  {{0.05 , 0.25 , 0.35}, -2.34875292761},
  {{0.05 , 0.35 , 0.25}, -2.34875292761},
  {{0.05 , 0.45 , 0.15}, -2.34875292761},
  {{0.05 , 0.55 , 0.05}, -2.34875292761},
  {{0.15 , 0.05 , 0.45}, -2.34875292761},
  {{0.15 , 0.15 , 0.35}, -2.34875292761},
  {{0.15 , 0.25 , 0.25}, -2.34875292761},
  {{0.15 , 0.35 , 0.15}, -2.34875292761},
  {{0.15 , 0.45 , 0.05}, -2.34875292761},
  {{0.25 , 0.05 , 0.35}, -2.34875292761},
  {{0.25 , 0.15 , 0.25}, -2.34875292761},
  {{0.25 , 0.25 , 0.15}, -2.34875292761},
  {{0.25 , 0.35 , 0.05}, -2.34875292761},
  {{0.35 , 0.05 , 0.25}, -2.34875292761},
  {{0.35 , 0.15 , 0.15}, -2.34875292761},
  {{0.35 , 0.25 , 0.05}, -2.34875292761},
  {{0.45 , 0.05 , 0.15}, -2.34875292761},
  {{0.45 , 0.15 , 0.05}, -2.34875292761},
  {{0.55 , 0.05 , 0.05}, -2.34875292761},
  {{0.05 , 0.05 , 0.45}, -2.34875292761},
  {{0.05 , 0.15 , 0.35}, -2.34875292761},
  {{0.05 , 0.25 , 0.25}, -2.34875292761},
  {{0.05 , 0.35 , 0.15}, -2.34875292761},
  {{0.05 , 0.45 , 0.05}, -2.34875292761},
  {{0.15 , 0.05 , 0.35}, -2.34875292761},
  {{0.15 , 0.15 , 0.25}, -2.34875292761},
  {{0.15 , 0.25 , 0.15}, -2.34875292761},
  {{0.15 , 0.35 , 0.05}, -2.34875292761},
  {{0.25 , 0.05 , 0.25}, -2.34875292761},
  {{0.25 , 0.15 , 0.15}, -2.34875292761},
  {{0.25 , 0.25 , 0.05}, -2.34875292761},
  {{0.35 , 0.05 , 0.15}, -2.34875292761},
  {{0.35 , 0.15 , 0.05}, -2.34875292761},
  {{0.45 , 0.05 , 0.05}, -2.34875292761},
  {{0.05 , 0.05 , 0.35}, -2.34875292761},
  {{0.05 , 0.15 , 0.25}, -2.34875292761},
  {{0.05 , 0.25 , 0.15}, -2.34875292761},
  {{0.05 , 0.35 , 0.05}, -2.34875292761},
  {{0.15 , 0.05 , 0.25}, -2.34875292761},
  {{0.15 , 0.15 , 0.15}, -2.34875292761},
  {{0.15 , 0.25 , 0.05}, -2.34875292761},
  {{0.25 , 0.05 , 0.15}, -2.34875292761},
  {{0.25 , 0.15 , 0.05}, -2.34875292761},
  {{0.35 , 0.05 , 0.05}, -2.34875292761},
  {{0.05 , 0.05 , 0.25}, -2.34875292761},
  {{0.05 , 0.15 , 0.15}, -2.34875292761},
  {{0.05 , 0.25 , 0.05}, -2.34875292761},
  {{0.15 , 0.05 , 0.15}, -2.34875292761},
  {{0.15 , 0.15 , 0.05}, -2.34875292761},
  {{0.25 , 0.05 , 0.05}, -2.34875292761},
  {{0.05 , 0.05 , 0.15}, -2.34875292761},
  {{0.05 , 0.15 , 0.05}, -2.34875292761},
  {{0.15 , 0.05 , 0.05}, -2.34875292761},
  {{0.05 , 0.05 , 0.05}, -2.34875292761},
  {{0.0555555555556 , 0.0555555555556 , 0.833333333333}, 3.33145777298},
  {{0.0555555555556 , 0.166666666667 , 0.722222222222}, 3.33145777298},
  {{0.0555555555556 , 0.277777777778 , 0.611111111111}, 3.33145777298},
  {{0.0555555555556 , 0.388888888889 , 0.5}, 3.33145777298},
  {{0.0555555555556 , 0.5 , 0.388888888889}, 3.33145777298},
  {{0.0555555555556 , 0.611111111111 , 0.277777777778}, 3.33145777298},
  {{0.0555555555556 , 0.722222222222 , 0.166666666667}, 3.33145777298},
  {{0.0555555555556 , 0.833333333333 , 0.0555555555556}, 3.33145777298},
  {{0.166666666667 , 0.0555555555556 , 0.722222222222}, 3.33145777298},
  {{0.166666666667 , 0.166666666667 , 0.611111111111}, 3.33145777298},
  {{0.166666666667 , 0.277777777778 , 0.5}, 3.33145777298},
  {{0.166666666667 , 0.388888888889 , 0.388888888889}, 3.33145777298},
  {{0.166666666667 , 0.5 , 0.277777777778}, 3.33145777298},
  {{0.166666666667 , 0.611111111111 , 0.166666666667}, 3.33145777298},
  {{0.166666666667 , 0.722222222222 , 0.0555555555556}, 3.33145777298},
  {{0.277777777778 , 0.0555555555556 , 0.611111111111}, 3.33145777298},
  {{0.277777777778 , 0.166666666667 , 0.5}, 3.33145777298},
  {{0.277777777778 , 0.277777777778 , 0.388888888889}, 3.33145777298},
  {{0.277777777778 , 0.388888888889 , 0.277777777778}, 3.33145777298},
  {{0.277777777778 , 0.5 , 0.166666666667}, 3.33145777298},
  {{0.277777777778 , 0.611111111111 , 0.0555555555556}, 3.33145777298},
  {{0.388888888889 , 0.0555555555556 , 0.5}, 3.33145777298},
  {{0.388888888889 , 0.166666666667 , 0.388888888889}, 3.33145777298},
  {{0.388888888889 , 0.277777777778 , 0.277777777778}, 3.33145777298},
  {{0.388888888889 , 0.388888888889 , 0.166666666667}, 3.33145777298},
  {{0.388888888889 , 0.5 , 0.0555555555556}, 3.33145777298},
  {{0.5 , 0.0555555555556 , 0.388888888889}, 3.33145777298},
  {{0.5 , 0.166666666667 , 0.277777777778}, 3.33145777298},
  {{0.5 , 0.277777777778 , 0.166666666667}, 3.33145777298},
  {{0.5 , 0.388888888889 , 0.0555555555556}, 3.33145777298},
  {{0.611111111111 , 0.0555555555556 , 0.277777777778}, 3.33145777298},
  {{0.611111111111 , 0.166666666667 , 0.166666666667}, 3.33145777298},
  {{0.611111111111 , 0.277777777778 , 0.0555555555556}, 3.33145777298},
  {{0.722222222222 , 0.0555555555556 , 0.166666666667}, 3.33145777298},
  {{0.722222222222 , 0.166666666667 , 0.0555555555556}, 3.33145777298},
  {{0.833333333333 , 0.0555555555556 , 0.0555555555556}, 3.33145777298},
  {{0.0555555555556 , 0.0555555555556 , 0.722222222222}, 3.33145777298},
  {{0.0555555555556 , 0.166666666667 , 0.611111111111}, 3.33145777298},
  {{0.0555555555556 , 0.277777777778 , 0.5}, 3.33145777298},
  {{0.0555555555556 , 0.388888888889 , 0.388888888889}, 3.33145777298},
  {{0.0555555555556 , 0.5 , 0.277777777778}, 3.33145777298},
  {{0.0555555555556 , 0.611111111111 , 0.166666666667}, 3.33145777298},
  {{0.0555555555556 , 0.722222222222 , 0.0555555555556}, 3.33145777298},
  {{0.166666666667 , 0.0555555555556 , 0.611111111111}, 3.33145777298},
  {{0.166666666667 , 0.166666666667 , 0.5}, 3.33145777298},
  {{0.166666666667 , 0.277777777778 , 0.388888888889}, 3.33145777298},
  {{0.166666666667 , 0.388888888889 , 0.277777777778}, 3.33145777298},
  {{0.166666666667 , 0.5 , 0.166666666667}, 3.33145777298},
  {{0.166666666667 , 0.611111111111 , 0.0555555555556}, 3.33145777298},
  {{0.277777777778 , 0.0555555555556 , 0.5}, 3.33145777298},
  {{0.277777777778 , 0.166666666667 , 0.388888888889}, 3.33145777298},
  {{0.277777777778 , 0.277777777778 , 0.277777777778}, 3.33145777298},
  {{0.277777777778 , 0.388888888889 , 0.166666666667}, 3.33145777298},
  {{0.277777777778 , 0.5 , 0.0555555555556}, 3.33145777298},
  {{0.388888888889 , 0.0555555555556 , 0.388888888889}, 3.33145777298},
  {{0.388888888889 , 0.166666666667 , 0.277777777778}, 3.33145777298},
  {{0.388888888889 , 0.277777777778 , 0.166666666667}, 3.33145777298},
  {{0.388888888889 , 0.388888888889 , 0.0555555555556}, 3.33145777298},
  {{0.5 , 0.0555555555556 , 0.277777777778}, 3.33145777298},
  {{0.5 , 0.166666666667 , 0.166666666667}, 3.33145777298},
  {{0.5 , 0.277777777778 , 0.0555555555556}, 3.33145777298},
  {{0.611111111111 , 0.0555555555556 , 0.166666666667}, 3.33145777298},
  {{0.611111111111 , 0.166666666667 , 0.0555555555556}, 3.33145777298},
  {{0.722222222222 , 0.0555555555556 , 0.0555555555556}, 3.33145777298},
  {{0.0555555555556 , 0.0555555555556 , 0.611111111111}, 3.33145777298},
  {{0.0555555555556 , 0.166666666667 , 0.5}, 3.33145777298},
  {{0.0555555555556 , 0.277777777778 , 0.388888888889}, 3.33145777298},
  {{0.0555555555556 , 0.388888888889 , 0.277777777778}, 3.33145777298},
  {{0.0555555555556 , 0.5 , 0.166666666667}, 3.33145777298},
  {{0.0555555555556 , 0.611111111111 , 0.0555555555556}, 3.33145777298},
  {{0.166666666667 , 0.0555555555556 , 0.5}, 3.33145777298},
  {{0.166666666667 , 0.166666666667 , 0.388888888889}, 3.33145777298},
  {{0.166666666667 , 0.277777777778 , 0.277777777778}, 3.33145777298},
  {{0.166666666667 , 0.388888888889 , 0.166666666667}, 3.33145777298},
  {{0.166666666667 , 0.5 , 0.0555555555556}, 3.33145777298},
  {{0.277777777778 , 0.0555555555556 , 0.388888888889}, 3.33145777298},
  {{0.277777777778 , 0.166666666667 , 0.277777777778}, 3.33145777298},
  {{0.277777777778 , 0.277777777778 , 0.166666666667}, 3.33145777298},
  {{0.277777777778 , 0.388888888889 , 0.0555555555556}, 3.33145777298},
  {{0.388888888889 , 0.0555555555556 , 0.277777777778}, 3.33145777298},
  {{0.388888888889 , 0.166666666667 , 0.166666666667}, 3.33145777298},
  {{0.388888888889 , 0.277777777778 , 0.0555555555556}, 3.33145777298},
  {{0.5 , 0.0555555555556 , 0.166666666667}, 3.33145777298},
  {{0.5 , 0.166666666667 , 0.0555555555556}, 3.33145777298},
  {{0.611111111111 , 0.0555555555556 , 0.0555555555556}, 3.33145777298},
  {{0.0555555555556 , 0.0555555555556 , 0.5}, 3.33145777298},
  {{0.0555555555556 , 0.166666666667 , 0.388888888889}, 3.33145777298},
  {{0.0555555555556 , 0.277777777778 , 0.277777777778}, 3.33145777298},
  {{0.0555555555556 , 0.388888888889 , 0.166666666667}, 3.33145777298},
  {{0.0555555555556 , 0.5 , 0.0555555555556}, 3.33145777298},
  {{0.166666666667 , 0.0555555555556 , 0.388888888889}, 3.33145777298},
  {{0.166666666667 , 0.166666666667 , 0.277777777778}, 3.33145777298},
  {{0.166666666667 , 0.277777777778 , 0.166666666667}, 3.33145777298},
  {{0.166666666667 , 0.388888888889 , 0.0555555555556}, 3.33145777298},
  {{0.277777777778 , 0.0555555555556 , 0.277777777778}, 3.33145777298},
  {{0.277777777778 , 0.166666666667 , 0.166666666667}, 3.33145777298},
  {{0.277777777778 , 0.277777777778 , 0.0555555555556}, 3.33145777298},
  {{0.388888888889 , 0.0555555555556 , 0.166666666667}, 3.33145777298},
  {{0.388888888889 , 0.166666666667 , 0.0555555555556}, 3.33145777298},
  {{0.5 , 0.0555555555556 , 0.0555555555556}, 3.33145777298},
  {{0.0555555555556 , 0.0555555555556 , 0.388888888889}, 3.33145777298},
  {{0.0555555555556 , 0.166666666667 , 0.277777777778}, 3.33145777298},
  {{0.0555555555556 , 0.277777777778 , 0.166666666667}, 3.33145777298},
  {{0.0555555555556 , 0.388888888889 , 0.0555555555556}, 3.33145777298},
  {{0.166666666667 , 0.0555555555556 , 0.277777777778}, 3.33145777298},
  {{0.166666666667 , 0.166666666667 , 0.166666666667}, 3.33145777298},
  {{0.166666666667 , 0.277777777778 , 0.0555555555556}, 3.33145777298},
  {{0.277777777778 , 0.0555555555556 , 0.166666666667}, 3.33145777298},
  {{0.277777777778 , 0.166666666667 , 0.0555555555556}, 3.33145777298},
  {{0.388888888889 , 0.0555555555556 , 0.0555555555556}, 3.33145777298},
  {{0.0555555555556 , 0.0555555555556 , 0.277777777778}, 3.33145777298},
  {{0.0555555555556 , 0.166666666667 , 0.166666666667}, 3.33145777298},
  {{0.0555555555556 , 0.277777777778 , 0.0555555555556}, 3.33145777298},
  {{0.166666666667 , 0.0555555555556 , 0.166666666667}, 3.33145777298},
  {{0.166666666667 , 0.166666666667 , 0.0555555555556}, 3.33145777298},
  {{0.277777777778 , 0.0555555555556 , 0.0555555555556}, 3.33145777298},
  {{0.0555555555556 , 0.0555555555556 , 0.166666666667}, 3.33145777298},
  {{0.0555555555556 , 0.166666666667 , 0.0555555555556}, 3.33145777298},
  {{0.166666666667 , 0.0555555555556 , 0.0555555555556}, 3.33145777298},
  {{0.0555555555556 , 0.0555555555556 , 0.0555555555556}, 3.33145777298},
  {{0.0625 , 0.0625 , 0.8125}, -2.36943678934},
  {{0.0625 , 0.1875 , 0.6875}, -2.36943678934},
  {{0.0625 , 0.3125 , 0.5625}, -2.36943678934},
  {{0.0625 , 0.4375 , 0.4375}, -2.36943678934},
  {{0.0625 , 0.5625 , 0.3125}, -2.36943678934},
  {{0.0625 , 0.6875 , 0.1875}, -2.36943678934},
  {{0.0625 , 0.8125 , 0.0625}, -2.36943678934},
  {{0.1875 , 0.0625 , 0.6875}, -2.36943678934},
  {{0.1875 , 0.1875 , 0.5625}, -2.36943678934},
  {{0.1875 , 0.3125 , 0.4375}, -2.36943678934},
  {{0.1875 , 0.4375 , 0.3125}, -2.36943678934},
  {{0.1875 , 0.5625 , 0.1875}, -2.36943678934},
  {{0.1875 , 0.6875 , 0.0625}, -2.36943678934},
  {{0.3125 , 0.0625 , 0.5625}, -2.36943678934},
  {{0.3125 , 0.1875 , 0.4375}, -2.36943678934},
  {{0.3125 , 0.3125 , 0.3125}, -2.36943678934},
  {{0.3125 , 0.4375 , 0.1875}, -2.36943678934},
  {{0.3125 , 0.5625 , 0.0625}, -2.36943678934},
  {{0.4375 , 0.0625 , 0.4375}, -2.36943678934},
  {{0.4375 , 0.1875 , 0.3125}, -2.36943678934},
  {{0.4375 , 0.3125 , 0.1875}, -2.36943678934},
  {{0.4375 , 0.4375 , 0.0625}, -2.36943678934},
  {{0.5625 , 0.0625 , 0.3125}, -2.36943678934},
  {{0.5625 , 0.1875 , 0.1875}, -2.36943678934},
  {{0.5625 , 0.3125 , 0.0625}, -2.36943678934},
  {{0.6875 , 0.0625 , 0.1875}, -2.36943678934},
  {{0.6875 , 0.1875 , 0.0625}, -2.36943678934},
  {{0.8125 , 0.0625 , 0.0625}, -2.36943678934},
  {{0.0625 , 0.0625 , 0.6875}, -2.36943678934},
  {{0.0625 , 0.1875 , 0.5625}, -2.36943678934},
  {{0.0625 , 0.3125 , 0.4375}, -2.36943678934},
  {{0.0625 , 0.4375 , 0.3125}, -2.36943678934},
  {{0.0625 , 0.5625 , 0.1875}, -2.36943678934},
  {{0.0625 , 0.6875 , 0.0625}, -2.36943678934},
  {{0.1875 , 0.0625 , 0.5625}, -2.36943678934},
  {{0.1875 , 0.1875 , 0.4375}, -2.36943678934},
  {{0.1875 , 0.3125 , 0.3125}, -2.36943678934},
  {{0.1875 , 0.4375 , 0.1875}, -2.36943678934},
  {{0.1875 , 0.5625 , 0.0625}, -2.36943678934},
  {{0.3125 , 0.0625 , 0.4375}, -2.36943678934},
  {{0.3125 , 0.1875 , 0.3125}, -2.36943678934},
  {{0.3125 , 0.3125 , 0.1875}, -2.36943678934},
  {{0.3125 , 0.4375 , 0.0625}, -2.36943678934},
  {{0.4375 , 0.0625 , 0.3125}, -2.36943678934},
  {{0.4375 , 0.1875 , 0.1875}, -2.36943678934},
  {{0.4375 , 0.3125 , 0.0625}, -2.36943678934},
  {{0.5625 , 0.0625 , 0.1875}, -2.36943678934},
  {{0.5625 , 0.1875 , 0.0625}, -2.36943678934},
  {{0.6875 , 0.0625 , 0.0625}, -2.36943678934},
  {{0.0625 , 0.0625 , 0.5625}, -2.36943678934},
  {{0.0625 , 0.1875 , 0.4375}, -2.36943678934},
  {{0.0625 , 0.3125 , 0.3125}, -2.36943678934},
  {{0.0625 , 0.4375 , 0.1875}, -2.36943678934},
  {{0.0625 , 0.5625 , 0.0625}, -2.36943678934},
  {{0.1875 , 0.0625 , 0.4375}, -2.36943678934},
  {{0.1875 , 0.1875 , 0.3125}, -2.36943678934},
  {{0.1875 , 0.3125 , 0.1875}, -2.36943678934},
  {{0.1875 , 0.4375 , 0.0625}, -2.36943678934},
  {{0.3125 , 0.0625 , 0.3125}, -2.36943678934},
  {{0.3125 , 0.1875 , 0.1875}, -2.36943678934},
  {{0.3125 , 0.3125 , 0.0625}, -2.36943678934},
  {{0.4375 , 0.0625 , 0.1875}, -2.36943678934},
  {{0.4375 , 0.1875 , 0.0625}, -2.36943678934},
  {{0.5625 , 0.0625 , 0.0625}, -2.36943678934},
  {{0.0625 , 0.0625 , 0.4375}, -2.36943678934},
  {{0.0625 , 0.1875 , 0.3125}, -2.36943678934},
  {{0.0625 , 0.3125 , 0.1875}, -2.36943678934},
  {{0.0625 , 0.4375 , 0.0625}, -2.36943678934},
  {{0.1875 , 0.0625 , 0.3125}, -2.36943678934},
  {{0.1875 , 0.1875 , 0.1875}, -2.36943678934},
  {{0.1875 , 0.3125 , 0.0625}, -2.36943678934},
  {{0.3125 , 0.0625 , 0.1875}, -2.36943678934},
  {{0.3125 , 0.1875 , 0.0625}, -2.36943678934},
  {{0.4375 , 0.0625 , 0.0625}, -2.36943678934},
  {{0.0625 , 0.0625 , 0.3125}, -2.36943678934},
  {{0.0625 , 0.1875 , 0.1875}, -2.36943678934},
  {{0.0625 , 0.3125 , 0.0625}, -2.36943678934},
  {{0.1875 , 0.0625 , 0.1875}, -2.36943678934},
  {{0.1875 , 0.1875 , 0.0625}, -2.36943678934},
  {{0.3125 , 0.0625 , 0.0625}, -2.36943678934},
  {{0.0625 , 0.0625 , 0.1875}, -2.36943678934},
  {{0.0625 , 0.1875 , 0.0625}, -2.36943678934},
  {{0.1875 , 0.0625 , 0.0625}, -2.36943678934},
  {{0.0625 , 0.0625 , 0.0625}, -2.36943678934},
  {{0.0714285714286 , 0.0714285714286 , 0.785714285714}, 0.890208515568},
  {{0.0714285714286 , 0.214285714286 , 0.642857142857}, 0.890208515568},
  {{0.0714285714286 , 0.357142857143 , 0.5}, 0.890208515568},
  {{0.0714285714286 , 0.5 , 0.357142857143}, 0.890208515568},
  {{0.0714285714286 , 0.642857142857 , 0.214285714286}, 0.890208515568},
  {{0.0714285714286 , 0.785714285714 , 0.0714285714286}, 0.890208515568},
  {{0.214285714286 , 0.0714285714286 , 0.642857142857}, 0.890208515568},
  {{0.214285714286 , 0.214285714286 , 0.5}, 0.890208515568},
  {{0.214285714286 , 0.357142857143 , 0.357142857143}, 0.890208515568},
  {{0.214285714286 , 0.5 , 0.214285714286}, 0.890208515568},
  {{0.214285714286 , 0.642857142857 , 0.0714285714286}, 0.890208515568},
  {{0.357142857143 , 0.0714285714286 , 0.5}, 0.890208515568},
  {{0.357142857143 , 0.214285714286 , 0.357142857143}, 0.890208515568},
  {{0.357142857143 , 0.357142857143 , 0.214285714286}, 0.890208515568},
  {{0.357142857143 , 0.5 , 0.0714285714286}, 0.890208515568},
  {{0.5 , 0.0714285714286 , 0.357142857143}, 0.890208515568},
  {{0.5 , 0.214285714286 , 0.214285714286}, 0.890208515568},
  {{0.5 , 0.357142857143 , 0.0714285714286}, 0.890208515568},
  {{0.642857142857 , 0.0714285714286 , 0.214285714286}, 0.890208515568},
  {{0.642857142857 , 0.214285714286 , 0.0714285714286}, 0.890208515568},
  {{0.785714285714 , 0.0714285714286 , 0.0714285714286}, 0.890208515568},
  {{0.0714285714286 , 0.0714285714286 , 0.642857142857}, 0.890208515568},
  {{0.0714285714286 , 0.214285714286 , 0.5}, 0.890208515568},
  {{0.0714285714286 , 0.357142857143 , 0.357142857143}, 0.890208515568},
  {{0.0714285714286 , 0.5 , 0.214285714286}, 0.890208515568},
  {{0.0714285714286 , 0.642857142857 , 0.0714285714286}, 0.890208515568},
  {{0.214285714286 , 0.0714285714286 , 0.5}, 0.890208515568},
  {{0.214285714286 , 0.214285714286 , 0.357142857143}, 0.890208515568},
  {{0.214285714286 , 0.357142857143 , 0.214285714286}, 0.890208515568},
  {{0.214285714286 , 0.5 , 0.0714285714286}, 0.890208515568},
  {{0.357142857143 , 0.0714285714286 , 0.357142857143}, 0.890208515568},
  {{0.357142857143 , 0.214285714286 , 0.214285714286}, 0.890208515568},
  {{0.357142857143 , 0.357142857143 , 0.0714285714286}, 0.890208515568},
  {{0.5 , 0.0714285714286 , 0.214285714286}, 0.890208515568},
  {{0.5 , 0.214285714286 , 0.0714285714286}, 0.890208515568},
  {{0.642857142857 , 0.0714285714286 , 0.0714285714286}, 0.890208515568},
  {{0.0714285714286 , 0.0714285714286 , 0.5}, 0.890208515568},
  {{0.0714285714286 , 0.214285714286 , 0.357142857143}, 0.890208515568},
  {{0.0714285714286 , 0.357142857143 , 0.214285714286}, 0.890208515568},
  {{0.0714285714286 , 0.5 , 0.0714285714286}, 0.890208515568},
  {{0.214285714286 , 0.0714285714286 , 0.357142857143}, 0.890208515568},
  {{0.214285714286 , 0.214285714286 , 0.214285714286}, 0.890208515568},
  {{0.214285714286 , 0.357142857143 , 0.0714285714286}, 0.890208515568},
  {{0.357142857143 , 0.0714285714286 , 0.214285714286}, 0.890208515568},
  {{0.357142857143 , 0.214285714286 , 0.0714285714286}, 0.890208515568},
  {{0.5 , 0.0714285714286 , 0.0714285714286}, 0.890208515568},
  {{0.0714285714286 , 0.0714285714286 , 0.357142857143}, 0.890208515568},
  {{0.0714285714286 , 0.214285714286 , 0.214285714286}, 0.890208515568},
  {{0.0714285714286 , 0.357142857143 , 0.0714285714286}, 0.890208515568},
  {{0.214285714286 , 0.0714285714286 , 0.214285714286}, 0.890208515568},
  {{0.214285714286 , 0.214285714286 , 0.0714285714286}, 0.890208515568},
  {{0.357142857143 , 0.0714285714286 , 0.0714285714286}, 0.890208515568},
  {{0.0714285714286 , 0.0714285714286 , 0.214285714286}, 0.890208515568},
  {{0.0714285714286 , 0.214285714286 , 0.0714285714286}, 0.890208515568},
  {{0.214285714286 , 0.0714285714286 , 0.0714285714286}, 0.890208515568},
  {{0.0714285714286 , 0.0714285714286 , 0.0714285714286}, 0.890208515568},
  {{0.0833333333333 , 0.0833333333333 , 0.75}, -0.171318886156},
  {{0.0833333333333 , 0.25 , 0.583333333333}, -0.171318886156},
  {{0.0833333333333 , 0.416666666667 , 0.416666666667}, -0.171318886156},
  {{0.0833333333333 , 0.583333333333 , 0.25}, -0.171318886156},
  {{0.0833333333333 , 0.75 , 0.0833333333333}, -0.171318886156},
  {{0.25 , 0.0833333333333 , 0.583333333333}, -0.171318886156},
  {{0.25 , 0.25 , 0.416666666667}, -0.171318886156},
  {{0.25 , 0.416666666667 , 0.25}, -0.171318886156},
  {{0.25 , 0.583333333333 , 0.0833333333333}, -0.171318886156},
  {{0.416666666667 , 0.0833333333333 , 0.416666666667}, -0.171318886156},
  {{0.416666666667 , 0.25 , 0.25}, -0.171318886156},
  {{0.416666666667 , 0.416666666667 , 0.0833333333333}, -0.171318886156},
  {{0.583333333333 , 0.0833333333333 , 0.25}, -0.171318886156},
  {{0.583333333333 , 0.25 , 0.0833333333333}, -0.171318886156},
  {{0.75 , 0.0833333333333 , 0.0833333333333}, -0.171318886156},
  {{0.0833333333333 , 0.0833333333333 , 0.583333333333}, -0.171318886156},
  {{0.0833333333333 , 0.25 , 0.416666666667}, -0.171318886156},
  {{0.0833333333333 , 0.416666666667 , 0.25}, -0.171318886156},
  {{0.0833333333333 , 0.583333333333 , 0.0833333333333}, -0.171318886156},
  {{0.25 , 0.0833333333333 , 0.416666666667}, -0.171318886156},
  {{0.25 , 0.25 , 0.25}, -0.171318886156},
  {{0.25 , 0.416666666667 , 0.0833333333333}, -0.171318886156},
  {{0.416666666667 , 0.0833333333333 , 0.25}, -0.171318886156},
  {{0.416666666667 , 0.25 , 0.0833333333333}, -0.171318886156},
  {{0.583333333333 , 0.0833333333333 , 0.0833333333333}, -0.171318886156},
  {{0.0833333333333 , 0.0833333333333 , 0.416666666667}, -0.171318886156},
  {{0.0833333333333 , 0.25 , 0.25}, -0.171318886156},
  {{0.0833333333333 , 0.416666666667 , 0.0833333333333}, -0.171318886156},
  {{0.25 , 0.0833333333333 , 0.25}, -0.171318886156},
  {{0.25 , 0.25 , 0.0833333333333}, -0.171318886156},
  {{0.416666666667 , 0.0833333333333 , 0.0833333333333}, -0.171318886156},
  {{0.0833333333333 , 0.0833333333333 , 0.25}, -0.171318886156},
  {{0.0833333333333 , 0.25 , 0.0833333333333}, -0.171318886156},
  {{0.25 , 0.0833333333333 , 0.0833333333333}, -0.171318886156},
  {{0.0833333333333 , 0.0833333333333 , 0.0833333333333}, -0.171318886156},
  {{0.1 , 0.1 , 0.7}, 0.0151935492591},
  {{0.1 , 0.3 , 0.5}, 0.0151935492591},
  {{0.1 , 0.5 , 0.3}, 0.0151935492591},
  {{0.1 , 0.7 , 0.1}, 0.0151935492591},
  {{0.3 , 0.1 , 0.5}, 0.0151935492591},
  {{0.3 , 0.3 , 0.3}, 0.0151935492591},
  {{0.3 , 0.5 , 0.1}, 0.0151935492591},
  {{0.5 , 0.1 , 0.3}, 0.0151935492591},
  {{0.5 , 0.3 , 0.1}, 0.0151935492591},
  {{0.7 , 0.1 , 0.1}, 0.0151935492591},
  {{0.1 , 0.1 , 0.5}, 0.0151935492591},
  {{0.1 , 0.3 , 0.3}, 0.0151935492591},
  {{0.1 , 0.5 , 0.1}, 0.0151935492591},
  {{0.3 , 0.1 , 0.3}, 0.0151935492591},
  {{0.3 , 0.3 , 0.1}, 0.0151935492591},
  {{0.5 , 0.1 , 0.1}, 0.0151935492591},
  {{0.1 , 0.1 , 0.3}, 0.0151935492591},
  {{0.1 , 0.3 , 0.1}, 0.0151935492591},
  {{0.3 , 0.1 , 0.1}, 0.0151935492591},
  {{0.1 , 0.1 , 0.1}, 0.0151935492591},
  {{0.125 , 0.125 , 0.625}, -0.000500484847776},
  {{0.125 , 0.375 , 0.375}, -0.000500484847776},
  {{0.125 , 0.625 , 0.125}, -0.000500484847776},
  {{0.375 , 0.125 , 0.375}, -0.000500484847776},
  {{0.375 , 0.375 , 0.125}, -0.000500484847776},
  {{0.625 , 0.125 , 0.125}, -0.000500484847776},
  {{0.125 , 0.125 , 0.375}, -0.000500484847776},
  {{0.125 , 0.375 , 0.125}, -0.000500484847776},
  {{0.375 , 0.125 , 0.125}, -0.000500484847776},
  {{0.125 , 0.125 , 0.125}, -0.000500484847776},
  {{0.166666666667 , 0.166666666667 , 0.5}, 3.96785881125e-06},
  {{0.166666666667 , 0.5 , 0.166666666667}, 3.96785881125e-06},
  {{0.5 , 0.166666666667 , 0.166666666667}, 3.96785881125e-06},
  {{0.166666666667 , 0.166666666667 , 0.166666666667}, 3.96785881125e-06},
  {{0.25 , 0.25 , 0.25}, -2.7842475e-09}
};

// 295 negative weights, 0 points outside of the tetrahedron 


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 21 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP21Solin[1001] = {
  {{0.0416666666667 , 0.0416666666667 , 0.875}, 0.889778162649},
  {{0.0416666666667 , 0.125 , 0.791666666667}, 0.889778162649},
  {{0.0416666666667 , 0.208333333333 , 0.708333333333}, 0.889778162649},
  {{0.0416666666667 , 0.291666666667 , 0.625}, 0.889778162649},
  {{0.0416666666667 , 0.375 , 0.541666666667}, 0.889778162649},
  {{0.0416666666667 , 0.458333333333 , 0.458333333333}, 0.889778162649},
  {{0.0416666666667 , 0.541666666667 , 0.375}, 0.889778162649},
  {{0.0416666666667 , 0.625 , 0.291666666667}, 0.889778162649},
  {{0.0416666666667 , 0.708333333333 , 0.208333333333}, 0.889778162649},
  {{0.0416666666667 , 0.791666666667 , 0.125}, 0.889778162649},
  {{0.0416666666667 , 0.875 , 0.0416666666667}, 0.889778162649},
  {{0.125 , 0.0416666666667 , 0.791666666667}, 0.889778162649},
  {{0.125 , 0.125 , 0.708333333333}, 0.889778162649},
  {{0.125 , 0.208333333333 , 0.625}, 0.889778162649},
  {{0.125 , 0.291666666667 , 0.541666666667}, 0.889778162649},
  {{0.125 , 0.375 , 0.458333333333}, 0.889778162649},
  {{0.125 , 0.458333333333 , 0.375}, 0.889778162649},
  {{0.125 , 0.541666666667 , 0.291666666667}, 0.889778162649},
  {{0.125 , 0.625 , 0.208333333333}, 0.889778162649},
  {{0.125 , 0.708333333333 , 0.125}, 0.889778162649},
  {{0.125 , 0.791666666667 , 0.0416666666667}, 0.889778162649},
  {{0.208333333333 , 0.0416666666667 , 0.708333333333}, 0.889778162649},
  {{0.208333333333 , 0.125 , 0.625}, 0.889778162649},
  {{0.208333333333 , 0.208333333333 , 0.541666666667}, 0.889778162649},
  {{0.208333333333 , 0.291666666667 , 0.458333333333}, 0.889778162649},
  {{0.208333333333 , 0.375 , 0.375}, 0.889778162649},
  {{0.208333333333 , 0.458333333333 , 0.291666666667}, 0.889778162649},
  {{0.208333333333 , 0.541666666667 , 0.208333333333}, 0.889778162649},
  {{0.208333333333 , 0.625 , 0.125}, 0.889778162649},
  {{0.208333333333 , 0.708333333333 , 0.0416666666667}, 0.889778162649},
  {{0.291666666667 , 0.0416666666667 , 0.625}, 0.889778162649},
  {{0.291666666667 , 0.125 , 0.541666666667}, 0.889778162649},
  {{0.291666666667 , 0.208333333333 , 0.458333333333}, 0.889778162649},
  {{0.291666666667 , 0.291666666667 , 0.375}, 0.889778162649},
  {{0.291666666667 , 0.375 , 0.291666666667}, 0.889778162649},
  {{0.291666666667 , 0.458333333333 , 0.208333333333}, 0.889778162649},
  {{0.291666666667 , 0.541666666667 , 0.125}, 0.889778162649},
  {{0.291666666667 , 0.625 , 0.0416666666667}, 0.889778162649},
  {{0.375 , 0.0416666666667 , 0.541666666667}, 0.889778162649},
  {{0.375 , 0.125 , 0.458333333333}, 0.889778162649},
  {{0.375 , 0.208333333333 , 0.375}, 0.889778162649},
  {{0.375 , 0.291666666667 , 0.291666666667}, 0.889778162649},
  {{0.375 , 0.375 , 0.208333333333}, 0.889778162649},
  {{0.375 , 0.458333333333 , 0.125}, 0.889778162649},
  {{0.375 , 0.541666666667 , 0.0416666666667}, 0.889778162649},
  {{0.458333333333 , 0.0416666666667 , 0.458333333333}, 0.889778162649},
  {{0.458333333333 , 0.125 , 0.375}, 0.889778162649},
  {{0.458333333333 , 0.208333333333 , 0.291666666667}, 0.889778162649},
  {{0.458333333333 , 0.291666666667 , 0.208333333333}, 0.889778162649},
  {{0.458333333333 , 0.375 , 0.125}, 0.889778162649},
  {{0.458333333333 , 0.458333333333 , 0.0416666666667}, 0.889778162649},
  {{0.541666666667 , 0.0416666666667 , 0.375}, 0.889778162649},
  {{0.541666666667 , 0.125 , 0.291666666667}, 0.889778162649},
  {{0.541666666667 , 0.208333333333 , 0.208333333333}, 0.889778162649},
  {{0.541666666667 , 0.291666666667 , 0.125}, 0.889778162649},
  {{0.541666666667 , 0.375 , 0.0416666666667}, 0.889778162649},
  {{0.625 , 0.0416666666667 , 0.291666666667}, 0.889778162649},
  {{0.625 , 0.125 , 0.208333333333}, 0.889778162649},
  {{0.625 , 0.208333333333 , 0.125}, 0.889778162649},
  {{0.625 , 0.291666666667 , 0.0416666666667}, 0.889778162649},
  {{0.708333333333 , 0.0416666666667 , 0.208333333333}, 0.889778162649},
  {{0.708333333333 , 0.125 , 0.125}, 0.889778162649},
  {{0.708333333333 , 0.208333333333 , 0.0416666666667}, 0.889778162649},
  {{0.791666666667 , 0.0416666666667 , 0.125}, 0.889778162649},
  {{0.791666666667 , 0.125 , 0.0416666666667}, 0.889778162649},
  {{0.875 , 0.0416666666667 , 0.0416666666667}, 0.889778162649},
  {{0.0416666666667 , 0.0416666666667 , 0.791666666667}, 0.889778162649},
  {{0.0416666666667 , 0.125 , 0.708333333333}, 0.889778162649},
  {{0.0416666666667 , 0.208333333333 , 0.625}, 0.889778162649},
  {{0.0416666666667 , 0.291666666667 , 0.541666666667}, 0.889778162649},
  {{0.0416666666667 , 0.375 , 0.458333333333}, 0.889778162649},
  {{0.0416666666667 , 0.458333333333 , 0.375}, 0.889778162649},
  {{0.0416666666667 , 0.541666666667 , 0.291666666667}, 0.889778162649},
  {{0.0416666666667 , 0.625 , 0.208333333333}, 0.889778162649},
  {{0.0416666666667 , 0.708333333333 , 0.125}, 0.889778162649},
  {{0.0416666666667 , 0.791666666667 , 0.0416666666667}, 0.889778162649},
  {{0.125 , 0.0416666666667 , 0.708333333333}, 0.889778162649},
  {{0.125 , 0.125 , 0.625}, 0.889778162649},
  {{0.125 , 0.208333333333 , 0.541666666667}, 0.889778162649},
  {{0.125 , 0.291666666667 , 0.458333333333}, 0.889778162649},
  {{0.125 , 0.375 , 0.375}, 0.889778162649},
  {{0.125 , 0.458333333333 , 0.291666666667}, 0.889778162649},
  {{0.125 , 0.541666666667 , 0.208333333333}, 0.889778162649},
  {{0.125 , 0.625 , 0.125}, 0.889778162649},
  {{0.125 , 0.708333333333 , 0.0416666666667}, 0.889778162649},
  {{0.208333333333 , 0.0416666666667 , 0.625}, 0.889778162649},
  {{0.208333333333 , 0.125 , 0.541666666667}, 0.889778162649},
  {{0.208333333333 , 0.208333333333 , 0.458333333333}, 0.889778162649},
  {{0.208333333333 , 0.291666666667 , 0.375}, 0.889778162649},
  {{0.208333333333 , 0.375 , 0.291666666667}, 0.889778162649},
  {{0.208333333333 , 0.458333333333 , 0.208333333333}, 0.889778162649},
  {{0.208333333333 , 0.541666666667 , 0.125}, 0.889778162649},
  {{0.208333333333 , 0.625 , 0.0416666666667}, 0.889778162649},
  {{0.291666666667 , 0.0416666666667 , 0.541666666667}, 0.889778162649},
  {{0.291666666667 , 0.125 , 0.458333333333}, 0.889778162649},
  {{0.291666666667 , 0.208333333333 , 0.375}, 0.889778162649},
  {{0.291666666667 , 0.291666666667 , 0.291666666667}, 0.889778162649},
  {{0.291666666667 , 0.375 , 0.208333333333}, 0.889778162649},
  {{0.291666666667 , 0.458333333333 , 0.125}, 0.889778162649},
  {{0.291666666667 , 0.541666666667 , 0.0416666666667}, 0.889778162649},
  {{0.375 , 0.0416666666667 , 0.458333333333}, 0.889778162649},
  {{0.375 , 0.125 , 0.375}, 0.889778162649},
  {{0.375 , 0.208333333333 , 0.291666666667}, 0.889778162649},
  {{0.375 , 0.291666666667 , 0.208333333333}, 0.889778162649},
  {{0.375 , 0.375 , 0.125}, 0.889778162649},
  {{0.375 , 0.458333333333 , 0.0416666666667}, 0.889778162649},
  {{0.458333333333 , 0.0416666666667 , 0.375}, 0.889778162649},
  {{0.458333333333 , 0.125 , 0.291666666667}, 0.889778162649},
  {{0.458333333333 , 0.208333333333 , 0.208333333333}, 0.889778162649},
  {{0.458333333333 , 0.291666666667 , 0.125}, 0.889778162649},
  {{0.458333333333 , 0.375 , 0.0416666666667}, 0.889778162649},
  {{0.541666666667 , 0.0416666666667 , 0.291666666667}, 0.889778162649},
  {{0.541666666667 , 0.125 , 0.208333333333}, 0.889778162649},
  {{0.541666666667 , 0.208333333333 , 0.125}, 0.889778162649},
  {{0.541666666667 , 0.291666666667 , 0.0416666666667}, 0.889778162649},
  {{0.625 , 0.0416666666667 , 0.208333333333}, 0.889778162649},
  {{0.625 , 0.125 , 0.125}, 0.889778162649},
  {{0.625 , 0.208333333333 , 0.0416666666667}, 0.889778162649},
  {{0.708333333333 , 0.0416666666667 , 0.125}, 0.889778162649},
  {{0.708333333333 , 0.125 , 0.0416666666667}, 0.889778162649},
  {{0.791666666667 , 0.0416666666667 , 0.0416666666667}, 0.889778162649},
  {{0.0416666666667 , 0.0416666666667 , 0.708333333333}, 0.889778162649},
  {{0.0416666666667 , 0.125 , 0.625}, 0.889778162649},
  {{0.0416666666667 , 0.208333333333 , 0.541666666667}, 0.889778162649},
  {{0.0416666666667 , 0.291666666667 , 0.458333333333}, 0.889778162649},
  {{0.0416666666667 , 0.375 , 0.375}, 0.889778162649},
  {{0.0416666666667 , 0.458333333333 , 0.291666666667}, 0.889778162649},
  {{0.0416666666667 , 0.541666666667 , 0.208333333333}, 0.889778162649},
  {{0.0416666666667 , 0.625 , 0.125}, 0.889778162649},
  {{0.0416666666667 , 0.708333333333 , 0.0416666666667}, 0.889778162649},
  {{0.125 , 0.0416666666667 , 0.625}, 0.889778162649},
  {{0.125 , 0.125 , 0.541666666667}, 0.889778162649},
  {{0.125 , 0.208333333333 , 0.458333333333}, 0.889778162649},
  {{0.125 , 0.291666666667 , 0.375}, 0.889778162649},
  {{0.125 , 0.375 , 0.291666666667}, 0.889778162649},
  {{0.125 , 0.458333333333 , 0.208333333333}, 0.889778162649},
  {{0.125 , 0.541666666667 , 0.125}, 0.889778162649},
  {{0.125 , 0.625 , 0.0416666666667}, 0.889778162649},
  {{0.208333333333 , 0.0416666666667 , 0.541666666667}, 0.889778162649},
  {{0.208333333333 , 0.125 , 0.458333333333}, 0.889778162649},
  {{0.208333333333 , 0.208333333333 , 0.375}, 0.889778162649},
  {{0.208333333333 , 0.291666666667 , 0.291666666667}, 0.889778162649},
  {{0.208333333333 , 0.375 , 0.208333333333}, 0.889778162649},
  {{0.208333333333 , 0.458333333333 , 0.125}, 0.889778162649},
  {{0.208333333333 , 0.541666666667 , 0.0416666666667}, 0.889778162649},
  {{0.291666666667 , 0.0416666666667 , 0.458333333333}, 0.889778162649},
  {{0.291666666667 , 0.125 , 0.375}, 0.889778162649},
  {{0.291666666667 , 0.208333333333 , 0.291666666667}, 0.889778162649},
  {{0.291666666667 , 0.291666666667 , 0.208333333333}, 0.889778162649},
  {{0.291666666667 , 0.375 , 0.125}, 0.889778162649},
  {{0.291666666667 , 0.458333333333 , 0.0416666666667}, 0.889778162649},
  {{0.375 , 0.0416666666667 , 0.375}, 0.889778162649},
  {{0.375 , 0.125 , 0.291666666667}, 0.889778162649},
  {{0.375 , 0.208333333333 , 0.208333333333}, 0.889778162649},
  {{0.375 , 0.291666666667 , 0.125}, 0.889778162649},
  {{0.375 , 0.375 , 0.0416666666667}, 0.889778162649},
  {{0.458333333333 , 0.0416666666667 , 0.291666666667}, 0.889778162649},
  {{0.458333333333 , 0.125 , 0.208333333333}, 0.889778162649},
  {{0.458333333333 , 0.208333333333 , 0.125}, 0.889778162649},
  {{0.458333333333 , 0.291666666667 , 0.0416666666667}, 0.889778162649},
  {{0.541666666667 , 0.0416666666667 , 0.208333333333}, 0.889778162649},
  {{0.541666666667 , 0.125 , 0.125}, 0.889778162649},
  {{0.541666666667 , 0.208333333333 , 0.0416666666667}, 0.889778162649},
  {{0.625 , 0.0416666666667 , 0.125}, 0.889778162649},
  {{0.625 , 0.125 , 0.0416666666667}, 0.889778162649},
  {{0.708333333333 , 0.0416666666667 , 0.0416666666667}, 0.889778162649},
  {{0.0416666666667 , 0.0416666666667 , 0.625}, 0.889778162649},
  {{0.0416666666667 , 0.125 , 0.541666666667}, 0.889778162649},
  {{0.0416666666667 , 0.208333333333 , 0.458333333333}, 0.889778162649},
  {{0.0416666666667 , 0.291666666667 , 0.375}, 0.889778162649},
  {{0.0416666666667 , 0.375 , 0.291666666667}, 0.889778162649},
  {{0.0416666666667 , 0.458333333333 , 0.208333333333}, 0.889778162649},
  {{0.0416666666667 , 0.541666666667 , 0.125}, 0.889778162649},
  {{0.0416666666667 , 0.625 , 0.0416666666667}, 0.889778162649},
  {{0.125 , 0.0416666666667 , 0.541666666667}, 0.889778162649},
  {{0.125 , 0.125 , 0.458333333333}, 0.889778162649},
  {{0.125 , 0.208333333333 , 0.375}, 0.889778162649},
  {{0.125 , 0.291666666667 , 0.291666666667}, 0.889778162649},
  {{0.125 , 0.375 , 0.208333333333}, 0.889778162649},
  {{0.125 , 0.458333333333 , 0.125}, 0.889778162649},
  {{0.125 , 0.541666666667 , 0.0416666666667}, 0.889778162649},
  {{0.208333333333 , 0.0416666666667 , 0.458333333333}, 0.889778162649},
  {{0.208333333333 , 0.125 , 0.375}, 0.889778162649},
  {{0.208333333333 , 0.208333333333 , 0.291666666667}, 0.889778162649},
  {{0.208333333333 , 0.291666666667 , 0.208333333333}, 0.889778162649},
  {{0.208333333333 , 0.375 , 0.125}, 0.889778162649},
  {{0.208333333333 , 0.458333333333 , 0.0416666666667}, 0.889778162649},
  {{0.291666666667 , 0.0416666666667 , 0.375}, 0.889778162649},
  {{0.291666666667 , 0.125 , 0.291666666667}, 0.889778162649},
  {{0.291666666667 , 0.208333333333 , 0.208333333333}, 0.889778162649},
  {{0.291666666667 , 0.291666666667 , 0.125}, 0.889778162649},
  {{0.291666666667 , 0.375 , 0.0416666666667}, 0.889778162649},
  {{0.375 , 0.0416666666667 , 0.291666666667}, 0.889778162649},
  {{0.375 , 0.125 , 0.208333333333}, 0.889778162649},
  {{0.375 , 0.208333333333 , 0.125}, 0.889778162649},
  {{0.375 , 0.291666666667 , 0.0416666666667}, 0.889778162649},
  {{0.458333333333 , 0.0416666666667 , 0.208333333333}, 0.889778162649},
  {{0.458333333333 , 0.125 , 0.125}, 0.889778162649},
  {{0.458333333333 , 0.208333333333 , 0.0416666666667}, 0.889778162649},
  {{0.541666666667 , 0.0416666666667 , 0.125}, 0.889778162649},
  {{0.541666666667 , 0.125 , 0.0416666666667}, 0.889778162649},
  {{0.625 , 0.0416666666667 , 0.0416666666667}, 0.889778162649},
  {{0.0416666666667 , 0.0416666666667 , 0.541666666667}, 0.889778162649},
  {{0.0416666666667 , 0.125 , 0.458333333333}, 0.889778162649},
  {{0.0416666666667 , 0.208333333333 , 0.375}, 0.889778162649},
  {{0.0416666666667 , 0.291666666667 , 0.291666666667}, 0.889778162649},
  {{0.0416666666667 , 0.375 , 0.208333333333}, 0.889778162649},
  {{0.0416666666667 , 0.458333333333 , 0.125}, 0.889778162649},
  {{0.0416666666667 , 0.541666666667 , 0.0416666666667}, 0.889778162649},
  {{0.125 , 0.0416666666667 , 0.458333333333}, 0.889778162649},
  {{0.125 , 0.125 , 0.375}, 0.889778162649},
  {{0.125 , 0.208333333333 , 0.291666666667}, 0.889778162649},
  {{0.125 , 0.291666666667 , 0.208333333333}, 0.889778162649},
  {{0.125 , 0.375 , 0.125}, 0.889778162649},
  {{0.125 , 0.458333333333 , 0.0416666666667}, 0.889778162649},
  {{0.208333333333 , 0.0416666666667 , 0.375}, 0.889778162649},
  {{0.208333333333 , 0.125 , 0.291666666667}, 0.889778162649},
  {{0.208333333333 , 0.208333333333 , 0.208333333333}, 0.889778162649},
  {{0.208333333333 , 0.291666666667 , 0.125}, 0.889778162649},
  {{0.208333333333 , 0.375 , 0.0416666666667}, 0.889778162649},
  {{0.291666666667 , 0.0416666666667 , 0.291666666667}, 0.889778162649},
  {{0.291666666667 , 0.125 , 0.208333333333}, 0.889778162649},
  {{0.291666666667 , 0.208333333333 , 0.125}, 0.889778162649},
  {{0.291666666667 , 0.291666666667 , 0.0416666666667}, 0.889778162649},
  {{0.375 , 0.0416666666667 , 0.208333333333}, 0.889778162649},
  {{0.375 , 0.125 , 0.125}, 0.889778162649},
  {{0.375 , 0.208333333333 , 0.0416666666667}, 0.889778162649},
  {{0.458333333333 , 0.0416666666667 , 0.125}, 0.889778162649},
  {{0.458333333333 , 0.125 , 0.0416666666667}, 0.889778162649},
  {{0.541666666667 , 0.0416666666667 , 0.0416666666667}, 0.889778162649},
  {{0.0416666666667 , 0.0416666666667 , 0.458333333333}, 0.889778162649},
  {{0.0416666666667 , 0.125 , 0.375}, 0.889778162649},
  {{0.0416666666667 , 0.208333333333 , 0.291666666667}, 0.889778162649},
  {{0.0416666666667 , 0.291666666667 , 0.208333333333}, 0.889778162649},
  {{0.0416666666667 , 0.375 , 0.125}, 0.889778162649},
  {{0.0416666666667 , 0.458333333333 , 0.0416666666667}, 0.889778162649},
  {{0.125 , 0.0416666666667 , 0.375}, 0.889778162649},
  {{0.125 , 0.125 , 0.291666666667}, 0.889778162649},
  {{0.125 , 0.208333333333 , 0.208333333333}, 0.889778162649},
  {{0.125 , 0.291666666667 , 0.125}, 0.889778162649},
  {{0.125 , 0.375 , 0.0416666666667}, 0.889778162649},
  {{0.208333333333 , 0.0416666666667 , 0.291666666667}, 0.889778162649},
  {{0.208333333333 , 0.125 , 0.208333333333}, 0.889778162649},
  {{0.208333333333 , 0.208333333333 , 0.125}, 0.889778162649},
  {{0.208333333333 , 0.291666666667 , 0.0416666666667}, 0.889778162649},
  {{0.291666666667 , 0.0416666666667 , 0.208333333333}, 0.889778162649},
  {{0.291666666667 , 0.125 , 0.125}, 0.889778162649},
  {{0.291666666667 , 0.208333333333 , 0.0416666666667}, 0.889778162649},
  {{0.375 , 0.0416666666667 , 0.125}, 0.889778162649},
  {{0.375 , 0.125 , 0.0416666666667}, 0.889778162649},
  {{0.458333333333 , 0.0416666666667 , 0.0416666666667}, 0.889778162649},
  {{0.0416666666667 , 0.0416666666667 , 0.375}, 0.889778162649},
  {{0.0416666666667 , 0.125 , 0.291666666667}, 0.889778162649},
  {{0.0416666666667 , 0.208333333333 , 0.208333333333}, 0.889778162649},
  {{0.0416666666667 , 0.291666666667 , 0.125}, 0.889778162649},
  {{0.0416666666667 , 0.375 , 0.0416666666667}, 0.889778162649},
  {{0.125 , 0.0416666666667 , 0.291666666667}, 0.889778162649},
  {{0.125 , 0.125 , 0.208333333333}, 0.889778162649},
  {{0.125 , 0.208333333333 , 0.125}, 0.889778162649},
  {{0.125 , 0.291666666667 , 0.0416666666667}, 0.889778162649},
  {{0.208333333333 , 0.0416666666667 , 0.208333333333}, 0.889778162649},
  {{0.208333333333 , 0.125 , 0.125}, 0.889778162649},
  {{0.208333333333 , 0.208333333333 , 0.0416666666667}, 0.889778162649},
  {{0.291666666667 , 0.0416666666667 , 0.125}, 0.889778162649},
  {{0.291666666667 , 0.125 , 0.0416666666667}, 0.889778162649},
  {{0.375 , 0.0416666666667 , 0.0416666666667}, 0.889778162649},
  {{0.0416666666667 , 0.0416666666667 , 0.291666666667}, 0.889778162649},
  {{0.0416666666667 , 0.125 , 0.208333333333}, 0.889778162649},
  {{0.0416666666667 , 0.208333333333 , 0.125}, 0.889778162649},
  {{0.0416666666667 , 0.291666666667 , 0.0416666666667}, 0.889778162649},
  {{0.125 , 0.0416666666667 , 0.208333333333}, 0.889778162649},
  {{0.125 , 0.125 , 0.125}, 0.889778162649},
  {{0.125 , 0.208333333333 , 0.0416666666667}, 0.889778162649},
  {{0.208333333333 , 0.0416666666667 , 0.125}, 0.889778162649},
  {{0.208333333333 , 0.125 , 0.0416666666667}, 0.889778162649},
  {{0.291666666667 , 0.0416666666667 , 0.0416666666667}, 0.889778162649},
  {{0.0416666666667 , 0.0416666666667 , 0.208333333333}, 0.889778162649},
  {{0.0416666666667 , 0.125 , 0.125}, 0.889778162649},
  {{0.0416666666667 , 0.208333333333 , 0.0416666666667}, 0.889778162649},
  {{0.125 , 0.0416666666667 , 0.125}, 0.889778162649},
  {{0.125 , 0.125 , 0.0416666666667}, 0.889778162649},
  {{0.208333333333 , 0.0416666666667 , 0.0416666666667}, 0.889778162649},
  {{0.0416666666667 , 0.0416666666667 , 0.125}, 0.889778162649},
  {{0.0416666666667 , 0.125 , 0.0416666666667}, 0.889778162649},
  {{0.125 , 0.0416666666667 , 0.0416666666667}, 0.889778162649},
  {{0.0416666666667 , 0.0416666666667 , 0.0416666666667}, 0.889778162649},
  {{0.0454545454545 , 0.0454545454545 , 0.863636363636}, -3.43505113075},
  {{0.0454545454545 , 0.136363636364 , 0.772727272727}, -3.43505113075},
  {{0.0454545454545 , 0.227272727273 , 0.681818181818}, -3.43505113075},
  {{0.0454545454545 , 0.318181818182 , 0.590909090909}, -3.43505113075},
  {{0.0454545454545 , 0.409090909091 , 0.5}, -3.43505113075},
  {{0.0454545454545 , 0.5 , 0.409090909091}, -3.43505113075},
  {{0.0454545454545 , 0.590909090909 , 0.318181818182}, -3.43505113075},
  {{0.0454545454545 , 0.681818181818 , 0.227272727273}, -3.43505113075},
  {{0.0454545454545 , 0.772727272727 , 0.136363636364}, -3.43505113075},
  {{0.0454545454545 , 0.863636363636 , 0.0454545454545}, -3.43505113075},
  {{0.136363636364 , 0.0454545454545 , 0.772727272727}, -3.43505113075},
  {{0.136363636364 , 0.136363636364 , 0.681818181818}, -3.43505113075},
  {{0.136363636364 , 0.227272727273 , 0.590909090909}, -3.43505113075},
  {{0.136363636364 , 0.318181818182 , 0.5}, -3.43505113075},
  {{0.136363636364 , 0.409090909091 , 0.409090909091}, -3.43505113075},
  {{0.136363636364 , 0.5 , 0.318181818182}, -3.43505113075},
  {{0.136363636364 , 0.590909090909 , 0.227272727273}, -3.43505113075},
  {{0.136363636364 , 0.681818181818 , 0.136363636364}, -3.43505113075},
  {{0.136363636364 , 0.772727272727 , 0.0454545454545}, -3.43505113075},
  {{0.227272727273 , 0.0454545454545 , 0.681818181818}, -3.43505113075},
  {{0.227272727273 , 0.136363636364 , 0.590909090909}, -3.43505113075},
  {{0.227272727273 , 0.227272727273 , 0.5}, -3.43505113075},
  {{0.227272727273 , 0.318181818182 , 0.409090909091}, -3.43505113075},
  {{0.227272727273 , 0.409090909091 , 0.318181818182}, -3.43505113075},
  {{0.227272727273 , 0.5 , 0.227272727273}, -3.43505113075},
  {{0.227272727273 , 0.590909090909 , 0.136363636364}, -3.43505113075},
  {{0.227272727273 , 0.681818181818 , 0.0454545454545}, -3.43505113075},
  {{0.318181818182 , 0.0454545454545 , 0.590909090909}, -3.43505113075},
  {{0.318181818182 , 0.136363636364 , 0.5}, -3.43505113075},
  {{0.318181818182 , 0.227272727273 , 0.409090909091}, -3.43505113075},
  {{0.318181818182 , 0.318181818182 , 0.318181818182}, -3.43505113075},
  {{0.318181818182 , 0.409090909091 , 0.227272727273}, -3.43505113075},
  {{0.318181818182 , 0.5 , 0.136363636364}, -3.43505113075},
  {{0.318181818182 , 0.590909090909 , 0.0454545454545}, -3.43505113075},
  {{0.409090909091 , 0.0454545454545 , 0.5}, -3.43505113075},
  {{0.409090909091 , 0.136363636364 , 0.409090909091}, -3.43505113075},
  {{0.409090909091 , 0.227272727273 , 0.318181818182}, -3.43505113075},
  {{0.409090909091 , 0.318181818182 , 0.227272727273}, -3.43505113075},
  {{0.409090909091 , 0.409090909091 , 0.136363636364}, -3.43505113075},
  {{0.409090909091 , 0.5 , 0.0454545454545}, -3.43505113075},
  {{0.5 , 0.0454545454545 , 0.409090909091}, -3.43505113075},
  {{0.5 , 0.136363636364 , 0.318181818182}, -3.43505113075},
  {{0.5 , 0.227272727273 , 0.227272727273}, -3.43505113075},
  {{0.5 , 0.318181818182 , 0.136363636364}, -3.43505113075},
  {{0.5 , 0.409090909091 , 0.0454545454545}, -3.43505113075},
  {{0.590909090909 , 0.0454545454545 , 0.318181818182}, -3.43505113075},
  {{0.590909090909 , 0.136363636364 , 0.227272727273}, -3.43505113075},
  {{0.590909090909 , 0.227272727273 , 0.136363636364}, -3.43505113075},
  {{0.590909090909 , 0.318181818182 , 0.0454545454545}, -3.43505113075},
  {{0.681818181818 , 0.0454545454545 , 0.227272727273}, -3.43505113075},
  {{0.681818181818 , 0.136363636364 , 0.136363636364}, -3.43505113075},
  {{0.681818181818 , 0.227272727273 , 0.0454545454545}, -3.43505113075},
  {{0.772727272727 , 0.0454545454545 , 0.136363636364}, -3.43505113075},
  {{0.772727272727 , 0.136363636364 , 0.0454545454545}, -3.43505113075},
  {{0.863636363636 , 0.0454545454545 , 0.0454545454545}, -3.43505113075},
  {{0.0454545454545 , 0.0454545454545 , 0.772727272727}, -3.43505113075},
  {{0.0454545454545 , 0.136363636364 , 0.681818181818}, -3.43505113075},
  {{0.0454545454545 , 0.227272727273 , 0.590909090909}, -3.43505113075},
  {{0.0454545454545 , 0.318181818182 , 0.5}, -3.43505113075},
  {{0.0454545454545 , 0.409090909091 , 0.409090909091}, -3.43505113075},
  {{0.0454545454545 , 0.5 , 0.318181818182}, -3.43505113075},
  {{0.0454545454545 , 0.590909090909 , 0.227272727273}, -3.43505113075},
  {{0.0454545454545 , 0.681818181818 , 0.136363636364}, -3.43505113075},
  {{0.0454545454545 , 0.772727272727 , 0.0454545454545}, -3.43505113075},
  {{0.136363636364 , 0.0454545454545 , 0.681818181818}, -3.43505113075},
  {{0.136363636364 , 0.136363636364 , 0.590909090909}, -3.43505113075},
  {{0.136363636364 , 0.227272727273 , 0.5}, -3.43505113075},
  {{0.136363636364 , 0.318181818182 , 0.409090909091}, -3.43505113075},
  {{0.136363636364 , 0.409090909091 , 0.318181818182}, -3.43505113075},
  {{0.136363636364 , 0.5 , 0.227272727273}, -3.43505113075},
  {{0.136363636364 , 0.590909090909 , 0.136363636364}, -3.43505113075},
  {{0.136363636364 , 0.681818181818 , 0.0454545454545}, -3.43505113075},
  {{0.227272727273 , 0.0454545454545 , 0.590909090909}, -3.43505113075},
  {{0.227272727273 , 0.136363636364 , 0.5}, -3.43505113075},
  {{0.227272727273 , 0.227272727273 , 0.409090909091}, -3.43505113075},
  {{0.227272727273 , 0.318181818182 , 0.318181818182}, -3.43505113075},
  {{0.227272727273 , 0.409090909091 , 0.227272727273}, -3.43505113075},
  {{0.227272727273 , 0.5 , 0.136363636364}, -3.43505113075},
  {{0.227272727273 , 0.590909090909 , 0.0454545454545}, -3.43505113075},
  {{0.318181818182 , 0.0454545454545 , 0.5}, -3.43505113075},
  {{0.318181818182 , 0.136363636364 , 0.409090909091}, -3.43505113075},
  {{0.318181818182 , 0.227272727273 , 0.318181818182}, -3.43505113075},
  {{0.318181818182 , 0.318181818182 , 0.227272727273}, -3.43505113075},
  {{0.318181818182 , 0.409090909091 , 0.136363636364}, -3.43505113075},
  {{0.318181818182 , 0.5 , 0.0454545454545}, -3.43505113075},
  {{0.409090909091 , 0.0454545454545 , 0.409090909091}, -3.43505113075},
  {{0.409090909091 , 0.136363636364 , 0.318181818182}, -3.43505113075},
  {{0.409090909091 , 0.227272727273 , 0.227272727273}, -3.43505113075},
  {{0.409090909091 , 0.318181818182 , 0.136363636364}, -3.43505113075},
  {{0.409090909091 , 0.409090909091 , 0.0454545454545}, -3.43505113075},
  {{0.5 , 0.0454545454545 , 0.318181818182}, -3.43505113075},
  {{0.5 , 0.136363636364 , 0.227272727273}, -3.43505113075},
  {{0.5 , 0.227272727273 , 0.136363636364}, -3.43505113075},
  {{0.5 , 0.318181818182 , 0.0454545454545}, -3.43505113075},
  {{0.590909090909 , 0.0454545454545 , 0.227272727273}, -3.43505113075},
  {{0.590909090909 , 0.136363636364 , 0.136363636364}, -3.43505113075},
  {{0.590909090909 , 0.227272727273 , 0.0454545454545}, -3.43505113075},
  {{0.681818181818 , 0.0454545454545 , 0.136363636364}, -3.43505113075},
  {{0.681818181818 , 0.136363636364 , 0.0454545454545}, -3.43505113075},
  {{0.772727272727 , 0.0454545454545 , 0.0454545454545}, -3.43505113075},
  {{0.0454545454545 , 0.0454545454545 , 0.681818181818}, -3.43505113075},
  {{0.0454545454545 , 0.136363636364 , 0.590909090909}, -3.43505113075},
  {{0.0454545454545 , 0.227272727273 , 0.5}, -3.43505113075},
  {{0.0454545454545 , 0.318181818182 , 0.409090909091}, -3.43505113075},
  {{0.0454545454545 , 0.409090909091 , 0.318181818182}, -3.43505113075},
  {{0.0454545454545 , 0.5 , 0.227272727273}, -3.43505113075},
  {{0.0454545454545 , 0.590909090909 , 0.136363636364}, -3.43505113075},
  {{0.0454545454545 , 0.681818181818 , 0.0454545454545}, -3.43505113075},
  {{0.136363636364 , 0.0454545454545 , 0.590909090909}, -3.43505113075},
  {{0.136363636364 , 0.136363636364 , 0.5}, -3.43505113075},
  {{0.136363636364 , 0.227272727273 , 0.409090909091}, -3.43505113075},
  {{0.136363636364 , 0.318181818182 , 0.318181818182}, -3.43505113075},
  {{0.136363636364 , 0.409090909091 , 0.227272727273}, -3.43505113075},
  {{0.136363636364 , 0.5 , 0.136363636364}, -3.43505113075},
  {{0.136363636364 , 0.590909090909 , 0.0454545454545}, -3.43505113075},
  {{0.227272727273 , 0.0454545454545 , 0.5}, -3.43505113075},
  {{0.227272727273 , 0.136363636364 , 0.409090909091}, -3.43505113075},
  {{0.227272727273 , 0.227272727273 , 0.318181818182}, -3.43505113075},
  {{0.227272727273 , 0.318181818182 , 0.227272727273}, -3.43505113075},
  {{0.227272727273 , 0.409090909091 , 0.136363636364}, -3.43505113075},
  {{0.227272727273 , 0.5 , 0.0454545454545}, -3.43505113075},
  {{0.318181818182 , 0.0454545454545 , 0.409090909091}, -3.43505113075},
  {{0.318181818182 , 0.136363636364 , 0.318181818182}, -3.43505113075},
  {{0.318181818182 , 0.227272727273 , 0.227272727273}, -3.43505113075},
  {{0.318181818182 , 0.318181818182 , 0.136363636364}, -3.43505113075},
  {{0.318181818182 , 0.409090909091 , 0.0454545454545}, -3.43505113075},
  {{0.409090909091 , 0.0454545454545 , 0.318181818182}, -3.43505113075},
  {{0.409090909091 , 0.136363636364 , 0.227272727273}, -3.43505113075},
  {{0.409090909091 , 0.227272727273 , 0.136363636364}, -3.43505113075},
  {{0.409090909091 , 0.318181818182 , 0.0454545454545}, -3.43505113075},
  {{0.5 , 0.0454545454545 , 0.227272727273}, -3.43505113075},
  {{0.5 , 0.136363636364 , 0.136363636364}, -3.43505113075},
  {{0.5 , 0.227272727273 , 0.0454545454545}, -3.43505113075},
  {{0.590909090909 , 0.0454545454545 , 0.136363636364}, -3.43505113075},
  {{0.590909090909 , 0.136363636364 , 0.0454545454545}, -3.43505113075},
  {{0.681818181818 , 0.0454545454545 , 0.0454545454545}, -3.43505113075},
  {{0.0454545454545 , 0.0454545454545 , 0.590909090909}, -3.43505113075},
  {{0.0454545454545 , 0.136363636364 , 0.5}, -3.43505113075},
  {{0.0454545454545 , 0.227272727273 , 0.409090909091}, -3.43505113075},
  {{0.0454545454545 , 0.318181818182 , 0.318181818182}, -3.43505113075},
  {{0.0454545454545 , 0.409090909091 , 0.227272727273}, -3.43505113075},
  {{0.0454545454545 , 0.5 , 0.136363636364}, -3.43505113075},
  {{0.0454545454545 , 0.590909090909 , 0.0454545454545}, -3.43505113075},
  {{0.136363636364 , 0.0454545454545 , 0.5}, -3.43505113075},
  {{0.136363636364 , 0.136363636364 , 0.409090909091}, -3.43505113075},
  {{0.136363636364 , 0.227272727273 , 0.318181818182}, -3.43505113075},
  {{0.136363636364 , 0.318181818182 , 0.227272727273}, -3.43505113075},
  {{0.136363636364 , 0.409090909091 , 0.136363636364}, -3.43505113075},
  {{0.136363636364 , 0.5 , 0.0454545454545}, -3.43505113075},
  {{0.227272727273 , 0.0454545454545 , 0.409090909091}, -3.43505113075},
  {{0.227272727273 , 0.136363636364 , 0.318181818182}, -3.43505113075},
  {{0.227272727273 , 0.227272727273 , 0.227272727273}, -3.43505113075},
  {{0.227272727273 , 0.318181818182 , 0.136363636364}, -3.43505113075},
  {{0.227272727273 , 0.409090909091 , 0.0454545454545}, -3.43505113075},
  {{0.318181818182 , 0.0454545454545 , 0.318181818182}, -3.43505113075},
  {{0.318181818182 , 0.136363636364 , 0.227272727273}, -3.43505113075},
  {{0.318181818182 , 0.227272727273 , 0.136363636364}, -3.43505113075},
  {{0.318181818182 , 0.318181818182 , 0.0454545454545}, -3.43505113075},
  {{0.409090909091 , 0.0454545454545 , 0.227272727273}, -3.43505113075},
  {{0.409090909091 , 0.136363636364 , 0.136363636364}, -3.43505113075},
  {{0.409090909091 , 0.227272727273 , 0.0454545454545}, -3.43505113075},
  {{0.5 , 0.0454545454545 , 0.136363636364}, -3.43505113075},
  {{0.5 , 0.136363636364 , 0.0454545454545}, -3.43505113075},
  {{0.590909090909 , 0.0454545454545 , 0.0454545454545}, -3.43505113075},
  {{0.0454545454545 , 0.0454545454545 , 0.5}, -3.43505113075},
  {{0.0454545454545 , 0.136363636364 , 0.409090909091}, -3.43505113075},
  {{0.0454545454545 , 0.227272727273 , 0.318181818182}, -3.43505113075},
  {{0.0454545454545 , 0.318181818182 , 0.227272727273}, -3.43505113075},
  {{0.0454545454545 , 0.409090909091 , 0.136363636364}, -3.43505113075},
  {{0.0454545454545 , 0.5 , 0.0454545454545}, -3.43505113075},
  {{0.136363636364 , 0.0454545454545 , 0.409090909091}, -3.43505113075},
  {{0.136363636364 , 0.136363636364 , 0.318181818182}, -3.43505113075},
  {{0.136363636364 , 0.227272727273 , 0.227272727273}, -3.43505113075},
  {{0.136363636364 , 0.318181818182 , 0.136363636364}, -3.43505113075},
  {{0.136363636364 , 0.409090909091 , 0.0454545454545}, -3.43505113075},
  {{0.227272727273 , 0.0454545454545 , 0.318181818182}, -3.43505113075},
  {{0.227272727273 , 0.136363636364 , 0.227272727273}, -3.43505113075},
  {{0.227272727273 , 0.227272727273 , 0.136363636364}, -3.43505113075},
  {{0.227272727273 , 0.318181818182 , 0.0454545454545}, -3.43505113075},
  {{0.318181818182 , 0.0454545454545 , 0.227272727273}, -3.43505113075},
  {{0.318181818182 , 0.136363636364 , 0.136363636364}, -3.43505113075},
  {{0.318181818182 , 0.227272727273 , 0.0454545454545}, -3.43505113075},
  {{0.409090909091 , 0.0454545454545 , 0.136363636364}, -3.43505113075},
  {{0.409090909091 , 0.136363636364 , 0.0454545454545}, -3.43505113075},
  {{0.5 , 0.0454545454545 , 0.0454545454545}, -3.43505113075},
  {{0.0454545454545 , 0.0454545454545 , 0.409090909091}, -3.43505113075},
  {{0.0454545454545 , 0.136363636364 , 0.318181818182}, -3.43505113075},
  {{0.0454545454545 , 0.227272727273 , 0.227272727273}, -3.43505113075},
  {{0.0454545454545 , 0.318181818182 , 0.136363636364}, -3.43505113075},
  {{0.0454545454545 , 0.409090909091 , 0.0454545454545}, -3.43505113075},
  {{0.136363636364 , 0.0454545454545 , 0.318181818182}, -3.43505113075},
  {{0.136363636364 , 0.136363636364 , 0.227272727273}, -3.43505113075},
  {{0.136363636364 , 0.227272727273 , 0.136363636364}, -3.43505113075},
  {{0.136363636364 , 0.318181818182 , 0.0454545454545}, -3.43505113075},
  {{0.227272727273 , 0.0454545454545 , 0.227272727273}, -3.43505113075},
  {{0.227272727273 , 0.136363636364 , 0.136363636364}, -3.43505113075},
  {{0.227272727273 , 0.227272727273 , 0.0454545454545}, -3.43505113075},
  {{0.318181818182 , 0.0454545454545 , 0.136363636364}, -3.43505113075},
  {{0.318181818182 , 0.136363636364 , 0.0454545454545}, -3.43505113075},
  {{0.409090909091 , 0.0454545454545 , 0.0454545454545}, -3.43505113075},
  {{0.0454545454545 , 0.0454545454545 , 0.318181818182}, -3.43505113075},
  {{0.0454545454545 , 0.136363636364 , 0.227272727273}, -3.43505113075},
  {{0.0454545454545 , 0.227272727273 , 0.136363636364}, -3.43505113075},
  {{0.0454545454545 , 0.318181818182 , 0.0454545454545}, -3.43505113075},
  {{0.136363636364 , 0.0454545454545 , 0.227272727273}, -3.43505113075},
  {{0.136363636364 , 0.136363636364 , 0.136363636364}, -3.43505113075},
  {{0.136363636364 , 0.227272727273 , 0.0454545454545}, -3.43505113075},
  {{0.227272727273 , 0.0454545454545 , 0.136363636364}, -3.43505113075},
  {{0.227272727273 , 0.136363636364 , 0.0454545454545}, -3.43505113075},
  {{0.318181818182 , 0.0454545454545 , 0.0454545454545}, -3.43505113075},
  {{0.0454545454545 , 0.0454545454545 , 0.227272727273}, -3.43505113075},
  {{0.0454545454545 , 0.136363636364 , 0.136363636364}, -3.43505113075},
  {{0.0454545454545 , 0.227272727273 , 0.0454545454545}, -3.43505113075},
  {{0.136363636364 , 0.0454545454545 , 0.136363636364}, -3.43505113075},
  {{0.136363636364 , 0.136363636364 , 0.0454545454545}, -3.43505113075},
  {{0.227272727273 , 0.0454545454545 , 0.0454545454545}, -3.43505113075},
  {{0.0454545454545 , 0.0454545454545 , 0.136363636364}, -3.43505113075},
  {{0.0454545454545 , 0.136363636364 , 0.0454545454545}, -3.43505113075},
  {{0.136363636364 , 0.0454545454545 , 0.0454545454545}, -3.43505113075},
  {{0.0454545454545 , 0.0454545454545 , 0.0454545454545}, -3.43505113075},
  {{0.05 , 0.05 , 0.85}, 5.33807483547},
  {{0.05 , 0.15 , 0.75}, 5.33807483547},
  {{0.05 , 0.25 , 0.65}, 5.33807483547},
  {{0.05 , 0.35 , 0.55}, 5.33807483547},
  {{0.05 , 0.45 , 0.45}, 5.33807483547},
  {{0.05 , 0.55 , 0.35}, 5.33807483547},
  {{0.05 , 0.65 , 0.25}, 5.33807483547},
  {{0.05 , 0.75 , 0.15}, 5.33807483547},
  {{0.05 , 0.85 , 0.05}, 5.33807483547},
  {{0.15 , 0.05 , 0.75}, 5.33807483547},
  {{0.15 , 0.15 , 0.65}, 5.33807483547},
  {{0.15 , 0.25 , 0.55}, 5.33807483547},
  {{0.15 , 0.35 , 0.45}, 5.33807483547},
  {{0.15 , 0.45 , 0.35}, 5.33807483547},
  {{0.15 , 0.55 , 0.25}, 5.33807483547},
  {{0.15 , 0.65 , 0.15}, 5.33807483547},
  {{0.15 , 0.75 , 0.05}, 5.33807483547},
  {{0.25 , 0.05 , 0.65}, 5.33807483547},
  {{0.25 , 0.15 , 0.55}, 5.33807483547},
  {{0.25 , 0.25 , 0.45}, 5.33807483547},
  {{0.25 , 0.35 , 0.35}, 5.33807483547},
  {{0.25 , 0.45 , 0.25}, 5.33807483547},
  {{0.25 , 0.55 , 0.15}, 5.33807483547},
  {{0.25 , 0.65 , 0.05}, 5.33807483547},
  {{0.35 , 0.05 , 0.55}, 5.33807483547},
  {{0.35 , 0.15 , 0.45}, 5.33807483547},
  {{0.35 , 0.25 , 0.35}, 5.33807483547},
  {{0.35 , 0.35 , 0.25}, 5.33807483547},
  {{0.35 , 0.45 , 0.15}, 5.33807483547},
  {{0.35 , 0.55 , 0.05}, 5.33807483547},
  {{0.45 , 0.05 , 0.45}, 5.33807483547},
  {{0.45 , 0.15 , 0.35}, 5.33807483547},
  {{0.45 , 0.25 , 0.25}, 5.33807483547},
  {{0.45 , 0.35 , 0.15}, 5.33807483547},
  {{0.45 , 0.45 , 0.05}, 5.33807483547},
  {{0.55 , 0.05 , 0.35}, 5.33807483547},
  {{0.55 , 0.15 , 0.25}, 5.33807483547},
  {{0.55 , 0.25 , 0.15}, 5.33807483547},
  {{0.55 , 0.35 , 0.05}, 5.33807483547},
  {{0.65 , 0.05 , 0.25}, 5.33807483547},
  {{0.65 , 0.15 , 0.15}, 5.33807483547},
  {{0.65 , 0.25 , 0.05}, 5.33807483547},
  {{0.75 , 0.05 , 0.15}, 5.33807483547},
  {{0.75 , 0.15 , 0.05}, 5.33807483547},
  {{0.85 , 0.05 , 0.05}, 5.33807483547},
  {{0.05 , 0.05 , 0.75}, 5.33807483547},
  {{0.05 , 0.15 , 0.65}, 5.33807483547},
  {{0.05 , 0.25 , 0.55}, 5.33807483547},
  {{0.05 , 0.35 , 0.45}, 5.33807483547},
  {{0.05 , 0.45 , 0.35}, 5.33807483547},
  {{0.05 , 0.55 , 0.25}, 5.33807483547},
  {{0.05 , 0.65 , 0.15}, 5.33807483547},
  {{0.05 , 0.75 , 0.05}, 5.33807483547},
  {{0.15 , 0.05 , 0.65}, 5.33807483547},
  {{0.15 , 0.15 , 0.55}, 5.33807483547},
  {{0.15 , 0.25 , 0.45}, 5.33807483547},
  {{0.15 , 0.35 , 0.35}, 5.33807483547},
  {{0.15 , 0.45 , 0.25}, 5.33807483547},
  {{0.15 , 0.55 , 0.15}, 5.33807483547},
  {{0.15 , 0.65 , 0.05}, 5.33807483547},
  {{0.25 , 0.05 , 0.55}, 5.33807483547},
  {{0.25 , 0.15 , 0.45}, 5.33807483547},
  {{0.25 , 0.25 , 0.35}, 5.33807483547},
  {{0.25 , 0.35 , 0.25}, 5.33807483547},
  {{0.25 , 0.45 , 0.15}, 5.33807483547},
  {{0.25 , 0.55 , 0.05}, 5.33807483547},
  {{0.35 , 0.05 , 0.45}, 5.33807483547},
  {{0.35 , 0.15 , 0.35}, 5.33807483547},
  {{0.35 , 0.25 , 0.25}, 5.33807483547},
  {{0.35 , 0.35 , 0.15}, 5.33807483547},
  {{0.35 , 0.45 , 0.05}, 5.33807483547},
  {{0.45 , 0.05 , 0.35}, 5.33807483547},
  {{0.45 , 0.15 , 0.25}, 5.33807483547},
  {{0.45 , 0.25 , 0.15}, 5.33807483547},
  {{0.45 , 0.35 , 0.05}, 5.33807483547},
  {{0.55 , 0.05 , 0.25}, 5.33807483547},
  {{0.55 , 0.15 , 0.15}, 5.33807483547},
  {{0.55 , 0.25 , 0.05}, 5.33807483547},
  {{0.65 , 0.05 , 0.15}, 5.33807483547},
  {{0.65 , 0.15 , 0.05}, 5.33807483547},
  {{0.75 , 0.05 , 0.05}, 5.33807483547},
  {{0.05 , 0.05 , 0.65}, 5.33807483547},
  {{0.05 , 0.15 , 0.55}, 5.33807483547},
  {{0.05 , 0.25 , 0.45}, 5.33807483547},
  {{0.05 , 0.35 , 0.35}, 5.33807483547},
  {{0.05 , 0.45 , 0.25}, 5.33807483547},
  {{0.05 , 0.55 , 0.15}, 5.33807483547},
  {{0.05 , 0.65 , 0.05}, 5.33807483547},
  {{0.15 , 0.05 , 0.55}, 5.33807483547},
  {{0.15 , 0.15 , 0.45}, 5.33807483547},
  {{0.15 , 0.25 , 0.35}, 5.33807483547},
  {{0.15 , 0.35 , 0.25}, 5.33807483547},
  {{0.15 , 0.45 , 0.15}, 5.33807483547},
  {{0.15 , 0.55 , 0.05}, 5.33807483547},
  {{0.25 , 0.05 , 0.45}, 5.33807483547},
  {{0.25 , 0.15 , 0.35}, 5.33807483547},
  {{0.25 , 0.25 , 0.25}, 5.33807483547},
  {{0.25 , 0.35 , 0.15}, 5.33807483547},
  {{0.25 , 0.45 , 0.05}, 5.33807483547},
  {{0.35 , 0.05 , 0.35}, 5.33807483547},
  {{0.35 , 0.15 , 0.25}, 5.33807483547},
  {{0.35 , 0.25 , 0.15}, 5.33807483547},
  {{0.35 , 0.35 , 0.05}, 5.33807483547},
  {{0.45 , 0.05 , 0.25}, 5.33807483547},
  {{0.45 , 0.15 , 0.15}, 5.33807483547},
  {{0.45 , 0.25 , 0.05}, 5.33807483547},
  {{0.55 , 0.05 , 0.15}, 5.33807483547},
  {{0.55 , 0.15 , 0.05}, 5.33807483547},
  {{0.65 , 0.05 , 0.05}, 5.33807483547},
  {{0.05 , 0.05 , 0.55}, 5.33807483547},
  {{0.05 , 0.15 , 0.45}, 5.33807483547},
  {{0.05 , 0.25 , 0.35}, 5.33807483547},
  {{0.05 , 0.35 , 0.25}, 5.33807483547},
  {{0.05 , 0.45 , 0.15}, 5.33807483547},
  {{0.05 , 0.55 , 0.05}, 5.33807483547},
  {{0.15 , 0.05 , 0.45}, 5.33807483547},
  {{0.15 , 0.15 , 0.35}, 5.33807483547},
  {{0.15 , 0.25 , 0.25}, 5.33807483547},
  {{0.15 , 0.35 , 0.15}, 5.33807483547},
  {{0.15 , 0.45 , 0.05}, 5.33807483547},
  {{0.25 , 0.05 , 0.35}, 5.33807483547},
  {{0.25 , 0.15 , 0.25}, 5.33807483547},
  {{0.25 , 0.25 , 0.15}, 5.33807483547},
  {{0.25 , 0.35 , 0.05}, 5.33807483547},
  {{0.35 , 0.05 , 0.25}, 5.33807483547},
  {{0.35 , 0.15 , 0.15}, 5.33807483547},
  {{0.35 , 0.25 , 0.05}, 5.33807483547},
  {{0.45 , 0.05 , 0.15}, 5.33807483547},
  {{0.45 , 0.15 , 0.05}, 5.33807483547},
  {{0.55 , 0.05 , 0.05}, 5.33807483547},
  {{0.05 , 0.05 , 0.45}, 5.33807483547},
  {{0.05 , 0.15 , 0.35}, 5.33807483547},
  {{0.05 , 0.25 , 0.25}, 5.33807483547},
  {{0.05 , 0.35 , 0.15}, 5.33807483547},
  {{0.05 , 0.45 , 0.05}, 5.33807483547},
  {{0.15 , 0.05 , 0.35}, 5.33807483547},
  {{0.15 , 0.15 , 0.25}, 5.33807483547},
  {{0.15 , 0.25 , 0.15}, 5.33807483547},
  {{0.15 , 0.35 , 0.05}, 5.33807483547},
  {{0.25 , 0.05 , 0.25}, 5.33807483547},
  {{0.25 , 0.15 , 0.15}, 5.33807483547},
  {{0.25 , 0.25 , 0.05}, 5.33807483547},
  {{0.35 , 0.05 , 0.15}, 5.33807483547},
  {{0.35 , 0.15 , 0.05}, 5.33807483547},
  {{0.45 , 0.05 , 0.05}, 5.33807483547},
  {{0.05 , 0.05 , 0.35}, 5.33807483547},
  {{0.05 , 0.15 , 0.25}, 5.33807483547},
  {{0.05 , 0.25 , 0.15}, 5.33807483547},
  {{0.05 , 0.35 , 0.05}, 5.33807483547},
  {{0.15 , 0.05 , 0.25}, 5.33807483547},
  {{0.15 , 0.15 , 0.15}, 5.33807483547},
  {{0.15 , 0.25 , 0.05}, 5.33807483547},
  {{0.25 , 0.05 , 0.15}, 5.33807483547},
  {{0.25 , 0.15 , 0.05}, 5.33807483547},
  {{0.35 , 0.05 , 0.05}, 5.33807483547},
  {{0.05 , 0.05 , 0.25}, 5.33807483547},
  {{0.05 , 0.15 , 0.15}, 5.33807483547},
  {{0.05 , 0.25 , 0.05}, 5.33807483547},
  {{0.15 , 0.05 , 0.15}, 5.33807483547},
  {{0.15 , 0.15 , 0.05}, 5.33807483547},
  {{0.25 , 0.05 , 0.05}, 5.33807483547},
  {{0.05 , 0.05 , 0.15}, 5.33807483547},
  {{0.05 , 0.15 , 0.05}, 5.33807483547},
  {{0.15 , 0.05 , 0.05}, 5.33807483547},
  {{0.05 , 0.05 , 0.05}, 5.33807483547},
  {{0.0555555555556 , 0.0555555555556 , 0.833333333333}, -4.28330285097},
  {{0.0555555555556 , 0.166666666667 , 0.722222222222}, -4.28330285097},
  {{0.0555555555556 , 0.277777777778 , 0.611111111111}, -4.28330285097},
  {{0.0555555555556 , 0.388888888889 , 0.5}, -4.28330285097},
  {{0.0555555555556 , 0.5 , 0.388888888889}, -4.28330285097},
  {{0.0555555555556 , 0.611111111111 , 0.277777777778}, -4.28330285097},
  {{0.0555555555556 , 0.722222222222 , 0.166666666667}, -4.28330285097},
  {{0.0555555555556 , 0.833333333333 , 0.0555555555556}, -4.28330285097},
  {{0.166666666667 , 0.0555555555556 , 0.722222222222}, -4.28330285097},
  {{0.166666666667 , 0.166666666667 , 0.611111111111}, -4.28330285097},
  {{0.166666666667 , 0.277777777778 , 0.5}, -4.28330285097},
  {{0.166666666667 , 0.388888888889 , 0.388888888889}, -4.28330285097},
  {{0.166666666667 , 0.5 , 0.277777777778}, -4.28330285097},
  {{0.166666666667 , 0.611111111111 , 0.166666666667}, -4.28330285097},
  {{0.166666666667 , 0.722222222222 , 0.0555555555556}, -4.28330285097},
  {{0.277777777778 , 0.0555555555556 , 0.611111111111}, -4.28330285097},
  {{0.277777777778 , 0.166666666667 , 0.5}, -4.28330285097},
  {{0.277777777778 , 0.277777777778 , 0.388888888889}, -4.28330285097},
  {{0.277777777778 , 0.388888888889 , 0.277777777778}, -4.28330285097},
  {{0.277777777778 , 0.5 , 0.166666666667}, -4.28330285097},
  {{0.277777777778 , 0.611111111111 , 0.0555555555556}, -4.28330285097},
  {{0.388888888889 , 0.0555555555556 , 0.5}, -4.28330285097},
  {{0.388888888889 , 0.166666666667 , 0.388888888889}, -4.28330285097},
  {{0.388888888889 , 0.277777777778 , 0.277777777778}, -4.28330285097},
  {{0.388888888889 , 0.388888888889 , 0.166666666667}, -4.28330285097},
  {{0.388888888889 , 0.5 , 0.0555555555556}, -4.28330285097},
  {{0.5 , 0.0555555555556 , 0.388888888889}, -4.28330285097},
  {{0.5 , 0.166666666667 , 0.277777777778}, -4.28330285097},
  {{0.5 , 0.277777777778 , 0.166666666667}, -4.28330285097},
  {{0.5 , 0.388888888889 , 0.0555555555556}, -4.28330285097},
  {{0.611111111111 , 0.0555555555556 , 0.277777777778}, -4.28330285097},
  {{0.611111111111 , 0.166666666667 , 0.166666666667}, -4.28330285097},
  {{0.611111111111 , 0.277777777778 , 0.0555555555556}, -4.28330285097},
  {{0.722222222222 , 0.0555555555556 , 0.166666666667}, -4.28330285097},
  {{0.722222222222 , 0.166666666667 , 0.0555555555556}, -4.28330285097},
  {{0.833333333333 , 0.0555555555556 , 0.0555555555556}, -4.28330285097},
  {{0.0555555555556 , 0.0555555555556 , 0.722222222222}, -4.28330285097},
  {{0.0555555555556 , 0.166666666667 , 0.611111111111}, -4.28330285097},
  {{0.0555555555556 , 0.277777777778 , 0.5}, -4.28330285097},
  {{0.0555555555556 , 0.388888888889 , 0.388888888889}, -4.28330285097},
  {{0.0555555555556 , 0.5 , 0.277777777778}, -4.28330285097},
  {{0.0555555555556 , 0.611111111111 , 0.166666666667}, -4.28330285097},
  {{0.0555555555556 , 0.722222222222 , 0.0555555555556}, -4.28330285097},
  {{0.166666666667 , 0.0555555555556 , 0.611111111111}, -4.28330285097},
  {{0.166666666667 , 0.166666666667 , 0.5}, -4.28330285097},
  {{0.166666666667 , 0.277777777778 , 0.388888888889}, -4.28330285097},
  {{0.166666666667 , 0.388888888889 , 0.277777777778}, -4.28330285097},
  {{0.166666666667 , 0.5 , 0.166666666667}, -4.28330285097},
  {{0.166666666667 , 0.611111111111 , 0.0555555555556}, -4.28330285097},
  {{0.277777777778 , 0.0555555555556 , 0.5}, -4.28330285097},
  {{0.277777777778 , 0.166666666667 , 0.388888888889}, -4.28330285097},
  {{0.277777777778 , 0.277777777778 , 0.277777777778}, -4.28330285097},
  {{0.277777777778 , 0.388888888889 , 0.166666666667}, -4.28330285097},
  {{0.277777777778 , 0.5 , 0.0555555555556}, -4.28330285097},
  {{0.388888888889 , 0.0555555555556 , 0.388888888889}, -4.28330285097},
  {{0.388888888889 , 0.166666666667 , 0.277777777778}, -4.28330285097},
  {{0.388888888889 , 0.277777777778 , 0.166666666667}, -4.28330285097},
  {{0.388888888889 , 0.388888888889 , 0.0555555555556}, -4.28330285097},
  {{0.5 , 0.0555555555556 , 0.277777777778}, -4.28330285097},
  {{0.5 , 0.166666666667 , 0.166666666667}, -4.28330285097},
  {{0.5 , 0.277777777778 , 0.0555555555556}, -4.28330285097},
  {{0.611111111111 , 0.0555555555556 , 0.166666666667}, -4.28330285097},
  {{0.611111111111 , 0.166666666667 , 0.0555555555556}, -4.28330285097},
  {{0.722222222222 , 0.0555555555556 , 0.0555555555556}, -4.28330285097},
  {{0.0555555555556 , 0.0555555555556 , 0.611111111111}, -4.28330285097},
  {{0.0555555555556 , 0.166666666667 , 0.5}, -4.28330285097},
  {{0.0555555555556 , 0.277777777778 , 0.388888888889}, -4.28330285097},
  {{0.0555555555556 , 0.388888888889 , 0.277777777778}, -4.28330285097},
  {{0.0555555555556 , 0.5 , 0.166666666667}, -4.28330285097},
  {{0.0555555555556 , 0.611111111111 , 0.0555555555556}, -4.28330285097},
  {{0.166666666667 , 0.0555555555556 , 0.5}, -4.28330285097},
  {{0.166666666667 , 0.166666666667 , 0.388888888889}, -4.28330285097},
  {{0.166666666667 , 0.277777777778 , 0.277777777778}, -4.28330285097},
  {{0.166666666667 , 0.388888888889 , 0.166666666667}, -4.28330285097},
  {{0.166666666667 , 0.5 , 0.0555555555556}, -4.28330285097},
  {{0.277777777778 , 0.0555555555556 , 0.388888888889}, -4.28330285097},
  {{0.277777777778 , 0.166666666667 , 0.277777777778}, -4.28330285097},
  {{0.277777777778 , 0.277777777778 , 0.166666666667}, -4.28330285097},
  {{0.277777777778 , 0.388888888889 , 0.0555555555556}, -4.28330285097},
  {{0.388888888889 , 0.0555555555556 , 0.277777777778}, -4.28330285097},
  {{0.388888888889 , 0.166666666667 , 0.166666666667}, -4.28330285097},
  {{0.388888888889 , 0.277777777778 , 0.0555555555556}, -4.28330285097},
  {{0.5 , 0.0555555555556 , 0.166666666667}, -4.28330285097},
  {{0.5 , 0.166666666667 , 0.0555555555556}, -4.28330285097},
  {{0.611111111111 , 0.0555555555556 , 0.0555555555556}, -4.28330285097},
  {{0.0555555555556 , 0.0555555555556 , 0.5}, -4.28330285097},
  {{0.0555555555556 , 0.166666666667 , 0.388888888889}, -4.28330285097},
  {{0.0555555555556 , 0.277777777778 , 0.277777777778}, -4.28330285097},
  {{0.0555555555556 , 0.388888888889 , 0.166666666667}, -4.28330285097},
  {{0.0555555555556 , 0.5 , 0.0555555555556}, -4.28330285097},
  {{0.166666666667 , 0.0555555555556 , 0.388888888889}, -4.28330285097},
  {{0.166666666667 , 0.166666666667 , 0.277777777778}, -4.28330285097},
  {{0.166666666667 , 0.277777777778 , 0.166666666667}, -4.28330285097},
  {{0.166666666667 , 0.388888888889 , 0.0555555555556}, -4.28330285097},
  {{0.277777777778 , 0.0555555555556 , 0.277777777778}, -4.28330285097},
  {{0.277777777778 , 0.166666666667 , 0.166666666667}, -4.28330285097},
  {{0.277777777778 , 0.277777777778 , 0.0555555555556}, -4.28330285097},
  {{0.388888888889 , 0.0555555555556 , 0.166666666667}, -4.28330285097},
  {{0.388888888889 , 0.166666666667 , 0.0555555555556}, -4.28330285097},
  {{0.5 , 0.0555555555556 , 0.0555555555556}, -4.28330285097},
  {{0.0555555555556 , 0.0555555555556 , 0.388888888889}, -4.28330285097},
  {{0.0555555555556 , 0.166666666667 , 0.277777777778}, -4.28330285097},
  {{0.0555555555556 , 0.277777777778 , 0.166666666667}, -4.28330285097},
  {{0.0555555555556 , 0.388888888889 , 0.0555555555556}, -4.28330285097},
  {{0.166666666667 , 0.0555555555556 , 0.277777777778}, -4.28330285097},
  {{0.166666666667 , 0.166666666667 , 0.166666666667}, -4.28330285097},
  {{0.166666666667 , 0.277777777778 , 0.0555555555556}, -4.28330285097},
  {{0.277777777778 , 0.0555555555556 , 0.166666666667}, -4.28330285097},
  {{0.277777777778 , 0.166666666667 , 0.0555555555556}, -4.28330285097},
  {{0.388888888889 , 0.0555555555556 , 0.0555555555556}, -4.28330285097},
  {{0.0555555555556 , 0.0555555555556 , 0.277777777778}, -4.28330285097},
  {{0.0555555555556 , 0.166666666667 , 0.166666666667}, -4.28330285097},
  {{0.0555555555556 , 0.277777777778 , 0.0555555555556}, -4.28330285097},
  {{0.166666666667 , 0.0555555555556 , 0.166666666667}, -4.28330285097},
  {{0.166666666667 , 0.166666666667 , 0.0555555555556}, -4.28330285097},
  {{0.277777777778 , 0.0555555555556 , 0.0555555555556}, -4.28330285097},
  {{0.0555555555556 , 0.0555555555556 , 0.166666666667}, -4.28330285097},
  {{0.0555555555556 , 0.166666666667 , 0.0555555555556}, -4.28330285097},
  {{0.166666666667 , 0.0555555555556 , 0.0555555555556}, -4.28330285097},
  {{0.0555555555556 , 0.0555555555556 , 0.0555555555556}, -4.28330285097},
  {{0.0625 , 0.0625 , 0.8125}, 1.89554943147},
  {{0.0625 , 0.1875 , 0.6875}, 1.89554943147},
  {{0.0625 , 0.3125 , 0.5625}, 1.89554943147},
  {{0.0625 , 0.4375 , 0.4375}, 1.89554943147},
  {{0.0625 , 0.5625 , 0.3125}, 1.89554943147},
  {{0.0625 , 0.6875 , 0.1875}, 1.89554943147},
  {{0.0625 , 0.8125 , 0.0625}, 1.89554943147},
  {{0.1875 , 0.0625 , 0.6875}, 1.89554943147},
  {{0.1875 , 0.1875 , 0.5625}, 1.89554943147},
  {{0.1875 , 0.3125 , 0.4375}, 1.89554943147},
  {{0.1875 , 0.4375 , 0.3125}, 1.89554943147},
  {{0.1875 , 0.5625 , 0.1875}, 1.89554943147},
  {{0.1875 , 0.6875 , 0.0625}, 1.89554943147},
  {{0.3125 , 0.0625 , 0.5625}, 1.89554943147},
  {{0.3125 , 0.1875 , 0.4375}, 1.89554943147},
  {{0.3125 , 0.3125 , 0.3125}, 1.89554943147},
  {{0.3125 , 0.4375 , 0.1875}, 1.89554943147},
  {{0.3125 , 0.5625 , 0.0625}, 1.89554943147},
  {{0.4375 , 0.0625 , 0.4375}, 1.89554943147},
  {{0.4375 , 0.1875 , 0.3125}, 1.89554943147},
  {{0.4375 , 0.3125 , 0.1875}, 1.89554943147},
  {{0.4375 , 0.4375 , 0.0625}, 1.89554943147},
  {{0.5625 , 0.0625 , 0.3125}, 1.89554943147},
  {{0.5625 , 0.1875 , 0.1875}, 1.89554943147},
  {{0.5625 , 0.3125 , 0.0625}, 1.89554943147},
  {{0.6875 , 0.0625 , 0.1875}, 1.89554943147},
  {{0.6875 , 0.1875 , 0.0625}, 1.89554943147},
  {{0.8125 , 0.0625 , 0.0625}, 1.89554943147},
  {{0.0625 , 0.0625 , 0.6875}, 1.89554943147},
  {{0.0625 , 0.1875 , 0.5625}, 1.89554943147},
  {{0.0625 , 0.3125 , 0.4375}, 1.89554943147},
  {{0.0625 , 0.4375 , 0.3125}, 1.89554943147},
  {{0.0625 , 0.5625 , 0.1875}, 1.89554943147},
  {{0.0625 , 0.6875 , 0.0625}, 1.89554943147},
  {{0.1875 , 0.0625 , 0.5625}, 1.89554943147},
  {{0.1875 , 0.1875 , 0.4375}, 1.89554943147},
  {{0.1875 , 0.3125 , 0.3125}, 1.89554943147},
  {{0.1875 , 0.4375 , 0.1875}, 1.89554943147},
  {{0.1875 , 0.5625 , 0.0625}, 1.89554943147},
  {{0.3125 , 0.0625 , 0.4375}, 1.89554943147},
  {{0.3125 , 0.1875 , 0.3125}, 1.89554943147},
  {{0.3125 , 0.3125 , 0.1875}, 1.89554943147},
  {{0.3125 , 0.4375 , 0.0625}, 1.89554943147},
  {{0.4375 , 0.0625 , 0.3125}, 1.89554943147},
  {{0.4375 , 0.1875 , 0.1875}, 1.89554943147},
  {{0.4375 , 0.3125 , 0.0625}, 1.89554943147},
  {{0.5625 , 0.0625 , 0.1875}, 1.89554943147},
  {{0.5625 , 0.1875 , 0.0625}, 1.89554943147},
  {{0.6875 , 0.0625 , 0.0625}, 1.89554943147},
  {{0.0625 , 0.0625 , 0.5625}, 1.89554943147},
  {{0.0625 , 0.1875 , 0.4375}, 1.89554943147},
  {{0.0625 , 0.3125 , 0.3125}, 1.89554943147},
  {{0.0625 , 0.4375 , 0.1875}, 1.89554943147},
  {{0.0625 , 0.5625 , 0.0625}, 1.89554943147},
  {{0.1875 , 0.0625 , 0.4375}, 1.89554943147},
  {{0.1875 , 0.1875 , 0.3125}, 1.89554943147},
  {{0.1875 , 0.3125 , 0.1875}, 1.89554943147},
  {{0.1875 , 0.4375 , 0.0625}, 1.89554943147},
  {{0.3125 , 0.0625 , 0.3125}, 1.89554943147},
  {{0.3125 , 0.1875 , 0.1875}, 1.89554943147},
  {{0.3125 , 0.3125 , 0.0625}, 1.89554943147},
  {{0.4375 , 0.0625 , 0.1875}, 1.89554943147},
  {{0.4375 , 0.1875 , 0.0625}, 1.89554943147},
  {{0.5625 , 0.0625 , 0.0625}, 1.89554943147},
  {{0.0625 , 0.0625 , 0.4375}, 1.89554943147},
  {{0.0625 , 0.1875 , 0.3125}, 1.89554943147},
  {{0.0625 , 0.3125 , 0.1875}, 1.89554943147},
  {{0.0625 , 0.4375 , 0.0625}, 1.89554943147},
  {{0.1875 , 0.0625 , 0.3125}, 1.89554943147},
  {{0.1875 , 0.1875 , 0.1875}, 1.89554943147},
  {{0.1875 , 0.3125 , 0.0625}, 1.89554943147},
  {{0.3125 , 0.0625 , 0.1875}, 1.89554943147},
  {{0.3125 , 0.1875 , 0.0625}, 1.89554943147},
  {{0.4375 , 0.0625 , 0.0625}, 1.89554943147},
  {{0.0625 , 0.0625 , 0.3125}, 1.89554943147},
  {{0.0625 , 0.1875 , 0.1875}, 1.89554943147},
  {{0.0625 , 0.3125 , 0.0625}, 1.89554943147},
  {{0.1875 , 0.0625 , 0.1875}, 1.89554943147},
  {{0.1875 , 0.1875 , 0.0625}, 1.89554943147},
  {{0.3125 , 0.0625 , 0.0625}, 1.89554943147},
  {{0.0625 , 0.0625 , 0.1875}, 1.89554943147},
  {{0.0625 , 0.1875 , 0.0625}, 1.89554943147},
  {{0.1875 , 0.0625 , 0.0625}, 1.89554943147},
  {{0.0625 , 0.0625 , 0.0625}, 1.89554943147},
  {{0.0714285714286 , 0.0714285714286 , 0.785714285714}, -0.459160181714},
  {{0.0714285714286 , 0.214285714286 , 0.642857142857}, -0.459160181714},
  {{0.0714285714286 , 0.357142857143 , 0.5}, -0.459160181714},
  {{0.0714285714286 , 0.5 , 0.357142857143}, -0.459160181714},
  {{0.0714285714286 , 0.642857142857 , 0.214285714286}, -0.459160181714},
  {{0.0714285714286 , 0.785714285714 , 0.0714285714286}, -0.459160181714},
  {{0.214285714286 , 0.0714285714286 , 0.642857142857}, -0.459160181714},
  {{0.214285714286 , 0.214285714286 , 0.5}, -0.459160181714},
  {{0.214285714286 , 0.357142857143 , 0.357142857143}, -0.459160181714},
  {{0.214285714286 , 0.5 , 0.214285714286}, -0.459160181714},
  {{0.214285714286 , 0.642857142857 , 0.0714285714286}, -0.459160181714},
  {{0.357142857143 , 0.0714285714286 , 0.5}, -0.459160181714},
  {{0.357142857143 , 0.214285714286 , 0.357142857143}, -0.459160181714},
  {{0.357142857143 , 0.357142857143 , 0.214285714286}, -0.459160181714},
  {{0.357142857143 , 0.5 , 0.0714285714286}, -0.459160181714},
  {{0.5 , 0.0714285714286 , 0.357142857143}, -0.459160181714},
  {{0.5 , 0.214285714286 , 0.214285714286}, -0.459160181714},
  {{0.5 , 0.357142857143 , 0.0714285714286}, -0.459160181714},
  {{0.642857142857 , 0.0714285714286 , 0.214285714286}, -0.459160181714},
  {{0.642857142857 , 0.214285714286 , 0.0714285714286}, -0.459160181714},
  {{0.785714285714 , 0.0714285714286 , 0.0714285714286}, -0.459160181714},
  {{0.0714285714286 , 0.0714285714286 , 0.642857142857}, -0.459160181714},
  {{0.0714285714286 , 0.214285714286 , 0.5}, -0.459160181714},
  {{0.0714285714286 , 0.357142857143 , 0.357142857143}, -0.459160181714},
  {{0.0714285714286 , 0.5 , 0.214285714286}, -0.459160181714},
  {{0.0714285714286 , 0.642857142857 , 0.0714285714286}, -0.459160181714},
  {{0.214285714286 , 0.0714285714286 , 0.5}, -0.459160181714},
  {{0.214285714286 , 0.214285714286 , 0.357142857143}, -0.459160181714},
  {{0.214285714286 , 0.357142857143 , 0.214285714286}, -0.459160181714},
  {{0.214285714286 , 0.5 , 0.0714285714286}, -0.459160181714},
  {{0.357142857143 , 0.0714285714286 , 0.357142857143}, -0.459160181714},
  {{0.357142857143 , 0.214285714286 , 0.214285714286}, -0.459160181714},
  {{0.357142857143 , 0.357142857143 , 0.0714285714286}, -0.459160181714},
  {{0.5 , 0.0714285714286 , 0.214285714286}, -0.459160181714},
  {{0.5 , 0.214285714286 , 0.0714285714286}, -0.459160181714},
  {{0.642857142857 , 0.0714285714286 , 0.0714285714286}, -0.459160181714},
  {{0.0714285714286 , 0.0714285714286 , 0.5}, -0.459160181714},
  {{0.0714285714286 , 0.214285714286 , 0.357142857143}, -0.459160181714},
  {{0.0714285714286 , 0.357142857143 , 0.214285714286}, -0.459160181714},
  {{0.0714285714286 , 0.5 , 0.0714285714286}, -0.459160181714},
  {{0.214285714286 , 0.0714285714286 , 0.357142857143}, -0.459160181714},
  {{0.214285714286 , 0.214285714286 , 0.214285714286}, -0.459160181714},
  {{0.214285714286 , 0.357142857143 , 0.0714285714286}, -0.459160181714},
  {{0.357142857143 , 0.0714285714286 , 0.214285714286}, -0.459160181714},
  {{0.357142857143 , 0.214285714286 , 0.0714285714286}, -0.459160181714},
  {{0.5 , 0.0714285714286 , 0.0714285714286}, -0.459160181714},
  {{0.0714285714286 , 0.0714285714286 , 0.357142857143}, -0.459160181714},
  {{0.0714285714286 , 0.214285714286 , 0.214285714286}, -0.459160181714},
  {{0.0714285714286 , 0.357142857143 , 0.0714285714286}, -0.459160181714},
  {{0.214285714286 , 0.0714285714286 , 0.214285714286}, -0.459160181714},
  {{0.214285714286 , 0.214285714286 , 0.0714285714286}, -0.459160181714},
  {{0.357142857143 , 0.0714285714286 , 0.0714285714286}, -0.459160181714},
  {{0.0714285714286 , 0.0714285714286 , 0.214285714286}, -0.459160181714},
  {{0.0714285714286 , 0.214285714286 , 0.0714285714286}, -0.459160181714},
  {{0.214285714286 , 0.0714285714286 , 0.0714285714286}, -0.459160181714},
  {{0.0714285714286 , 0.0714285714286 , 0.0714285714286}, -0.459160181714},
  {{0.0833333333333 , 0.0833333333333 , 0.75}, 0.0571062953853},
  {{0.0833333333333 , 0.25 , 0.583333333333}, 0.0571062953853},
  {{0.0833333333333 , 0.416666666667 , 0.416666666667}, 0.0571062953853},
  {{0.0833333333333 , 0.583333333333 , 0.25}, 0.0571062953853},
  {{0.0833333333333 , 0.75 , 0.0833333333333}, 0.0571062953853},
  {{0.25 , 0.0833333333333 , 0.583333333333}, 0.0571062953853},
  {{0.25 , 0.25 , 0.416666666667}, 0.0571062953853},
  {{0.25 , 0.416666666667 , 0.25}, 0.0571062953853},
  {{0.25 , 0.583333333333 , 0.0833333333333}, 0.0571062953853},
  {{0.416666666667 , 0.0833333333333 , 0.416666666667}, 0.0571062953853},
  {{0.416666666667 , 0.25 , 0.25}, 0.0571062953853},
  {{0.416666666667 , 0.416666666667 , 0.0833333333333}, 0.0571062953853},
  {{0.583333333333 , 0.0833333333333 , 0.25}, 0.0571062953853},
  {{0.583333333333 , 0.25 , 0.0833333333333}, 0.0571062953853},
  {{0.75 , 0.0833333333333 , 0.0833333333333}, 0.0571062953853},
  {{0.0833333333333 , 0.0833333333333 , 0.583333333333}, 0.0571062953853},
  {{0.0833333333333 , 0.25 , 0.416666666667}, 0.0571062953853},
  {{0.0833333333333 , 0.416666666667 , 0.25}, 0.0571062953853},
  {{0.0833333333333 , 0.583333333333 , 0.0833333333333}, 0.0571062953853},
  {{0.25 , 0.0833333333333 , 0.416666666667}, 0.0571062953853},
  {{0.25 , 0.25 , 0.25}, 0.0571062953853},
  {{0.25 , 0.416666666667 , 0.0833333333333}, 0.0571062953853},
  {{0.416666666667 , 0.0833333333333 , 0.25}, 0.0571062953853},
  {{0.416666666667 , 0.25 , 0.0833333333333}, 0.0571062953853},
  {{0.583333333333 , 0.0833333333333 , 0.0833333333333}, 0.0571062953853},
  {{0.0833333333333 , 0.0833333333333 , 0.416666666667}, 0.0571062953853},
  {{0.0833333333333 , 0.25 , 0.25}, 0.0571062953853},
  {{0.0833333333333 , 0.416666666667 , 0.0833333333333}, 0.0571062953853},
  {{0.25 , 0.0833333333333 , 0.25}, 0.0571062953853},
  {{0.25 , 0.25 , 0.0833333333333}, 0.0571062953853},
  {{0.416666666667 , 0.0833333333333 , 0.0833333333333}, 0.0571062953853},
  {{0.0833333333333 , 0.0833333333333 , 0.25}, 0.0571062953853},
  {{0.0833333333333 , 0.25 , 0.0833333333333}, 0.0571062953853},
  {{0.25 , 0.0833333333333 , 0.0833333333333}, 0.0571062953853},
  {{0.0833333333333 , 0.0833333333333 , 0.0833333333333}, 0.0571062953853},
  {{0.1 , 0.1 , 0.7}, -0.00319192211327},
  {{0.1 , 0.3 , 0.5}, -0.00319192211327},
  {{0.1 , 0.5 , 0.3}, -0.00319192211327},
  {{0.1 , 0.7 , 0.1}, -0.00319192211327},
  {{0.3 , 0.1 , 0.5}, -0.00319192211327},
  {{0.3 , 0.3 , 0.3}, -0.00319192211327},
  {{0.3 , 0.5 , 0.1}, -0.00319192211327},
  {{0.5 , 0.1 , 0.3}, -0.00319192211327},
  {{0.5 , 0.3 , 0.1}, -0.00319192211327},
  {{0.7 , 0.1 , 0.1}, -0.00319192211327},
  {{0.1 , 0.1 , 0.5}, -0.00319192211327},
  {{0.1 , 0.3 , 0.3}, -0.00319192211327},
  {{0.1 , 0.5 , 0.1}, -0.00319192211327},
  {{0.3 , 0.1 , 0.3}, -0.00319192211327},
  {{0.3 , 0.3 , 0.1}, -0.00319192211327},
  {{0.5 , 0.1 , 0.1}, -0.00319192211327},
  {{0.1 , 0.1 , 0.3}, -0.00319192211327},
  {{0.1 , 0.3 , 0.1}, -0.00319192211327},
  {{0.3 , 0.1 , 0.1}, -0.00319192211327},
  {{0.1 , 0.1 , 0.1}, -0.00319192211327},
  {{0.125 , 0.125 , 0.625}, 6.2560605972e-05},
  {{0.125 , 0.375 , 0.375}, 6.2560605972e-05},
  {{0.125 , 0.625 , 0.125}, 6.2560605972e-05},
  {{0.375 , 0.125 , 0.375}, 6.2560605972e-05},
  {{0.375 , 0.375 , 0.125}, 6.2560605972e-05},
  {{0.625 , 0.125 , 0.125}, 6.2560605972e-05},
  {{0.125 , 0.125 , 0.375}, 6.2560605972e-05},
  {{0.125 , 0.375 , 0.125}, 6.2560605972e-05},
  {{0.375 , 0.125 , 0.125}, 6.2560605972e-05},
  {{0.125 , 0.125 , 0.125}, 6.2560605972e-05},
  {{0.166666666667 , 0.166666666667 , 0.5}, -2.6452392075e-07},
  {{0.166666666667 , 0.5 , 0.166666666667}, -2.6452392075e-07},
  {{0.5 , 0.166666666667 , 0.166666666667}, -2.6452392075e-07},
  {{0.166666666667 , 0.166666666667 , 0.166666666667}, -2.6452392075e-07},
  {{0.25 , 0.25 , 0.25}, 7.955025e-11}
};

// 420 negative weights, 0 points outside of the tetrahedron 

IntPt * GQTetSolin[22] = {
  tetP1Solin,
  tetP1Solin,
  tetP2Solin,
  tetP3Solin,
  tetP4Solin,
  tetP5Solin,
  tetP6Solin,
  tetP7Solin,
  tetP8Solin,
  tetP9Solin,
  tetP11Solin,
  tetP11Solin,
  tetP13Solin,
  tetP13Solin,
  tetP15Solin,
  tetP15Solin,
  tetP17Solin,
  tetP17Solin,
  tetP19Solin,
  tetP19Solin,
  tetP21Solin,
  tetP21Solin
};  
                            
int GQTetnPtSolin[22] = {
  1,
  1,
  4,
  5,
  11,
  14,
  24,
  31,
  43,
  53,
  126,
  126,
  210,
  210,
  330,
  330,
  495,
  495,
  715,
  715,
  1001,
  1001};

IntPt *getGQTetPts(int order);
int getNGQTetPts(int order);

IntPt *getGQTetPts(int order)
{
  // if(order < 7)
  //     return GQTet[order]; 
  
  if (order < 21) return GQTetSolin[order];
  
  int n = (order+4)/2;
  int index = n-5;
  if(!GQTetDegen[index]){
    int npts = n*n*n;
    GQTetDegen[index] = new IntPt[npts];
    GaussLegendreTet(n,n,n,GQTetDegen[index]);
  }
  return GQTetDegen[index];  
}

int getNGQTetPts(int order)
{ 
  //   if(order < 7)
  //     return GQTetnPt[order];

  if (order < 21) return GQTetnPtSolin[order];

  
  int n = (order+4)/2;
  return n*n*n;
}
