/* gmpc-wikipedia (GMPC plugin)
 * Copyright (C) 2006-2009 Qball Cow <qball@sarine.nl>
 * Project homepage: http://gmpcwiki.sarine.nl/
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <stdio.h>
#include <string.h>
#include <gmpc/plugin.h>
#include <config.h>
#include <webkit/webkit.h>

static void wp_add(GtkWidget *cat_tree);
static void wp_selected(GtkWidget *container);
static void wp_unselected(GtkWidget *container);
static void wp_changed(GtkWidget *tree, GtkTreeIter *iter);
static void wp_status_changed(MpdObj *mi, ChangedStatusType what, void *userdata);

static GtkWidget *moz = NULL;
static GtkWidget *wp_vbox = NULL;
static GtkWidget *pgb = NULL;

static void wp_start_init(void);
static int wp_get_enabled();
static void wp_set_enabled(int enabled);
int global_progress;

gchar *old_url;

//GtkWidget * (*moz_new)(void) = NULL;
//GtkWidget * (*moz_load_url)(GtkWidget *moz, const char *url) = NULL;


/* Needed plugin_wp stuff */
gmpcPlBrowserPlugin wp_gbp = {
	.add                    = wp_add,		/** add */
	.selected               = wp_selected,	/** selected */
	.unselected             = wp_unselected,	/** unselected */
};
int plugin_api_version = PLUGIN_API_VERSION;
gmpcPlugin plugin = {
	.name = "WikiPedia",
	.version        = {PLUGIN_MAJOR_VERSION,PLUGIN_MINOR_VERSION,PLUGIN_MICRO_VERSION},
	.plugin_type = GMPC_PLUGIN_PL_BROWSER,
	.init = wp_start_init, /*init */
	.browser = &wp_gbp,
    .mpd_status_changed = 	wp_status_changed, /* status changed */
	.get_enabled = wp_get_enabled,
	.set_enabled = wp_set_enabled
};


/* Playlist window row reference */
static GtkTreeRowReference *wiki_ref = NULL;

void wp_changed(GtkWidget *tree, GtkTreeIter *iter)
{
    mpd_Song *song = mpd_playlist_get_current_song(connection);
    if(song)
    {
        gchar *artist= NULL;
        /* copied from metadata.h */
        if(song->artist && cfg_get_single_value_as_int_with_default(config, "metadata", "rename", FALSE))
        {
            gchar **str = g_strsplit(song->artist, ",", 2);
            if(str[1]) {
                artist = g_strdup_printf("%s %s", g_strstrip(str[1]), g_strstrip(str[0]));
            }
            g_strfreev(str);
            debug_printf(DEBUG_INFO, "string converted to: '%s'", song->artist);
        }

        if(song->artist != NULL){
            int i;
            gchar *esc_artist = g_strescape((artist)?artist:song->artist,NULL);
            gchar *url = g_strdup_printf("http://wikipedia.com/w/index.php?useskin=chick&title=%s", esc_artist);
       
            g_free(esc_artist);
            for(i=0;i< strlen(url);i++){
                if(url[i] == ' ') url[i] = '_';
            }
            if(strcmp(old_url,url))
      		{
            	webkit_web_view_open(WEBKIT_WEB_VIEW(moz),url);
            	gtk_widget_show_all(moz);
			}
			old_url = g_strdup_printf(url);
            
            
            g_free(url);
        }
        else{
		if(strcmp(old_url,"http://www.musicpd.org/")){
	            webkit_web_view_open(WEBKIT_WEB_VIEW(moz),"http://www.musicpd.org/");
		    old_url = g_strdup_printf("http://www.musicpd.org/");

		}
        }
        if(artist) g_free(artist);
    }
}

void wp_progress(GtkWidget *mozem, int progress, gpointer data)
{
	
	float fprog = (float)progress/100.0;
	gchar *text = g_strdup_printf("%d %%",progress);
	global_progress=progress;
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(pgb),fprog); 
	gtk_progress_bar_set_text(GTK_PROGRESS_BAR(pgb),text);
	g_free(text);
	
}

void wp_progress_started(WebKitWebView  *webkitwebview,WebKitWebFrame *arg1,gpointer user_data)
{
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(pgb),0);
	gtk_progress_bar_set_text(GTK_PROGRESS_BAR(pgb),"0 %");
	gtk_widget_show(pgb);
}

void wp_progress_finished(WebKitWebView  *webkitwebview,WebKitWebFrame *arg1,gpointer user_data)
{
	gtk_widget_hide(pgb);
}

void wp_init()
{
	GtkWidget *sw =gtk_scrolled_window_new(NULL,NULL);
    gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(sw), GTK_SHADOW_ETCHED_IN);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    wp_vbox = gtk_vbox_new(FALSE, 6);
    moz = webkit_web_view_new();//moz_new();
    if(moz == NULL)
    {
    }
    webkit_web_view_can_go_back_or_forward(WEBKIT_WEB_VIEW(moz), 0);

    gtk_container_add(GTK_CONTAINER(sw), moz);
    gtk_box_pack_start_defaults(GTK_BOX(wp_vbox), sw);
    pgb = gtk_progress_bar_new();
    gtk_box_pack_start(GTK_BOX(wp_vbox), pgb, FALSE, TRUE, 0);
    gtk_widget_grab_focus (GTK_WIDGET (moz));
    g_signal_connect(moz, "load_progress_changed", G_CALLBACK(wp_progress), NULL);
    g_signal_connect(moz, "load_finished", G_CALLBACK(wp_progress_finished),NULL);
    g_signal_connect(moz, "load_started", G_CALLBACK(wp_progress_started),NULL);
    gtk_widget_show_all(wp_vbox);
    gtk_widget_hide(pgb);
    g_object_ref(G_OBJECT(wp_vbox));
    old_url = g_strdup_printf("http://www.musicpd.org");

}

void wp_add(GtkWidget *cat_tree)
{
    GtkTreePath *path = NULL;
    GtkTreeStore *pl3_tree = (GtkTreeStore *)gtk_tree_view_get_model(GTK_TREE_VIEW(cat_tree));	
    GtkTreeIter iter;
    if(!cfg_get_single_value_as_int_with_default(config, "wp-plugin", "enable", 0)) return;
    gtk_list_store_append(pl3_tree, &iter);
    gtk_list_store_set(pl3_tree, &iter, 
            PL3_CAT_TYPE, plugin.id,
            PL3_CAT_TITLE, "Wikipedia Lookup",
            PL3_CAT_INT_ID, "/",
            PL3_CAT_ICON_ID, "gtk-info",
            PL3_CAT_PROC, TRUE,
            PL3_CAT_ICON_SIZE,GTK_ICON_SIZE_DND,-1);
    if (wiki_ref)
    {
        gtk_tree_row_reference_free(wiki_ref);
        wiki_ref = NULL;
    }

    path = gtk_tree_model_get_path(GTK_TREE_MODEL(playlist3_get_category_tree_store()), &iter);
    if (path)
    {
        wiki_ref = gtk_tree_row_reference_new(GTK_TREE_MODEL(playlist3_get_category_tree_store()), path);
        gtk_tree_path_free(path);
    }

}

void wp_selected(GtkWidget *container)
{

	if(wp_vbox== NULL)
	{
		wp_init();
	}

	gtk_container_add(GTK_CONTAINER(container), wp_vbox);
	gtk_widget_show_all(wp_vbox);
	if(global_progress==100)
	{
		gtk_widget_hide(pgb);
	}
	while (gtk_events_pending ())
		gtk_main_iteration ();

}

void wp_unselected(GtkWidget *container)
{
	gtk_widget_hide(moz);
	gtk_container_remove(GTK_CONTAINER(container),wp_vbox);
}


void wp_set_enabled(int enabled)
{
	cfg_set_single_value_as_int(config, "wp-plugin", "enable", enabled);
	if (enabled)
	{
		if(wiki_ref == NULL)
		{
			wp_add(GTK_WIDGET(playlist3_get_category_tree_view()));
		}
	}
	else if (wiki_ref)
	{
		GtkTreePath *path = gtk_tree_row_reference_get_path(wiki_ref);
		if (path){
			GtkTreeIter iter;
			if (gtk_tree_model_get_iter(GTK_TREE_MODEL(playlist3_get_category_tree_store()), &iter, path)){
				gtk_list_store_remove(playlist3_get_category_tree_store(), &iter);
			}
			gtk_tree_path_free(path);
			gtk_tree_row_reference_free(wiki_ref);
			wiki_ref = NULL;
		}                                                                                                  	
	}                                                                                                      	
}

int wp_get_enabled()
{
	return 	cfg_get_single_value_as_int_with_default(config, "wp-plugin", "enable", 0);
}
static void wp_start_init(void)
{

}


static void wp_status_changed(MpdObj *mi, ChangedStatusType what, void *userdata)
{
	if(pl3_cat_get_selected_browser() == plugin.id)
	{
			wp_changed(NULL, NULL);		
	}
}

