/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <string.h>
#include <gdk/gdkkeysyms.h>

#include "config.h"
#include "window.h"
#include "dsend.h"
#include "notebook.h"
#include "help.h"

void gm_dialog_send_close(world *w) {
    dsend_t *s = w->dialog_send;
    w->dialog_send = NULL;
    gtk_widget_hide(s->window);
    gtk_widget_destroy(s->window);
    g_free(s);
}

void gm_dialog_send_open_current_world() {
    world *w = gm_notebook_current_world();
    if(w) gm_dialog_send_open(w);
}

void send_close(GtkWidget *w, dsend_t *s) {
    gtk_widget_hide(s->window);
    gtk_editable_delete_text(GTK_EDITABLE(s->text), 0,
			     gtk_text_get_length(GTK_TEXT(s->text)));
}

void send_delete_w(GtkWidget *w, void *pointer, dsend_t *s) {
    send_close(w, s);
}

char *assemble_data(const char *prefix, const char *line_prefix,
		    const char *text, const char *suffix) {
    char *s;
    int len, len2, i, j;
    len = strlen(prefix) + strlen(text) + strlen(suffix) + 10;
    len2 = strlen(line_prefix);
    for(i = 0; text[i] != '\0'; i++) {
	if(text[i] == '\n')
	    len += len2;
    }
    len += len2;
    s = g_malloc(len);
    s[0] = '\0';
    strcat(s, prefix);
    strcat(s, "\n");

    if(text[0]) {
	i = strlen(s);
	j = 0;
	while(TRUE) {
	restart_loop:
	    strcpy(s + i, line_prefix);
	    i += len2;
	    while(text[j] != '\0') {
		s[i] = text[j];
		i++; j++;
		if(text[j - 1] == '\n') {
		    s[i] = '\0';
		    goto restart_loop;
		}
	    }
	    if(text[j] == '\0') {
		s[i] = '\0';
		break;
	    }
	}
	strcat(s, "\n");
    }
    strcat(s, suffix);
    strcat(s, "\n");
    return s;
}

void send_send(GtkWidget *w, dsend_t *s) {
    char *prefix = gtk_entry_get_text(GTK_ENTRY(s->prefix));
    char *line_prefix = gtk_entry_get_text(GTK_ENTRY(s->line_prefix));
    char *text =
	gtk_editable_get_chars(GTK_EDITABLE(s->text), 0,
			       gtk_text_get_length(GTK_TEXT(s->text)));
    char *suffix = gtk_entry_get_text(GTK_ENTRY(s->suffix));
    char *to_send;

    send_close(w, s);

    to_send = assemble_data(prefix, line_prefix, text, suffix);

    gm_world_write(s->belongs_to, to_send);

    g_free(text);
    g_free(to_send);
}

int key_press(GtkWidget *text, GdkEventKey *event, dsend_t *s) {
    if(event->state & GDK_CONTROL_MASK &&
       (event->keyval == GDK_Return || event->keyval == GDK_KP_Enter)) {
	send_send(text, s);
	return TRUE;
    }
    return FALSE;
}

void gm_dialog_send_open(world *w) {
    GtkWidget *vbox;
    GtkWidget *table;
    GtkWidget *scrollw;
    GtkWidget *tmp;
    GtkWidget *hbb;
    char *str;
    dsend_t *s;

    if(w->dialog_send) {
	gtk_widget_show(w->dialog_send->window);
	return;
    }
    s = g_malloc(sizeof(dsend_t));
    s->belongs_to = w;
    w->dialog_send = s;

    s->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_transient_for(GTK_WINDOW(s->window),
				 GTK_WINDOW(gm_window_get_window()));
    gtk_window_set_position (GTK_WINDOW (s->window), GTK_WIN_POS_MOUSE);
    str = g_strconcat(_("Send to world "), w->p->name, NULL);
    gtk_window_set_title (GTK_WINDOW (s->window), str);
    g_free(str);
    gtk_signal_connect(GTK_OBJECT(s->window), "delete_event",
		       GTK_SIGNAL_FUNC(send_delete_w), s);

    vbox = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox);
    gtk_container_add (GTK_CONTAINER (s->window), vbox);

    table = gtk_table_new (4, 2, FALSE);
    gtk_widget_show (table);
    gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (table), 5);
    gtk_table_set_row_spacings (GTK_TABLE (table), 2);
    gtk_table_set_col_spacings (GTK_TABLE (table), 5);

    scrollw = gtk_scrolled_window_new (NULL, NULL);
    gtk_widget_show (scrollw);
    gtk_table_attach (GTK_TABLE (table), scrollw, 0, 2, 2, 3,
		      (GtkAttachOptions) (GTK_FILL),
		      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
    gtk_widget_set_usize (scrollw, -2, 100);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrollw),
				    GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

    s->text = gtk_text_new (NULL, NULL);
    gtk_widget_show (s->text);
    gtk_container_add (GTK_CONTAINER (scrollw), s->text);
    gtk_editable_set_editable(GTK_EDITABLE(s->text), TRUE);
    gtk_signal_connect(GTK_OBJECT(s->text), "key_press_event",
		       GTK_SIGNAL_FUNC(key_press), (void *) s);

    s->prefix = gtk_entry_new ();
    gtk_widget_show (s->prefix);
    gtk_table_attach (GTK_TABLE (table), s->prefix, 1, 2, 0, 1,
		      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		      (GtkAttachOptions) (0), 0, 0);
    gtk_entry_set_text (GTK_ENTRY (s->prefix), _("@paste"));

    s->line_prefix = gtk_entry_new ();
    gtk_widget_show (s->line_prefix);
    gtk_table_attach (GTK_TABLE (table), s->line_prefix, 1, 2, 1, 2,
		      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		      (GtkAttachOptions) (0), 0, 0);

    s->suffix = gtk_entry_new ();
    gtk_widget_show (s->suffix);
    gtk_table_attach (GTK_TABLE (table), s->suffix, 1, 2, 3, 4,
		      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		      (GtkAttachOptions) (0), 0, 0);
    gtk_entry_set_text (GTK_ENTRY (s->suffix), _("."));

    tmp = gtk_label_new (_("Suffix"));
    gtk_widget_show (tmp);
    gtk_table_attach (GTK_TABLE (table), tmp, 0, 1, 3, 4,
		      (GtkAttachOptions) (GTK_FILL),
		      (GtkAttachOptions) (0), 0, 0);
    gtk_misc_set_alignment (GTK_MISC (tmp), 1, 0.5);

    tmp = gtk_label_new (_("Prefix"));
    gtk_widget_show (tmp);
    gtk_table_attach (GTK_TABLE (table), tmp, 0, 1, 0, 1,
		      (GtkAttachOptions) (GTK_FILL),
		      (GtkAttachOptions) (0), 0, 0);
    gtk_misc_set_alignment (GTK_MISC (tmp), 1, 0.5);

    tmp = gtk_label_new (_("Every line prefix"));
    gtk_widget_show (tmp);
    gtk_table_attach (GTK_TABLE (table), tmp, 0, 1, 1, 2,
		      (GtkAttachOptions) (GTK_FILL),
		      (GtkAttachOptions) (0), 0, 0);
    gtk_misc_set_alignment (GTK_MISC (tmp), 1, 0.5);

    tmp = gtk_hseparator_new ();
    gtk_widget_show (tmp);
    gtk_box_pack_start (GTK_BOX (vbox), tmp, FALSE, TRUE, 0);

    hbb = gtk_hbutton_box_new ();
    gtk_widget_show (hbb);
    gtk_box_pack_start (GTK_BOX (vbox), hbb, FALSE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbb), 5);
    gtk_button_box_set_layout (GTK_BUTTON_BOX (hbb), GTK_BUTTONBOX_END);
    gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbb), 0);
    gtk_button_box_set_child_size (GTK_BUTTON_BOX (hbb), 0, 0);

    s->but_send = gtk_button_new_with_label (_("Send"));
    gtk_widget_show (s->but_send);
    gtk_container_add (GTK_CONTAINER (hbb), s->but_send);
    GTK_WIDGET_SET_FLAGS (s->but_send, GTK_CAN_DEFAULT);
    gtk_signal_connect(GTK_OBJECT(s->but_send), "clicked",
		       GTK_SIGNAL_FUNC(send_send), s);

    s->but_cancel = gtk_button_new_with_label (_("Cancel"));
    gtk_widget_show (s->but_cancel);
    gtk_container_add (GTK_CONTAINER (hbb), s->but_cancel);
    GTK_WIDGET_SET_FLAGS (s->but_cancel, GTK_CAN_DEFAULT);
    gtk_widget_grab_default(s->but_cancel);
    gtk_signal_connect(GTK_OBJECT(s->but_cancel), "clicked",
		       GTK_SIGNAL_FUNC(send_close), s);

    s->but_help = gtk_button_new_with_label (_("Help"));
    gtk_widget_show (s->but_help);
    gtk_container_add (GTK_CONTAINER (hbb), s->but_help);
    GTK_WIDGET_SET_FLAGS (s->but_help, GTK_CAN_DEFAULT);
    gtk_signal_connect(GTK_OBJECT(s->but_help), "clicked",
		       GTK_SIGNAL_FUNC(gm_help_show), HELP_DSEND);

    gtk_widget_show(s->window);
}

