/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>

#include "config.h"
#include "window.h"
#include "dlogin.h"
#include "configdb.h"
#include "world.h"
#include "help.h"
#include "misc.h"

login_t *init_login(world *w) {
    login_t *l = g_malloc(sizeof(login_t));
    l->belongs_to = w;
    l->savelogin  = w->p->savelogin;
    l->username   = g_strdup(w->p->username == NULL ? "" : w->p->username);
    l->password   = g_strdup(w->p->password == NULL ? "" : w->p->password);
    return l;
}

void login_changed(GtkWidget *w, login_t *l) {
    if (strlen(gtk_entry_get_text(GTK_ENTRY(l->username_w))) == 0) {
        gtk_widget_set_sensitive(l->ok_but, FALSE);
	gtk_widget_grab_default(l->close_but);
    } else {
        gtk_widget_set_sensitive(l->ok_but, TRUE);
	gtk_widget_grab_default(l->ok_but);
    }
}

void gm_dialog_login_close(GtkWidget *w, login_t *l) {
    g_free(l->username);
    g_free(l->password);
    gtk_widget_hide(l->window);
    gtk_widget_destroy(l->window);
    if(l->belongs_to) {
	l->belongs_to->dialog_login = NULL;
    }
    g_free(l);
}

void login_ok(GtkWidget *w, login_t *l) {
    world *world = l->belongs_to;

    g_free(world->p->username);
    g_free(world->p->password);
    if(!world->quick) {
	world->p->savelogin =
	    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(l->savelogin_w));
    } else {
	world->p->savelogin = FALSE;
    }
    world->p->username =g_strdup(gtk_entry_get_text(GTK_ENTRY(l->username_w)));
    world->p->password =g_strdup(gtk_entry_get_text(GTK_ENTRY(l->password_w)));
    gm_world_save_settings(world);

    gm_world_log_in(world);

    gm_dialog_login_close(w, l);
}

void password_activated(GtkWidget *passwd, login_t *l) {
    if(GTK_WIDGET_HAS_DEFAULT(l->ok_but)) {
	gtk_widget_grab_focus(l->ok_but);
	gtk_button_clicked(GTK_BUTTON(l->ok_but));
    } else {
	gtk_button_clicked(GTK_BUTTON(l->close_but));
    }
}

void login_delete_w(GtkWidget *w, void *pointer, login_t *l) {
    gm_dialog_login_close(w, l);
}

void gm_dialog_login_open(world *w) {
    login_t *l;
    GtkWidget *vbox;
    GtkWidget *table;
    GtkWidget *tmp;
    GtkWidget *hbb;
    char *s;
    
    if(w && w->dialog_login) {
	return;
    }

    l = init_login(w);

    l->window = gtk_window_new (GTK_WINDOW_DIALOG);
    gtk_window_set_transient_for(GTK_WINDOW(l->window),
				 GTK_WINDOW(gm_window_get_window()));
    s = g_strconcat(_("Login world "), w->p->name, NULL);
    gtk_window_set_title (GTK_WINDOW (l->window), s);
    g_free(s);
    gtk_window_set_position (GTK_WINDOW (l->window), GTK_WIN_POS_MOUSE);
    gtk_window_set_policy (GTK_WINDOW (l->window), FALSE, FALSE, TRUE);
    gtk_window_set_modal(GTK_WINDOW(l->window), TRUE);
    gtk_signal_connect(GTK_OBJECT(l->window), "delete_event",
		       GTK_SIGNAL_FUNC(login_delete_w), l);

    vbox = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox);
    gtk_container_add (GTK_CONTAINER (l->window), vbox);

    table = gtk_table_new (w->quick ? 2 : 3, 2, FALSE);
    gtk_widget_show (table);
    gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (table), 5);
    gtk_table_set_row_spacings (GTK_TABLE (table), 2);
    gtk_table_set_col_spacings (GTK_TABLE (table), 5);

    tmp = gtk_label_new (_("Username"));
    gtk_widget_show (tmp);
    gtk_table_attach (GTK_TABLE (table), tmp, 0, 1, 0, 1,
		      (GtkAttachOptions) (0),
		      (GtkAttachOptions) (0), 0, 0);
    gtk_label_set_justify (GTK_LABEL (tmp), GTK_JUSTIFY_RIGHT);
    gtk_misc_set_alignment (GTK_MISC (tmp), 1, 0.5);

    tmp = gtk_label_new (_("Password"));
    gtk_widget_show (tmp);
    gtk_table_attach (GTK_TABLE (table), tmp, 0, 1, 1, 2,
		      (GtkAttachOptions) (0),
		      (GtkAttachOptions) (0), 0, 0);
    gtk_label_set_justify (GTK_LABEL (tmp), GTK_JUSTIFY_RIGHT);
    gtk_misc_set_alignment (GTK_MISC (tmp), 1, 0.5);

    if(!w->quick) {
	l->savelogin_w =
	    gtk_check_button_new_with_label(_("Save the login"));
	gtk_widget_show (l->savelogin_w);
	gtk_table_attach (GTK_TABLE (table), l->savelogin_w, 0, 2, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
    } else {
	l->savelogin_w = NULL;
    }

    l->username_w = gtk_entry_new ();
    gtk_widget_show (l->username_w);
    gtk_table_attach (GTK_TABLE (table), l->username_w, 1, 2, 0, 1,
		      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		      (GtkAttachOptions) (0), 0, 0);

    l->password_w = gtk_entry_new ();
    gtk_widget_show (l->password_w);
    gtk_table_attach (GTK_TABLE (table), l->password_w, 1, 2, 1, 2,
		      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		      (GtkAttachOptions) (0), 0, 0);
    gtk_entry_set_visibility (GTK_ENTRY (l->password_w), FALSE);

    tmp = gtk_hseparator_new ();
    gtk_widget_show (tmp);
    gtk_box_pack_start (GTK_BOX (vbox), tmp, TRUE, TRUE, 0);

    hbb = gtk_hbutton_box_new ();
    gtk_widget_show (hbb);
    gtk_box_pack_start (GTK_BOX (vbox), hbb, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbb), 5);
    gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbb), 0);
    gtk_button_box_set_child_size (GTK_BUTTON_BOX (hbb), 3, 0);

    tmp = gtk_button_new_with_label (_("Log in"));
    gtk_widget_show (tmp);
    gtk_container_add (GTK_CONTAINER (hbb), tmp);
    GTK_WIDGET_SET_FLAGS (tmp, GTK_CAN_DEFAULT);
    gtk_signal_connect(GTK_OBJECT(tmp), "clicked",
		       GTK_SIGNAL_FUNC(login_ok), l);
    l->ok_but = tmp;

    tmp = gtk_button_new_with_label (_("Close"));
    gtk_widget_show (tmp);
    gtk_container_add (GTK_CONTAINER (hbb), tmp);
    GTK_WIDGET_SET_FLAGS (tmp, GTK_CAN_DEFAULT);
    gtk_widget_grab_default (tmp);
    gtk_signal_connect(GTK_OBJECT(tmp), "clicked",
		       GTK_SIGNAL_FUNC(gm_dialog_login_close), l);
    l->close_but = tmp;

    tmp = gtk_button_new_with_label (_("Help"));
    gtk_widget_show (tmp);
    gtk_container_add (GTK_CONTAINER (hbb), tmp);
    GTK_WIDGET_SET_FLAGS (tmp, GTK_CAN_DEFAULT);
    gtk_signal_connect(GTK_OBJECT(tmp), "clicked",
		       GTK_SIGNAL_FUNC(gm_help_show), HELP_DLOGIN);

    gtk_entry_set_text(GTK_ENTRY(l->username_w), l->username);
    gtk_entry_set_text(GTK_ENTRY(l->password_w), l->password);
    if(!w->quick) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(l->savelogin_w), 
				     l->savelogin);
    }

    gtk_widget_set_sensitive(l->ok_but, FALSE);
    if (strlen(l->username))
        gtk_widget_set_sensitive(l->ok_but, TRUE);
    gtk_signal_connect(GTK_OBJECT(l->username_w), "changed",
		       GTK_SIGNAL_FUNC(login_changed), l);
    gtk_signal_connect(GTK_OBJECT(l->password_w), "changed",
		       GTK_SIGNAL_FUNC(login_changed), l);
    if(!w->quick) {
	gtk_signal_connect(GTK_OBJECT(l->savelogin_w), "toggled",
			   GTK_SIGNAL_FUNC(login_changed), l);
    }

    gtk_widget_grab_focus(l->username_w);

    gtk_signal_connect_object(GTK_OBJECT(l->username_w), "activate",
			      GTK_SIGNAL_FUNC(gtk_widget_grab_focus),
			      GTK_OBJECT(l->password_w));
    gtk_signal_connect(GTK_OBJECT(l->password_w), "activate",
		       GTK_SIGNAL_FUNC(password_activated), l);

    gtk_widget_show(l->window);

    w->dialog_login = l;
}
