#ifndef MOON_H
#define MOON_H 1
/*
 * Moon.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Original (C) Mike Henderson <mghenderson@lanl.gov>.
 *
 * I've converted Mike Henderson's original file to glib types, 
 * removed unused variables, and piped the whole thing through indent.
 *
 * (C) 1999-2003 josh buhl <jbuhl@users.sourceforge.net> 
 *
 */

#include <glib.h>

gdouble Moon(gdouble T, gdouble * LAMBDA, gdouble * BETA, gdouble * R,
	     gdouble * AGE);
gdouble frac(gdouble x);
gdouble NewMoon(gdouble ax, gdouble bx, gdouble cx);
gint MiniMoon(gdouble T, gdouble * RA, gdouble * DEC);

#endif	/* !MOON_H */
