drop database if exists rli1000;

create database rli1000;

use rli1000;

create table t_lfn (
  id int not null auto_increment primary key,
  name varchar(250) not null,
  ref int default 0 not null
) type = innodb;
create unique index t_lfn_name on t_lfn(name);

create table t_lrc (
  id int not null auto_increment primary key,
  name varchar(250) not null,
  ref int default 0 not null
) type = innodb;
create unique index t_lrc_name on t_lrc(name);

create table t_sender (
  id int not null auto_increment primary key,
  name varchar(250) not null,
  ref int default 0 not null
) type = innodb;
create unique index t_sender_name on t_sender(name);

create table t_map (
  lfn_id int not null references t_lfn(id),
  lrc_id int not null references t_lrc(id),
  sender_id int not null references t_sender(id),
  updatetime timestamp
) type = innodb;
alter table t_map add constraint pk_map primary key(lfn_id, lrc_id, sender_id);
create index t_map_lrc_id on t_map(lrc_id);
create index t_map_sender_id on t_map(sender_id);
create index t_map_updatetime on t_map(updatetime);

create table t_rli (
  id int not null auto_increment primary key,
  flags int default 0 not null,
  name varchar(250) not null
) type = innodb;
create unique index t_rli_name on t_rli(name);

create table t_rlipartition (
  rli_id int not null references t_rli(id),
  pattern varchar(250) not null
) type = innodb;
alter table t_rlipartition add constraint pk_rlipartition primary key(rli_id, pattern);
create index t_rlipartition_pattern on t_rlipartition(pattern);
