/*
 * Portions of this file Copyright 1999-2005 University of Chicago
 * Portions of this file Copyright 1999-2005 The University of Southern California.
 *
 * This file or a portion of this file is licensed under the
 * terms of the Globus Toolkit Public License, found at
 * http://www.globus.org/toolkit/download/license.html.
 * If you redistribute this file, with or without
 * modifications, you must include this notice in the file.
 */


#ifndef UTIL_UTILS_H
#define UTIL_UTILS_H

/********************************************************************
 *
 * This file defines GRUB thread-safe utility routines
 *
 ********************************************************************/

#ifndef EXTERN_C_BEGIN
#ifdef __cplusplus
#define EXTERN_C_BEGIN extern "C" {
#define EXTERN_C_END }
#else
#define EXTERN_C_BEGIN
#define EXTERN_C_END
#endif
#endif
 

#include <stdarg.h>
#include <stdio.h>

#define GLOBUS_IGNORE (void)

EXTERN_C_BEGIN


int utils_sprintf(char *s, const char *format, /* args */ ... );
int utils_fprintf(FILE *fp, const char *format, /* args */ ... );

int utils_strlen (const char *str);

char *utils_strdup (const char *src);

int utils_streq (const char *s1, const char *s2);
int utils_streq_ci (const char *s1, const char *s2);

void utils_debug(int pred, const char*format, ...);

void
globus_l_duroc_hex_decode_byte_array (const char *    src_hex_array,
				      int             byte_count,
				      globus_byte_t * dst_byte_array);

void
globus_l_duroc_hex_encode_byte_array (const globus_byte_t * src_byte_array,
				      int                   byte_count,
				      char *                dst_hex_array);

EXTERN_C_END

#endif /* UTIL_UTILS_H */

