/*
** The OpenGL Extension Wrangler Library
** Copyright (C) 2004, 2003, 2002, Milan Ikits <milan ikits[at]ieee org>
** Copyright (C) 2004, 2003, 2002, Marcelo E. Magallon <mmagallo[at]debian org>
** Copyright (C) 2002, Lev Povalahev
** All rights reserved.
** 
** Redistribution and use in source and binary forms, with or without 
** modification, are permitted provided that the following conditions are met:
** 
** * Redistributions of source code must retain the above copyright notice, 
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice, 
**   this list of conditions and the following disclaimer in the documentation 
**   and/or other materials provided with the distribution.
** * The name of the author may be used to endorse or promote products 
**   derived from this software without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
** LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
** CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
** SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
** CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
** THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <GL/glew.h>
#if defined(_WIN32)
#include <GL/wglew.h>
#elif !defined(__APPLE__) || defined(GLEW_APPLE_GLX)
#include <GL/glxew.h>
#endif

static FILE* f;

#ifdef GLEW_MX
GLEWContext _glewctx;
#define glewGetContext() (&_glewctx)
#ifdef _WIN32
WGLEWContext _wglewctx;
#define wglewGetContext() (&_wglewctx)
#elif !defined(__APPLE__) || defined(GLEW_APPLE_GLX)
GLXEWContext _glxewctx;
#define glxewGetContext() (&_glxewctx)
#endif
#endif

#if defined(_WIN32)
GLboolean glewCreateContext (int* pixelformat);
#elif !defined(__APPLE__) || defined(GLEW_APPLE_GLX)
GLboolean glewCreateContext (const char* display, int* visual);
#else
GLboolean glewCreateContext ();
#endif

#if defined(_WIN32) || !defined(__APPLE__) || defined(GLEW_APPLE_GLX)
GLboolean glewParseArgs (int argc, char** argv, char** display, int* visual);
#endif

void glewDestroyContext ();

/* ------------------------------------------------------------------------- */

static void glewPrintExt (const char* name, GLint def1, GLint def2)
{
  unsigned int i;
  fprintf(f, "\n%s:", name);
  for (i=0; i<62-strlen(name); i++) fprintf(f, " ");
  fprintf(f, "%s ", def1 ? "OK" : "MISSING");
  if (def1 != def2)
    fprintf(f, "[%s]\n", def2 ? "OK" : "MISSING");
  else
    fprintf(f, "\n");
  for (i=0; i<strlen(name)+1; i++) fprintf(f, "-");
  fprintf(f, "\n");
  fflush(f);
}

static void glewInfoFunc (const char* name, GLint undefined)
{
  unsigned int i;
  fprintf(f, "  %s:", name);
  for (i=0; i<60-strlen(name); i++) fprintf(f, " ");
  fprintf(f, "%s\n", undefined ? "MISSING" : "OK");
  fflush(f);
}

/* ----------------------------- GL_VERSION_1_1 ---------------------------- */

#ifdef GL_VERSION_1_1

static void _glewInfo_GL_VERSION_1_1 (void)
{
  glewPrintExt("GL_VERSION_1_1", GLEW_VERSION_1_1, GLEW_VERSION_1_1);
}

#endif /* GL_VERSION_1_1 */

/* ----------------------------- GL_VERSION_1_2 ---------------------------- */

#ifdef GL_VERSION_1_2

static void _glewInfo_GL_VERSION_1_2 (void)
{
  glewPrintExt("GL_VERSION_1_2", GLEW_VERSION_1_2, GLEW_VERSION_1_2);

  glewInfoFunc("glCopyTexSubImage3D", glCopyTexSubImage3D == NULL);
  glewInfoFunc("glDrawRangeElements", glDrawRangeElements == NULL);
  glewInfoFunc("glTexImage3D", glTexImage3D == NULL);
  glewInfoFunc("glTexSubImage3D", glTexSubImage3D == NULL);
}

#endif /* GL_VERSION_1_2 */

/* ----------------------------- GL_VERSION_1_3 ---------------------------- */

#ifdef GL_VERSION_1_3

static void _glewInfo_GL_VERSION_1_3 (void)
{
  glewPrintExt("GL_VERSION_1_3", GLEW_VERSION_1_3, GLEW_VERSION_1_3);

  glewInfoFunc("glActiveTexture", glActiveTexture == NULL);
  glewInfoFunc("glClientActiveTexture", glClientActiveTexture == NULL);
  glewInfoFunc("glCompressedTexImage1D", glCompressedTexImage1D == NULL);
  glewInfoFunc("glCompressedTexImage2D", glCompressedTexImage2D == NULL);
  glewInfoFunc("glCompressedTexImage3D", glCompressedTexImage3D == NULL);
  glewInfoFunc("glCompressedTexSubImage1D", glCompressedTexSubImage1D == NULL);
  glewInfoFunc("glCompressedTexSubImage2D", glCompressedTexSubImage2D == NULL);
  glewInfoFunc("glCompressedTexSubImage3D", glCompressedTexSubImage3D == NULL);
  glewInfoFunc("glGetCompressedTexImage", glGetCompressedTexImage == NULL);
  glewInfoFunc("glLoadTransposeMatrixd", glLoadTransposeMatrixd == NULL);
  glewInfoFunc("glLoadTransposeMatrixf", glLoadTransposeMatrixf == NULL);
  glewInfoFunc("glMultTransposeMatrixd", glMultTransposeMatrixd == NULL);
  glewInfoFunc("glMultTransposeMatrixf", glMultTransposeMatrixf == NULL);
  glewInfoFunc("glMultiTexCoord1d", glMultiTexCoord1d == NULL);
  glewInfoFunc("glMultiTexCoord1dv", glMultiTexCoord1dv == NULL);
  glewInfoFunc("glMultiTexCoord1f", glMultiTexCoord1f == NULL);
  glewInfoFunc("glMultiTexCoord1fv", glMultiTexCoord1fv == NULL);
  glewInfoFunc("glMultiTexCoord1i", glMultiTexCoord1i == NULL);
  glewInfoFunc("glMultiTexCoord1iv", glMultiTexCoord1iv == NULL);
  glewInfoFunc("glMultiTexCoord1s", glMultiTexCoord1s == NULL);
  glewInfoFunc("glMultiTexCoord1sv", glMultiTexCoord1sv == NULL);
  glewInfoFunc("glMultiTexCoord2d", glMultiTexCoord2d == NULL);
  glewInfoFunc("glMultiTexCoord2dv", glMultiTexCoord2dv == NULL);
  glewInfoFunc("glMultiTexCoord2f", glMultiTexCoord2f == NULL);
  glewInfoFunc("glMultiTexCoord2fv", glMultiTexCoord2fv == NULL);
  glewInfoFunc("glMultiTexCoord2i", glMultiTexCoord2i == NULL);
  glewInfoFunc("glMultiTexCoord2iv", glMultiTexCoord2iv == NULL);
  glewInfoFunc("glMultiTexCoord2s", glMultiTexCoord2s == NULL);
  glewInfoFunc("glMultiTexCoord2sv", glMultiTexCoord2sv == NULL);
  glewInfoFunc("glMultiTexCoord3d", glMultiTexCoord3d == NULL);
  glewInfoFunc("glMultiTexCoord3dv", glMultiTexCoord3dv == NULL);
  glewInfoFunc("glMultiTexCoord3f", glMultiTexCoord3f == NULL);
  glewInfoFunc("glMultiTexCoord3fv", glMultiTexCoord3fv == NULL);
  glewInfoFunc("glMultiTexCoord3i", glMultiTexCoord3i == NULL);
  glewInfoFunc("glMultiTexCoord3iv", glMultiTexCoord3iv == NULL);
  glewInfoFunc("glMultiTexCoord3s", glMultiTexCoord3s == NULL);
  glewInfoFunc("glMultiTexCoord3sv", glMultiTexCoord3sv == NULL);
  glewInfoFunc("glMultiTexCoord4d", glMultiTexCoord4d == NULL);
  glewInfoFunc("glMultiTexCoord4dv", glMultiTexCoord4dv == NULL);
  glewInfoFunc("glMultiTexCoord4f", glMultiTexCoord4f == NULL);
  glewInfoFunc("glMultiTexCoord4fv", glMultiTexCoord4fv == NULL);
  glewInfoFunc("glMultiTexCoord4i", glMultiTexCoord4i == NULL);
  glewInfoFunc("glMultiTexCoord4iv", glMultiTexCoord4iv == NULL);
  glewInfoFunc("glMultiTexCoord4s", glMultiTexCoord4s == NULL);
  glewInfoFunc("glMultiTexCoord4sv", glMultiTexCoord4sv == NULL);
  glewInfoFunc("glSampleCoverage", glSampleCoverage == NULL);
}

#endif /* GL_VERSION_1_3 */

/* ----------------------------- GL_VERSION_1_4 ---------------------------- */

#ifdef GL_VERSION_1_4

static void _glewInfo_GL_VERSION_1_4 (void)
{
  glewPrintExt("GL_VERSION_1_4", GLEW_VERSION_1_4, GLEW_VERSION_1_4);

  glewInfoFunc("glBlendColor", glBlendColor == NULL);
  glewInfoFunc("glBlendEquation", glBlendEquation == NULL);
  glewInfoFunc("glBlendFuncSeparate", glBlendFuncSeparate == NULL);
  glewInfoFunc("glFogCoordPointer", glFogCoordPointer == NULL);
  glewInfoFunc("glFogCoordd", glFogCoordd == NULL);
  glewInfoFunc("glFogCoorddv", glFogCoorddv == NULL);
  glewInfoFunc("glFogCoordf", glFogCoordf == NULL);
  glewInfoFunc("glFogCoordfv", glFogCoordfv == NULL);
  glewInfoFunc("glMultiDrawArrays", glMultiDrawArrays == NULL);
  glewInfoFunc("glMultiDrawElements", glMultiDrawElements == NULL);
  glewInfoFunc("glPointParameterf", glPointParameterf == NULL);
  glewInfoFunc("glPointParameterfv", glPointParameterfv == NULL);
  glewInfoFunc("glSecondaryColor3b", glSecondaryColor3b == NULL);
  glewInfoFunc("glSecondaryColor3bv", glSecondaryColor3bv == NULL);
  glewInfoFunc("glSecondaryColor3d", glSecondaryColor3d == NULL);
  glewInfoFunc("glSecondaryColor3dv", glSecondaryColor3dv == NULL);
  glewInfoFunc("glSecondaryColor3f", glSecondaryColor3f == NULL);
  glewInfoFunc("glSecondaryColor3fv", glSecondaryColor3fv == NULL);
  glewInfoFunc("glSecondaryColor3i", glSecondaryColor3i == NULL);
  glewInfoFunc("glSecondaryColor3iv", glSecondaryColor3iv == NULL);
  glewInfoFunc("glSecondaryColor3s", glSecondaryColor3s == NULL);
  glewInfoFunc("glSecondaryColor3sv", glSecondaryColor3sv == NULL);
  glewInfoFunc("glSecondaryColor3ub", glSecondaryColor3ub == NULL);
  glewInfoFunc("glSecondaryColor3ubv", glSecondaryColor3ubv == NULL);
  glewInfoFunc("glSecondaryColor3ui", glSecondaryColor3ui == NULL);
  glewInfoFunc("glSecondaryColor3uiv", glSecondaryColor3uiv == NULL);
  glewInfoFunc("glSecondaryColor3us", glSecondaryColor3us == NULL);
  glewInfoFunc("glSecondaryColor3usv", glSecondaryColor3usv == NULL);
  glewInfoFunc("glSecondaryColorPointer", glSecondaryColorPointer == NULL);
  glewInfoFunc("glWindowPos2d", glWindowPos2d == NULL);
  glewInfoFunc("glWindowPos2dv", glWindowPos2dv == NULL);
  glewInfoFunc("glWindowPos2f", glWindowPos2f == NULL);
  glewInfoFunc("glWindowPos2fv", glWindowPos2fv == NULL);
  glewInfoFunc("glWindowPos2i", glWindowPos2i == NULL);
  glewInfoFunc("glWindowPos2iv", glWindowPos2iv == NULL);
  glewInfoFunc("glWindowPos2s", glWindowPos2s == NULL);
  glewInfoFunc("glWindowPos2sv", glWindowPos2sv == NULL);
  glewInfoFunc("glWindowPos3d", glWindowPos3d == NULL);
  glewInfoFunc("glWindowPos3dv", glWindowPos3dv == NULL);
  glewInfoFunc("glWindowPos3f", glWindowPos3f == NULL);
  glewInfoFunc("glWindowPos3fv", glWindowPos3fv == NULL);
  glewInfoFunc("glWindowPos3i", glWindowPos3i == NULL);
  glewInfoFunc("glWindowPos3iv", glWindowPos3iv == NULL);
  glewInfoFunc("glWindowPos3s", glWindowPos3s == NULL);
  glewInfoFunc("glWindowPos3sv", glWindowPos3sv == NULL);
}

#endif /* GL_VERSION_1_4 */

/* ----------------------------- GL_VERSION_1_5 ---------------------------- */

#ifdef GL_VERSION_1_5

static void _glewInfo_GL_VERSION_1_5 (void)
{
  glewPrintExt("GL_VERSION_1_5", GLEW_VERSION_1_5, GLEW_VERSION_1_5);

  glewInfoFunc("glBeginQuery", glBeginQuery == NULL);
  glewInfoFunc("glBindBuffer", glBindBuffer == NULL);
  glewInfoFunc("glBufferData", glBufferData == NULL);
  glewInfoFunc("glBufferSubData", glBufferSubData == NULL);
  glewInfoFunc("glDeleteBuffers", glDeleteBuffers == NULL);
  glewInfoFunc("glDeleteQueries", glDeleteQueries == NULL);
  glewInfoFunc("glEndQuery", glEndQuery == NULL);
  glewInfoFunc("glGenBuffers", glGenBuffers == NULL);
  glewInfoFunc("glGenQueries", glGenQueries == NULL);
  glewInfoFunc("glGetBufferParameteriv", glGetBufferParameteriv == NULL);
  glewInfoFunc("glGetBufferPointerv", glGetBufferPointerv == NULL);
  glewInfoFunc("glGetBufferSubData", glGetBufferSubData == NULL);
  glewInfoFunc("glGetQueryObjectiv", glGetQueryObjectiv == NULL);
  glewInfoFunc("glGetQueryObjectuiv", glGetQueryObjectuiv == NULL);
  glewInfoFunc("glGetQueryiv", glGetQueryiv == NULL);
  glewInfoFunc("glIsBuffer", glIsBuffer == NULL);
  glewInfoFunc("glIsQuery", glIsQuery == NULL);
  glewInfoFunc("glMapBuffer", glMapBuffer == NULL);
  glewInfoFunc("glUnmapBuffer", glUnmapBuffer == NULL);
}

#endif /* GL_VERSION_1_5 */

/* -------------------------- GL_3DFX_multisample -------------------------- */

#ifdef GL_3DFX_multisample

static void _glewInfo_GL_3DFX_multisample (void)
{
  glewPrintExt("GL_3DFX_multisample", GLEW_3DFX_multisample, glewGetExtension("GL_3DFX_multisample"));
}

#endif /* GL_3DFX_multisample */

/* ---------------------------- GL_3DFX_tbuffer ---------------------------- */

#ifdef GL_3DFX_tbuffer

static void _glewInfo_GL_3DFX_tbuffer (void)
{
  glewPrintExt("GL_3DFX_tbuffer", GLEW_3DFX_tbuffer, glewGetExtension("GL_3DFX_tbuffer"));

  glewInfoFunc("glTbufferMask3DFX", glTbufferMask3DFX == NULL);
}

#endif /* GL_3DFX_tbuffer */

/* -------------------- GL_3DFX_texture_compression_FXT1 ------------------- */

#ifdef GL_3DFX_texture_compression_FXT1

static void _glewInfo_GL_3DFX_texture_compression_FXT1 (void)
{
  glewPrintExt("GL_3DFX_texture_compression_FXT1", GLEW_3DFX_texture_compression_FXT1, glewGetExtension("GL_3DFX_texture_compression_FXT1"));
}

#endif /* GL_3DFX_texture_compression_FXT1 */

/* ------------------------ GL_APPLE_client_storage ------------------------ */

#ifdef GL_APPLE_client_storage

static void _glewInfo_GL_APPLE_client_storage (void)
{
  glewPrintExt("GL_APPLE_client_storage", GLEW_APPLE_client_storage, glewGetExtension("GL_APPLE_client_storage"));
}

#endif /* GL_APPLE_client_storage */

/* ------------------------- GL_APPLE_element_array ------------------------ */

#ifdef GL_APPLE_element_array

static void _glewInfo_GL_APPLE_element_array (void)
{
  glewPrintExt("GL_APPLE_element_array", GLEW_APPLE_element_array, glewGetExtension("GL_APPLE_element_array"));

  glewInfoFunc("glDrawElementArrayAPPLE", glDrawElementArrayAPPLE == NULL);
  glewInfoFunc("glDrawRangeElementArrayAPPLE", glDrawRangeElementArrayAPPLE == NULL);
  glewInfoFunc("glElementPointerAPPLE", glElementPointerAPPLE == NULL);
  glewInfoFunc("glMultiDrawElementArrayAPPLE", glMultiDrawElementArrayAPPLE == NULL);
  glewInfoFunc("glMultiDrawRangeElementArrayAPPLE", glMultiDrawRangeElementArrayAPPLE == NULL);
}

#endif /* GL_APPLE_element_array */

/* ----------------------------- GL_APPLE_fence ---------------------------- */

#ifdef GL_APPLE_fence

static void _glewInfo_GL_APPLE_fence (void)
{
  glewPrintExt("GL_APPLE_fence", GLEW_APPLE_fence, glewGetExtension("GL_APPLE_fence"));

  glewInfoFunc("glDeleteFencesAPPLE", glDeleteFencesAPPLE == NULL);
  glewInfoFunc("glFinishFenceAPPLE", glFinishFenceAPPLE == NULL);
  glewInfoFunc("glFinishObjectAPPLE", glFinishObjectAPPLE == NULL);
  glewInfoFunc("glGenFencesAPPLE", glGenFencesAPPLE == NULL);
  glewInfoFunc("glIsFenceAPPLE", glIsFenceAPPLE == NULL);
  glewInfoFunc("glSetFenceAPPLE", glSetFenceAPPLE == NULL);
  glewInfoFunc("glTestFenceAPPLE", glTestFenceAPPLE == NULL);
  glewInfoFunc("glTestObjectAPPLE", glTestObjectAPPLE == NULL);
}

#endif /* GL_APPLE_fence */

/* ------------------------- GL_APPLE_float_pixels ------------------------- */

#ifdef GL_APPLE_float_pixels

static void _glewInfo_GL_APPLE_float_pixels (void)
{
  glewPrintExt("GL_APPLE_float_pixels", GLEW_APPLE_float_pixels, glewGetExtension("GL_APPLE_float_pixels"));
}

#endif /* GL_APPLE_float_pixels */

/* ------------------------ GL_APPLE_specular_vector ----------------------- */

#ifdef GL_APPLE_specular_vector

static void _glewInfo_GL_APPLE_specular_vector (void)
{
  glewPrintExt("GL_APPLE_specular_vector", GLEW_APPLE_specular_vector, glewGetExtension("GL_APPLE_specular_vector"));
}

#endif /* GL_APPLE_specular_vector */

/* ------------------------- GL_APPLE_texture_range ------------------------ */

#ifdef GL_APPLE_texture_range

static void _glewInfo_GL_APPLE_texture_range (void)
{
  glewPrintExt("GL_APPLE_texture_range", GLEW_APPLE_texture_range, glewGetExtension("GL_APPLE_texture_range"));

  glewInfoFunc("glGetTexParameterPointervAPPLE", glGetTexParameterPointervAPPLE == NULL);
  glewInfoFunc("glTextureRangeAPPLE", glTextureRangeAPPLE == NULL);
}

#endif /* GL_APPLE_texture_range */

/* ------------------------ GL_APPLE_transform_hint ------------------------ */

#ifdef GL_APPLE_transform_hint

static void _glewInfo_GL_APPLE_transform_hint (void)
{
  glewPrintExt("GL_APPLE_transform_hint", GLEW_APPLE_transform_hint, glewGetExtension("GL_APPLE_transform_hint"));
}

#endif /* GL_APPLE_transform_hint */

/* ---------------------- GL_APPLE_vertex_array_object --------------------- */

#ifdef GL_APPLE_vertex_array_object

static void _glewInfo_GL_APPLE_vertex_array_object (void)
{
  glewPrintExt("GL_APPLE_vertex_array_object", GLEW_APPLE_vertex_array_object, glewGetExtension("GL_APPLE_vertex_array_object"));

  glewInfoFunc("glBindVertexArrayAPPLE", glBindVertexArrayAPPLE == NULL);
  glewInfoFunc("glDeleteVertexArraysAPPLE", glDeleteVertexArraysAPPLE == NULL);
  glewInfoFunc("glGenVertexArraysAPPLE", glGenVertexArraysAPPLE == NULL);
  glewInfoFunc("glIsVertexArrayAPPLE", glIsVertexArrayAPPLE == NULL);
}

#endif /* GL_APPLE_vertex_array_object */

/* ---------------------- GL_APPLE_vertex_array_range ---------------------- */

#ifdef GL_APPLE_vertex_array_range

static void _glewInfo_GL_APPLE_vertex_array_range (void)
{
  glewPrintExt("GL_APPLE_vertex_array_range", GLEW_APPLE_vertex_array_range, glewGetExtension("GL_APPLE_vertex_array_range"));

  glewInfoFunc("glFlushVertexArrayRangeAPPLE", glFlushVertexArrayRangeAPPLE == NULL);
  glewInfoFunc("glVertexArrayParameteriAPPLE", glVertexArrayParameteriAPPLE == NULL);
  glewInfoFunc("glVertexArrayRangeAPPLE", glVertexArrayRangeAPPLE == NULL);
}

#endif /* GL_APPLE_vertex_array_range */

/* --------------------------- GL_APPLE_ycbcr_422 -------------------------- */

#ifdef GL_APPLE_ycbcr_422

static void _glewInfo_GL_APPLE_ycbcr_422 (void)
{
  glewPrintExt("GL_APPLE_ycbcr_422", GLEW_APPLE_ycbcr_422, glewGetExtension("GL_APPLE_ycbcr_422"));
}

#endif /* GL_APPLE_ycbcr_422 */

/* -------------------------- GL_ARB_depth_texture ------------------------- */

#ifdef GL_ARB_depth_texture

static void _glewInfo_GL_ARB_depth_texture (void)
{
  glewPrintExt("GL_ARB_depth_texture", GLEW_ARB_depth_texture, glewGetExtension("GL_ARB_depth_texture"));
}

#endif /* GL_ARB_depth_texture */

/* -------------------------- GL_ARB_draw_buffers -------------------------- */

#ifdef GL_ARB_draw_buffers

static void _glewInfo_GL_ARB_draw_buffers (void)
{
  glewPrintExt("GL_ARB_draw_buffers", GLEW_ARB_draw_buffers, glewGetExtension("GL_ARB_draw_buffers"));

  glewInfoFunc("glDrawBuffersARB", glDrawBuffersARB == NULL);
}

#endif /* GL_ARB_draw_buffers */

/* ------------------------ GL_ARB_fragment_program ------------------------ */

#ifdef GL_ARB_fragment_program

static void _glewInfo_GL_ARB_fragment_program (void)
{
  glewPrintExt("GL_ARB_fragment_program", GLEW_ARB_fragment_program, glewGetExtension("GL_ARB_fragment_program"));
}

#endif /* GL_ARB_fragment_program */

/* --------------------- GL_ARB_fragment_program_shadow -------------------- */

#ifdef GL_ARB_fragment_program_shadow

static void _glewInfo_GL_ARB_fragment_program_shadow (void)
{
  glewPrintExt("GL_ARB_fragment_program_shadow", GLEW_ARB_fragment_program_shadow, glewGetExtension("GL_ARB_fragment_program_shadow"));
}

#endif /* GL_ARB_fragment_program_shadow */

/* ------------------------- GL_ARB_fragment_shader ------------------------ */

#ifdef GL_ARB_fragment_shader

static void _glewInfo_GL_ARB_fragment_shader (void)
{
  glewPrintExt("GL_ARB_fragment_shader", GLEW_ARB_fragment_shader, glewGetExtension("GL_ARB_fragment_shader"));
}

#endif /* GL_ARB_fragment_shader */

/* ----------------------------- GL_ARB_imaging ---------------------------- */

#ifdef GL_ARB_imaging

static void _glewInfo_GL_ARB_imaging (void)
{
  glewPrintExt("GL_ARB_imaging", GLEW_ARB_imaging, glewGetExtension("GL_ARB_imaging"));

  glewInfoFunc("glColorSubTable", glColorSubTable == NULL);
  glewInfoFunc("glColorTable", glColorTable == NULL);
  glewInfoFunc("glColorTableParameterfv", glColorTableParameterfv == NULL);
  glewInfoFunc("glColorTableParameteriv", glColorTableParameteriv == NULL);
  glewInfoFunc("glConvolutionFilter1D", glConvolutionFilter1D == NULL);
  glewInfoFunc("glConvolutionFilter2D", glConvolutionFilter2D == NULL);
  glewInfoFunc("glConvolutionParameterf", glConvolutionParameterf == NULL);
  glewInfoFunc("glConvolutionParameterfv", glConvolutionParameterfv == NULL);
  glewInfoFunc("glConvolutionParameteri", glConvolutionParameteri == NULL);
  glewInfoFunc("glConvolutionParameteriv", glConvolutionParameteriv == NULL);
  glewInfoFunc("glCopyColorSubTable", glCopyColorSubTable == NULL);
  glewInfoFunc("glCopyColorTable", glCopyColorTable == NULL);
  glewInfoFunc("glCopyConvolutionFilter1D", glCopyConvolutionFilter1D == NULL);
  glewInfoFunc("glCopyConvolutionFilter2D", glCopyConvolutionFilter2D == NULL);
  glewInfoFunc("glGetColorTable", glGetColorTable == NULL);
  glewInfoFunc("glGetColorTableParameterfv", glGetColorTableParameterfv == NULL);
  glewInfoFunc("glGetColorTableParameteriv", glGetColorTableParameteriv == NULL);
  glewInfoFunc("glGetConvolutionFilter", glGetConvolutionFilter == NULL);
  glewInfoFunc("glGetConvolutionParameterfv", glGetConvolutionParameterfv == NULL);
  glewInfoFunc("glGetConvolutionParameteriv", glGetConvolutionParameteriv == NULL);
  glewInfoFunc("glGetHistogram", glGetHistogram == NULL);
  glewInfoFunc("glGetHistogramParameterfv", glGetHistogramParameterfv == NULL);
  glewInfoFunc("glGetHistogramParameteriv", glGetHistogramParameteriv == NULL);
  glewInfoFunc("glGetMinmax", glGetMinmax == NULL);
  glewInfoFunc("glGetMinmaxParameterfv", glGetMinmaxParameterfv == NULL);
  glewInfoFunc("glGetMinmaxParameteriv", glGetMinmaxParameteriv == NULL);
  glewInfoFunc("glGetSeparableFilter", glGetSeparableFilter == NULL);
  glewInfoFunc("glHistogram", glHistogram == NULL);
  glewInfoFunc("glMinmax", glMinmax == NULL);
  glewInfoFunc("glResetHistogram", glResetHistogram == NULL);
  glewInfoFunc("glResetMinmax", glResetMinmax == NULL);
  glewInfoFunc("glSeparableFilter2D", glSeparableFilter2D == NULL);
}

#endif /* GL_ARB_imaging */

/* ------------------------- GL_ARB_matrix_palette ------------------------- */

#ifdef GL_ARB_matrix_palette

static void _glewInfo_GL_ARB_matrix_palette (void)
{
  glewPrintExt("GL_ARB_matrix_palette", GLEW_ARB_matrix_palette, glewGetExtension("GL_ARB_matrix_palette"));

  glewInfoFunc("glCurrentPaletteMatrixARB", glCurrentPaletteMatrixARB == NULL);
  glewInfoFunc("glMatrixIndexPointerARB", glMatrixIndexPointerARB == NULL);
  glewInfoFunc("glMatrixIndexubvARB", glMatrixIndexubvARB == NULL);
  glewInfoFunc("glMatrixIndexuivARB", glMatrixIndexuivARB == NULL);
  glewInfoFunc("glMatrixIndexusvARB", glMatrixIndexusvARB == NULL);
}

#endif /* GL_ARB_matrix_palette */

/* --------------------------- GL_ARB_multisample -------------------------- */

#ifdef GL_ARB_multisample

static void _glewInfo_GL_ARB_multisample (void)
{
  glewPrintExt("GL_ARB_multisample", GLEW_ARB_multisample, glewGetExtension("GL_ARB_multisample"));

  glewInfoFunc("glSampleCoverageARB", glSampleCoverageARB == NULL);
}

#endif /* GL_ARB_multisample */

/* -------------------------- GL_ARB_multitexture -------------------------- */

#ifdef GL_ARB_multitexture

static void _glewInfo_GL_ARB_multitexture (void)
{
  glewPrintExt("GL_ARB_multitexture", GLEW_ARB_multitexture, glewGetExtension("GL_ARB_multitexture"));

  glewInfoFunc("glActiveTextureARB", glActiveTextureARB == NULL);
  glewInfoFunc("glClientActiveTextureARB", glClientActiveTextureARB == NULL);
  glewInfoFunc("glMultiTexCoord1dARB", glMultiTexCoord1dARB == NULL);
  glewInfoFunc("glMultiTexCoord1dvARB", glMultiTexCoord1dvARB == NULL);
  glewInfoFunc("glMultiTexCoord1fARB", glMultiTexCoord1fARB == NULL);
  glewInfoFunc("glMultiTexCoord1fvARB", glMultiTexCoord1fvARB == NULL);
  glewInfoFunc("glMultiTexCoord1iARB", glMultiTexCoord1iARB == NULL);
  glewInfoFunc("glMultiTexCoord1ivARB", glMultiTexCoord1ivARB == NULL);
  glewInfoFunc("glMultiTexCoord1sARB", glMultiTexCoord1sARB == NULL);
  glewInfoFunc("glMultiTexCoord1svARB", glMultiTexCoord1svARB == NULL);
  glewInfoFunc("glMultiTexCoord2dARB", glMultiTexCoord2dARB == NULL);
  glewInfoFunc("glMultiTexCoord2dvARB", glMultiTexCoord2dvARB == NULL);
  glewInfoFunc("glMultiTexCoord2fARB", glMultiTexCoord2fARB == NULL);
  glewInfoFunc("glMultiTexCoord2fvARB", glMultiTexCoord2fvARB == NULL);
  glewInfoFunc("glMultiTexCoord2iARB", glMultiTexCoord2iARB == NULL);
  glewInfoFunc("glMultiTexCoord2ivARB", glMultiTexCoord2ivARB == NULL);
  glewInfoFunc("glMultiTexCoord2sARB", glMultiTexCoord2sARB == NULL);
  glewInfoFunc("glMultiTexCoord2svARB", glMultiTexCoord2svARB == NULL);
  glewInfoFunc("glMultiTexCoord3dARB", glMultiTexCoord3dARB == NULL);
  glewInfoFunc("glMultiTexCoord3dvARB", glMultiTexCoord3dvARB == NULL);
  glewInfoFunc("glMultiTexCoord3fARB", glMultiTexCoord3fARB == NULL);
  glewInfoFunc("glMultiTexCoord3fvARB", glMultiTexCoord3fvARB == NULL);
  glewInfoFunc("glMultiTexCoord3iARB", glMultiTexCoord3iARB == NULL);
  glewInfoFunc("glMultiTexCoord3ivARB", glMultiTexCoord3ivARB == NULL);
  glewInfoFunc("glMultiTexCoord3sARB", glMultiTexCoord3sARB == NULL);
  glewInfoFunc("glMultiTexCoord3svARB", glMultiTexCoord3svARB == NULL);
  glewInfoFunc("glMultiTexCoord4dARB", glMultiTexCoord4dARB == NULL);
  glewInfoFunc("glMultiTexCoord4dvARB", glMultiTexCoord4dvARB == NULL);
  glewInfoFunc("glMultiTexCoord4fARB", glMultiTexCoord4fARB == NULL);
  glewInfoFunc("glMultiTexCoord4fvARB", glMultiTexCoord4fvARB == NULL);
  glewInfoFunc("glMultiTexCoord4iARB", glMultiTexCoord4iARB == NULL);
  glewInfoFunc("glMultiTexCoord4ivARB", glMultiTexCoord4ivARB == NULL);
  glewInfoFunc("glMultiTexCoord4sARB", glMultiTexCoord4sARB == NULL);
  glewInfoFunc("glMultiTexCoord4svARB", glMultiTexCoord4svARB == NULL);
}

#endif /* GL_ARB_multitexture */

/* ------------------------- GL_ARB_occlusion_query ------------------------ */

#ifdef GL_ARB_occlusion_query

static void _glewInfo_GL_ARB_occlusion_query (void)
{
  glewPrintExt("GL_ARB_occlusion_query", GLEW_ARB_occlusion_query, glewGetExtension("GL_ARB_occlusion_query"));

  glewInfoFunc("glBeginQueryARB", glBeginQueryARB == NULL);
  glewInfoFunc("glDeleteQueriesARB", glDeleteQueriesARB == NULL);
  glewInfoFunc("glEndQueryARB", glEndQueryARB == NULL);
  glewInfoFunc("glGenQueriesARB", glGenQueriesARB == NULL);
  glewInfoFunc("glGetQueryObjectivARB", glGetQueryObjectivARB == NULL);
  glewInfoFunc("glGetQueryObjectuivARB", glGetQueryObjectuivARB == NULL);
  glewInfoFunc("glGetQueryivARB", glGetQueryivARB == NULL);
  glewInfoFunc("glIsQueryARB", glIsQueryARB == NULL);
}

#endif /* GL_ARB_occlusion_query */

/* ------------------------ GL_ARB_point_parameters ------------------------ */

#ifdef GL_ARB_point_parameters

static void _glewInfo_GL_ARB_point_parameters (void)
{
  glewPrintExt("GL_ARB_point_parameters", GLEW_ARB_point_parameters, glewGetExtension("GL_ARB_point_parameters"));

  glewInfoFunc("glPointParameterfARB", glPointParameterfARB == NULL);
  glewInfoFunc("glPointParameterfvARB", glPointParameterfvARB == NULL);
}

#endif /* GL_ARB_point_parameters */

/* -------------------------- GL_ARB_point_sprite -------------------------- */

#ifdef GL_ARB_point_sprite

static void _glewInfo_GL_ARB_point_sprite (void)
{
  glewPrintExt("GL_ARB_point_sprite", GLEW_ARB_point_sprite, glewGetExtension("GL_ARB_point_sprite"));
}

#endif /* GL_ARB_point_sprite */

/* ------------------------- GL_ARB_shader_objects ------------------------- */

#ifdef GL_ARB_shader_objects

static void _glewInfo_GL_ARB_shader_objects (void)
{
  glewPrintExt("GL_ARB_shader_objects", GLEW_ARB_shader_objects, glewGetExtension("GL_ARB_shader_objects"));

  glewInfoFunc("glAttachObjectARB", glAttachObjectARB == NULL);
  glewInfoFunc("glCompileShaderARB", glCompileShaderARB == NULL);
  glewInfoFunc("glCreateProgramObjectARB", glCreateProgramObjectARB == NULL);
  glewInfoFunc("glCreateShaderObjectARB", glCreateShaderObjectARB == NULL);
  glewInfoFunc("glDeleteObjectARB", glDeleteObjectARB == NULL);
  glewInfoFunc("glDetachObjectARB", glDetachObjectARB == NULL);
  glewInfoFunc("glGetActiveUniformARB", glGetActiveUniformARB == NULL);
  glewInfoFunc("glGetAttachedObjectsARB", glGetAttachedObjectsARB == NULL);
  glewInfoFunc("glGetHandleARB", glGetHandleARB == NULL);
  glewInfoFunc("glGetInfoLogARB", glGetInfoLogARB == NULL);
  glewInfoFunc("glGetObjectParameterfvARB", glGetObjectParameterfvARB == NULL);
  glewInfoFunc("glGetObjectParameterivARB", glGetObjectParameterivARB == NULL);
  glewInfoFunc("glGetShaderSourceARB", glGetShaderSourceARB == NULL);
  glewInfoFunc("glGetUniformLocationARB", glGetUniformLocationARB == NULL);
  glewInfoFunc("glGetUniformfvARB", glGetUniformfvARB == NULL);
  glewInfoFunc("glGetUniformivARB", glGetUniformivARB == NULL);
  glewInfoFunc("glLinkProgramARB", glLinkProgramARB == NULL);
  glewInfoFunc("glShaderSourceARB", glShaderSourceARB == NULL);
  glewInfoFunc("glUniform1fARB", glUniform1fARB == NULL);
  glewInfoFunc("glUniform1fvARB", glUniform1fvARB == NULL);
  glewInfoFunc("glUniform1iARB", glUniform1iARB == NULL);
  glewInfoFunc("glUniform1ivARB", glUniform1ivARB == NULL);
  glewInfoFunc("glUniform2fARB", glUniform2fARB == NULL);
  glewInfoFunc("glUniform2fvARB", glUniform2fvARB == NULL);
  glewInfoFunc("glUniform2iARB", glUniform2iARB == NULL);
  glewInfoFunc("glUniform2ivARB", glUniform2ivARB == NULL);
  glewInfoFunc("glUniform3fARB", glUniform3fARB == NULL);
  glewInfoFunc("glUniform3fvARB", glUniform3fvARB == NULL);
  glewInfoFunc("glUniform3iARB", glUniform3iARB == NULL);
  glewInfoFunc("glUniform3ivARB", glUniform3ivARB == NULL);
  glewInfoFunc("glUniform4fARB", glUniform4fARB == NULL);
  glewInfoFunc("glUniform4fvARB", glUniform4fvARB == NULL);
  glewInfoFunc("glUniform4iARB", glUniform4iARB == NULL);
  glewInfoFunc("glUniform4ivARB", glUniform4ivARB == NULL);
  glewInfoFunc("glUniformMatrix2fvARB", glUniformMatrix2fvARB == NULL);
  glewInfoFunc("glUniformMatrix3fvARB", glUniformMatrix3fvARB == NULL);
  glewInfoFunc("glUniformMatrix4fvARB", glUniformMatrix4fvARB == NULL);
  glewInfoFunc("glUseProgramObjectARB", glUseProgramObjectARB == NULL);
  glewInfoFunc("glValidateProgramARB", glValidateProgramARB == NULL);
}

#endif /* GL_ARB_shader_objects */

/* ---------------------- GL_ARB_shading_language_100 ---------------------- */

#ifdef GL_ARB_shading_language_100

static void _glewInfo_GL_ARB_shading_language_100 (void)
{
  glewPrintExt("GL_ARB_shading_language_100", GLEW_ARB_shading_language_100, glewGetExtension("GL_ARB_shading_language_100"));
}

#endif /* GL_ARB_shading_language_100 */

/* ----------------------------- GL_ARB_shadow ----------------------------- */

#ifdef GL_ARB_shadow

static void _glewInfo_GL_ARB_shadow (void)
{
  glewPrintExt("GL_ARB_shadow", GLEW_ARB_shadow, glewGetExtension("GL_ARB_shadow"));
}

#endif /* GL_ARB_shadow */

/* ------------------------- GL_ARB_shadow_ambient ------------------------- */

#ifdef GL_ARB_shadow_ambient

static void _glewInfo_GL_ARB_shadow_ambient (void)
{
  glewPrintExt("GL_ARB_shadow_ambient", GLEW_ARB_shadow_ambient, glewGetExtension("GL_ARB_shadow_ambient"));
}

#endif /* GL_ARB_shadow_ambient */

/* ---------------------- GL_ARB_texture_border_clamp ---------------------- */

#ifdef GL_ARB_texture_border_clamp

static void _glewInfo_GL_ARB_texture_border_clamp (void)
{
  glewPrintExt("GL_ARB_texture_border_clamp", GLEW_ARB_texture_border_clamp, glewGetExtension("GL_ARB_texture_border_clamp"));
}

#endif /* GL_ARB_texture_border_clamp */

/* ----------------------- GL_ARB_texture_compression ---------------------- */

#ifdef GL_ARB_texture_compression

static void _glewInfo_GL_ARB_texture_compression (void)
{
  glewPrintExt("GL_ARB_texture_compression", GLEW_ARB_texture_compression, glewGetExtension("GL_ARB_texture_compression"));

  glewInfoFunc("glCompressedTexImage1DARB", glCompressedTexImage1DARB == NULL);
  glewInfoFunc("glCompressedTexImage2DARB", glCompressedTexImage2DARB == NULL);
  glewInfoFunc("glCompressedTexImage3DARB", glCompressedTexImage3DARB == NULL);
  glewInfoFunc("glCompressedTexSubImage1DARB", glCompressedTexSubImage1DARB == NULL);
  glewInfoFunc("glCompressedTexSubImage2DARB", glCompressedTexSubImage2DARB == NULL);
  glewInfoFunc("glCompressedTexSubImage3DARB", glCompressedTexSubImage3DARB == NULL);
  glewInfoFunc("glGetCompressedTexImageARB", glGetCompressedTexImageARB == NULL);
}

#endif /* GL_ARB_texture_compression */

/* ------------------------ GL_ARB_texture_cube_map ------------------------ */

#ifdef GL_ARB_texture_cube_map

static void _glewInfo_GL_ARB_texture_cube_map (void)
{
  glewPrintExt("GL_ARB_texture_cube_map", GLEW_ARB_texture_cube_map, glewGetExtension("GL_ARB_texture_cube_map"));
}

#endif /* GL_ARB_texture_cube_map */

/* ------------------------- GL_ARB_texture_env_add ------------------------ */

#ifdef GL_ARB_texture_env_add

static void _glewInfo_GL_ARB_texture_env_add (void)
{
  glewPrintExt("GL_ARB_texture_env_add", GLEW_ARB_texture_env_add, glewGetExtension("GL_ARB_texture_env_add"));
}

#endif /* GL_ARB_texture_env_add */

/* ----------------------- GL_ARB_texture_env_combine ---------------------- */

#ifdef GL_ARB_texture_env_combine

static void _glewInfo_GL_ARB_texture_env_combine (void)
{
  glewPrintExt("GL_ARB_texture_env_combine", GLEW_ARB_texture_env_combine, glewGetExtension("GL_ARB_texture_env_combine"));
}

#endif /* GL_ARB_texture_env_combine */

/* ---------------------- GL_ARB_texture_env_crossbar ---------------------- */

#ifdef GL_ARB_texture_env_crossbar

static void _glewInfo_GL_ARB_texture_env_crossbar (void)
{
  glewPrintExt("GL_ARB_texture_env_crossbar", GLEW_ARB_texture_env_crossbar, glewGetExtension("GL_ARB_texture_env_crossbar"));
}

#endif /* GL_ARB_texture_env_crossbar */

/* ------------------------ GL_ARB_texture_env_dot3 ------------------------ */

#ifdef GL_ARB_texture_env_dot3

static void _glewInfo_GL_ARB_texture_env_dot3 (void)
{
  glewPrintExt("GL_ARB_texture_env_dot3", GLEW_ARB_texture_env_dot3, glewGetExtension("GL_ARB_texture_env_dot3"));
}

#endif /* GL_ARB_texture_env_dot3 */

/* --------------------- GL_ARB_texture_mirrored_repeat -------------------- */

#ifdef GL_ARB_texture_mirrored_repeat

static void _glewInfo_GL_ARB_texture_mirrored_repeat (void)
{
  glewPrintExt("GL_ARB_texture_mirrored_repeat", GLEW_ARB_texture_mirrored_repeat, glewGetExtension("GL_ARB_texture_mirrored_repeat"));
}

#endif /* GL_ARB_texture_mirrored_repeat */

/* -------------------- GL_ARB_texture_non_power_of_two -------------------- */

#ifdef GL_ARB_texture_non_power_of_two

static void _glewInfo_GL_ARB_texture_non_power_of_two (void)
{
  glewPrintExt("GL_ARB_texture_non_power_of_two", GLEW_ARB_texture_non_power_of_two, glewGetExtension("GL_ARB_texture_non_power_of_two"));
}

#endif /* GL_ARB_texture_non_power_of_two */

/* ------------------------ GL_ARB_texture_rectangle ----------------------- */

#ifdef GL_ARB_texture_rectangle

static void _glewInfo_GL_ARB_texture_rectangle (void)
{
  glewPrintExt("GL_ARB_texture_rectangle", GLEW_ARB_texture_rectangle, glewGetExtension("GL_ARB_texture_rectangle"));
}

#endif /* GL_ARB_texture_rectangle */

/* ------------------------ GL_ARB_transpose_matrix ------------------------ */

#ifdef GL_ARB_transpose_matrix

static void _glewInfo_GL_ARB_transpose_matrix (void)
{
  glewPrintExt("GL_ARB_transpose_matrix", GLEW_ARB_transpose_matrix, glewGetExtension("GL_ARB_transpose_matrix"));
}

#endif /* GL_ARB_transpose_matrix */

/* -------------------------- GL_ARB_vertex_blend -------------------------- */

#ifdef GL_ARB_vertex_blend

static void _glewInfo_GL_ARB_vertex_blend (void)
{
  glewPrintExt("GL_ARB_vertex_blend", GLEW_ARB_vertex_blend, glewGetExtension("GL_ARB_vertex_blend"));

  glewInfoFunc("glVertexBlendARB", glVertexBlendARB == NULL);
  glewInfoFunc("glWeightPointerARB", glWeightPointerARB == NULL);
  glewInfoFunc("glWeightbvARB", glWeightbvARB == NULL);
  glewInfoFunc("glWeightdvARB", glWeightdvARB == NULL);
  glewInfoFunc("glWeightfvARB", glWeightfvARB == NULL);
  glewInfoFunc("glWeightivARB", glWeightivARB == NULL);
  glewInfoFunc("glWeightsvARB", glWeightsvARB == NULL);
  glewInfoFunc("glWeightubvARB", glWeightubvARB == NULL);
  glewInfoFunc("glWeightuivARB", glWeightuivARB == NULL);
  glewInfoFunc("glWeightusvARB", glWeightusvARB == NULL);
}

#endif /* GL_ARB_vertex_blend */

/* ---------------------- GL_ARB_vertex_buffer_object ---------------------- */

#ifdef GL_ARB_vertex_buffer_object

static void _glewInfo_GL_ARB_vertex_buffer_object (void)
{
  glewPrintExt("GL_ARB_vertex_buffer_object", GLEW_ARB_vertex_buffer_object, glewGetExtension("GL_ARB_vertex_buffer_object"));

  glewInfoFunc("glBindBufferARB", glBindBufferARB == NULL);
  glewInfoFunc("glBufferDataARB", glBufferDataARB == NULL);
  glewInfoFunc("glBufferSubDataARB", glBufferSubDataARB == NULL);
  glewInfoFunc("glDeleteBuffersARB", glDeleteBuffersARB == NULL);
  glewInfoFunc("glGenBuffersARB", glGenBuffersARB == NULL);
  glewInfoFunc("glGetBufferParameterivARB", glGetBufferParameterivARB == NULL);
  glewInfoFunc("glGetBufferPointervARB", glGetBufferPointervARB == NULL);
  glewInfoFunc("glGetBufferSubDataARB", glGetBufferSubDataARB == NULL);
  glewInfoFunc("glIsBufferARB", glIsBufferARB == NULL);
  glewInfoFunc("glMapBufferARB", glMapBufferARB == NULL);
  glewInfoFunc("glUnmapBufferARB", glUnmapBufferARB == NULL);
}

#endif /* GL_ARB_vertex_buffer_object */

/* ------------------------- GL_ARB_vertex_program ------------------------- */

#ifdef GL_ARB_vertex_program

static void _glewInfo_GL_ARB_vertex_program (void)
{
  glewPrintExt("GL_ARB_vertex_program", GLEW_ARB_vertex_program, glewGetExtension("GL_ARB_vertex_program"));

  glewInfoFunc("glBindProgramARB", glBindProgramARB == NULL);
  glewInfoFunc("glDeleteProgramsARB", glDeleteProgramsARB == NULL);
  glewInfoFunc("glDisableVertexAttribArrayARB", glDisableVertexAttribArrayARB == NULL);
  glewInfoFunc("glEnableVertexAttribArrayARB", glEnableVertexAttribArrayARB == NULL);
  glewInfoFunc("glGenProgramsARB", glGenProgramsARB == NULL);
  glewInfoFunc("glGetProgramEnvParameterdvARB", glGetProgramEnvParameterdvARB == NULL);
  glewInfoFunc("glGetProgramEnvParameterfvARB", glGetProgramEnvParameterfvARB == NULL);
  glewInfoFunc("glGetProgramLocalParameterdvARB", glGetProgramLocalParameterdvARB == NULL);
  glewInfoFunc("glGetProgramLocalParameterfvARB", glGetProgramLocalParameterfvARB == NULL);
  glewInfoFunc("glGetProgramStringARB", glGetProgramStringARB == NULL);
  glewInfoFunc("glGetProgramivARB", glGetProgramivARB == NULL);
  glewInfoFunc("glGetVertexAttribPointervARB", glGetVertexAttribPointervARB == NULL);
  glewInfoFunc("glGetVertexAttribdvARB", glGetVertexAttribdvARB == NULL);
  glewInfoFunc("glGetVertexAttribfvARB", glGetVertexAttribfvARB == NULL);
  glewInfoFunc("glGetVertexAttribivARB", glGetVertexAttribivARB == NULL);
  glewInfoFunc("glIsProgramARB", glIsProgramARB == NULL);
  glewInfoFunc("glProgramEnvParameter4dARB", glProgramEnvParameter4dARB == NULL);
  glewInfoFunc("glProgramEnvParameter4dvARB", glProgramEnvParameter4dvARB == NULL);
  glewInfoFunc("glProgramEnvParameter4fARB", glProgramEnvParameter4fARB == NULL);
  glewInfoFunc("glProgramEnvParameter4fvARB", glProgramEnvParameter4fvARB == NULL);
  glewInfoFunc("glProgramLocalParameter4dARB", glProgramLocalParameter4dARB == NULL);
  glewInfoFunc("glProgramLocalParameter4dvARB", glProgramLocalParameter4dvARB == NULL);
  glewInfoFunc("glProgramLocalParameter4fARB", glProgramLocalParameter4fARB == NULL);
  glewInfoFunc("glProgramLocalParameter4fvARB", glProgramLocalParameter4fvARB == NULL);
  glewInfoFunc("glProgramStringARB", glProgramStringARB == NULL);
  glewInfoFunc("glVertexAttrib1dARB", glVertexAttrib1dARB == NULL);
  glewInfoFunc("glVertexAttrib1dvARB", glVertexAttrib1dvARB == NULL);
  glewInfoFunc("glVertexAttrib1fARB", glVertexAttrib1fARB == NULL);
  glewInfoFunc("glVertexAttrib1fvARB", glVertexAttrib1fvARB == NULL);
  glewInfoFunc("glVertexAttrib1sARB", glVertexAttrib1sARB == NULL);
  glewInfoFunc("glVertexAttrib1svARB", glVertexAttrib1svARB == NULL);
  glewInfoFunc("glVertexAttrib2dARB", glVertexAttrib2dARB == NULL);
  glewInfoFunc("glVertexAttrib2dvARB", glVertexAttrib2dvARB == NULL);
  glewInfoFunc("glVertexAttrib2fARB", glVertexAttrib2fARB == NULL);
  glewInfoFunc("glVertexAttrib2fvARB", glVertexAttrib2fvARB == NULL);
  glewInfoFunc("glVertexAttrib2sARB", glVertexAttrib2sARB == NULL);
  glewInfoFunc("glVertexAttrib2svARB", glVertexAttrib2svARB == NULL);
  glewInfoFunc("glVertexAttrib3dARB", glVertexAttrib3dARB == NULL);
  glewInfoFunc("glVertexAttrib3dvARB", glVertexAttrib3dvARB == NULL);
  glewInfoFunc("glVertexAttrib3fARB", glVertexAttrib3fARB == NULL);
  glewInfoFunc("glVertexAttrib3fvARB", glVertexAttrib3fvARB == NULL);
  glewInfoFunc("glVertexAttrib3sARB", glVertexAttrib3sARB == NULL);
  glewInfoFunc("glVertexAttrib3svARB", glVertexAttrib3svARB == NULL);
  glewInfoFunc("glVertexAttrib4NbvARB", glVertexAttrib4NbvARB == NULL);
  glewInfoFunc("glVertexAttrib4NivARB", glVertexAttrib4NivARB == NULL);
  glewInfoFunc("glVertexAttrib4NsvARB", glVertexAttrib4NsvARB == NULL);
  glewInfoFunc("glVertexAttrib4NubARB", glVertexAttrib4NubARB == NULL);
  glewInfoFunc("glVertexAttrib4NubvARB", glVertexAttrib4NubvARB == NULL);
  glewInfoFunc("glVertexAttrib4NuivARB", glVertexAttrib4NuivARB == NULL);
  glewInfoFunc("glVertexAttrib4NusvARB", glVertexAttrib4NusvARB == NULL);
  glewInfoFunc("glVertexAttrib4bvARB", glVertexAttrib4bvARB == NULL);
  glewInfoFunc("glVertexAttrib4dARB", glVertexAttrib4dARB == NULL);
  glewInfoFunc("glVertexAttrib4dvARB", glVertexAttrib4dvARB == NULL);
  glewInfoFunc("glVertexAttrib4fARB", glVertexAttrib4fARB == NULL);
  glewInfoFunc("glVertexAttrib4fvARB", glVertexAttrib4fvARB == NULL);
  glewInfoFunc("glVertexAttrib4ivARB", glVertexAttrib4ivARB == NULL);
  glewInfoFunc("glVertexAttrib4sARB", glVertexAttrib4sARB == NULL);
  glewInfoFunc("glVertexAttrib4svARB", glVertexAttrib4svARB == NULL);
  glewInfoFunc("glVertexAttrib4ubvARB", glVertexAttrib4ubvARB == NULL);
  glewInfoFunc("glVertexAttrib4uivARB", glVertexAttrib4uivARB == NULL);
  glewInfoFunc("glVertexAttrib4usvARB", glVertexAttrib4usvARB == NULL);
  glewInfoFunc("glVertexAttribPointerARB", glVertexAttribPointerARB == NULL);
}

#endif /* GL_ARB_vertex_program */

/* -------------------------- GL_ARB_vertex_shader ------------------------- */

#ifdef GL_ARB_vertex_shader

static void _glewInfo_GL_ARB_vertex_shader (void)
{
  glewPrintExt("GL_ARB_vertex_shader", GLEW_ARB_vertex_shader, glewGetExtension("GL_ARB_vertex_shader"));

  glewInfoFunc("glBindAttribLocationARB", glBindAttribLocationARB == NULL);
  glewInfoFunc("glGetActiveAttribARB", glGetActiveAttribARB == NULL);
  glewInfoFunc("glGetAttribLocationARB", glGetAttribLocationARB == NULL);
}

#endif /* GL_ARB_vertex_shader */

/* --------------------------- GL_ARB_window_pos --------------------------- */

#ifdef GL_ARB_window_pos

static void _glewInfo_GL_ARB_window_pos (void)
{
  glewPrintExt("GL_ARB_window_pos", GLEW_ARB_window_pos, glewGetExtension("GL_ARB_window_pos"));

  glewInfoFunc("glWindowPos2dARB", glWindowPos2dARB == NULL);
  glewInfoFunc("glWindowPos2dvARB", glWindowPos2dvARB == NULL);
  glewInfoFunc("glWindowPos2fARB", glWindowPos2fARB == NULL);
  glewInfoFunc("glWindowPos2fvARB", glWindowPos2fvARB == NULL);
  glewInfoFunc("glWindowPos2iARB", glWindowPos2iARB == NULL);
  glewInfoFunc("glWindowPos2ivARB", glWindowPos2ivARB == NULL);
  glewInfoFunc("glWindowPos2sARB", glWindowPos2sARB == NULL);
  glewInfoFunc("glWindowPos2svARB", glWindowPos2svARB == NULL);
  glewInfoFunc("glWindowPos3dARB", glWindowPos3dARB == NULL);
  glewInfoFunc("glWindowPos3dvARB", glWindowPos3dvARB == NULL);
  glewInfoFunc("glWindowPos3fARB", glWindowPos3fARB == NULL);
  glewInfoFunc("glWindowPos3fvARB", glWindowPos3fvARB == NULL);
  glewInfoFunc("glWindowPos3iARB", glWindowPos3iARB == NULL);
  glewInfoFunc("glWindowPos3ivARB", glWindowPos3ivARB == NULL);
  glewInfoFunc("glWindowPos3sARB", glWindowPos3sARB == NULL);
  glewInfoFunc("glWindowPos3svARB", glWindowPos3svARB == NULL);
}

#endif /* GL_ARB_window_pos */

/* ------------------------- GL_ATIX_point_sprites ------------------------- */

#ifdef GL_ATIX_point_sprites

static void _glewInfo_GL_ATIX_point_sprites (void)
{
  glewPrintExt("GL_ATIX_point_sprites", GLEW_ATIX_point_sprites, glewGetExtension("GL_ATIX_point_sprites"));
}

#endif /* GL_ATIX_point_sprites */

/* ---------------------- GL_ATIX_texture_env_combine3 --------------------- */

#ifdef GL_ATIX_texture_env_combine3

static void _glewInfo_GL_ATIX_texture_env_combine3 (void)
{
  glewPrintExt("GL_ATIX_texture_env_combine3", GLEW_ATIX_texture_env_combine3, glewGetExtension("GL_ATIX_texture_env_combine3"));
}

#endif /* GL_ATIX_texture_env_combine3 */

/* ----------------------- GL_ATIX_texture_env_route ----------------------- */

#ifdef GL_ATIX_texture_env_route

static void _glewInfo_GL_ATIX_texture_env_route (void)
{
  glewPrintExt("GL_ATIX_texture_env_route", GLEW_ATIX_texture_env_route, glewGetExtension("GL_ATIX_texture_env_route"));
}

#endif /* GL_ATIX_texture_env_route */

/* ---------------- GL_ATIX_vertex_shader_output_point_size ---------------- */

#ifdef GL_ATIX_vertex_shader_output_point_size

static void _glewInfo_GL_ATIX_vertex_shader_output_point_size (void)
{
  glewPrintExt("GL_ATIX_vertex_shader_output_point_size", GLEW_ATIX_vertex_shader_output_point_size, glewGetExtension("GL_ATIX_vertex_shader_output_point_size"));
}

#endif /* GL_ATIX_vertex_shader_output_point_size */

/* -------------------------- GL_ATI_draw_buffers -------------------------- */

#ifdef GL_ATI_draw_buffers

static void _glewInfo_GL_ATI_draw_buffers (void)
{
  glewPrintExt("GL_ATI_draw_buffers", GLEW_ATI_draw_buffers, glewGetExtension("GL_ATI_draw_buffers"));

  glewInfoFunc("glDrawBuffersATI", glDrawBuffersATI == NULL);
}

#endif /* GL_ATI_draw_buffers */

/* -------------------------- GL_ATI_element_array ------------------------- */

#ifdef GL_ATI_element_array

static void _glewInfo_GL_ATI_element_array (void)
{
  glewPrintExt("GL_ATI_element_array", GLEW_ATI_element_array, glewGetExtension("GL_ATI_element_array"));

  glewInfoFunc("glDrawElementArrayATI", glDrawElementArrayATI == NULL);
  glewInfoFunc("glDrawRangeElementArrayATI", glDrawRangeElementArrayATI == NULL);
  glewInfoFunc("glElementPointerATI", glElementPointerATI == NULL);
}

#endif /* GL_ATI_element_array */

/* ------------------------- GL_ATI_envmap_bumpmap ------------------------- */

#ifdef GL_ATI_envmap_bumpmap

static void _glewInfo_GL_ATI_envmap_bumpmap (void)
{
  glewPrintExt("GL_ATI_envmap_bumpmap", GLEW_ATI_envmap_bumpmap, glewGetExtension("GL_ATI_envmap_bumpmap"));

  glewInfoFunc("glGetTexBumpParameterfvATI", glGetTexBumpParameterfvATI == NULL);
  glewInfoFunc("glGetTexBumpParameterivATI", glGetTexBumpParameterivATI == NULL);
  glewInfoFunc("glTexBumpParameterfvATI", glTexBumpParameterfvATI == NULL);
  glewInfoFunc("glTexBumpParameterivATI", glTexBumpParameterivATI == NULL);
}

#endif /* GL_ATI_envmap_bumpmap */

/* ------------------------- GL_ATI_fragment_shader ------------------------ */

#ifdef GL_ATI_fragment_shader

static void _glewInfo_GL_ATI_fragment_shader (void)
{
  glewPrintExt("GL_ATI_fragment_shader", GLEW_ATI_fragment_shader, glewGetExtension("GL_ATI_fragment_shader"));

  glewInfoFunc("glAlphaFragmentOp1ATI", glAlphaFragmentOp1ATI == NULL);
  glewInfoFunc("glAlphaFragmentOp2ATI", glAlphaFragmentOp2ATI == NULL);
  glewInfoFunc("glAlphaFragmentOp3ATI", glAlphaFragmentOp3ATI == NULL);
  glewInfoFunc("glBeginFragmentShaderATI", glBeginFragmentShaderATI == NULL);
  glewInfoFunc("glBindFragmentShaderATI", glBindFragmentShaderATI == NULL);
  glewInfoFunc("glColorFragmentOp1ATI", glColorFragmentOp1ATI == NULL);
  glewInfoFunc("glColorFragmentOp2ATI", glColorFragmentOp2ATI == NULL);
  glewInfoFunc("glColorFragmentOp3ATI", glColorFragmentOp3ATI == NULL);
  glewInfoFunc("glDeleteFragmentShaderATI", glDeleteFragmentShaderATI == NULL);
  glewInfoFunc("glEndFragmentShaderATI", glEndFragmentShaderATI == NULL);
  glewInfoFunc("glGenFragmentShadersATI", glGenFragmentShadersATI == NULL);
  glewInfoFunc("glPassTexCoordATI", glPassTexCoordATI == NULL);
  glewInfoFunc("glSampleMapATI", glSampleMapATI == NULL);
  glewInfoFunc("glSetFragmentShaderConstantATI", glSetFragmentShaderConstantATI == NULL);
}

#endif /* GL_ATI_fragment_shader */

/* ------------------------ GL_ATI_map_object_buffer ----------------------- */

#ifdef GL_ATI_map_object_buffer

static void _glewInfo_GL_ATI_map_object_buffer (void)
{
  glewPrintExt("GL_ATI_map_object_buffer", GLEW_ATI_map_object_buffer, glewGetExtension("GL_ATI_map_object_buffer"));

  glewInfoFunc("glMapObjectBufferATI", glMapObjectBufferATI == NULL);
  glewInfoFunc("glUnmapObjectBufferATI", glUnmapObjectBufferATI == NULL);
}

#endif /* GL_ATI_map_object_buffer */

/* -------------------------- GL_ATI_pn_triangles -------------------------- */

#ifdef GL_ATI_pn_triangles

static void _glewInfo_GL_ATI_pn_triangles (void)
{
  glewPrintExt("GL_ATI_pn_triangles", GLEW_ATI_pn_triangles, glewGetExtension("GL_ATI_pn_triangles"));

  glewInfoFunc("glPNTrianglesfATI", glPNTrianglesfATI == NULL);
  glewInfoFunc("glPNTrianglesiATI", glPNTrianglesiATI == NULL);
}

#endif /* GL_ATI_pn_triangles */

/* ------------------------ GL_ATI_separate_stencil ------------------------ */

#ifdef GL_ATI_separate_stencil

static void _glewInfo_GL_ATI_separate_stencil (void)
{
  glewPrintExt("GL_ATI_separate_stencil", GLEW_ATI_separate_stencil, glewGetExtension("GL_ATI_separate_stencil"));

  glewInfoFunc("glStencilFuncSeparateATI", glStencilFuncSeparateATI == NULL);
  glewInfoFunc("glStencilOpSeparateATI", glStencilOpSeparateATI == NULL);
}

#endif /* GL_ATI_separate_stencil */

/* ---------------------- GL_ATI_text_fragment_shader ---------------------- */

#ifdef GL_ATI_text_fragment_shader

static void _glewInfo_GL_ATI_text_fragment_shader (void)
{
  glewPrintExt("GL_ATI_text_fragment_shader", GLEW_ATI_text_fragment_shader, glewGetExtension("GL_ATI_text_fragment_shader"));
}

#endif /* GL_ATI_text_fragment_shader */

/* ---------------------- GL_ATI_texture_env_combine3 ---------------------- */

#ifdef GL_ATI_texture_env_combine3

static void _glewInfo_GL_ATI_texture_env_combine3 (void)
{
  glewPrintExt("GL_ATI_texture_env_combine3", GLEW_ATI_texture_env_combine3, glewGetExtension("GL_ATI_texture_env_combine3"));
}

#endif /* GL_ATI_texture_env_combine3 */

/* -------------------------- GL_ATI_texture_float ------------------------- */

#ifdef GL_ATI_texture_float

static void _glewInfo_GL_ATI_texture_float (void)
{
  glewPrintExt("GL_ATI_texture_float", GLEW_ATI_texture_float, glewGetExtension("GL_ATI_texture_float"));
}

#endif /* GL_ATI_texture_float */

/* ----------------------- GL_ATI_texture_mirror_once ---------------------- */

#ifdef GL_ATI_texture_mirror_once

static void _glewInfo_GL_ATI_texture_mirror_once (void)
{
  glewPrintExt("GL_ATI_texture_mirror_once", GLEW_ATI_texture_mirror_once, glewGetExtension("GL_ATI_texture_mirror_once"));
}

#endif /* GL_ATI_texture_mirror_once */

/* ----------------------- GL_ATI_vertex_array_object ---------------------- */

#ifdef GL_ATI_vertex_array_object

static void _glewInfo_GL_ATI_vertex_array_object (void)
{
  glewPrintExt("GL_ATI_vertex_array_object", GLEW_ATI_vertex_array_object, glewGetExtension("GL_ATI_vertex_array_object"));

  glewInfoFunc("glArrayObjectATI", glArrayObjectATI == NULL);
  glewInfoFunc("glFreeObjectBufferATI", glFreeObjectBufferATI == NULL);
  glewInfoFunc("glGetArrayObjectfvATI", glGetArrayObjectfvATI == NULL);
  glewInfoFunc("glGetArrayObjectivATI", glGetArrayObjectivATI == NULL);
  glewInfoFunc("glGetObjectBufferfvATI", glGetObjectBufferfvATI == NULL);
  glewInfoFunc("glGetObjectBufferivATI", glGetObjectBufferivATI == NULL);
  glewInfoFunc("glGetVariantArrayObjectfvATI", glGetVariantArrayObjectfvATI == NULL);
  glewInfoFunc("glGetVariantArrayObjectivATI", glGetVariantArrayObjectivATI == NULL);
  glewInfoFunc("glIsObjectBufferATI", glIsObjectBufferATI == NULL);
  glewInfoFunc("glNewObjectBufferATI", glNewObjectBufferATI == NULL);
  glewInfoFunc("glUpdateObjectBufferATI", glUpdateObjectBufferATI == NULL);
  glewInfoFunc("glVariantArrayObjectATI", glVariantArrayObjectATI == NULL);
}

#endif /* GL_ATI_vertex_array_object */

/* ------------------- GL_ATI_vertex_attrib_array_object ------------------- */

#ifdef GL_ATI_vertex_attrib_array_object

static void _glewInfo_GL_ATI_vertex_attrib_array_object (void)
{
  glewPrintExt("GL_ATI_vertex_attrib_array_object", GLEW_ATI_vertex_attrib_array_object, glewGetExtension("GL_ATI_vertex_attrib_array_object"));

  glewInfoFunc("glGetVertexAttribArrayObjectfvATI", glGetVertexAttribArrayObjectfvATI == NULL);
  glewInfoFunc("glGetVertexAttribArrayObjectivATI", glGetVertexAttribArrayObjectivATI == NULL);
  glewInfoFunc("glVertexAttribArrayObjectATI", glVertexAttribArrayObjectATI == NULL);
}

#endif /* GL_ATI_vertex_attrib_array_object */

/* ------------------------- GL_ATI_vertex_streams ------------------------- */

#ifdef GL_ATI_vertex_streams

static void _glewInfo_GL_ATI_vertex_streams (void)
{
  glewPrintExt("GL_ATI_vertex_streams", GLEW_ATI_vertex_streams, glewGetExtension("GL_ATI_vertex_streams"));

  glewInfoFunc("glClientActiveVertexStreamATI", glClientActiveVertexStreamATI == NULL);
  glewInfoFunc("glNormalStream3bATI", glNormalStream3bATI == NULL);
  glewInfoFunc("glNormalStream3bvATI", glNormalStream3bvATI == NULL);
  glewInfoFunc("glNormalStream3dATI", glNormalStream3dATI == NULL);
  glewInfoFunc("glNormalStream3dvATI", glNormalStream3dvATI == NULL);
  glewInfoFunc("glNormalStream3fATI", glNormalStream3fATI == NULL);
  glewInfoFunc("glNormalStream3fvATI", glNormalStream3fvATI == NULL);
  glewInfoFunc("glNormalStream3iATI", glNormalStream3iATI == NULL);
  glewInfoFunc("glNormalStream3ivATI", glNormalStream3ivATI == NULL);
  glewInfoFunc("glNormalStream3sATI", glNormalStream3sATI == NULL);
  glewInfoFunc("glNormalStream3svATI", glNormalStream3svATI == NULL);
  glewInfoFunc("glVertexBlendEnvfATI", glVertexBlendEnvfATI == NULL);
  glewInfoFunc("glVertexBlendEnviATI", glVertexBlendEnviATI == NULL);
  glewInfoFunc("glVertexStream2dATI", glVertexStream2dATI == NULL);
  glewInfoFunc("glVertexStream2dvATI", glVertexStream2dvATI == NULL);
  glewInfoFunc("glVertexStream2fATI", glVertexStream2fATI == NULL);
  glewInfoFunc("glVertexStream2fvATI", glVertexStream2fvATI == NULL);
  glewInfoFunc("glVertexStream2iATI", glVertexStream2iATI == NULL);
  glewInfoFunc("glVertexStream2ivATI", glVertexStream2ivATI == NULL);
  glewInfoFunc("glVertexStream2sATI", glVertexStream2sATI == NULL);
  glewInfoFunc("glVertexStream2svATI", glVertexStream2svATI == NULL);
  glewInfoFunc("glVertexStream3dATI", glVertexStream3dATI == NULL);
  glewInfoFunc("glVertexStream3dvATI", glVertexStream3dvATI == NULL);
  glewInfoFunc("glVertexStream3fATI", glVertexStream3fATI == NULL);
  glewInfoFunc("glVertexStream3fvATI", glVertexStream3fvATI == NULL);
  glewInfoFunc("glVertexStream3iATI", glVertexStream3iATI == NULL);
  glewInfoFunc("glVertexStream3ivATI", glVertexStream3ivATI == NULL);
  glewInfoFunc("glVertexStream3sATI", glVertexStream3sATI == NULL);
  glewInfoFunc("glVertexStream3svATI", glVertexStream3svATI == NULL);
  glewInfoFunc("glVertexStream4dATI", glVertexStream4dATI == NULL);
  glewInfoFunc("glVertexStream4dvATI", glVertexStream4dvATI == NULL);
  glewInfoFunc("glVertexStream4fATI", glVertexStream4fATI == NULL);
  glewInfoFunc("glVertexStream4fvATI", glVertexStream4fvATI == NULL);
  glewInfoFunc("glVertexStream4iATI", glVertexStream4iATI == NULL);
  glewInfoFunc("glVertexStream4ivATI", glVertexStream4ivATI == NULL);
  glewInfoFunc("glVertexStream4sATI", glVertexStream4sATI == NULL);
  glewInfoFunc("glVertexStream4svATI", glVertexStream4svATI == NULL);
}

#endif /* GL_ATI_vertex_streams */

/* --------------------------- GL_EXT_422_pixels --------------------------- */

#ifdef GL_EXT_422_pixels

static void _glewInfo_GL_EXT_422_pixels (void)
{
  glewPrintExt("GL_EXT_422_pixels", GLEW_EXT_422_pixels, glewGetExtension("GL_EXT_422_pixels"));
}

#endif /* GL_EXT_422_pixels */

/* ------------------------------ GL_EXT_abgr ------------------------------ */

#ifdef GL_EXT_abgr

static void _glewInfo_GL_EXT_abgr (void)
{
  glewPrintExt("GL_EXT_abgr", GLEW_EXT_abgr, glewGetExtension("GL_EXT_abgr"));
}

#endif /* GL_EXT_abgr */

/* ------------------------------ GL_EXT_bgra ------------------------------ */

#ifdef GL_EXT_bgra

static void _glewInfo_GL_EXT_bgra (void)
{
  glewPrintExt("GL_EXT_bgra", GLEW_EXT_bgra, glewGetExtension("GL_EXT_bgra"));
}

#endif /* GL_EXT_bgra */

/* --------------------------- GL_EXT_blend_color -------------------------- */

#ifdef GL_EXT_blend_color

static void _glewInfo_GL_EXT_blend_color (void)
{
  glewPrintExt("GL_EXT_blend_color", GLEW_EXT_blend_color, glewGetExtension("GL_EXT_blend_color"));

  glewInfoFunc("glBlendColorEXT", glBlendColorEXT == NULL);
}

#endif /* GL_EXT_blend_color */

/* --------------------- GL_EXT_blend_equation_separate -------------------- */

#ifdef GL_EXT_blend_equation_separate

static void _glewInfo_GL_EXT_blend_equation_separate (void)
{
  glewPrintExt("GL_EXT_blend_equation_separate", GLEW_EXT_blend_equation_separate, glewGetExtension("GL_EXT_blend_equation_separate"));

  glewInfoFunc("glBlendEquationSeparateEXT", glBlendEquationSeparateEXT == NULL);
}

#endif /* GL_EXT_blend_equation_separate */

/* ----------------------- GL_EXT_blend_func_separate ---------------------- */

#ifdef GL_EXT_blend_func_separate

static void _glewInfo_GL_EXT_blend_func_separate (void)
{
  glewPrintExt("GL_EXT_blend_func_separate", GLEW_EXT_blend_func_separate, glewGetExtension("GL_EXT_blend_func_separate"));

  glewInfoFunc("glBlendFuncSeparateEXT", glBlendFuncSeparateEXT == NULL);
}

#endif /* GL_EXT_blend_func_separate */

/* ------------------------- GL_EXT_blend_logic_op ------------------------- */

#ifdef GL_EXT_blend_logic_op

static void _glewInfo_GL_EXT_blend_logic_op (void)
{
  glewPrintExt("GL_EXT_blend_logic_op", GLEW_EXT_blend_logic_op, glewGetExtension("GL_EXT_blend_logic_op"));
}

#endif /* GL_EXT_blend_logic_op */

/* -------------------------- GL_EXT_blend_minmax -------------------------- */

#ifdef GL_EXT_blend_minmax

static void _glewInfo_GL_EXT_blend_minmax (void)
{
  glewPrintExt("GL_EXT_blend_minmax", GLEW_EXT_blend_minmax, glewGetExtension("GL_EXT_blend_minmax"));

  glewInfoFunc("glBlendEquationEXT", glBlendEquationEXT == NULL);
}

#endif /* GL_EXT_blend_minmax */

/* ------------------------- GL_EXT_blend_subtract ------------------------- */

#ifdef GL_EXT_blend_subtract

static void _glewInfo_GL_EXT_blend_subtract (void)
{
  glewPrintExt("GL_EXT_blend_subtract", GLEW_EXT_blend_subtract, glewGetExtension("GL_EXT_blend_subtract"));
}

#endif /* GL_EXT_blend_subtract */

/* ------------------------ GL_EXT_clip_volume_hint ------------------------ */

#ifdef GL_EXT_clip_volume_hint

static void _glewInfo_GL_EXT_clip_volume_hint (void)
{
  glewPrintExt("GL_EXT_clip_volume_hint", GLEW_EXT_clip_volume_hint, glewGetExtension("GL_EXT_clip_volume_hint"));
}

#endif /* GL_EXT_clip_volume_hint */

/* ------------------------------ GL_EXT_cmyka ----------------------------- */

#ifdef GL_EXT_cmyka

static void _glewInfo_GL_EXT_cmyka (void)
{
  glewPrintExt("GL_EXT_cmyka", GLEW_EXT_cmyka, glewGetExtension("GL_EXT_cmyka"));
}

#endif /* GL_EXT_cmyka */

/* ------------------------- GL_EXT_color_subtable ------------------------- */

#ifdef GL_EXT_color_subtable

static void _glewInfo_GL_EXT_color_subtable (void)
{
  glewPrintExt("GL_EXT_color_subtable", GLEW_EXT_color_subtable, glewGetExtension("GL_EXT_color_subtable"));

  glewInfoFunc("glColorSubTableEXT", glColorSubTableEXT == NULL);
  glewInfoFunc("glCopyColorSubTableEXT", glCopyColorSubTableEXT == NULL);
}

#endif /* GL_EXT_color_subtable */

/* ---------------------- GL_EXT_compiled_vertex_array --------------------- */

#ifdef GL_EXT_compiled_vertex_array

static void _glewInfo_GL_EXT_compiled_vertex_array (void)
{
  glewPrintExt("GL_EXT_compiled_vertex_array", GLEW_EXT_compiled_vertex_array, glewGetExtension("GL_EXT_compiled_vertex_array"));

  glewInfoFunc("glLockArraysEXT", glLockArraysEXT == NULL);
  glewInfoFunc("glUnlockArraysEXT", glUnlockArraysEXT == NULL);
}

#endif /* GL_EXT_compiled_vertex_array */

/* --------------------------- GL_EXT_convolution -------------------------- */

#ifdef GL_EXT_convolution

static void _glewInfo_GL_EXT_convolution (void)
{
  glewPrintExt("GL_EXT_convolution", GLEW_EXT_convolution, glewGetExtension("GL_EXT_convolution"));

  glewInfoFunc("glConvolutionFilter1DEXT", glConvolutionFilter1DEXT == NULL);
  glewInfoFunc("glConvolutionFilter2DEXT", glConvolutionFilter2DEXT == NULL);
  glewInfoFunc("glConvolutionParameterfEXT", glConvolutionParameterfEXT == NULL);
  glewInfoFunc("glConvolutionParameterfvEXT", glConvolutionParameterfvEXT == NULL);
  glewInfoFunc("glConvolutionParameteriEXT", glConvolutionParameteriEXT == NULL);
  glewInfoFunc("glConvolutionParameterivEXT", glConvolutionParameterivEXT == NULL);
  glewInfoFunc("glCopyConvolutionFilter1DEXT", glCopyConvolutionFilter1DEXT == NULL);
  glewInfoFunc("glCopyConvolutionFilter2DEXT", glCopyConvolutionFilter2DEXT == NULL);
  glewInfoFunc("glGetConvolutionFilterEXT", glGetConvolutionFilterEXT == NULL);
  glewInfoFunc("glGetConvolutionParameterfvEXT", glGetConvolutionParameterfvEXT == NULL);
  glewInfoFunc("glGetConvolutionParameterivEXT", glGetConvolutionParameterivEXT == NULL);
  glewInfoFunc("glGetSeparableFilterEXT", glGetSeparableFilterEXT == NULL);
  glewInfoFunc("glSeparableFilter2DEXT", glSeparableFilter2DEXT == NULL);
}

#endif /* GL_EXT_convolution */

/* ------------------------ GL_EXT_coordinate_frame ------------------------ */

#ifdef GL_EXT_coordinate_frame

static void _glewInfo_GL_EXT_coordinate_frame (void)
{
  glewPrintExt("GL_EXT_coordinate_frame", GLEW_EXT_coordinate_frame, glewGetExtension("GL_EXT_coordinate_frame"));

  glewInfoFunc("glBinormalPointerEXT", glBinormalPointerEXT == NULL);
  glewInfoFunc("glTangentPointerEXT", glTangentPointerEXT == NULL);
}

#endif /* GL_EXT_coordinate_frame */

/* -------------------------- GL_EXT_copy_texture -------------------------- */

#ifdef GL_EXT_copy_texture

static void _glewInfo_GL_EXT_copy_texture (void)
{
  glewPrintExt("GL_EXT_copy_texture", GLEW_EXT_copy_texture, glewGetExtension("GL_EXT_copy_texture"));

  glewInfoFunc("glCopyTexImage1DEXT", glCopyTexImage1DEXT == NULL);
  glewInfoFunc("glCopyTexImage2DEXT", glCopyTexImage2DEXT == NULL);
  glewInfoFunc("glCopyTexSubImage1DEXT", glCopyTexSubImage1DEXT == NULL);
  glewInfoFunc("glCopyTexSubImage2DEXT", glCopyTexSubImage2DEXT == NULL);
  glewInfoFunc("glCopyTexSubImage3DEXT", glCopyTexSubImage3DEXT == NULL);
}

#endif /* GL_EXT_copy_texture */

/* --------------------------- GL_EXT_cull_vertex -------------------------- */

#ifdef GL_EXT_cull_vertex

static void _glewInfo_GL_EXT_cull_vertex (void)
{
  glewPrintExt("GL_EXT_cull_vertex", GLEW_EXT_cull_vertex, glewGetExtension("GL_EXT_cull_vertex"));

  glewInfoFunc("glCullParameterdvEXT", glCullParameterdvEXT == NULL);
  glewInfoFunc("glCullParameterfvEXT", glCullParameterfvEXT == NULL);
}

#endif /* GL_EXT_cull_vertex */

/* ------------------------ GL_EXT_depth_bounds_test ----------------------- */

#ifdef GL_EXT_depth_bounds_test

static void _glewInfo_GL_EXT_depth_bounds_test (void)
{
  glewPrintExt("GL_EXT_depth_bounds_test", GLEW_EXT_depth_bounds_test, glewGetExtension("GL_EXT_depth_bounds_test"));

  glewInfoFunc("glDepthBoundsEXT", glDepthBoundsEXT == NULL);
}

#endif /* GL_EXT_depth_bounds_test */

/* ----------------------- GL_EXT_draw_range_elements ---------------------- */

#ifdef GL_EXT_draw_range_elements

static void _glewInfo_GL_EXT_draw_range_elements (void)
{
  glewPrintExt("GL_EXT_draw_range_elements", GLEW_EXT_draw_range_elements, glewGetExtension("GL_EXT_draw_range_elements"));
}

#endif /* GL_EXT_draw_range_elements */

/* ---------------------------- GL_EXT_fog_coord --------------------------- */

#ifdef GL_EXT_fog_coord

static void _glewInfo_GL_EXT_fog_coord (void)
{
  glewPrintExt("GL_EXT_fog_coord", GLEW_EXT_fog_coord, glewGetExtension("GL_EXT_fog_coord"));

  glewInfoFunc("glFogCoordPointerEXT", glFogCoordPointerEXT == NULL);
  glewInfoFunc("glFogCoorddEXT", glFogCoorddEXT == NULL);
  glewInfoFunc("glFogCoorddvEXT", glFogCoorddvEXT == NULL);
  glewInfoFunc("glFogCoordfEXT", glFogCoordfEXT == NULL);
  glewInfoFunc("glFogCoordfvEXT", glFogCoordfvEXT == NULL);
}

#endif /* GL_EXT_fog_coord */

/* ------------------------ GL_EXT_fragment_lighting ----------------------- */

#ifdef GL_EXT_fragment_lighting

static void _glewInfo_GL_EXT_fragment_lighting (void)
{
  glewPrintExt("GL_EXT_fragment_lighting", GLEW_EXT_fragment_lighting, glewGetExtension("GL_EXT_fragment_lighting"));

  glewInfoFunc("glFragmentColorMaterialEXT", glFragmentColorMaterialEXT == NULL);
  glewInfoFunc("glFragmentLightModelfEXT", glFragmentLightModelfEXT == NULL);
  glewInfoFunc("glFragmentLightModelfvEXT", glFragmentLightModelfvEXT == NULL);
  glewInfoFunc("glFragmentLightModeliEXT", glFragmentLightModeliEXT == NULL);
  glewInfoFunc("glFragmentLightModelivEXT", glFragmentLightModelivEXT == NULL);
  glewInfoFunc("glFragmentLightfEXT", glFragmentLightfEXT == NULL);
  glewInfoFunc("glFragmentLightfvEXT", glFragmentLightfvEXT == NULL);
  glewInfoFunc("glFragmentLightiEXT", glFragmentLightiEXT == NULL);
  glewInfoFunc("glFragmentLightivEXT", glFragmentLightivEXT == NULL);
  glewInfoFunc("glFragmentMaterialfEXT", glFragmentMaterialfEXT == NULL);
  glewInfoFunc("glFragmentMaterialfvEXT", glFragmentMaterialfvEXT == NULL);
  glewInfoFunc("glFragmentMaterialiEXT", glFragmentMaterialiEXT == NULL);
  glewInfoFunc("glFragmentMaterialivEXT", glFragmentMaterialivEXT == NULL);
  glewInfoFunc("glGetFragmentLightfvEXT", glGetFragmentLightfvEXT == NULL);
  glewInfoFunc("glGetFragmentLightivEXT", glGetFragmentLightivEXT == NULL);
  glewInfoFunc("glGetFragmentMaterialfvEXT", glGetFragmentMaterialfvEXT == NULL);
  glewInfoFunc("glGetFragmentMaterialivEXT", glGetFragmentMaterialivEXT == NULL);
  glewInfoFunc("glLightEnviEXT", glLightEnviEXT == NULL);
}

#endif /* GL_EXT_fragment_lighting */

/* ---------------------------- GL_EXT_histogram --------------------------- */

#ifdef GL_EXT_histogram

static void _glewInfo_GL_EXT_histogram (void)
{
  glewPrintExt("GL_EXT_histogram", GLEW_EXT_histogram, glewGetExtension("GL_EXT_histogram"));

  glewInfoFunc("glGetHistogramEXT", glGetHistogramEXT == NULL);
  glewInfoFunc("glGetHistogramParameterfvEXT", glGetHistogramParameterfvEXT == NULL);
  glewInfoFunc("glGetHistogramParameterivEXT", glGetHistogramParameterivEXT == NULL);
  glewInfoFunc("glGetMinmaxEXT", glGetMinmaxEXT == NULL);
  glewInfoFunc("glGetMinmaxParameterfvEXT", glGetMinmaxParameterfvEXT == NULL);
  glewInfoFunc("glGetMinmaxParameterivEXT", glGetMinmaxParameterivEXT == NULL);
  glewInfoFunc("glHistogramEXT", glHistogramEXT == NULL);
  glewInfoFunc("glMinmaxEXT", glMinmaxEXT == NULL);
  glewInfoFunc("glResetHistogramEXT", glResetHistogramEXT == NULL);
  glewInfoFunc("glResetMinmaxEXT", glResetMinmaxEXT == NULL);
}

#endif /* GL_EXT_histogram */

/* ----------------------- GL_EXT_index_array_formats ---------------------- */

#ifdef GL_EXT_index_array_formats

static void _glewInfo_GL_EXT_index_array_formats (void)
{
  glewPrintExt("GL_EXT_index_array_formats", GLEW_EXT_index_array_formats, glewGetExtension("GL_EXT_index_array_formats"));
}

#endif /* GL_EXT_index_array_formats */

/* --------------------------- GL_EXT_index_func --------------------------- */

#ifdef GL_EXT_index_func

static void _glewInfo_GL_EXT_index_func (void)
{
  glewPrintExt("GL_EXT_index_func", GLEW_EXT_index_func, glewGetExtension("GL_EXT_index_func"));

  glewInfoFunc("glIndexFuncEXT", glIndexFuncEXT == NULL);
}

#endif /* GL_EXT_index_func */

/* ------------------------- GL_EXT_index_material ------------------------- */

#ifdef GL_EXT_index_material

static void _glewInfo_GL_EXT_index_material (void)
{
  glewPrintExt("GL_EXT_index_material", GLEW_EXT_index_material, glewGetExtension("GL_EXT_index_material"));

  glewInfoFunc("glIndexMaterialEXT", glIndexMaterialEXT == NULL);
}

#endif /* GL_EXT_index_material */

/* -------------------------- GL_EXT_index_texture ------------------------- */

#ifdef GL_EXT_index_texture

static void _glewInfo_GL_EXT_index_texture (void)
{
  glewPrintExt("GL_EXT_index_texture", GLEW_EXT_index_texture, glewGetExtension("GL_EXT_index_texture"));
}

#endif /* GL_EXT_index_texture */

/* -------------------------- GL_EXT_light_texture ------------------------- */

#ifdef GL_EXT_light_texture

static void _glewInfo_GL_EXT_light_texture (void)
{
  glewPrintExt("GL_EXT_light_texture", GLEW_EXT_light_texture, glewGetExtension("GL_EXT_light_texture"));

  glewInfoFunc("glApplyTextureEXT", glApplyTextureEXT == NULL);
  glewInfoFunc("glTextureLightEXT", glTextureLightEXT == NULL);
  glewInfoFunc("glTextureMaterialEXT", glTextureMaterialEXT == NULL);
}

#endif /* GL_EXT_light_texture */

/* ------------------------- GL_EXT_misc_attribute ------------------------- */

#ifdef GL_EXT_misc_attribute

static void _glewInfo_GL_EXT_misc_attribute (void)
{
  glewPrintExt("GL_EXT_misc_attribute", GLEW_EXT_misc_attribute, glewGetExtension("GL_EXT_misc_attribute"));
}

#endif /* GL_EXT_misc_attribute */

/* ------------------------ GL_EXT_multi_draw_arrays ----------------------- */

#ifdef GL_EXT_multi_draw_arrays

static void _glewInfo_GL_EXT_multi_draw_arrays (void)
{
  glewPrintExt("GL_EXT_multi_draw_arrays", GLEW_EXT_multi_draw_arrays, glewGetExtension("GL_EXT_multi_draw_arrays"));

  glewInfoFunc("glMultiDrawArraysEXT", glMultiDrawArraysEXT == NULL);
  glewInfoFunc("glMultiDrawElementsEXT", glMultiDrawElementsEXT == NULL);
}

#endif /* GL_EXT_multi_draw_arrays */

/* --------------------------- GL_EXT_multisample -------------------------- */

#ifdef GL_EXT_multisample

static void _glewInfo_GL_EXT_multisample (void)
{
  glewPrintExt("GL_EXT_multisample", GLEW_EXT_multisample, glewGetExtension("GL_EXT_multisample"));

  glewInfoFunc("glSampleMaskEXT", glSampleMaskEXT == NULL);
  glewInfoFunc("glSamplePatternEXT", glSamplePatternEXT == NULL);
}

#endif /* GL_EXT_multisample */

/* -------------------------- GL_EXT_packed_pixels ------------------------- */

#ifdef GL_EXT_packed_pixels

static void _glewInfo_GL_EXT_packed_pixels (void)
{
  glewPrintExt("GL_EXT_packed_pixels", GLEW_EXT_packed_pixels, glewGetExtension("GL_EXT_packed_pixels"));
}

#endif /* GL_EXT_packed_pixels */

/* ------------------------ GL_EXT_paletted_texture ------------------------ */

#ifdef GL_EXT_paletted_texture

static void _glewInfo_GL_EXT_paletted_texture (void)
{
  glewPrintExt("GL_EXT_paletted_texture", GLEW_EXT_paletted_texture, glewGetExtension("GL_EXT_paletted_texture"));

  glewInfoFunc("glColorTableEXT", glColorTableEXT == NULL);
  glewInfoFunc("glGetColorTableEXT", glGetColorTableEXT == NULL);
  glewInfoFunc("glGetColorTableParameterfvEXT", glGetColorTableParameterfvEXT == NULL);
  glewInfoFunc("glGetColorTableParameterivEXT", glGetColorTableParameterivEXT == NULL);
}

#endif /* GL_EXT_paletted_texture */

/* ----------------------- GL_EXT_pixel_buffer_object ---------------------- */

#ifdef GL_EXT_pixel_buffer_object

static void _glewInfo_GL_EXT_pixel_buffer_object (void)
{
  glewPrintExt("GL_EXT_pixel_buffer_object", GLEW_EXT_pixel_buffer_object, glewGetExtension("GL_EXT_pixel_buffer_object"));
}

#endif /* GL_EXT_pixel_buffer_object */

/* ------------------------- GL_EXT_pixel_transform ------------------------ */

#ifdef GL_EXT_pixel_transform

static void _glewInfo_GL_EXT_pixel_transform (void)
{
  glewPrintExt("GL_EXT_pixel_transform", GLEW_EXT_pixel_transform, glewGetExtension("GL_EXT_pixel_transform"));

  glewInfoFunc("glGetPixelTransformParameterfvEXT", glGetPixelTransformParameterfvEXT == NULL);
  glewInfoFunc("glGetPixelTransformParameterivEXT", glGetPixelTransformParameterivEXT == NULL);
  glewInfoFunc("glPixelTransformParameterfEXT", glPixelTransformParameterfEXT == NULL);
  glewInfoFunc("glPixelTransformParameterfvEXT", glPixelTransformParameterfvEXT == NULL);
  glewInfoFunc("glPixelTransformParameteriEXT", glPixelTransformParameteriEXT == NULL);
  glewInfoFunc("glPixelTransformParameterivEXT", glPixelTransformParameterivEXT == NULL);
}

#endif /* GL_EXT_pixel_transform */

/* ------------------- GL_EXT_pixel_transform_color_table ------------------ */

#ifdef GL_EXT_pixel_transform_color_table

static void _glewInfo_GL_EXT_pixel_transform_color_table (void)
{
  glewPrintExt("GL_EXT_pixel_transform_color_table", GLEW_EXT_pixel_transform_color_table, glewGetExtension("GL_EXT_pixel_transform_color_table"));
}

#endif /* GL_EXT_pixel_transform_color_table */

/* ------------------------ GL_EXT_point_parameters ------------------------ */

#ifdef GL_EXT_point_parameters

static void _glewInfo_GL_EXT_point_parameters (void)
{
  glewPrintExt("GL_EXT_point_parameters", GLEW_EXT_point_parameters, glewGetExtension("GL_EXT_point_parameters"));

  glewInfoFunc("glPointParameterfEXT", glPointParameterfEXT == NULL);
  glewInfoFunc("glPointParameterfvEXT", glPointParameterfvEXT == NULL);
}

#endif /* GL_EXT_point_parameters */

/* ------------------------- GL_EXT_polygon_offset ------------------------- */

#ifdef GL_EXT_polygon_offset

static void _glewInfo_GL_EXT_polygon_offset (void)
{
  glewPrintExt("GL_EXT_polygon_offset", GLEW_EXT_polygon_offset, glewGetExtension("GL_EXT_polygon_offset"));

  glewInfoFunc("glPolygonOffsetEXT", glPolygonOffsetEXT == NULL);
}

#endif /* GL_EXT_polygon_offset */

/* ------------------------- GL_EXT_rescale_normal ------------------------- */

#ifdef GL_EXT_rescale_normal

static void _glewInfo_GL_EXT_rescale_normal (void)
{
  glewPrintExt("GL_EXT_rescale_normal", GLEW_EXT_rescale_normal, glewGetExtension("GL_EXT_rescale_normal"));
}

#endif /* GL_EXT_rescale_normal */

/* -------------------------- GL_EXT_scene_marker -------------------------- */

#ifdef GL_EXT_scene_marker

static void _glewInfo_GL_EXT_scene_marker (void)
{
  glewPrintExt("GL_EXT_scene_marker", GLEW_EXT_scene_marker, glewGetExtension("GL_EXT_scene_marker"));

  glewInfoFunc("glBeginSceneEXT", glBeginSceneEXT == NULL);
  glewInfoFunc("glEndSceneEXT", glEndSceneEXT == NULL);
}

#endif /* GL_EXT_scene_marker */

/* ------------------------- GL_EXT_secondary_color ------------------------ */

#ifdef GL_EXT_secondary_color

static void _glewInfo_GL_EXT_secondary_color (void)
{
  glewPrintExt("GL_EXT_secondary_color", GLEW_EXT_secondary_color, glewGetExtension("GL_EXT_secondary_color"));

  glewInfoFunc("glSecondaryColor3bEXT", glSecondaryColor3bEXT == NULL);
  glewInfoFunc("glSecondaryColor3bvEXT", glSecondaryColor3bvEXT == NULL);
  glewInfoFunc("glSecondaryColor3dEXT", glSecondaryColor3dEXT == NULL);
  glewInfoFunc("glSecondaryColor3dvEXT", glSecondaryColor3dvEXT == NULL);
  glewInfoFunc("glSecondaryColor3fEXT", glSecondaryColor3fEXT == NULL);
  glewInfoFunc("glSecondaryColor3fvEXT", glSecondaryColor3fvEXT == NULL);
  glewInfoFunc("glSecondaryColor3iEXT", glSecondaryColor3iEXT == NULL);
  glewInfoFunc("glSecondaryColor3ivEXT", glSecondaryColor3ivEXT == NULL);
  glewInfoFunc("glSecondaryColor3sEXT", glSecondaryColor3sEXT == NULL);
  glewInfoFunc("glSecondaryColor3svEXT", glSecondaryColor3svEXT == NULL);
  glewInfoFunc("glSecondaryColor3ubEXT", glSecondaryColor3ubEXT == NULL);
  glewInfoFunc("glSecondaryColor3ubvEXT", glSecondaryColor3ubvEXT == NULL);
  glewInfoFunc("glSecondaryColor3uiEXT", glSecondaryColor3uiEXT == NULL);
  glewInfoFunc("glSecondaryColor3uivEXT", glSecondaryColor3uivEXT == NULL);
  glewInfoFunc("glSecondaryColor3usEXT", glSecondaryColor3usEXT == NULL);
  glewInfoFunc("glSecondaryColor3usvEXT", glSecondaryColor3usvEXT == NULL);
  glewInfoFunc("glSecondaryColorPointerEXT", glSecondaryColorPointerEXT == NULL);
}

#endif /* GL_EXT_secondary_color */

/* --------------------- GL_EXT_separate_specular_color -------------------- */

#ifdef GL_EXT_separate_specular_color

static void _glewInfo_GL_EXT_separate_specular_color (void)
{
  glewPrintExt("GL_EXT_separate_specular_color", GLEW_EXT_separate_specular_color, glewGetExtension("GL_EXT_separate_specular_color"));
}

#endif /* GL_EXT_separate_specular_color */

/* -------------------------- GL_EXT_shadow_funcs -------------------------- */

#ifdef GL_EXT_shadow_funcs

static void _glewInfo_GL_EXT_shadow_funcs (void)
{
  glewPrintExt("GL_EXT_shadow_funcs", GLEW_EXT_shadow_funcs, glewGetExtension("GL_EXT_shadow_funcs"));
}

#endif /* GL_EXT_shadow_funcs */

/* --------------------- GL_EXT_shared_texture_palette --------------------- */

#ifdef GL_EXT_shared_texture_palette

static void _glewInfo_GL_EXT_shared_texture_palette (void)
{
  glewPrintExt("GL_EXT_shared_texture_palette", GLEW_EXT_shared_texture_palette, glewGetExtension("GL_EXT_shared_texture_palette"));
}

#endif /* GL_EXT_shared_texture_palette */

/* ------------------------ GL_EXT_stencil_two_side ------------------------ */

#ifdef GL_EXT_stencil_two_side

static void _glewInfo_GL_EXT_stencil_two_side (void)
{
  glewPrintExt("GL_EXT_stencil_two_side", GLEW_EXT_stencil_two_side, glewGetExtension("GL_EXT_stencil_two_side"));

  glewInfoFunc("glActiveStencilFaceEXT", glActiveStencilFaceEXT == NULL);
}

#endif /* GL_EXT_stencil_two_side */

/* -------------------------- GL_EXT_stencil_wrap -------------------------- */

#ifdef GL_EXT_stencil_wrap

static void _glewInfo_GL_EXT_stencil_wrap (void)
{
  glewPrintExt("GL_EXT_stencil_wrap", GLEW_EXT_stencil_wrap, glewGetExtension("GL_EXT_stencil_wrap"));
}

#endif /* GL_EXT_stencil_wrap */

/* --------------------------- GL_EXT_subtexture --------------------------- */

#ifdef GL_EXT_subtexture

static void _glewInfo_GL_EXT_subtexture (void)
{
  glewPrintExt("GL_EXT_subtexture", GLEW_EXT_subtexture, glewGetExtension("GL_EXT_subtexture"));

  glewInfoFunc("glTexSubImage1DEXT", glTexSubImage1DEXT == NULL);
  glewInfoFunc("glTexSubImage2DEXT", glTexSubImage2DEXT == NULL);
  glewInfoFunc("glTexSubImage3DEXT", glTexSubImage3DEXT == NULL);
}

#endif /* GL_EXT_subtexture */

/* ----------------------------- GL_EXT_texture ---------------------------- */

#ifdef GL_EXT_texture

static void _glewInfo_GL_EXT_texture (void)
{
  glewPrintExt("GL_EXT_texture", GLEW_EXT_texture, glewGetExtension("GL_EXT_texture"));
}

#endif /* GL_EXT_texture */

/* ---------------------------- GL_EXT_texture3D --------------------------- */

#ifdef GL_EXT_texture3D

static void _glewInfo_GL_EXT_texture3D (void)
{
  glewPrintExt("GL_EXT_texture3D", GLEW_EXT_texture3D, glewGetExtension("GL_EXT_texture3D"));

  glewInfoFunc("glTexImage3DEXT", glTexImage3DEXT == NULL);
}

#endif /* GL_EXT_texture3D */

/* -------------------- GL_EXT_texture_compression_s3tc -------------------- */

#ifdef GL_EXT_texture_compression_s3tc

static void _glewInfo_GL_EXT_texture_compression_s3tc (void)
{
  glewPrintExt("GL_EXT_texture_compression_s3tc", GLEW_EXT_texture_compression_s3tc, glewGetExtension("GL_EXT_texture_compression_s3tc"));
}

#endif /* GL_EXT_texture_compression_s3tc */

/* ------------------------ GL_EXT_texture_cube_map ------------------------ */

#ifdef GL_EXT_texture_cube_map

static void _glewInfo_GL_EXT_texture_cube_map (void)
{
  glewPrintExt("GL_EXT_texture_cube_map", GLEW_EXT_texture_cube_map, glewGetExtension("GL_EXT_texture_cube_map"));
}

#endif /* GL_EXT_texture_cube_map */

/* ----------------------- GL_EXT_texture_edge_clamp ----------------------- */

#ifdef GL_EXT_texture_edge_clamp

static void _glewInfo_GL_EXT_texture_edge_clamp (void)
{
  glewPrintExt("GL_EXT_texture_edge_clamp", GLEW_EXT_texture_edge_clamp, glewGetExtension("GL_EXT_texture_edge_clamp"));
}

#endif /* GL_EXT_texture_edge_clamp */

/* --------------------------- GL_EXT_texture_env -------------------------- */

#ifdef GL_EXT_texture_env

static void _glewInfo_GL_EXT_texture_env (void)
{
  glewPrintExt("GL_EXT_texture_env", GLEW_EXT_texture_env, glewGetExtension("GL_EXT_texture_env"));
}

#endif /* GL_EXT_texture_env */

/* ------------------------- GL_EXT_texture_env_add ------------------------ */

#ifdef GL_EXT_texture_env_add

static void _glewInfo_GL_EXT_texture_env_add (void)
{
  glewPrintExt("GL_EXT_texture_env_add", GLEW_EXT_texture_env_add, glewGetExtension("GL_EXT_texture_env_add"));
}

#endif /* GL_EXT_texture_env_add */

/* ----------------------- GL_EXT_texture_env_combine ---------------------- */

#ifdef GL_EXT_texture_env_combine

static void _glewInfo_GL_EXT_texture_env_combine (void)
{
  glewPrintExt("GL_EXT_texture_env_combine", GLEW_EXT_texture_env_combine, glewGetExtension("GL_EXT_texture_env_combine"));
}

#endif /* GL_EXT_texture_env_combine */

/* ------------------------ GL_EXT_texture_env_dot3 ------------------------ */

#ifdef GL_EXT_texture_env_dot3

static void _glewInfo_GL_EXT_texture_env_dot3 (void)
{
  glewPrintExt("GL_EXT_texture_env_dot3", GLEW_EXT_texture_env_dot3, glewGetExtension("GL_EXT_texture_env_dot3"));
}

#endif /* GL_EXT_texture_env_dot3 */

/* ------------------- GL_EXT_texture_filter_anisotropic ------------------- */

#ifdef GL_EXT_texture_filter_anisotropic

static void _glewInfo_GL_EXT_texture_filter_anisotropic (void)
{
  glewPrintExt("GL_EXT_texture_filter_anisotropic", GLEW_EXT_texture_filter_anisotropic, glewGetExtension("GL_EXT_texture_filter_anisotropic"));
}

#endif /* GL_EXT_texture_filter_anisotropic */

/* ------------------------ GL_EXT_texture_lod_bias ------------------------ */

#ifdef GL_EXT_texture_lod_bias

static void _glewInfo_GL_EXT_texture_lod_bias (void)
{
  glewPrintExt("GL_EXT_texture_lod_bias", GLEW_EXT_texture_lod_bias, glewGetExtension("GL_EXT_texture_lod_bias"));
}

#endif /* GL_EXT_texture_lod_bias */

/* ---------------------- GL_EXT_texture_mirror_clamp ---------------------- */

#ifdef GL_EXT_texture_mirror_clamp

static void _glewInfo_GL_EXT_texture_mirror_clamp (void)
{
  glewPrintExt("GL_EXT_texture_mirror_clamp", GLEW_EXT_texture_mirror_clamp, glewGetExtension("GL_EXT_texture_mirror_clamp"));
}

#endif /* GL_EXT_texture_mirror_clamp */

/* ------------------------- GL_EXT_texture_object ------------------------- */

#ifdef GL_EXT_texture_object

static void _glewInfo_GL_EXT_texture_object (void)
{
  glewPrintExt("GL_EXT_texture_object", GLEW_EXT_texture_object, glewGetExtension("GL_EXT_texture_object"));

  glewInfoFunc("glAreTexturesResidentEXT", glAreTexturesResidentEXT == NULL);
  glewInfoFunc("glBindTextureEXT", glBindTextureEXT == NULL);
  glewInfoFunc("glDeleteTexturesEXT", glDeleteTexturesEXT == NULL);
  glewInfoFunc("glGenTexturesEXT", glGenTexturesEXT == NULL);
  glewInfoFunc("glIsTextureEXT", glIsTextureEXT == NULL);
  glewInfoFunc("glPrioritizeTexturesEXT", glPrioritizeTexturesEXT == NULL);
}

#endif /* GL_EXT_texture_object */

/* --------------------- GL_EXT_texture_perturb_normal --------------------- */

#ifdef GL_EXT_texture_perturb_normal

static void _glewInfo_GL_EXT_texture_perturb_normal (void)
{
  glewPrintExt("GL_EXT_texture_perturb_normal", GLEW_EXT_texture_perturb_normal, glewGetExtension("GL_EXT_texture_perturb_normal"));

  glewInfoFunc("glTextureNormalEXT", glTextureNormalEXT == NULL);
}

#endif /* GL_EXT_texture_perturb_normal */

/* ------------------------ GL_EXT_texture_rectangle ----------------------- */

#ifdef GL_EXT_texture_rectangle

static void _glewInfo_GL_EXT_texture_rectangle (void)
{
  glewPrintExt("GL_EXT_texture_rectangle", GLEW_EXT_texture_rectangle, glewGetExtension("GL_EXT_texture_rectangle"));
}

#endif /* GL_EXT_texture_rectangle */

/* -------------------------- GL_EXT_vertex_array -------------------------- */

#ifdef GL_EXT_vertex_array

static void _glewInfo_GL_EXT_vertex_array (void)
{
  glewPrintExt("GL_EXT_vertex_array", GLEW_EXT_vertex_array, glewGetExtension("GL_EXT_vertex_array"));

  glewInfoFunc("glArrayElementEXT", glArrayElementEXT == NULL);
  glewInfoFunc("glColorPointerEXT", glColorPointerEXT == NULL);
  glewInfoFunc("glDrawArraysEXT", glDrawArraysEXT == NULL);
  glewInfoFunc("glEdgeFlagPointerEXT", glEdgeFlagPointerEXT == NULL);
  glewInfoFunc("glGetPointervEXT", glGetPointervEXT == NULL);
  glewInfoFunc("glIndexPointerEXT", glIndexPointerEXT == NULL);
  glewInfoFunc("glNormalPointerEXT", glNormalPointerEXT == NULL);
  glewInfoFunc("glTexCoordPointerEXT", glTexCoordPointerEXT == NULL);
  glewInfoFunc("glVertexPointerEXT", glVertexPointerEXT == NULL);
}

#endif /* GL_EXT_vertex_array */

/* -------------------------- GL_EXT_vertex_shader ------------------------- */

#ifdef GL_EXT_vertex_shader

static void _glewInfo_GL_EXT_vertex_shader (void)
{
  glewPrintExt("GL_EXT_vertex_shader", GLEW_EXT_vertex_shader, glewGetExtension("GL_EXT_vertex_shader"));

  glewInfoFunc("glBeginVertexShaderEXT", glBeginVertexShaderEXT == NULL);
  glewInfoFunc("glBindLightParameterEXT", glBindLightParameterEXT == NULL);
  glewInfoFunc("glBindMaterialParameterEXT", glBindMaterialParameterEXT == NULL);
  glewInfoFunc("glBindParameterEXT", glBindParameterEXT == NULL);
  glewInfoFunc("glBindTexGenParameterEXT", glBindTexGenParameterEXT == NULL);
  glewInfoFunc("glBindTextureUnitParameterEXT", glBindTextureUnitParameterEXT == NULL);
  glewInfoFunc("glBindVertexShaderEXT", glBindVertexShaderEXT == NULL);
  glewInfoFunc("glDeleteVertexShaderEXT", glDeleteVertexShaderEXT == NULL);
  glewInfoFunc("glDisableVariantClientStateEXT", glDisableVariantClientStateEXT == NULL);
  glewInfoFunc("glEnableVariantClientStateEXT", glEnableVariantClientStateEXT == NULL);
  glewInfoFunc("glEndVertexShaderEXT", glEndVertexShaderEXT == NULL);
  glewInfoFunc("glExtractComponentEXT", glExtractComponentEXT == NULL);
  glewInfoFunc("glGenSymbolsEXT", glGenSymbolsEXT == NULL);
  glewInfoFunc("glGenVertexShadersEXT", glGenVertexShadersEXT == NULL);
  glewInfoFunc("glGetInvariantBooleanvEXT", glGetInvariantBooleanvEXT == NULL);
  glewInfoFunc("glGetInvariantFloatvEXT", glGetInvariantFloatvEXT == NULL);
  glewInfoFunc("glGetInvariantIntegervEXT", glGetInvariantIntegervEXT == NULL);
  glewInfoFunc("glGetLocalConstantBooleanvEXT", glGetLocalConstantBooleanvEXT == NULL);
  glewInfoFunc("glGetLocalConstantFloatvEXT", glGetLocalConstantFloatvEXT == NULL);
  glewInfoFunc("glGetLocalConstantIntegervEXT", glGetLocalConstantIntegervEXT == NULL);
  glewInfoFunc("glGetVariantBooleanvEXT", glGetVariantBooleanvEXT == NULL);
  glewInfoFunc("glGetVariantFloatvEXT", glGetVariantFloatvEXT == NULL);
  glewInfoFunc("glGetVariantIntegervEXT", glGetVariantIntegervEXT == NULL);
  glewInfoFunc("glGetVariantPointervEXT", glGetVariantPointervEXT == NULL);
  glewInfoFunc("glInsertComponentEXT", glInsertComponentEXT == NULL);
  glewInfoFunc("glIsVariantEnabledEXT", glIsVariantEnabledEXT == NULL);
  glewInfoFunc("glSetInvariantEXT", glSetInvariantEXT == NULL);
  glewInfoFunc("glSetLocalConstantEXT", glSetLocalConstantEXT == NULL);
  glewInfoFunc("glShaderOp1EXT", glShaderOp1EXT == NULL);
  glewInfoFunc("glShaderOp2EXT", glShaderOp2EXT == NULL);
  glewInfoFunc("glShaderOp3EXT", glShaderOp3EXT == NULL);
  glewInfoFunc("glSwizzleEXT", glSwizzleEXT == NULL);
  glewInfoFunc("glVariantPointerEXT", glVariantPointerEXT == NULL);
  glewInfoFunc("glVariantbvEXT", glVariantbvEXT == NULL);
  glewInfoFunc("glVariantdvEXT", glVariantdvEXT == NULL);
  glewInfoFunc("glVariantfvEXT", glVariantfvEXT == NULL);
  glewInfoFunc("glVariantivEXT", glVariantivEXT == NULL);
  glewInfoFunc("glVariantsvEXT", glVariantsvEXT == NULL);
  glewInfoFunc("glVariantubvEXT", glVariantubvEXT == NULL);
  glewInfoFunc("glVariantuivEXT", glVariantuivEXT == NULL);
  glewInfoFunc("glVariantusvEXT", glVariantusvEXT == NULL);
  glewInfoFunc("glWriteMaskEXT", glWriteMaskEXT == NULL);
}

#endif /* GL_EXT_vertex_shader */

/* ------------------------ GL_EXT_vertex_weighting ------------------------ */

#ifdef GL_EXT_vertex_weighting

static void _glewInfo_GL_EXT_vertex_weighting (void)
{
  glewPrintExt("GL_EXT_vertex_weighting", GLEW_EXT_vertex_weighting, glewGetExtension("GL_EXT_vertex_weighting"));

  glewInfoFunc("glVertexWeightPointerEXT", glVertexWeightPointerEXT == NULL);
  glewInfoFunc("glVertexWeightfEXT", glVertexWeightfEXT == NULL);
  glewInfoFunc("glVertexWeightfvEXT", glVertexWeightfvEXT == NULL);
}

#endif /* GL_EXT_vertex_weighting */

/* --------------------- GL_HP_convolution_border_modes -------------------- */

#ifdef GL_HP_convolution_border_modes

static void _glewInfo_GL_HP_convolution_border_modes (void)
{
  glewPrintExt("GL_HP_convolution_border_modes", GLEW_HP_convolution_border_modes, glewGetExtension("GL_HP_convolution_border_modes"));
}

#endif /* GL_HP_convolution_border_modes */

/* ------------------------- GL_HP_image_transform ------------------------- */

#ifdef GL_HP_image_transform

static void _glewInfo_GL_HP_image_transform (void)
{
  glewPrintExt("GL_HP_image_transform", GLEW_HP_image_transform, glewGetExtension("GL_HP_image_transform"));

  glewInfoFunc("glGetImageTransformParameterfvHP", glGetImageTransformParameterfvHP == NULL);
  glewInfoFunc("glGetImageTransformParameterivHP", glGetImageTransformParameterivHP == NULL);
  glewInfoFunc("glImageTransformParameterfHP", glImageTransformParameterfHP == NULL);
  glewInfoFunc("glImageTransformParameterfvHP", glImageTransformParameterfvHP == NULL);
  glewInfoFunc("glImageTransformParameteriHP", glImageTransformParameteriHP == NULL);
  glewInfoFunc("glImageTransformParameterivHP", glImageTransformParameterivHP == NULL);
}

#endif /* GL_HP_image_transform */

/* -------------------------- GL_HP_occlusion_test ------------------------- */

#ifdef GL_HP_occlusion_test

static void _glewInfo_GL_HP_occlusion_test (void)
{
  glewPrintExt("GL_HP_occlusion_test", GLEW_HP_occlusion_test, glewGetExtension("GL_HP_occlusion_test"));
}

#endif /* GL_HP_occlusion_test */

/* ------------------------- GL_HP_texture_lighting ------------------------ */

#ifdef GL_HP_texture_lighting

static void _glewInfo_GL_HP_texture_lighting (void)
{
  glewPrintExt("GL_HP_texture_lighting", GLEW_HP_texture_lighting, glewGetExtension("GL_HP_texture_lighting"));
}

#endif /* GL_HP_texture_lighting */

/* --------------------------- GL_IBM_cull_vertex -------------------------- */

#ifdef GL_IBM_cull_vertex

static void _glewInfo_GL_IBM_cull_vertex (void)
{
  glewPrintExt("GL_IBM_cull_vertex", GLEW_IBM_cull_vertex, glewGetExtension("GL_IBM_cull_vertex"));
}

#endif /* GL_IBM_cull_vertex */

/* ---------------------- GL_IBM_multimode_draw_arrays --------------------- */

#ifdef GL_IBM_multimode_draw_arrays

static void _glewInfo_GL_IBM_multimode_draw_arrays (void)
{
  glewPrintExt("GL_IBM_multimode_draw_arrays", GLEW_IBM_multimode_draw_arrays, glewGetExtension("GL_IBM_multimode_draw_arrays"));

  glewInfoFunc("glMultiModeDrawArraysIBM", glMultiModeDrawArraysIBM == NULL);
  glewInfoFunc("glMultiModeDrawElementsIBM", glMultiModeDrawElementsIBM == NULL);
}

#endif /* GL_IBM_multimode_draw_arrays */

/* ------------------------- GL_IBM_rasterpos_clip ------------------------- */

#ifdef GL_IBM_rasterpos_clip

static void _glewInfo_GL_IBM_rasterpos_clip (void)
{
  glewPrintExt("GL_IBM_rasterpos_clip", GLEW_IBM_rasterpos_clip, glewGetExtension("GL_IBM_rasterpos_clip"));
}

#endif /* GL_IBM_rasterpos_clip */

/* --------------------------- GL_IBM_static_data -------------------------- */

#ifdef GL_IBM_static_data

static void _glewInfo_GL_IBM_static_data (void)
{
  glewPrintExt("GL_IBM_static_data", GLEW_IBM_static_data, glewGetExtension("GL_IBM_static_data"));
}

#endif /* GL_IBM_static_data */

/* --------------------- GL_IBM_texture_mirrored_repeat -------------------- */

#ifdef GL_IBM_texture_mirrored_repeat

static void _glewInfo_GL_IBM_texture_mirrored_repeat (void)
{
  glewPrintExt("GL_IBM_texture_mirrored_repeat", GLEW_IBM_texture_mirrored_repeat, glewGetExtension("GL_IBM_texture_mirrored_repeat"));
}

#endif /* GL_IBM_texture_mirrored_repeat */

/* ----------------------- GL_IBM_vertex_array_lists ----------------------- */

#ifdef GL_IBM_vertex_array_lists

static void _glewInfo_GL_IBM_vertex_array_lists (void)
{
  glewPrintExt("GL_IBM_vertex_array_lists", GLEW_IBM_vertex_array_lists, glewGetExtension("GL_IBM_vertex_array_lists"));

  glewInfoFunc("glColorPointerListIBM", glColorPointerListIBM == NULL);
  glewInfoFunc("glEdgeFlagPointerListIBM", glEdgeFlagPointerListIBM == NULL);
  glewInfoFunc("glFogCoordPointerListIBM", glFogCoordPointerListIBM == NULL);
  glewInfoFunc("glIndexPointerListIBM", glIndexPointerListIBM == NULL);
  glewInfoFunc("glNormalPointerListIBM", glNormalPointerListIBM == NULL);
  glewInfoFunc("glSecondaryColorPointerListIBM", glSecondaryColorPointerListIBM == NULL);
  glewInfoFunc("glTexCoordPointerListIBM", glTexCoordPointerListIBM == NULL);
  glewInfoFunc("glVertexPointerListIBM", glVertexPointerListIBM == NULL);
}

#endif /* GL_IBM_vertex_array_lists */

/* -------------------------- GL_INGR_color_clamp -------------------------- */

#ifdef GL_INGR_color_clamp

static void _glewInfo_GL_INGR_color_clamp (void)
{
  glewPrintExt("GL_INGR_color_clamp", GLEW_INGR_color_clamp, glewGetExtension("GL_INGR_color_clamp"));
}

#endif /* GL_INGR_color_clamp */

/* ------------------------- GL_INGR_interlace_read ------------------------ */

#ifdef GL_INGR_interlace_read

static void _glewInfo_GL_INGR_interlace_read (void)
{
  glewPrintExt("GL_INGR_interlace_read", GLEW_INGR_interlace_read, glewGetExtension("GL_INGR_interlace_read"));
}

#endif /* GL_INGR_interlace_read */

/* ------------------------ GL_INTEL_parallel_arrays ----------------------- */

#ifdef GL_INTEL_parallel_arrays

static void _glewInfo_GL_INTEL_parallel_arrays (void)
{
  glewPrintExt("GL_INTEL_parallel_arrays", GLEW_INTEL_parallel_arrays, glewGetExtension("GL_INTEL_parallel_arrays"));

  glewInfoFunc("glColorPointervINTEL", glColorPointervINTEL == NULL);
  glewInfoFunc("glNormalPointervINTEL", glNormalPointervINTEL == NULL);
  glewInfoFunc("glTexCoordPointervINTEL", glTexCoordPointervINTEL == NULL);
  glewInfoFunc("glVertexPointervINTEL", glVertexPointervINTEL == NULL);
}

#endif /* GL_INTEL_parallel_arrays */

/* ------------------------ GL_INTEL_texture_scissor ----------------------- */

#ifdef GL_INTEL_texture_scissor

static void _glewInfo_GL_INTEL_texture_scissor (void)
{
  glewPrintExt("GL_INTEL_texture_scissor", GLEW_INTEL_texture_scissor, glewGetExtension("GL_INTEL_texture_scissor"));

  glewInfoFunc("glTexScissorFuncINTEL", glTexScissorFuncINTEL == NULL);
  glewInfoFunc("glTexScissorINTEL", glTexScissorINTEL == NULL);
}

#endif /* GL_INTEL_texture_scissor */

/* -------------------------- GL_MESA_pack_invert -------------------------- */

#ifdef GL_MESA_pack_invert

static void _glewInfo_GL_MESA_pack_invert (void)
{
  glewPrintExt("GL_MESA_pack_invert", GLEW_MESA_pack_invert, glewGetExtension("GL_MESA_pack_invert"));
}

#endif /* GL_MESA_pack_invert */

/* ------------------------- GL_MESA_resize_buffers ------------------------ */

#ifdef GL_MESA_resize_buffers

static void _glewInfo_GL_MESA_resize_buffers (void)
{
  glewPrintExt("GL_MESA_resize_buffers", GLEW_MESA_resize_buffers, glewGetExtension("GL_MESA_resize_buffers"));

  glewInfoFunc("glResizeBuffersMESA", glResizeBuffersMESA == NULL);
}

#endif /* GL_MESA_resize_buffers */

/* --------------------------- GL_MESA_window_pos -------------------------- */

#ifdef GL_MESA_window_pos

static void _glewInfo_GL_MESA_window_pos (void)
{
  glewPrintExt("GL_MESA_window_pos", GLEW_MESA_window_pos, glewGetExtension("GL_MESA_window_pos"));

  glewInfoFunc("glWindowPos2dMESA", glWindowPos2dMESA == NULL);
  glewInfoFunc("glWindowPos2dvMESA", glWindowPos2dvMESA == NULL);
  glewInfoFunc("glWindowPos2fMESA", glWindowPos2fMESA == NULL);
  glewInfoFunc("glWindowPos2fvMESA", glWindowPos2fvMESA == NULL);
  glewInfoFunc("glWindowPos2iMESA", glWindowPos2iMESA == NULL);
  glewInfoFunc("glWindowPos2ivMESA", glWindowPos2ivMESA == NULL);
  glewInfoFunc("glWindowPos2sMESA", glWindowPos2sMESA == NULL);
  glewInfoFunc("glWindowPos2svMESA", glWindowPos2svMESA == NULL);
  glewInfoFunc("glWindowPos3dMESA", glWindowPos3dMESA == NULL);
  glewInfoFunc("glWindowPos3dvMESA", glWindowPos3dvMESA == NULL);
  glewInfoFunc("glWindowPos3fMESA", glWindowPos3fMESA == NULL);
  glewInfoFunc("glWindowPos3fvMESA", glWindowPos3fvMESA == NULL);
  glewInfoFunc("glWindowPos3iMESA", glWindowPos3iMESA == NULL);
  glewInfoFunc("glWindowPos3ivMESA", glWindowPos3ivMESA == NULL);
  glewInfoFunc("glWindowPos3sMESA", glWindowPos3sMESA == NULL);
  glewInfoFunc("glWindowPos3svMESA", glWindowPos3svMESA == NULL);
  glewInfoFunc("glWindowPos4dMESA", glWindowPos4dMESA == NULL);
  glewInfoFunc("glWindowPos4dvMESA", glWindowPos4dvMESA == NULL);
  glewInfoFunc("glWindowPos4fMESA", glWindowPos4fMESA == NULL);
  glewInfoFunc("glWindowPos4fvMESA", glWindowPos4fvMESA == NULL);
  glewInfoFunc("glWindowPos4iMESA", glWindowPos4iMESA == NULL);
  glewInfoFunc("glWindowPos4ivMESA", glWindowPos4ivMESA == NULL);
  glewInfoFunc("glWindowPos4sMESA", glWindowPos4sMESA == NULL);
  glewInfoFunc("glWindowPos4svMESA", glWindowPos4svMESA == NULL);
}

#endif /* GL_MESA_window_pos */

/* ------------------------- GL_MESA_ycbcr_texture ------------------------- */

#ifdef GL_MESA_ycbcr_texture

static void _glewInfo_GL_MESA_ycbcr_texture (void)
{
  glewPrintExt("GL_MESA_ycbcr_texture", GLEW_MESA_ycbcr_texture, glewGetExtension("GL_MESA_ycbcr_texture"));
}

#endif /* GL_MESA_ycbcr_texture */

/* --------------------------- GL_NV_blend_square -------------------------- */

#ifdef GL_NV_blend_square

static void _glewInfo_GL_NV_blend_square (void)
{
  glewPrintExt("GL_NV_blend_square", GLEW_NV_blend_square, glewGetExtension("GL_NV_blend_square"));
}

#endif /* GL_NV_blend_square */

/* ----------------------- GL_NV_copy_depth_to_color ----------------------- */

#ifdef GL_NV_copy_depth_to_color

static void _glewInfo_GL_NV_copy_depth_to_color (void)
{
  glewPrintExt("GL_NV_copy_depth_to_color", GLEW_NV_copy_depth_to_color, glewGetExtension("GL_NV_copy_depth_to_color"));
}

#endif /* GL_NV_copy_depth_to_color */

/* --------------------------- GL_NV_depth_clamp --------------------------- */

#ifdef GL_NV_depth_clamp

static void _glewInfo_GL_NV_depth_clamp (void)
{
  glewPrintExt("GL_NV_depth_clamp", GLEW_NV_depth_clamp, glewGetExtension("GL_NV_depth_clamp"));
}

#endif /* GL_NV_depth_clamp */

/* ---------------------------- GL_NV_evaluators --------------------------- */

#ifdef GL_NV_evaluators

static void _glewInfo_GL_NV_evaluators (void)
{
  glewPrintExt("GL_NV_evaluators", GLEW_NV_evaluators, glewGetExtension("GL_NV_evaluators"));

  glewInfoFunc("glEvalMapsNV", glEvalMapsNV == NULL);
  glewInfoFunc("glGetMapAttribParameterfvNV", glGetMapAttribParameterfvNV == NULL);
  glewInfoFunc("glGetMapAttribParameterivNV", glGetMapAttribParameterivNV == NULL);
  glewInfoFunc("glGetMapControlPointsNV", glGetMapControlPointsNV == NULL);
  glewInfoFunc("glGetMapParameterfvNV", glGetMapParameterfvNV == NULL);
  glewInfoFunc("glGetMapParameterivNV", glGetMapParameterivNV == NULL);
  glewInfoFunc("glMapControlPointsNV", glMapControlPointsNV == NULL);
  glewInfoFunc("glMapParameterfvNV", glMapParameterfvNV == NULL);
  glewInfoFunc("glMapParameterivNV", glMapParameterivNV == NULL);
}

#endif /* GL_NV_evaluators */

/* ------------------------------ GL_NV_fence ------------------------------ */

#ifdef GL_NV_fence

static void _glewInfo_GL_NV_fence (void)
{
  glewPrintExt("GL_NV_fence", GLEW_NV_fence, glewGetExtension("GL_NV_fence"));

  glewInfoFunc("glDeleteFencesNV", glDeleteFencesNV == NULL);
  glewInfoFunc("glFinishFenceNV", glFinishFenceNV == NULL);
  glewInfoFunc("glGenFencesNV", glGenFencesNV == NULL);
  glewInfoFunc("glGetFenceivNV", glGetFenceivNV == NULL);
  glewInfoFunc("glIsFenceNV", glIsFenceNV == NULL);
  glewInfoFunc("glSetFenceNV", glSetFenceNV == NULL);
  glewInfoFunc("glTestFenceNV", glTestFenceNV == NULL);
}

#endif /* GL_NV_fence */

/* --------------------------- GL_NV_float_buffer -------------------------- */

#ifdef GL_NV_float_buffer

static void _glewInfo_GL_NV_float_buffer (void)
{
  glewPrintExt("GL_NV_float_buffer", GLEW_NV_float_buffer, glewGetExtension("GL_NV_float_buffer"));
}

#endif /* GL_NV_float_buffer */

/* --------------------------- GL_NV_fog_distance -------------------------- */

#ifdef GL_NV_fog_distance

static void _glewInfo_GL_NV_fog_distance (void)
{
  glewPrintExt("GL_NV_fog_distance", GLEW_NV_fog_distance, glewGetExtension("GL_NV_fog_distance"));
}

#endif /* GL_NV_fog_distance */

/* ------------------------- GL_NV_fragment_program ------------------------ */

#ifdef GL_NV_fragment_program

static void _glewInfo_GL_NV_fragment_program (void)
{
  glewPrintExt("GL_NV_fragment_program", GLEW_NV_fragment_program, glewGetExtension("GL_NV_fragment_program"));

  glewInfoFunc("glGetProgramNamedParameterdvNV", glGetProgramNamedParameterdvNV == NULL);
  glewInfoFunc("glGetProgramNamedParameterfvNV", glGetProgramNamedParameterfvNV == NULL);
  glewInfoFunc("glProgramNamedParameter4dNV", glProgramNamedParameter4dNV == NULL);
  glewInfoFunc("glProgramNamedParameter4dvNV", glProgramNamedParameter4dvNV == NULL);
  glewInfoFunc("glProgramNamedParameter4fNV", glProgramNamedParameter4fNV == NULL);
  glewInfoFunc("glProgramNamedParameter4fvNV", glProgramNamedParameter4fvNV == NULL);
}

#endif /* GL_NV_fragment_program */

/* ------------------------ GL_NV_fragment_program2 ------------------------ */

#ifdef GL_NV_fragment_program2

static void _glewInfo_GL_NV_fragment_program2 (void)
{
  glewPrintExt("GL_NV_fragment_program2", GLEW_NV_fragment_program2, glewGetExtension("GL_NV_fragment_program2"));
}

#endif /* GL_NV_fragment_program2 */

/* --------------------- GL_NV_fragment_program_option --------------------- */

#ifdef GL_NV_fragment_program_option

static void _glewInfo_GL_NV_fragment_program_option (void)
{
  glewPrintExt("GL_NV_fragment_program_option", GLEW_NV_fragment_program_option, glewGetExtension("GL_NV_fragment_program_option"));
}

#endif /* GL_NV_fragment_program_option */

/* ---------------------------- GL_NV_half_float --------------------------- */

#ifdef GL_NV_half_float

static void _glewInfo_GL_NV_half_float (void)
{
  glewPrintExt("GL_NV_half_float", GLEW_NV_half_float, glewGetExtension("GL_NV_half_float"));

  glewInfoFunc("glColor3hNV", glColor3hNV == NULL);
  glewInfoFunc("glColor3hvNV", glColor3hvNV == NULL);
  glewInfoFunc("glColor4hNV", glColor4hNV == NULL);
  glewInfoFunc("glColor4hvNV", glColor4hvNV == NULL);
  glewInfoFunc("glFogCoordhNV", glFogCoordhNV == NULL);
  glewInfoFunc("glFogCoordhvNV", glFogCoordhvNV == NULL);
  glewInfoFunc("glMultiTexCoord1hNV", glMultiTexCoord1hNV == NULL);
  glewInfoFunc("glMultiTexCoord1hvNV", glMultiTexCoord1hvNV == NULL);
  glewInfoFunc("glMultiTexCoord2hNV", glMultiTexCoord2hNV == NULL);
  glewInfoFunc("glMultiTexCoord2hvNV", glMultiTexCoord2hvNV == NULL);
  glewInfoFunc("glMultiTexCoord3hNV", glMultiTexCoord3hNV == NULL);
  glewInfoFunc("glMultiTexCoord3hvNV", glMultiTexCoord3hvNV == NULL);
  glewInfoFunc("glMultiTexCoord4hNV", glMultiTexCoord4hNV == NULL);
  glewInfoFunc("glMultiTexCoord4hvNV", glMultiTexCoord4hvNV == NULL);
  glewInfoFunc("glNormal3hNV", glNormal3hNV == NULL);
  glewInfoFunc("glNormal3hvNV", glNormal3hvNV == NULL);
  glewInfoFunc("glSecondaryColor3hNV", glSecondaryColor3hNV == NULL);
  glewInfoFunc("glSecondaryColor3hvNV", glSecondaryColor3hvNV == NULL);
  glewInfoFunc("glTexCoord1hNV", glTexCoord1hNV == NULL);
  glewInfoFunc("glTexCoord1hvNV", glTexCoord1hvNV == NULL);
  glewInfoFunc("glTexCoord2hNV", glTexCoord2hNV == NULL);
  glewInfoFunc("glTexCoord2hvNV", glTexCoord2hvNV == NULL);
  glewInfoFunc("glTexCoord3hNV", glTexCoord3hNV == NULL);
  glewInfoFunc("glTexCoord3hvNV", glTexCoord3hvNV == NULL);
  glewInfoFunc("glTexCoord4hNV", glTexCoord4hNV == NULL);
  glewInfoFunc("glTexCoord4hvNV", glTexCoord4hvNV == NULL);
  glewInfoFunc("glVertex2hNV", glVertex2hNV == NULL);
  glewInfoFunc("glVertex2hvNV", glVertex2hvNV == NULL);
  glewInfoFunc("glVertex3hNV", glVertex3hNV == NULL);
  glewInfoFunc("glVertex3hvNV", glVertex3hvNV == NULL);
  glewInfoFunc("glVertex4hNV", glVertex4hNV == NULL);
  glewInfoFunc("glVertex4hvNV", glVertex4hvNV == NULL);
  glewInfoFunc("glVertexAttrib1hNV", glVertexAttrib1hNV == NULL);
  glewInfoFunc("glVertexAttrib1hvNV", glVertexAttrib1hvNV == NULL);
  glewInfoFunc("glVertexAttrib2hNV", glVertexAttrib2hNV == NULL);
  glewInfoFunc("glVertexAttrib2hvNV", glVertexAttrib2hvNV == NULL);
  glewInfoFunc("glVertexAttrib3hNV", glVertexAttrib3hNV == NULL);
  glewInfoFunc("glVertexAttrib3hvNV", glVertexAttrib3hvNV == NULL);
  glewInfoFunc("glVertexAttrib4hNV", glVertexAttrib4hNV == NULL);
  glewInfoFunc("glVertexAttrib4hvNV", glVertexAttrib4hvNV == NULL);
  glewInfoFunc("glVertexAttribs1hvNV", glVertexAttribs1hvNV == NULL);
  glewInfoFunc("glVertexAttribs2hvNV", glVertexAttribs2hvNV == NULL);
  glewInfoFunc("glVertexAttribs3hvNV", glVertexAttribs3hvNV == NULL);
  glewInfoFunc("glVertexAttribs4hvNV", glVertexAttribs4hvNV == NULL);
  glewInfoFunc("glVertexWeighthNV", glVertexWeighthNV == NULL);
  glewInfoFunc("glVertexWeighthvNV", glVertexWeighthvNV == NULL);
}

#endif /* GL_NV_half_float */

/* ------------------------ GL_NV_light_max_exponent ----------------------- */

#ifdef GL_NV_light_max_exponent

static void _glewInfo_GL_NV_light_max_exponent (void)
{
  glewPrintExt("GL_NV_light_max_exponent", GLEW_NV_light_max_exponent, glewGetExtension("GL_NV_light_max_exponent"));
}

#endif /* GL_NV_light_max_exponent */

/* --------------------- GL_NV_multisample_filter_hint --------------------- */

#ifdef GL_NV_multisample_filter_hint

static void _glewInfo_GL_NV_multisample_filter_hint (void)
{
  glewPrintExt("GL_NV_multisample_filter_hint", GLEW_NV_multisample_filter_hint, glewGetExtension("GL_NV_multisample_filter_hint"));
}

#endif /* GL_NV_multisample_filter_hint */

/* ------------------------- GL_NV_occlusion_query ------------------------- */

#ifdef GL_NV_occlusion_query

static void _glewInfo_GL_NV_occlusion_query (void)
{
  glewPrintExt("GL_NV_occlusion_query", GLEW_NV_occlusion_query, glewGetExtension("GL_NV_occlusion_query"));

  glewInfoFunc("glBeginOcclusionQueryNV", glBeginOcclusionQueryNV == NULL);
  glewInfoFunc("glDeleteOcclusionQueriesNV", glDeleteOcclusionQueriesNV == NULL);
  glewInfoFunc("glEndOcclusionQueryNV", glEndOcclusionQueryNV == NULL);
  glewInfoFunc("glGenOcclusionQueriesNV", glGenOcclusionQueriesNV == NULL);
  glewInfoFunc("glGetOcclusionQueryivNV", glGetOcclusionQueryivNV == NULL);
  glewInfoFunc("glGetOcclusionQueryuivNV", glGetOcclusionQueryuivNV == NULL);
  glewInfoFunc("glIsOcclusionQueryNV", glIsOcclusionQueryNV == NULL);
}

#endif /* GL_NV_occlusion_query */

/* ----------------------- GL_NV_packed_depth_stencil ---------------------- */

#ifdef GL_NV_packed_depth_stencil

static void _glewInfo_GL_NV_packed_depth_stencil (void)
{
  glewPrintExt("GL_NV_packed_depth_stencil", GLEW_NV_packed_depth_stencil, glewGetExtension("GL_NV_packed_depth_stencil"));
}

#endif /* GL_NV_packed_depth_stencil */

/* ------------------------- GL_NV_pixel_data_range ------------------------ */

#ifdef GL_NV_pixel_data_range

static void _glewInfo_GL_NV_pixel_data_range (void)
{
  glewPrintExt("GL_NV_pixel_data_range", GLEW_NV_pixel_data_range, glewGetExtension("GL_NV_pixel_data_range"));

  glewInfoFunc("glFlushPixelDataRangeNV", glFlushPixelDataRangeNV == NULL);
  glewInfoFunc("glPixelDataRangeNV", glPixelDataRangeNV == NULL);
}

#endif /* GL_NV_pixel_data_range */

/* --------------------------- GL_NV_point_sprite -------------------------- */

#ifdef GL_NV_point_sprite

static void _glewInfo_GL_NV_point_sprite (void)
{
  glewPrintExt("GL_NV_point_sprite", GLEW_NV_point_sprite, glewGetExtension("GL_NV_point_sprite"));

  glewInfoFunc("glPointParameteriNV", glPointParameteriNV == NULL);
  glewInfoFunc("glPointParameterivNV", glPointParameterivNV == NULL);
}

#endif /* GL_NV_point_sprite */

/* ------------------------ GL_NV_primitive_restart ------------------------ */

#ifdef GL_NV_primitive_restart

static void _glewInfo_GL_NV_primitive_restart (void)
{
  glewPrintExt("GL_NV_primitive_restart", GLEW_NV_primitive_restart, glewGetExtension("GL_NV_primitive_restart"));

  glewInfoFunc("glPrimitiveRestartIndexNV", glPrimitiveRestartIndexNV == NULL);
  glewInfoFunc("glPrimitiveRestartNV", glPrimitiveRestartNV == NULL);
}

#endif /* GL_NV_primitive_restart */

/* ------------------------ GL_NV_register_combiners ----------------------- */

#ifdef GL_NV_register_combiners

static void _glewInfo_GL_NV_register_combiners (void)
{
  glewPrintExt("GL_NV_register_combiners", GLEW_NV_register_combiners, glewGetExtension("GL_NV_register_combiners"));

  glewInfoFunc("glCombinerInputNV", glCombinerInputNV == NULL);
  glewInfoFunc("glCombinerOutputNV", glCombinerOutputNV == NULL);
  glewInfoFunc("glCombinerParameterfNV", glCombinerParameterfNV == NULL);
  glewInfoFunc("glCombinerParameterfvNV", glCombinerParameterfvNV == NULL);
  glewInfoFunc("glCombinerParameteriNV", glCombinerParameteriNV == NULL);
  glewInfoFunc("glCombinerParameterivNV", glCombinerParameterivNV == NULL);
  glewInfoFunc("glFinalCombinerInputNV", glFinalCombinerInputNV == NULL);
  glewInfoFunc("glGetCombinerInputParameterfvNV", glGetCombinerInputParameterfvNV == NULL);
  glewInfoFunc("glGetCombinerInputParameterivNV", glGetCombinerInputParameterivNV == NULL);
  glewInfoFunc("glGetCombinerOutputParameterfvNV", glGetCombinerOutputParameterfvNV == NULL);
  glewInfoFunc("glGetCombinerOutputParameterivNV", glGetCombinerOutputParameterivNV == NULL);
  glewInfoFunc("glGetFinalCombinerInputParameterfvNV", glGetFinalCombinerInputParameterfvNV == NULL);
  glewInfoFunc("glGetFinalCombinerInputParameterivNV", glGetFinalCombinerInputParameterivNV == NULL);
}

#endif /* GL_NV_register_combiners */

/* ----------------------- GL_NV_register_combiners2 ----------------------- */

#ifdef GL_NV_register_combiners2

static void _glewInfo_GL_NV_register_combiners2 (void)
{
  glewPrintExt("GL_NV_register_combiners2", GLEW_NV_register_combiners2, glewGetExtension("GL_NV_register_combiners2"));

  glewInfoFunc("glCombinerStageParameterfvNV", glCombinerStageParameterfvNV == NULL);
  glewInfoFunc("glGetCombinerStageParameterfvNV", glGetCombinerStageParameterfvNV == NULL);
}

#endif /* GL_NV_register_combiners2 */

/* -------------------------- GL_NV_texgen_emboss -------------------------- */

#ifdef GL_NV_texgen_emboss

static void _glewInfo_GL_NV_texgen_emboss (void)
{
  glewPrintExt("GL_NV_texgen_emboss", GLEW_NV_texgen_emboss, glewGetExtension("GL_NV_texgen_emboss"));
}

#endif /* GL_NV_texgen_emboss */

/* ------------------------ GL_NV_texgen_reflection ------------------------ */

#ifdef GL_NV_texgen_reflection

static void _glewInfo_GL_NV_texgen_reflection (void)
{
  glewPrintExt("GL_NV_texgen_reflection", GLEW_NV_texgen_reflection, glewGetExtension("GL_NV_texgen_reflection"));
}

#endif /* GL_NV_texgen_reflection */

/* --------------------- GL_NV_texture_compression_vtc --------------------- */

#ifdef GL_NV_texture_compression_vtc

static void _glewInfo_GL_NV_texture_compression_vtc (void)
{
  glewPrintExt("GL_NV_texture_compression_vtc", GLEW_NV_texture_compression_vtc, glewGetExtension("GL_NV_texture_compression_vtc"));
}

#endif /* GL_NV_texture_compression_vtc */

/* ----------------------- GL_NV_texture_env_combine4 ---------------------- */

#ifdef GL_NV_texture_env_combine4

static void _glewInfo_GL_NV_texture_env_combine4 (void)
{
  glewPrintExt("GL_NV_texture_env_combine4", GLEW_NV_texture_env_combine4, glewGetExtension("GL_NV_texture_env_combine4"));
}

#endif /* GL_NV_texture_env_combine4 */

/* ---------------------- GL_NV_texture_expand_normal ---------------------- */

#ifdef GL_NV_texture_expand_normal

static void _glewInfo_GL_NV_texture_expand_normal (void)
{
  glewPrintExt("GL_NV_texture_expand_normal", GLEW_NV_texture_expand_normal, glewGetExtension("GL_NV_texture_expand_normal"));
}

#endif /* GL_NV_texture_expand_normal */

/* ------------------------ GL_NV_texture_rectangle ------------------------ */

#ifdef GL_NV_texture_rectangle

static void _glewInfo_GL_NV_texture_rectangle (void)
{
  glewPrintExt("GL_NV_texture_rectangle", GLEW_NV_texture_rectangle, glewGetExtension("GL_NV_texture_rectangle"));
}

#endif /* GL_NV_texture_rectangle */

/* -------------------------- GL_NV_texture_shader ------------------------- */

#ifdef GL_NV_texture_shader

static void _glewInfo_GL_NV_texture_shader (void)
{
  glewPrintExt("GL_NV_texture_shader", GLEW_NV_texture_shader, glewGetExtension("GL_NV_texture_shader"));
}

#endif /* GL_NV_texture_shader */

/* ------------------------- GL_NV_texture_shader2 ------------------------- */

#ifdef GL_NV_texture_shader2

static void _glewInfo_GL_NV_texture_shader2 (void)
{
  glewPrintExt("GL_NV_texture_shader2", GLEW_NV_texture_shader2, glewGetExtension("GL_NV_texture_shader2"));
}

#endif /* GL_NV_texture_shader2 */

/* ------------------------- GL_NV_texture_shader3 ------------------------- */

#ifdef GL_NV_texture_shader3

static void _glewInfo_GL_NV_texture_shader3 (void)
{
  glewPrintExt("GL_NV_texture_shader3", GLEW_NV_texture_shader3, glewGetExtension("GL_NV_texture_shader3"));
}

#endif /* GL_NV_texture_shader3 */

/* ------------------------ GL_NV_vertex_array_range ----------------------- */

#ifdef GL_NV_vertex_array_range

static void _glewInfo_GL_NV_vertex_array_range (void)
{
  glewPrintExt("GL_NV_vertex_array_range", GLEW_NV_vertex_array_range, glewGetExtension("GL_NV_vertex_array_range"));

  glewInfoFunc("glFlushVertexArrayRangeNV", glFlushVertexArrayRangeNV == NULL);
  glewInfoFunc("glVertexArrayRangeNV", glVertexArrayRangeNV == NULL);
}

#endif /* GL_NV_vertex_array_range */

/* ----------------------- GL_NV_vertex_array_range2 ----------------------- */

#ifdef GL_NV_vertex_array_range2

static void _glewInfo_GL_NV_vertex_array_range2 (void)
{
  glewPrintExt("GL_NV_vertex_array_range2", GLEW_NV_vertex_array_range2, glewGetExtension("GL_NV_vertex_array_range2"));
}

#endif /* GL_NV_vertex_array_range2 */

/* -------------------------- GL_NV_vertex_program ------------------------- */

#ifdef GL_NV_vertex_program

static void _glewInfo_GL_NV_vertex_program (void)
{
  glewPrintExt("GL_NV_vertex_program", GLEW_NV_vertex_program, glewGetExtension("GL_NV_vertex_program"));

  glewInfoFunc("glAreProgramsResidentNV", glAreProgramsResidentNV == NULL);
  glewInfoFunc("glBindProgramNV", glBindProgramNV == NULL);
  glewInfoFunc("glDeleteProgramsNV", glDeleteProgramsNV == NULL);
  glewInfoFunc("glExecuteProgramNV", glExecuteProgramNV == NULL);
  glewInfoFunc("glGenProgramsNV", glGenProgramsNV == NULL);
  glewInfoFunc("glGetProgramParameterdvNV", glGetProgramParameterdvNV == NULL);
  glewInfoFunc("glGetProgramParameterfvNV", glGetProgramParameterfvNV == NULL);
  glewInfoFunc("glGetProgramStringNV", glGetProgramStringNV == NULL);
  glewInfoFunc("glGetProgramivNV", glGetProgramivNV == NULL);
  glewInfoFunc("glGetTrackMatrixivNV", glGetTrackMatrixivNV == NULL);
  glewInfoFunc("glGetVertexAttribPointervNV", glGetVertexAttribPointervNV == NULL);
  glewInfoFunc("glGetVertexAttribdvNV", glGetVertexAttribdvNV == NULL);
  glewInfoFunc("glGetVertexAttribfvNV", glGetVertexAttribfvNV == NULL);
  glewInfoFunc("glGetVertexAttribivNV", glGetVertexAttribivNV == NULL);
  glewInfoFunc("glIsProgramNV", glIsProgramNV == NULL);
  glewInfoFunc("glLoadProgramNV", glLoadProgramNV == NULL);
  glewInfoFunc("glProgramParameter4dNV", glProgramParameter4dNV == NULL);
  glewInfoFunc("glProgramParameter4dvNV", glProgramParameter4dvNV == NULL);
  glewInfoFunc("glProgramParameter4fNV", glProgramParameter4fNV == NULL);
  glewInfoFunc("glProgramParameter4fvNV", glProgramParameter4fvNV == NULL);
  glewInfoFunc("glProgramParameters4dvNV", glProgramParameters4dvNV == NULL);
  glewInfoFunc("glProgramParameters4fvNV", glProgramParameters4fvNV == NULL);
  glewInfoFunc("glRequestResidentProgramsNV", glRequestResidentProgramsNV == NULL);
  glewInfoFunc("glTrackMatrixNV", glTrackMatrixNV == NULL);
  glewInfoFunc("glVertexAttrib1dNV", glVertexAttrib1dNV == NULL);
  glewInfoFunc("glVertexAttrib1dvNV", glVertexAttrib1dvNV == NULL);
  glewInfoFunc("glVertexAttrib1fNV", glVertexAttrib1fNV == NULL);
  glewInfoFunc("glVertexAttrib1fvNV", glVertexAttrib1fvNV == NULL);
  glewInfoFunc("glVertexAttrib1sNV", glVertexAttrib1sNV == NULL);
  glewInfoFunc("glVertexAttrib1svNV", glVertexAttrib1svNV == NULL);
  glewInfoFunc("glVertexAttrib2dNV", glVertexAttrib2dNV == NULL);
  glewInfoFunc("glVertexAttrib2dvNV", glVertexAttrib2dvNV == NULL);
  glewInfoFunc("glVertexAttrib2fNV", glVertexAttrib2fNV == NULL);
  glewInfoFunc("glVertexAttrib2fvNV", glVertexAttrib2fvNV == NULL);
  glewInfoFunc("glVertexAttrib2sNV", glVertexAttrib2sNV == NULL);
  glewInfoFunc("glVertexAttrib2svNV", glVertexAttrib2svNV == NULL);
  glewInfoFunc("glVertexAttrib3dNV", glVertexAttrib3dNV == NULL);
  glewInfoFunc("glVertexAttrib3dvNV", glVertexAttrib3dvNV == NULL);
  glewInfoFunc("glVertexAttrib3fNV", glVertexAttrib3fNV == NULL);
  glewInfoFunc("glVertexAttrib3fvNV", glVertexAttrib3fvNV == NULL);
  glewInfoFunc("glVertexAttrib3sNV", glVertexAttrib3sNV == NULL);
  glewInfoFunc("glVertexAttrib3svNV", glVertexAttrib3svNV == NULL);
  glewInfoFunc("glVertexAttrib4dNV", glVertexAttrib4dNV == NULL);
  glewInfoFunc("glVertexAttrib4dvNV", glVertexAttrib4dvNV == NULL);
  glewInfoFunc("glVertexAttrib4fNV", glVertexAttrib4fNV == NULL);
  glewInfoFunc("glVertexAttrib4fvNV", glVertexAttrib4fvNV == NULL);
  glewInfoFunc("glVertexAttrib4sNV", glVertexAttrib4sNV == NULL);
  glewInfoFunc("glVertexAttrib4svNV", glVertexAttrib4svNV == NULL);
  glewInfoFunc("glVertexAttrib4ubNV", glVertexAttrib4ubNV == NULL);
  glewInfoFunc("glVertexAttrib4ubvNV", glVertexAttrib4ubvNV == NULL);
  glewInfoFunc("glVertexAttribPointerNV", glVertexAttribPointerNV == NULL);
  glewInfoFunc("glVertexAttribs1dvNV", glVertexAttribs1dvNV == NULL);
  glewInfoFunc("glVertexAttribs1fvNV", glVertexAttribs1fvNV == NULL);
  glewInfoFunc("glVertexAttribs1svNV", glVertexAttribs1svNV == NULL);
  glewInfoFunc("glVertexAttribs2dvNV", glVertexAttribs2dvNV == NULL);
  glewInfoFunc("glVertexAttribs2fvNV", glVertexAttribs2fvNV == NULL);
  glewInfoFunc("glVertexAttribs2svNV", glVertexAttribs2svNV == NULL);
  glewInfoFunc("glVertexAttribs3dvNV", glVertexAttribs3dvNV == NULL);
  glewInfoFunc("glVertexAttribs3fvNV", glVertexAttribs3fvNV == NULL);
  glewInfoFunc("glVertexAttribs3svNV", glVertexAttribs3svNV == NULL);
  glewInfoFunc("glVertexAttribs4dvNV", glVertexAttribs4dvNV == NULL);
  glewInfoFunc("glVertexAttribs4fvNV", glVertexAttribs4fvNV == NULL);
  glewInfoFunc("glVertexAttribs4svNV", glVertexAttribs4svNV == NULL);
  glewInfoFunc("glVertexAttribs4ubvNV", glVertexAttribs4ubvNV == NULL);
}

#endif /* GL_NV_vertex_program */

/* ------------------------ GL_NV_vertex_program1_1 ------------------------ */

#ifdef GL_NV_vertex_program1_1

static void _glewInfo_GL_NV_vertex_program1_1 (void)
{
  glewPrintExt("GL_NV_vertex_program1_1", GLEW_NV_vertex_program1_1, glewGetExtension("GL_NV_vertex_program1_1"));
}

#endif /* GL_NV_vertex_program1_1 */

/* ------------------------- GL_NV_vertex_program2 ------------------------- */

#ifdef GL_NV_vertex_program2

static void _glewInfo_GL_NV_vertex_program2 (void)
{
  glewPrintExt("GL_NV_vertex_program2", GLEW_NV_vertex_program2, glewGetExtension("GL_NV_vertex_program2"));
}

#endif /* GL_NV_vertex_program2 */

/* ---------------------- GL_NV_vertex_program2_option --------------------- */

#ifdef GL_NV_vertex_program2_option

static void _glewInfo_GL_NV_vertex_program2_option (void)
{
  glewPrintExt("GL_NV_vertex_program2_option", GLEW_NV_vertex_program2_option, glewGetExtension("GL_NV_vertex_program2_option"));
}

#endif /* GL_NV_vertex_program2_option */

/* ------------------------- GL_NV_vertex_program3 ------------------------- */

#ifdef GL_NV_vertex_program3

static void _glewInfo_GL_NV_vertex_program3 (void)
{
  glewPrintExt("GL_NV_vertex_program3", GLEW_NV_vertex_program3, glewGetExtension("GL_NV_vertex_program3"));
}

#endif /* GL_NV_vertex_program3 */

/* ---------------------------- GL_OML_interlace --------------------------- */

#ifdef GL_OML_interlace

static void _glewInfo_GL_OML_interlace (void)
{
  glewPrintExt("GL_OML_interlace", GLEW_OML_interlace, glewGetExtension("GL_OML_interlace"));
}

#endif /* GL_OML_interlace */

/* ---------------------------- GL_OML_resample ---------------------------- */

#ifdef GL_OML_resample

static void _glewInfo_GL_OML_resample (void)
{
  glewPrintExt("GL_OML_resample", GLEW_OML_resample, glewGetExtension("GL_OML_resample"));
}

#endif /* GL_OML_resample */

/* ---------------------------- GL_OML_subsample --------------------------- */

#ifdef GL_OML_subsample

static void _glewInfo_GL_OML_subsample (void)
{
  glewPrintExt("GL_OML_subsample", GLEW_OML_subsample, glewGetExtension("GL_OML_subsample"));
}

#endif /* GL_OML_subsample */

/* --------------------------- GL_PGI_misc_hints --------------------------- */

#ifdef GL_PGI_misc_hints

static void _glewInfo_GL_PGI_misc_hints (void)
{
  glewPrintExt("GL_PGI_misc_hints", GLEW_PGI_misc_hints, glewGetExtension("GL_PGI_misc_hints"));
}

#endif /* GL_PGI_misc_hints */

/* -------------------------- GL_PGI_vertex_hints -------------------------- */

#ifdef GL_PGI_vertex_hints

static void _glewInfo_GL_PGI_vertex_hints (void)
{
  glewPrintExt("GL_PGI_vertex_hints", GLEW_PGI_vertex_hints, glewGetExtension("GL_PGI_vertex_hints"));
}

#endif /* GL_PGI_vertex_hints */

/* ----------------------- GL_REND_screen_coordinates ---------------------- */

#ifdef GL_REND_screen_coordinates

static void _glewInfo_GL_REND_screen_coordinates (void)
{
  glewPrintExt("GL_REND_screen_coordinates", GLEW_REND_screen_coordinates, glewGetExtension("GL_REND_screen_coordinates"));
}

#endif /* GL_REND_screen_coordinates */

/* ------------------------------- GL_S3_s3tc ------------------------------ */

#ifdef GL_S3_s3tc

static void _glewInfo_GL_S3_s3tc (void)
{
  glewPrintExt("GL_S3_s3tc", GLEW_S3_s3tc, glewGetExtension("GL_S3_s3tc"));
}

#endif /* GL_S3_s3tc */

/* -------------------------- GL_SGIS_color_range -------------------------- */

#ifdef GL_SGIS_color_range

static void _glewInfo_GL_SGIS_color_range (void)
{
  glewPrintExt("GL_SGIS_color_range", GLEW_SGIS_color_range, glewGetExtension("GL_SGIS_color_range"));
}

#endif /* GL_SGIS_color_range */

/* ------------------------- GL_SGIS_detail_texture ------------------------ */

#ifdef GL_SGIS_detail_texture

static void _glewInfo_GL_SGIS_detail_texture (void)
{
  glewPrintExt("GL_SGIS_detail_texture", GLEW_SGIS_detail_texture, glewGetExtension("GL_SGIS_detail_texture"));

  glewInfoFunc("glDetailTexFuncSGIS", glDetailTexFuncSGIS == NULL);
  glewInfoFunc("glGetDetailTexFuncSGIS", glGetDetailTexFuncSGIS == NULL);
}

#endif /* GL_SGIS_detail_texture */

/* -------------------------- GL_SGIS_fog_function ------------------------- */

#ifdef GL_SGIS_fog_function

static void _glewInfo_GL_SGIS_fog_function (void)
{
  glewPrintExt("GL_SGIS_fog_function", GLEW_SGIS_fog_function, glewGetExtension("GL_SGIS_fog_function"));

  glewInfoFunc("glFogFuncSGIS", glFogFuncSGIS == NULL);
  glewInfoFunc("glGetFogFuncSGIS", glGetFogFuncSGIS == NULL);
}

#endif /* GL_SGIS_fog_function */

/* ------------------------ GL_SGIS_generate_mipmap ------------------------ */

#ifdef GL_SGIS_generate_mipmap

static void _glewInfo_GL_SGIS_generate_mipmap (void)
{
  glewPrintExt("GL_SGIS_generate_mipmap", GLEW_SGIS_generate_mipmap, glewGetExtension("GL_SGIS_generate_mipmap"));
}

#endif /* GL_SGIS_generate_mipmap */

/* -------------------------- GL_SGIS_multisample -------------------------- */

#ifdef GL_SGIS_multisample

static void _glewInfo_GL_SGIS_multisample (void)
{
  glewPrintExt("GL_SGIS_multisample", GLEW_SGIS_multisample, glewGetExtension("GL_SGIS_multisample"));

  glewInfoFunc("glSampleMaskSGIS", glSampleMaskSGIS == NULL);
  glewInfoFunc("glSamplePatternSGIS", glSamplePatternSGIS == NULL);
}

#endif /* GL_SGIS_multisample */

/* ------------------------- GL_SGIS_pixel_texture ------------------------- */

#ifdef GL_SGIS_pixel_texture

static void _glewInfo_GL_SGIS_pixel_texture (void)
{
  glewPrintExt("GL_SGIS_pixel_texture", GLEW_SGIS_pixel_texture, glewGetExtension("GL_SGIS_pixel_texture"));
}

#endif /* GL_SGIS_pixel_texture */

/* ------------------------ GL_SGIS_sharpen_texture ------------------------ */

#ifdef GL_SGIS_sharpen_texture

static void _glewInfo_GL_SGIS_sharpen_texture (void)
{
  glewPrintExt("GL_SGIS_sharpen_texture", GLEW_SGIS_sharpen_texture, glewGetExtension("GL_SGIS_sharpen_texture"));

  glewInfoFunc("glGetSharpenTexFuncSGIS", glGetSharpenTexFuncSGIS == NULL);
  glewInfoFunc("glSharpenTexFuncSGIS", glSharpenTexFuncSGIS == NULL);
}

#endif /* GL_SGIS_sharpen_texture */

/* --------------------------- GL_SGIS_texture4D --------------------------- */

#ifdef GL_SGIS_texture4D

static void _glewInfo_GL_SGIS_texture4D (void)
{
  glewPrintExt("GL_SGIS_texture4D", GLEW_SGIS_texture4D, glewGetExtension("GL_SGIS_texture4D"));

  glewInfoFunc("glTexImage4DSGIS", glTexImage4DSGIS == NULL);
  glewInfoFunc("glTexSubImage4DSGIS", glTexSubImage4DSGIS == NULL);
}

#endif /* GL_SGIS_texture4D */

/* ---------------------- GL_SGIS_texture_border_clamp --------------------- */

#ifdef GL_SGIS_texture_border_clamp

static void _glewInfo_GL_SGIS_texture_border_clamp (void)
{
  glewPrintExt("GL_SGIS_texture_border_clamp", GLEW_SGIS_texture_border_clamp, glewGetExtension("GL_SGIS_texture_border_clamp"));
}

#endif /* GL_SGIS_texture_border_clamp */

/* ----------------------- GL_SGIS_texture_edge_clamp ---------------------- */

#ifdef GL_SGIS_texture_edge_clamp

static void _glewInfo_GL_SGIS_texture_edge_clamp (void)
{
  glewPrintExt("GL_SGIS_texture_edge_clamp", GLEW_SGIS_texture_edge_clamp, glewGetExtension("GL_SGIS_texture_edge_clamp"));
}

#endif /* GL_SGIS_texture_edge_clamp */

/* ------------------------ GL_SGIS_texture_filter4 ------------------------ */

#ifdef GL_SGIS_texture_filter4

static void _glewInfo_GL_SGIS_texture_filter4 (void)
{
  glewPrintExt("GL_SGIS_texture_filter4", GLEW_SGIS_texture_filter4, glewGetExtension("GL_SGIS_texture_filter4"));

  glewInfoFunc("glGetTexFilterFuncSGIS", glGetTexFilterFuncSGIS == NULL);
  glewInfoFunc("glTexFilterFuncSGIS", glTexFilterFuncSGIS == NULL);
}

#endif /* GL_SGIS_texture_filter4 */

/* -------------------------- GL_SGIS_texture_lod -------------------------- */

#ifdef GL_SGIS_texture_lod

static void _glewInfo_GL_SGIS_texture_lod (void)
{
  glewPrintExt("GL_SGIS_texture_lod", GLEW_SGIS_texture_lod, glewGetExtension("GL_SGIS_texture_lod"));
}

#endif /* GL_SGIS_texture_lod */

/* ------------------------- GL_SGIS_texture_select ------------------------ */

#ifdef GL_SGIS_texture_select

static void _glewInfo_GL_SGIS_texture_select (void)
{
  glewPrintExt("GL_SGIS_texture_select", GLEW_SGIS_texture_select, glewGetExtension("GL_SGIS_texture_select"));
}

#endif /* GL_SGIS_texture_select */

/* ----------------------------- GL_SGIX_async ----------------------------- */

#ifdef GL_SGIX_async

static void _glewInfo_GL_SGIX_async (void)
{
  glewPrintExt("GL_SGIX_async", GLEW_SGIX_async, glewGetExtension("GL_SGIX_async"));

  glewInfoFunc("glAsyncMarkerSGIX", glAsyncMarkerSGIX == NULL);
  glewInfoFunc("glDeleteAsyncMarkersSGIX", glDeleteAsyncMarkersSGIX == NULL);
  glewInfoFunc("glFinishAsyncSGIX", glFinishAsyncSGIX == NULL);
  glewInfoFunc("glGenAsyncMarkersSGIX", glGenAsyncMarkersSGIX == NULL);
  glewInfoFunc("glIsAsyncMarkerSGIX", glIsAsyncMarkerSGIX == NULL);
  glewInfoFunc("glPollAsyncSGIX", glPollAsyncSGIX == NULL);
}

#endif /* GL_SGIX_async */

/* ------------------------ GL_SGIX_async_histogram ------------------------ */

#ifdef GL_SGIX_async_histogram

static void _glewInfo_GL_SGIX_async_histogram (void)
{
  glewPrintExt("GL_SGIX_async_histogram", GLEW_SGIX_async_histogram, glewGetExtension("GL_SGIX_async_histogram"));
}

#endif /* GL_SGIX_async_histogram */

/* -------------------------- GL_SGIX_async_pixel -------------------------- */

#ifdef GL_SGIX_async_pixel

static void _glewInfo_GL_SGIX_async_pixel (void)
{
  glewPrintExt("GL_SGIX_async_pixel", GLEW_SGIX_async_pixel, glewGetExtension("GL_SGIX_async_pixel"));
}

#endif /* GL_SGIX_async_pixel */

/* ----------------------- GL_SGIX_blend_alpha_minmax ---------------------- */

#ifdef GL_SGIX_blend_alpha_minmax

static void _glewInfo_GL_SGIX_blend_alpha_minmax (void)
{
  glewPrintExt("GL_SGIX_blend_alpha_minmax", GLEW_SGIX_blend_alpha_minmax, glewGetExtension("GL_SGIX_blend_alpha_minmax"));
}

#endif /* GL_SGIX_blend_alpha_minmax */

/* ---------------------------- GL_SGIX_clipmap ---------------------------- */

#ifdef GL_SGIX_clipmap

static void _glewInfo_GL_SGIX_clipmap (void)
{
  glewPrintExt("GL_SGIX_clipmap", GLEW_SGIX_clipmap, glewGetExtension("GL_SGIX_clipmap"));
}

#endif /* GL_SGIX_clipmap */

/* ------------------------- GL_SGIX_depth_texture ------------------------- */

#ifdef GL_SGIX_depth_texture

static void _glewInfo_GL_SGIX_depth_texture (void)
{
  glewPrintExt("GL_SGIX_depth_texture", GLEW_SGIX_depth_texture, glewGetExtension("GL_SGIX_depth_texture"));
}

#endif /* GL_SGIX_depth_texture */

/* -------------------------- GL_SGIX_flush_raster ------------------------- */

#ifdef GL_SGIX_flush_raster

static void _glewInfo_GL_SGIX_flush_raster (void)
{
  glewPrintExt("GL_SGIX_flush_raster", GLEW_SGIX_flush_raster, glewGetExtension("GL_SGIX_flush_raster"));

  glewInfoFunc("glFlushRasterSGIX", glFlushRasterSGIX == NULL);
}

#endif /* GL_SGIX_flush_raster */

/* --------------------------- GL_SGIX_fog_offset -------------------------- */

#ifdef GL_SGIX_fog_offset

static void _glewInfo_GL_SGIX_fog_offset (void)
{
  glewPrintExt("GL_SGIX_fog_offset", GLEW_SGIX_fog_offset, glewGetExtension("GL_SGIX_fog_offset"));
}

#endif /* GL_SGIX_fog_offset */

/* -------------------------- GL_SGIX_fog_texture -------------------------- */

#ifdef GL_SGIX_fog_texture

static void _glewInfo_GL_SGIX_fog_texture (void)
{
  glewPrintExt("GL_SGIX_fog_texture", GLEW_SGIX_fog_texture, glewGetExtension("GL_SGIX_fog_texture"));

  glewInfoFunc("glTextureFogSGIX", glTextureFogSGIX == NULL);
}

#endif /* GL_SGIX_fog_texture */

/* ------------------- GL_SGIX_fragment_specular_lighting ------------------ */

#ifdef GL_SGIX_fragment_specular_lighting

static void _glewInfo_GL_SGIX_fragment_specular_lighting (void)
{
  glewPrintExt("GL_SGIX_fragment_specular_lighting", GLEW_SGIX_fragment_specular_lighting, glewGetExtension("GL_SGIX_fragment_specular_lighting"));

  glewInfoFunc("glFragmentColorMaterialSGIX", glFragmentColorMaterialSGIX == NULL);
  glewInfoFunc("glFragmentLightModelfSGIX", glFragmentLightModelfSGIX == NULL);
  glewInfoFunc("glFragmentLightModelfvSGIX", glFragmentLightModelfvSGIX == NULL);
  glewInfoFunc("glFragmentLightModeliSGIX", glFragmentLightModeliSGIX == NULL);
  glewInfoFunc("glFragmentLightModelivSGIX", glFragmentLightModelivSGIX == NULL);
  glewInfoFunc("glFragmentLightfSGIX", glFragmentLightfSGIX == NULL);
  glewInfoFunc("glFragmentLightfvSGIX", glFragmentLightfvSGIX == NULL);
  glewInfoFunc("glFragmentLightiSGIX", glFragmentLightiSGIX == NULL);
  glewInfoFunc("glFragmentLightivSGIX", glFragmentLightivSGIX == NULL);
  glewInfoFunc("glFragmentMaterialfSGIX", glFragmentMaterialfSGIX == NULL);
  glewInfoFunc("glFragmentMaterialfvSGIX", glFragmentMaterialfvSGIX == NULL);
  glewInfoFunc("glFragmentMaterialiSGIX", glFragmentMaterialiSGIX == NULL);
  glewInfoFunc("glFragmentMaterialivSGIX", glFragmentMaterialivSGIX == NULL);
  glewInfoFunc("glGetFragmentLightfvSGIX", glGetFragmentLightfvSGIX == NULL);
  glewInfoFunc("glGetFragmentLightivSGIX", glGetFragmentLightivSGIX == NULL);
  glewInfoFunc("glGetFragmentMaterialfvSGIX", glGetFragmentMaterialfvSGIX == NULL);
  glewInfoFunc("glGetFragmentMaterialivSGIX", glGetFragmentMaterialivSGIX == NULL);
}

#endif /* GL_SGIX_fragment_specular_lighting */

/* --------------------------- GL_SGIX_framezoom --------------------------- */

#ifdef GL_SGIX_framezoom

static void _glewInfo_GL_SGIX_framezoom (void)
{
  glewPrintExt("GL_SGIX_framezoom", GLEW_SGIX_framezoom, glewGetExtension("GL_SGIX_framezoom"));

  glewInfoFunc("glFrameZoomSGIX", glFrameZoomSGIX == NULL);
}

#endif /* GL_SGIX_framezoom */

/* --------------------------- GL_SGIX_interlace --------------------------- */

#ifdef GL_SGIX_interlace

static void _glewInfo_GL_SGIX_interlace (void)
{
  glewPrintExt("GL_SGIX_interlace", GLEW_SGIX_interlace, glewGetExtension("GL_SGIX_interlace"));
}

#endif /* GL_SGIX_interlace */

/* ------------------------- GL_SGIX_ir_instrument1 ------------------------ */

#ifdef GL_SGIX_ir_instrument1

static void _glewInfo_GL_SGIX_ir_instrument1 (void)
{
  glewPrintExt("GL_SGIX_ir_instrument1", GLEW_SGIX_ir_instrument1, glewGetExtension("GL_SGIX_ir_instrument1"));
}

#endif /* GL_SGIX_ir_instrument1 */

/* ------------------------- GL_SGIX_list_priority ------------------------- */

#ifdef GL_SGIX_list_priority

static void _glewInfo_GL_SGIX_list_priority (void)
{
  glewPrintExt("GL_SGIX_list_priority", GLEW_SGIX_list_priority, glewGetExtension("GL_SGIX_list_priority"));
}

#endif /* GL_SGIX_list_priority */

/* ------------------------- GL_SGIX_pixel_texture ------------------------- */

#ifdef GL_SGIX_pixel_texture

static void _glewInfo_GL_SGIX_pixel_texture (void)
{
  glewPrintExt("GL_SGIX_pixel_texture", GLEW_SGIX_pixel_texture, glewGetExtension("GL_SGIX_pixel_texture"));

  glewInfoFunc("glPixelTexGenSGIX", glPixelTexGenSGIX == NULL);
}

#endif /* GL_SGIX_pixel_texture */

/* ----------------------- GL_SGIX_pixel_texture_bits ---------------------- */

#ifdef GL_SGIX_pixel_texture_bits

static void _glewInfo_GL_SGIX_pixel_texture_bits (void)
{
  glewPrintExt("GL_SGIX_pixel_texture_bits", GLEW_SGIX_pixel_texture_bits, glewGetExtension("GL_SGIX_pixel_texture_bits"));
}

#endif /* GL_SGIX_pixel_texture_bits */

/* ------------------------ GL_SGIX_reference_plane ------------------------ */

#ifdef GL_SGIX_reference_plane

static void _glewInfo_GL_SGIX_reference_plane (void)
{
  glewPrintExt("GL_SGIX_reference_plane", GLEW_SGIX_reference_plane, glewGetExtension("GL_SGIX_reference_plane"));

  glewInfoFunc("glReferencePlaneSGIX", glReferencePlaneSGIX == NULL);
}

#endif /* GL_SGIX_reference_plane */

/* ---------------------------- GL_SGIX_resample --------------------------- */

#ifdef GL_SGIX_resample

static void _glewInfo_GL_SGIX_resample (void)
{
  glewPrintExt("GL_SGIX_resample", GLEW_SGIX_resample, glewGetExtension("GL_SGIX_resample"));
}

#endif /* GL_SGIX_resample */

/* ----------------------------- GL_SGIX_shadow ---------------------------- */

#ifdef GL_SGIX_shadow

static void _glewInfo_GL_SGIX_shadow (void)
{
  glewPrintExt("GL_SGIX_shadow", GLEW_SGIX_shadow, glewGetExtension("GL_SGIX_shadow"));
}

#endif /* GL_SGIX_shadow */

/* ------------------------- GL_SGIX_shadow_ambient ------------------------ */

#ifdef GL_SGIX_shadow_ambient

static void _glewInfo_GL_SGIX_shadow_ambient (void)
{
  glewPrintExt("GL_SGIX_shadow_ambient", GLEW_SGIX_shadow_ambient, glewGetExtension("GL_SGIX_shadow_ambient"));
}

#endif /* GL_SGIX_shadow_ambient */

/* ----------------------------- GL_SGIX_sprite ---------------------------- */

#ifdef GL_SGIX_sprite

static void _glewInfo_GL_SGIX_sprite (void)
{
  glewPrintExt("GL_SGIX_sprite", GLEW_SGIX_sprite, glewGetExtension("GL_SGIX_sprite"));

  glewInfoFunc("glSpriteParameterfSGIX", glSpriteParameterfSGIX == NULL);
  glewInfoFunc("glSpriteParameterfvSGIX", glSpriteParameterfvSGIX == NULL);
  glewInfoFunc("glSpriteParameteriSGIX", glSpriteParameteriSGIX == NULL);
  glewInfoFunc("glSpriteParameterivSGIX", glSpriteParameterivSGIX == NULL);
}

#endif /* GL_SGIX_sprite */

/* ----------------------- GL_SGIX_tag_sample_buffer ----------------------- */

#ifdef GL_SGIX_tag_sample_buffer

static void _glewInfo_GL_SGIX_tag_sample_buffer (void)
{
  glewPrintExt("GL_SGIX_tag_sample_buffer", GLEW_SGIX_tag_sample_buffer, glewGetExtension("GL_SGIX_tag_sample_buffer"));

  glewInfoFunc("glTagSampleBufferSGIX", glTagSampleBufferSGIX == NULL);
}

#endif /* GL_SGIX_tag_sample_buffer */

/* ------------------------ GL_SGIX_texture_add_env ------------------------ */

#ifdef GL_SGIX_texture_add_env

static void _glewInfo_GL_SGIX_texture_add_env (void)
{
  glewPrintExt("GL_SGIX_texture_add_env", GLEW_SGIX_texture_add_env, glewGetExtension("GL_SGIX_texture_add_env"));
}

#endif /* GL_SGIX_texture_add_env */

/* -------------------- GL_SGIX_texture_coordinate_clamp ------------------- */

#ifdef GL_SGIX_texture_coordinate_clamp

static void _glewInfo_GL_SGIX_texture_coordinate_clamp (void)
{
  glewPrintExt("GL_SGIX_texture_coordinate_clamp", GLEW_SGIX_texture_coordinate_clamp, glewGetExtension("GL_SGIX_texture_coordinate_clamp"));
}

#endif /* GL_SGIX_texture_coordinate_clamp */

/* ------------------------ GL_SGIX_texture_lod_bias ----------------------- */

#ifdef GL_SGIX_texture_lod_bias

static void _glewInfo_GL_SGIX_texture_lod_bias (void)
{
  glewPrintExt("GL_SGIX_texture_lod_bias", GLEW_SGIX_texture_lod_bias, glewGetExtension("GL_SGIX_texture_lod_bias"));
}

#endif /* GL_SGIX_texture_lod_bias */

/* ---------------------- GL_SGIX_texture_multi_buffer --------------------- */

#ifdef GL_SGIX_texture_multi_buffer

static void _glewInfo_GL_SGIX_texture_multi_buffer (void)
{
  glewPrintExt("GL_SGIX_texture_multi_buffer", GLEW_SGIX_texture_multi_buffer, glewGetExtension("GL_SGIX_texture_multi_buffer"));
}

#endif /* GL_SGIX_texture_multi_buffer */

/* ------------------------- GL_SGIX_texture_range ------------------------- */

#ifdef GL_SGIX_texture_range

static void _glewInfo_GL_SGIX_texture_range (void)
{
  glewPrintExt("GL_SGIX_texture_range", GLEW_SGIX_texture_range, glewGetExtension("GL_SGIX_texture_range"));
}

#endif /* GL_SGIX_texture_range */

/* ----------------------- GL_SGIX_texture_scale_bias ---------------------- */

#ifdef GL_SGIX_texture_scale_bias

static void _glewInfo_GL_SGIX_texture_scale_bias (void)
{
  glewPrintExt("GL_SGIX_texture_scale_bias", GLEW_SGIX_texture_scale_bias, glewGetExtension("GL_SGIX_texture_scale_bias"));
}

#endif /* GL_SGIX_texture_scale_bias */

/* ------------------------- GL_SGIX_vertex_preclip ------------------------ */

#ifdef GL_SGIX_vertex_preclip

static void _glewInfo_GL_SGIX_vertex_preclip (void)
{
  glewPrintExt("GL_SGIX_vertex_preclip", GLEW_SGIX_vertex_preclip, glewGetExtension("GL_SGIX_vertex_preclip"));
}

#endif /* GL_SGIX_vertex_preclip */

/* ---------------------- GL_SGIX_vertex_preclip_hint ---------------------- */

#ifdef GL_SGIX_vertex_preclip_hint

static void _glewInfo_GL_SGIX_vertex_preclip_hint (void)
{
  glewPrintExt("GL_SGIX_vertex_preclip_hint", GLEW_SGIX_vertex_preclip_hint, glewGetExtension("GL_SGIX_vertex_preclip_hint"));
}

#endif /* GL_SGIX_vertex_preclip_hint */

/* ----------------------------- GL_SGIX_ycrcb ----------------------------- */

#ifdef GL_SGIX_ycrcb

static void _glewInfo_GL_SGIX_ycrcb (void)
{
  glewPrintExt("GL_SGIX_ycrcb", GLEW_SGIX_ycrcb, glewGetExtension("GL_SGIX_ycrcb"));
}

#endif /* GL_SGIX_ycrcb */

/* -------------------------- GL_SGI_color_matrix -------------------------- */

#ifdef GL_SGI_color_matrix

static void _glewInfo_GL_SGI_color_matrix (void)
{
  glewPrintExt("GL_SGI_color_matrix", GLEW_SGI_color_matrix, glewGetExtension("GL_SGI_color_matrix"));
}

#endif /* GL_SGI_color_matrix */

/* --------------------------- GL_SGI_color_table -------------------------- */

#ifdef GL_SGI_color_table

static void _glewInfo_GL_SGI_color_table (void)
{
  glewPrintExt("GL_SGI_color_table", GLEW_SGI_color_table, glewGetExtension("GL_SGI_color_table"));

  glewInfoFunc("glColorTableParameterfvSGI", glColorTableParameterfvSGI == NULL);
  glewInfoFunc("glColorTableParameterivSGI", glColorTableParameterivSGI == NULL);
  glewInfoFunc("glColorTableSGI", glColorTableSGI == NULL);
  glewInfoFunc("glCopyColorTableSGI", glCopyColorTableSGI == NULL);
  glewInfoFunc("glGetColorTableParameterfvSGI", glGetColorTableParameterfvSGI == NULL);
  glewInfoFunc("glGetColorTableParameterivSGI", glGetColorTableParameterivSGI == NULL);
  glewInfoFunc("glGetColorTableSGI", glGetColorTableSGI == NULL);
}

#endif /* GL_SGI_color_table */

/* ----------------------- GL_SGI_texture_color_table ---------------------- */

#ifdef GL_SGI_texture_color_table

static void _glewInfo_GL_SGI_texture_color_table (void)
{
  glewPrintExt("GL_SGI_texture_color_table", GLEW_SGI_texture_color_table, glewGetExtension("GL_SGI_texture_color_table"));
}

#endif /* GL_SGI_texture_color_table */

/* ------------------------- GL_SUNX_constant_data ------------------------- */

#ifdef GL_SUNX_constant_data

static void _glewInfo_GL_SUNX_constant_data (void)
{
  glewPrintExt("GL_SUNX_constant_data", GLEW_SUNX_constant_data, glewGetExtension("GL_SUNX_constant_data"));

  glewInfoFunc("glFinishTextureSUNX", glFinishTextureSUNX == NULL);
}

#endif /* GL_SUNX_constant_data */

/* -------------------- GL_SUN_convolution_border_modes -------------------- */

#ifdef GL_SUN_convolution_border_modes

static void _glewInfo_GL_SUN_convolution_border_modes (void)
{
  glewPrintExt("GL_SUN_convolution_border_modes", GLEW_SUN_convolution_border_modes, glewGetExtension("GL_SUN_convolution_border_modes"));
}

#endif /* GL_SUN_convolution_border_modes */

/* -------------------------- GL_SUN_global_alpha -------------------------- */

#ifdef GL_SUN_global_alpha

static void _glewInfo_GL_SUN_global_alpha (void)
{
  glewPrintExt("GL_SUN_global_alpha", GLEW_SUN_global_alpha, glewGetExtension("GL_SUN_global_alpha"));

  glewInfoFunc("glGlobalAlphaFactorbSUN", glGlobalAlphaFactorbSUN == NULL);
  glewInfoFunc("glGlobalAlphaFactordSUN", glGlobalAlphaFactordSUN == NULL);
  glewInfoFunc("glGlobalAlphaFactorfSUN", glGlobalAlphaFactorfSUN == NULL);
  glewInfoFunc("glGlobalAlphaFactoriSUN", glGlobalAlphaFactoriSUN == NULL);
  glewInfoFunc("glGlobalAlphaFactorsSUN", glGlobalAlphaFactorsSUN == NULL);
  glewInfoFunc("glGlobalAlphaFactorubSUN", glGlobalAlphaFactorubSUN == NULL);
  glewInfoFunc("glGlobalAlphaFactoruiSUN", glGlobalAlphaFactoruiSUN == NULL);
  glewInfoFunc("glGlobalAlphaFactorusSUN", glGlobalAlphaFactorusSUN == NULL);
}

#endif /* GL_SUN_global_alpha */

/* --------------------------- GL_SUN_mesh_array --------------------------- */

#ifdef GL_SUN_mesh_array

static void _glewInfo_GL_SUN_mesh_array (void)
{
  glewPrintExt("GL_SUN_mesh_array", GLEW_SUN_mesh_array, glewGetExtension("GL_SUN_mesh_array"));
}

#endif /* GL_SUN_mesh_array */

/* ------------------------ GL_SUN_read_video_pixels ----------------------- */

#ifdef GL_SUN_read_video_pixels

static void _glewInfo_GL_SUN_read_video_pixels (void)
{
  glewPrintExt("GL_SUN_read_video_pixels", GLEW_SUN_read_video_pixels, glewGetExtension("GL_SUN_read_video_pixels"));

  glewInfoFunc("glReadVideoPixelsSUN", glReadVideoPixelsSUN == NULL);
}

#endif /* GL_SUN_read_video_pixels */

/* --------------------------- GL_SUN_slice_accum -------------------------- */

#ifdef GL_SUN_slice_accum

static void _glewInfo_GL_SUN_slice_accum (void)
{
  glewPrintExt("GL_SUN_slice_accum", GLEW_SUN_slice_accum, glewGetExtension("GL_SUN_slice_accum"));
}

#endif /* GL_SUN_slice_accum */

/* -------------------------- GL_SUN_triangle_list ------------------------- */

#ifdef GL_SUN_triangle_list

static void _glewInfo_GL_SUN_triangle_list (void)
{
  glewPrintExt("GL_SUN_triangle_list", GLEW_SUN_triangle_list, glewGetExtension("GL_SUN_triangle_list"));

  glewInfoFunc("glReplacementCodePointerSUN", glReplacementCodePointerSUN == NULL);
  glewInfoFunc("glReplacementCodeubSUN", glReplacementCodeubSUN == NULL);
  glewInfoFunc("glReplacementCodeubvSUN", glReplacementCodeubvSUN == NULL);
  glewInfoFunc("glReplacementCodeuiSUN", glReplacementCodeuiSUN == NULL);
  glewInfoFunc("glReplacementCodeuivSUN", glReplacementCodeuivSUN == NULL);
  glewInfoFunc("glReplacementCodeusSUN", glReplacementCodeusSUN == NULL);
  glewInfoFunc("glReplacementCodeusvSUN", glReplacementCodeusvSUN == NULL);
}

#endif /* GL_SUN_triangle_list */

/* ----------------------------- GL_SUN_vertex ----------------------------- */

#ifdef GL_SUN_vertex

static void _glewInfo_GL_SUN_vertex (void)
{
  glewPrintExt("GL_SUN_vertex", GLEW_SUN_vertex, glewGetExtension("GL_SUN_vertex"));

  glewInfoFunc("glColor3fVertex3fSUN", glColor3fVertex3fSUN == NULL);
  glewInfoFunc("glColor3fVertex3fvSUN", glColor3fVertex3fvSUN == NULL);
  glewInfoFunc("glColor4fNormal3fVertex3fSUN", glColor4fNormal3fVertex3fSUN == NULL);
  glewInfoFunc("glColor4fNormal3fVertex3fvSUN", glColor4fNormal3fVertex3fvSUN == NULL);
  glewInfoFunc("glColor4ubVertex2fSUN", glColor4ubVertex2fSUN == NULL);
  glewInfoFunc("glColor4ubVertex2fvSUN", glColor4ubVertex2fvSUN == NULL);
  glewInfoFunc("glColor4ubVertex3fSUN", glColor4ubVertex3fSUN == NULL);
  glewInfoFunc("glColor4ubVertex3fvSUN", glColor4ubVertex3fvSUN == NULL);
  glewInfoFunc("glNormal3fVertex3fSUN", glNormal3fVertex3fSUN == NULL);
  glewInfoFunc("glNormal3fVertex3fvSUN", glNormal3fVertex3fvSUN == NULL);
  glewInfoFunc("glReplacementCodeuiColor3fVertex3fSUN", glReplacementCodeuiColor3fVertex3fSUN == NULL);
  glewInfoFunc("glReplacementCodeuiColor3fVertex3fvSUN", glReplacementCodeuiColor3fVertex3fvSUN == NULL);
  glewInfoFunc("glReplacementCodeuiColor4fNormal3fVertex3fSUN", glReplacementCodeuiColor4fNormal3fVertex3fSUN == NULL);
  glewInfoFunc("glReplacementCodeuiColor4fNormal3fVertex3fvSUN", glReplacementCodeuiColor4fNormal3fVertex3fvSUN == NULL);
  glewInfoFunc("glReplacementCodeuiColor4ubVertex3fSUN", glReplacementCodeuiColor4ubVertex3fSUN == NULL);
  glewInfoFunc("glReplacementCodeuiColor4ubVertex3fvSUN", glReplacementCodeuiColor4ubVertex3fvSUN == NULL);
  glewInfoFunc("glReplacementCodeuiNormal3fVertex3fSUN", glReplacementCodeuiNormal3fVertex3fSUN == NULL);
  glewInfoFunc("glReplacementCodeuiNormal3fVertex3fvSUN", glReplacementCodeuiNormal3fVertex3fvSUN == NULL);
  glewInfoFunc("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN", glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN == NULL);
  glewInfoFunc("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN", glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN == NULL);
  glewInfoFunc("glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN", glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN == NULL);
  glewInfoFunc("glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN", glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN == NULL);
  glewInfoFunc("glReplacementCodeuiTexCoord2fVertex3fSUN", glReplacementCodeuiTexCoord2fVertex3fSUN == NULL);
  glewInfoFunc("glReplacementCodeuiTexCoord2fVertex3fvSUN", glReplacementCodeuiTexCoord2fVertex3fvSUN == NULL);
  glewInfoFunc("glReplacementCodeuiVertex3fSUN", glReplacementCodeuiVertex3fSUN == NULL);
  glewInfoFunc("glReplacementCodeuiVertex3fvSUN", glReplacementCodeuiVertex3fvSUN == NULL);
  glewInfoFunc("glTexCoord2fColor3fVertex3fSUN", glTexCoord2fColor3fVertex3fSUN == NULL);
  glewInfoFunc("glTexCoord2fColor3fVertex3fvSUN", glTexCoord2fColor3fVertex3fvSUN == NULL);
  glewInfoFunc("glTexCoord2fColor4fNormal3fVertex3fSUN", glTexCoord2fColor4fNormal3fVertex3fSUN == NULL);
  glewInfoFunc("glTexCoord2fColor4fNormal3fVertex3fvSUN", glTexCoord2fColor4fNormal3fVertex3fvSUN == NULL);
  glewInfoFunc("glTexCoord2fColor4ubVertex3fSUN", glTexCoord2fColor4ubVertex3fSUN == NULL);
  glewInfoFunc("glTexCoord2fColor4ubVertex3fvSUN", glTexCoord2fColor4ubVertex3fvSUN == NULL);
  glewInfoFunc("glTexCoord2fNormal3fVertex3fSUN", glTexCoord2fNormal3fVertex3fSUN == NULL);
  glewInfoFunc("glTexCoord2fNormal3fVertex3fvSUN", glTexCoord2fNormal3fVertex3fvSUN == NULL);
  glewInfoFunc("glTexCoord2fVertex3fSUN", glTexCoord2fVertex3fSUN == NULL);
  glewInfoFunc("glTexCoord2fVertex3fvSUN", glTexCoord2fVertex3fvSUN == NULL);
  glewInfoFunc("glTexCoord4fColor4fNormal3fVertex4fSUN", glTexCoord4fColor4fNormal3fVertex4fSUN == NULL);
  glewInfoFunc("glTexCoord4fColor4fNormal3fVertex4fvSUN", glTexCoord4fColor4fNormal3fVertex4fvSUN == NULL);
  glewInfoFunc("glTexCoord4fVertex4fSUN", glTexCoord4fVertex4fSUN == NULL);
  glewInfoFunc("glTexCoord4fVertex4fvSUN", glTexCoord4fVertex4fvSUN == NULL);
}

#endif /* GL_SUN_vertex */

/* -------------------------- GL_WIN_phong_shading ------------------------- */

#ifdef GL_WIN_phong_shading

static void _glewInfo_GL_WIN_phong_shading (void)
{
  glewPrintExt("GL_WIN_phong_shading", GLEW_WIN_phong_shading, glewGetExtension("GL_WIN_phong_shading"));
}

#endif /* GL_WIN_phong_shading */

/* -------------------------- GL_WIN_specular_fog -------------------------- */

#ifdef GL_WIN_specular_fog

static void _glewInfo_GL_WIN_specular_fog (void)
{
  glewPrintExt("GL_WIN_specular_fog", GLEW_WIN_specular_fog, glewGetExtension("GL_WIN_specular_fog"));
}

#endif /* GL_WIN_specular_fog */

/* ---------------------------- GL_WIN_swap_hint --------------------------- */

#ifdef GL_WIN_swap_hint

static void _glewInfo_GL_WIN_swap_hint (void)
{
  glewPrintExt("GL_WIN_swap_hint", GLEW_WIN_swap_hint, glewGetExtension("GL_WIN_swap_hint"));

  glewInfoFunc("glAddSwapHintRectWIN", glAddSwapHintRectWIN == NULL);
}

#endif /* GL_WIN_swap_hint */

#ifdef _WIN32

/* -------------------------- WGL_3DFX_multisample ------------------------- */

#ifdef WGL_3DFX_multisample

static void _glewInfo_WGL_3DFX_multisample (void)
{
  glewPrintExt("WGL_3DFX_multisample", WGLEW_3DFX_multisample, wglewGetExtension("WGL_3DFX_multisample"));
}

#endif /* WGL_3DFX_multisample */

/* ------------------------- WGL_ARB_buffer_region ------------------------- */

#ifdef WGL_ARB_buffer_region

static void _glewInfo_WGL_ARB_buffer_region (void)
{
  glewPrintExt("WGL_ARB_buffer_region", WGLEW_ARB_buffer_region, wglewGetExtension("WGL_ARB_buffer_region"));

  glewInfoFunc("wglCreateBufferRegionARB", wglCreateBufferRegionARB == NULL);
  glewInfoFunc("wglDeleteBufferRegionARB", wglDeleteBufferRegionARB == NULL);
  glewInfoFunc("wglRestoreBufferRegionARB", wglRestoreBufferRegionARB == NULL);
  glewInfoFunc("wglSaveBufferRegionARB", wglSaveBufferRegionARB == NULL);
}

#endif /* WGL_ARB_buffer_region */

/* ----------------------- WGL_ARB_extensions_string ----------------------- */

#ifdef WGL_ARB_extensions_string

static void _glewInfo_WGL_ARB_extensions_string (void)
{
  glewPrintExt("WGL_ARB_extensions_string", WGLEW_ARB_extensions_string, wglewGetExtension("WGL_ARB_extensions_string"));

  glewInfoFunc("wglGetExtensionsStringARB", wglGetExtensionsStringARB == NULL);
}

#endif /* WGL_ARB_extensions_string */

/* ----------------------- WGL_ARB_make_current_read ----------------------- */

#ifdef WGL_ARB_make_current_read

static void _glewInfo_WGL_ARB_make_current_read (void)
{
  glewPrintExt("WGL_ARB_make_current_read", WGLEW_ARB_make_current_read, wglewGetExtension("WGL_ARB_make_current_read"));

  glewInfoFunc("wglGetCurrentReadDCARB", wglGetCurrentReadDCARB == NULL);
  glewInfoFunc("wglMakeContextCurrentARB", wglMakeContextCurrentARB == NULL);
}

#endif /* WGL_ARB_make_current_read */

/* -------------------------- WGL_ARB_multisample -------------------------- */

#ifdef WGL_ARB_multisample

static void _glewInfo_WGL_ARB_multisample (void)
{
  glewPrintExt("WGL_ARB_multisample", WGLEW_ARB_multisample, wglewGetExtension("WGL_ARB_multisample"));
}

#endif /* WGL_ARB_multisample */

/* ---------------------------- WGL_ARB_pbuffer ---------------------------- */

#ifdef WGL_ARB_pbuffer

static void _glewInfo_WGL_ARB_pbuffer (void)
{
  glewPrintExt("WGL_ARB_pbuffer", WGLEW_ARB_pbuffer, wglewGetExtension("WGL_ARB_pbuffer"));

  glewInfoFunc("wglCreatePbufferARB", wglCreatePbufferARB == NULL);
  glewInfoFunc("wglDestroyPbufferARB", wglDestroyPbufferARB == NULL);
  glewInfoFunc("wglGetPbufferDCARB", wglGetPbufferDCARB == NULL);
  glewInfoFunc("wglQueryPbufferARB", wglQueryPbufferARB == NULL);
  glewInfoFunc("wglReleasePbufferDCARB", wglReleasePbufferDCARB == NULL);
}

#endif /* WGL_ARB_pbuffer */

/* -------------------------- WGL_ARB_pixel_format ------------------------- */

#ifdef WGL_ARB_pixel_format

static void _glewInfo_WGL_ARB_pixel_format (void)
{
  glewPrintExt("WGL_ARB_pixel_format", WGLEW_ARB_pixel_format, wglewGetExtension("WGL_ARB_pixel_format"));

  glewInfoFunc("wglChoosePixelFormatARB", wglChoosePixelFormatARB == NULL);
  glewInfoFunc("wglGetPixelFormatAttribfvARB", wglGetPixelFormatAttribfvARB == NULL);
  glewInfoFunc("wglGetPixelFormatAttribivARB", wglGetPixelFormatAttribivARB == NULL);
}

#endif /* WGL_ARB_pixel_format */

/* ------------------------- WGL_ARB_render_texture ------------------------ */

#ifdef WGL_ARB_render_texture

static void _glewInfo_WGL_ARB_render_texture (void)
{
  glewPrintExt("WGL_ARB_render_texture", WGLEW_ARB_render_texture, wglewGetExtension("WGL_ARB_render_texture"));

  glewInfoFunc("wglBindTexImageARB", wglBindTexImageARB == NULL);
  glewInfoFunc("wglReleaseTexImageARB", wglReleaseTexImageARB == NULL);
  glewInfoFunc("wglSetPbufferAttribARB", wglSetPbufferAttribARB == NULL);
}

#endif /* WGL_ARB_render_texture */

/* ----------------------- WGL_ATI_pixel_format_float ---------------------- */

#ifdef WGL_ATI_pixel_format_float

static void _glewInfo_WGL_ATI_pixel_format_float (void)
{
  glewPrintExt("WGL_ATI_pixel_format_float", WGLEW_ATI_pixel_format_float, wglewGetExtension("WGL_ATI_pixel_format_float"));
}

#endif /* WGL_ATI_pixel_format_float */

/* -------------------------- WGL_EXT_depth_float -------------------------- */

#ifdef WGL_EXT_depth_float

static void _glewInfo_WGL_EXT_depth_float (void)
{
  glewPrintExt("WGL_EXT_depth_float", WGLEW_EXT_depth_float, wglewGetExtension("WGL_EXT_depth_float"));
}

#endif /* WGL_EXT_depth_float */

/* ---------------------- WGL_EXT_display_color_table ---------------------- */

#ifdef WGL_EXT_display_color_table

static void _glewInfo_WGL_EXT_display_color_table (void)
{
  glewPrintExt("WGL_EXT_display_color_table", WGLEW_EXT_display_color_table, wglewGetExtension("WGL_EXT_display_color_table"));

  glewInfoFunc("wglBindDisplayColorTableEXT", wglBindDisplayColorTableEXT == NULL);
  glewInfoFunc("wglCreateDisplayColorTableEXT", wglCreateDisplayColorTableEXT == NULL);
  glewInfoFunc("wglDestroyDisplayColorTableEXT", wglDestroyDisplayColorTableEXT == NULL);
  glewInfoFunc("wglLoadDisplayColorTableEXT", wglLoadDisplayColorTableEXT == NULL);
}

#endif /* WGL_EXT_display_color_table */

/* ----------------------- WGL_EXT_extensions_string ----------------------- */

#ifdef WGL_EXT_extensions_string

static void _glewInfo_WGL_EXT_extensions_string (void)
{
  glewPrintExt("WGL_EXT_extensions_string", WGLEW_EXT_extensions_string, wglewGetExtension("WGL_EXT_extensions_string"));

  glewInfoFunc("wglGetExtensionsStringEXT", wglGetExtensionsStringEXT == NULL);
}

#endif /* WGL_EXT_extensions_string */

/* ----------------------- WGL_EXT_make_current_read ----------------------- */

#ifdef WGL_EXT_make_current_read

static void _glewInfo_WGL_EXT_make_current_read (void)
{
  glewPrintExt("WGL_EXT_make_current_read", WGLEW_EXT_make_current_read, wglewGetExtension("WGL_EXT_make_current_read"));

  glewInfoFunc("wglGetCurrentReadDCEXT", wglGetCurrentReadDCEXT == NULL);
  glewInfoFunc("wglMakeContextCurrentEXT", wglMakeContextCurrentEXT == NULL);
}

#endif /* WGL_EXT_make_current_read */

/* -------------------------- WGL_EXT_multisample -------------------------- */

#ifdef WGL_EXT_multisample

static void _glewInfo_WGL_EXT_multisample (void)
{
  glewPrintExt("WGL_EXT_multisample", WGLEW_EXT_multisample, wglewGetExtension("WGL_EXT_multisample"));
}

#endif /* WGL_EXT_multisample */

/* ---------------------------- WGL_EXT_pbuffer ---------------------------- */

#ifdef WGL_EXT_pbuffer

static void _glewInfo_WGL_EXT_pbuffer (void)
{
  glewPrintExt("WGL_EXT_pbuffer", WGLEW_EXT_pbuffer, wglewGetExtension("WGL_EXT_pbuffer"));

  glewInfoFunc("wglCreatePbufferEXT", wglCreatePbufferEXT == NULL);
  glewInfoFunc("wglDestroyPbufferEXT", wglDestroyPbufferEXT == NULL);
  glewInfoFunc("wglGetPbufferDCEXT", wglGetPbufferDCEXT == NULL);
  glewInfoFunc("wglQueryPbufferEXT", wglQueryPbufferEXT == NULL);
  glewInfoFunc("wglReleasePbufferDCEXT", wglReleasePbufferDCEXT == NULL);
}

#endif /* WGL_EXT_pbuffer */

/* -------------------------- WGL_EXT_pixel_format ------------------------- */

#ifdef WGL_EXT_pixel_format

static void _glewInfo_WGL_EXT_pixel_format (void)
{
  glewPrintExt("WGL_EXT_pixel_format", WGLEW_EXT_pixel_format, wglewGetExtension("WGL_EXT_pixel_format"));

  glewInfoFunc("wglChoosePixelFormatEXT", wglChoosePixelFormatEXT == NULL);
  glewInfoFunc("wglGetPixelFormatAttribfvEXT", wglGetPixelFormatAttribfvEXT == NULL);
  glewInfoFunc("wglGetPixelFormatAttribivEXT", wglGetPixelFormatAttribivEXT == NULL);
}

#endif /* WGL_EXT_pixel_format */

/* -------------------------- WGL_EXT_swap_control ------------------------- */

#ifdef WGL_EXT_swap_control

static void _glewInfo_WGL_EXT_swap_control (void)
{
  glewPrintExt("WGL_EXT_swap_control", WGLEW_EXT_swap_control, wglewGetExtension("WGL_EXT_swap_control"));

  glewInfoFunc("wglGetSwapIntervalEXT", wglGetSwapIntervalEXT == NULL);
  glewInfoFunc("wglSwapIntervalEXT", wglSwapIntervalEXT == NULL);
}

#endif /* WGL_EXT_swap_control */

/* --------------------- WGL_I3D_digital_video_control --------------------- */

#ifdef WGL_I3D_digital_video_control

static void _glewInfo_WGL_I3D_digital_video_control (void)
{
  glewPrintExt("WGL_I3D_digital_video_control", WGLEW_I3D_digital_video_control, wglewGetExtension("WGL_I3D_digital_video_control"));

  glewInfoFunc("wglGetDigitalVideoParametersI3D", wglGetDigitalVideoParametersI3D == NULL);
  glewInfoFunc("wglSetDigitalVideoParametersI3D", wglSetDigitalVideoParametersI3D == NULL);
}

#endif /* WGL_I3D_digital_video_control */

/* ----------------------------- WGL_I3D_gamma ----------------------------- */

#ifdef WGL_I3D_gamma

static void _glewInfo_WGL_I3D_gamma (void)
{
  glewPrintExt("WGL_I3D_gamma", WGLEW_I3D_gamma, wglewGetExtension("WGL_I3D_gamma"));

  glewInfoFunc("wglGetGammaTableI3D", wglGetGammaTableI3D == NULL);
  glewInfoFunc("wglGetGammaTableParametersI3D", wglGetGammaTableParametersI3D == NULL);
  glewInfoFunc("wglSetGammaTableI3D", wglSetGammaTableI3D == NULL);
  glewInfoFunc("wglSetGammaTableParametersI3D", wglSetGammaTableParametersI3D == NULL);
}

#endif /* WGL_I3D_gamma */

/* ---------------------------- WGL_I3D_genlock ---------------------------- */

#ifdef WGL_I3D_genlock

static void _glewInfo_WGL_I3D_genlock (void)
{
  glewPrintExt("WGL_I3D_genlock", WGLEW_I3D_genlock, wglewGetExtension("WGL_I3D_genlock"));

  glewInfoFunc("wglDisableGenlockI3D", wglDisableGenlockI3D == NULL);
  glewInfoFunc("wglEnableGenlockI3D", wglEnableGenlockI3D == NULL);
  glewInfoFunc("wglGenlockSampleRateI3D", wglGenlockSampleRateI3D == NULL);
  glewInfoFunc("wglGenlockSourceDelayI3D", wglGenlockSourceDelayI3D == NULL);
  glewInfoFunc("wglGenlockSourceEdgeI3D", wglGenlockSourceEdgeI3D == NULL);
  glewInfoFunc("wglGenlockSourceI3D", wglGenlockSourceI3D == NULL);
  glewInfoFunc("wglGetGenlockSampleRateI3D", wglGetGenlockSampleRateI3D == NULL);
  glewInfoFunc("wglGetGenlockSourceDelayI3D", wglGetGenlockSourceDelayI3D == NULL);
  glewInfoFunc("wglGetGenlockSourceEdgeI3D", wglGetGenlockSourceEdgeI3D == NULL);
  glewInfoFunc("wglGetGenlockSourceI3D", wglGetGenlockSourceI3D == NULL);
  glewInfoFunc("wglIsEnabledGenlockI3D", wglIsEnabledGenlockI3D == NULL);
  glewInfoFunc("wglQueryGenlockMaxSourceDelayI3D", wglQueryGenlockMaxSourceDelayI3D == NULL);
}

#endif /* WGL_I3D_genlock */

/* -------------------------- WGL_I3D_image_buffer ------------------------- */

#ifdef WGL_I3D_image_buffer

static void _glewInfo_WGL_I3D_image_buffer (void)
{
  glewPrintExt("WGL_I3D_image_buffer", WGLEW_I3D_image_buffer, wglewGetExtension("WGL_I3D_image_buffer"));

  glewInfoFunc("wglAssociateImageBufferEventsI3D", wglAssociateImageBufferEventsI3D == NULL);
  glewInfoFunc("wglCreateImageBufferI3D", wglCreateImageBufferI3D == NULL);
  glewInfoFunc("wglDestroyImageBufferI3D", wglDestroyImageBufferI3D == NULL);
  glewInfoFunc("wglReleaseImageBufferEventsI3D", wglReleaseImageBufferEventsI3D == NULL);
}

#endif /* WGL_I3D_image_buffer */

/* ------------------------ WGL_I3D_swap_frame_lock ------------------------ */

#ifdef WGL_I3D_swap_frame_lock

static void _glewInfo_WGL_I3D_swap_frame_lock (void)
{
  glewPrintExt("WGL_I3D_swap_frame_lock", WGLEW_I3D_swap_frame_lock, wglewGetExtension("WGL_I3D_swap_frame_lock"));

  glewInfoFunc("wglDisableFrameLockI3D", wglDisableFrameLockI3D == NULL);
  glewInfoFunc("wglEnableFrameLockI3D", wglEnableFrameLockI3D == NULL);
  glewInfoFunc("wglIsEnabledFrameLockI3D", wglIsEnabledFrameLockI3D == NULL);
  glewInfoFunc("wglQueryFrameLockMasterI3D", wglQueryFrameLockMasterI3D == NULL);
}

#endif /* WGL_I3D_swap_frame_lock */

/* ------------------------ WGL_I3D_swap_frame_usage ----------------------- */

#ifdef WGL_I3D_swap_frame_usage

static void _glewInfo_WGL_I3D_swap_frame_usage (void)
{
  glewPrintExt("WGL_I3D_swap_frame_usage", WGLEW_I3D_swap_frame_usage, wglewGetExtension("WGL_I3D_swap_frame_usage"));

  glewInfoFunc("wglBeginFrameTrackingI3D", wglBeginFrameTrackingI3D == NULL);
  glewInfoFunc("wglEndFrameTrackingI3D", wglEndFrameTrackingI3D == NULL);
  glewInfoFunc("wglGetFrameUsageI3D", wglGetFrameUsageI3D == NULL);
  glewInfoFunc("wglQueryFrameTrackingI3D", wglQueryFrameTrackingI3D == NULL);
}

#endif /* WGL_I3D_swap_frame_usage */

/* -------------------------- WGL_NV_float_buffer -------------------------- */

#ifdef WGL_NV_float_buffer

static void _glewInfo_WGL_NV_float_buffer (void)
{
  glewPrintExt("WGL_NV_float_buffer", WGLEW_NV_float_buffer, wglewGetExtension("WGL_NV_float_buffer"));
}

#endif /* WGL_NV_float_buffer */

/* ---------------------- WGL_NV_render_depth_texture ---------------------- */

#ifdef WGL_NV_render_depth_texture

static void _glewInfo_WGL_NV_render_depth_texture (void)
{
  glewPrintExt("WGL_NV_render_depth_texture", WGLEW_NV_render_depth_texture, wglewGetExtension("WGL_NV_render_depth_texture"));
}

#endif /* WGL_NV_render_depth_texture */

/* -------------------- WGL_NV_render_texture_rectangle -------------------- */

#ifdef WGL_NV_render_texture_rectangle

static void _glewInfo_WGL_NV_render_texture_rectangle (void)
{
  glewPrintExt("WGL_NV_render_texture_rectangle", WGLEW_NV_render_texture_rectangle, wglewGetExtension("WGL_NV_render_texture_rectangle"));
}

#endif /* WGL_NV_render_texture_rectangle */

/* ----------------------- WGL_NV_vertex_array_range ----------------------- */

#ifdef WGL_NV_vertex_array_range

static void _glewInfo_WGL_NV_vertex_array_range (void)
{
  glewPrintExt("WGL_NV_vertex_array_range", WGLEW_NV_vertex_array_range, wglewGetExtension("WGL_NV_vertex_array_range"));

  glewInfoFunc("wglAllocateMemoryNV", wglAllocateMemoryNV == NULL);
  glewInfoFunc("wglFreeMemoryNV", wglFreeMemoryNV == NULL);
}

#endif /* WGL_NV_vertex_array_range */

/* -------------------------- WGL_OML_sync_control ------------------------- */

#ifdef WGL_OML_sync_control

static void _glewInfo_WGL_OML_sync_control (void)
{
  glewPrintExt("WGL_OML_sync_control", WGLEW_OML_sync_control, wglewGetExtension("WGL_OML_sync_control"));

  glewInfoFunc("wglGetMscRateOML", wglGetMscRateOML == NULL);
  glewInfoFunc("wglGetSyncValuesOML", wglGetSyncValuesOML == NULL);
  glewInfoFunc("wglSwapBuffersMscOML", wglSwapBuffersMscOML == NULL);
  glewInfoFunc("wglSwapLayerBuffersMscOML", wglSwapLayerBuffersMscOML == NULL);
  glewInfoFunc("wglWaitForMscOML", wglWaitForMscOML == NULL);
  glewInfoFunc("wglWaitForSbcOML", wglWaitForSbcOML == NULL);
}

#endif /* WGL_OML_sync_control */

#else /* _UNIX */

/* ---------------------------- GLX_VERSION_1_2 ---------------------------- */

#ifdef GLX_VERSION_1_2

static void _glewInfo_GLX_VERSION_1_2 (void)
{
  glewPrintExt("GLX_VERSION_1_2", GLXEW_VERSION_1_2, GLXEW_VERSION_1_2);

  glewInfoFunc("glXGetCurrentDisplay", glXGetCurrentDisplay == NULL);
}

#endif /* GLX_VERSION_1_2 */

/* ---------------------------- GLX_VERSION_1_3 ---------------------------- */

#ifdef GLX_VERSION_1_3

static void _glewInfo_GLX_VERSION_1_3 (void)
{
  glewPrintExt("GLX_VERSION_1_3", GLXEW_VERSION_1_3, GLXEW_VERSION_1_3);

  glewInfoFunc("glXChooseFBConfig", glXChooseFBConfig == NULL);
  glewInfoFunc("glXCreateNewContext", glXCreateNewContext == NULL);
  glewInfoFunc("glXCreatePbuffer", glXCreatePbuffer == NULL);
  glewInfoFunc("glXCreatePixmap", glXCreatePixmap == NULL);
  glewInfoFunc("glXCreateWindow", glXCreateWindow == NULL);
  glewInfoFunc("glXDestroyPbuffer", glXDestroyPbuffer == NULL);
  glewInfoFunc("glXDestroyPixmap", glXDestroyPixmap == NULL);
  glewInfoFunc("glXDestroyWindow", glXDestroyWindow == NULL);
  glewInfoFunc("glXGetCurrentReadDrawable", glXGetCurrentReadDrawable == NULL);
  glewInfoFunc("glXGetFBConfigAttrib", glXGetFBConfigAttrib == NULL);
  glewInfoFunc("glXGetFBConfigs", glXGetFBConfigs == NULL);
  glewInfoFunc("glXGetSelectedEvent", glXGetSelectedEvent == NULL);
  glewInfoFunc("glXGetVisualFromFBConfig", glXGetVisualFromFBConfig == NULL);
  glewInfoFunc("glXMakeContextCurrent", glXMakeContextCurrent == NULL);
  glewInfoFunc("glXQueryContext", glXQueryContext == NULL);
  glewInfoFunc("glXQueryDrawable", glXQueryDrawable == NULL);
  glewInfoFunc("glXSelectEvent", glXSelectEvent == NULL);
}

#endif /* GLX_VERSION_1_3 */

/* ---------------------------- GLX_VERSION_1_4 ---------------------------- */

#ifdef GLX_VERSION_1_4

static void _glewInfo_GLX_VERSION_1_4 (void)
{
  glewPrintExt("GLX_VERSION_1_4", GLXEW_VERSION_1_4, GLXEW_VERSION_1_4);
}

#endif /* GLX_VERSION_1_4 */

/* -------------------------- GLX_3DFX_multisample ------------------------- */

#ifdef GLX_3DFX_multisample

static void _glewInfo_GLX_3DFX_multisample (void)
{
  glewPrintExt("GLX_3DFX_multisample", GLXEW_3DFX_multisample, glxewGetExtension("GLX_3DFX_multisample"));
}

#endif /* GLX_3DFX_multisample */

/* ------------------------ GLX_ARB_get_proc_address ----------------------- */

#ifdef GLX_ARB_get_proc_address

static void _glewInfo_GLX_ARB_get_proc_address (void)
{
  glewPrintExt("GLX_ARB_get_proc_address", GLXEW_ARB_get_proc_address, glxewGetExtension("GLX_ARB_get_proc_address"));
}

#endif /* GLX_ARB_get_proc_address */

/* -------------------------- GLX_ARB_multisample -------------------------- */

#ifdef GLX_ARB_multisample

static void _glewInfo_GLX_ARB_multisample (void)
{
  glewPrintExt("GLX_ARB_multisample", GLXEW_ARB_multisample, glxewGetExtension("GLX_ARB_multisample"));
}

#endif /* GLX_ARB_multisample */

/* ----------------------- GLX_ATI_pixel_format_float ---------------------- */

#ifdef GLX_ATI_pixel_format_float

static void _glewInfo_GLX_ATI_pixel_format_float (void)
{
  glewPrintExt("GLX_ATI_pixel_format_float", GLXEW_ATI_pixel_format_float, glxewGetExtension("GLX_ATI_pixel_format_float"));
}

#endif /* GLX_ATI_pixel_format_float */

/* ------------------------- GLX_ATI_render_texture ------------------------ */

#ifdef GLX_ATI_render_texture

static void _glewInfo_GLX_ATI_render_texture (void)
{
  glewPrintExt("GLX_ATI_render_texture", GLXEW_ATI_render_texture, glxewGetExtension("GLX_ATI_render_texture"));

  glewInfoFunc("glXBindTexImageATI", glXBindTexImageATI == NULL);
  glewInfoFunc("glXDrawableAttribATI", glXDrawableAttribATI == NULL);
  glewInfoFunc("glXReleaseTexImageATI", glXReleaseTexImageATI == NULL);
}

#endif /* GLX_ATI_render_texture */

/* ------------------------- GLX_EXT_import_context ------------------------ */

#ifdef GLX_EXT_import_context

static void _glewInfo_GLX_EXT_import_context (void)
{
  glewPrintExt("GLX_EXT_import_context", GLXEW_EXT_import_context, glxewGetExtension("GLX_EXT_import_context"));

  glewInfoFunc("glXFreeContextEXT", glXFreeContextEXT == NULL);
  glewInfoFunc("glXGetContextIDEXT", glXGetContextIDEXT == NULL);
  glewInfoFunc("glXImportContextEXT", glXImportContextEXT == NULL);
  glewInfoFunc("glXQueryContextInfoEXT", glXQueryContextInfoEXT == NULL);
}

#endif /* GLX_EXT_import_context */

/* -------------------------- GLX_EXT_scene_marker ------------------------- */

#ifdef GLX_EXT_scene_marker

static void _glewInfo_GLX_EXT_scene_marker (void)
{
  glewPrintExt("GLX_EXT_scene_marker", GLXEW_EXT_scene_marker, glxewGetExtension("GLX_EXT_scene_marker"));
}

#endif /* GLX_EXT_scene_marker */

/* -------------------------- GLX_EXT_visual_info -------------------------- */

#ifdef GLX_EXT_visual_info

static void _glewInfo_GLX_EXT_visual_info (void)
{
  glewPrintExt("GLX_EXT_visual_info", GLXEW_EXT_visual_info, glxewGetExtension("GLX_EXT_visual_info"));
}

#endif /* GLX_EXT_visual_info */

/* ------------------------- GLX_EXT_visual_rating ------------------------- */

#ifdef GLX_EXT_visual_rating

static void _glewInfo_GLX_EXT_visual_rating (void)
{
  glewPrintExt("GLX_EXT_visual_rating", GLXEW_EXT_visual_rating, glxewGetExtension("GLX_EXT_visual_rating"));
}

#endif /* GLX_EXT_visual_rating */

/* -------------------------- GLX_MESA_agp_offset -------------------------- */

#ifdef GLX_MESA_agp_offset

static void _glewInfo_GLX_MESA_agp_offset (void)
{
  glewPrintExt("GLX_MESA_agp_offset", GLXEW_MESA_agp_offset, glxewGetExtension("GLX_MESA_agp_offset"));

  glewInfoFunc("glXGetAGPOffsetMESA", glXGetAGPOffsetMESA == NULL);
}

#endif /* GLX_MESA_agp_offset */

/* ------------------------ GLX_MESA_copy_sub_buffer ----------------------- */

#ifdef GLX_MESA_copy_sub_buffer

static void _glewInfo_GLX_MESA_copy_sub_buffer (void)
{
  glewPrintExt("GLX_MESA_copy_sub_buffer", GLXEW_MESA_copy_sub_buffer, glxewGetExtension("GLX_MESA_copy_sub_buffer"));

  glewInfoFunc("glXCopySubBufferMESA", glXCopySubBufferMESA == NULL);
}

#endif /* GLX_MESA_copy_sub_buffer */

/* ------------------------ GLX_MESA_pixmap_colormap ----------------------- */

#ifdef GLX_MESA_pixmap_colormap

static void _glewInfo_GLX_MESA_pixmap_colormap (void)
{
  glewPrintExt("GLX_MESA_pixmap_colormap", GLXEW_MESA_pixmap_colormap, glxewGetExtension("GLX_MESA_pixmap_colormap"));

  glewInfoFunc("glXCreateGLXPixmapMESA", glXCreateGLXPixmapMESA == NULL);
}

#endif /* GLX_MESA_pixmap_colormap */

/* ------------------------ GLX_MESA_release_buffers ----------------------- */

#ifdef GLX_MESA_release_buffers

static void _glewInfo_GLX_MESA_release_buffers (void)
{
  glewPrintExt("GLX_MESA_release_buffers", GLXEW_MESA_release_buffers, glxewGetExtension("GLX_MESA_release_buffers"));

  glewInfoFunc("glXReleaseBuffersMESA", glXReleaseBuffersMESA == NULL);
}

#endif /* GLX_MESA_release_buffers */

/* ------------------------- GLX_MESA_set_3dfx_mode ------------------------ */

#ifdef GLX_MESA_set_3dfx_mode

static void _glewInfo_GLX_MESA_set_3dfx_mode (void)
{
  glewPrintExt("GLX_MESA_set_3dfx_mode", GLXEW_MESA_set_3dfx_mode, glxewGetExtension("GLX_MESA_set_3dfx_mode"));

  glewInfoFunc("glXSet3DfxModeMESA", glXSet3DfxModeMESA == NULL);
}

#endif /* GLX_MESA_set_3dfx_mode */

/* -------------------------- GLX_NV_float_buffer -------------------------- */

#ifdef GLX_NV_float_buffer

static void _glewInfo_GLX_NV_float_buffer (void)
{
  glewPrintExt("GLX_NV_float_buffer", GLXEW_NV_float_buffer, glxewGetExtension("GLX_NV_float_buffer"));
}

#endif /* GLX_NV_float_buffer */

/* ----------------------- GLX_NV_vertex_array_range ----------------------- */

#ifdef GLX_NV_vertex_array_range

static void _glewInfo_GLX_NV_vertex_array_range (void)
{
  glewPrintExt("GLX_NV_vertex_array_range", GLXEW_NV_vertex_array_range, glxewGetExtension("GLX_NV_vertex_array_range"));

  glewInfoFunc("glXAllocateMemoryNV", glXAllocateMemoryNV == NULL);
  glewInfoFunc("glXFreeMemoryNV", glXFreeMemoryNV == NULL);
}

#endif /* GLX_NV_vertex_array_range */

/* -------------------------- GLX_OML_swap_method -------------------------- */

#ifdef GLX_OML_swap_method

static void _glewInfo_GLX_OML_swap_method (void)
{
  glewPrintExt("GLX_OML_swap_method", GLXEW_OML_swap_method, glxewGetExtension("GLX_OML_swap_method"));
}

#endif /* GLX_OML_swap_method */

/* -------------------------- GLX_OML_sync_control ------------------------- */

#if defined(GLX_OML_sync_control) && defined(__STDC_VERSION__) && (__STDC_VERSION__ >= 199901L)
#include <inttypes.h>

static void _glewInfo_GLX_OML_sync_control (void)
{
  glewPrintExt("GLX_OML_sync_control", GLXEW_OML_sync_control, glxewGetExtension("GLX_OML_sync_control"));

  glewInfoFunc("glXGetMscRateOML", glXGetMscRateOML == NULL);
  glewInfoFunc("glXGetSyncValuesOML", glXGetSyncValuesOML == NULL);
  glewInfoFunc("glXSwapBuffersMscOML", glXSwapBuffersMscOML == NULL);
  glewInfoFunc("glXWaitForMscOML", glXWaitForMscOML == NULL);
  glewInfoFunc("glXWaitForSbcOML", glXWaitForSbcOML == NULL);
}

#endif /* GLX_OML_sync_control */

/* ------------------------ GLX_SGIS_blended_overlay ----------------------- */

#ifdef GLX_SGIS_blended_overlay

static void _glewInfo_GLX_SGIS_blended_overlay (void)
{
  glewPrintExt("GLX_SGIS_blended_overlay", GLXEW_SGIS_blended_overlay, glxewGetExtension("GLX_SGIS_blended_overlay"));
}

#endif /* GLX_SGIS_blended_overlay */

/* -------------------------- GLX_SGIS_color_range ------------------------- */

#ifdef GLX_SGIS_color_range

static void _glewInfo_GLX_SGIS_color_range (void)
{
  glewPrintExt("GLX_SGIS_color_range", GLXEW_SGIS_color_range, glxewGetExtension("GLX_SGIS_color_range"));
}

#endif /* GLX_SGIS_color_range */

/* -------------------------- GLX_SGIS_multisample ------------------------- */

#ifdef GLX_SGIS_multisample

static void _glewInfo_GLX_SGIS_multisample (void)
{
  glewPrintExt("GLX_SGIS_multisample", GLXEW_SGIS_multisample, glxewGetExtension("GLX_SGIS_multisample"));
}

#endif /* GLX_SGIS_multisample */

/* ---------------------- GLX_SGIS_shared_multisample ---------------------- */

#ifdef GLX_SGIS_shared_multisample

static void _glewInfo_GLX_SGIS_shared_multisample (void)
{
  glewPrintExt("GLX_SGIS_shared_multisample", GLXEW_SGIS_shared_multisample, glxewGetExtension("GLX_SGIS_shared_multisample"));
}

#endif /* GLX_SGIS_shared_multisample */

/* --------------------------- GLX_SGIX_fbconfig --------------------------- */

#ifdef GLX_SGIX_fbconfig

static void _glewInfo_GLX_SGIX_fbconfig (void)
{
  glewPrintExt("GLX_SGIX_fbconfig", GLXEW_SGIX_fbconfig, glxewGetExtension("GLX_SGIX_fbconfig"));

  glewInfoFunc("glXChooseFBConfigSGIX", glXChooseFBConfigSGIX == NULL);
  glewInfoFunc("glXCreateContextWithConfigSGIX", glXCreateContextWithConfigSGIX == NULL);
  glewInfoFunc("glXCreateGLXPixmapWithConfigSGIX", glXCreateGLXPixmapWithConfigSGIX == NULL);
  glewInfoFunc("glXGetFBConfigAttribSGIX", glXGetFBConfigAttribSGIX == NULL);
  glewInfoFunc("glXGetFBConfigFromVisualSGIX", glXGetFBConfigFromVisualSGIX == NULL);
  glewInfoFunc("glXGetVisualFromFBConfigSGIX", glXGetVisualFromFBConfigSGIX == NULL);
}

#endif /* GLX_SGIX_fbconfig */

/* ---------------------------- GLX_SGIX_pbuffer --------------------------- */

#ifdef GLX_SGIX_pbuffer

static void _glewInfo_GLX_SGIX_pbuffer (void)
{
  glewPrintExt("GLX_SGIX_pbuffer", GLXEW_SGIX_pbuffer, glxewGetExtension("GLX_SGIX_pbuffer"));

  glewInfoFunc("glXCreateGLXPbufferSGIX", glXCreateGLXPbufferSGIX == NULL);
  glewInfoFunc("glXDestroyGLXPbufferSGIX", glXDestroyGLXPbufferSGIX == NULL);
  glewInfoFunc("glXGetSelectedEventSGIX", glXGetSelectedEventSGIX == NULL);
  glewInfoFunc("glXQueryGLXPbufferSGIX", glXQueryGLXPbufferSGIX == NULL);
  glewInfoFunc("glXSelectEventSGIX", glXSelectEventSGIX == NULL);
}

#endif /* GLX_SGIX_pbuffer */

/* ------------------------- GLX_SGIX_swap_barrier ------------------------- */

#ifdef GLX_SGIX_swap_barrier

static void _glewInfo_GLX_SGIX_swap_barrier (void)
{
  glewPrintExt("GLX_SGIX_swap_barrier", GLXEW_SGIX_swap_barrier, glxewGetExtension("GLX_SGIX_swap_barrier"));

  glewInfoFunc("glXBindSwapBarrierSGIX", glXBindSwapBarrierSGIX == NULL);
  glewInfoFunc("glXQueryMaxSwapBarriersSGIX", glXQueryMaxSwapBarriersSGIX == NULL);
}

#endif /* GLX_SGIX_swap_barrier */

/* -------------------------- GLX_SGIX_swap_group -------------------------- */

#ifdef GLX_SGIX_swap_group

static void _glewInfo_GLX_SGIX_swap_group (void)
{
  glewPrintExt("GLX_SGIX_swap_group", GLXEW_SGIX_swap_group, glxewGetExtension("GLX_SGIX_swap_group"));

  glewInfoFunc("glXJoinSwapGroupSGIX", glXJoinSwapGroupSGIX == NULL);
}

#endif /* GLX_SGIX_swap_group */

/* ------------------------- GLX_SGIX_video_resize ------------------------- */

#ifdef GLX_SGIX_video_resize

static void _glewInfo_GLX_SGIX_video_resize (void)
{
  glewPrintExt("GLX_SGIX_video_resize", GLXEW_SGIX_video_resize, glxewGetExtension("GLX_SGIX_video_resize"));

  glewInfoFunc("glXBindChannelToWindowSGIX", glXBindChannelToWindowSGIX == NULL);
  glewInfoFunc("glXChannelRectSGIX", glXChannelRectSGIX == NULL);
  glewInfoFunc("glXChannelRectSyncSGIX", glXChannelRectSyncSGIX == NULL);
  glewInfoFunc("glXQueryChannelDeltasSGIX", glXQueryChannelDeltasSGIX == NULL);
  glewInfoFunc("glXQueryChannelRectSGIX", glXQueryChannelRectSGIX == NULL);
}

#endif /* GLX_SGIX_video_resize */

/* ---------------------- GLX_SGIX_visual_select_group --------------------- */

#ifdef GLX_SGIX_visual_select_group

static void _glewInfo_GLX_SGIX_visual_select_group (void)
{
  glewPrintExt("GLX_SGIX_visual_select_group", GLXEW_SGIX_visual_select_group, glxewGetExtension("GLX_SGIX_visual_select_group"));
}

#endif /* GLX_SGIX_visual_select_group */

/* ---------------------------- GLX_SGI_cushion ---------------------------- */

#ifdef GLX_SGI_cushion

static void _glewInfo_GLX_SGI_cushion (void)
{
  glewPrintExt("GLX_SGI_cushion", GLXEW_SGI_cushion, glxewGetExtension("GLX_SGI_cushion"));

  glewInfoFunc("glXCushionSGI", glXCushionSGI == NULL);
}

#endif /* GLX_SGI_cushion */

/* ----------------------- GLX_SGI_make_current_read ----------------------- */

#ifdef GLX_SGI_make_current_read

static void _glewInfo_GLX_SGI_make_current_read (void)
{
  glewPrintExt("GLX_SGI_make_current_read", GLXEW_SGI_make_current_read, glxewGetExtension("GLX_SGI_make_current_read"));

  glewInfoFunc("glXGetCurrentReadDrawableSGI", glXGetCurrentReadDrawableSGI == NULL);
  glewInfoFunc("glXMakeCurrentReadSGI", glXMakeCurrentReadSGI == NULL);
}

#endif /* GLX_SGI_make_current_read */

/* -------------------------- GLX_SGI_swap_control ------------------------- */

#ifdef GLX_SGI_swap_control

static void _glewInfo_GLX_SGI_swap_control (void)
{
  glewPrintExt("GLX_SGI_swap_control", GLXEW_SGI_swap_control, glxewGetExtension("GLX_SGI_swap_control"));

  glewInfoFunc("glXSwapIntervalSGI", glXSwapIntervalSGI == NULL);
}

#endif /* GLX_SGI_swap_control */

/* --------------------------- GLX_SGI_video_sync -------------------------- */

#ifdef GLX_SGI_video_sync

static void _glewInfo_GLX_SGI_video_sync (void)
{
  glewPrintExt("GLX_SGI_video_sync", GLXEW_SGI_video_sync, glxewGetExtension("GLX_SGI_video_sync"));

  glewInfoFunc("glXGetVideoSyncSGI", glXGetVideoSyncSGI == NULL);
  glewInfoFunc("glXWaitVideoSyncSGI", glXWaitVideoSyncSGI == NULL);
}

#endif /* GLX_SGI_video_sync */

/* --------------------- GLX_SUN_get_transparent_index --------------------- */

#ifdef GLX_SUN_get_transparent_index

static void _glewInfo_GLX_SUN_get_transparent_index (void)
{
  glewPrintExt("GLX_SUN_get_transparent_index", GLXEW_SUN_get_transparent_index, glxewGetExtension("GLX_SUN_get_transparent_index"));

  glewInfoFunc("glXGetTransparentIndexSUN", glXGetTransparentIndexSUN == NULL);
}

#endif /* GLX_SUN_get_transparent_index */

/* -------------------------- GLX_SUN_video_resize ------------------------- */

#ifdef GLX_SUN_video_resize

static void _glewInfo_GLX_SUN_video_resize (void)
{
  glewPrintExt("GLX_SUN_video_resize", GLXEW_SUN_video_resize, glxewGetExtension("GLX_SUN_video_resize"));

  glewInfoFunc("glXGetVideoResizeSUN", glXGetVideoResizeSUN == NULL);
  glewInfoFunc("glXVideoResizeSUN", glXVideoResizeSUN == NULL);
}

#endif /* GLX_SUN_video_resize */

#endif /* _WIN32 */

/* ------------------------------------------------------------------------ */

static void glewInfo (void)
{
#ifdef GL_VERSION_1_1
  _glewInfo_GL_VERSION_1_1();
#endif /* GL_VERSION_1_1 */
#ifdef GL_VERSION_1_2
  _glewInfo_GL_VERSION_1_2();
#endif /* GL_VERSION_1_2 */
#ifdef GL_VERSION_1_3
  _glewInfo_GL_VERSION_1_3();
#endif /* GL_VERSION_1_3 */
#ifdef GL_VERSION_1_4
  _glewInfo_GL_VERSION_1_4();
#endif /* GL_VERSION_1_4 */
#ifdef GL_VERSION_1_5
  _glewInfo_GL_VERSION_1_5();
#endif /* GL_VERSION_1_5 */
#ifdef GL_3DFX_multisample
  _glewInfo_GL_3DFX_multisample();
#endif /* GL_3DFX_multisample */
#ifdef GL_3DFX_tbuffer
  _glewInfo_GL_3DFX_tbuffer();
#endif /* GL_3DFX_tbuffer */
#ifdef GL_3DFX_texture_compression_FXT1
  _glewInfo_GL_3DFX_texture_compression_FXT1();
#endif /* GL_3DFX_texture_compression_FXT1 */
#ifdef GL_APPLE_client_storage
  _glewInfo_GL_APPLE_client_storage();
#endif /* GL_APPLE_client_storage */
#ifdef GL_APPLE_element_array
  _glewInfo_GL_APPLE_element_array();
#endif /* GL_APPLE_element_array */
#ifdef GL_APPLE_fence
  _glewInfo_GL_APPLE_fence();
#endif /* GL_APPLE_fence */
#ifdef GL_APPLE_float_pixels
  _glewInfo_GL_APPLE_float_pixels();
#endif /* GL_APPLE_float_pixels */
#ifdef GL_APPLE_specular_vector
  _glewInfo_GL_APPLE_specular_vector();
#endif /* GL_APPLE_specular_vector */
#ifdef GL_APPLE_texture_range
  _glewInfo_GL_APPLE_texture_range();
#endif /* GL_APPLE_texture_range */
#ifdef GL_APPLE_transform_hint
  _glewInfo_GL_APPLE_transform_hint();
#endif /* GL_APPLE_transform_hint */
#ifdef GL_APPLE_vertex_array_object
  _glewInfo_GL_APPLE_vertex_array_object();
#endif /* GL_APPLE_vertex_array_object */
#ifdef GL_APPLE_vertex_array_range
  _glewInfo_GL_APPLE_vertex_array_range();
#endif /* GL_APPLE_vertex_array_range */
#ifdef GL_APPLE_ycbcr_422
  _glewInfo_GL_APPLE_ycbcr_422();
#endif /* GL_APPLE_ycbcr_422 */
#ifdef GL_ARB_depth_texture
  _glewInfo_GL_ARB_depth_texture();
#endif /* GL_ARB_depth_texture */
#ifdef GL_ARB_draw_buffers
  _glewInfo_GL_ARB_draw_buffers();
#endif /* GL_ARB_draw_buffers */
#ifdef GL_ARB_fragment_program
  _glewInfo_GL_ARB_fragment_program();
#endif /* GL_ARB_fragment_program */
#ifdef GL_ARB_fragment_program_shadow
  _glewInfo_GL_ARB_fragment_program_shadow();
#endif /* GL_ARB_fragment_program_shadow */
#ifdef GL_ARB_fragment_shader
  _glewInfo_GL_ARB_fragment_shader();
#endif /* GL_ARB_fragment_shader */
#ifdef GL_ARB_imaging
  _glewInfo_GL_ARB_imaging();
#endif /* GL_ARB_imaging */
#ifdef GL_ARB_matrix_palette
  _glewInfo_GL_ARB_matrix_palette();
#endif /* GL_ARB_matrix_palette */
#ifdef GL_ARB_multisample
  _glewInfo_GL_ARB_multisample();
#endif /* GL_ARB_multisample */
#ifdef GL_ARB_multitexture
  _glewInfo_GL_ARB_multitexture();
#endif /* GL_ARB_multitexture */
#ifdef GL_ARB_occlusion_query
  _glewInfo_GL_ARB_occlusion_query();
#endif /* GL_ARB_occlusion_query */
#ifdef GL_ARB_point_parameters
  _glewInfo_GL_ARB_point_parameters();
#endif /* GL_ARB_point_parameters */
#ifdef GL_ARB_point_sprite
  _glewInfo_GL_ARB_point_sprite();
#endif /* GL_ARB_point_sprite */
#ifdef GL_ARB_shader_objects
  _glewInfo_GL_ARB_shader_objects();
#endif /* GL_ARB_shader_objects */
#ifdef GL_ARB_shading_language_100
  _glewInfo_GL_ARB_shading_language_100();
#endif /* GL_ARB_shading_language_100 */
#ifdef GL_ARB_shadow
  _glewInfo_GL_ARB_shadow();
#endif /* GL_ARB_shadow */
#ifdef GL_ARB_shadow_ambient
  _glewInfo_GL_ARB_shadow_ambient();
#endif /* GL_ARB_shadow_ambient */
#ifdef GL_ARB_texture_border_clamp
  _glewInfo_GL_ARB_texture_border_clamp();
#endif /* GL_ARB_texture_border_clamp */
#ifdef GL_ARB_texture_compression
  _glewInfo_GL_ARB_texture_compression();
#endif /* GL_ARB_texture_compression */
#ifdef GL_ARB_texture_cube_map
  _glewInfo_GL_ARB_texture_cube_map();
#endif /* GL_ARB_texture_cube_map */
#ifdef GL_ARB_texture_env_add
  _glewInfo_GL_ARB_texture_env_add();
#endif /* GL_ARB_texture_env_add */
#ifdef GL_ARB_texture_env_combine
  _glewInfo_GL_ARB_texture_env_combine();
#endif /* GL_ARB_texture_env_combine */
#ifdef GL_ARB_texture_env_crossbar
  _glewInfo_GL_ARB_texture_env_crossbar();
#endif /* GL_ARB_texture_env_crossbar */
#ifdef GL_ARB_texture_env_dot3
  _glewInfo_GL_ARB_texture_env_dot3();
#endif /* GL_ARB_texture_env_dot3 */
#ifdef GL_ARB_texture_mirrored_repeat
  _glewInfo_GL_ARB_texture_mirrored_repeat();
#endif /* GL_ARB_texture_mirrored_repeat */
#ifdef GL_ARB_texture_non_power_of_two
  _glewInfo_GL_ARB_texture_non_power_of_two();
#endif /* GL_ARB_texture_non_power_of_two */
#ifdef GL_ARB_texture_rectangle
  _glewInfo_GL_ARB_texture_rectangle();
#endif /* GL_ARB_texture_rectangle */
#ifdef GL_ARB_transpose_matrix
  _glewInfo_GL_ARB_transpose_matrix();
#endif /* GL_ARB_transpose_matrix */
#ifdef GL_ARB_vertex_blend
  _glewInfo_GL_ARB_vertex_blend();
#endif /* GL_ARB_vertex_blend */
#ifdef GL_ARB_vertex_buffer_object
  _glewInfo_GL_ARB_vertex_buffer_object();
#endif /* GL_ARB_vertex_buffer_object */
#ifdef GL_ARB_vertex_program
  _glewInfo_GL_ARB_vertex_program();
#endif /* GL_ARB_vertex_program */
#ifdef GL_ARB_vertex_shader
  _glewInfo_GL_ARB_vertex_shader();
#endif /* GL_ARB_vertex_shader */
#ifdef GL_ARB_window_pos
  _glewInfo_GL_ARB_window_pos();
#endif /* GL_ARB_window_pos */
#ifdef GL_ATIX_point_sprites
  _glewInfo_GL_ATIX_point_sprites();
#endif /* GL_ATIX_point_sprites */
#ifdef GL_ATIX_texture_env_combine3
  _glewInfo_GL_ATIX_texture_env_combine3();
#endif /* GL_ATIX_texture_env_combine3 */
#ifdef GL_ATIX_texture_env_route
  _glewInfo_GL_ATIX_texture_env_route();
#endif /* GL_ATIX_texture_env_route */
#ifdef GL_ATIX_vertex_shader_output_point_size
  _glewInfo_GL_ATIX_vertex_shader_output_point_size();
#endif /* GL_ATIX_vertex_shader_output_point_size */
#ifdef GL_ATI_draw_buffers
  _glewInfo_GL_ATI_draw_buffers();
#endif /* GL_ATI_draw_buffers */
#ifdef GL_ATI_element_array
  _glewInfo_GL_ATI_element_array();
#endif /* GL_ATI_element_array */
#ifdef GL_ATI_envmap_bumpmap
  _glewInfo_GL_ATI_envmap_bumpmap();
#endif /* GL_ATI_envmap_bumpmap */
#ifdef GL_ATI_fragment_shader
  _glewInfo_GL_ATI_fragment_shader();
#endif /* GL_ATI_fragment_shader */
#ifdef GL_ATI_map_object_buffer
  _glewInfo_GL_ATI_map_object_buffer();
#endif /* GL_ATI_map_object_buffer */
#ifdef GL_ATI_pn_triangles
  _glewInfo_GL_ATI_pn_triangles();
#endif /* GL_ATI_pn_triangles */
#ifdef GL_ATI_separate_stencil
  _glewInfo_GL_ATI_separate_stencil();
#endif /* GL_ATI_separate_stencil */
#ifdef GL_ATI_text_fragment_shader
  _glewInfo_GL_ATI_text_fragment_shader();
#endif /* GL_ATI_text_fragment_shader */
#ifdef GL_ATI_texture_env_combine3
  _glewInfo_GL_ATI_texture_env_combine3();
#endif /* GL_ATI_texture_env_combine3 */
#ifdef GL_ATI_texture_float
  _glewInfo_GL_ATI_texture_float();
#endif /* GL_ATI_texture_float */
#ifdef GL_ATI_texture_mirror_once
  _glewInfo_GL_ATI_texture_mirror_once();
#endif /* GL_ATI_texture_mirror_once */
#ifdef GL_ATI_vertex_array_object
  _glewInfo_GL_ATI_vertex_array_object();
#endif /* GL_ATI_vertex_array_object */
#ifdef GL_ATI_vertex_attrib_array_object
  _glewInfo_GL_ATI_vertex_attrib_array_object();
#endif /* GL_ATI_vertex_attrib_array_object */
#ifdef GL_ATI_vertex_streams
  _glewInfo_GL_ATI_vertex_streams();
#endif /* GL_ATI_vertex_streams */
#ifdef GL_EXT_422_pixels
  _glewInfo_GL_EXT_422_pixels();
#endif /* GL_EXT_422_pixels */
#ifdef GL_EXT_abgr
  _glewInfo_GL_EXT_abgr();
#endif /* GL_EXT_abgr */
#ifdef GL_EXT_bgra
  _glewInfo_GL_EXT_bgra();
#endif /* GL_EXT_bgra */
#ifdef GL_EXT_blend_color
  _glewInfo_GL_EXT_blend_color();
#endif /* GL_EXT_blend_color */
#ifdef GL_EXT_blend_equation_separate
  _glewInfo_GL_EXT_blend_equation_separate();
#endif /* GL_EXT_blend_equation_separate */
#ifdef GL_EXT_blend_func_separate
  _glewInfo_GL_EXT_blend_func_separate();
#endif /* GL_EXT_blend_func_separate */
#ifdef GL_EXT_blend_logic_op
  _glewInfo_GL_EXT_blend_logic_op();
#endif /* GL_EXT_blend_logic_op */
#ifdef GL_EXT_blend_minmax
  _glewInfo_GL_EXT_blend_minmax();
#endif /* GL_EXT_blend_minmax */
#ifdef GL_EXT_blend_subtract
  _glewInfo_GL_EXT_blend_subtract();
#endif /* GL_EXT_blend_subtract */
#ifdef GL_EXT_clip_volume_hint
  _glewInfo_GL_EXT_clip_volume_hint();
#endif /* GL_EXT_clip_volume_hint */
#ifdef GL_EXT_cmyka
  _glewInfo_GL_EXT_cmyka();
#endif /* GL_EXT_cmyka */
#ifdef GL_EXT_color_subtable
  _glewInfo_GL_EXT_color_subtable();
#endif /* GL_EXT_color_subtable */
#ifdef GL_EXT_compiled_vertex_array
  _glewInfo_GL_EXT_compiled_vertex_array();
#endif /* GL_EXT_compiled_vertex_array */
#ifdef GL_EXT_convolution
  _glewInfo_GL_EXT_convolution();
#endif /* GL_EXT_convolution */
#ifdef GL_EXT_coordinate_frame
  _glewInfo_GL_EXT_coordinate_frame();
#endif /* GL_EXT_coordinate_frame */
#ifdef GL_EXT_copy_texture
  _glewInfo_GL_EXT_copy_texture();
#endif /* GL_EXT_copy_texture */
#ifdef GL_EXT_cull_vertex
  _glewInfo_GL_EXT_cull_vertex();
#endif /* GL_EXT_cull_vertex */
#ifdef GL_EXT_depth_bounds_test
  _glewInfo_GL_EXT_depth_bounds_test();
#endif /* GL_EXT_depth_bounds_test */
#ifdef GL_EXT_draw_range_elements
  _glewInfo_GL_EXT_draw_range_elements();
#endif /* GL_EXT_draw_range_elements */
#ifdef GL_EXT_fog_coord
  _glewInfo_GL_EXT_fog_coord();
#endif /* GL_EXT_fog_coord */
#ifdef GL_EXT_fragment_lighting
  _glewInfo_GL_EXT_fragment_lighting();
#endif /* GL_EXT_fragment_lighting */
#ifdef GL_EXT_histogram
  _glewInfo_GL_EXT_histogram();
#endif /* GL_EXT_histogram */
#ifdef GL_EXT_index_array_formats
  _glewInfo_GL_EXT_index_array_formats();
#endif /* GL_EXT_index_array_formats */
#ifdef GL_EXT_index_func
  _glewInfo_GL_EXT_index_func();
#endif /* GL_EXT_index_func */
#ifdef GL_EXT_index_material
  _glewInfo_GL_EXT_index_material();
#endif /* GL_EXT_index_material */
#ifdef GL_EXT_index_texture
  _glewInfo_GL_EXT_index_texture();
#endif /* GL_EXT_index_texture */
#ifdef GL_EXT_light_texture
  _glewInfo_GL_EXT_light_texture();
#endif /* GL_EXT_light_texture */
#ifdef GL_EXT_misc_attribute
  _glewInfo_GL_EXT_misc_attribute();
#endif /* GL_EXT_misc_attribute */
#ifdef GL_EXT_multi_draw_arrays
  _glewInfo_GL_EXT_multi_draw_arrays();
#endif /* GL_EXT_multi_draw_arrays */
#ifdef GL_EXT_multisample
  _glewInfo_GL_EXT_multisample();
#endif /* GL_EXT_multisample */
#ifdef GL_EXT_packed_pixels
  _glewInfo_GL_EXT_packed_pixels();
#endif /* GL_EXT_packed_pixels */
#ifdef GL_EXT_paletted_texture
  _glewInfo_GL_EXT_paletted_texture();
#endif /* GL_EXT_paletted_texture */
#ifdef GL_EXT_pixel_buffer_object
  _glewInfo_GL_EXT_pixel_buffer_object();
#endif /* GL_EXT_pixel_buffer_object */
#ifdef GL_EXT_pixel_transform
  _glewInfo_GL_EXT_pixel_transform();
#endif /* GL_EXT_pixel_transform */
#ifdef GL_EXT_pixel_transform_color_table
  _glewInfo_GL_EXT_pixel_transform_color_table();
#endif /* GL_EXT_pixel_transform_color_table */
#ifdef GL_EXT_point_parameters
  _glewInfo_GL_EXT_point_parameters();
#endif /* GL_EXT_point_parameters */
#ifdef GL_EXT_polygon_offset
  _glewInfo_GL_EXT_polygon_offset();
#endif /* GL_EXT_polygon_offset */
#ifdef GL_EXT_rescale_normal
  _glewInfo_GL_EXT_rescale_normal();
#endif /* GL_EXT_rescale_normal */
#ifdef GL_EXT_scene_marker
  _glewInfo_GL_EXT_scene_marker();
#endif /* GL_EXT_scene_marker */
#ifdef GL_EXT_secondary_color
  _glewInfo_GL_EXT_secondary_color();
#endif /* GL_EXT_secondary_color */
#ifdef GL_EXT_separate_specular_color
  _glewInfo_GL_EXT_separate_specular_color();
#endif /* GL_EXT_separate_specular_color */
#ifdef GL_EXT_shadow_funcs
  _glewInfo_GL_EXT_shadow_funcs();
#endif /* GL_EXT_shadow_funcs */
#ifdef GL_EXT_shared_texture_palette
  _glewInfo_GL_EXT_shared_texture_palette();
#endif /* GL_EXT_shared_texture_palette */
#ifdef GL_EXT_stencil_two_side
  _glewInfo_GL_EXT_stencil_two_side();
#endif /* GL_EXT_stencil_two_side */
#ifdef GL_EXT_stencil_wrap
  _glewInfo_GL_EXT_stencil_wrap();
#endif /* GL_EXT_stencil_wrap */
#ifdef GL_EXT_subtexture
  _glewInfo_GL_EXT_subtexture();
#endif /* GL_EXT_subtexture */
#ifdef GL_EXT_texture
  _glewInfo_GL_EXT_texture();
#endif /* GL_EXT_texture */
#ifdef GL_EXT_texture3D
  _glewInfo_GL_EXT_texture3D();
#endif /* GL_EXT_texture3D */
#ifdef GL_EXT_texture_compression_s3tc
  _glewInfo_GL_EXT_texture_compression_s3tc();
#endif /* GL_EXT_texture_compression_s3tc */
#ifdef GL_EXT_texture_cube_map
  _glewInfo_GL_EXT_texture_cube_map();
#endif /* GL_EXT_texture_cube_map */
#ifdef GL_EXT_texture_edge_clamp
  _glewInfo_GL_EXT_texture_edge_clamp();
#endif /* GL_EXT_texture_edge_clamp */
#ifdef GL_EXT_texture_env
  _glewInfo_GL_EXT_texture_env();
#endif /* GL_EXT_texture_env */
#ifdef GL_EXT_texture_env_add
  _glewInfo_GL_EXT_texture_env_add();
#endif /* GL_EXT_texture_env_add */
#ifdef GL_EXT_texture_env_combine
  _glewInfo_GL_EXT_texture_env_combine();
#endif /* GL_EXT_texture_env_combine */
#ifdef GL_EXT_texture_env_dot3
  _glewInfo_GL_EXT_texture_env_dot3();
#endif /* GL_EXT_texture_env_dot3 */
#ifdef GL_EXT_texture_filter_anisotropic
  _glewInfo_GL_EXT_texture_filter_anisotropic();
#endif /* GL_EXT_texture_filter_anisotropic */
#ifdef GL_EXT_texture_lod_bias
  _glewInfo_GL_EXT_texture_lod_bias();
#endif /* GL_EXT_texture_lod_bias */
#ifdef GL_EXT_texture_mirror_clamp
  _glewInfo_GL_EXT_texture_mirror_clamp();
#endif /* GL_EXT_texture_mirror_clamp */
#ifdef GL_EXT_texture_object
  _glewInfo_GL_EXT_texture_object();
#endif /* GL_EXT_texture_object */
#ifdef GL_EXT_texture_perturb_normal
  _glewInfo_GL_EXT_texture_perturb_normal();
#endif /* GL_EXT_texture_perturb_normal */
#ifdef GL_EXT_texture_rectangle
  _glewInfo_GL_EXT_texture_rectangle();
#endif /* GL_EXT_texture_rectangle */
#ifdef GL_EXT_vertex_array
  _glewInfo_GL_EXT_vertex_array();
#endif /* GL_EXT_vertex_array */
#ifdef GL_EXT_vertex_shader
  _glewInfo_GL_EXT_vertex_shader();
#endif /* GL_EXT_vertex_shader */
#ifdef GL_EXT_vertex_weighting
  _glewInfo_GL_EXT_vertex_weighting();
#endif /* GL_EXT_vertex_weighting */
#ifdef GL_HP_convolution_border_modes
  _glewInfo_GL_HP_convolution_border_modes();
#endif /* GL_HP_convolution_border_modes */
#ifdef GL_HP_image_transform
  _glewInfo_GL_HP_image_transform();
#endif /* GL_HP_image_transform */
#ifdef GL_HP_occlusion_test
  _glewInfo_GL_HP_occlusion_test();
#endif /* GL_HP_occlusion_test */
#ifdef GL_HP_texture_lighting
  _glewInfo_GL_HP_texture_lighting();
#endif /* GL_HP_texture_lighting */
#ifdef GL_IBM_cull_vertex
  _glewInfo_GL_IBM_cull_vertex();
#endif /* GL_IBM_cull_vertex */
#ifdef GL_IBM_multimode_draw_arrays
  _glewInfo_GL_IBM_multimode_draw_arrays();
#endif /* GL_IBM_multimode_draw_arrays */
#ifdef GL_IBM_rasterpos_clip
  _glewInfo_GL_IBM_rasterpos_clip();
#endif /* GL_IBM_rasterpos_clip */
#ifdef GL_IBM_static_data
  _glewInfo_GL_IBM_static_data();
#endif /* GL_IBM_static_data */
#ifdef GL_IBM_texture_mirrored_repeat
  _glewInfo_GL_IBM_texture_mirrored_repeat();
#endif /* GL_IBM_texture_mirrored_repeat */
#ifdef GL_IBM_vertex_array_lists
  _glewInfo_GL_IBM_vertex_array_lists();
#endif /* GL_IBM_vertex_array_lists */
#ifdef GL_INGR_color_clamp
  _glewInfo_GL_INGR_color_clamp();
#endif /* GL_INGR_color_clamp */
#ifdef GL_INGR_interlace_read
  _glewInfo_GL_INGR_interlace_read();
#endif /* GL_INGR_interlace_read */
#ifdef GL_INTEL_parallel_arrays
  _glewInfo_GL_INTEL_parallel_arrays();
#endif /* GL_INTEL_parallel_arrays */
#ifdef GL_INTEL_texture_scissor
  _glewInfo_GL_INTEL_texture_scissor();
#endif /* GL_INTEL_texture_scissor */
#ifdef GL_MESA_pack_invert
  _glewInfo_GL_MESA_pack_invert();
#endif /* GL_MESA_pack_invert */
#ifdef GL_MESA_resize_buffers
  _glewInfo_GL_MESA_resize_buffers();
#endif /* GL_MESA_resize_buffers */
#ifdef GL_MESA_window_pos
  _glewInfo_GL_MESA_window_pos();
#endif /* GL_MESA_window_pos */
#ifdef GL_MESA_ycbcr_texture
  _glewInfo_GL_MESA_ycbcr_texture();
#endif /* GL_MESA_ycbcr_texture */
#ifdef GL_NV_blend_square
  _glewInfo_GL_NV_blend_square();
#endif /* GL_NV_blend_square */
#ifdef GL_NV_copy_depth_to_color
  _glewInfo_GL_NV_copy_depth_to_color();
#endif /* GL_NV_copy_depth_to_color */
#ifdef GL_NV_depth_clamp
  _glewInfo_GL_NV_depth_clamp();
#endif /* GL_NV_depth_clamp */
#ifdef GL_NV_evaluators
  _glewInfo_GL_NV_evaluators();
#endif /* GL_NV_evaluators */
#ifdef GL_NV_fence
  _glewInfo_GL_NV_fence();
#endif /* GL_NV_fence */
#ifdef GL_NV_float_buffer
  _glewInfo_GL_NV_float_buffer();
#endif /* GL_NV_float_buffer */
#ifdef GL_NV_fog_distance
  _glewInfo_GL_NV_fog_distance();
#endif /* GL_NV_fog_distance */
#ifdef GL_NV_fragment_program
  _glewInfo_GL_NV_fragment_program();
#endif /* GL_NV_fragment_program */
#ifdef GL_NV_fragment_program2
  _glewInfo_GL_NV_fragment_program2();
#endif /* GL_NV_fragment_program2 */
#ifdef GL_NV_fragment_program_option
  _glewInfo_GL_NV_fragment_program_option();
#endif /* GL_NV_fragment_program_option */
#ifdef GL_NV_half_float
  _glewInfo_GL_NV_half_float();
#endif /* GL_NV_half_float */
#ifdef GL_NV_light_max_exponent
  _glewInfo_GL_NV_light_max_exponent();
#endif /* GL_NV_light_max_exponent */
#ifdef GL_NV_multisample_filter_hint
  _glewInfo_GL_NV_multisample_filter_hint();
#endif /* GL_NV_multisample_filter_hint */
#ifdef GL_NV_occlusion_query
  _glewInfo_GL_NV_occlusion_query();
#endif /* GL_NV_occlusion_query */
#ifdef GL_NV_packed_depth_stencil
  _glewInfo_GL_NV_packed_depth_stencil();
#endif /* GL_NV_packed_depth_stencil */
#ifdef GL_NV_pixel_data_range
  _glewInfo_GL_NV_pixel_data_range();
#endif /* GL_NV_pixel_data_range */
#ifdef GL_NV_point_sprite
  _glewInfo_GL_NV_point_sprite();
#endif /* GL_NV_point_sprite */
#ifdef GL_NV_primitive_restart
  _glewInfo_GL_NV_primitive_restart();
#endif /* GL_NV_primitive_restart */
#ifdef GL_NV_register_combiners
  _glewInfo_GL_NV_register_combiners();
#endif /* GL_NV_register_combiners */
#ifdef GL_NV_register_combiners2
  _glewInfo_GL_NV_register_combiners2();
#endif /* GL_NV_register_combiners2 */
#ifdef GL_NV_texgen_emboss
  _glewInfo_GL_NV_texgen_emboss();
#endif /* GL_NV_texgen_emboss */
#ifdef GL_NV_texgen_reflection
  _glewInfo_GL_NV_texgen_reflection();
#endif /* GL_NV_texgen_reflection */
#ifdef GL_NV_texture_compression_vtc
  _glewInfo_GL_NV_texture_compression_vtc();
#endif /* GL_NV_texture_compression_vtc */
#ifdef GL_NV_texture_env_combine4
  _glewInfo_GL_NV_texture_env_combine4();
#endif /* GL_NV_texture_env_combine4 */
#ifdef GL_NV_texture_expand_normal
  _glewInfo_GL_NV_texture_expand_normal();
#endif /* GL_NV_texture_expand_normal */
#ifdef GL_NV_texture_rectangle
  _glewInfo_GL_NV_texture_rectangle();
#endif /* GL_NV_texture_rectangle */
#ifdef GL_NV_texture_shader
  _glewInfo_GL_NV_texture_shader();
#endif /* GL_NV_texture_shader */
#ifdef GL_NV_texture_shader2
  _glewInfo_GL_NV_texture_shader2();
#endif /* GL_NV_texture_shader2 */
#ifdef GL_NV_texture_shader3
  _glewInfo_GL_NV_texture_shader3();
#endif /* GL_NV_texture_shader3 */
#ifdef GL_NV_vertex_array_range
  _glewInfo_GL_NV_vertex_array_range();
#endif /* GL_NV_vertex_array_range */
#ifdef GL_NV_vertex_array_range2
  _glewInfo_GL_NV_vertex_array_range2();
#endif /* GL_NV_vertex_array_range2 */
#ifdef GL_NV_vertex_program
  _glewInfo_GL_NV_vertex_program();
#endif /* GL_NV_vertex_program */
#ifdef GL_NV_vertex_program1_1
  _glewInfo_GL_NV_vertex_program1_1();
#endif /* GL_NV_vertex_program1_1 */
#ifdef GL_NV_vertex_program2
  _glewInfo_GL_NV_vertex_program2();
#endif /* GL_NV_vertex_program2 */
#ifdef GL_NV_vertex_program2_option
  _glewInfo_GL_NV_vertex_program2_option();
#endif /* GL_NV_vertex_program2_option */
#ifdef GL_NV_vertex_program3
  _glewInfo_GL_NV_vertex_program3();
#endif /* GL_NV_vertex_program3 */
#ifdef GL_OML_interlace
  _glewInfo_GL_OML_interlace();
#endif /* GL_OML_interlace */
#ifdef GL_OML_resample
  _glewInfo_GL_OML_resample();
#endif /* GL_OML_resample */
#ifdef GL_OML_subsample
  _glewInfo_GL_OML_subsample();
#endif /* GL_OML_subsample */
#ifdef GL_PGI_misc_hints
  _glewInfo_GL_PGI_misc_hints();
#endif /* GL_PGI_misc_hints */
#ifdef GL_PGI_vertex_hints
  _glewInfo_GL_PGI_vertex_hints();
#endif /* GL_PGI_vertex_hints */
#ifdef GL_REND_screen_coordinates
  _glewInfo_GL_REND_screen_coordinates();
#endif /* GL_REND_screen_coordinates */
#ifdef GL_S3_s3tc
  _glewInfo_GL_S3_s3tc();
#endif /* GL_S3_s3tc */
#ifdef GL_SGIS_color_range
  _glewInfo_GL_SGIS_color_range();
#endif /* GL_SGIS_color_range */
#ifdef GL_SGIS_detail_texture
  _glewInfo_GL_SGIS_detail_texture();
#endif /* GL_SGIS_detail_texture */
#ifdef GL_SGIS_fog_function
  _glewInfo_GL_SGIS_fog_function();
#endif /* GL_SGIS_fog_function */
#ifdef GL_SGIS_generate_mipmap
  _glewInfo_GL_SGIS_generate_mipmap();
#endif /* GL_SGIS_generate_mipmap */
#ifdef GL_SGIS_multisample
  _glewInfo_GL_SGIS_multisample();
#endif /* GL_SGIS_multisample */
#ifdef GL_SGIS_pixel_texture
  _glewInfo_GL_SGIS_pixel_texture();
#endif /* GL_SGIS_pixel_texture */
#ifdef GL_SGIS_sharpen_texture
  _glewInfo_GL_SGIS_sharpen_texture();
#endif /* GL_SGIS_sharpen_texture */
#ifdef GL_SGIS_texture4D
  _glewInfo_GL_SGIS_texture4D();
#endif /* GL_SGIS_texture4D */
#ifdef GL_SGIS_texture_border_clamp
  _glewInfo_GL_SGIS_texture_border_clamp();
#endif /* GL_SGIS_texture_border_clamp */
#ifdef GL_SGIS_texture_edge_clamp
  _glewInfo_GL_SGIS_texture_edge_clamp();
#endif /* GL_SGIS_texture_edge_clamp */
#ifdef GL_SGIS_texture_filter4
  _glewInfo_GL_SGIS_texture_filter4();
#endif /* GL_SGIS_texture_filter4 */
#ifdef GL_SGIS_texture_lod
  _glewInfo_GL_SGIS_texture_lod();
#endif /* GL_SGIS_texture_lod */
#ifdef GL_SGIS_texture_select
  _glewInfo_GL_SGIS_texture_select();
#endif /* GL_SGIS_texture_select */
#ifdef GL_SGIX_async
  _glewInfo_GL_SGIX_async();
#endif /* GL_SGIX_async */
#ifdef GL_SGIX_async_histogram
  _glewInfo_GL_SGIX_async_histogram();
#endif /* GL_SGIX_async_histogram */
#ifdef GL_SGIX_async_pixel
  _glewInfo_GL_SGIX_async_pixel();
#endif /* GL_SGIX_async_pixel */
#ifdef GL_SGIX_blend_alpha_minmax
  _glewInfo_GL_SGIX_blend_alpha_minmax();
#endif /* GL_SGIX_blend_alpha_minmax */
#ifdef GL_SGIX_clipmap
  _glewInfo_GL_SGIX_clipmap();
#endif /* GL_SGIX_clipmap */
#ifdef GL_SGIX_depth_texture
  _glewInfo_GL_SGIX_depth_texture();
#endif /* GL_SGIX_depth_texture */
#ifdef GL_SGIX_flush_raster
  _glewInfo_GL_SGIX_flush_raster();
#endif /* GL_SGIX_flush_raster */
#ifdef GL_SGIX_fog_offset
  _glewInfo_GL_SGIX_fog_offset();
#endif /* GL_SGIX_fog_offset */
#ifdef GL_SGIX_fog_texture
  _glewInfo_GL_SGIX_fog_texture();
#endif /* GL_SGIX_fog_texture */
#ifdef GL_SGIX_fragment_specular_lighting
  _glewInfo_GL_SGIX_fragment_specular_lighting();
#endif /* GL_SGIX_fragment_specular_lighting */
#ifdef GL_SGIX_framezoom
  _glewInfo_GL_SGIX_framezoom();
#endif /* GL_SGIX_framezoom */
#ifdef GL_SGIX_interlace
  _glewInfo_GL_SGIX_interlace();
#endif /* GL_SGIX_interlace */
#ifdef GL_SGIX_ir_instrument1
  _glewInfo_GL_SGIX_ir_instrument1();
#endif /* GL_SGIX_ir_instrument1 */
#ifdef GL_SGIX_list_priority
  _glewInfo_GL_SGIX_list_priority();
#endif /* GL_SGIX_list_priority */
#ifdef GL_SGIX_pixel_texture
  _glewInfo_GL_SGIX_pixel_texture();
#endif /* GL_SGIX_pixel_texture */
#ifdef GL_SGIX_pixel_texture_bits
  _glewInfo_GL_SGIX_pixel_texture_bits();
#endif /* GL_SGIX_pixel_texture_bits */
#ifdef GL_SGIX_reference_plane
  _glewInfo_GL_SGIX_reference_plane();
#endif /* GL_SGIX_reference_plane */
#ifdef GL_SGIX_resample
  _glewInfo_GL_SGIX_resample();
#endif /* GL_SGIX_resample */
#ifdef GL_SGIX_shadow
  _glewInfo_GL_SGIX_shadow();
#endif /* GL_SGIX_shadow */
#ifdef GL_SGIX_shadow_ambient
  _glewInfo_GL_SGIX_shadow_ambient();
#endif /* GL_SGIX_shadow_ambient */
#ifdef GL_SGIX_sprite
  _glewInfo_GL_SGIX_sprite();
#endif /* GL_SGIX_sprite */
#ifdef GL_SGIX_tag_sample_buffer
  _glewInfo_GL_SGIX_tag_sample_buffer();
#endif /* GL_SGIX_tag_sample_buffer */
#ifdef GL_SGIX_texture_add_env
  _glewInfo_GL_SGIX_texture_add_env();
#endif /* GL_SGIX_texture_add_env */
#ifdef GL_SGIX_texture_coordinate_clamp
  _glewInfo_GL_SGIX_texture_coordinate_clamp();
#endif /* GL_SGIX_texture_coordinate_clamp */
#ifdef GL_SGIX_texture_lod_bias
  _glewInfo_GL_SGIX_texture_lod_bias();
#endif /* GL_SGIX_texture_lod_bias */
#ifdef GL_SGIX_texture_multi_buffer
  _glewInfo_GL_SGIX_texture_multi_buffer();
#endif /* GL_SGIX_texture_multi_buffer */
#ifdef GL_SGIX_texture_range
  _glewInfo_GL_SGIX_texture_range();
#endif /* GL_SGIX_texture_range */
#ifdef GL_SGIX_texture_scale_bias
  _glewInfo_GL_SGIX_texture_scale_bias();
#endif /* GL_SGIX_texture_scale_bias */
#ifdef GL_SGIX_vertex_preclip
  _glewInfo_GL_SGIX_vertex_preclip();
#endif /* GL_SGIX_vertex_preclip */
#ifdef GL_SGIX_vertex_preclip_hint
  _glewInfo_GL_SGIX_vertex_preclip_hint();
#endif /* GL_SGIX_vertex_preclip_hint */
#ifdef GL_SGIX_ycrcb
  _glewInfo_GL_SGIX_ycrcb();
#endif /* GL_SGIX_ycrcb */
#ifdef GL_SGI_color_matrix
  _glewInfo_GL_SGI_color_matrix();
#endif /* GL_SGI_color_matrix */
#ifdef GL_SGI_color_table
  _glewInfo_GL_SGI_color_table();
#endif /* GL_SGI_color_table */
#ifdef GL_SGI_texture_color_table
  _glewInfo_GL_SGI_texture_color_table();
#endif /* GL_SGI_texture_color_table */
#ifdef GL_SUNX_constant_data
  _glewInfo_GL_SUNX_constant_data();
#endif /* GL_SUNX_constant_data */
#ifdef GL_SUN_convolution_border_modes
  _glewInfo_GL_SUN_convolution_border_modes();
#endif /* GL_SUN_convolution_border_modes */
#ifdef GL_SUN_global_alpha
  _glewInfo_GL_SUN_global_alpha();
#endif /* GL_SUN_global_alpha */
#ifdef GL_SUN_mesh_array
  _glewInfo_GL_SUN_mesh_array();
#endif /* GL_SUN_mesh_array */
#ifdef GL_SUN_read_video_pixels
  _glewInfo_GL_SUN_read_video_pixels();
#endif /* GL_SUN_read_video_pixels */
#ifdef GL_SUN_slice_accum
  _glewInfo_GL_SUN_slice_accum();
#endif /* GL_SUN_slice_accum */
#ifdef GL_SUN_triangle_list
  _glewInfo_GL_SUN_triangle_list();
#endif /* GL_SUN_triangle_list */
#ifdef GL_SUN_vertex
  _glewInfo_GL_SUN_vertex();
#endif /* GL_SUN_vertex */
#ifdef GL_WIN_phong_shading
  _glewInfo_GL_WIN_phong_shading();
#endif /* GL_WIN_phong_shading */
#ifdef GL_WIN_specular_fog
  _glewInfo_GL_WIN_specular_fog();
#endif /* GL_WIN_specular_fog */
#ifdef GL_WIN_swap_hint
  _glewInfo_GL_WIN_swap_hint();
#endif /* GL_WIN_swap_hint */
}

/* ------------------------------------------------------------------------ */

#ifdef _WIN32

static void wglewInfo ()
{
#ifdef WGL_3DFX_multisample
  _glewInfo_WGL_3DFX_multisample();
#endif /* WGL_3DFX_multisample */
#ifdef WGL_ARB_buffer_region
  _glewInfo_WGL_ARB_buffer_region();
#endif /* WGL_ARB_buffer_region */
#ifdef WGL_ARB_extensions_string
  _glewInfo_WGL_ARB_extensions_string();
#endif /* WGL_ARB_extensions_string */
#ifdef WGL_ARB_make_current_read
  _glewInfo_WGL_ARB_make_current_read();
#endif /* WGL_ARB_make_current_read */
#ifdef WGL_ARB_multisample
  _glewInfo_WGL_ARB_multisample();
#endif /* WGL_ARB_multisample */
#ifdef WGL_ARB_pbuffer
  _glewInfo_WGL_ARB_pbuffer();
#endif /* WGL_ARB_pbuffer */
#ifdef WGL_ARB_pixel_format
  _glewInfo_WGL_ARB_pixel_format();
#endif /* WGL_ARB_pixel_format */
#ifdef WGL_ARB_render_texture
  _glewInfo_WGL_ARB_render_texture();
#endif /* WGL_ARB_render_texture */
#ifdef WGL_ATI_pixel_format_float
  _glewInfo_WGL_ATI_pixel_format_float();
#endif /* WGL_ATI_pixel_format_float */
#ifdef WGL_EXT_depth_float
  _glewInfo_WGL_EXT_depth_float();
#endif /* WGL_EXT_depth_float */
#ifdef WGL_EXT_display_color_table
  _glewInfo_WGL_EXT_display_color_table();
#endif /* WGL_EXT_display_color_table */
#ifdef WGL_EXT_extensions_string
  _glewInfo_WGL_EXT_extensions_string();
#endif /* WGL_EXT_extensions_string */
#ifdef WGL_EXT_make_current_read
  _glewInfo_WGL_EXT_make_current_read();
#endif /* WGL_EXT_make_current_read */
#ifdef WGL_EXT_multisample
  _glewInfo_WGL_EXT_multisample();
#endif /* WGL_EXT_multisample */
#ifdef WGL_EXT_pbuffer
  _glewInfo_WGL_EXT_pbuffer();
#endif /* WGL_EXT_pbuffer */
#ifdef WGL_EXT_pixel_format
  _glewInfo_WGL_EXT_pixel_format();
#endif /* WGL_EXT_pixel_format */
#ifdef WGL_EXT_swap_control
  _glewInfo_WGL_EXT_swap_control();
#endif /* WGL_EXT_swap_control */
#ifdef WGL_I3D_digital_video_control
  _glewInfo_WGL_I3D_digital_video_control();
#endif /* WGL_I3D_digital_video_control */
#ifdef WGL_I3D_gamma
  _glewInfo_WGL_I3D_gamma();
#endif /* WGL_I3D_gamma */
#ifdef WGL_I3D_genlock
  _glewInfo_WGL_I3D_genlock();
#endif /* WGL_I3D_genlock */
#ifdef WGL_I3D_image_buffer
  _glewInfo_WGL_I3D_image_buffer();
#endif /* WGL_I3D_image_buffer */
#ifdef WGL_I3D_swap_frame_lock
  _glewInfo_WGL_I3D_swap_frame_lock();
#endif /* WGL_I3D_swap_frame_lock */
#ifdef WGL_I3D_swap_frame_usage
  _glewInfo_WGL_I3D_swap_frame_usage();
#endif /* WGL_I3D_swap_frame_usage */
#ifdef WGL_NV_float_buffer
  _glewInfo_WGL_NV_float_buffer();
#endif /* WGL_NV_float_buffer */
#ifdef WGL_NV_render_depth_texture
  _glewInfo_WGL_NV_render_depth_texture();
#endif /* WGL_NV_render_depth_texture */
#ifdef WGL_NV_render_texture_rectangle
  _glewInfo_WGL_NV_render_texture_rectangle();
#endif /* WGL_NV_render_texture_rectangle */
#ifdef WGL_NV_vertex_array_range
  _glewInfo_WGL_NV_vertex_array_range();
#endif /* WGL_NV_vertex_array_range */
#ifdef WGL_OML_sync_control
  _glewInfo_WGL_OML_sync_control();
#endif /* WGL_OML_sync_control */
}

#else /* _UNIX */

static void glxewInfo ()
{
#ifdef GLX_VERSION_1_2
  _glewInfo_GLX_VERSION_1_2();
#endif /* GLX_VERSION_1_2 */
#ifdef GLX_VERSION_1_3
  _glewInfo_GLX_VERSION_1_3();
#endif /* GLX_VERSION_1_3 */
#ifdef GLX_VERSION_1_4
  _glewInfo_GLX_VERSION_1_4();
#endif /* GLX_VERSION_1_4 */
#ifdef GLX_3DFX_multisample
  _glewInfo_GLX_3DFX_multisample();
#endif /* GLX_3DFX_multisample */
#ifdef GLX_ARB_get_proc_address
  _glewInfo_GLX_ARB_get_proc_address();
#endif /* GLX_ARB_get_proc_address */
#ifdef GLX_ARB_multisample
  _glewInfo_GLX_ARB_multisample();
#endif /* GLX_ARB_multisample */
#ifdef GLX_ATI_pixel_format_float
  _glewInfo_GLX_ATI_pixel_format_float();
#endif /* GLX_ATI_pixel_format_float */
#ifdef GLX_ATI_render_texture
  _glewInfo_GLX_ATI_render_texture();
#endif /* GLX_ATI_render_texture */
#ifdef GLX_EXT_import_context
  _glewInfo_GLX_EXT_import_context();
#endif /* GLX_EXT_import_context */
#ifdef GLX_EXT_scene_marker
  _glewInfo_GLX_EXT_scene_marker();
#endif /* GLX_EXT_scene_marker */
#ifdef GLX_EXT_visual_info
  _glewInfo_GLX_EXT_visual_info();
#endif /* GLX_EXT_visual_info */
#ifdef GLX_EXT_visual_rating
  _glewInfo_GLX_EXT_visual_rating();
#endif /* GLX_EXT_visual_rating */
#ifdef GLX_MESA_agp_offset
  _glewInfo_GLX_MESA_agp_offset();
#endif /* GLX_MESA_agp_offset */
#ifdef GLX_MESA_copy_sub_buffer
  _glewInfo_GLX_MESA_copy_sub_buffer();
#endif /* GLX_MESA_copy_sub_buffer */
#ifdef GLX_MESA_pixmap_colormap
  _glewInfo_GLX_MESA_pixmap_colormap();
#endif /* GLX_MESA_pixmap_colormap */
#ifdef GLX_MESA_release_buffers
  _glewInfo_GLX_MESA_release_buffers();
#endif /* GLX_MESA_release_buffers */
#ifdef GLX_MESA_set_3dfx_mode
  _glewInfo_GLX_MESA_set_3dfx_mode();
#endif /* GLX_MESA_set_3dfx_mode */
#ifdef GLX_NV_float_buffer
  _glewInfo_GLX_NV_float_buffer();
#endif /* GLX_NV_float_buffer */
#ifdef GLX_NV_vertex_array_range
  _glewInfo_GLX_NV_vertex_array_range();
#endif /* GLX_NV_vertex_array_range */
#ifdef GLX_OML_swap_method
  _glewInfo_GLX_OML_swap_method();
#endif /* GLX_OML_swap_method */
#if defined(GLX_OML_sync_control) && defined(__STDC_VERSION__) && (__STDC_VERSION__ >= 199901L)
#include <inttypes.h>
  _glewInfo_GLX_OML_sync_control();
#endif /* GLX_OML_sync_control */
#ifdef GLX_SGIS_blended_overlay
  _glewInfo_GLX_SGIS_blended_overlay();
#endif /* GLX_SGIS_blended_overlay */
#ifdef GLX_SGIS_color_range
  _glewInfo_GLX_SGIS_color_range();
#endif /* GLX_SGIS_color_range */
#ifdef GLX_SGIS_multisample
  _glewInfo_GLX_SGIS_multisample();
#endif /* GLX_SGIS_multisample */
#ifdef GLX_SGIS_shared_multisample
  _glewInfo_GLX_SGIS_shared_multisample();
#endif /* GLX_SGIS_shared_multisample */
#ifdef GLX_SGIX_fbconfig
  _glewInfo_GLX_SGIX_fbconfig();
#endif /* GLX_SGIX_fbconfig */
#ifdef GLX_SGIX_pbuffer
  _glewInfo_GLX_SGIX_pbuffer();
#endif /* GLX_SGIX_pbuffer */
#ifdef GLX_SGIX_swap_barrier
  _glewInfo_GLX_SGIX_swap_barrier();
#endif /* GLX_SGIX_swap_barrier */
#ifdef GLX_SGIX_swap_group
  _glewInfo_GLX_SGIX_swap_group();
#endif /* GLX_SGIX_swap_group */
#ifdef GLX_SGIX_video_resize
  _glewInfo_GLX_SGIX_video_resize();
#endif /* GLX_SGIX_video_resize */
#ifdef GLX_SGIX_visual_select_group
  _glewInfo_GLX_SGIX_visual_select_group();
#endif /* GLX_SGIX_visual_select_group */
#ifdef GLX_SGI_cushion
  _glewInfo_GLX_SGI_cushion();
#endif /* GLX_SGI_cushion */
#ifdef GLX_SGI_make_current_read
  _glewInfo_GLX_SGI_make_current_read();
#endif /* GLX_SGI_make_current_read */
#ifdef GLX_SGI_swap_control
  _glewInfo_GLX_SGI_swap_control();
#endif /* GLX_SGI_swap_control */
#ifdef GLX_SGI_video_sync
  _glewInfo_GLX_SGI_video_sync();
#endif /* GLX_SGI_video_sync */
#ifdef GLX_SUN_get_transparent_index
  _glewInfo_GLX_SUN_get_transparent_index();
#endif /* GLX_SUN_get_transparent_index */
#ifdef GLX_SUN_video_resize
  _glewInfo_GLX_SUN_video_resize();
#endif /* GLX_SUN_video_resize */
}

#endif /* _WIN32 */

/* ------------------------------------------------------------------------ */

#if defined(_WIN32) || !defined(__APPLE__) || defined(GLEW_APPLE_GLX)
int main (int argc, char** argv)
#else
int main (void)
#endif
{
  GLuint err;

#if defined(_WIN32) || !defined(__APPLE__) || defined(GLEW_APPLE_GLX)
  char* display = NULL;
  int visual = -1;

  if (glewParseArgs(argc-1, argv+1, &display, &visual))
  {
#if defined(_WIN32)
    fprintf(stderr, "Usage: glewinfo [-pf <id>]\n");
#else
    fprintf(stderr, "Usage: glewinfo [-display <display>] [-visual <id>]\n");
#endif
    return 1;
  }
#endif

#if defined(_WIN32)
  if (GL_TRUE == glewCreateContext(&visual))
#elif defined(__APPLE__) && !defined(GLEW_APPLE_GLX)
  if (GL_TRUE == glewCreateContext())
#else
  if (GL_TRUE == glewCreateContext(display, &visual))
#endif
  {
    fprintf(stderr, "Error: glewCreateContext failed\n");
    glewDestroyContext();
    return 1;
  }
  glewExperimental = GL_TRUE;
#ifdef GLEW_MX
  err = glewContextInit(glewGetContext());
#ifdef _WIN32
  err = err || wglewContextInit(wglewGetContext());
#elif !defined(__APPLE__) || defined(GLEW_APPLE_GLX)
  err = err || glxewContextInit(glxewGetContext());
#endif

#else
  err = glewInit();
#endif
  if (GLEW_OK != err)
  {
    fprintf(stderr, "Error [main]: glewInit failed: %s\n", glewGetErrorString(err));
    glewDestroyContext();
    return 1;
  }
#if defined(_WIN32)
  f = fopen("glewinfo.txt", "w");
  if (f == NULL) f = stdout;
#else
  f = stdout;
#endif
  fprintf(f, "---------------------------\n");
  fprintf(f, "    GLEW Extension Info\n");
  fprintf(f, "---------------------------\n\n");
  fprintf(f, "GLEW version %s\n", glewGetString(GLEW_VERSION));
#if defined(_WIN32)
  fprintf(f, "Reporting capabilities of pixelformat %d\n", visual);
#elif !defined(__APPLE__) || defined(GLEW_APPLE_GLX)
  fprintf(f, "Reporting capabilities of display %s, visual 0x%x\n", 
    display == NULL ? getenv("DISPLAY") : display, visual);
#endif
  fprintf(f, "Running on a %s from %s\n", 
	  glGetString(GL_RENDERER), glGetString(GL_VENDOR));
  fprintf(f, "OpenGL version %s is supported\n", glGetString(GL_VERSION));
  glewInfo();
#if defined(_WIN32)
  wglewInfo();
#else
  glxewInfo();
#endif
  if (f != stdout) fclose(f);
  glewDestroyContext();
  return 0;
}

/* ------------------------------------------------------------------------ */

#if defined(_WIN32) || !defined(__APPLE__) || defined(GLEW_APPLE_GLX)
GLboolean glewParseArgs (int argc, char** argv, char** display, int* visual)
{
  int p = 0;
  while (p < argc)
  {
#if defined(_WIN32)
    if (!strcmp(argv[p], "-pf") || !strcmp(argv[p], "-pixelformat"))
    {
      if (++p >= argc) return GL_TRUE;
      *display = 0;
      *visual = strtol(argv[p++], NULL, 0);
    }
    else
      return GL_TRUE;
#else
    if (!strcmp(argv[p], "-display"))
    {
      if (++p >= argc) return GL_TRUE;
      *display = argv[p++];
    }
    else if (!strcmp(argv[p], "-visual"))
    {
      if (++p >= argc) return GL_TRUE;
      *visual = (int)strtol(argv[p++], NULL, 0);
    }
    else
      return GL_TRUE;
#endif
  }
  return GL_FALSE;
}
#endif

/* ------------------------------------------------------------------------ */

#if defined(_WIN32)

HWND wnd = NULL;
HDC dc = NULL;
HGLRC rc = NULL;

GLboolean glewCreateContext (int* pixelformat)
{
  WNDCLASS wc;
  PIXELFORMATDESCRIPTOR pfd;
  /* register window class */
  ZeroMemory(&wc, sizeof(WNDCLASS));
  wc.hInstance = GetModuleHandle(NULL);
  wc.lpfnWndProc = DefWindowProc;
  wc.lpszClassName = "GLEW";
  if (0 == RegisterClass(&wc)) return GL_TRUE;
  /* create window */
  wnd = CreateWindow("GLEW", "GLEW", 0, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, 
                     CW_USEDEFAULT, NULL, NULL, GetModuleHandle(NULL), NULL);
  if (NULL == wnd) return GL_TRUE;
  /* get the device context */
  dc = GetDC(wnd);
  if (NULL == dc) return GL_TRUE;
  /* find pixel format */
  ZeroMemory(&pfd, sizeof(PIXELFORMATDESCRIPTOR));
  if (*pixelformat == -1) /* find default */
  {
    pfd.nSize = sizeof(PIXELFORMATDESCRIPTOR);
    pfd.nVersion = 1;
    pfd.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL;
    *pixelformat = ChoosePixelFormat(dc, &pfd);
    if (*pixelformat == 0) return GL_TRUE;
  }
  /* set the pixel format for the dc */
  if (FALSE == SetPixelFormat(dc, *pixelformat, &pfd)) return GL_TRUE;
  /* create rendering context */
  rc = wglCreateContext(dc);
  if (NULL == rc) return GL_TRUE;
  if (FALSE == wglMakeCurrent(dc, rc)) return GL_TRUE;
  return GL_FALSE;
}

void glewDestroyContext ()
{
  if (NULL != rc) wglMakeCurrent(NULL, NULL);
  if (NULL != rc) wglDeleteContext(wglGetCurrentContext());
  if (NULL != wnd && NULL != dc) ReleaseDC(wnd, dc);
  if (NULL != wnd) DestroyWindow(wnd);
  UnregisterClass("GLEW", GetModuleHandle(NULL));
}

/* ------------------------------------------------------------------------ */

#elif defined(__APPLE__) && !defined(GLEW_APPLE_GLX)

#include <AGL/agl.h>

AGLContext ctx, octx;

GLboolean glewCreateContext ()
{
  int attrib[] = { AGL_RGBA, AGL_NONE };
  AGLPixelFormat pf;
  /*int major, minor;
  SetPortWindowPort(wnd);
  aglGetVersion(&major, &minor);
  fprintf(stderr, "GL %d.%d\n", major, minor);*/
  pf = aglChoosePixelFormat(NULL, 0, attrib);
  if (NULL == pf) return GL_TRUE;
  ctx = aglCreateContext(pf, NULL);
  if (NULL == ctx || AGL_NO_ERROR != aglGetError()) return GL_TRUE;
  aglDestroyPixelFormat(pf);
  /*aglSetDrawable(ctx, GetWindowPort(wnd));*/
  octx = aglGetCurrentContext();
  if (NULL == aglSetCurrentContext(ctx)) return GL_TRUE;
  return GL_FALSE;
}

void glewDestroyContext ()
{
  aglSetCurrentContext(octx);
  if (NULL != ctx) aglDestroyContext(ctx);
}

/* ------------------------------------------------------------------------ */

#else /* __UNIX || (__APPLE__ && GLEW_APPLE_GLX) */

Display* dpy = NULL;
XVisualInfo* vi = NULL;
XVisualInfo* vis = NULL;
GLXContext ctx = NULL;
Window wnd = 0;
Colormap cmap = 0;

GLboolean glewCreateContext (const char* display, int* visual)
{
  int attrib[] = { GLX_RGBA, GLX_DOUBLEBUFFER, None };
  int erb, evb;
  XSetWindowAttributes swa;
  /* open display */
  dpy = XOpenDisplay(display);
  if (NULL == dpy) return GL_TRUE;
  /* query for glx */
  if (!glXQueryExtension(dpy, &erb, &evb)) return GL_TRUE;
  /* choose visual */
  if (*visual == -1)
  {
    vi = glXChooseVisual(dpy, DefaultScreen(dpy), attrib);
    if (NULL == vi) return GL_TRUE;
    *visual = (int)XVisualIDFromVisual(vi->visual);
  }
  else
  {
    int n_vis, i;
    vis = XGetVisualInfo(dpy, 0, NULL, &n_vis);
    for (i=0; i<n_vis; i++)
    {
      if ((int)XVisualIDFromVisual(vis[i].visual) == *visual)
        vi = &vis[i];
    }
    if (vi == NULL) return GL_TRUE;
  }
  /* create context */
  ctx = glXCreateContext(dpy, vi, None, True);
  if (NULL == ctx) return GL_TRUE;
  /* create window */
  /*wnd = XCreateSimpleWindow(dpy, RootWindow(dpy, vi->screen), 0, 0, 1, 1, 1, 0, 0);*/
  cmap = XCreateColormap(dpy, RootWindow(dpy, vi->screen), vi->visual, AllocNone);
  swa.border_pixel = 0;
  swa.colormap = cmap;
  wnd = XCreateWindow(dpy, RootWindow(dpy, vi->screen), 
                      0, 0, 1, 1, 0, vi->depth, InputOutput, vi->visual, 
                      CWBorderPixel | CWColormap, &swa);
  /* make context current */
  if (!glXMakeCurrent(dpy, wnd, ctx)) return GL_TRUE;
  return GL_FALSE;
}

void glewDestroyContext ()
{
  if (NULL != dpy && NULL != ctx) glXDestroyContext(dpy, ctx);
  if (NULL != dpy && 0 != wnd) XDestroyWindow(dpy, wnd);
  if (NULL != dpy && 0 != cmap) XFreeColormap(dpy, cmap);
  if (NULL != vis)
    XFree(vis);
  else if (NULL != vi)
    XFree(vi);
  if (NULL != dpy) XCloseDisplay(dpy);
}

#endif /* __UNIX || (__APPLE__ && GLEW_APPLE_GLX) */
