// $Id: inputdialog.cc,v 1.14 2002/05/14 08:25:44 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "window.hh"

class Gtk_InputDialog : public Gtk_Window
{public:
	typedef Gtk_Window Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_InputDialog();
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
};

static Gtk_InputDialog Gtk_InputDialog;

const std::string Gtk_InputDialog::TypeName(const Widget &w) const
{  return GtkPrefix()+"InputDialog";
}

const std::string Gtk_InputDialog::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"inputdialog.h";
}

Gtk_InputDialog::Gtk_InputDialog()
{  Writer["GtkInputDialog"]=this;
}

//#warning this code is untested
