// $Id: gnome_druid.cc,v 1.7 2003/04/24 08:20:41 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 2001 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

class Gnome_Druid : public Gtk_Container
{public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
//	virtual Subwidget IsSubwidget(const Widget &parent,const Widget &w2) const;
	void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	Gnome_Druid();
	virtual void AddChild(const Widget &w,CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
//	virtual const std::string InternalInstance(const Widget &parent,const Widget &w2) const;
	virtual bool isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const;
};

static Gnome_Druid Gnome_Druid;

const std::string Gnome_Druid::TypeName(const Widget &w) const
{  return GnomeUIPrefix()+"Druid";
}

const std::string Gnome_Druid::IncludeName(const Widget &w) const
{  return Configuration.GnomeUImmIncludePath()+"druid.h";
}

Gnome_Druid::Gnome_Druid()
{  Writer["GnomeDruid"]=this;
}

void Gnome_Druid::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);

// set_buttons_sensitive
}

void Gnome_Druid::AddChild(const Widget &w,CxxFile &f,const std::string &instance) const
{  f.Statement() << instance << "pages().push_back(" << Reference(w) << ')';
}

bool Gnome_Druid::isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const
{  const char prefix[]="gnome_druid_";
   const int plen(sizeof(prefix)-1);
   if (method.substr(0,plen)==prefix) method=method.substr(plen);
   if (method=="cancel" && args.empty())
   {  scope=Gnome_Druid::TypeName(w);
      is_signal=true;
      return true;
   }
   return Parent::isInternalMethod(w,method,args,scope,is_signal);
}

