// $Id: alignment.cc,v 1.16 2003/03/10 09:25:01 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "bin.hh"

class Gtk_Alignment : public Gtk_Bin
{public:
	typedef Gtk_Bin Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Alignment();
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const;
};

static Gtk_Alignment Gtk_Alignment;

const std::string Gtk_Alignment::TypeName(const Widget &w) const
{  return GtkPrefix()+"Alignment";
}

const std::string Gtk_Alignment::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"alignment.h";
}

void Gtk_Alignment::ConstructionArgs(const Widget &w, CxxFile &f) const
{
   if( w.hasProperty("xalign") && w.hasProperty("yalign") && 
       w.hasProperty("xscale") && w.hasProperty("yscale") )
   {
      f.FunctionArg() << w.getFloatProperty("xalign");
      f.FunctionArg() << w.getFloatProperty("yalign");
      f.FunctionArg() << w.getFloatProperty("xscale");
      f.FunctionArg() << w.getFloatProperty("yscale");
   }
   else f.FunctionArg();
}

Gtk_Alignment::Gtk_Alignment()
{  Writer["GtkAlignment"]=this;
}

//#warning this code is untested
