/*
 * Copyright (C) 2008 Gustavo Noronha Silva
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.  You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GKSU_ENVIRONMENT_H__
#define __GKSU_ENVIRONMENT_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define GKSU_TYPE_ENVIRONMENT (gksu_environment_get_type ())
#define GKSU_ENVIRONMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GKSU_TYPE_ENVIRONMENT, GksuEnvironment))
#define GKSU_ENVIRONMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GKSU_TYPE_ENVIRONMENT, GksuEnvironmentClass))
#define GKSU_IS_ENVIRONMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GKSU_TYPE_ENVIRONMENT))
#define GKSU_IS_ENVIRONMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GKSU_TYPE_ENVIRONMENT))
#define GKSU_ENVIRONMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GKSU_TYPE_ENVIRONMENT, GksuEnvironmentClass))

typedef struct _GksuEnvironment GksuEnvironment;
typedef struct _GksuEnvironmentClass GksuEnvironmentClass;
typedef struct _GksuEnvironmentPrivate GksuEnvironmentPrivate;

struct _GksuEnvironment {
	GObject parent_instance;
	GksuEnvironmentPrivate * priv;
};

struct _GksuEnvironmentClass {
	GObjectClass parent_class;
};


GHashTable* gksu_environment_get_variables (GksuEnvironment* self);
gboolean gksu_environment_validate_hash_table (GksuEnvironment* self, GHashTable* hash_table);
gboolean gksu_environment_is_variable_valid (GksuEnvironment* self, const char* name, const char* value);
GksuEnvironment* gksu_environment_new (void);
GType gksu_environment_get_type (void);


G_END_DECLS

#endif
