# -*- coding: utf-8 -*-

# Copyright 2015 Donne Martin. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You
# may not use this file except in compliance with the License. A copy of
# the License is located at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# or in the "license" file accompanying this file. This file is
# distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
# ANY KIND, either express or implied. See the License for the specific
# language governing permissions and limitations under the License.

raw_markdown = u"""
[Skip to content](#start-of-content)\n\n[ ](https://github.com/)\n\n[Sign up](/join) [Sign in](/login?return_to=%2Fdonnemartin%2Fsaws)\n\nThis repository\n\n  * [Explore](/explore)\n  * [Features](/features)\n  * [Enterprise](https://enterprise.github.com/)\n  * [Pricing](/pricing)\n\n  * [ Watch ](/login?return_to=%2Fdonnemartin%2Fsaws) [ 80 ](/donnemartin/saws/watchers)\n  * [ Star ](/login?return_to=%2Fdonnemartin%2Fsaws) [ 2,428 ](/donnemartin/saws/stargazers)\n  * [ Fork ](/login?return_to=%2Fdonnemartin%2Fsaws) [ 77 ](/donnemartin/saws/network)\n\n#  [donnemartin](/donnemartin)/**[saws](/donnemartin/saws)** ![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\n\n  * [ Code ![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) ](/donnemartin/saws)\n  * [ Issues ![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) ](/donnemartin/saws/issues)\n  * [ Pull requests ![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) ](/donnemartin/saws/pulls)\n\n  * [ Pulse ![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) ](/donnemartin/saws/pulse)\n  * [ Graphs ![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) ](/donnemartin/saws/graphs)\n\n### HTTPS clone URL\n\n### Subversion checkout URL\n\nYou can clone with \n\nHTTPS or \n\nSubversion. [ ](https://help.github.com/articles/which-remote-url-should-i-use)\n\n[ Download ZIP ](/donnemartin/saws/archive/master.zip "Download the contents of donnemartin/saws as a zip file" )\n\nA Supercharged AWS Command Line Interface (CLI). <http://bit.ly/git-saws>\n\n  * [ 544  commits ](/donnemartin/saws/commits/master)\n  * [ 2  branches ](/donnemartin/saws/branches)\n  * [ 7  releases ](/donnemartin/saws/releases)\n  * [ 5  contributors ](/donnemartin/saws/graphs/contributors)\n\n  1. [ Python 99.4% ](/donnemartin/saws/search?l=python)\n  2. [ Shell 0.6% ](/donnemartin/saws/search?l=bash)\n\nPython Shell\n\n[ ](/donnemartin/saws/find/master) [ ](/donnemartin/saws/compare)\n\n_Branch:_ master\n\nSwitch branches/tags\n\n  * [Branches](#)\n  * [Tags](#)\n\n[ develop  ](/donnemartin/saws/tree/develop) [ master  ](/donnemartin/saws/tree/master)\n\nNothing to show\n\n[0.3.2](/donnemartin/saws/tree/0.3.2 "0.3.2" )\n\n[0.3.1](/donnemartin/saws/tree/0.3.1 "0.3.1" )\n\n[0.3.0](/donnemartin/saws/tree/0.3.0 "0.3.0" )\n\n[0.2.1](/donnemartin/saws/tree/0.2.1 "0.2.1" )\n\n[0.2.0](/donnemartin/saws/tree/0.2.0 "0.2.0" )\n\n[0.1.1](/donnemartin/saws/tree/0.1.1 "0.1.1" )\n\n[0.1.0](/donnemartin/saws/tree/0.1.0 "0.1.0" )\n\nNothing to show\n\n[saws](/donnemartin/saws)/\n\nLatest commit [ 07c1d7d ](/donnemartin/saws/commit/07c1d7df22c9032b993d18f22162b91fb16e86d6) Nov 30, 2015 ![@donnemartin](https://avatars3.githubusercontent.com/u/5458997?v=3&s=40) [donnemartin](/donnemartin) [Fix](/donnemartin/saws/commit/07c1d7df22c9032b993d18f22162b91fb16e86d6 "Fix #66: Remove docs/build from the source repository." ) [#66](https://github.com/donnemartin/saws/issues/66 "Remove docs/build from the source repository." )[: Remove docs/build from the source repository.](/donnemartin/saws/commit/07c1d7df22c9032b993d18f22162b91fb16e86d6 "Fix #66: Remove docs/build from the source repository." )\n\n[Permalink](/donnemartin/saws/tree/07c1d7df22c9032b993d18f22162b91fb16e86d6) | Failed to load latest commit information.  \n---|---  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [docs](/donnemartin/saws/tree/master/docs "docs" ) |  [Fix](/donnemartin/saws/commit/07c1d7df22c9032b993d18f22162b91fb16e86d6 "Fix #66: Remove docs/build from the source repository." ) [#66](https://github.com/donnemartin/saws/issues/66 "Remove docs/build from the source repository." )[: Remove docs/build from the source repository.](/donnemartin/saws/commit/07c1d7df22c9032b993d18f22162b91fb16e86d6 "Fix #66: Remove docs/build from the source repository." ) |  Nov 30, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [saws](/donnemartin/saws/tree/master/saws "saws" ) |  [Merge branch \'master\' into develop](/donnemartin/saws/commit/4d174fe79f61eeeda363c0b03e9e53392da671ef "Merge branch \'master\' into develop\n\n* master:\n  Removed mention of scripts/release_pypi.sh, which is no longer used.\n  Updated commands." ) |  Nov 30, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [scripts](/donnemartin/saws/tree/master/scripts "scripts" ) |  [Updated CHANGELOG to README script to use the new CHANGELOG.rst.](/donnemartin/saws/commit/5c03b2cc6882590aa567a98cc8dceae780d1428c "Updated CHANGELOG to README script to use the new CHANGELOG.rst." ) |  Oct 16, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [tests](/donnemartin/saws/tree/master/tests "tests" ) |  [Fix linter line length issues.](/donnemartin/saws/commit/bf1afa4c73bf1a7dd462cb0c92f945d2b7d7cf5a "Fix linter line length issues." ) |  Oct 15, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [.gitchangelog.rc](/donnemartin/saws/blob/master/.gitchangelog.rc ".gitchangelog.rc" ) |  [Added gitchangelog.](/donnemartin/saws/commit/7347e0cc55a9ac75368152b9683881d41982a943 "Added gitchangelog." ) |  Sep 15, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [.gitignore](/donnemartin/saws/blob/master/.gitignore ".gitignore" ) |  [Fix](/donnemartin/saws/commit/07c1d7df22c9032b993d18f22162b91fb16e86d6 "Fix #66: Remove docs/build from the source repository." ) [#66](https://github.com/donnemartin/saws/issues/66 "Remove docs/build from the source repository." )[: Remove docs/build from the source repository.](/donnemartin/saws/commit/07c1d7df22c9032b993d18f22162b91fb16e86d6 "Fix #66: Remove docs/build from the source repository." ) |  Nov 30, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [.travis.yml](/donnemartin/saws/blob/master/.travis.yml ".travis.yml" ) |  [Revert Python 3.5 build and test support due to:](/donnemartin/saws/commit/36e073de59b0fbe872fb30c80f3521c3b558b37f "Revert Python 3.5 build and test support due to: https://github.com/travis-ci/travis-ci/issues/4794." ) [travis-ci/travis-ci#\u2026](https://github.com/travis-ci/travis-ci/issues/4794 "Tox builds for Python 3.5 fail" ) |  Sep 23, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [CHANGELOG.md](/donnemartin/saws/blob/master/CHANGELOG.md "CHANGELOG.md" ) |  [Prepped version 0.3.2.](/donnemartin/saws/commit/0408df93b135542c2388fe60444ba4651feec481 "Prepped version 0.3.2." ) |  Oct 16, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [CHANGELOG.rst](/donnemartin/saws/blob/master/CHANGELOG.rst "CHANGELOG.rst" ) |  [Prepped version 0.3.2.](/donnemartin/saws/commit/0408df93b135542c2388fe60444ba4651feec481 "Prepped version 0.3.2." ) |  Oct 16, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [CHECKLIST.md](/donnemartin/saws/blob/master/CHECKLIST.md "CHECKLIST.md" ) |  [Removed mention of scripts/release_pypi.sh, which is no longer used.](/donnemartin/saws/commit/ba73311f8dd04e9a1eb159ff4d8c741a22027e50 "Removed mention of scripts/release_pypi.sh, which is no longer used." ) |  Nov 16, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [CONTRIBUTING.md](/donnemartin/saws/blob/master/CONTRIBUTING.md "CONTRIBUTING.md" ) |  [Add note about AWS collaboration.](/donnemartin/saws/commit/9fb37599835024ef7c99a7f00822aab54904fa5b "Add note about AWS collaboration." ) |  Nov 30, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [Dockerfile](/donnemartin/saws/blob/master/Dockerfile "Dockerfile" ) |  [Add Dockerfile](/donnemartin/saws/commit/7e185a10918059f0c763b1437d540b78432ea1a9 "Add Dockerfile" ) |  Sep 26, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [INSTALLATION.md](/donnemartin/saws/blob/master/INSTALLATION.md "INSTALLATION.md" ) |  [Added INSTALLATION.md.](/donnemartin/saws/commit/8317c4c92441f40ce20dad5ced97fe090f77e93e "Added INSTALLATION.md." ) |  Oct 3, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [LICENSE.txt](/donnemartin/saws/blob/master/LICENSE.txt "LICENSE.txt" ) |  [Added LICENSE.](/donnemartin/saws/commit/1166ffddffffbd981868d700df1f8ecc2061847f "Added LICENSE." ) |  Sep 19, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [MANIFEST.in](/donnemartin/saws/blob/master/MANIFEST.in "MANIFEST.in" ) |  [Updated MANIFEST.in.](/donnemartin/saws/commit/cba64a756e8dd193bb93083ee7aecd4316c2c9b4 "Updated MANIFEST.in." ) |  Sep 19, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [README.md](/donnemartin/saws/blob/master/README.md "README.md" ) |  [Fix #todo-add-more-resources anchor link.](/donnemartin/saws/commit/8427a6432c58aa9f95bf4fe26ab76a13645a8261 "Fix #todo-add-more-resources anchor link." ) |  Nov 30, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [appveyor.yml](/donnemartin/saws/blob/master/appveyor.yml "appveyor.yml" ) |  [Added Appveyor support, inspired by](/donnemartin/saws/commit/f756340ad4f9f4d47860644b0e677f49dac575d4 "Added Appveyor support, inspired by https://github.com/audreyr/cookiecutter/blob/master/appveyor.yml." ) [https://github.com/audreyr/cookie\u2026](https://github.com/audreyr/cookiecutter/blob/master/appveyor.yml) |  Sep 28, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [requirements-dev.txt](/donnemartin/saws/blob/master/requirements-dev.txt "requirements-dev.txt" ) |  [Added Sphinx-PyPI-upload support.](/donnemartin/saws/commit/7068598aa117cc16d6e32000afa05963d3d76093 "Added Sphinx-PyPI-upload support." ) |  Sep 19, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [setup.cfg](/donnemartin/saws/blob/master/setup.cfg "setup.cfg" ) |  [Added Sphinx-PyPI-upload support.](/donnemartin/saws/commit/7068598aa117cc16d6e32000afa05963d3d76093 "Added Sphinx-PyPI-upload support." ) |  Sep 19, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [setup.py](/donnemartin/saws/blob/master/setup.py "setup.py" ) |  [Fixed](/donnemartin/saws/commit/1628d3efda27ba638833b54bdc3124db68a7fb30 "Fixed #53: Shortcuts should be placed separately in a .saws.shortcuts file." ) [#53](https://github.com/donnemartin/saws/issues/53 "Shortcuts should be placed separately in a .saws.shortcuts file" )[: Shortcuts should be placed separately in a .saws.shortcuts\u2026](/donnemartin/saws/commit/1628d3efda27ba638833b54bdc3124db68a7fb30 "Fixed #53: Shortcuts should be placed separately in a .saws.shortcuts file." ) |  Oct 14, 2015  \n![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif) |  [tox.ini](/donnemartin/saws/blob/master/tox.ini "tox.ini" ) |  [Revert Python 3.5 build and test support due to:](/donnemartin/saws/commit/36e073de59b0fbe872fb30c80f3521c3b558b37f "Revert Python 3.5 build and test support due to: https://github.com/travis-ci/travis-ci/issues/4794." ) [travis-ci/travis-ci#\u2026](https://github.com/travis-ci/travis-ci/issues/4794 "Tox builds for Python 3.5 fail" ) |  Sep 23, 2015  \n  \n###  README.md \n\n[![](https://camo.githubusercontent.com/2af72023269b0b320adf4ec55576435f5c8b79c4/687474703a2f2f692e696d6775722e636f6d2f767a43357a6d412e676966)](https://camo.githubusercontent.com/2af72023269b0b320adf4ec55576435f5c8b79c4/687474703a2f2f692e696d6775722e636f6d2f767a43357a6d412e676966)\n\n[![Build Status](https://camo.githubusercontent.com/c1d6d1e8f7cdac1e6a82bf900832bbbe52d61e95/68747470733a2f2f7472617669732d63692e6f72672f646f6e6e656d617274696e2f736177732e7376673f6272616e63683d6d6173746572)](https://travis-ci.org/donnemartin/saws) [![Documentation Status](https://camo.githubusercontent.com/41afe5f96e9f915ecd9706bdc7dfd19518eaf05a/68747470733a2f2f72656164746865646f63732e6f72672f70726f6a656374732f736177732f62616467652f3f76657273696f6e3d6c6174657374)](http://saws.readthedocs.org/en/latest/?badge=latest) [![Dependency Status](https://camo.githubusercontent.com/11e16ba1560f0232928945436bf86340615d85ae/68747470733a2f2f67656d6e617369756d2e636f6d2f646f6e6e656d617274696e2f736177732e737667)](https://gemnasium.com/donnemartin/saws) [![Codecov](https://camo.githubusercontent.com/e24a50e9dd63768d90d26a9f6be1cf3d0c3b0230/68747470733a2f2f696d672e736869656c64732e696f2f636f6465636f762f632f6769746875622f646f6e6e656d617274696e2f736177732e737667)](https://codecov.io/github/donnemartin/saws/saws)\n\n[![PyPI version](https://camo.githubusercontent.com/818edda38216a62a4bb36557372877febec35086/68747470733a2f2f62616467652e667572792e696f2f70792f736177732e737667)](http://badge.fury.io/py/saws) [![PyPI](https://camo.githubusercontent.com/04574f61c5dff98734bd6a013cc9217b9a428e47/68747470733a2f2f696d672e736869656c64732e696f2f707970692f707976657273696f6e732f736177732e737667)](https://pypi.python.org/pypi/saws/) [![License](https://camo.githubusercontent.com/8bf81d4b6a63eaf6f712e3092fe7238f8716e615/687474703a2f2f696d672e736869656c64732e696f2f3a6c6963656e73652d6170616368652d626c75652e737667)](http://www.apache.org/licenses/LICENSE-2.0.html)\n\n# [](#saws)SAWS\n\n## [](#motivation)Motivation\n\n### [](#aws-cli)AWS CLI\n\nAlthough the [AWS CLI](https://github.com/aws/aws-cli) is a great resource to manage your AWS-powered services, it\'s **tough to remember usage** of:\n\n  * 50+ top-level commands\n  * 1400+ subcommands\n  * Countless command-specific options\n  * Resources such as instance tags and buckets\n\n### [](#saws-a-supercharged-aws-cli)SAWS: A Supercharged AWS CLI\n\n`SAWS` aims to **supercharge** the AWS CLI with features focusing on:\n\n  * **Improving ease-of-use**\n  * **Increasing productivity**\n\nUnder the hood, `SAWS` is **powered by the AWS CLI** and supports the **same commands** and **command structure**.\n\n`SAWS` and `AWS CLI` Usage:\n    \n    \n    aws <command> <subcommand> [parameters] [options]\n    \n\n`SAWS` features:\n\n  * Auto-completion of: \n    * Commands\n    * Subcommands\n    * Options\n  * Auto-completion of resources: \n    * Bucket names\n    * Instance ids\n    * Instance tags\n    * [More coming soon!](#todo-add-more-resources)\n  * Customizable shortcuts\n  * Fuzzy completion of resources and shortcuts\n  * Fish-style auto-suggestions\n  * Syntax and output highlighting\n  * Execution of shell commands\n  * Command history\n  * Contextual help\n  * Toolbar options\n\n`SAWS` is available for Mac, Linux, Unix, and [Windows](#windows-support).\n\n[![](https://camo.githubusercontent.com/571a2d19a969447b477713d54d1d3ba46d7418ee/687474703a2f2f692e696d6775722e636f6d2f456f31327139542e706e67)](https://camo.githubusercontent.com/571a2d19a969447b477713d54d1d3ba46d7418ee/687474703a2f2f692e696d6775722e636f6d2f456f31327139542e706e67)\n\n## [](#index)Index\n\n### [](#features)Features\n\n  * [Syntax and Output Highlighting](#syntax-and-output-highlighting)\n  * [Auto-Completion of Commands, Subcommands, and Options](#auto-completion-of-commands-subcommands-and-options)\n  * [Auto-Completion of AWS Resources](#auto-completion-of-aws-resources)\n    * [S3 Buckets](#s3-buckets)\n    * [EC2 Instance Ids](#ec2-instance-ids)\n    * [EC2 Instance Tags](#ec2-instance-tags)\n    * [TODO: Add More Resources](#todo-add-more-resources)\n  * [Customizable Shortcuts](#customizable-shortcuts)\n  * [Fuzzy Resource and Shortcut Completion](#fuzzy-resource-and-shortcut-completion)\n  * [Fish-Style Auto-Suggestions](#fish-style-auto-suggestions)\n  * [Executing Shell Commands](#executing-shell-commands)\n  * [Command History](#command-history)\n  * [Contextual Help](#contextual-help)\n    * [Contextual Command Line Help](#contextual-command-line-help)\n    * [Contextual Web Docs](#contextual-web-docs)\n  * [Toolbar Options](#toolbar-options)\n  * [Windows Support](#windows-support)\n\n### [](#installation-and-tests)Installation and Tests\n\n  * [Installation](#installation)\n    * [Pip Installation](#pip-installation)\n    * [Virtual Environment and Docker Installation](#virtual-environment-and-docker-installation)\n    * [AWS Credentials and Named Profiles](#aws-credentials-and-named-profiles)\n    * [Supported Python Versions](#supported-python-versions)\n    * [Supported Platforms](#supported-platforms)\n  * [Developer Installation](#developer-installation)\n    * [Continuous Integration](#continuous-integration)\n    * [Dependencies Management](#dependencies-management)\n    * [Unit Tests and Code Coverage](#unit-tests-and-code-coverage)\n    * [Documentation](#documentation)\n\n### [](#misc)Misc\n\n  * [Contributing](#contributing)\n  * [Credits](#credits)\n  * [Contact Info](#contact-info)\n  * [License](#license)\n\n## [](#syntax-and-output-highlighting)Syntax and Output Highlighting\n\n[![](https://camo.githubusercontent.com/c527a4c00862bb1fe47c272a3c3563418f06866f/687474703a2f2f692e696d6775722e636f6d2f785144707737302e706e67)](https://camo.githubusercontent.com/c527a4c00862bb1fe47c272a3c3563418f06866f/687474703a2f2f692e696d6775722e636f6d2f785144707737302e706e67)\n\nYou can control which theme to load for syntax highlighting by updating your [~/.sawsrc](https://github.com/donnemartin/saws/blob/master/saws/sawsrc) file:\n    \n    \n    # Visual theme. Possible values: manni, igor, xcode, vim, autumn, vs, rrt,\n    # native, perldoc, borland, tango, emacs, friendly, monokai, paraiso-dark,\n    # colorful, murphy, bw, pastie, paraiso-light, trac, default, fruity\n    theme = vim\n    \n\n## [](#auto-completion-of-commands-subcommands-and-options)Auto-Completion of Commands, Subcommands, and Options\n\n`SAWS` provides smart autocompletion as you type. Entering the following command will interactively list and auto-complete all subcommands **specific only** to `ec2`:\n    \n    \n    aws ec2\n    \n\n[![](https://camo.githubusercontent.com/df93a08e1371694a8086f3b45ba6e5ec955212e2/687474703a2f2f692e696d6775722e636f6d2f5032744c3976572e706e67)](https://camo.githubusercontent.com/df93a08e1371694a8086f3b45ba6e5ec955212e2/687474703a2f2f692e696d6775722e636f6d2f5032744c3976572e706e67)\n\n## [](#auto-completion-of-aws-resources)Auto-Completion of AWS Resources\n\nIn addition to the default commands, subcommands, and options the AWS CLI provides, `SAWS` supports auto-completion of your AWS resources. Currently, bucket names, instance ids, and instance tags are included, with additional support for more resources [under development](#todo-add-more-resources).\n\n### [](#s3-buckets)S3 Buckets\n\nOption for `s3api`:\n    \n    \n    --bucket\n    \n\nSample Usage:\n    \n    \n    aws s3api get-bucket-acl --bucket\n    \n\nSyntax for `s3`:\n    \n    \n    s3://\n    \n\nSample Usage:\n    \n    \n    aws s3 ls s3://\n    \n\nNote: The example below demonstrates the use of [fuzzy resource completion](/donnemartin/saws/blob/master/fuzzy-resource-and-shortcutcompletion):\n\n[![](https://camo.githubusercontent.com/756f14d2ed77a7a9a3da9b0d9501cab9b7433e36/687474703a2f2f692e696d6775722e636f6d2f333943415335542e706e67)](https://camo.githubusercontent.com/756f14d2ed77a7a9a3da9b0d9501cab9b7433e36/687474703a2f2f692e696d6775722e636f6d2f333943415335542e706e67)\n\n### [](#ec2-instance-ids)EC2 Instance Ids\n\nOption for `ec2`:\n    \n    \n    --instance-ids\n    \n\nSample Usage:\n    \n    \n    aws ec2 describe-instances --instance-ids\n    aws ec2 ls --instance-ids\n    \n\nNote: The `ls` command demonstrates the use of [customizable shortcuts](#customizable-shortcuts):\n\n[![](https://camo.githubusercontent.com/d4b0298e0ecd0afc1dac0d62617a4be53a44f598/687474703a2f2f692e696d6775722e636f6d2f6a46794353586c2e706e67)](https://camo.githubusercontent.com/d4b0298e0ecd0afc1dac0d62617a4be53a44f598/687474703a2f2f692e696d6775722e636f6d2f6a46794353586c2e706e67)\n\n### [](#ec2-instance-tags)EC2 Instance Tags\n\nOption for `ec2`:\n    \n    \n    --ec2-tag-key\n    --ec2-tag-value\n    \n\nSample Usage:\n    \n    \n    aws ec2 ls --ec2-tag-key\n    aws ec2 ls --ec2-tag-value\n    \n\n**Tags support wildcards** with the `*` character.\n\nNote: `ls`, `--ec2-tag-value`, and `--ec2-tag-key` demonstrate the use of [customizable shortcuts](#customizable-shortcuts):\n\n[![](https://camo.githubusercontent.com/593e9fc80cc6e1fb8e0fd7324cb4cb3a1b51bf2f/687474703a2f2f692e696d6775722e636f6d2f56494b7747335a2e706e67)](https://camo.githubusercontent.com/593e9fc80cc6e1fb8e0fd7324cb4cb3a1b51bf2f/687474703a2f2f692e696d6775722e636f6d2f56494b7747335a2e706e67)\n\n### [](#todo-add-more-resources)TODO: Add More Resources\n\nFeel free to [submit an issue or a pull request](#contributions) if you\'d like support for additional resources.\n\n## [](#customizable-shortcuts)Customizable Shortcuts\n\nThe [~/.saws.shortcuts](https://github.com/donnemartin/saws/blob/master/saws/saws.shortcuts) file contains shortcuts that you can modify. It comes pre-populated with several [handy shortcuts](https://github.com/donnemartin/saws/blob/master/saws/saws.shortcuts) out of the box. You can combine shortcuts with [fuzzy completion](#fuzzy-resource-and-shortcut-completion) for even less keystrokes. Below are a few examples.\n\nList all EC2 instances:\n    \n    \n    aws ec2 ls\n    \n\nList all running EC2 instances:\n    \n    \n    aws ec2 ls --ec2-state running  # fuzzy shortcut: aws ecstate\n    \n\n[![](https://camo.githubusercontent.com/7b56fd124f76cf2a9573de7b963bbb791f4cae16/687474703a2f2f692e696d6775722e636f6d2f6a594645736f4d2e706e67)](https://camo.githubusercontent.com/7b56fd124f76cf2a9573de7b963bbb791f4cae16/687474703a2f2f692e696d6775722e636f6d2f6a594645736f4d2e706e67)\n\nList all EC2 instances with a matching tag (supports wildcards `*`):\n    \n    \n    aws ec2 ls --ec2-tag-key    # fuzzy shortcut: aws ectagk\n    aws ec2 ls --ec2-tag-value  # fuzzy shortcut: aws ectagv\n    \n\n[![](https://camo.githubusercontent.com/c45874a55d4ac6485ba78c6d4a91cc1d928703a4/687474703a2f2f692e696d6775722e636f6d2f505375775549772e706e67)](https://camo.githubusercontent.com/c45874a55d4ac6485ba78c6d4a91cc1d928703a4/687474703a2f2f692e696d6775722e636f6d2f505375775549772e706e67)\n\nList EC2 instance with matching id:\n    \n    \n    aws ec2 ls --instance-ids  # fuzzy shortcut: aws eclsi\n    \n\n[![](https://camo.githubusercontent.com/48136027017398a300b9fe968e50e2e7c2a8b18b/687474703a2f2f692e696d6775722e636f6d2f774763554373612e706e67)](https://camo.githubusercontent.com/48136027017398a300b9fe968e50e2e7c2a8b18b/687474703a2f2f692e696d6775722e636f6d2f774763554373612e706e67)\n\nList all DynamoDB tables:\n    \n    \n    aws dynamodb ls  # fuzzy shortcut: aws dls\n    \n\nList all EMR clusters:\n    \n    \n    aws emr ls  # fuzzy shortcut: aws emls\n    \n\nAdd/remove/modify shortcuts in your [~/.saws.shortcuts](https://github.com/donnemartin/saws/blob/master/saws/shortcuts) file to suit your needs.\n\nFeel free to submit:\n\n  * An issue to request additional shortcuts\n  * A pull request if you\'d like to share your shortcuts (see [contributing guidelines](#contributions))\n\n### [](#fuzzy-resource-and-shortcut-completion)Fuzzy Resource and Shortcut Completion\n\nTo toggle fuzzy completion of AWS resources and shortcuts, use `F3` key.\n\nSample fuzzy shortcuts to start and stop EC2 instances:\n    \n    \n    aws ecstop\n    aws ecstart\n    \n\nNote: Fuzzy completion currently only works with AWS [resources](#auto-completion-of-aws-resources) and [shortcuts](/donnemartin/saws/blob/master/customizable-shortcuts).\n\n[![](https://camo.githubusercontent.com/a918a4d70ca61189149746e052f5bb2ffec9ae65/687474703a2f2f692e696d6775722e636f6d2f374f76464843772e706e67)](https://camo.githubusercontent.com/a918a4d70ca61189149746e052f5bb2ffec9ae65/687474703a2f2f692e696d6775722e636f6d2f374f76464843772e706e67)\n\n### [](#fish-style-auto-suggestions)Fish-Style Auto-Suggestions\n\n`SAWS` supports Fish-style auto-suggestions. Use the `right arrow` key to complete a suggestion.\n\n[![](https://camo.githubusercontent.com/6671d93da542b2f2cdec589fcb2c174e3bbc25f6/687474703a2f2f692e696d6775722e636f6d2f743532303071312e706e67)](https://camo.githubusercontent.com/6671d93da542b2f2cdec589fcb2c174e3bbc25f6/687474703a2f2f692e696d6775722e636f6d2f743532303071312e706e67)\n\n### [](#executing-shell-commands)Executing Shell Commands\n\n`SAWS` allows you to execute shell commands from the `saws>` prompt.\n\n[![](https://camo.githubusercontent.com/4d26d484e5b94b7ca62607ec1557d847f5db96f3/687474703a2f2f692e696d6775722e636f6d2f4669536e3662322e706e67)](https://camo.githubusercontent.com/4d26d484e5b94b7ca62607ec1557d847f5db96f3/687474703a2f2f692e696d6775722e636f6d2f4669536e3662322e706e67)\n\n### [](#command-history)Command History\n\n`SAWS` keeps track of commands you enter and stores them in `~/.saws-history`. Use the up and down arrow keys to cycle through the command history.\n\n[![](https://camo.githubusercontent.com/a5ded83f813be928236c804a90d85fc0fd5e517d/687474703a2f2f692e696d6775722e636f6d2f7a3852724451422e706e67)](https://camo.githubusercontent.com/a5ded83f813be928236c804a90d85fc0fd5e517d/687474703a2f2f692e696d6775722e636f6d2f7a3852724451422e706e67)\n\n## [](#contextual-help)Contextual Help\n\n`SAWS` supports contextual command line `help` and contextual web `docs`.\n\n### [](#contextual-command-line-help)Contextual Command Line Help\n\nThe `help` command is powered by the AWS CLI and outputs help within the command line.\n\nUsage:\n    \n    \n    aws <command> <subcommand> help\n    \n\n[![](https://camo.githubusercontent.com/e10dae70d7f9303bc5fae0e3f5dba453fa905df7/687474703a2f2f692e696d6775722e636f6d2f7a536b7a7436792e706e67)](https://camo.githubusercontent.com/e10dae70d7f9303bc5fae0e3f5dba453fa905df7/687474703a2f2f692e696d6775722e636f6d2f7a536b7a7436792e706e67)\n\n### [](#contextual-web-docs)Contextual Web Docs\n\nSometimes you\'re not quite sure what specific command/subcommand/option combination you need to use. In such cases, browsing through several combinations with the `help` command line is cumbersome versus browsing the online AWS CLI docs through a web browser.\n\n`SAWS` supports contextual web docs with the `docs` command or the `F9` key. `SAWS` will display the web docs specific to the currently entered command and subcommand.\n\nUsage:\n    \n    \n    aws <command> <subcommand> docs\n    \n\n[![](https://camo.githubusercontent.com/e0a9e9bd21f2ff174f2e257f0c9966c6620d97d7/687474703a2f2f692e696d6775722e636f6d2f7a4b34494a59702e706e67)](https://camo.githubusercontent.com/e0a9e9bd21f2ff174f2e257f0c9966c6620d97d7/687474703a2f2f692e696d6775722e636f6d2f7a4b34494a59702e706e67)\n\n## [](#toolbar-options)Toolbar Options\n\n`SAWS` supports a number of toolbar options:\n\n  * `F2` toggles [output syntax highlighting](#syntax-and-output-highlighting)\n  * `F3` toggles [fuzzy completion of AWS resources and shortcuts](#fuzzy-resource-and-shortcut-completion)\n  * `F4` toggles [completion of shortcuts](#customizable-shortcuts)\n  * `F5` refreshes [resources for auto-completion](#auto-completion-of-aws-resources)\n  * `F9` displays the [contextual web docs](#contextual-web-docs)\n  * `F10` or `control d` exits `SAWS`\n\n[![](https://camo.githubusercontent.com/f1bb53eda629178af0d849a112193a91daca5628/687474703a2f2f692e696d6775722e636f6d2f37767a384f53632e706e67)](https://camo.githubusercontent.com/f1bb53eda629178af0d849a112193a91daca5628/687474703a2f2f692e696d6775722e636f6d2f37767a384f53632e706e67)\n\n### [](#windows-support)Windows Support\n\n`SAWS` has been tested on Windows 7 and Windows 10.\n\nOn Windows, the [.sawsrc](https://github.com/donnemartin/saws/blob/master/saws/sawsrc) file can be found in `%userprofile%`. For example:\n    \n    \n    C:\\Users\\dmartin\\.sawsrc\n    \n\nAlthough you can use the standard Windows command prompt, you\'ll probably have a better experience with either [cmder](https://github.com/cmderdev/cmder) or [conemu](https://github.com/Maximus5/ConEmu).\n\n[![](https://camo.githubusercontent.com/cfd9f911b9960308e0346d90ba4cf2338145fb52/687474703a2f2f692e696d6775722e636f6d2f7055774a57636b2e706e67)](https://camo.githubusercontent.com/cfd9f911b9960308e0346d90ba4cf2338145fb52/687474703a2f2f692e696d6775722e636f6d2f7055774a57636b2e706e67)\n\n## [](#installation)Installation\n\n### [](#pip-installation)Pip Installation\n\n[![PyPI version](https://camo.githubusercontent.com/818edda38216a62a4bb36557372877febec35086/68747470733a2f2f62616467652e667572792e696f2f70792f736177732e737667)](http://badge.fury.io/py/saws) [![PyPI](https://camo.githubusercontent.com/04574f61c5dff98734bd6a013cc9217b9a428e47/68747470733a2f2f696d672e736869656c64732e696f2f707970692f707976657273696f6e732f736177732e737667)](https://pypi.python.org/pypi/saws/)\n\n`SAWS` is hosted on [PyPI](https://pypi.python.org/pypi/saws). The following command will install `SAWS` along with dependencies such as the [AWS CLI](https://github.com/aws/aws-cli):\n    \n    \n    $ pip install saws\n    \n\nYou can also install the latest `SAWS` from GitHub source which can contain changes not yet pushed to PyPI:\n    \n    \n    $ pip install git+https://github.com/donnemartin/saws.git\n    \n\nIf you are not installing in a [virtualenv](#virtual-environment-and-docker-installation), run with `sudo`:\n    \n    \n    $ sudo pip install saws\n    \n\nOnce installed, start `SAWS`:\n    \n    \n    $ saws\n    \n\n### [](#virtual-environment-and-docker-installation)Virtual Environment and Docker Installation\n\nIt is recommended that you install Python packages in a [virtualenv](http://docs.python-guide.org/en/latest/dev/virtualenvs/) to avoid potential [issues with dependencies or permissions](https://github.com/donnemartin/saws/issues/15).\n\nTo view `SAWS` `virtualenv` and [Docker](https://www.docker.com/) installation instructions, click [here](https://github.com/donnemartin/saws/blob/master/INSTALLATION.md).\n\n### [](#aws-credentials-and-named-profiles)AWS Credentials and Named Profiles\n\n[Configure your credentials](https://github.com/aws/aws-cli#getting-started) with the AWS CLI:\n    \n    \n    $ aws configure\n    \n\nIf you\'d like to use a specific named profile with `SAWS`, run the following commands on OS X, Linux, or Unix:\n    \n    \n    $ export AWS_DEFAULT_PROFILE=user1\n    $ saws\n    \n\nOr as a one-liner:\n    \n    \n    $ AWS_DEFAULT_PROFILE=user1 saws\n    \n\nWindows users can run the following commands:\n    \n    \n    > set AWS_DEFAULT_PROFILE=user1\n    > saws\n    \n\nCommand line options for starting `SAWS` with a specific profile are [under development](https://github.com/donnemartin/saws/issues/16). For more details on how to install and configure the AWS CLI, refer to the following [documentation](http://docs.aws.amazon.com/cli/latest/userguide/installing.html).\n\n### [](#supported-python-versions)Supported Python Versions\n\n  * Python 2.6\n  * Python 2.7\n  * Python 3.3\n  * Python 3.4\n  * Pypy\n\nLight testing indicates that `SAWS` also seems to be compatible with Python 3.5.\n\nPypy3 is not supported due to [lack of support](https://github.com/boto/botocore/issues/622) from [boto](https://github.com/boto/boto).\n\n### [](#supported-platforms)Supported Platforms\n\n  * Mac OS X \n    * Tested on OS X 10.10\n  * Linux, Unix \n    * Tested on Ubuntu 14.04 LTS\n  * Windows \n    * Tested on Windows 7 and 10\n\n## [](#developer-installation)Developer Installation\n\nIf you\'re interested in contributing to `SAWS`, run the following commands:\n    \n    \n    $ git clone https://github.com/donnemartin/saws.git\n    $ pip install -e .\n    $ pip install -r requirements-dev.txt\n    $ saws\n    \n\n### [](#continuous-integration)Continuous Integration\n\n[![Build Status](https://camo.githubusercontent.com/c1d6d1e8f7cdac1e6a82bf900832bbbe52d61e95/68747470733a2f2f7472617669732d63692e6f72672f646f6e6e656d617274696e2f736177732e7376673f6272616e63683d6d6173746572)](https://travis-ci.org/donnemartin/saws)\n\nContinuous integration details are available on [Travis CI](https://travis-ci.org/donnemartin/saws).\n\n### [](#dependencies-management)Dependencies Management\n\n[![Dependency Status](https://camo.githubusercontent.com/11e16ba1560f0232928945436bf86340615d85ae/68747470733a2f2f67656d6e617369756d2e636f6d2f646f6e6e656d617274696e2f736177732e737667)](https://gemnasium.com/donnemartin/saws)\n\nDependencies management details are available on [Gemnasium](https://gemnasium.com/donnemartin/saws).\n\n### [](#unit-tests-and-code-coverage)Unit Tests and Code Coverage\n\n[![Codecov](https://camo.githubusercontent.com/e24a50e9dd63768d90d26a9f6be1cf3d0c3b0230/68747470733a2f2f696d672e736869656c64732e696f2f636f6465636f762f632f6769746875622f646f6e6e656d617274696e2f736177732e737667)](https://codecov.io/github/donnemartin/saws/saws)\n\n[![](https://camo.githubusercontent.com/a3588f226c5b2c9007fd9e49212ae8294c5bc023/687474703a2f2f636f6465636f762e696f2f6769746875622f646f6e6e656d617274696e2f736177732f6272616e63682e7376673f6272616e63683d6d6173746572)](https://camo.githubusercontent.com/a3588f226c5b2c9007fd9e49212ae8294c5bc023/687474703a2f2f636f6465636f762e696f2f6769746875622f646f6e6e656d617274696e2f736177732f6272616e63682e7376673f6272616e63683d6d6173746572)\n\nCode coverage details are available on [Codecov](https://codecov.io/github/donnemartin/saws/saws).\n\nRun unit tests in your active Python environment:\n    \n    \n    $ python tests/run_tests.py\n    \n\nRun unit tests with [tox](https://pypi.python.org/pypi/tox) on multiple Python environments:\n    \n    \n    $ tox\n    \n\n### [](#documentation)Documentation\n\n[![Documentation Status](https://camo.githubusercontent.com/41afe5f96e9f915ecd9706bdc7dfd19518eaf05a/68747470733a2f2f72656164746865646f63732e6f72672f70726f6a656374732f736177732f62616467652f3f76657273696f6e3d6c6174657374)](http://saws.readthedocs.org/en/latest/?badge=latest)\n\nSource code documentation is available on [Readthedocs.org](http://saws.readthedocs.org/en/latest/?badge=latest).\n\nRun the following to build the docs:\n    \n    \n    $ scripts/update_docs.sh\n    \n\n## [](#contributing)Contributing\n\nContributions are welcome!\n\nReview the [Contributing Guidelines](https://github.com/donnemartin/saws/blob/master/CONTRIBUTING.md) for details on how to:\n\n  * Submit issues\n  * Submit pull requests\n\n## [](#credits)Credits\n\n  * [AWS CLI](https://github.com/aws/aws-cli) by [AWS](https://github.com/aws) for powering `SAWS` under the hood\n  * [Python Prompt Toolkit](https://github.com/jonathanslenders/python-prompt-toolkit) by [jonathanslenders](https://github.com/jonathanslenders) for simplifying the creation of `SAWS`\n  * [Wharfee](https://github.com/j-bennet/wharfee) by [j-bennet](https://github.com/j-bennet) for inspiring the creation of `SAWS` and for some handy utility functions\n\n## [](#contact-info)Contact Info\n\nFeel free to contact me to discuss any issues, questions, or comments.\n\n  * Email: [donne.martin@gmail.com](mailto:donne.martin@gmail.com)\n  * Twitter: [donne_martin](https://twitter.com/donne_martin)\n  * GitHub: [donnemartin](https://github.com/donnemartin)\n  * LinkedIn: [donnemartin](https://www.linkedin.com/in/donnemartin)\n  * Website: [donnemartin.com](http://donnemartin.com)\n\n## [](#license)License\n    \n    \n    Copyright 2015 Donne Martin\n    \n    Licensed under the Apache License, Version 2.0 (the "License");\n    you may not use this file except in compliance with the License.\n    You may obtain a copy of the License at\n    \n       http://www.apache.org/licenses/LICENSE-2.0\n    \n    Unless required by applicable law or agreed to in writing, software\n    distributed under the License is distributed on an "AS IS" BASIS,\n    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n    See the License for the specific language governing permissions and\n    limitations under the License.\n    \n\n  * [Status](https://status.github.com/)\n  * [API](https://developer.github.com)\n  * [Training](https://training.github.com)\n  * [Shop](https://shop.github.com)\n  * [Blog](https://github.com/blog)\n  * [About](https://github.com/about)\n  * [Pricing](https://github.com/pricing)\n[ ](https://github.com)\n\n  * (C) 2015 GitHub, Inc.\n  * [Terms](https://github.com/site/terms)\n  * [Privacy](https://github.com/site/privacy)\n  * [Security](https://github.com/security)\n  * [Contact](https://github.com/contact)\n  * [Help](https://help.github.com)\n\nSomething went wrong with that request. Please try again. \n\nYou signed in with another tab or window. [Reload]() to refresh your session. You signed out in another tab or window. [Reload]() to refresh your session.\n
"""  # NOQA
formatted_markdown = u"""
\x1b[32m[Skip to content](#start-of-content)\x1b[0m\n\n\x1b[32m[ ](https://github.com/)\x1b[0m\n\n\x1b[32m[Sign up](/join)\x1b[0m \x1b[32m[Sign in](/login?return_to=%2Fdonnemartin%2Fsaws)\x1b[0m\n\nThis repository\n\n\x1b[36m  * \x1b[32m[Explore](/explore)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Features](/features)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Enterprise](https://enterprise.github.com/)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Pricing](/pricing)\x1b[0m\x1b[0m\n\n\x1b[36m  * \x1b[32m[ Watch ](/login?return_to=%2Fdonnemartin%2Fsaws)\x1b[0m \x1b[32m[ 80 ](/donnemartin/saws/watchers)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[ Star ](/login?return_to=%2Fdonnemartin%2Fsaws)\x1b[0m \x1b[32m[ 2,428 ](/donnemartin/saws/stargazers)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[ Fork ](/login?return_to=%2Fdonnemartin%2Fsaws)\x1b[0m \x1b[32m[ 77 ](/donnemartin/saws/network)\x1b[0m\x1b[0m\n\n\x1b[33m \x1b[32m[donnemartin](/donnemartin)\x1b[0m/\x1b[36m\x1b[32m[saws](/donnemartin/saws)\x1b[0m\x1b[0m \x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m\x1b[0m\n\n\x1b[36m  * \x1b[32m[ Code ![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m ](/donnemartin/saws)\x1b[0m\n\x1b[36m  * \x1b[32m[ Issues ![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m ](/donnemartin/saws/issues)\x1b[0m\n\x1b[36m  * \x1b[32m[ Pull requests ![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m ](/donnemartin/saws/pulls)\x1b[0m\n\n\x1b[36m  * \x1b[32m[ Pulse ![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m ](/donnemartin/saws/pulse)\x1b[0m\n\x1b[36m  * \x1b[32m[ Graphs ![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m ](/donnemartin/saws/graphs)\x1b[0m\n\n\x1b[33mHTTPS clone URL\x1b[0m\n\n\x1b[33mSubversion checkout URL\x1b[0m\n\nYou can clone with\n\nHTTPS or\n\nSubversion. \x1b[32m[ ](https://help.github.com/articles/which-remote-url-should-i-use)\x1b[0m\n\n\x1b[32m[ Download ZIP ](/donnemartin/saws/archive/master.zip "Download the contents of donnemartin/saws as a zip file" )\x1b[0m\n\nA Supercharged AWS Command Line Interface (CLI). <http://bit.ly/git-saws>\n\n\x1b[36m  * \x1b[32m[ 544  commits ](/donnemartin/saws/commits/master)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[ 2  branches ](/donnemartin/saws/branches)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[ 7  releases ](/donnemartin/saws/releases)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[ 5  contributors ](/donnemartin/saws/graphs/contributors)\x1b[0m\x1b[0m\n\n1. \x1b[32m[ Python 99.4% ](/donnemartin/saws/search?l=python)\x1b[0m\n  2. \x1b[32m[ Shell 0.6% ](/donnemartin/saws/search?l=bash)\x1b[0m\n\nPython Shell\n\n\x1b[32m[ ](/donnemartin/saws/find/master)\x1b[0m \x1b[32m[ ](/donnemartin/saws/compare)\x1b[0m\n\n_Branch:_ master\n\nSwitch branches/tags\n\n\x1b[36m  * \x1b[32m[Branches](#)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Tags](#)\x1b[0m\x1b[0m\n\n\x1b[32m[ develop  ](/donnemartin/saws/tree/develop)\x1b[0m \x1b[32m[ master  ](/donnemartin/saws/tree/master)\x1b[0m\n\nNothing to show\n\n\x1b[32m[0.3.2](/donnemartin/saws/tree/0.3.2 "0.3.2" )\x1b[0m\n\n\x1b[32m[0.3.1](/donnemartin/saws/tree/0.3.1 "0.3.1" )\x1b[0m\n\n\x1b[32m[0.3.0](/donnemartin/saws/tree/0.3.0 "0.3.0" )\x1b[0m\n\n\x1b[32m[0.2.1](/donnemartin/saws/tree/0.2.1 "0.2.1" )\x1b[0m\n\n\x1b[32m[0.2.0](/donnemartin/saws/tree/0.2.0 "0.2.0" )\x1b[0m\n\n\x1b[32m[0.1.1](/donnemartin/saws/tree/0.1.1 "0.1.1" )\x1b[0m\n\n\x1b[32m[0.1.0](/donnemartin/saws/tree/0.1.0 "0.1.0" )\x1b[0m\n\nNothing to show\n\n\x1b[32m[saws](/donnemartin/saws)\x1b[0m/\n\nLatest commit \x1b[32m[ 07c1d7d ](/donnemartin/saws/commit/07c1d7df22c9032b993d18f22162b91fb16e86d6)\x1b[0m Nov 30, 2015 \x1b[32m![@donnemartin](https://avatars3.githubusercontent.com/u/5458997?v=3&s=40)\x1b[0m \x1b[32m[donnemartin](/donnemartin)\x1b[0m \x1b[32m[Fix](/donnemartin/saws/commit/07c1d7df22c9032b993d18f22162b91fb16e86d6 "Fix #66: Remove docs/build from the source repository." )\x1b[0m \x1b[32m[#66](https://github.com/donnemartin/saws/issues/66 "Remove docs/build from the source repository." )\x1b[0m\x1b[32m[: Remove docs/build from the source repository.](/donnemartin/saws/commit/07c1d7df22c9032b993d18f22162b91fb16e86d6 "Fix #66: Remove docs/build from the source repository." )\x1b[0m\n\n\x1b[32m[Permalink](/donnemartin/saws/tree/07c1d7df22c9032b993d18f22162b91fb16e86d6)\x1b[0m | Failed to load latest commit information.  \n---|---  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[docs](/donnemartin/saws/tree/master/docs "docs" )\x1b[0m |  \x1b[32m[Fix](/donnemartin/saws/commit/07c1d7df22c9032b993d18f22162b91fb16e86d6 "Fix #66: Remove docs/build from the source repository." )\x1b[0m \x1b[32m[#66](https://github.com/donnemartin/saws/issues/66 "Remove docs/build from the source repository." )\x1b[0m\x1b[32m[: Remove docs/build from the source repository.](/donnemartin/saws/commit/07c1d7df22c9032b993d18f22162b91fb16e86d6 "Fix #66: Remove docs/build from the source repository." )\x1b[0m |  Nov 30, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[saws](/donnemartin/saws/tree/master/saws "saws" )\x1b[0m |  \x1b[32m[Merge branch \'master\' into develop](/donnemartin/saws/commit/4d174fe79f61eeeda363c0b03e9e53392da671ef "Merge branch \'master\' into develop\n\n* master:\n  Removed mention of scripts/release_pypi.sh, which is no longer used.\n  Updated commands." )\x1b[0m |  Nov 30, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[scripts](/donnemartin/saws/tree/master/scripts "scripts" )\x1b[0m |  \x1b[32m[Updated CHANGELOG to README script to use the new CHANGELOG.rst.](/donnemartin/saws/commit/5c03b2cc6882590aa567a98cc8dceae780d1428c "Updated CHANGELOG to README script to use the new CHANGELOG.rst." )\x1b[0m |  Oct 16, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[tests](/donnemartin/saws/tree/master/tests "tests" )\x1b[0m |  \x1b[32m[Fix linter line length issues.](/donnemartin/saws/commit/bf1afa4c73bf1a7dd462cb0c92f945d2b7d7cf5a "Fix linter line length issues." )\x1b[0m |  Oct 15, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[.gitchangelog.rc](/donnemartin/saws/blob/master/.gitchangelog.rc ".gitchangelog.rc" )\x1b[0m |  \x1b[32m[Added gitchangelog.](/donnemartin/saws/commit/7347e0cc55a9ac75368152b9683881d41982a943 "Added gitchangelog." )\x1b[0m |  Sep 15, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[.gitignore](/donnemartin/saws/blob/master/.gitignore ".gitignore" )\x1b[0m |  \x1b[32m[Fix](/donnemartin/saws/commit/07c1d7df22c9032b993d18f22162b91fb16e86d6 "Fix #66: Remove docs/build from the source repository." )\x1b[0m \x1b[32m[#66](https://github.com/donnemartin/saws/issues/66 "Remove docs/build from the source repository." )\x1b[0m\x1b[32m[: Remove docs/build from the source repository.](/donnemartin/saws/commit/07c1d7df22c9032b993d18f22162b91fb16e86d6 "Fix #66: Remove docs/build from the source repository." )\x1b[0m |  Nov 30, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[.travis.yml](/donnemartin/saws/blob/master/.travis.yml ".travis.yml" )\x1b[0m |  \x1b[32m[Revert Python 3.5 build and test support due to:](/donnemartin/saws/commit/36e073de59b0fbe872fb30c80f3521c3b558b37f "Revert Python 3.5 build and test support due to: https://github.com/travis-ci/travis-ci/issues/4794." )\x1b[0m \x1b[32m[travis-ci/travis-ci#…](https://github.com/travis-ci/travis-ci/issues/4794 "Tox builds for Python 3.5 fail" )\x1b[0m |  Sep 23, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[CHANGELOG.md](/donnemartin/saws/blob/master/CHANGELOG.md "CHANGELOG.md" )\x1b[0m |  \x1b[32m[Prepped version 0.3.2.](/donnemartin/saws/commit/0408df93b135542c2388fe60444ba4651feec481 "Prepped version 0.3.2." )\x1b[0m |  Oct 16, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[CHANGELOG.rst](/donnemartin/saws/blob/master/CHANGELOG.rst "CHANGELOG.rst" )\x1b[0m |  \x1b[32m[Prepped version 0.3.2.](/donnemartin/saws/commit/0408df93b135542c2388fe60444ba4651feec481 "Prepped version 0.3.2." )\x1b[0m |  Oct 16, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[CHECKLIST.md](/donnemartin/saws/blob/master/CHECKLIST.md "CHECKLIST.md" )\x1b[0m |  \x1b[32m[Removed mention of scripts/release_pypi.sh, which is no longer used.](/donnemartin/saws/commit/ba73311f8dd04e9a1eb159ff4d8c741a22027e50 "Removed mention of scripts/release_pypi.sh, which is no longer used." )\x1b[0m |  Nov 16, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[CONTRIBUTING.md](/donnemartin/saws/blob/master/CONTRIBUTING.md "CONTRIBUTING.md" )\x1b[0m |  \x1b[32m[Add note about AWS collaboration.](/donnemartin/saws/commit/9fb37599835024ef7c99a7f00822aab54904fa5b "Add note about AWS collaboration." )\x1b[0m |  Nov 30, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[Dockerfile](/donnemartin/saws/blob/master/Dockerfile "Dockerfile" )\x1b[0m |  \x1b[32m[Add Dockerfile](/donnemartin/saws/commit/7e185a10918059f0c763b1437d540b78432ea1a9 "Add Dockerfile" )\x1b[0m |  Sep 26, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[INSTALLATION.md](/donnemartin/saws/blob/master/INSTALLATION.md "INSTALLATION.md" )\x1b[0m |  \x1b[32m[Added INSTALLATION.md.](/donnemartin/saws/commit/8317c4c92441f40ce20dad5ced97fe090f77e93e "Added INSTALLATION.md." )\x1b[0m |  Oct 3, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[LICENSE.txt](/donnemartin/saws/blob/master/LICENSE.txt "LICENSE.txt" )\x1b[0m |  \x1b[32m[Added LICENSE.](/donnemartin/saws/commit/1166ffddffffbd981868d700df1f8ecc2061847f "Added LICENSE." )\x1b[0m |  Sep 19, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[MANIFEST.in](/donnemartin/saws/blob/master/MANIFEST.in "MANIFEST.in" )\x1b[0m |  \x1b[32m[Updated MANIFEST.in.](/donnemartin/saws/commit/cba64a756e8dd193bb93083ee7aecd4316c2c9b4 "Updated MANIFEST.in." )\x1b[0m |  Sep 19, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[README.md](/donnemartin/saws/blob/master/README.md "README.md" )\x1b[0m |  \x1b[32m[Fix #todo-add-more-resources anchor link.](/donnemartin/saws/commit/8427a6432c58aa9f95bf4fe26ab76a13645a8261 "Fix #todo-add-more-resources anchor link." )\x1b[0m |  Nov 30, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[appveyor.yml](/donnemartin/saws/blob/master/appveyor.yml "appveyor.yml" )\x1b[0m |  \x1b[32m[Added Appveyor support, inspired by](/donnemartin/saws/commit/f756340ad4f9f4d47860644b0e677f49dac575d4 "Added Appveyor support, inspired by https://github.com/audreyr/cookiecutter/blob/master/appveyor.yml." )\x1b[0m \x1b[32m[https://github.com/audreyr/cookie…](https://github.com/audreyr/cookiecutter/blob/master/appveyor.yml)\x1b[0m |  Sep 28, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[requirements-dev.txt](/donnemartin/saws/blob/master/requirements-dev.txt "requirements-dev.txt" )\x1b[0m |  \x1b[32m[Added Sphinx-PyPI-upload support.](/donnemartin/saws/commit/7068598aa117cc16d6e32000afa05963d3d76093 "Added Sphinx-PyPI-upload support." )\x1b[0m |  Sep 19, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[setup.cfg](/donnemartin/saws/blob/master/setup.cfg "setup.cfg" )\x1b[0m |  \x1b[32m[Added Sphinx-PyPI-upload support.](/donnemartin/saws/commit/7068598aa117cc16d6e32000afa05963d3d76093 "Added Sphinx-PyPI-upload support." )\x1b[0m |  Sep 19, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[setup.py](/donnemartin/saws/blob/master/setup.py "setup.py" )\x1b[0m |  \x1b[32m[Fixed](/donnemartin/saws/commit/1628d3efda27ba638833b54bdc3124db68a7fb30 "Fixed #53: Shortcuts should be placed separately in a .saws.shortcuts file." )\x1b[0m \x1b[32m[#53](https://github.com/donnemartin/saws/issues/53 "Shortcuts should be placed separately in a .saws.shortcuts file" )\x1b[0m\x1b[32m[: Shortcuts should be placed separately in a .saws.shortcuts…](/donnemartin/saws/commit/1628d3efda27ba638833b54bdc3124db68a7fb30 "Fixed #53: Shortcuts should be placed separately in a .saws.shortcuts file." )\x1b[0m |  Oct 14, 2015  \n\x1b[32m![](https://assets-cdn.github.com/images/spinners/octocat-spinner-32.gif)\x1b[0m |  \x1b[32m[tox.ini](/donnemartin/saws/blob/master/tox.ini "tox.ini" )\x1b[0m |  \x1b[32m[Revert Python 3.5 build and test support due to:](/donnemartin/saws/commit/36e073de59b0fbe872fb30c80f3521c3b558b37f "Revert Python 3.5 build and test support due to: https://github.com/travis-ci/travis-ci/issues/4794." )\x1b[0m \x1b[32m[travis-ci/travis-ci#…](https://github.com/travis-ci/travis-ci/issues/4794 "Tox builds for Python 3.5 fail" )\x1b[0m |  Sep 23, 2015\n\n\x1b[33m README.md \x1b[0m\n\n\x1b[32m[![](https://camo.githubusercontent.com/2af72023269b0b320adf4ec55576435f5c8b79c4/687474703a2f2f692e696d6775722e636f6d2f767a43357a6d412e676966)\x1b[0m](https://camo.githubusercontent.com/2af72023269b0b320adf4ec55576435f5c8b79c4/687474703a2f2f692e696d6775722e636f6d2f767a43357a6d412e676966)\n\n\x1b[32m[![Build Status](https://camo.githubusercontent.com/c1d6d1e8f7cdac1e6a82bf900832bbbe52d61e95/68747470733a2f2f7472617669732d63692e6f72672f646f6e6e656d617274696e2f736177732e7376673f6272616e63683d6d6173746572)\x1b[0m](https://travis-ci.org/donnemartin/saws) \x1b[32m[![Documentation Status](https://camo.githubusercontent.com/41afe5f96e9f915ecd9706bdc7dfd19518eaf05a/68747470733a2f2f72656164746865646f63732e6f72672f70726f6a656374732f736177732f62616467652f3f76657273696f6e3d6c6174657374)\x1b[0m](http://saws.readthedocs.org/en/latest/?badge=latest) \x1b[32m[![Dependency Status](https://camo.githubusercontent.com/11e16ba1560f0232928945436bf86340615d85ae/68747470733a2f2f67656d6e617369756d2e636f6d2f646f6e6e656d617274696e2f736177732e737667)\x1b[0m](https://gemnasium.com/donnemartin/saws) \x1b[32m[![Codecov](https://camo.githubusercontent.com/e24a50e9dd63768d90d26a9f6be1cf3d0c3b0230/68747470733a2f2f696d672e736869656c64732e696f2f636f6465636f762f632f6769746875622f646f6e6e656d617274696e2f736177732e737667)\x1b[0m](https://codecov.io/github/donnemartin/saws/saws)\n\n\x1b[32m[![PyPI version](https://camo.githubusercontent.com/818edda38216a62a4bb36557372877febec35086/68747470733a2f2f62616467652e667572792e696f2f70792f736177732e737667)\x1b[0m](http://badge.fury.io/py/saws) \x1b[32m[![PyPI](https://camo.githubusercontent.com/04574f61c5dff98734bd6a013cc9217b9a428e47/68747470733a2f2f696d672e736869656c64732e696f2f707970692f707976657273696f6e732f736177732e737667)\x1b[0m](https://pypi.python.org/pypi/saws/) \x1b[32m[![License](https://camo.githubusercontent.com/8bf81d4b6a63eaf6f712e3092fe7238f8716e615/687474703a2f2f696d672e736869656c64732e696f2f3a6c6963656e73652d6170616368652d626c75652e737667)\x1b[0m](http://www.apache.org/licenses/LICENSE-2.0.html)\n\n\x1b[33m\x1b[32m[](#saws)\x1b[0mSAWS\x1b[0m\n\n\x1b[33m\x1b[32m[](#motivation)\x1b[0mMotivation\x1b[0m\n\n\x1b[33m\x1b[32m[](#aws-cli)\x1b[0mAWS CLI\x1b[0m\n\nAlthough the \x1b[32m[AWS CLI](https://github.com/aws/aws-cli)\x1b[0m is a great resource to manage your AWS-powered services, it\'s \x1b[36mtough to remember usage\x1b[0m of:\n\n\x1b[36m  * 50+ top-level commands\x1b[0m\n\x1b[36m  * 1400+ subcommands\x1b[0m\n\x1b[36m  * Countless command-specific options\x1b[0m\n\x1b[36m  * Resources such as instance tags and buckets\x1b[0m\n\n\x1b[33m\x1b[32m[](#saws-a-supercharged-aws-cli)\x1b[0mSAWS: A Supercharged AWS CLI\x1b[0m\n\n\x1b[36m`SAWS`\x1b[0m aims to \x1b[36msupercharge\x1b[0m the AWS CLI with features focusing on:\n\n\x1b[36m  * \x1b[36mImproving ease-of-use\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[36mIncreasing productivity\x1b[0m\x1b[0m\n\nUnder the hood, \x1b[36m`SAWS`\x1b[0m is \x1b[36mpowered by the AWS CLI\x1b[0m and supports the \x1b[36msame commands\x1b[0m and \x1b[36mcommand structure\x1b[0m.\n\n\x1b[36m`SAWS`\x1b[0m and \x1b[36m`AWS CLI`\x1b[0m Usage:\n\naws <command> <subcommand> [parameters] [options]\n\n\x1b[36m`SAWS`\x1b[0m features:\n\n\x1b[36m  * Auto-completion of: \x1b[0m\n  \x1b[36m  * Commands\x1b[0m\n  \x1b[36m  * Subcommands\x1b[0m\n  \x1b[36m  * Options\x1b[0m\n\x1b[36m  * Auto-completion of resources: \x1b[0m\n  \x1b[36m  * Bucket names\x1b[0m\n  \x1b[36m  * Instance ids\x1b[0m\n  \x1b[36m  * Instance tags\x1b[0m\n  \x1b[36m  * \x1b[32m[More coming soon!](#todo-add-more-resources)\x1b[0m\x1b[0m\n\x1b[36m  * Customizable shortcuts\x1b[0m\n\x1b[36m  * Fuzzy completion of resources and shortcuts\x1b[0m\n\x1b[36m  * Fish-style auto-suggestions\x1b[0m\n\x1b[36m  * Syntax and output highlighting\x1b[0m\n\x1b[36m  * Execution of shell commands\x1b[0m\n\x1b[36m  * Command history\x1b[0m\n\x1b[36m  * Contextual help\x1b[0m\n\x1b[36m  * Toolbar options\x1b[0m\n\n\x1b[36m`SAWS`\x1b[0m is available for Mac, Linux, Unix, and \x1b[32m[Windows](#windows-support)\x1b[0m.\n\n\x1b[32m[![](https://camo.githubusercontent.com/571a2d19a969447b477713d54d1d3ba46d7418ee/687474703a2f2f692e696d6775722e636f6d2f456f31327139542e706e67)\x1b[0m](https://camo.githubusercontent.com/571a2d19a969447b477713d54d1d3ba46d7418ee/687474703a2f2f692e696d6775722e636f6d2f456f31327139542e706e67)\n\n\x1b[33m\x1b[32m[](#index)\x1b[0mIndex\x1b[0m\n\n\x1b[33m\x1b[32m[](#features)\x1b[0mFeatures\x1b[0m\n\n\x1b[36m  * \x1b[32m[Syntax and Output Highlighting](#syntax-and-output-highlighting)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Auto-Completion of Commands, Subcommands, and Options](#auto-completion-of-commands-subcommands-and-options)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Auto-Completion of AWS Resources](#auto-completion-of-aws-resources)\x1b[0m\x1b[0m\n  \x1b[36m  * \x1b[32m[S3 Buckets](#s3-buckets)\x1b[0m\x1b[0m\n  \x1b[36m  * \x1b[32m[EC2 Instance Ids](#ec2-instance-ids)\x1b[0m\x1b[0m\n  \x1b[36m  * \x1b[32m[EC2 Instance Tags](#ec2-instance-tags)\x1b[0m\x1b[0m\n  \x1b[36m  * \x1b[32m[TODO: Add More Resources](#todo-add-more-resources)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Customizable Shortcuts](#customizable-shortcuts)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Fuzzy Resource and Shortcut Completion](#fuzzy-resource-and-shortcut-completion)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Fish-Style Auto-Suggestions](#fish-style-auto-suggestions)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Executing Shell Commands](#executing-shell-commands)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Command History](#command-history)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Contextual Help](#contextual-help)\x1b[0m\x1b[0m\n  \x1b[36m  * \x1b[32m[Contextual Command Line Help](#contextual-command-line-help)\x1b[0m\x1b[0m\n  \x1b[36m  * \x1b[32m[Contextual Web Docs](#contextual-web-docs)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Toolbar Options](#toolbar-options)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Windows Support](#windows-support)\x1b[0m\x1b[0m\n\n\x1b[33m\x1b[32m[](#installation-and-tests)\x1b[0mInstallation and Tests\x1b[0m\n\n\x1b[36m  * \x1b[32m[Installation](#installation)\x1b[0m\x1b[0m\n  \x1b[36m  * \x1b[32m[Pip Installation](#pip-installation)\x1b[0m\x1b[0m\n  \x1b[36m  * \x1b[32m[Virtual Environment and Docker Installation](#virtual-environment-and-docker-installation)\x1b[0m\x1b[0m\n  \x1b[36m  * \x1b[32m[AWS Credentials and Named Profiles](#aws-credentials-and-named-profiles)\x1b[0m\x1b[0m\n  \x1b[36m  * \x1b[32m[Supported Python Versions](#supported-python-versions)\x1b[0m\x1b[0m\n  \x1b[36m  * \x1b[32m[Supported Platforms](#supported-platforms)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Developer Installation](#developer-installation)\x1b[0m\x1b[0m\n  \x1b[36m  * \x1b[32m[Continuous Integration](#continuous-integration)\x1b[0m\x1b[0m\n  \x1b[36m  * \x1b[32m[Dependencies Management](#dependencies-management)\x1b[0m\x1b[0m\n  \x1b[36m  * \x1b[32m[Unit Tests and Code Coverage](#unit-tests-and-code-coverage)\x1b[0m\x1b[0m\n  \x1b[36m  * \x1b[32m[Documentation](#documentation)\x1b[0m\x1b[0m\n\n\x1b[33m\x1b[32m[](#misc)\x1b[0mMisc\x1b[0m\n\n\x1b[36m  * \x1b[32m[Contributing](#contributing)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Credits](#credits)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Contact Info](#contact-info)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[License](#license)\x1b[0m\x1b[0m\n\n\x1b[33m\x1b[32m[](#syntax-and-output-highlighting)\x1b[0mSyntax and Output Highlighting\x1b[0m\n\n\x1b[32m[![](https://camo.githubusercontent.com/c527a4c00862bb1fe47c272a3c3563418f06866f/687474703a2f2f692e696d6775722e636f6d2f785144707737302e706e67)\x1b[0m](https://camo.githubusercontent.com/c527a4c00862bb1fe47c272a3c3563418f06866f/687474703a2f2f692e696d6775722e636f6d2f785144707737302e706e67)\n\nYou can control which theme to load for syntax highlighting by updating your \x1b[32m[~/.sawsrc](https://github.com/donnemartin/saws/blob/master/saws/sawsrc)\x1b[0m file:\n\n\x1b[33mVisual theme. Possible values: manni, igor, xcode, vim, autumn, vs, rrt,\x1b[0m\n    \x1b[33mnative, perldoc, borland, tango, emacs, friendly, monokai, paraiso-dark,\x1b[0m\n    \x1b[33mcolorful, murphy, bw, pastie, paraiso-light, trac, default, fruity\x1b[0m\n    theme = vim\n\n\x1b[33m\x1b[32m[](#auto-completion-of-commands-subcommands-and-options)\x1b[0mAuto-Completion of Commands, Subcommands, and Options\x1b[0m\n\n\x1b[36m`SAWS`\x1b[0m provides smart autocompletion as you type. Entering the following command will interactively list and auto-complete all subcommands \x1b[36mspecific only\x1b[0m to \x1b[36m`ec2`\x1b[0m:\n\naws ec2\n\n\x1b[32m[![](https://camo.githubusercontent.com/df93a08e1371694a8086f3b45ba6e5ec955212e2/687474703a2f2f692e696d6775722e636f6d2f5032744c3976572e706e67)\x1b[0m](https://camo.githubusercontent.com/df93a08e1371694a8086f3b45ba6e5ec955212e2/687474703a2f2f692e696d6775722e636f6d2f5032744c3976572e706e67)\n\n\x1b[33m\x1b[32m[](#auto-completion-of-aws-resources)\x1b[0mAuto-Completion of AWS Resources\x1b[0m\n\nIn addition to the default commands, subcommands, and options the AWS CLI provides, \x1b[36m`SAWS`\x1b[0m supports auto-completion of your AWS resources. Currently, bucket names, instance ids, and instance tags are included, with additional support for more resources \x1b[32m[under development](#todo-add-more-resources)\x1b[0m.\n\n\x1b[33m\x1b[32m[](#s3-buckets)\x1b[0mS3 Buckets\x1b[0m\n\nOption for \x1b[36m`s3api`\x1b[0m:\n\n--bucket\n\nSample Usage:\n\naws s3api get-bucket-acl --bucket\n\nSyntax for \x1b[36m`s3`\x1b[0m:\n\ns3://\n\nSample Usage:\n\naws s3 ls s3://\n\nNote: The example below demonstrates the use of \x1b[32m[fuzzy resource completion](/donnemartin/saws/blob/master/fuzzy-resource-and-shortcutcompletion)\x1b[0m:\n\n\x1b[32m[![](https://camo.githubusercontent.com/756f14d2ed77a7a9a3da9b0d9501cab9b7433e36/687474703a2f2f692e696d6775722e636f6d2f333943415335542e706e67)\x1b[0m](https://camo.githubusercontent.com/756f14d2ed77a7a9a3da9b0d9501cab9b7433e36/687474703a2f2f692e696d6775722e636f6d2f333943415335542e706e67)\n\n\x1b[33m\x1b[32m[](#ec2-instance-ids)\x1b[0mEC2 Instance Ids\x1b[0m\n\nOption for \x1b[36m`ec2`\x1b[0m:\n\n--instance-ids\n\nSample Usage:\n\naws ec2 describe-instances --instance-ids\n    aws ec2 ls --instance-ids\n\nNote: The \x1b[36m`ls`\x1b[0m command demonstrates the use of \x1b[32m[customizable shortcuts](#customizable-shortcuts)\x1b[0m:\n\n\x1b[32m[![](https://camo.githubusercontent.com/d4b0298e0ecd0afc1dac0d62617a4be53a44f598/687474703a2f2f692e696d6775722e636f6d2f6a46794353586c2e706e67)\x1b[0m](https://camo.githubusercontent.com/d4b0298e0ecd0afc1dac0d62617a4be53a44f598/687474703a2f2f692e696d6775722e636f6d2f6a46794353586c2e706e67)\n\n\x1b[33m\x1b[32m[](#ec2-instance-tags)\x1b[0mEC2 Instance Tags\x1b[0m\n\nOption for \x1b[36m`ec2`\x1b[0m:\n\n--ec2-tag-key\n    --ec2-tag-value\n\nSample Usage:\n\naws ec2 ls --ec2-tag-key\n    aws ec2 ls --ec2-tag-value\n\n\x1b[36mTags support wildcards\x1b[0m with the \x1b[36m`*`\x1b[0m character.\n\nNote: \x1b[36m`ls`\x1b[0m, \x1b[36m`--ec2-tag-value`\x1b[0m, and \x1b[36m`--ec2-tag-key`\x1b[0m demonstrate the use of \x1b[32m[customizable shortcuts](#customizable-shortcuts)\x1b[0m:\n\n\x1b[32m[![](https://camo.githubusercontent.com/593e9fc80cc6e1fb8e0fd7324cb4cb3a1b51bf2f/687474703a2f2f692e696d6775722e636f6d2f56494b7747335a2e706e67)\x1b[0m](https://camo.githubusercontent.com/593e9fc80cc6e1fb8e0fd7324cb4cb3a1b51bf2f/687474703a2f2f692e696d6775722e636f6d2f56494b7747335a2e706e67)\n\n\x1b[33m\x1b[32m[](#todo-add-more-resources)\x1b[0mTODO: Add More Resources\x1b[0m\n\nFeel free to \x1b[32m[submit an issue or a pull request](#contributions)\x1b[0m if you\'d like support for additional resources.\n\n\x1b[33m\x1b[32m[](#customizable-shortcuts)\x1b[0mCustomizable Shortcuts\x1b[0m\n\nThe \x1b[32m[~/.saws.shortcuts](https://github.com/donnemartin/saws/blob/master/saws/saws.shortcuts)\x1b[0m file contains shortcuts that you can modify. It comes pre-populated with several \x1b[32m[handy shortcuts](https://github.com/donnemartin/saws/blob/master/saws/saws.shortcuts)\x1b[0m out of the box. You can combine shortcuts with \x1b[32m[fuzzy completion](#fuzzy-resource-and-shortcut-completion)\x1b[0m for even less keystrokes. Below are a few examples.\n\nList all EC2 instances:\n\naws ec2 ls\n\nList all running EC2 instances:\n\naws ec2 ls --ec2-state running  \x1b[33mfuzzy shortcut: aws ecstate\x1b[0m\n\n\x1b[32m[![](https://camo.githubusercontent.com/7b56fd124f76cf2a9573de7b963bbb791f4cae16/687474703a2f2f692e696d6775722e636f6d2f6a594645736f4d2e706e67)\x1b[0m](https://camo.githubusercontent.com/7b56fd124f76cf2a9573de7b963bbb791f4cae16/687474703a2f2f692e696d6775722e636f6d2f6a594645736f4d2e706e67)\n\nList all EC2 instances with a matching tag (supports wildcards \x1b[36m`*`\x1b[0m):\n\naws ec2 ls --ec2-tag-key    \x1b[33mfuzzy shortcut: aws ectagk\x1b[0m\n    aws ec2 ls --ec2-tag-value  \x1b[33mfuzzy shortcut: aws ectagv\x1b[0m\n\n\x1b[32m[![](https://camo.githubusercontent.com/c45874a55d4ac6485ba78c6d4a91cc1d928703a4/687474703a2f2f692e696d6775722e636f6d2f505375775549772e706e67)\x1b[0m](https://camo.githubusercontent.com/c45874a55d4ac6485ba78c6d4a91cc1d928703a4/687474703a2f2f692e696d6775722e636f6d2f505375775549772e706e67)\n\nList EC2 instance with matching id:\n\naws ec2 ls --instance-ids  \x1b[33mfuzzy shortcut: aws eclsi\x1b[0m\n\n\x1b[32m[![](https://camo.githubusercontent.com/48136027017398a300b9fe968e50e2e7c2a8b18b/687474703a2f2f692e696d6775722e636f6d2f774763554373612e706e67)\x1b[0m](https://camo.githubusercontent.com/48136027017398a300b9fe968e50e2e7c2a8b18b/687474703a2f2f692e696d6775722e636f6d2f774763554373612e706e67)\n\nList all DynamoDB tables:\n\naws dynamodb ls  \x1b[33mfuzzy shortcut: aws dls\x1b[0m\n\nList all EMR clusters:\n\naws emr ls  \x1b[33mfuzzy shortcut: aws emls\x1b[0m\n\nAdd/remove/modify shortcuts in your \x1b[32m[~/.saws.shortcuts](https://github.com/donnemartin/saws/blob/master/saws/shortcuts)\x1b[0m file to suit your needs.\n\nFeel free to submit:\n\n\x1b[36m  * An issue to request additional shortcuts\x1b[0m\n\x1b[36m  * A pull request if you\'d like to share your shortcuts (see \x1b[32m[contributing guidelines](#contributions)\x1b[0m)\x1b[0m\n\n\x1b[33m\x1b[32m[](#fuzzy-resource-and-shortcut-completion)\x1b[0mFuzzy Resource and Shortcut Completion\x1b[0m\n\nTo toggle fuzzy completion of AWS resources and shortcuts, use \x1b[36m`F3`\x1b[0m key.\n\nSample fuzzy shortcuts to start and stop EC2 instances:\n\naws ecstop\n    aws ecstart\n\nNote: Fuzzy completion currently only works with AWS \x1b[32m[resources](#auto-completion-of-aws-resources)\x1b[0m and \x1b[32m[shortcuts](/donnemartin/saws/blob/master/customizable-shortcuts)\x1b[0m.\n\n\x1b[32m[![](https://camo.githubusercontent.com/a918a4d70ca61189149746e052f5bb2ffec9ae65/687474703a2f2f692e696d6775722e636f6d2f374f76464843772e706e67)\x1b[0m](https://camo.githubusercontent.com/a918a4d70ca61189149746e052f5bb2ffec9ae65/687474703a2f2f692e696d6775722e636f6d2f374f76464843772e706e67)\n\n\x1b[33m\x1b[32m[](#fish-style-auto-suggestions)\x1b[0mFish-Style Auto-Suggestions\x1b[0m\n\n\x1b[36m`SAWS`\x1b[0m supports Fish-style auto-suggestions. Use the \x1b[36m`right arrow`\x1b[0m key to complete a suggestion.\n\n\x1b[32m[![](https://camo.githubusercontent.com/6671d93da542b2f2cdec589fcb2c174e3bbc25f6/687474703a2f2f692e696d6775722e636f6d2f743532303071312e706e67)\x1b[0m](https://camo.githubusercontent.com/6671d93da542b2f2cdec589fcb2c174e3bbc25f6/687474703a2f2f692e696d6775722e636f6d2f743532303071312e706e67)\n\n\x1b[33m\x1b[32m[](#executing-shell-commands)\x1b[0mExecuting Shell Commands\x1b[0m\n\n\x1b[36m`SAWS`\x1b[0m allows you to execute shell commands from the \x1b[36m`saws>`\x1b[0m prompt.\n\n\x1b[32m[![](https://camo.githubusercontent.com/4d26d484e5b94b7ca62607ec1557d847f5db96f3/687474703a2f2f692e696d6775722e636f6d2f4669536e3662322e706e67)\x1b[0m](https://camo.githubusercontent.com/4d26d484e5b94b7ca62607ec1557d847f5db96f3/687474703a2f2f692e696d6775722e636f6d2f4669536e3662322e706e67)\n\n\x1b[33m\x1b[32m[](#command-history)\x1b[0mCommand History\x1b[0m\n\n\x1b[36m`SAWS`\x1b[0m keeps track of commands you enter and stores them in \x1b[36m`~/.saws-history`\x1b[0m. Use the up and down arrow keys to cycle through the command history.\n\n\x1b[32m[![](https://camo.githubusercontent.com/a5ded83f813be928236c804a90d85fc0fd5e517d/687474703a2f2f692e696d6775722e636f6d2f7a3852724451422e706e67)\x1b[0m](https://camo.githubusercontent.com/a5ded83f813be928236c804a90d85fc0fd5e517d/687474703a2f2f692e696d6775722e636f6d2f7a3852724451422e706e67)\n\n\x1b[33m\x1b[32m[](#contextual-help)\x1b[0mContextual Help\x1b[0m\n\n\x1b[36m`SAWS`\x1b[0m supports contextual command line \x1b[36m`help`\x1b[0m and contextual web \x1b[36m`docs`\x1b[0m.\n\n\x1b[33m\x1b[32m[](#contextual-command-line-help)\x1b[0mContextual Command Line Help\x1b[0m\n\nThe \x1b[36m`help`\x1b[0m command is powered by the AWS CLI and outputs help within the command line.\n\nUsage:\n\naws <command> <subcommand> help\n\n\x1b[32m[![](https://camo.githubusercontent.com/e10dae70d7f9303bc5fae0e3f5dba453fa905df7/687474703a2f2f692e696d6775722e636f6d2f7a536b7a7436792e706e67)\x1b[0m](https://camo.githubusercontent.com/e10dae70d7f9303bc5fae0e3f5dba453fa905df7/687474703a2f2f692e696d6775722e636f6d2f7a536b7a7436792e706e67)\n\n\x1b[33m\x1b[32m[](#contextual-web-docs)\x1b[0mContextual Web Docs\x1b[0m\n\nSometimes you\'re not quite sure what specific command/subcommand/option combination you need to use. In such cases, browsing through several combinations with the \x1b[36m`help`\x1b[0m command line is cumbersome versus browsing the online AWS CLI docs through a web browser.\n\n\x1b[36m`SAWS`\x1b[0m supports contextual web docs with the \x1b[36m`docs`\x1b[0m command or the \x1b[36m`F9`\x1b[0m key. \x1b[36m`SAWS`\x1b[0m will display the web docs specific to the currently entered command and subcommand.\n\nUsage:\n\naws <command> <subcommand> docs\n\n\x1b[32m[![](https://camo.githubusercontent.com/e0a9e9bd21f2ff174f2e257f0c9966c6620d97d7/687474703a2f2f692e696d6775722e636f6d2f7a4b34494a59702e706e67)\x1b[0m](https://camo.githubusercontent.com/e0a9e9bd21f2ff174f2e257f0c9966c6620d97d7/687474703a2f2f692e696d6775722e636f6d2f7a4b34494a59702e706e67)\n\n\x1b[33m\x1b[32m[](#toolbar-options)\x1b[0mToolbar Options\x1b[0m\n\n\x1b[36m`SAWS`\x1b[0m supports a number of toolbar options:\n\n\x1b[36m  * \x1b[36m`F2`\x1b[0m toggles \x1b[32m[output syntax highlighting](#syntax-and-output-highlighting)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[36m`F3`\x1b[0m toggles \x1b[32m[fuzzy completion of AWS resources and shortcuts](#fuzzy-resource-and-shortcut-completion)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[36m`F4`\x1b[0m toggles \x1b[32m[completion of shortcuts](#customizable-shortcuts)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[36m`F5`\x1b[0m refreshes \x1b[32m[resources for auto-completion](#auto-completion-of-aws-resources)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[36m`F9`\x1b[0m displays the \x1b[32m[contextual web docs](#contextual-web-docs)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[36m`F10`\x1b[0m or \x1b[36m`control d`\x1b[0m exits \x1b[36m`SAWS`\x1b[0m\x1b[0m\n\n\x1b[32m[![](https://camo.githubusercontent.com/f1bb53eda629178af0d849a112193a91daca5628/687474703a2f2f692e696d6775722e636f6d2f37767a384f53632e706e67)\x1b[0m](https://camo.githubusercontent.com/f1bb53eda629178af0d849a112193a91daca5628/687474703a2f2f692e696d6775722e636f6d2f37767a384f53632e706e67)\n\n\x1b[33m\x1b[32m[](#windows-support)\x1b[0mWindows Support\x1b[0m\n\n\x1b[36m`SAWS`\x1b[0m has been tested on Windows 7 and Windows 10.\n\nOn Windows, the \x1b[32m[.sawsrc](https://github.com/donnemartin/saws/blob/master/saws/sawsrc)\x1b[0m file can be found in \x1b[36m`%userprofile%`\x1b[0m. For example:\n\nC:\\Users\\dmartin\\.sawsrc\n\nAlthough you can use the standard Windows command prompt, you\'ll probably have a better experience with either \x1b[32m[cmder](https://github.com/cmderdev/cmder)\x1b[0m or \x1b[32m[conemu](https://github.com/Maximus5/ConEmu)\x1b[0m.\n\n\x1b[32m[![](https://camo.githubusercontent.com/cfd9f911b9960308e0346d90ba4cf2338145fb52/687474703a2f2f692e696d6775722e636f6d2f7055774a57636b2e706e67)\x1b[0m](https://camo.githubusercontent.com/cfd9f911b9960308e0346d90ba4cf2338145fb52/687474703a2f2f692e696d6775722e636f6d2f7055774a57636b2e706e67)\n\n\x1b[33m\x1b[32m[](#installation)\x1b[0mInstallation\x1b[0m\n\n\x1b[33m\x1b[32m[](#pip-installation)\x1b[0mPip Installation\x1b[0m\n\n\x1b[32m[![PyPI version](https://camo.githubusercontent.com/818edda38216a62a4bb36557372877febec35086/68747470733a2f2f62616467652e667572792e696f2f70792f736177732e737667)\x1b[0m](http://badge.fury.io/py/saws) \x1b[32m[![PyPI](https://camo.githubusercontent.com/04574f61c5dff98734bd6a013cc9217b9a428e47/68747470733a2f2f696d672e736869656c64732e696f2f707970692f707976657273696f6e732f736177732e737667)\x1b[0m](https://pypi.python.org/pypi/saws/)\n\n\x1b[36m`SAWS`\x1b[0m is hosted on \x1b[32m[PyPI](https://pypi.python.org/pypi/saws)\x1b[0m. The following command will install \x1b[36m`SAWS`\x1b[0m along with dependencies such as the \x1b[32m[AWS CLI](https://github.com/aws/aws-cli)\x1b[0m:\n\n$ pip install saws\n\nYou can also install the latest \x1b[36m`SAWS`\x1b[0m from GitHub source which can contain changes not yet pushed to PyPI:\n\n$ pip install git+https://github.com/donnemartin/saws.git\n\nIf you are not installing in a \x1b[32m[virtualenv](#virtual-environment-and-docker-installation)\x1b[0m, run with \x1b[36m`sudo`\x1b[0m:\n\n$ sudo pip install saws\n\nOnce installed, start \x1b[36m`SAWS`\x1b[0m:\n\n$ saws\n\n\x1b[33m\x1b[32m[](#virtual-environment-and-docker-installation)\x1b[0mVirtual Environment and Docker Installation\x1b[0m\n\nIt is recommended that you install Python packages in a \x1b[32m[virtualenv](http://docs.python-guide.org/en/latest/dev/virtualenvs/)\x1b[0m to avoid potential \x1b[32m[issues with dependencies or permissions](https://github.com/donnemartin/saws/issues/15)\x1b[0m.\n\nTo view \x1b[36m`SAWS`\x1b[0m \x1b[36m`virtualenv`\x1b[0m and \x1b[32m[Docker](https://www.docker.com/)\x1b[0m installation instructions, click \x1b[32m[here](https://github.com/donnemartin/saws/blob/master/INSTALLATION.md)\x1b[0m.\n\n\x1b[33m\x1b[32m[](#aws-credentials-and-named-profiles)\x1b[0mAWS Credentials and Named Profiles\x1b[0m\n\n\x1b[32m[Configure your credentials](https://github.com/aws/aws-cli#getting-started)\x1b[0m with the AWS CLI:\n\n$ aws configure\n\nIf you\'d like to use a specific named profile with \x1b[36m`SAWS`\x1b[0m, run the following commands on OS X, Linux, or Unix:\n\n$ export AWS_DEFAULT_PROFILE=user1\n    $ saws\n\nOr as a one-liner:\n\n$ AWS_DEFAULT_PROFILE=user1 saws\n\nWindows users can run the following commands:\n\n> set AWS_DEFAULT_PROFILE=user1\n    > saws\n\nCommand line options for starting \x1b[36m`SAWS`\x1b[0m with a specific profile are \x1b[32m[under development](https://github.com/donnemartin/saws/issues/16)\x1b[0m. For more details on how to install and configure the AWS CLI, refer to the following \x1b[32m[documentation](http://docs.aws.amazon.com/cli/latest/userguide/installing.html)\x1b[0m.\n\n\x1b[33m\x1b[32m[](#supported-python-versions)\x1b[0mSupported Python Versions\x1b[0m\n\n\x1b[36m  * Python 2.6\x1b[0m\n\x1b[36m  * Python 2.7\x1b[0m\n\x1b[36m  * Python 3.3\x1b[0m\n\x1b[36m  * Python 3.4\x1b[0m\n\x1b[36m  * Pypy\x1b[0m\n\nLight testing indicates that \x1b[36m`SAWS`\x1b[0m also seems to be compatible with Python 3.5.\n\nPypy3 is not supported due to \x1b[32m[lack of support](https://github.com/boto/botocore/issues/622)\x1b[0m from \x1b[32m[boto](https://github.com/boto/boto)\x1b[0m.\n\n\x1b[33m\x1b[32m[](#supported-platforms)\x1b[0mSupported Platforms\x1b[0m\n\n\x1b[36m  * Mac OS X \x1b[0m\n  \x1b[36m  * Tested on OS X 10.10\x1b[0m\n\x1b[36m  * Linux, Unix \x1b[0m\n  \x1b[36m  * Tested on Ubuntu 14.04 LTS\x1b[0m\n\x1b[36m  * Windows \x1b[0m\n  \x1b[36m  * Tested on Windows 7 and 10\x1b[0m\n\n\x1b[33m\x1b[32m[](#developer-installation)\x1b[0mDeveloper Installation\x1b[0m\n\nIf you\'re interested in contributing to \x1b[36m`SAWS`\x1b[0m, run the following commands:\n\n$ git clone https://github.com/donnemartin/saws.git\n    $ pip install -e .\n    $ pip install -r requirements-dev.txt\n    $ saws\n\n\x1b[33m\x1b[32m[](#continuous-integration)\x1b[0mContinuous Integration\x1b[0m\n\n\x1b[32m[![Build Status](https://camo.githubusercontent.com/c1d6d1e8f7cdac1e6a82bf900832bbbe52d61e95/68747470733a2f2f7472617669732d63692e6f72672f646f6e6e656d617274696e2f736177732e7376673f6272616e63683d6d6173746572)\x1b[0m](https://travis-ci.org/donnemartin/saws)\n\nContinuous integration details are available on \x1b[32m[Travis CI](https://travis-ci.org/donnemartin/saws)\x1b[0m.\n\n\x1b[33m\x1b[32m[](#dependencies-management)\x1b[0mDependencies Management\x1b[0m\n\n\x1b[32m[![Dependency Status](https://camo.githubusercontent.com/11e16ba1560f0232928945436bf86340615d85ae/68747470733a2f2f67656d6e617369756d2e636f6d2f646f6e6e656d617274696e2f736177732e737667)\x1b[0m](https://gemnasium.com/donnemartin/saws)\n\nDependencies management details are available on \x1b[32m[Gemnasium](https://gemnasium.com/donnemartin/saws)\x1b[0m.\n\n\x1b[33m\x1b[32m[](#unit-tests-and-code-coverage)\x1b[0mUnit Tests and Code Coverage\x1b[0m\n\n\x1b[32m[![Codecov](https://camo.githubusercontent.com/e24a50e9dd63768d90d26a9f6be1cf3d0c3b0230/68747470733a2f2f696d672e736869656c64732e696f2f636f6465636f762f632f6769746875622f646f6e6e656d617274696e2f736177732e737667)\x1b[0m](https://codecov.io/github/donnemartin/saws/saws)\n\n\x1b[32m[![](https://camo.githubusercontent.com/a3588f226c5b2c9007fd9e49212ae8294c5bc023/687474703a2f2f636f6465636f762e696f2f6769746875622f646f6e6e656d617274696e2f736177732f6272616e63682e7376673f6272616e63683d6d6173746572)\x1b[0m](https://camo.githubusercontent.com/a3588f226c5b2c9007fd9e49212ae8294c5bc023/687474703a2f2f636f6465636f762e696f2f6769746875622f646f6e6e656d617274696e2f736177732f6272616e63682e7376673f6272616e63683d6d6173746572)\n\nCode coverage details are available on \x1b[32m[Codecov](https://codecov.io/github/donnemartin/saws/saws)\x1b[0m.\n\nRun unit tests in your active Python environment:\n\n$ python tests/run_tests.py\n\nRun unit tests with \x1b[32m[tox](https://pypi.python.org/pypi/tox)\x1b[0m on multiple Python environments:\n\n$ tox\n\n\x1b[33m\x1b[32m[](#documentation)\x1b[0mDocumentation\x1b[0m\n\n\x1b[32m[![Documentation Status](https://camo.githubusercontent.com/41afe5f96e9f915ecd9706bdc7dfd19518eaf05a/68747470733a2f2f72656164746865646f63732e6f72672f70726f6a656374732f736177732f62616467652f3f76657273696f6e3d6c6174657374)\x1b[0m](http://saws.readthedocs.org/en/latest/?badge=latest)\n\nSource code documentation is available on \x1b[32m[Readthedocs.org](http://saws.readthedocs.org/en/latest/?badge=latest)\x1b[0m.\n\nRun the following to build the docs:\n\n$ scripts/update_docs.sh\n\n\x1b[33m\x1b[32m[](#contributing)\x1b[0mContributing\x1b[0m\n\nContributions are welcome!\n\nReview the \x1b[32m[Contributing Guidelines](https://github.com/donnemartin/saws/blob/master/CONTRIBUTING.md)\x1b[0m for details on how to:\n\n\x1b[36m  * Submit issues\x1b[0m\n\x1b[36m  * Submit pull requests\x1b[0m\n\n\x1b[33m\x1b[32m[](#credits)\x1b[0mCredits\x1b[0m\n\n\x1b[36m  * \x1b[32m[AWS CLI](https://github.com/aws/aws-cli)\x1b[0m by \x1b[32m[AWS](https://github.com/aws)\x1b[0m for powering \x1b[36m`SAWS`\x1b[0m under the hood\x1b[0m\n\x1b[36m  * \x1b[32m[Python Prompt Toolkit](https://github.com/jonathanslenders/python-prompt-toolkit)\x1b[0m by \x1b[32m[jonathanslenders](https://github.com/jonathanslenders)\x1b[0m for simplifying the creation of \x1b[36m`SAWS`\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Wharfee](https://github.com/j-bennet/wharfee)\x1b[0m by \x1b[32m[j-bennet](https://github.com/j-bennet)\x1b[0m for inspiring the creation of \x1b[36m`SAWS`\x1b[0m and for some handy utility functions\x1b[0m\n\n\x1b[33m\x1b[32m[](#contact-info)\x1b[0mContact Info\x1b[0m\n\nFeel free to contact me to discuss any issues, questions, or comments.\n\n\x1b[36m  * Email: \x1b[32m[donne.martin@gmail.com](mailto:donne.martin@gmail.com)\x1b[0m\x1b[0m\n\x1b[36m  * Twitter: \x1b[32m[donne_martin](https://twitter.com/donne_martin)\x1b[0m\x1b[0m\n\x1b[36m  * GitHub: \x1b[32m[donnemartin](https://github.com/donnemartin)\x1b[0m\x1b[0m\n\x1b[36m  * LinkedIn: \x1b[32m[donnemartin](https://www.linkedin.com/in/donnemartin)\x1b[0m\x1b[0m\n\x1b[36m  * Website: \x1b[32m[donnemartin.com](http://donnemartin.com)\x1b[0m\x1b[0m\n\n\x1b[33m\x1b[32m[](#license)\x1b[0mLicense\x1b[0m\n\nCopyright 2015 Donne Martin\n\nLicensed under the Apache License, Version 2.0 (the "License");\n    you may not use this file except in compliance with the License.\n    You may obtain a copy of the License at\n\nhttp://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\n    distributed under the License is distributed on an "AS IS" BASIS,\n    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n    See the License for the specific language governing permissions and\n    limitations under the License.\n\n\x1b[36m  * \x1b[32m[Status](https://status.github.com/)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[API](https://developer.github.com)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Training](https://training.github.com)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Shop](https://shop.github.com)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Blog](https://github.com/blog)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[About](https://github.com/about)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Pricing](https://github.com/pricing)\x1b[0m\x1b[0m\n\x1b[32m[ ](https://github.com)\x1b[0m\n\n\x1b[36m  * (C) 2015 GitHub, Inc.\x1b[0m\n\x1b[36m  * \x1b[32m[Terms](https://github.com/site/terms)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Privacy](https://github.com/site/privacy)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Security](https://github.com/security)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Contact](https://github.com/contact)\x1b[0m\x1b[0m\n\x1b[36m  * \x1b[32m[Help](https://help.github.com)\x1b[0m\x1b[0m\n\nSomething went wrong with that request. Please try again.\n\nYou signed in with another tab or window. [Reload]() to refresh your session. You signed out in another tab or window. [Reload]() to refresh your session.\n
"""  # NOQA
ssl_error = u"Viewing https://requestb.in\n\n\x1b[0mError: hostname 'requestb.in' doesn't match either of '*.herokuapp.com', 'herokuapp.com'\nTry running gh view # with the --browser/-b flag\n\nView this article in a browser with the -b/--browser flag.\n\x1b[0m\nPress q to quit viewing this article.\n\x1b[0m"  # NOQA
