require 'spec_helper'

describe NamespaceUrlConstrainer, lib: true do
  let!(:group) { create(:group, path: 'gitlab') }

  describe '#matches?' do
    context 'existing namespace' do
      it { expect(subject.matches?(request '/gitlab')).to be_truthy }
      it { expect(subject.matches?(request '/gitlab.atom')).to be_truthy }
      it { expect(subject.matches?(request '/gitlab/')).to be_truthy }
      it { expect(subject.matches?(request '//gitlab/')).to be_truthy }
    end

    context 'non-existing namespace' do
      it { expect(subject.matches?(request '/gitlab-ce')).to be_falsey }
      it { expect(subject.matches?(request '/gitlab.ce')).to be_falsey }
      it { expect(subject.matches?(request '/g/gitlab')).to be_falsey }
      it { expect(subject.matches?(request '/.gitlab')).to be_falsey }
    end

    context 'relative url' do
      before do
        allow(Gitlab::Application.config).to receive(:relative_url_root) { '/gitlab' }
      end

      it { expect(subject.matches?(request '/gitlab/gitlab')).to be_truthy }
      it { expect(subject.matches?(request '/gitlab/gitlab-ce')).to be_falsey }
      it { expect(subject.matches?(request '/gitlab/')).to be_falsey }
    end
  end

  def request(path)
    OpenStruct.new(path: path)
  end
end
