/*
 *  
 *  $Id$
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "aprimresourcemanager.h"

#include "iconosherramientas/iconos.h"
#include "barracine/iconos.h"
#include "barrasincronizar/iconos.h"
#include "3dbar/icons.h"

#include <api/globals.h>

#include <wx/mstream.h>
#include <wx/image.h>

#define wxMEMORY_IMAGE( name ) _wxConvertMemoryToImage( name, sizeof( name ) )
#define wxMEMORY_IMAGEEX( name, type ) _wxConvertMemoryToImage( name, sizeof( name ), type )
#define wxMEMORY_BITMAP( name ) _wxConvertMemoryToBitmap( name, sizeof( name ) )
#define wxMEMORY_BITMAPEX( name, type ) _wxConvertMemoryToBitmap( name, sizeof( name ), type )

inline wxImage _wxConvertMemoryToImage(const unsigned char* data, int length, long type = wxBITMAP_TYPE_ANY )
{
	wxMemoryInputStream stream( data, length );
	return wxImage( stream, type, -1 );
}

inline wxBitmap _wxConvertMemoryToBitmap(const unsigned char* data, int length, long type = wxBITMAP_TYPE_ANY )
{
	wxMemoryInputStream stream( data, length );
	return wxBitmap( wxImage( stream, type, -1 ), -1 );
}

// Herramientas
wxBitmap APrimResourcesManager::Herramientas::GetIcoCapas(){return wxMEMORY_BITMAP(ico_capas); }
wxBitmap APrimResourcesManager::Herramientas::GetIcoReset(){return wxMEMORY_BITMAP(ico_reset); }
wxBitmap APrimResourcesManager::Herramientas::GetIcoMenuImagen(){return wxMEMORY_BITMAP(ico_menu_imagen); }
wxBitmap APrimResourcesManager::Herramientas::GetIcoLayout(){return wxMEMORY_BITMAP(ico_layout); }
wxBitmap APrimResourcesManager::Herramientas::GetIcoFlipVertical(){return wxMEMORY_BITMAP(ico_flip_vertical); }
wxBitmap APrimResourcesManager::Herramientas::GetIcoFlipHorizontal(){return wxMEMORY_BITMAP(ico_flip_horizontal); }
wxBitmap APrimResourcesManager::Herramientas::GetIcoRotateLeft(){return wxMEMORY_BITMAP(ico_rotate_left); }
wxBitmap APrimResourcesManager::Herramientas::GetIcoRotateRight(){return wxMEMORY_BITMAP(ico_rotate_right); }
wxBitmap APrimResourcesManager::Herramientas::GetIcoInvert(){return wxMEMORY_BITMAP(ico_invert); }
wxBitmap APrimResourcesManager::Herramientas::GetIcoECGMetadata(){return wxMEMORY_BITMAP(ico_ecg_metadata); }

// Barra Cine
wxBitmap APrimResourcesManager::BarraCine::GetIcoPlay(){return wxMEMORY_BITMAP(ico_play); }
wxBitmap APrimResourcesManager::BarraCine::GetIcoBucle(){return wxMEMORY_BITMAP(ico_bucle); }
wxBitmap APrimResourcesManager::BarraCine::GetIcoNoBucle(){return wxMEMORY_BITMAP(ico_no_bucle); }
wxBitmap APrimResourcesManager::BarraCine::GetIcoStop(){return wxMEMORY_BITMAP(ico_stop); }
wxBitmap APrimResourcesManager::BarraCine::GetIcoPause(){return wxMEMORY_BITMAP(ico_pause); }
wxBitmap APrimResourcesManager::BarraCine::GetIcoCine(){return wxMEMORY_BITMAP(ico_cine); }


wxBitmap APrimResourcesManager::Bar3D::GetIco3DArrow() {return wxMEMORY_BITMAP(ico_cursor3d);  }
wxBitmap APrimResourcesManager::Bar3D::GetIcoStereo(){return wxMEMORY_BITMAP(ico_stereo);  }
wxBitmap APrimResourcesManager::Bar3D::GetIcoPin(){return wxMEMORY_BITMAP(ico_plegar);  }
wxBitmap APrimResourcesManager::Bar3D::GetIcoDemo(){return wxMEMORY_BITMAP(ico_demo);  }


wxBitmap APrimResourcesManager::BarraSincronizar::GetIcoDessincronizar(){return wxMEMORY_BITMAP(ico_dessincronizar); }

