/*
*  $Id: gvistaoftal.cpp 3681 2011-04-12 10:53:31Z tovar $
*  Proyecto Ginkgo
*
*  Copyright 2008 MetaEmotion S.L. All rights reserved.
*
*/

#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <wx/wx.h>
#include <wx/config.h>
#include <wx/msgdlg.h>
#include <wx/menu.h>
#include <wx/image.h>
#include <wx/event.h>
#include <wx/aui/auibar.h>
#include <api/globals.h>
#include <api/iwidgetsmanager.h>
#include <api/iwidgetsrenderer.h>
#include <api/icontexto.h>
#include <api/icontroladorvistas.h>
#include <api/icontroladorcomandos.h>
#include <api/icontroladorherramientas.h>
#include <api/icontroladoreventos.h>
#include <export/iherramientarejillametrica.h>
#include <eventos/eventosginkgo.h>
#include <export/iherramientaanotacionesesquina.h>
#include <api/icontroladorlog.h>
#include "gfooextensionview.h"
#include <fooextension/views/fooextensionview.h>

#include <ios>
#include <vector>
#include <sstream>


#include <vtkSmartPointer.h>
#include <vtkObject.h>
#include <vtkRenderer.h>
#include <vtkPointData.h>
#include <vtkImageData.h>
#include <vtkLookupTable.h>
#include <vtkProperty.h>

#include <vtkImageActor.h>
#include <vtkGlyphSource2D.h>
#include <vtkImageTracerWidget.h>
#include <vtkRenderWindow.h>
#include <vtkRenderer.h>
#include <vtkMapper.h>
#include <vtkWorldPointPicker.h>
#include <vtkImageReslice.h>
#include <vtkAlgorithmOutput.h>

#include <vtk/widgets/widgetsactor.h>

#include <commands/comandodestruirvista.h>

#include <vtkgl.h>
#include <widgets/wprogreso.h>


namespace FooExtension {
	namespace GUI {

		GFooExtensionView::GFooExtensionView(FooExtensionView* pView) : GFooExtensionViewBase(pView->GetEstudio()->VentanaPadre)
		{
			IView = pView;

			// Setup widgets handler
			GNC::GCS::IContratoWidgets::m_pManager = pView->GetFooStudy()->Entorno->NewWidgetsManager(IView);
				//setup interactor
			GNC::GCS::IWidgetsRenderer* pR = ViewInteractor2D;
				//connect manager
			pR->SetManager(GNC::GCS::IContratoWidgets::m_pManager);
			pR->SetVID(0,false);
			GNC::GCS::IContratoWidgets::m_pManager->SetRendererActivo(pR);
				//create corner annotations
			GNC::GCS::IContratoWidgets::m_pManager->CrearWidgetAnotador(this);
				//this is important to paint widgets
			WidgetRepresentation* pWidgetsRepresentation = WidgetRepresentation::New();
			pWidgetsRepresentation->SetRenderer(ViewInteractor2D->FindPokedRenderer(0,0));
			ViewInteractor2D->FindPokedRenderer(0,0)->AddViewProp(pWidgetsRepresentation);
			pR->SetRepresentation(pWidgetsRepresentation);
			pWidgetsRepresentation->SetWidgetsManager(GNC::GCS::IContratoWidgets::m_pManager);
			pWidgetsRepresentation->SetWidgetsRenderer(pR);
			pWidgetsRepresentation->Delete();
			pWidgetsRepresentation = NULL;

				//setup widgets contract
			GNC::GCS::IContratoWidgets::Setup(GNC::GCS::IContratoWidgets::m_pManager);

			//setup visualization like background color or interpolation mode
			ViewImage2D->SetBackgroundColor(0.0f, 0.0f, 0.0f);
			ViewImage2D->SetInterpolationMode(VTK_NEAREST_INTERPOLATION);
			pView->GetFooStudy()->SetViewer(ViewImage2D);

			
			ViewInteractor2D->m_pImageViewer = ViewImage2D;

			//register events...			
				//image modification
			GNC::GCS::Eventos::EventoModificacionImagen ev2(IView);
				//render
			GNC::GCS::Eventos::EventoRender ev4(IView);
			IView->GetEstudio()->Entorno->GetControladorEventos()->Registrar(this, ev2);
			IView->GetEstudio()->Entorno->GetControladorEventos()->Registrar(this, ev4);

			//connect wxWidgets events
			ViewInteractor2D->Connect(wxEVT_KEY_DOWN,wxKeyEventHandler(GFooExtensionView::OnKeyDown),NULL,this);
			Connect(wxEVT_CHILD_FOCUS, wxChildFocusEventHandler(GFooExtensionView::OnFocus));
			Connect(wxEVT_MOUSEWHEEL,wxMouseEventHandler(GFooExtensionView::OnMouseWheel),NULL,this);
			Connect(wxEVT_CHAR, wxCharEventHandler(GFooExtensionView::OnKeyDown));
		}

		GFooExtensionView::~GFooExtensionView()
		{
			//ignore modifications
			IView->GetEstudio()->SetIgnorarModificaciones(true);

			//disconnect wxWidgets Events
			Disconnect(wxEVT_CHAR, wxCharEventHandler(GFooExtensionView::OnKeyDown));
			ViewInteractor2D->Disconnect(wxEVT_KEY_DOWN,wxKeyEventHandler(GFooExtensionView::OnKeyDown),NULL,this);
			Disconnect(wxEVT_CHILD_FOCUS, wxChildFocusEventHandler(GFooExtensionView::OnFocus));
			Disconnect(wxEVT_MOUSEWHEEL,wxMouseEventHandler(GFooExtensionView::OnMouseWheel),NULL,this);

			//remove all widgets
			m_pManager->EliminarTodosLosWidgets(false);

			//unset widgets representation
			ViewInteractor2D->SetRepresentation(NULL);

			//free widgets manager
			IView->GetEstudio()->Entorno->FreeWidgetsManager(GNC::GCS::IContratoWidgets::m_pManager);

			//detach viewer
			ViewImage2D->Detach();
			ViewImage2D->Delete();
			ViewImage2D = NULL;

			//delete interactor
			ViewInteractor2D->Delete();
			ViewInteractor2D = NULL;

			//this is the common way to destroy view without leaks
			IView->Lock(GLOC());
			delete IView;
		}

		//init pipeline
		void GFooExtensionView::InitPipeline()
		{
			ViewImage2D->SetInterpolationMode(VTK_NEAREST_INTERPOLATION);

			ViewImage2D->SetInputConnection(IView->GetEstudio()->renderConnection);

			ViewImage2D->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);

			if (IView->GetEstudio()->GetNumeroCortes()>1) {
				m_pPanelSlider->Show(true);
				m_pSliderSerie->SetMin(0);
				m_pSliderSerie->SetValue(0);
				m_pSliderSerie->SetMax(IView->GetEstudio()->GetNumeroCortes()-1);
			} else {
				m_pPanelSlider->Show(false);
			}
			SetSlice(0, true);
		}

		//on paint wx
		void GFooExtensionView::OnPaint(wxPaintEvent &event)
		{
			//draws a yellow line
			GFooExtensionViewBase::OnPaint(event);
			if(IView->GetEstudio()->Entorno->GetControladorVistas()->GetVistaActiva() == IView)
			{
				wxPaintDC dc(this);
				wxColour colorLineaSeleccion(219, 219, 0, 255);
				dc.SetBrush(wxBrush(colorLineaSeleccion,wxTRANSPARENT));
				dc.SetPen(wxPen(colorLineaSeleccion, 3, wxSOLID));
				dc.DrawRectangle(wxRect(wxPoint(1, 1), wxPoint(dc.GetSize().x-1, dc.GetSize().y-1)));
			}
		}

		//avoid flickering
		void GFooExtensionView::OnEraseBackground( wxEraseEvent& event )
		{
			event.Skip(true);
		}

		//set focus to view
		void GFooExtensionView::OnFocus(wxChildFocusEvent& WXUNUSED(event))
		{
			IView->OnFocus();
		}

		//layout commponents
		void GFooExtensionView::OnSize(wxSizeEvent& WXUNUSED(event))
		{
			Layout();
		}

		//slice changing
		void GFooExtensionView::OnMouseWheel(wxMouseEvent& event)
		{
			if (event.ControlDown())
			{
				if(event.GetWheelRotation() > 0)
				{
					GoToSlice(m_pSliderSerie->GetValue()+1);
				}
				else
				{
					GoToSlice(m_pSliderSerie->GetValue()-1);
				}
			}
		}

		//slice changing
		void GFooExtensionView::OnKeyDown( wxKeyEvent& event )
		{
			switch(event.GetKeyCode()){
		case WXK_RIGHT:
			{
				GoToSlice(m_pSliderSerie->GetValue()+1);
			}
			break;
		case WXK_LEFT:
			{
				GoToSlice(m_pSliderSerie->GetValue()-1);
			}
			break;
		case WXK_ESCAPE:
			{
				GNC::GCS::ISolicitadorCambioHerramienta* solicitador = dynamic_cast<GNC::GCS::ISolicitadorCambioHerramienta*>(IView->GetEstudio()->Entorno->GetControladorHerramientas());
				if(solicitador!=NULL){
					solicitador->SolicitarActivacion(IView->GetEstudio()->Entorno->GetControladorHerramientas()->ObtenerHerramienta(GNC::GCS::IHerramientaPuntero::ID));
				}
			}
			break;
		default:
			event.Skip(true);
			}
		}

		//slice changing
		void GFooExtensionView::GoToSlice(int i)
		{
			if(i>=m_pSliderSerie->GetMin() && i<=m_pSliderSerie->GetMax()){
				m_pSliderSerie->SetValue(i);
				wxScrollEvent evt;
				evt.SetPosition(i);
				OnScrollSliderSerie(evt);
			}
		}

		//slice changing
		void GFooExtensionView::OnScrollSliderSerie(wxScrollEvent& event)
		{
			unsigned int vid = (unsigned int)event.GetPosition();
			if ((int)vid < 0 ) {
				vid = 0;
			}
			if( (int) vid >= IView->GetEstudio()->GetNumeroCortes()) {
				return;
			}
			SetSlice(vid);
		}

		//slice changing
		void GFooExtensionView::SetSlice(unsigned int vid, bool force)
		{
			IView->GetEstudio()->SetIgnorarModificaciones(true);
			ViewInteractor2D->SetVID(vid, false); // Cambia el id de vista del Widgets Renderer
			if (vid != (unsigned int)IView->GetEstudio()->IndiceFicheroActivo || force) {
				IView->GetEstudio()->SetIndiceActivo(vid);

				GNC::GCS::IEntorno* pEntorno = IView->GetEstudio()->Entorno;

				IView->GetEstudio()->CargarWidgetsActivo();

				pEntorno->GetControladorEventos()->ProcesarEvento(new GNC::GCS::Eventos::EventoModificacionImagen(IView,GNC::GCS::Eventos::EventoModificacionImagen::ImagenCargada));
			}
			IView->GetEstudio()->SetIgnorarModificaciones(false);
		}

		//Widgets contract
		vtkGinkgoImageViewer* GFooExtensionView::GetViewer()
		{
			return ViewImage2D;
		}

		//Ginkgo CADx events
		void GFooExtensionView::PreProcesarEvento(GNC::GCS::Eventos::IEvento* evt, GNC::GCS::IControladorEventos::TipoListaPunterosEventos& lista)
		{
			if (evt == NULL) {
				std::cerr << "Error: null event" << std::endl;
				return;
			}
			switch (evt->GetCodigoEvento()) {
				//image modification generates render
				case ginkgoEVT_Core_ModificacionImagen:
					{
						//image has been modified
						GNC::GCS::Eventos::EventoModificacionImagen* pEvt = dynamic_cast<GNC::GCS::Eventos::EventoModificacionImagen*>(evt);
						if (pEvt == NULL) {
							std::cerr << "Error al interpretar evento como evento de modificacion de imagen: Evento = " << evt << std::endl;
							return;
						}
						switch (pEvt->GetTipo()) {
							case GNC::GCS::Eventos::EventoModificacionImagen::ImagenRecalibrada:
								{
									//recalibration event pushes one image load event (image has changed)
									lista.push_back(new GNC::GCS::Eventos::EventoModificacionImagen(IView,GNC::GCS::Eventos::EventoModificacionImagen::ImagenCargada));
								}
								break;
							case GNC::GCS::Eventos::EventoModificacionImagen::ImagenCargada:
								break;
							case GNC::GCS::Eventos::EventoModificacionImagen::ImagenModificada:
								break;
							case GNC::GCS::Eventos::EventoModificacionImagen::ImagenDescargada:
								break;
							case GNC::GCS::Eventos::EventoModificacionImagen::VisualizacionImagenModificada:
								if(pEvt->ResetZoom())
								{
									ViewImage2D->ResetZoom();
								}
								ViewImage2D->Modified();
								break;
							case GNC::GCS::Eventos::EventoModificacionImagen::SliceCambiado:
								break;
							case GNC::GCS::Eventos::EventoModificacionImagen::MapaModificado:
								break;
							case GNC::GCS::Eventos::EventoModificacionImagen::AnotacionesEstaticasModificadas:
								break;
						}
						//modification generates render
						lista.push_back(new GNC::GCS::Eventos::EventoRender(IView,pEvt->GetSliceAfectado()));
					}
					break;
				default:
					break;
			}
		}

		//Ginkgo CADx events
		void GFooExtensionView::ProcesarEvento(GNC::GCS::Eventos::IEvento *evt)
		{
			switch (evt->GetCodigoEvento()) {
				case ginkgoEVT_Core_ModificacionImagen:
					{
						GNC::GCS::Eventos::EventoModificacionImagen* pEvt = dynamic_cast<GNC::GCS::Eventos::EventoModificacionImagen*>(evt);
						if (pEvt == NULL) {
							std::cerr << "Error al interpretar evento como evento de modificacion de imagen: Evento = " << evt << std::endl;
							return;
						}
						switch (pEvt->GetTipo()) {
				case GNC::GCS::Eventos::EventoModificacionImagen::ImagenModificada:
				case GNC::GCS::Eventos::EventoModificacionImagen::ImagenCargada:
					{
						ViewImage2D->Modified();
					}
					break;
				case GNC::GCS::Eventos::EventoModificacionImagen::ImagenDescargada:
					break;
				case GNC::GCS::Eventos::EventoModificacionImagen::MapaModificado:
					break;
				case GNC::GCS::Eventos::EventoModificacionImagen::ImagenRecalibrada:
					{
						if (pEvt->GetSliceAfectado() != -1) {
							IView->GetEstudio()->RecalibrarImagen(pEvt->GetSliceAfectado(), pEvt->GetNewSpacing(), pEvt->GetNewOrigin());
						} else {
							IView->GetEstudio()->RecalibrarImagenActiva(pEvt->GetNewSpacing(), pEvt->GetNewOrigin());
						}
					}
					break;
				case GNC::GCS::Eventos::EventoModificacionImagen::VisualizacionImagenModificada:
					break;
				case GNC::GCS::Eventos::EventoModificacionImagen::SliceCambiado:
					break;
				case GNC::GCS::Eventos::EventoModificacionImagen::AnotacionesEstaticasModificadas:
					break;
						}
					}//fin modificacion
					break;

				case ginkgoEVT_Core_Render:
					{
						ViewInteractor2D->Render();
					}//fin render
					break;
				default:
					break;
			}
		}

		//annotator
		std::string GFooExtensionView::GetTopLeftAnnotation(GNC::GCS::Contexto3D* )
		{
			return _Std("GFooView TopLeft annotation");
		}
		std::string GFooExtensionView::GetTopRightAnnotation(GNC::GCS::Contexto3D* c)
		{
			return _Std("GFooView TopRight annotation");
		}
		std::string GFooExtensionView::GetBottomLeftAnnotation(GNC::GCS::Contexto3D* c)
		{
			return _Std("GFooView BottomLeft annotation");
		}
		std::string GFooExtensionView::GetBottomRightAnnotation(GNC::GCS::Contexto3D* c)
		{
			return _Std("GFooView BottomRight annotation");
		}
		std::string GFooExtensionView::GetAnotacionPosicion(GNC::GCS::Vector* pPosicionRaton)
		{
			std::ostringstream ostr;
			ostr << _Std("Position ") << pPosicionRaton->x << ", " << pPosicionRaton->y;
			return ostr.str();
		}
		//

	}
};

