/*
 *  
 *  $Id: conexionopenssl.h 3066 2010-12-21 10:10:14Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include <string>
#include <ostream>
#include <openssl/ssl.h>

class Endpoint;

namespace GIL {
	namespace GnkNetwork {
		namespace GnkSSL {
			class ConexionOpenSSLException : public std::exception {
			public:
				ConexionOpenSSLException(const std::string& msg, bool fatal = true) throw()
				{
					this->cause = msg;
					this->fatal = fatal;
				}
				~ConexionOpenSSLException() throw()
				{
				}

				const std::string& GetCause() const {
					return cause;
				}

				bool IsFatal()  const {
					return fatal;
				}

				operator const std::string () const {
					return std::string("Excepcion En conexion Openssl: ")  + GetCause();
				}

				friend std::ostream& operator<<(std::ostream& out, const ConexionOpenSSLException& ex)
				{
					out << (const std::string&) ex;
					return out;
				}

				friend std::ostream& operator<<(std::ostream& out, const ConexionOpenSSLException* ex)
				{
					if (ex != NULL) {
						out << *ex;
					}
					else {
						out << "(NULL)";
					}
					return out;
				}

			protected:
				std::string cause;
				bool fatal;
			};

			class ConexionOpenSSL {
			public:
				ConexionOpenSSL();
				~ConexionOpenSSL();

				void CrearConexionSSL(const std::string& host, const int& puerto);
				void CerrarConexionSSL();
				void HacerPeticion(const std::string& peticion, std::string& respuesta);

			protected:
#ifdef _WIN32
				//agrega los certificados del sistema
				void X509_STORE_load_windows_systemstore(X509_STORE *store);
#endif
				void CargarCertificadosSistema(X509_STORE *store);
				void ComprobarCertificado(SSL *ssl,const std::string& host);

				SSL_CTX *ctx;
				SSL *ssl;
				Endpoint* ep;
			};
		};
	};
};

