/*
 *  
 *  $Id: herramientamarcado.h 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <export/iherramientamarcado.h>
#include <api/api.h>


namespace GNC {

	namespace GCS {
		namespace Widgets {
			class IWidgetBuilder;
		}
	}

	class EXTAPI HerramientaMarcado : public GNC::GCS::IHerramientaMarcado {
	public:

		typedef  GNC::GCS::IContratable<GNC::GCS::IContratoWidgets> ICConcreto;

		typedef enum TipoMarcado {
			TW_Ninguno,
			TW_Flecha,
			TW_Elipse,
			TW_Punto,
			TW_Trapezoide,
			TW_Poligono
		} TipoMarcado;

		HerramientaMarcado();
		~HerramientaMarcado();

		wxXmlNode* Serializar(GNC::GCS::IVista* pVista,long vid, const std::string nombreMedicoSerializa);

		void Deserializar(GNC::GCS::IVista* pVista, long vid, wxXmlNode* nodo);

		//region "Realizacion de la interfaz IHerramienta"

		// Setup de paneles
		virtual void CrearPaneles( wxPanel* panel );

		//endregion

		virtual void ConectarContratoFalso(bool activar);
		virtual void SetVistaActiva(GNC::GCS::IVista* pVista);
		virtual void ConectarContratos(bool activar);

		//region "Eventos refinados desde los paneles"

		virtual void SetTipoMarcado(TipoMarcado tipo);

		//endregion

	protected:
		GNC::GCS::Widgets::IWidgetBuilder*                 m_pBuilder;
		TipoMarcado                                        m_MarcadoActivo;
		GNC::GCS::IContratoWidgets*                        m_pContratoActivo;
	};
}
