/*
 *  
 *  $Id: pasoperfilimportacion.cpp 3920 2011-07-06 06:12:31Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "pasoperfilimportacion.h"
#include <wx/msgdlg.h>
#include <wx/msgout.h>
#include <wx/filename.h>
#include <main/controllers/configurationcontroller.h>
#include <vector>
#include <sstream>
#include <wx/file.h>
#include <wx/dir.h>
#include <main/controllers/controladorextensiones.h>

#include <api/ientorno.h>
#include <api/icontextoestudio.h>

namespace GNC {
	namespace GUI {

		PasoPefilImportacion::PasoPefilImportacion(wxWindow* pParent,IWizard* pWizard, GNC::GCS::IEntorno* pEntorno):PasoPerfilImportacionBase(pParent),IPasoWizard(pWizard)
		{
			m_pEntorno = pEntorno;
			m_pControladorModulo = NULL;

			GNC::ControladorExtensiones::ListaModulos listaModulos = ControladorExtensiones::Instance()->Modulos();
			for(GNC::ControladorExtensiones::IteradorListaModulos it=listaModulos.begin();it!=listaModulos.end();++it){
				GNC::GCS::IControladorModulo* modulo = (*it).second;
				if(modulo->SoportaImportacion()){
					m_pListaModulos->Append(wxString::FromUTF8(modulo->GetImporterDescription().c_str()));
				}
			}
			m_pListaModulos->Select(0);

			{
				int defaultDicomizator;
				GNC::GCS::ConfigurationController::Instance()->readIntUser("/GinkgoCore/Importacion", "DefaultDicomizator", defaultDicomizator);				
				if (defaultDicomizator < (int)m_pListaModulos->GetCount()) {
					m_pListaModulos->Select(defaultDicomizator);
				}
			}
		}

		PasoPefilImportacion::~PasoPefilImportacion()
		{
			m_pEntorno = NULL;
			m_pControladorModulo = NULL;
		}

//region "Metodos heredados de Ipasowizard"

		void PasoPefilImportacion::Attach(wxSizer *sizer){
			Show(true);
			sizer->Add(this,10, wxEXPAND);
			this->GetParent()->Layout();
		}

		void PasoPefilImportacion::Detach(wxSizer *sizer){
			Hide();
			sizer->Detach(this);
			sizer->GetContainingWindow()->Layout();
		}

		std::string PasoPefilImportacion::GetTitle(){
			return _Std("Selecting Import Profile");
		}

		std::string PasoPefilImportacion::GetSubTitle(){
			return _Std("You must select the profile you want to use import");
		}

		bool PasoPefilImportacion::Siguiente(){
			return true;
		}

		bool PasoPefilImportacion::Anterior(){
			return false;
		}

		bool PasoPefilImportacion::Cancelar(){
			return true;
		}

		bool PasoPefilImportacion::Validar(){
			if(m_pListaModulos->GetSelection()<0){
				wxMessageBox(_("You must select the import profile"), _("Info"),
					 wxOK | wxICON_INFORMATION, this);
				return false;
			}

			std::string nombreModulo(m_pListaModulos->GetStringSelection().ToUTF8());

			GNC::ControladorExtensiones::ListaModulos listaModulos = ControladorExtensiones::Instance()->Modulos();
			for(GNC::ControladorExtensiones::IteradorListaModulos it=listaModulos.begin();it!=listaModulos.end();++it){
				GNC::GCS::IControladorModulo* modulo=(*it).second;
				if(modulo->GetImporterDescription() == nombreModulo){
					m_pControladorModulo = modulo;

					GNC::GCS::ConfigurationController::Instance()->writeIntUser("/GinkgoCore/Importacion", "DefaultDicomizator", m_pListaModulos->GetSelection());				
					return true;
				}
			}
			//
			wxMessageBox(_("Unexpected error, select the module again"), _("Info"),
					 wxOK | wxICON_INFORMATION, this);
			return false;
		}
	//endregion
	}
}
