/*
 *  
 *  $Id: ifiltro.h 3066 2010-12-21 10:10:14Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <string>
#include <list>
#include <map>
namespace GNC {
	namespace GCS {
		class IVista;
	}
}

namespace GNC {

	//------------------------------------------------------------------------------------------

	class IFiltro {

		public:
			typedef enum Implementacion {
				IF_ITK,
				IF_MEF
			} Implementacion;

		protected:
			Implementacion implementacion; // Implementacion del filtro
			bool           filtro3D;       // Indica si el filtro es obligatoriamente 3D o no

		public:
			IFiltro(Implementacion fimplementacion = IF_ITK, bool f3D = false)
			{
				implementacion = fimplementacion;
				filtro3D = f3D;
			}

			virtual ~IFiltro() {}

			virtual void Configurar() {}

			virtual void Procesar(GNC::GCS::IVista* pVista) = 0;

		protected:
			GNC::GCS::IVista* m_pVista;
	};

	//------------------------------------------------------------------------------------------

	class TipoFiltro {
		public:

			TipoFiltro()
			{
				id = -1;
			}

			TipoFiltro(long fid, long fcategoria, const std::string& strNombre, const std::string& strDescripcion)
			{
				id = fid;
				categoria = fcategoria;
				nombre = strNombre;
				descripcion = strDescripcion;
			}

			TipoFiltro(long fid, long fcategoria, const char* strNombre, const char* strDescripcion)
			{
				id = fid;
				categoria = fcategoria;
				nombre.assign(strNombre);
				descripcion.assign(strDescripcion);
			}

			TipoFiltro(const TipoFiltro& otro)
			{
				id = otro.id;
				categoria = otro.categoria;
				nombre = otro.nombre;
				descripcion = otro.descripcion;
			}

			TipoFiltro& operator=(const TipoFiltro& otro)
			{
				id = otro.id;
				categoria = otro.categoria;
				nombre = otro.nombre;
				descripcion = otro.descripcion;
				return *this;
			}

			long id;
			long categoria;
			std::string nombre;
			std::string descripcion;
	};

	//------------------------------------------------------------------------------------------

	class IFiltrosManager {
		public:
			typedef std::list<TipoFiltro> ListaFiltros;
			typedef ListaFiltros::iterator IteradorListaFiltros;
			typedef std::map<long, std::string> MapaCategorias;

			IFiltrosManager();
			~IFiltrosManager();

			ListaFiltros&   GetListaFiltros();
			MapaCategorias& GetMapaCategorias();

			IFiltro* CrearFiltro(long id);

			void DestruirFiltro(IFiltro* pFiltro);

		protected:
			ListaFiltros   m_Filtros;
			MapaCategorias m_Categorias;
	};

}
