/*
*  
*  $Id: deletefilehistory.h 3698 2011-04-14 12:38:49Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once

#include <string>
#include <vector>
#include <yasper/yasper.h>
#include <api/imodelointegracion.h>


namespace GNC {
	namespace GCS {
		namespace Eventos {

			class EXTAPI EventDeleteFileHistory: public GNC::GCS::Eventos::IEvento
			{
			public:

				typedef std::list<std::string> TIdList;

				EventDeleteFileHistory():GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_DeleteFile)
				{
					m_Nombre = "DeleteFileHistory";
				}

				EventDeleteFileHistory(const std::string& patientId, const std::string& studyId, const std::string& seriesId, const TIdList& listSopInstanceUID ):GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_DeleteFile)
				{
					m_listSopInstanceUID = listSopInstanceUID;
					m_PatientId = patientId;
					m_StudyId = studyId;
					m_SeriesId = seriesId;
					m_Nombre = "DeleteFileHistory";
				}

				~EventDeleteFileHistory()
				{
				}

				TIdList &GetIdList()
				{
					return m_listSopInstanceUID;
				}

				std::string& GetPatientId()
				{
					return m_PatientId;
				}

				std::string& GetStudyId()
				{
					return m_StudyId;
				}

				std::string& GetSeriesId()
				{
					return m_SeriesId;
				}

				virtual void pushInfo(std::ostream& out) const {
					out << " Ids = [ ";
					int i = 0;
					for (TIdList::const_iterator it = m_listSopInstanceUID.begin(); it != m_listSopInstanceUID.end(); it++) {
						if (i != 0) {
							out << ", ";
						}
						out << (*it).c_str();
					}
					out << " ]";
				}

			protected:
				TIdList          m_listSopInstanceUID;
				std::string		  m_PatientId;
				std::string		  m_StudyId;
				std::string		  m_SeriesId;
			};
		}
	}
}
