/*
 *  
 *  $Id: iwidgetsmanager.cpp 3483 2011-03-10 14:56:55Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#include "iwidgetsmanager.h"
#include "observers/iwidgetsobserver.h"

GNC::GCS::IWidgetsManager::IWidgetsManager(GNC::GCS::IVista* pVista) {
	m_pVista = pVista;
	m_pBuilder = NULL;
	m_Modificado = false;
	m_pRendererActivo = NULL;
}

GNC::GCS::IWidgetsManager::~IWidgetsManager() {
	m_pVista = NULL;
}

//----------------------------------------------------------------------------------------------------
//region "Interfaz de registro del IWidgetsRenderer"

void GNC::GCS::IWidgetsManager::InsertarObservador(GNC::GCS::Widgets::IObservadorWidget* observador)
{
	m_Observadores.push_back(observador);
}

void GNC::GCS::IWidgetsManager::EliminarObservador(GNC::GCS::Widgets::IObservadorWidget* observador)
{
	IteradorListaObservadores it;
	
	for (it = m_Observadores.begin(); it != m_Observadores.end() && (*it) != observador; it++);
	
	if (it != m_Observadores.end()) {
		m_Observadores.erase(it);
	}
}

//endregion

