#pragma once

#include <api/globals.h>
#include <api/ivista.h>
#include <api/icontextoestudio.h>


#include <list>
#include <vector>
#include <map>

namespace GNC {
	namespace GCS {
		class IEntorno;
	}
}

class wxWindow;

namespace GNC {
	namespace GUI {
		class StartUpForm;
		class StartUpViewTimer;

		class StartUpStudy : public GNC::GCS::IContextoEstudio
		{
		public:
			
			StartUpStudy(){}
			~StartUpStudy(){}

			virtual bool CallbackPreCrearDiagnostico(const int /*indice*/, GIL::DICOM::TipoJerarquia* /*pJerarquiaSR*/, std::list<GnkPtr<GIL::DICOM::TipoPrivateTags> >& /*listaTagsPrivados*/) {return true;}
			virtual bool CallbackPreGuardarDiagnostico(const int /*indice*/, GIL::DICOM::IDICOMManager* /*pDicomManager*/) {return true;}
			virtual void CallbackCargarTagsImagen(const int /*indice*/, GIL::DICOM::IDICOMManager* /*pDicomManager*/) {}


		protected:

		};

		class StartUpView  : public GNC::GCS::IVista {
		public:
			/* Constructor */
			StartUpView (const GnkPtr<GNC::GUI::StartUpStudy>& study);

			/* Destructor */
			~StartUpView ();

			//suports save?
			virtual bool SoportaGuardar();

			//supports exportation?
			virtual bool SoportaExportar();

			//----------------------------------------------------------------------------------------------------
			//region Loading interface

			// Starts loading. Synchronous with interface.
			virtual void OnCargaIniciada();

			// Step1: LoadStudy not synchronized with interface thread
			virtual void CargarEstudio(GNC::GCS::IComando* pCmdInvocador);

			//Ends loading. Synchronous with interface
			virtual void OnCargaFinalizada();

			// Step2: init pipeline synchronous with interface
			virtual void IniciarPipeline();

			// stops pipeline, it's called if there has been an error loading study
			virtual void DetenerPipeline();

			//endregion

			//call when this view is activated
			virtual void Activar();

			virtual bool LoadTwitter();
			virtual bool LoadWelcome();

			//return graphic form
			virtual wxWindow* GetWindow();

			virtual void OnFocus();

		protected:

			void BuildTitle();

			bool DownloadFile(const std::string& url, const wxString& pathOfFileWx);
			std::string GetRSSUrl();
			std::string GetWelcomeUrl();

			GNC::GUI::StartUpForm* m_pWindow;
			GnkPtr<GNC::GUI::StartUpStudy>     FooStudy;
			std::string m_twiterFile;
			std::string m_welcomeFile;
			StartUpViewTimer* m_pTimer;

		};
	}
}
