/*
 *  
 *  $Id: wxwizarduploadpacs.cpp 4403 2011-11-14 10:59:24Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <wx/filename.h>
#include <wx/file.h>
#include <wx/dir.h>
#include <wx/busyinfo.h>

#include <wx/ginkgostyle/ginkgostyle.h>

#include "wxwizarduploadpacs.h"
#include "selectfiles.h"

#include <vector>
#include <sstream>

#include <api/ientorno.h>
#include <api/ivista.h>
#include <api/icontextoestudio.h>
#include <main/entorno.h>
#include <main/controllers/controladorextensiones.h>
#include <main/controllers/controladorcomandos.h>
#include <resources/ginkgoresourcemanager.h>
#include <commands/comandopacs.h>
#include <commands/comandomergediagnosticwithimage.h>


namespace GNC {
	namespace GUI {
			wxWizardUploadPACSGinkgo::wxWizardUploadPACSGinkgo(wxWindow* pParent, const TListUIDs& uids) : wxWizardGinkgoBase(pParent)
			{
				SetTitle(_("Assistant to send files to PACS"));
				SetSize(760,500);

				m_OK = false;

				//se pillan los pasos
				IPasoWizard* pPaso = NULL;
								
				pPaso = new SelectFiles(m_pPanelPrincipal, uids, this);

				m_ListaPasos.push_back(pPaso);

				m_pBAnterior->Show(false);

				//
				m_currentPaso = m_ListaPasos.begin();
				m_currentPasoIndex = 1;
				CargarCurrent();
			}

			wxWizardUploadPACSGinkgo::~wxWizardUploadPACSGinkgo()
			{
				m_ListaPasos.clear();
			}


			void wxWizardUploadPACSGinkgo::OnCancelarClick(wxCommandEvent& )
			{
				Close();
			}

			void wxWizardUploadPACSGinkgo::OnSiguienteClick(wxCommandEvent& )
			{
				if((*m_currentPaso)->Validar()){
					wxWindow* pCurrent = dynamic_cast<wxWindow*> (*m_currentPaso);
					if (pCurrent != NULL && (*m_currentPaso)->Detach()) {
						pCurrent->Hide();
						m_pSizerPrincipal->Detach(pCurrent);
						++m_currentPasoIndex;
						++m_currentPaso;
						if(m_currentPaso==m_ListaPasos.end()){
							Hide();						
							m_OK = true;
						}else{
							CargarCurrent();
						}
					}
				}
			}

			void wxWizardUploadPACSGinkgo::OnAnteriorClick(wxCommandEvent &)
			{
				if(m_currentPaso!=m_ListaPasos.begin()){
					wxWindow* pCurrent = dynamic_cast<wxWindow*> (*m_currentPaso);
					if (pCurrent != NULL && (*m_currentPaso)->Detach()) {
						pCurrent->Hide();
						m_pSizerPrincipal->Detach(pCurrent);

						--m_currentPaso;
						--m_currentPasoIndex;
						CargarCurrent();
					}
				}
			}

			 bool wxWizardUploadPACSGinkgo::IsOK()
			 {
				 return m_OK;
			 }

			 void wxWizardUploadPACSGinkgo::CargarCurrent(){
				wxWindow* pCurrent = dynamic_cast<wxWindow*> (*m_currentPaso);
				if (pCurrent != NULL && (*m_currentPaso)->Attach()) 
				{
					pCurrent->Show(true);
				m_pSizerPrincipal->Add(pCurrent, 10, wxEXPAND);

					m_pHeader->SetTitle(wxString::FromUTF8((*m_currentPaso)->GetTitle().c_str()));
					m_pBSiguiente->Enable((*m_currentPaso)->Siguiente());
					m_pBAnterior->Enable((*m_currentPaso)->Anterior());
					m_pBCerrar->Enable((*m_currentPaso)->Cancelar());
					if(*(m_currentPaso)==m_ListaPasos.back()){
						m_pBSiguiente->SetLabel(_("&Accept"));
					}else{
						m_pBSiguiente->SetLabel(_("&Next >"));
					}
				}
				m_pPanelPrincipal->Layout();
				Layout();
			 }




	};

};
