/*
 *  
 *  $Id: initwx.h 4701 2012-02-14 13:00:19Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <wx/app.h>
#include <wx/bitmap.h>
#include <api/icontroladormodulo.h>
#include <wx/snglinst.h>
#include <api/icontroladoreventos.h>

class wxSingleInstanceChecker;
class Entorno;
class stServer;

// Colores de la ventana del logo
#define SPLASH_COLOR_RELLENO "#4400FF" // Azul
#define SPLASH_COLOR_BORDE   "#d4d4d4" // Gris
#define SPLASH_COLOR_TEXTO   "#d4d4d4" // Gris

class wxSplashScreen;
class VentanaPrincipal;

class Ginkgo : public wxApp, GNC::GCS::IObservador {
public:
	virtual bool OnInit();
	virtual int OnExit();

#ifdef __WXMAC__
	virtual void MacOpenFile(const wxString &fileName);
	std::string m_OpenFileName;
	bool m_Inicializado;
#endif

	virtual void DoProgress(wxString str);

	VentanaPrincipal* GetMainFrame();

	void OnSplashClose(wxCloseEvent& event);

	void WriteHeaderLog();

//IObservador
	virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt);
	virtual int FilterEvent(wxEvent &event);

//region "Carga de Extensiones"
	void LoadPlugins();
//endregion


private:


protected:
	wxSplashScreen*			m_pVentanaLogo;
	wxBitmap                m_pBitmapOriginal;
	VentanaPrincipal*       m_pVentanaPrincipal;
	wxSingleInstanceChecker m_singleInstanceChecker;
	stServer*               m_pServer;

public:

	wxCriticalSection m_SplashCriticalSection;
};

#if defined(_WIN32)
int WINAPI InitWX(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow);
#else
int InitWX(int argc, char** argv);
#endif
