#!/bin/sh
#
# setup-unconfigured.sh
#
# --------------------------------------------------------------------------
# Copyright notice
# --------------------------------------------------------------------------
# Copyright: Rene Mayrhofer, Mar. 2000
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# On Debian GNU/Linux systems, the complete text of the GNU General
# Public License can be found in `/usr/share/common-licenses/GPL'.
# --------------------------------------------------------------------------
#

. /usr/lib/gibraltar-bootsupport/common-definitions.sh

umask 077
set -e

# is the system is unconfigured at this stage, run all setup scripts
if [ -f /etc/unconfigured ]; then
  echo
  echo -e "This is an ${COLOR_RED}unconfigured${COLOR_NORMAL} system."\
       "Running configuration phase now ..."
  echo "- start ------------------------------------------------------------------------"
  for script in /etc/setup.d/*; do
    # Ignore dangling symlinks for now.
    [ ! -f "$script" ] && continue

    $script
  done
  echo "- done -------------------------------------------------------------------------"
  echo

  # after all scripts were run successfully (if not, "set -e" would have
  # exited this script after the first failure), they should not be run
  # anymore on the next reboot
  rm /etc/unconfigured
fi
