# --------------------------------------------------------------------------
# Copyright notice
# --------------------------------------------------------------------------
# Copyright: Rene Mayrhofer, Mar. 2000
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# On Debian GNU/Linux systems, the complete text of the GNU General
# Public License can be found in `/usr/share/common-licenses/GPL'.
# --------------------------------------------------------------------------
#

# this is just for older configuration that used this filename
if [ -e /etc/gibraltar_config ]; then
  . /etc/gibraltar_config
fi

if [ -e /etc/gibraltar/config ]; then
  . /etc/gibraltar/config
fi

if [ -z "$MAX_DISK_TRIES" ]; then
  MAX_DISK_TRIES=5
fi
if [ -z "$MAX_SAVE_TRIES" ]; then
  MAX_SAVE_TRIES=5
fi
if [ -z "$DISK_TIMEOUT" ]; then
  DISK_TIMEOUT=30
fi
if [ -z "$SAVE_TARGET" ]; then
  SAVE_TARGET=/dev/fd0
fi
if [ -z "$SAVE_AUTOFORMAT" ]; then
  SAVE_AUTOFORMAT=NO
fi
if [ -z "$ETCDISK_SIZE" ]; then
  ETCDISK_SIZE=32m
fi
if [ -z "$VARDISK_SIZE" ]; then
  VARDISK_SIZE=4m
fi

DEFAULT_ETC=/system/etc-defaults.tar.gz
DEFAULT_VAR=/system/var-defaults.tar.gz

# the target for saving the configuration is mounted here
temp_mntpoint=/mnt/temp
save_mntpoint=/mnt/configmedia
save_etcimage=$save_mntpoint/etc.tgz
save_etcimage_name=etc.tgz
save_etcimage_old=$save_mntpoint/etc.gz
save_txtfile=/system/config-disk.msg
save_filesystems_floppy="vfat ext2"
# the possible filesystem types for storing the configuration on a harddisk
# partition
save_filesystems_hdd="vfat ext3 ext2 reiserfs"

# do not edit below this line
# ------------------------------------------------------------

# without the proc filesystem, I can not gather defaults
if [ ! -r /proc/mounts ]; then
  mount -t proc proc /proc
fi

# some definitions
if [ $TERM = "linux" ] && ! grep "console=ttyS" /proc/cmdline >/dev/null; then
  COLOR_NORMAL="\033[0m"
  COLOR_BLUE="\033[1;34m"
  COLOR_GREEN="\033[1;32m"
  COLOR_RED="\033[1;31m"

  beepconsole() {
    beep $@
  }
else
  COLOR_NORMAL=""
  COLOR_BLUE=""
  COLOR_GREEN=""
  COLOR_RED=""

  beepconsole() {
    /bin/true
  }
fi

# NEW: beginnings of devfs support
devfs_support=0
if grep "devfs" /proc/filesystems >/dev/null; then
  # ahh, the kernel supports devfs, but is it mounted too ?
  if grep "devfs" /proc/mounts >/dev/null; then
    devfs_support=1
  fi
fi

# the ram device names are different when devfs is used
# the floppy device name is different too
if [ $devfs_support -eq 0 ]; then
  ramdisks="/dev/ram"
  save_floppies="/dev/fd"
else
  ramdisks="/dev/rd/"
  save_floppies="/dev/floppy/"
fi

call_script_hook() {
  if [ -x /system/scripts/$1 ]; then
    script=$1
    shift
    echo "Calling system script-hook $script"
    /system/scripts/$script $@
  fi

  if [ -x /etc/local/sbin/$1 ]; then
    script=$1
    shift
    echo "Calling user script-hook $script"
    /etc/local/sbin/$script $@
  fi
}

insmod_helper() {
  if [ $# -lt 1 ]; then
    echo "Usage: insmod_helper <module name>"
    return 1
  fi

  local path=`find /lib/modules/$kernelver/ -name "$1.o"`
  if [ -n "$path" ]; then
    if [ -r $path ]; then
      if insmod --autoclean --noksymoops --quiet $path >/dev/null 2>/dev/null; then
        return 0
      else
        return 2
      fi
    fi
  fi
  return 100
}

check_disk_size_string() {
  if [ `expr $1 : "[0-9]\+[kmg]\?$"` -ne `echo $1 | wc --max-line-length` ]
  then
    echo "Error: $2 in /etc/gibraltar/config is invalid."
    exit 2
  fi
}

mount_tmpfs() {
  if ! mount -n -o size=$1,mode=0755 -t tmpfs tmpfs $2; then
    echo "Error during mounting."
    exit 3
  fi
}

remount_tmpfs() {
  if ! mount -n -o remount,size=$1 -t tmpfs tmpfs $2; then
    echo "Remounting failed, your settings for the maximum ramdisk size could not be applied."
    exit 4
  fi
}

mount_tmpfs_without_sizelimit() {
  if ! mount -n -o mode=0755 -t tmpfs tmpfs $1; then
    echo "Error during mounting."
    exit 3
  fi
}

# this method checks if the given device is already mounted and prints the 
# mountpath to stdout if it is
get_mount_path() {
  local maj=`ls -lnL $1 | cut -c 33-37 | tr -d " "`
  local min=`ls -lnL $1 | cut -c 39-42 | tr -d " "`
  cat /proc/mounts | while read mntline; do
    mntdev=`echo "$mntline" | cut -d' ' -f1,1`
    mntpath=`echo "$mntline" | cut -d' ' -f2,2`
    if [ -e $mntdev ]; then
      local majmnt=`ls -lnL $mntdev | cut -c 33-37 | tr -d " "`
      local minmnt=`ls -lnL $mntdev | cut -c 39-42 | tr -d " "`
      if [ $majmnt -eq $maj ] && [ $minmnt -eq $min ]; then
        echo $mntpath
      fi
    fi
  done
}
