// GTK_ELDVIEW_WND.CPP

// Copyright (C) 2005 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "gtk_eldview_wnd.h"

#include "eldview_wcl.h"
#include "gtk_app.h"

/*################################################################################################*/

GtkActionEntry gtk_eldview_wnd::entries[] =
{
	{ "AttachDetachELD", NULL, "Attach/Detach This View", NULL, "Select whether this view is attached or in an independent window", (GCallback) gtk_eldview_wnd::popup_AttachDetach },
	{ "DeleteViewELD", NULL, "Delete View", NULL, "Delete this view", (GCallback) gtk_eldview_wnd::popup_DeleteView }
};

const char * gtk_eldview_wnd::ui_description =
"<ui>"
"  <popup name='geldvMenu'>"
"    <menuitem action='AttachDetachELD'/>"
"    <separator/>"
"    <menuitem action='DeleteViewELD'/>"
"  </popup>"
"</ui>";

gtk_eldview_wnd::gtk_eldview_wnd(bool det_flag) :
	gtk_wnd(det_flag)
{
	GtkActionGroup * action_group = gtk_action_group_new("geldvActions");
	gtk_action_group_add_actions(action_group, entries, G_N_ELEMENTS(entries), GTK_WIDGET(view_widget));
	
	gtk_ui_manager_insert_action_group(gtk_app::GetUIManager(), action_group, 0);
	
	GError * error = NULL;
	if (!gtk_ui_manager_add_ui_from_string(gtk_app::GetUIManager(), ui_description, -1, & error))
	{
		g_message("Building geldv menu failed : %s", error->message);
		g_error_free(error); exit(EXIT_FAILURE);
	}
	
	// set gtk_view::popupmenu so that gtk_ogl_view::ButtonHandler() will display it...
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	popupmenu = gtk_ui_manager_get_widget(gtk_app::GetUIManager(), "/geldvMenu");
}

gtk_eldview_wnd::~gtk_eldview_wnd(void)
{
}

// here are the popup menu callbacks:
// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

void gtk_eldview_wnd::popup_AttachDetach(GtkWidget *, gpointer data)
{
	gtk_wnd * wnd = iv_Find((GtkWidget *) data);
	eldview_wcl * wcl = dynamic_cast<eldview_wcl *>(wnd->GetClient());
	
	gtk_app::GetAppX()->AttachDetachView(wcl);
}

void gtk_eldview_wnd::popup_DeleteView(GtkWidget *, gpointer data)
{
	gtk_wnd * wnd = iv_Find((GtkWidget *) data);
	eldview_wcl * wcl = dynamic_cast<eldview_wcl *>(wnd->GetClient());
	
	gtk_app::GetPrjX()->RemovePlottingClient(wcl);
}

/*################################################################################################*/

// eof
