-- #hide
--------------------------------------------------------------------------------
-- |
-- Module      :  Sound.OpenAL.AL.ObjectInternal
-- Copyright   :  (c) Sven Panne 2003
-- License     :  BSD-style (see the file libraries/OpenAL/LICENSE)
-- 
-- Maintainer  :  sven_panne@yahoo.com
-- Stability   :  provisional
-- Portability :  portable
--
--------------------------------------------------------------------------------

module Sound.OpenAL.AL.ObjectInternal (
   Object(..)
) where

import Foreign.Storable ( Storable(..) )
import Foreign.Ptr ( Ptr )
import Sound.OpenAL.AL.BasicTypes

--------------------------------------------------------------------------------

class Storable a => Object a where
   alGenObjects :: ALsizei -> Ptr a -> IO ()
   alDeleteObjects :: ALsizei -> Ptr a -> IO ()
   alIsObject :: a -> IO ALboolean
