-- #hide
--------------------------------------------------------------------------------
-- |
-- Module      :  Sound.OpenAL.AL.Format
-- Copyright   :  (c) Sven Panne 2003
-- License     :  BSD-style (see the file libraries/OpenAL/LICENSE)
-- 
-- Maintainer  :  sven_panne@yahoo.com
-- Stability   :  provisional
-- Portability :  portable
--
--------------------------------------------------------------------------------

module Sound.OpenAL.AL.Format (
   Format(..), marshalFormat, unmarshalFormat
) where

import Sound.OpenAL.AL.BasicTypes ( ALenum )

--------------------------------------------------------------------------------

#include "HsOpenALConfig.h"

--------------------------------------------------------------------------------

data Format =
     Mono8
   | Mono16
   | Stereo8
   | Stereo16
   | IMAADPCMMono16
   | IMAADPCMStereo16
   | Vorbis
   | Quad8
   | Quad16
   deriving ( Eq, Ord, Show )

marshalFormat :: Format -> ALenum
marshalFormat x = case x of
   Mono8 -> 0x1100
   Mono16 -> 0x1101
   Stereo8 -> 0x1102
   Stereo16 -> 0x1103
   IMAADPCMMono16 -> 0x10000
   IMAADPCMStereo16 -> 0x10001
   Vorbis -> CONST_AL_FORMAT_VORBIS_EXT
   Quad8 -> 0x10004
   Quad16 -> 0x10005

unmarshalFormat :: ALenum -> Format
unmarshalFormat x
   | x == 0x1100 = Mono8
   | x == 0x1101 = Mono16
   | x == 0x1102 = Stereo8
   | x == 0x1103 = Stereo16
   | x == 0x10000 = IMAADPCMMono16
   | x == 0x10002 = IMAADPCMStereo16
   | x == CONST_AL_FORMAT_VORBIS_EXT = Vorbis
   | x == 0x10004 = Quad8
   | x == 0x10005 = Quad16
   | otherwise = error ("unmarshalFormat: illegal value " ++ show x)
