--------------------------------------------------------------------------------
-- |
-- Module      :  Sound.OpenAL.AL.BasicTypes
-- Copyright   :  (c) Sven Panne 2003
-- License     :  BSD-style (see the file libraries/OpenAL/LICENSE)
-- 
-- Maintainer  :  sven_panne@yahoo.com
-- Stability   :  provisional
-- Portability :  portable
--
-- This module corresponds to section 2.1.1 (Primitive Types) of the OpenAL
-- Specification and Reference (version 1.0).
--
--------------------------------------------------------------------------------

module Sound.OpenAL.AL.BasicTypes (
   ALboolean, ALbyte, ALshort, ALint, ALubyte, ALushort, ALuint, ALsizei,
   ALenum, ALbitfield, ALfloat, ALclampf, ALdouble, ALclampd
) where

--------------------------------------------------------------------------------

import Data.Int
import Data.Word

--------------------------------------------------------------------------------

#include "HsOpenALConfig.h"

--------------------------------------------------------------------------------

-- | Boolean (min. 1 bit)
type ALboolean = HTYPE_ALBOOLEAN

-- | Signed 2\'s complement binary integer (min. 8 bits)
type ALbyte = HTYPE_ALBYTE

-- | Unsigned binary integer (min. 8 bits)
type ALubyte = HTYPE_ALUBYTE

-- | Signed 2\'s complement binary integer (min. 16 bits)
type ALshort = HTYPE_ALSHORT

-- | Unsigned binary integer (min. 16 bits)
type ALushort = HTYPE_ALUSHORT

-- | Signed 2\'s complement binary integer (min. 32 bits)
type ALint = HTYPE_ALINT

-- | Unsigned binary integer (min. 32 bits)
type ALuint = HTYPE_ALUINT

-- | Non-negatitve binary integer size (min. 32 bits)
type ALsizei = HTYPE_ALSIZEI

-- | Enumerated binary integer value (min. 32 bits)
type ALenum = HTYPE_ALENUM

-- | Bit field (min. 32 bits)
type ALbitfield = HTYPE_ALBITFIELD

-- | Floating-point value (min. 32 bits)
type ALfloat = HTYPE_ALFLOAT

-- | Floating-point value clamped to [0,1] (min. 32 bits)
type ALclampf = HTYPE_ALCLAMPF

-- | Floating-point value (min. 64 bits)
type ALdouble = HTYPE_ALDOUBLE

-- | Floating-point value clamped to [0,1] (min. 64 bits)
type ALclampd = HTYPE_ALCLAMPD
