/* $Id: support.c,v 1.11 2002/10/30 21:24:03 thrull Exp $ */

/*
 * (C) Copyright 2001-2002 Igor Popik. Released under terms of GPL license.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#ifdef USE_GNOME
#include <gnome.h>
#endif
#include "support.h"
#include "interface.h"

/* This is an internally used function to check if a pixmap file exists. */
static gchar *check_file_exists(const gchar * directory,
				const gchar * filename);

/* This is an internally used function to create pixmaps. */
static GtkWidget *create_dummy_pixmap(GtkWidget * widget);

GtkWidget *lookup_widget(GtkWidget * widget, const gchar * widget_name)
{
	GtkWidget *parent, *found_widget;

	for (;;) {
		if (GTK_IS_MENU(widget))
			parent =
			    gtk_menu_get_attach_widget(GTK_MENU(widget));
		else
			parent = widget->parent;
		if (parent == NULL)
			break;
		widget = parent;
	}

	found_widget =
	    (GtkWidget *) gtk_object_get_data(GTK_OBJECT(widget),
					      widget_name);
	if (!found_widget)
		g_warning("Widget not found: %s", widget_name);
	return found_widget;
}

/* This is a dummy pixmap we use when a pixmap can't be found. */
static char *dummy_pixmap_xpm[] = {
/* columns rows colors chars-per-pixel */
	"1 1 1 1",
	"  c None",
/* pixels */
	" "
};

/* This is an internally used function to create pixmaps. */
static GtkWidget *create_dummy_pixmap(GtkWidget * widget)
{
	GdkColormap *colormap;
	GdkPixmap *gdkpixmap;
	GdkBitmap *mask;
	GtkWidget *pixmap;

	colormap = gtk_widget_get_colormap(widget);
	gdkpixmap =
	    gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask,
						  NULL, dummy_pixmap_xpm);
	if (gdkpixmap == NULL)
		g_error("Couldn't create replacement pixmap.");
	pixmap = gtk_pixmap_new(gdkpixmap, mask);
	gdk_pixmap_unref(gdkpixmap);
	gdk_bitmap_unref(mask);
	return pixmap;
}
static GList *pixmaps_directories = NULL;
static GList *sounds_directories = NULL;

/* Use this function to set the directory containing installed pixmaps. */
void add_pixmap_directory(const gchar * directory)
{
	pixmaps_directories = g_list_prepend(pixmaps_directories,
					     g_strdup(directory));
}

void add_sound_directory(const gchar * directory)
{
	sounds_directories = g_list_prepend(sounds_directories,
					    g_strdup(directory));
}

/* This is an internally used function to create pixmaps. */
GtkWidget *create_pixmap(GtkWidget * widget, const gchar * filename)
{
	gchar *found_filename = NULL;
	GdkColormap *colormap;
	GdkPixmap *gdkpixmap;
	GdkBitmap *mask;
	GtkWidget *pixmap;
	GList *elem;

	if (!filename || !filename[0])
		return create_dummy_pixmap(widget);

	/* We first try any pixmaps directories set by the application. */
	elem = pixmaps_directories;
	while (elem) {
		found_filename =
		    check_file_exists((gchar *) elem->data, filename);
		if (found_filename)
			break;
		elem = elem->next;
	}

	/* If we haven't found the pixmap, try the source directory. */
	if (!found_filename) {
		found_filename = check_file_exists("../pixmaps", filename);
	}

	if (!found_filename) {
		g_warning(_("Couldn't find pixmap file: %s"), filename);
		return create_dummy_pixmap(widget);
	}

	colormap = gtk_widget_get_colormap(widget);
	gdkpixmap =
	    gdk_pixmap_colormap_create_from_xpm(NULL, colormap, &mask,
						NULL, found_filename);
	if (gdkpixmap == NULL) {
		g_warning(_("Error loading pixmap file: %s"),
			  found_filename);
		g_free(found_filename);
		return create_dummy_pixmap(widget);
	}
	g_free(found_filename);
	pixmap = gtk_pixmap_new(gdkpixmap, mask);
	gdk_pixmap_unref(gdkpixmap);
	gdk_bitmap_unref(mask);
	return pixmap;
}

/* This is an internally used function to check if a file exists. */
gchar *check_file_exists(const gchar * directory, const gchar * filename)
{
	gchar *full_filename;
	struct stat s;
	gint status;
	if (directory != NULL) {
    	    full_filename = (gchar *) g_malloc(strlen(directory) + 1
					   + strlen(filename) + 1);
	    strcpy(full_filename, directory);
	    strcat(full_filename, G_DIR_SEPARATOR_S);
	    strcat(full_filename, filename);
	} else {
	    full_filename = g_strdup(filename);
	}
	status = stat(full_filename, &s);
	if (status == 0 && S_ISREG(s.st_mode))
		return full_filename;
	g_free(full_filename);
	return NULL;
}

gchar *get_pixmap_path(gchar * filename)
{
	gchar *found_filename = NULL;
	GList *elem;
	
	if (!filename || !filename[0])
		return NULL;
	
	g_print("GETTING PIXMAP PATH FOR: %s\n", filename);
	/* We first try any pixmaps directories set by the application. */
	elem = pixmaps_directories;
	while (elem) {
		found_filename =
		    check_file_exists((gchar *) elem->data, filename);
		if (found_filename)
			break;
		elem = elem->next;
	}

	/* If we haven't found the pixmap, try the source directory. */
	if (!found_filename) {
		found_filename = check_file_exists("../pixmaps", filename);
	}

	if (!found_filename) {
		g_warning(_("Couldn't find pixmap file: %s"), filename);
		return 0;
	}
	return found_filename;
}

gchar *get_sound_path(gchar * filename)
{
	gchar *found_filename = NULL;
	GList *elem;

	if (!filename || !filename[0])
		return NULL;

	/* We first try any sounds directories set by the application. */
	elem = sounds_directories;
	while (elem) {
		found_filename =
		    check_file_exists((gchar *) elem->data, filename);
		if (found_filename)
			break;
		elem = elem->next;
	}

	/* If we haven't found the sound, try the source directory. */

	if (!found_filename) {
		found_filename = check_file_exists("../sounds", filename);
	}

	if (!found_filename) {
		found_filename = check_file_exists(NULL, filename);
		g_print("Still srying\n");
	}

	if (!found_filename) {
		g_warning(_("Couldn't find sound file: %s"), filename);
		return 0;
	}
	return found_filename;
}

void show_message_dialog(gchar * message)
{
#ifndef USE_GNOME
	GtkWidget *dialog;
	GtkWidget *label;

	dialog = create_simple_dialog(_("GNU Gadu"));

	label = lookup_widget(dialog, "label");
	gtk_label_set_text(GTK_LABEL(label), _(message));
	gtk_widget_show(dialog);
#else
	gnome_ok_dialog(message);
#endif
}

void show_error_dialog(gchar * message)
{
	GtkWidget *dialog;
#ifndef USE_GNOME
	GtkWidget *label;

	dialog = create_simple_dialog(_("Bd"));

	label = lookup_widget(dialog, "label");
	gtk_label_set_text(GTK_LABEL(label), _(message));
	gtk_widget_show(dialog);
#else
	dialog = gnome_error_dialog(message);
#endif
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
}

gchar *get_timestamp(time_t t)
{
	time_t _t;
	struct tm *tm;
	char buf[1024];
	
	if (t) 
	    _t = t;
	else
	    time(&_t);
	    
	tm = localtime(&_t);
	strftime(buf, 1024 - 1, "%H:%M", tm);

	return g_strdup(buf);
}

gchar *get_full_timestamp(time_t t)
{
	time_t _t;
	struct tm *tm;
	char buf[1024];

	if (t) 
	    _t = t;
	else
	    time(&_t);

	tm = localtime(&_t);
	strftime(buf, 1024, "%a, %d-%m-%Y %H:%M", tm);

	return g_strdup(buf);
}

/*
 * cp_to_iso()
 *
 * zamienia krzaczki pisane w cp1250 na iso-8859-2, przy okazji maskujc
 * znaki, ktrych nie da si wywietli, za wyjtkiem \r i \n.
 *
 *  - buf.
 */
void cp_to_iso(unsigned char *buf)
{
	while (*buf) {
		switch (*buf) {
		case 165:
			*buf = 161;	//
			break;
		case 185:
			*buf = 177;	//
			break;
		case 140:
			*buf = 166;	//
			break;
		case 156:
			*buf = 182;	//
			break;
		case 143:
			*buf = 172;	//
			break;
		case 159:
			*buf = 188;	//
			break;
		default:
			if (*buf != 13 && *buf != 10
			    && (*buf < 32 || (*buf > 127 && *buf < 160)))
				*buf = '?';
		}
		buf++;
	}
}

/*
 * iso_to_cp()
 *
 * zamienia sensowny format kodowania polskich znaczkw na bezsensowny.
 *
 *  - buf.
 */
void iso_to_cp(unsigned char *buf)
{
	while (*buf) {
		switch (*buf) {
		case 161:	//
			*buf = 165;
			break;
		case 177:	//
			*buf = 185;
			break;
		case 166:	//
			*buf = 140;
			break;
		case 182:	//
			*buf = 156;
			break;
		case 172:	//
			*buf = 143;
			break;
		case 188:	//
			*buf = 159;
			break;
		}
		buf++;
	}
}

/* 
 * remove_cr()
 *
 * Funkcja usuwa brzydki znak konca linii (CR) dodawany przez pewien popularny system
 * (brzydkie kwadraty w niektorych wersjach GTK/GNOME)
 */

void remove_cr(gchar *buf)
{
    gchar *tmp = buf;
    
    if (!buf) return;

    for (; *tmp; tmp++) {	
	*buf = *tmp;
	if (*tmp != '\r') buf++;
    }
    *buf = 0;
}

/* 
 * insert_cr()
 *
 * Funkcja dodaje brzydki znak konca linii (CR) poniewaz pewien popularny system
 * skleja wszystko gdy wysylamy z UNIX'ow wielolinijkowy tekst.
 */

gchar *insert_cr(gchar *buf)
{
    gchar *out, *tmp = buf;
    guint size;
    
    if (!buf) return NULL;

    size = strlen(buf);
    
    for (; *tmp; tmp++) {
	if (*tmp == '\n') size++;
    }
    
    out = g_malloc0(size + 1);
    tmp = out;
    
    for ( ; *buf; buf++, tmp++) {
    	if (*buf == '\n') {
	    *tmp = '\r';
	    tmp++;
	}
	*tmp = *buf;
    }

    return out;
}

/* Funkcje poyczone od:
 * GQview
 * (C) 2001 John Ellis
 *
 * Author: John Ellis
 *
*/
typedef struct _WindowIconData WindowIconData;
struct _WindowIconData {
	const char **icon;
	gchar *path;
};

static void window_set_icon_cb(GtkWidget * widget, gpointer data)
{
	WindowIconData *wid = data;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GdkColormap *colormap;
	gchar *fullpath;

	colormap = gtk_widget_get_colormap(widget);
	fullpath = get_pixmap_path(wid->path);
	pixmap = gdk_pixmap_colormap_create_from_xpm(NULL, colormap, &mask,
						     NULL,
						     fullpath);
	g_free(fullpath);
	g_free(wid->path);
	g_free(wid);

	g_return_if_fail(pixmap != NULL);

	gdk_window_set_icon(widget->window, NULL, pixmap, mask);
	/* apparently, gdk_window_set_icon does not ref the pixmap and mask, so don't unref it (leak?) */
}

void
window_set_icon(GtkWidget * window, const char **icon, const gchar * file)
{
	WindowIconData *wid;

	if (!icon && !file)
		return;

	wid = g_new0(WindowIconData, 1);
	wid->icon = icon;
	wid->path = g_strdup(file);

	gtk_signal_connect(GTK_OBJECT(window), "realize",
			   GTK_SIGNAL_FUNC(window_set_icon_cb), wid);
}

gint send_sms_prog(gchar * sms_send_app, gchar * mobile, gchar * text)
{
	int pid;

	if (sms_send_app == NULL || mobile == NULL) {
		return -1;
	}
	if ((pid = fork()) == -1)
		return -1;

	if (!pid) {
#ifdef DEBUG
		g_print("send_sms_prog(): %s %s %s\n", sms_send_app,
			mobile, text);
#endif
		if (execlp(sms_send_app, sms_send_app, mobile, text, NULL)
		    == -1) {
#ifdef DEBUG
			perror("exec_sms_prog()");
#endif
			_exit(1);
		}
		_exit(1);
	}
	return pid;
}

/*
 * gg_urlencode() // funkcja wewntrzna
 *
 * zamienia podany tekst na cig znakw do formularza http. przydaje si
 * przy szukaniu userw z dziwnymi znaczkami.
 *
 *  - str - cig znakw do poprawki.
 *
 * zwraca zaalokowany bufor, ktry wypadaoby kiedy zwolni albo NULL
 * w przypadku bdu.
 */
char *gg_urlencode(char *str)
{
	char *p, *q, *buf, hex[] = "0123456789abcdef";
	int size = 0;

	if (!str)
		str = strdup("");
	
	for (p = str; *p; p++, size++) {
		if (!((*p >= 'a' && *p <= 'z') || (*p >= 'A' && *p <= 'Z') || (*p >= '0' && *p <= '9'))) {
			size += 2;
		}
	}

	if (!(buf = g_malloc0(size + 1)))
		return NULL;

	for (p = str, q = buf; *p; p++, q++) {
		if ((*p >= 'a' && *p <= 'z') || (*p >= 'A' && *p <= 'Z') || (*p >= '0' && *p <= '9')) {
			*q = *p;
		} else {
			*q++ = '%';
			*q++ = hex[*p >> 4 & 15];
			*q = hex[*p & 15];
		}
	}

	*q = 0;

	return buf;
}

/*
 *
 *    base64_*() - autorstwa brygady RR czyli EKG team'u ;-)
 *
 */ 

static char base64_charset[] =
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

/*
 * base64_encode()
 *
 * zapisuje cig znakw w base64. alokuje pami. 
 */
char *base64_encode(char *buf)
{
	char *out, *res;
	int i = 0, j = 0, k = 0, len = strlen(buf);
	
	if (!(res = out = malloc((len / 3 + 1) * 4 + 2))) {
		g_print("// base64_encode() not enough memory\n");
		return NULL;
	}
	
	while (j <= len) {
		switch (i % 4) {
			case 0:
				k = (buf[j] & 252) >> 2;
				break;
			case 1:
				k = ((buf[j] & 3) << 4) | ((buf[++j] & 240) >> 4);
				break;
			case 2:
				k = ((buf[j] & 15) << 2) | ((buf[++j] & 192) >> 6);
				break;
			case 3:
				k = buf[j++] & 63;
				break;
		}
		*out++ = base64_charset[k];
		i++;
	}

	if (i % 4)
		for (j = 0; j < 4 - (i % 4); j++, out++)
			*out = '=';
	
	*out = 0;
	
	return res;
}

/*
 * base64_decode()
 *
 * wczytuje cig znakw base64, zwraca zaalokowany buforek.
 */
char *base64_decode(char *buf)
{
	char *res, *save, *end, *foo, val;
	int index = 0;
	
	if (!(save = res = calloc(1, (strlen(buf) / 4 + 1) * 3 + 2))) {
		g_print("// base64_decode() not enough memory\n");
		return NULL;
	}

	end = buf + strlen(buf);

	while (*buf && buf < end) {
		if (*buf == '\r' || *buf == '\n') {
			buf++;
			continue;
		}
		if (!(foo = strchr(base64_charset, *buf)))
			foo = base64_charset;
		val = (int)foo - (int)base64_charset;
		*buf = 0;
		buf++;
		switch (index) {
			case 0:
				*res |= val << 2;
				break;
			case 1:
				*res++ |= val >> 4;
				*res |= val << 4;
				break;
			case 2:
				*res++ |= val >> 2;
				*res |= val << 6;
				break;
			case 3:
				*res++ |= val;
				break;
		}
		index++;
		index %= 4;
	}
	*res = 0;
	
	return save;
}
/*
    Zmienia obrazek w pixmap_widget zwalniajac poprzednia zawartosc tj.
    zmiejsza o jeden referencje do tych struktur co najczesciej powoduje
    ich zniszczenie.
*/

void change_pixmap(GtkWidget *pixmap_widget, GdkPixmap *pixmap, GdkBitmap *mask)
{
	if (pixmap_widget && pixmap && mask) {
		GdkPixmap *old_pixmap;
		GdkBitmap *old_mask;
		gtk_pixmap_get(GTK_PIXMAP(pixmap_widget), &old_pixmap, &old_mask);
		gtk_pixmap_set(GTK_PIXMAP(pixmap_widget), pixmap, mask);
		if (old_pixmap && old_mask) {
		    gdk_pixmap_unref(old_pixmap);
		    gdk_bitmap_unref(old_mask);
		}
	}
}
