/* $Id: ggcore.c,v 1.8 2003/01/25 15:46:02 thrull Exp $ */

/*
 * (C) Copyright 2001-2002 Igor Popik. Released under terms of GPL license.
 * 
 * Small parts ripped from Wojtek Kaniewski <wojtekka@irc.pl> libgg (common.c)
 *
 */
#ifndef HAVE_CONFIG_H
#include "config.h"
#endif

#include <glib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <string.h>

#include "gg-types.h"
#include "gg.h"

extern GGStatus status;
extern GGConfig config;

#define MAX_BUF 2048
inline guint fix32(guint x)
{
    return x;
#ifdef WORDS_BIGENDIAN
	return GUINT_FROM_LE(x);
#else
	return x;
#endif
}

/* oblicza hasza hasa */

/*static unsigned int
gg_hash_passwd(unsigned char *passwd, unsigned int seed)
{
	unsigned int sum = 1;
	int i, len = strlen(passwd);

	for (i = 0; i < len; i++) {
		sum = sum * (passwd[i] + 1);
	}
	return (unsigned int) sum *seed;
}
*/
#define gg_hash_passwd gg_hash
/*
 *
 * gg_hash() - nowa funkcja oliczajca nowego hasza by bart/xtreeme
 *
 */
 
unsigned int gg_hash(unsigned char *pass, unsigned int key) 
{ 
    unsigned int i,j,x = 0,y = 0,z = 0; 

    j = strlen(pass); 
    y = key; 

    for (i = 0;i < j ;i++ ) { 
        x = (x & 0xFFFFFF00) | (unsigned char)pass[i]; 
        y ^= x; 
        y += x; 
        x <<= 8; 
        y ^= x; 

        x <<= 8; 
        y -= x; 
        x <<= 8; 
        y ^= x; 

        z = y & 0x1F; 
        y = (y << z) | (y >> (32-z)); 
    } 

    return y; 
} 
/*
 * gg_http_hash()
 *
 * funkcja, ktra liczy hash dla adresu e-mail i hasa.
 *
 *  - email - adres email,
 *  - password - haso.
 *
 * zwraca hash wykorzystywany przy rejestracji i wszelkich
 * manipulacjach wasnego wpisu w katalogu publicznym.
 */


long gg_http_hash(unsigned char *email, unsigned char *password)
{
	unsigned long a, c;
	long b;
	int i;
	b = (-1);

	i = 0;
	while ((c = (long) email[i++]) != 0) {
		a = (c ^ b) + (c << 8);
		b = (a >> 24) | (a << 8);
	}

	i = 0;
	while ((c = (long) password[i++]) != 0) {
		a = (c ^ b) + (c << 8);
		b = (a >> 24) | (a << 8);
	}
	return (b < 0 ? -b : b);
}

/* odczyt polecenia z deskryptora*/
GGCmd *gg_read_cmd(int sock)
{
	GGCmd *cmd = NULL;
	gint c;
	char headbuf[8];

	if (!status.resume_cmd) {
		memset(headbuf, 0, 8);

		c = read(sock, headbuf, 8);
		g_print("gg_read_cmd(): read: %d\n", c);

		if (c == -1 || c == 0) {
			return NULL;
		}

		cmd = g_new0(GGCmd, 1);
		cmd->data = NULL;

		memcpy(&cmd->type, headbuf, 4);
		memcpy(&cmd->datalen, headbuf + 4, 4);

		cmd->type = fix32(cmd->type);
		cmd->datalen = fix32(cmd->datalen);

		if (cmd->datalen > 0) {
			g_print("gg_read_cmd(): data read: %d\n", c);
			g_print("gg_read_cmd(): cmd->type  = %d\n",
				cmd->type);
			g_print("gg_read_cmd(): cmd->datalen  = %d\n",
				cmd->datalen);
			if (cmd->datalen < 0 || cmd->datalen > MAX_BUF * 4) {
				g_free(cmd);
				return NULL;
			}
			cmd->data = (gchar *) g_malloc0(cmd->datalen);
			c = read(sock, cmd->data, cmd->datalen);
			g_print("gg_read_cmd(): data read: %d\n", c);
			if (c == -1) {
				g_free(cmd->data);
				g_free(cmd);
				return NULL;
			}
			if (c < cmd->datalen) {
				g_print
				    ("gg_read_cmd(): Hmm, dostaem mniej niz chc, zostao: %d z %d\n",
				     cmd->datalen - c, cmd->datalen);
				status.resume_cmd = (cmd->datalen - c);
				status.cmd = cmd;
				return NULL;
			}
		}
	} else {
		g_print("*** Resuming cmd ***\n");
		cmd = status.cmd;
		c = read(sock, cmd->data + (cmd->datalen - status.resume_cmd),
			 status.resume_cmd);

		if (c + (cmd->datalen - status.resume_cmd) < cmd->datalen) {
			g_print
			    ("gg_read_cmd(): Znw dostaem mniej niz chc, zostao: %d z %d\n",
			     cmd->datalen - c - status.resume_cmd,
			     cmd->datalen);
			status.resume_cmd = (cmd->datalen - c - status.resume_cmd);
			status.cmd = cmd;
			return NULL;
		} else {
			status.resume_cmd = 0;
			status.cmd = NULL;
		}
	}
	return cmd;
}

/* wysanie polecenia */
int gg_send_cmd(GGCmd * cmd, int sock)
{
	int res;
#ifdef DEBUG
	int i;
#endif
	char *buf;
	gint datalen = cmd->datalen;

	cmd->type = fix32(cmd->type);
	cmd->datalen = fix32(cmd->datalen);

	buf = g_malloc0(GG_CMD_HEADER_LEN + datalen);
	memcpy(buf, cmd, GG_CMD_HEADER_LEN);
	memcpy(buf + GG_CMD_HEADER_LEN, cmd->data, datalen);

	res = send(sock, buf, GG_CMD_HEADER_LEN + datalen, 0);
#ifdef DEBUG
	g_print("gg_send_cmd(): send: %d | ", res);
	for (i = 0; i < (cmd->datalen + 8); i++) {
		g_print("%0X ", (unsigned char) buf[i]);
	}
	g_print("\n");
#endif
	g_free(buf);
	return res;
}

/* przygotowanie i wysanie pakietu logujcego nas do gg */
void gg_login(int sock, GGCmd * servcmd, gint state, gchar *descr)
{
	GGCmd *cmd;
	GGLoginMsg *loginmsg;
	guint8 use_descr = 0;
	unsigned int seed;

	memcpy(&seed, servcmd->data, 4);

	loginmsg = g_new0(GGLoginMsg, 1);
	loginmsg->uin = fix32(config.uin);
	loginmsg->password_hash =
	    fix32(gg_hash_passwd(config.password, seed));
	loginmsg->state =
	    fix32(state | (config.private ? GG_STATUS_FRIENDS_MASK : 0x0));
	loginmsg->version = fix32(GG_VERSION);
	loginmsg->ip = 0;
	loginmsg->port = 0;

	cmd = g_new0(GGCmd, 1);
	cmd->type = GG_LOGIN_ANSWER;
	cmd->datalen = sizeof(GGLoginMsg);

	if (descr && (state == GG_STATUS_ONLINE_DESCR || 
		      state == GG_STATUS_AWAY_DESCR || 
		      state == GG_STATUS_INVISIBLE_DESCR)) {
		      use_descr = 1;
	}
	
	if (use_descr)
	    cmd->datalen += strlen(descr);

	cmd->data = g_malloc(cmd->datalen);
	memcpy(cmd->data, loginmsg, sizeof(GGLoginMsg));
	
	if (use_descr)
	    memcpy(cmd->data + sizeof(GGLoginMsg), descr, strlen(descr));

	gg_send_cmd(cmd, sock);
	
	g_free(cmd->data);
	g_free(cmd);
	g_free(loginmsg);

	status.state = state;
}

void gg_change_status(guint gg_status)
{
	GGCmd *cmd;
	guint tmp_status = 0;

#ifdef DEBUG
	g_print("gg_change_status(): zmieniam status na %d\n", gg_status);
#endif
	status.state = gg_status;

	cmd = g_new0(GGCmd, 1);
	cmd->type = GG_STATUS;
	cmd->datalen = 4;
	cmd->data = g_malloc(cmd->datalen);


	if (gg_status != GG_STATUS_OFFLINE)
	    tmp_status =
		fix32(gg_status |
		  (config.private ? GG_STATUS_FRIENDS_MASK : 0x0));
	else
	    tmp_status = fix32(gg_status);

	memcpy(cmd->data, &tmp_status, 4);

	gg_send_cmd(cmd, status.sock);

	g_free(cmd->data);
	g_free(cmd);

}

void gg_change_status_descr(guint gg_status, gchar *descr)
{
	GGCmd *cmd;
	guint tmp_status = 0;

#ifdef DEBUG
	g_print("gg_change_status_descr(): zmieniam status na %d (%s)\n", gg_status, descr);
#endif
	status.state = gg_status;

	cmd = g_new0(GGCmd, 1);
	cmd->type = GG_STATUS;
	cmd->datalen = 4 + strlen(descr);
	cmd->data = g_malloc(cmd->datalen);
	
	if (gg_status != GG_STATUS_OFFLINE_DESCR)
	    tmp_status =
		fix32(gg_status |
		  (config.private ? GG_STATUS_FRIENDS_MASK : 0x0));
	else
	    tmp_status = fix32(gg_status);
	    
	memcpy(cmd->data, &tmp_status, 4);
	memcpy(cmd->data + 4, descr, strlen(descr));
	gg_send_cmd(cmd, status.sock);

	g_free(cmd->data);
	g_free(cmd);

}
