% FUNCTION I = gf_geotrans(name)
% GeoTrans = gf_geotrans(string name)
% 
%   The name argument contains the specification of the geometric
%  transformation as a string, which may be:
% 
%   * GT_PK(n,k)
%     Transformation on simplexes, dim `n`, degree `k`.
%  * GT_QK(n,k)
%     Transformation on parallelepipeds, dim `n`, degree `k`.
%  * GT_PRISM(n,k)
%     Transformation on prisms, dim `n`, degree `k`.
%  * GT_PRODUCT(A,B)
%     Tensorial product of two transformations.
%  * GT_LINEAR_PRODUCT(A,B)
%     Linear tensorial product of two transformations
function [varargout]=gf_geotrans(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('geotrans',varargin{:});
  else
    gf_matlab('geotrans',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
