/*
    msgbox.c - Provide some simple message boxes
    Copyright (c) 1998,9  Martin Schulze <joey@infodrom.north.de>

    This file is part of the Gerstensaft package.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111, USA.
*/

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "msgbox.h"
#include "config.h"
#include "nls.h"
#include "beer.h"

void msgbox_close(GtkWidget *widget, GtkWidget* dialog)
{
  /*  gtk_widget_destroy(msgbox_window);*/
  if (dialog)
    gtk_widget_destroy(dialog);
}

void msgbox_about(GtkWidget *widget, gpointer data)
{
  GtkWidget *dialog;
  GtkWidget *hbox, *vbox;
  GtkWidget *label;
  GtkWidget *button;
  char buf[1024];
  GdkPixmap *beer_pixmap;
  GdkBitmap *beer_mask;
  GtkStyle *style;

  dialog = gtk_dialog_new();

  gtk_window_set_title (GTK_WINDOW (dialog), _("About Gerstensaft"));
  gtk_signal_connect (GTK_OBJECT (dialog), "delete_event", GTK_SIGNAL_FUNC (msgbox_close), dialog);
  gtk_signal_connect (GTK_OBJECT (dialog), "destroy", GTK_SIGNAL_FUNC (msgbox_close), dialog);

  /* Horizontal box with pix on the left, text on the right */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), hbox, TRUE, TRUE, 5);
  gtk_widget_show (hbox);
  gtk_widget_show (dialog);

  snprintf (buf, sizeof(buf), "%s/%s", PIXMAP_DIR, "gerstensaft.xpm");
  style = gtk_widget_get_style (dialog);
  beer_pixmap = gdk_pixmap_create_from_xpm (dialog->window, &beer_mask, &style->bg[GTK_STATE_NORMAL], buf);
  if (beer_pixmap != NULL) {
    label = gtk_pixmap_new (beer_pixmap, beer_mask);
    gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);
    gtk_widget_show (label);
  }

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hbox), vbox, FALSE, FALSE, 0);

  label = gtk_label_new (" ");
  gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 5);
  gtk_widget_show (label);
  label = gtk_label_new (" ");
  gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  snprintf(buf, sizeof(buf), "Gerstensaft %s", version);
  label = gtk_label_new (buf);
  gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  label = gtk_label_new (_("  Graphical frontend to SAFT  "));
  gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  label = gtk_label_new ("  Martin Schulze <joey@infodrom.north.de>  ");
  gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  label = gtk_label_new ("http://www.infodrom.north.de/gerstensaft/");
  gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 5);
  gtk_widget_show (label);
  gtk_widget_show (vbox);

  button = gtk_button_new_with_label (_(" Close "));
  gtk_signal_connect (GTK_OBJECT(button),"clicked", GTK_SIGNAL_FUNC(msgbox_close),dialog);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialog)->action_area), button, TRUE, FALSE, 0);
  gtk_widget_show (button);
  gtk_widget_grab_default (button);
}

void msgbox_todo (GtkWidget *widget, gpointer data)
{
  GtkWidget *dialog;
  GtkWidget *box;
  GtkWidget *label;
  GtkWidget *button;
  char buf[1024];
  GdkPixmap *beer_pixmap;
  GdkBitmap *beer_mask;
  GtkStyle *style;

  dialog = gtk_dialog_new();

  gtk_window_set_title (GTK_WINDOW (dialog), _("Gerstensaft Todo"));
  gtk_signal_connect (GTK_OBJECT (dialog), "delete_event", GTK_SIGNAL_FUNC (msgbox_close), dialog);
  gtk_signal_connect (GTK_OBJECT (dialog), "destroy", GTK_SIGNAL_FUNC (msgbox_close), dialog);

  box = gtk_vbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), box, TRUE, TRUE, 5);
  gtk_widget_show (box);
  gtk_widget_show (dialog);

  snprintf(buf, sizeof(buf), "Gerstensaft %s", version);
  label = gtk_label_new (buf);
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  snprintf (buf, sizeof(buf), "%s/%s", PIXMAP_WM_DIR, "beer.xpm");
  style = gtk_widget_get_style (dialog);
  beer_pixmap = gdk_pixmap_create_from_xpm (dialog->window, &beer_mask, &style->bg[GTK_STATE_NORMAL], buf);

  if (beer_pixmap != NULL) {
    label = gtk_pixmap_new (beer_pixmap, beer_mask);
    gtk_box_pack_start (GTK_BOX(box), label, FALSE, FALSE, 0);
    gtk_widget_show (label);
  }

  label = gtk_label_new (_("  Things to do for Gerstensaft  "));
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  label = gtk_label_new (_("  Receive module  "));
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  label = gtk_label_new (_("  Select/Unselect via pattern  "));
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  label = gtk_label_new (_("  Possibility to add comments  "));
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  label = gtk_label_new (_("  Option to use an archive instead of files  "));
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  label = gtk_label_new (_("  Gnomification / Support for drag and drop  "));
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  button = gtk_button_new_with_label (_(" Close "));
  gtk_signal_connect (GTK_OBJECT(button),"clicked", GTK_SIGNAL_FUNC(msgbox_close),dialog);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialog)->action_area), button, TRUE, FALSE, 0);
  gtk_widget_show (button);
  gtk_widget_grab_default (button);
}

void msgbox (const char *title, const char *text)
{
  GtkWidget *dialog;
  GtkWidget *box;
  GtkWidget *label;
  GtkWidget *button;

  if (!title || !strlen(title) || !text || !strlen(text))
    return;

  dialog = gtk_dialog_new();
  gtk_grab_add (dialog);
  gtk_window_set_title(GTK_WINDOW (dialog), title);
  /*
  gtk_widget_set_usize (GTK_WIDGET (dialog), 250, 100);
  */
  gtk_signal_connect (GTK_OBJECT (dialog), "delete_event", GTK_SIGNAL_FUNC (msgbox_close), dialog);
  gtk_signal_connect (GTK_OBJECT (dialog), "destroy", GTK_SIGNAL_FUNC (msgbox_close), dialog);

  box = gtk_vbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), box, TRUE, TRUE, 5);
  gtk_widget_show (box);

  /*
  if (strlen(text) < 40) {
    memset(mytext, 0, sizeof(mytext));
    memset(mytext, ' ', (50-strlen(text))/2);
    strcat(mytext, text);
    memset(mytext+strlen(mytext), ' ', ((50-strlen(text))/2)-1);
    label = gtk_label_new (mytext);
  } else
  */
  printf ("text=%s\n", text);
  label = gtk_label_new (text);
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
  gtk_widget_show (label);

  button = gtk_button_new_with_label (_(" Close "));
  gtk_signal_connect (GTK_OBJECT(button),"clicked",
		      GTK_SIGNAL_FUNC(msgbox_close),dialog);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialog)->action_area), 
		      button, TRUE, FALSE, 0);
  gtk_widget_show (button);
  gtk_widget_grab_default (button);

  gtk_widget_show (dialog);
}
