/* Gerris - The GNU Flow Solver
 * Copyright (C) 2001 National Institute of Water and Atmospheric Research
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.  
 */

#ifndef __SOURCE_H__
#define __SOURCE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "event.h"

gdouble    gfs_variable_source        (GfsVariable * v, 
				       FttCell * cell);
void       gfs_variable_sources       (GfsDomain * domain, 
				       GfsVariable * v,
				       GfsAdvectionParams * par);
void       gfs_velocity_sources       (GfsDomain * domain, 
				       GfsAdvectionParams * par);

/* GfsSource: Header */

typedef struct _GfsSource         GfsSource;

struct _GfsSource {
  /*< private >*/
  GfsEvent parent;

  /*< public >*/
  GfsVariable * v;
};

typedef struct _GfsSourceClass    GfsSourceClass;

struct _GfsSourceClass {
  /*< private >*/
  GfsEventClass parent_class;

  /*< public >*/
  gdouble (* value) (GfsSource *, FttCell *);
};

#define GFS_SOURCE(obj)            GTS_OBJECT_CAST (obj,\
					         GfsSource,\
					         gfs_source_class ())
#define GFS_SOURCE_CLASS(klass)    GTS_OBJECT_CLASS_CAST (klass,\
						 GfsSourceClass,\
						 gfs_source_class())
#define GFS_IS_SOURCE(obj)         (gts_object_is_from_class (obj,\
						 gfs_source_class ()))

GfsSourceClass * gfs_source_class  (void);

/* GfsSourceConstant: Header */

typedef struct _GfsSourceConstant         GfsSourceConstant;

struct _GfsSourceConstant {
  /*< private >*/
  GfsSource parent;

  /*< public >*/
  gdouble intensity;
};

#define GFS_SOURCE_CONSTANT(obj)            GTS_OBJECT_CAST (obj,\
					         GfsSourceConstant,\
					         gfs_source_constant_class ())
#define GFS_IS_SOURCE_CONSTANT(obj)         (gts_object_is_from_class (obj,\
						 gfs_source_constant_class ()))

GfsSourceClass * gfs_source_constant_class  (void);

/* GfsSourceGaussian: Header */

typedef struct _GfsSourceGaussian         GfsSourceGaussian;

struct _GfsSourceGaussian {
  /*< private >*/
  GfsSourceConstant parent;

  /*< public >*/
  FttVector p;
  gdouble r;
};

#define GFS_SOURCE_GAUSSIAN(obj)            GTS_OBJECT_CAST (obj,\
					         GfsSourceGaussian,\
					         gfs_source_gaussian_class ())
#define GFS_IS_SOURCE_GAUSSIAN(obj)         (gts_object_is_from_class (obj,\
						 gfs_source_gaussian_class ()))

GfsSourceClass * gfs_source_gaussian_class  (void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SOURCE_H__ */
