/*
 * Decompiled with CFR 0.152.
 */
package geotrans.gui;

import geotrans.gui.FillList;
import geotrans.jni.GeotransError;
import geotrans.jni.JNIEngine;
import geotrans.jni.JNIException;
import geotrans.jni.JNIStrtoval;
import geotrans.utility.Platform;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class _3ParamDatumPanel
extends JPanel {
    private JPanel createDatumPanel;
    private JLabel datumCodeLabel;
    private JTextField datumCodeTextField;
    private JLabel datumNameLabel;
    private JTextField datumNameTextField;
    private JPanel datumPanel;
    private JLabel datumShiftLabel;
    private JPanel deltaPanel;
    private JLabel deltaXLabel;
    private JTextField deltaXTextField;
    private JLabel deltaYLabel;
    private JTextField deltaYTextField;
    private JLabel deltaZLabel;
    private JTextField deltaZTextField;
    private JPanel domainAPanel;
    private JPanel domainBPanel;
    private JLabel eastLonLabel;
    private JTextField eastLonTextField;
    private JComboBox ellipsoidComboBox;
    private JLabel ellipsoidLabel;
    private JLabel northLatLabel;
    private JTextField northLatTextField;
    private JPanel selectEllipsoidPanel;
    private JLabel sigmaXLabel;
    private JTextField sigmaXTextField;
    private JLabel sigmaYLabel;
    private JTextField sigmaYTextField;
    private JLabel sigmaZLabel;
    private JTextField sigmaZTextField;
    private JLabel southLatLabel;
    private JTextField southLatTextField;
    private JPanel stdErrPanel;
    private JLabel validDomainLabel;
    private JLabel westLonLabel;
    private JTextField westLonTextField;

    public _3ParamDatumPanel() {
        this.initComponents();
        new FillList(this.ellipsoidComboBox, 1);
        if (Platform.isUnix) {
            this.datumCodeLabel.setFont(new Font("Dialog", 1, 10));
            this.datumNameLabel.setFont(new Font("Dialog", 1, 10));
            this.ellipsoidLabel.setFont(new Font("Dialog", 1, 10));
            this.datumShiftLabel.setFont(new Font("Dialog", 1, 10));
            this.deltaXLabel.setFont(new Font("Dialog", 1, 10));
            this.deltaYLabel.setFont(new Font("Dialog", 1, 10));
            this.deltaZLabel.setFont(new Font("Dialog", 1, 10));
            this.sigmaXLabel.setFont(new Font("Dialog", 1, 10));
            this.sigmaYLabel.setFont(new Font("Dialog", 1, 10));
            this.sigmaZLabel.setFont(new Font("Dialog", 1, 10));
            this.validDomainLabel.setFont(new Font("Dialog", 1, 10));
            this.northLatLabel.setFont(new Font("Dialog", 1, 10));
            this.westLonLabel.setFont(new Font("Dialog", 1, 10));
            this.eastLonLabel.setFont(new Font("Dialog", 1, 10));
            this.southLatLabel.setFont(new Font("Dialog", 1, 10));
            this.ellipsoidComboBox.setFont(new Font("Dialog", 1, 10));
        }
    }

    private void initComponents() {
        this.createDatumPanel = new JPanel();
        this.datumPanel = new JPanel();
        this.datumCodeLabel = new JLabel();
        this.datumNameLabel = new JLabel();
        this.datumCodeTextField = new JTextField();
        this.datumNameTextField = new JTextField();
        this.selectEllipsoidPanel = new JPanel();
        this.ellipsoidLabel = new JLabel();
        this.ellipsoidComboBox = new JComboBox();
        this.datumShiftLabel = new JLabel();
        this.deltaPanel = new JPanel();
        this.deltaXLabel = new JLabel();
        this.deltaYLabel = new JLabel();
        this.deltaZLabel = new JLabel();
        this.deltaXTextField = new JTextField();
        this.deltaYTextField = new JTextField();
        this.deltaZTextField = new JTextField();
        this.stdErrPanel = new JPanel();
        this.sigmaXLabel = new JLabel();
        this.sigmaYLabel = new JLabel();
        this.sigmaZLabel = new JLabel();
        this.sigmaXTextField = new JTextField();
        this.sigmaYTextField = new JTextField();
        this.sigmaZTextField = new JTextField();
        this.validDomainLabel = new JLabel();
        this.domainAPanel = new JPanel();
        this.northLatLabel = new JLabel();
        this.westLonLabel = new JLabel();
        this.northLatTextField = new JTextField();
        this.eastLonLabel = new JLabel();
        this.domainBPanel = new JPanel();
        this.westLonTextField = new JTextField();
        this.southLatLabel = new JLabel();
        this.eastLonTextField = new JTextField();
        this.southLatTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.createDatumPanel.setLayout(new GridBagLayout());
        this.createDatumPanel.setBorder(BorderFactory.createEmptyBorder(0, 18, 0, 18));
        this.createDatumPanel.setMaximumSize(new Dimension(430, 500));
        this.createDatumPanel.setMinimumSize(new Dimension(430, 200));
        this.datumPanel.setLayout(new GridBagLayout());
        this.datumCodeLabel.setHorizontalAlignment(2);
        this.datumCodeLabel.setText("Code:");
        this.datumCodeLabel.setVerticalAlignment(3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        this.datumPanel.add((Component)this.datumCodeLabel, gridBagConstraints);
        this.datumNameLabel.setHorizontalAlignment(2);
        this.datumNameLabel.setText("Name:");
        this.datumNameLabel.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.datumPanel.add((Component)this.datumNameLabel, gridBagConstraints);
        this.datumCodeTextField.setText("WGE");
        this.datumCodeTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.datumCodeTextField.setMinimumSize(new Dimension(179, 19));
        this.datumCodeTextField.setPreferredSize(new Dimension(179, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        this.datumPanel.add((Component)this.datumCodeTextField, gridBagConstraints);
        this.datumNameTextField.setText("World Geodetic System  1984");
        this.datumNameTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.datumNameTextField.setMinimumSize(new Dimension(179, 19));
        this.datumNameTextField.setPreferredSize(new Dimension(179, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.datumPanel.add((Component)this.datumNameTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.createDatumPanel.add((Component)this.datumPanel, gridBagConstraints);
        this.selectEllipsoidPanel.setLayout(new GridBagLayout());
        this.ellipsoidLabel.setHorizontalAlignment(2);
        this.ellipsoidLabel.setText("Ellipsoid:");
        this.ellipsoidLabel.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.selectEllipsoidPanel.add((Component)this.ellipsoidLabel, gridBagConstraints);
        this.ellipsoidComboBox.setMaximumSize(new Dimension(400, 25));
        this.ellipsoidComboBox.setMinimumSize(new Dimension(126, 8));
        this.ellipsoidComboBox.setPreferredSize(new Dimension(250, 22));
        this.ellipsoidComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                _3ParamDatumPanel.this.ellipsoidComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.selectEllipsoidPanel.add((Component)this.ellipsoidComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.createDatumPanel.add((Component)this.selectEllipsoidPanel, gridBagConstraints);
        this.datumShiftLabel.setHorizontalAlignment(0);
        this.datumShiftLabel.setText("Datum Shift to WGS84");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.createDatumPanel.add((Component)this.datumShiftLabel, gridBagConstraints);
        this.deltaPanel.setLayout(new GridBagLayout());
        this.deltaPanel.setPreferredSize(new Dimension(220, 68));
        this.deltaXLabel.setHorizontalAlignment(2);
        this.deltaXLabel.setText("Delta X (m):");
        this.deltaXLabel.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.deltaPanel.add((Component)this.deltaXLabel, gridBagConstraints);
        this.deltaYLabel.setHorizontalAlignment(2);
        this.deltaYLabel.setText(" Delta Y (m):");
        this.deltaYLabel.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.deltaPanel.add((Component)this.deltaYLabel, gridBagConstraints);
        this.deltaZLabel.setHorizontalAlignment(2);
        this.deltaZLabel.setText("Delta Z (m):");
        this.deltaZLabel.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.deltaPanel.add((Component)this.deltaZLabel, gridBagConstraints);
        this.deltaXTextField.setText("0");
        this.deltaXTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.deltaXTextField.setMinimumSize(new Dimension(115, 19));
        this.deltaXTextField.setPreferredSize(new Dimension(115, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.deltaPanel.add((Component)this.deltaXTextField, gridBagConstraints);
        this.deltaYTextField.setText("0");
        this.deltaYTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.deltaYTextField.setMinimumSize(new Dimension(115, 19));
        this.deltaYTextField.setPreferredSize(new Dimension(115, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.deltaPanel.add((Component)this.deltaYTextField, gridBagConstraints);
        this.deltaZTextField.setText("0");
        this.deltaZTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.deltaZTextField.setMinimumSize(new Dimension(115, 19));
        this.deltaZTextField.setPreferredSize(new Dimension(115, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.deltaPanel.add((Component)this.deltaZTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.createDatumPanel.add((Component)this.deltaPanel, gridBagConstraints);
        this.stdErrPanel.setLayout(new GridBagLayout());
        this.sigmaXLabel.setHorizontalAlignment(2);
        this.sigmaXLabel.setText("Std. Err in X (m):");
        this.sigmaXLabel.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.stdErrPanel.add((Component)this.sigmaXLabel, gridBagConstraints);
        this.sigmaYLabel.setHorizontalAlignment(2);
        this.sigmaYLabel.setText("Std. Err in Y (m):");
        this.sigmaYLabel.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.stdErrPanel.add((Component)this.sigmaYLabel, gridBagConstraints);
        this.sigmaZLabel.setHorizontalAlignment(2);
        this.sigmaZLabel.setText("Std. Err in Z (m):");
        this.sigmaZLabel.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.stdErrPanel.add((Component)this.sigmaZLabel, gridBagConstraints);
        this.sigmaXTextField.setText("-1");
        this.sigmaXTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.sigmaXTextField.setMinimumSize(new Dimension(115, 19));
        this.sigmaXTextField.setPreferredSize(new Dimension(115, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.stdErrPanel.add((Component)this.sigmaXTextField, gridBagConstraints);
        this.sigmaYTextField.setText("-1");
        this.sigmaYTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.sigmaYTextField.setMinimumSize(new Dimension(115, 19));
        this.sigmaYTextField.setPreferredSize(new Dimension(115, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.stdErrPanel.add((Component)this.sigmaYTextField, gridBagConstraints);
        this.sigmaZTextField.setText("-1");
        this.sigmaZTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.sigmaZTextField.setMinimumSize(new Dimension(115, 19));
        this.sigmaZTextField.setPreferredSize(new Dimension(115, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.stdErrPanel.add((Component)this.sigmaZTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        this.createDatumPanel.add((Component)this.stdErrPanel, gridBagConstraints);
        this.validDomainLabel.setHorizontalAlignment(0);
        this.validDomainLabel.setText("Valid Domain");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.createDatumPanel.add((Component)this.validDomainLabel, gridBagConstraints);
        this.domainAPanel.setLayout(new GridBagLayout());
        this.northLatLabel.setHorizontalAlignment(2);
        this.northLatLabel.setText("Northern Latitude:");
        this.northLatLabel.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.domainAPanel.add((Component)this.northLatLabel, gridBagConstraints);
        this.westLonLabel.setHorizontalAlignment(2);
        this.westLonLabel.setText("Western Longitude:");
        this.westLonLabel.setVerticalAlignment(3);
        this.westLonLabel.setMaximumSize(new Dimension(115, 15));
        this.westLonLabel.setMinimumSize(new Dimension(115, 15));
        this.westLonLabel.setOpaque(true);
        this.westLonLabel.setPreferredSize(new Dimension(115, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.domainAPanel.add((Component)this.westLonLabel, gridBagConstraints);
        this.northLatTextField.setText("90 00 00.0N");
        this.northLatTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.northLatTextField.setMinimumSize(new Dimension(115, 19));
        this.northLatTextField.setPreferredSize(new Dimension(115, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.domainAPanel.add((Component)this.northLatTextField, gridBagConstraints);
        this.eastLonLabel.setHorizontalAlignment(2);
        this.eastLonLabel.setText("Eastern Longitude:");
        this.eastLonLabel.setVerticalAlignment(3);
        this.eastLonLabel.setMaximumSize(new Dimension(115, 15));
        this.eastLonLabel.setMinimumSize(new Dimension(115, 15));
        this.eastLonLabel.setPreferredSize(new Dimension(115, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.domainAPanel.add((Component)this.eastLonLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.createDatumPanel.add((Component)this.domainAPanel, gridBagConstraints);
        this.domainBPanel.setLayout(new GridBagLayout());
        this.westLonTextField.setText("180 00 00.0W");
        this.westLonTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.westLonTextField.setMinimumSize(new Dimension(115, 19));
        this.westLonTextField.setPreferredSize(new Dimension(115, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.domainBPanel.add((Component)this.westLonTextField, gridBagConstraints);
        this.southLatLabel.setHorizontalAlignment(2);
        this.southLatLabel.setText("Southern Latitude:");
        this.southLatLabel.setVerticalAlignment(3);
        this.southLatLabel.setMaximumSize(new Dimension(115, 15));
        this.southLatLabel.setMinimumSize(new Dimension(115, 15));
        this.southLatLabel.setPreferredSize(new Dimension(115, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.domainBPanel.add((Component)this.southLatLabel, gridBagConstraints);
        this.eastLonTextField.setText("180 00 00.0E");
        this.eastLonTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.eastLonTextField.setMinimumSize(new Dimension(115, 19));
        this.eastLonTextField.setPreferredSize(new Dimension(115, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.domainBPanel.add((Component)this.eastLonTextField, gridBagConstraints);
        this.southLatTextField.setText("90 00 00.0S");
        this.southLatTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.southLatTextField.setMinimumSize(new Dimension(115, 19));
        this.southLatTextField.setPreferredSize(new Dimension(115, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.domainBPanel.add((Component)this.southLatTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        this.createDatumPanel.add((Component)this.domainBPanel, gridBagConstraints);
        this.add((Component)this.createDatumPanel, new GridBagConstraints());
    }

    private void ellipsoidComboBoxActionPerformed(ActionEvent evt) {
        this.ellipsoidComboBox.getSelectedIndex();
    }

    public boolean createDatum() {
        JNIEngine jniEngine = new JNIEngine();
        JNIStrtoval jniStrtoval = new JNIStrtoval();
        double deltaX = jniStrtoval.stringToDouble(this.deltaXTextField.getText().trim(), "Invalid Delta X");
        double deltaY = jniStrtoval.stringToDouble(this.deltaYTextField.getText().trim(), "Invalid Delta Y");
        double deltaZ = jniStrtoval.stringToDouble(this.deltaZTextField.getText().trim(), "Invalid Delta Z");
        double sigmaX = jniStrtoval.stringToDouble(this.sigmaXTextField.getText().trim(), "Invalid Std. Error in X");
        double sigmaY = jniStrtoval.stringToDouble(this.sigmaYTextField.getText().trim(), "Invalid Std. Error in Y");
        double sigmaZ = jniStrtoval.stringToDouble(this.sigmaZTextField.getText().trim(), "Invalid Std. Error in Z");
        double southLat = jniStrtoval.stringToLatitude(this.southLatTextField.getText().trim(), "Invalid Southern Latitude");
        double northLat = jniStrtoval.stringToLatitude(this.northLatTextField.getText().trim(), "Invalid Northern Latitude");
        double westLon = jniStrtoval.stringToLongitude(this.westLonTextField.getText().trim(), "Invalid Western Longitude");
        double eastLon = jniStrtoval.stringToLongitude(this.eastLonTextField.getText().trim(), "Invalid Eastern Longitude");
        if (jniStrtoval.getEngineError() || jniStrtoval.getJNIError()) {
            jniStrtoval.displayErrorMsg(this);
        } else {
            try {
                jniEngine.JNIDefine3ParamDatum(this.datumCodeTextField.getText().trim(), this.datumNameTextField.getText().trim(), jniEngine.JNIGetEllipsoidCode(this.ellipsoidComboBox.getSelectedIndex() + 1), deltaX, deltaY, deltaZ, sigmaX, sigmaY, sigmaZ, southLat, northLat, westLon, eastLon);
                return true;
            }
            catch (GeotransError e) {
                jniStrtoval.displayErrorMsg(this, e.getMessage());
            }
            catch (JNIException e) {
                jniStrtoval.displayErrorMsg(this, e.getMessage());
            }
        }
        return false;
    }
}

