/*
 * Decompiled with CFR 0.152.
 */
package geotrans.gui;

import geotrans.gui.Geotrans;
import geotrans.gui.MasterPanel;
import geotrans.gui.jOptions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;

public class SaveAsDefault {
    private Geotrans parent;
    private File file;
    private MasterPanel upperMasterPanel;
    private MasterPanel lowerMasterPanel;
    private FileWriter defaultFile;
    private int projectionType = 0;
    private jOptions joptions;

    public SaveAsDefault(Geotrans _parent, File _file, MasterPanel _upperMasterPanel, MasterPanel _lowerMasterPanel, jOptions _joptions) {
        this.parent = _parent;
        this.file = _file;
        this.upperMasterPanel = _upperMasterPanel;
        this.lowerMasterPanel = _lowerMasterPanel;
        this.joptions = _joptions;
        this.writeDefaults();
    }

    private void writeDefaults() {
        try {
            this.defaultFile = new FileWriter(this.file);
            String contents = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n";
            contents = contents + "<defaults>\r\n";
            this.defaultFile.write(contents, 0, contents.length());
            this.writeOptions();
            contents = "  <source>\r\n";
            contents = contents + "    <datum>\r\n";
            contents = contents + "      <index>" + (this.upperMasterPanel.getDatumIndex() - 1) + "</index>\r\n";
            contents = contents + "      <code>" + this.upperMasterPanel.getDatumCode() + "</code>\r\n";
            contents = contents + "    </datum>\r\n";
            contents = contents + "    <projection>\r\n";
            this.projectionType = this.upperMasterPanel.getProjectionType();
            contents = contents + "      <index>" + this.projectionType + "</index>\r\n";
            contents = contents + "      <code>" + this.upperMasterPanel.getProjectionCode() + "</code>\r\n";
            contents = contents + "    </projection>\r\n";
            this.defaultFile.write(contents, 0, contents.length());
            this.writeParameters(this.upperMasterPanel);
            contents = "  </source>\r\n";
            contents = contents + "  <target>\r\n";
            contents = contents + "    <datum>\r\n";
            contents = contents + "      <index>" + (this.lowerMasterPanel.getDatumIndex() - 1) + "</index>\r\n";
            contents = contents + "      <code>" + this.lowerMasterPanel.getDatumCode() + "</code>\r\n";
            contents = contents + "    </datum>\r\n";
            contents = contents + "    <projection>\r\n";
            this.projectionType = this.lowerMasterPanel.getProjectionType();
            contents = contents + "      <index>" + this.projectionType + "</index>\r\n";
            contents = contents + "      <code>" + this.lowerMasterPanel.getProjectionCode() + "</code>\r\n";
            contents = contents + "    </projection>\r\n";
            this.defaultFile.write(contents, 0, contents.length());
            this.writeParameters(this.lowerMasterPanel);
            contents = "  </target>\r\n";
            contents = contents + "</defaults>\r\n";
            this.defaultFile.write(contents, 0, contents.length());
            this.defaultFile.flush();
            this.defaultFile.close();
            JOptionPane.showMessageDialog(this.parent, "Defaults saved: " + this.file, "Save", 1);
        }
        catch (IOException ioex) {
            JOptionPane.showMessageDialog(this.parent, "Error Saving File: " + this.file, "Error", 0);
        }
    }

    private void writeParameters(MasterPanel masterPanel) {
        try {
            String contents = "    <parameters>\r\n";
            switch (this.projectionType) {
                case 15: 
                case 16: 
                case 22: 
                case 23: 
                case 30: 
                case 34: {
                    contents = contents + "      <centralMeridian>" + masterPanel.get3ParamCentralMeridian() + "</centralMeridian>\r\n";
                    contents = contents + "      <falseEasting>" + masterPanel.getFalseEasting() + "</falseEasting>\r\n";
                    contents = contents + "      <falseNorthing>" + masterPanel.getFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 18: 
                case 27: 
                case 29: 
                case 31: {
                    contents = contents + "      <centralMeridian>" + masterPanel.get4ParamCentralMeridian() + "</centralMeridian>\r\n";
                    contents = contents + "      <originLatitude>" + masterPanel.get4ParamOriginLatitude() + "</originLatitude>\r\n";
                    contents = contents + "      <falseEasting>" + masterPanel.getFalseEasting() + "</falseEasting>\r\n";
                    contents = contents + "      <falseNorthing>" + masterPanel.getFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 17: {
                    contents = contents + "      <centralMeridian>" + masterPanel.get4ParamCentralMeridian() + "</centralMeridian>\r\n";
                    contents = contents + "      <standardParallel>" + masterPanel.get4ParamOriginLatitude() + "</standardParallel>\r\n";
                    contents = contents + "      <falseEasting>" + masterPanel.getFalseEasting() + "</falseEasting>\r\n";
                    contents = contents + "      <falseNorthing>" + masterPanel.getFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 19: 
                case 32: 
                case 33: {
                    contents = contents + "      <centralMeridian>" + masterPanel.get5ParamCentralMeridian() + "</centralMeridian>\r\n";
                    contents = contents + "      <originLatitude>" + masterPanel.get5ParamOriginLatitude() + "</originLatitude>\r\n";
                    contents = contents + "      <scaleFactor>" + masterPanel.get5ParamScaleFactor() + "</scaleFactor>\r\n";
                    contents = contents + "      <falseEasting>" + masterPanel.getFalseEasting() + "</falseEasting>\r\n";
                    contents = contents + "      <falseNorthing>" + masterPanel.getFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 21: {
                    contents = contents + "      <centralMeridian>" + masterPanel.get5ParamCentralMeridian() + "</centralMeridian>\r\n";
                    contents = contents + "      <latitudeOfTrueScale>" + masterPanel.get5ParamOriginLatitude() + "</latitudeOfTrueScale>\r\n";
                    contents = contents + "      <scaleFactor>" + masterPanel.get5ParamScaleFactor() + "</scaleFactor>\r\n";
                    contents = contents + "      <falseEasting>" + masterPanel.getFalseEasting() + "</falseEasting>\r\n";
                    contents = contents + "      <falseNorthing>" + masterPanel.getFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 9: 
                case 20: {
                    contents = contents + "      <centralMeridian>" + masterPanel.get6ParamCentralMeridian() + "</centralMeridian>\r\n";
                    contents = contents + "      <originLatitude>" + masterPanel.get6ParamOriginLatitude() + "</originLatitude>\r\n";
                    contents = contents + "      <standardParallel1>" + masterPanel.get6ParamStandardParallel1() + "</standardParallel1>\r\n";
                    contents = contents + "      <standardParallel2>" + masterPanel.get6ParamStandardParallel2() + "</standardParallel2>\r\n";
                    contents = contents + "      <falseEasting>" + masterPanel.getFalseEasting() + "</falseEasting>\r\n";
                    contents = contents + "      <falseNorthing>" + masterPanel.getFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 0: {
                    contents = contents + "      <heightType>" + masterPanel.getGeodeticHeight() + "</heightType>\r\n";
                    break;
                }
                case 4: {
                    contents = contents + "      <originLongitude>" + masterPanel.getOriginLongitude() + "</originLongitude>\r\n";
                    contents = contents + "      <originLatitude>" + masterPanel.getOriginLatitude() + "</originLatitude>\r\n";
                    contents = contents + "      <originHeight>" + masterPanel.getOriginHeight() + "</originHeight>\r\n";
                    contents = contents + "      <orientation>" + masterPanel.getOrientation() + "</orientation>\r\n";
                    break;
                }
                case 24: {
                    contents = contents + "      <centralMeridian>" + masterPanel.getNeysCentralMeridian() + "</centralMeridian>\r\n";
                    contents = contents + "      <originLatitude>" + masterPanel.getNeysOriginLatitude() + "</originLatitude>\r\n";
                    contents = contents + "      <standardParallel1>" + masterPanel.getNeysStandardParallel1() + "</standardParallel1>\r\n";
                    contents = contents + "      <falseEasting>" + masterPanel.getFalseEasting() + "</falseEasting>\r\n";
                    contents = contents + "      <falseNorthing>" + masterPanel.getFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 26: {
                    contents = contents + "      <originLatitude>" + masterPanel.getOmercOriginLatitude() + "</originLatitude>\r\n";
                    contents = contents + "      <scaleFactor>" + masterPanel.getOmercScaleFactor() + "</scaleFactor>\r\n";
                    contents = contents + "      <longitude1>" + masterPanel.getOmercLongitude1() + "</longitude1>\r\n";
                    contents = contents + "      <latitude1>" + masterPanel.getOmercLatitude1() + "</latitude1>\r\n";
                    contents = contents + "      <longitude2>" + masterPanel.getOmercLongitude2() + "</longitude2>\r\n";
                    contents = contents + "      <latitude2>" + masterPanel.getOmercLatitude2() + "</latitude2>\r\n";
                    contents = contents + "      <falseEasting>" + masterPanel.getOmercFalseEasting() + "</falseEasting>\r\n";
                    contents = contents + "      <falseNorthing>" + masterPanel.getOmercFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 28: {
                    contents = contents + "      <longitudeDownFromPole>" + masterPanel.get4ParamCentralMeridian() + "</longitudeDownFromPole>\r\n";
                    contents = contents + "      <latitudeOfTrueScale>" + masterPanel.get4ParamOriginLatitude() + "</latitudeOfTrueScale>\r\n";
                    contents = contents + "      <falseEasting>" + masterPanel.getFalseEasting() + "</falseEasting>\r\n";
                    contents = contents + "      <falseNorthing>" + masterPanel.getFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 7: {
                    contents = contents + "      <override>" + masterPanel.getOverride() + "</override>\r\n";
                    contents = contents + "      <zone>" + masterPanel.getZone() + "</zone>\r\n";
                }
            }
            contents = contents + "    </parameters>\r\n";
            this.defaultFile.write(contents, 0, contents.length());
        }
        catch (IOException ioex) {
            JOptionPane.showMessageDialog(this.parent, "Error Saving File: " + this.file, "Error", 0);
        }
    }

    void writeOptions() {
        try {
            String contents = "  <options>\r\n";
            contents = contents + "    <units>\r\n";
            contents = contents + "      <index>" + this.joptions.getUnits() + "</index>\r\n";
            contents = contents + "      <value>" + this.joptions.getUnitsString() + "</value>\r\n";
            contents = contents + "    </units>\r\n";
            contents = contents + "    <separator>\r\n";
            contents = contents + "      <index>" + this.joptions.getSeparatorIndex() + "</index>\r\n";
            contents = contents + "      <value>" + this.joptions.getSeparator() + "</value>\r\n";
            contents = contents + "    </separator>\r\n";
            contents = contents + "    <signHemisphere>\r\n";
            contents = contents + "      <index>" + this.joptions.getSignHemi() + "</index>\r\n";
            contents = contents + "      <value>" + this.joptions.getSignHemiString() + "</value>\r\n";
            contents = contents + "    </signHemisphere>\r\n";
            contents = contents + "    <longitudeRange>\r\n";
            contents = contents + "      <index>" + this.joptions.getRange() + "</index>\r\n";
            contents = contents + "      <value>" + this.joptions.getRangeString() + "</value>\r\n";
            contents = contents + "    </longitudeRange>\r\n";
            contents = contents + "    <precision>\r\n";
            contents = contents + "      <index>" + this.joptions.getPrecision() + "</index>\r\n";
            contents = contents + "      <value>" + this.joptions.getPrecisionString() + "</value>\r\n";
            contents = contents + "    </precision>\r\n";
            contents = contents + "    <leadingZeros>\r\n";
            contents = contents + "      <value>" + this.joptions.getLeadingZeros() + "</value>\r\n";
            contents = contents + "    </leadingZeros>\r\n";
            contents = contents + "  </options>\r\n";
            this.defaultFile.write(contents, 0, contents.length());
        }
        catch (IOException ioex) {
            JOptionPane.showMessageDialog(this.parent, "Error Saving File: " + this.file, "Error", 0);
        }
    }
}

